/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.job.utils.EbiddingJobUtil;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingHeadServiceImpl;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingItemServiceImpl;
import com.els.modules.ebidding.service.impl.SaleEbiddingHeadServiceImpl;
import com.els.modules.ebidding.service.impl.SaleEbiddingItemServiceImpl;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="srmEbiddingFailedJobServiceImpl")
public class SrmEbiddingFailedJobBeanServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(SrmEbiddingFailedJobBeanServiceImpl.class);

    @Async
    public void execute(String parameter) {
        log.info(" \u7ade\u4ef7\u6d41\u6807\u5b9a\u65f6\u4efb\u52a1 SrmEbiddingFailedJob \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        if (StrUtil.isEmpty((CharSequence)id)) {
            log.error("parameter must contain id.");
            return;
        }
        String tenantId = paramObj.getString("tenantId");
        if (StrUtil.isBlank((CharSequence)tenantId)) {
            tenantId = "100000";
        }
        TenantContext.setTenant((String)tenantId);
        PurchaseEbiddingHeadService purchaseEbiddingHeadService = (PurchaseEbiddingHeadService)SpringContextUtils.getBean(PurchaseEbiddingHeadServiceImpl.class);
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)purchaseEbiddingHeadService.getById((Serializable)((Object)id));
        if (dbHead.getReplyQuantity() == null || dbHead.getReplyQuantity() < dbHead.getParticipateQuantity()) {
            String status = EbiddingStatusEnum.BID_FAILED.getValue();
            dbHead.setEbiddingStatus(status);
            purchaseEbiddingHeadService.updateById((Object)dbHead);
            PurchaseEbiddingItemService purchaseEbiddingItemService = (PurchaseEbiddingItemService)SpringContextUtils.getBean(PurchaseEbiddingItemServiceImpl.class);
            purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)id)).set(PurchaseEbiddingItem::getItemStatus, (Object)status));
            SaleEbiddingHeadService saleEbiddingHeadService = (SaleEbiddingHeadService)SpringContextUtils.getBean(SaleEbiddingHeadServiceImpl.class);
            saleEbiddingHeadService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)id)).set(SaleEbiddingHead::getEbiddingStatus, (Object)status));
            SaleEbiddingItemService saleEbiddingItemService = (SaleEbiddingItemService)SpringContextUtils.getBean(SaleEbiddingItemServiceImpl.class);
            saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingItem::getEbiddingNumber, (Object)dbHead.getEbiddingNumber())).eq(SaleEbiddingItem::getToElsAccount, (Object)tenantId)).eq(SaleEbiddingItem::getCurrentRound, (Object)dbHead.getCurrentRound())).set(SaleEbiddingItem::getItemStatus, (Object)status));
            String jobKey = "srmEbiddingBeginJobServiceImpl_" + dbHead.getEbiddingNumber() + "_" + tenantId;
            EbiddingJobUtil.deleteJob((String)jobKey);
        }
        String jobKey = paramObj.getString("jobKey");
        EbiddingJobUtil.deleteJob((String)jobKey);
        log.info(" \u7ade\u4ef7\u6d41\u6807\u5b9a\u65f6\u4efb\u52a1 SrmEbiddingFailedJob \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

