/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.global.api.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.im.ImBaseUserRecordRpcService;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseClarificationInfo;
import com.els.modules.bidding.entity.PurchaseMentoringHead;
import com.els.modules.bidding.entity.SaleClarificationInfo;
import com.els.modules.bidding.entity.SaleMentoringHead;
import com.els.modules.bidding.enumerate.ClarificationBusinessTypeEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.PurchaseMentoringHeadService;
import com.els.modules.bidding.service.SaleClarificationInfoService;
import com.els.modules.bidding.service.SaleMentoringHeadService;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.im.api.dto.ImRecordDto;
import com.els.modules.im.api.enumerate.ImRecordTypeEnum;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="inquiryImUserRecordRpcService")
public class InquiryBeanImUserRecordRpcService
extends ImBaseUserRecordRpcService {
    @Resource
    private PurchaseClarificationInfoService purchaseClarificationInfoService;
    @Resource
    private SaleClarificationInfoService saleClarificationInfoService;
    @Resource
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Resource
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Resource
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Resource
    private EnquirySupplierListService enquirySupplierListService;
    @Resource
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Resource
    private BiddingSupplierService biddingSupplierService;
    @Resource
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Resource
    private PurchaseMentoringHeadService purchaseMentoringHeadService;
    @Resource
    private SaleMentoringHeadService saleMentoringHeadService;

    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        ArrayList<ImUserDTO> resultList = new ArrayList<ImUserDTO>();
        if (ImRecordTypeEnum.PURCHASE_CLARIFICATION_INFO.getValue().equals(imRecordDto.getType())) {
            PurchaseClarificationInfo dbHeadTemp = (PurchaseClarificationInfo)this.purchaseClarificationInfoService.getById((Serializable)((Object)imRecordDto.getRecordId()));
            Assert.isTrue((null != dbHeadTemp ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_LVtyWWWWxMK_fea6c2c6", (String)"\u6f84\u6e05\u5355\u53f7[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            if (ClarificationBusinessTypeEnum.BIDDING_BUY.getValue().equals(dbHeadTemp.getBusinessType())) {
                PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)this.purchaseEbiddingHeadService.getById((Serializable)((Object)dbHeadTemp.getBusinessId()));
                Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_OutWWWWxMK_536c140d", (String)"\u7ade\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), dbHeadTemp.getBusinessId()));
                List supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
                return this.queryAllUserWithGroupChat(supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()));
            }
            if (ClarificationBusinessTypeEnum.ENQUIRY.getValue().equals(dbHeadTemp.getBusinessType())) {
                PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)this.purchaseEnquiryHeadService.getById((Serializable)((Object)dbHeadTemp.getBusinessId()));
                Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_hsutWWWWxMK_ab6b9588", (String)"\u8be2\u62a5\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), dbHeadTemp.getBusinessId()));
                List supplierList = this.enquirySupplierListService.selectByMainId(imRecordDto.getRecordId());
                return this.queryAllUserWithGroupChat(supplierList.stream().map(EnquirySupplierList::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()));
            }
            if (ClarificationBusinessTypeEnum.BIDDING.getValue().equals(dbHeadTemp.getBusinessType())) {
                PurchaseBiddingHead dbHead = (PurchaseBiddingHead)this.purchaseBiddingHeadService.getById((Serializable)((Object)dbHeadTemp.getBusinessId()));
                Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_bidding_record_id_no_found_bidding", (String)("\u62db\u6807\u5355[" + dbHeadTemp.getBusinessId() + "]\u4e0d\u5b58\u5728"), (String[])new String[]{dbHeadTemp.getBusinessId()}));
                List biddingSupplierList = this.biddingSupplierService.selectByMainId(dbHead.getId());
                List purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(dbHead.getId());
                List supplierList = this.queryAllUserWithGroupChat(biddingSupplierList.stream().map(BiddingSupplier::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()));
                for (ImUserDTO dto : supplierList) {
                    dto.setGroupName("\u4f9b\u5e94\u5546");
                }
                List memberList = purchaseBiddingSpecialistList.stream().map(supplier -> {
                    ImUserDTO imUserDTO = new ImUserDTO();
                    imUserDTO.setElsAccount(supplier.getElsAccount() + "_" + supplier.getSubAccount());
                    imUserDTO.setGroupName(MemberTypeEnum.getMemberTypeDesc((String)supplier.getMemberType()));
                    return imUserDTO;
                }).collect(Collectors.toList());
                supplierList.addAll(memberList);
                return supplierList;
            }
        } else if (ImRecordTypeEnum.SALE_CLARIFICATION_INFO.getValue().equals(imRecordDto.getType())) {
            SaleClarificationInfo dbHead = (SaleClarificationInfo)this.saleClarificationInfoService.getById((Serializable)((Object)imRecordDto.getRecordId()));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_LVtyWWWWxMK_fea6c2c6", (String)"\u6f84\u6e05\u5355\u53f7[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            String toElsAccount = dbHead.getToElsAccount();
            String subAccount = dbHead.getUpdateBy();
            ImUserDTO e = new ImUserDTO();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        } else {
            if (ImRecordTypeEnum.PURCHASE_MENTORING_HEAD.getValue().equals(imRecordDto.getType())) {
                PurchaseMentoringHead dbHead = (PurchaseMentoringHead)this.purchaseMentoringHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
                Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_fItyWWWWxMK_6668008a", (String)"\u7b54\u7591\u5355\u53f7[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
                return this.queryAllUserWithGroupChat(Lists.newArrayList((Object[])new String[]{dbHead.getToElsAccount()}));
            }
            if (ImRecordTypeEnum.SALE_MENTORING_HEAD.getValue().equals(imRecordDto.getType())) {
                SaleMentoringHead dbHead = (SaleMentoringHead)this.saleMentoringHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
                Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_fItyWWWWxMK_6668008a", (String)"\u7b54\u7591\u5355\u53f7[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
                String toElsAccount = dbHead.getToElsAccount();
                String subAccount = dbHead.getUpdateBy();
                ImUserDTO e = new ImUserDTO();
                e.setElsAccount(toElsAccount + "_" + subAccount);
                resultList.add(e);
            }
        }
        return resultList;
    }
}

