/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.api.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.im.ImBaseUserRecordRpcService;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.im.api.dto.ImRecordDto;
import com.els.modules.im.api.enumerate.ImRecordTypeEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="ebiddingBuyImUserRecordServiceImpl")
public class EbiddingBuyUserRecordInvokeBeanServiceImpl
extends ImBaseUserRecordRpcService {
    @Resource
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Resource
    private SaleEbiddingHeadService saleEbiddingHeadService;
    @Resource
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;

    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        ArrayList<ImUserDTO> resultList = new ArrayList<ImUserDTO>();
        if (ImRecordTypeEnum.EBIDDING_BUY.getValue().equals(imRecordDto.getType())) {
            PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)this.purchaseEbiddingHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_OutWWWWxMK_536c140d", (String)"\u7ade\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            Assert.isTrue((!EbiddingStatusEnum.NEW.getValue().equals(dbHead.getEbiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_OutVIzEWShRe_d64caf4b", (String)"\u7ade\u4ef7\u5355\u65b0\u5efa\u72b6\u6001\uff0c\u65e0\u6cd5\u6c9f\u901a"));
            List supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
            return this.queryAllUserWithGroupChat(supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()));
        }
        if (ImRecordTypeEnum.SALE_EBIDDING_BUY.getValue().equals(imRecordDto.getType())) {
            SaleEbiddingHead dbHead = (SaleEbiddingHead)this.saleEbiddingHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_OutWWWWxMK_536c140d", (String)"\u7ade\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            String toElsAccount = dbHead.getToElsAccount();
            String subAccount = dbHead.getUpdateBy();
            ImUserDTO e = new ImUserDTO();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        }
        return resultList;
    }
}

