/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.third.sql.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.InterfaceUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.third.sql.dto.PurchaseRequestHeadOracleDto;
import com.els.modules.demand.third.sql.dto.PurchaseRequestItemOracleDto;
import com.els.modules.enquiry.utils.DefaultValueInitUtil;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.service.PurchaseMaterialHeadRpcService;
import com.els.modules.third.sql.util.OracleSqlUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetPurchaseRequestFromCQGTOracleDbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetPurchaseRequestFromCQGTOracleDbImpl.class);
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private TemplateRpcService templateRpcService;
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PurchaseMaterialHeadRpcService purchaseMaterialHeadRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public JSONObject before(JSONObject obj, Object custom) {
        String tableName = "SRM_PO_REQUESTION_HEADERS_ALL";
        obj.put("body", (Object)OracleSqlUtil.getAllDataSql((String)tableName));
        obj.put("business_message", (Object)tableName);
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("GetMaterialCodeFromCQGTOracleDbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        JSONArray headList = OracleSqlUtil.handlerResultListInfo((JSONObject)interfaceResult);
        Map<String, List<PurchaseRequestItemOracleDto>> requestItemMap = this.getPurchaseRequestItem();
        String elsAccount = TenantContext.getTenant();
        List templateList = this.templateRpcService.getDefaultTemplateByType("purchaseRequest");
        Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u91c7\u8d2d\u7533\u8bf7\u9ed8\u8ba4\u6a21\u677f", (Object[])new Object[0]);
        TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
        Map headValueMap = DefaultValueInitUtil.getHeadDefaultValue((String)template.getElsAccount(), (String)template.getTemplateNumber(), (String)String.valueOf(template.getTemplateVersion()));
        Map itemValueMap = DefaultValueInitUtil.getItemDefaultValue((String)template.getElsAccount(), (String)template.getTemplateNumber(), (String)String.valueOf(template.getTemplateVersion()));
        Map<String, PurchaseRequestHead> orgInfoMap = this.getPurchaseRequest(elsAccount);
        Map<String, String> deptMap = this.invokeBaseRpcService.queryDictItemsByCode("unitCode", elsAccount).stream().collect(Collectors.toMap(DictDTO::getText, DictDTO::getValue));
        Map<String, PurchaseMaterialHeadDTO> materialHeadItems = this.getPurchaseMaterialItem(elsAccount);
        ArrayList<PurchaseRequestHead> insertHead = new ArrayList<PurchaseRequestHead>();
        ArrayList<PurchaseRequestHead> updateHead = new ArrayList<PurchaseRequestHead>();
        ArrayList<PurchaseRequestItem> insertItem = new ArrayList<PurchaseRequestItem>();
        ArrayList<String> deleteItems = new ArrayList<String>();
        for (Object o : headList) {
            PurchaseRequestHead head;
            JSONObject json = (JSONObject)o;
            PurchaseRequestHeadOracleDto oracleDto = (PurchaseRequestHeadOracleDto)JSON.parseObject((String)json.toJSONString(), PurchaseRequestHeadOracleDto.class);
            if (orgInfoMap.containsKey(oracleDto.getRequestNumber())) {
                head = orgInfoMap.get(oracleDto.getRequestNumber());
                long time = head.getUpdateTime().getTime();
                long time1 = OracleSqlUtil.getUpdateTime((String)oracleDto.getUpdateTime()).getTime();
                if (time1 <= time) continue;
                head.setRequestNumber(oracleDto.getRequestNumber());
                head.setApplyDate(OracleSqlUtil.getUpdateTime((String)oracleDto.getApplyDate()));
                head.setApplyDept(oracleDto.getOrgCode() + "_" + oracleDto.getApplyDept());
                head.setApplicant(oracleDto.getUserAccount() + "_" + oracleDto.getApplicant());
                head.setApplyDeptName(oracleDto.getApplyDept());
                updateHead.add(head);
                deleteItems.add(head.getId());
            }
            head = (PurchaseRequestHead)JSONObject.parseObject((String)JSON.toJSONString((Object)headValueMap), PurchaseRequestHead.class);
            head.setId(IdWorker.getIdStr());
            head.setElsAccount(elsAccount);
            head.setTemplateNumber(template.getTemplateNumber());
            head.setTemplateName(template.getTemplateName());
            head.setTemplateAccount(template.getElsAccount());
            head.setTemplateVersion(template.getTemplateVersion().toString());
            head.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_DEMAND.getValue());
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            head.setSourceId(oracleDto.getRequestHeadId());
            head.setSourceSystem("ERP");
            head.setRequestNumber(oracleDto.getRequestNumber());
            head.setApplyDate(OracleSqlUtil.getUpdateTime((String)oracleDto.getApplyDate()));
            head.setApplyDept(oracleDto.getOrgCode() + "_" + oracleDto.getApplyDept());
            head.setApplicant(oracleDto.getUserAccount() + "_" + oracleDto.getApplicant());
            head.setApplyDeptName(oracleDto.getApplyDept());
            head.setSourceId(oracleDto.getRequestHeadId());
            insertHead.add(head);
            List<PurchaseRequestItemOracleDto> resultItems = requestItemMap.get(oracleDto.getRequestHeadId());
            for (PurchaseRequestItemOracleDto resultItem : resultItems) {
                PurchaseRequestItem item = (PurchaseRequestItem)JSONObject.parseObject((String)JSON.toJSONString((Object)itemValueMap), PurchaseRequestItem.class);
                item.setHeadId(head.getId());
                item.setAuditStatus(head.getAuditStatus());
                item.setRequestNumber(head.getRequestNumber());
                item.setRequestType(head.getRequestType());
                item.setPurchaseType(head.getPurchaseType());
                item.setApplyDept(head.getApplyDept());
                item.setApplyDate(head.getApplyDate());
                item.setApplicant(head.getApplicant());
                item.setItemStatus(PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                item.setPurchasePrincipal(head.getPurchasePrincipal());
                PurchaseMaterialHeadDTO materialHeadDTO = materialHeadItems.get(resultItem.getMaterialNumber());
                if (null != materialHeadDTO) {
                    item.setMaterialId(materialHeadDTO.getId());
                    item.setMaterialName(materialHeadDTO.getMaterialName());
                    item.setMaterialNumber(materialHeadDTO.getMaterialNumber());
                    item.setMaterialSpec(materialHeadDTO.getMaterialSpec());
                    item.setMaterialModel(materialHeadDTO.getMaterialModel());
                }
                item.setPurchaseUnit(deptMap.get(resultItem.getUomCode()));
                item.setSourceId(resultItem.getPurchaseRequestItemId());
                item.setFactory(resultItem.getFactory());
                item.setRepertoryQuantity(StringUtils.isBlank((String)resultItem.getQuantity()) ? BigDecimal.ZERO : new BigDecimal(resultItem.getQuantity()));
                item.setQuantity(StringUtils.isBlank((String)resultItem.getQuantity()) ? BigDecimal.ZERO : new BigDecimal(resultItem.getQuantity()));
                item.setDeliveryDate(OracleSqlUtil.getUpdateTime((String)resultItem.getDeliveryDate()));
                item.setFbk1(resultItem.getFbk1());
                item.setRemark(resultItem.getFbk2());
                item.setFbk2(resultItem.getFbk3());
                insertItem.add(item);
            }
        }
        if (CollectionUtil.isNotEmpty(deleteItems)) {
            this.purchaseRequestItemService.deleteByHeadIds(deleteItems);
        }
        if (CollectionUtil.isNotEmpty(insertHead)) {
            this.purchaseRequestHeadService.saveBatch(insertHead, 2000);
        }
        if (CollectionUtil.isNotEmpty(updateHead)) {
            this.purchaseRequestHeadService.updateBatchById(updateHead, 2000);
        }
        if (CollectionUtil.isNotEmpty(insertItem)) {
            this.purchaseRequestItemService.saveBatch(insertItem, 2000);
        }
        return interfaceResult;
    }

    private Map<String, List<PurchaseRequestItemOracleDto>> getPurchaseRequestItem() {
        String elsAccount = TenantContext.getTenant();
        String tableName = "SRM_PO_REQUESTION_LINES_ALL";
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)"getPurchaseRequestDetailData");
        param.put("body", (Object)OracleSqlUtil.getAllDataSql((String)tableName));
        param.put("business_message", (Object)tableName);
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, null, param, null);
        JSONArray jsonArray = OracleSqlUtil.handlerResultListInfo((JSONObject)resultObj);
        List resultItems = JSON.parseArray((String)jsonArray.toJSONString(), PurchaseRequestItemOracleDto.class);
        return resultItems.parallelStream().collect(Collectors.groupingBy(PurchaseRequestItemOracleDto::getPurchaseRequestHeadId));
    }

    private Map<String, PurchaseRequestHead> getPurchaseRequest(String elsAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        wrapper.eq(PurchaseRequestHead::getSourceSystem, (Object)"ERP");
        List list = this.purchaseRequestHeadService.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return new HashMap<String, PurchaseRequestHead>();
        }
        return list.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestNumber, Function.identity(), (newVal, oldVal) -> oldVal));
    }

    private Map<String, PurchaseMaterialHeadDTO> getPurchaseMaterialItem(String elsAccount) {
        List list = this.purchaseMaterialHeadRpcService.listAll();
        if (CollectionUtil.isEmpty((Collection)list)) {
            return new HashMap<String, PurchaseMaterialHeadDTO>();
        }
        return list.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity(), (newVal, oldVal) -> oldVal));
    }
}

