/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.modules.bidding.job.BiddingJobUtil;
import com.els.modules.tender.common.utils.OpenBidRecordLogUtils;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectOpenInfoHeadVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component(value="tenderOpenBidDecryptAlertJobServiceImpl")
public class TenderOpenBidDecryptAlertJobServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(TenderOpenBidDecryptAlertJobServiceImpl.class);

    @Async
    public void execute(String parameter) {
        log.info(" \u62db\u6807\u89e3\u5bc6\u5012\u8ba1\u65f6\u5b9a\u65f6\u4efb\u52a1 tenderOpenBidDecryptAlertJobServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        if (StrUtil.isEmpty((CharSequence)id)) {
            log.error("parameter must contain id.");
            return;
        }
        PurchaseTenderProjectSubpackageInfoService subpackageInfoService = (PurchaseTenderProjectSubpackageInfoService)SpringContextUtils.getBean(PurchaseTenderProjectSubpackageInfoService.class);
        PurchaseTenderProjectOpenInfoHeadVO openInfoHeadVO = subpackageInfoService.queryOpenInfoById(id);
        if (PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openInfoHeadVO.getOpenBidStatus())) {
            subpackageInfoService.updateOpenBidStatus(id, PurchaseOpenBidStatusEnum.DECRYPTED.getValue(), Integer.valueOf(TenderProjectSubpackageStatusEnum.DECRYPTED.getValue()));
            OpenBidRecordLogUtils.saveRecordMsg((PurchaseTenderProjectOpenInfoHeadVO)openInfoHeadVO, (String)"\u89e3\u5bc6\u73af\u8282\u7ed3\u675f");
        }
        String jobKey = paramObj.getString("jobKey");
        BiddingJobUtil.deleteJob((String)jobKey);
        log.info(" \u62db\u6807\u5f00\u6807\u9884\u8b66\u5b9a\u65f6\u4efb\u52a1 tenderOpenBidAlertJobServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

