/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.im.api.dto.ImRecordDto;
import com.els.modules.im.api.service.ImUserRecordRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="purchaseBiddingProjectUserRecordServiceImpl")
public class PurchaseBiddingProjectUserRecordInvokeBeanServiceImpl
implements ImUserRecordRpcService {
    @Autowired
    private PurchaseBiddingHeadService biddingHeadService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Resource
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;

    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        ArrayList<ImUserDTO> resultList = new ArrayList<ImUserDTO>();
        List purchaseBiddingHeadList = ((LambdaQueryChainWrapper)this.biddingHeadService.lambdaQuery().eq(PurchaseBiddingHead::getProjectId, (Object)imRecordDto.getRecordId())).list();
        if (CollectionUtil.isEmpty((Collection)purchaseBiddingHeadList)) {
            return resultList;
        }
        for (PurchaseBiddingHead purchaseBiddingHead : purchaseBiddingHeadList) {
            List<ImUserDTO> userDTOList = this.getSupplier(purchaseBiddingHead);
            if (!CollectionUtil.isNotEmpty(userDTOList)) continue;
            resultList.addAll(userDTOList);
        }
        return resultList;
    }

    public List<ImUserDTO> getSupplier(PurchaseBiddingHead dbHead) {
        if (BiddingStatusEnum.CANCEL.getValue().equals(dbHead.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(dbHead.getBiddingStatus())) {
            return null;
        }
        List biddingSupplierList = this.biddingSupplierService.selectByMainId(dbHead.getId());
        List purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(dbHead.getId());
        List<ImUserDTO> supplierList = biddingSupplierList.stream().map(supplier -> {
            String toElsAccount = supplier.getToElsAccount();
            String subAccount = StringUtils.isEmpty((Object)supplier.getContacts()) ? "1001" : supplier.getContacts();
            ImUserDTO imUserDTO = new ImUserDTO();
            imUserDTO.setElsAccount(toElsAccount + "_" + subAccount);
            imUserDTO.setGroupName(dbHead.getBiddingDesc() + "\u4f9b\u5e94\u5546");
            return imUserDTO;
        }).collect(Collectors.toList());
        List memberList = purchaseBiddingSpecialistList.stream().map(supplier -> {
            ImUserDTO imUserDTO = new ImUserDTO();
            imUserDTO.setElsAccount(supplier.getElsAccount() + "_" + supplier.getSubAccount());
            imUserDTO.setGroupName(dbHead.getBiddingDesc() + MemberTypeEnum.getMemberTypeDesc((String)supplier.getMemberType()));
            return imUserDTO;
        }).collect(Collectors.toList());
        supplierList.addAll(memberList);
        return supplierList;
    }
}

