/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.job;

import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.inquiry.rpc.service.InquriyInvokeJobRpcService;
import com.els.modules.job.api.dto.QuartzJobDTO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiddingJobUtil {
    private static final Logger log = LoggerFactory.getLogger(BiddingJobUtil.class);
    private static InquriyInvokeJobRpcService inquriyInvokeJobRpcService = (InquriyInvokeJobRpcService)SpringContextUtils.getBean(InquriyInvokeJobRpcService.class);
    public static final String OPEN_BID_ALERT_JOB = "openBidAlertJobServiceImpl";
    public static final String FAILURE_BID_BY_QUOTE_JOB = "failureBidByQuoteJobServiceImpl";
    public static final String FAILURE_BID_BY_REPLY_JOB = "failureBidByReplyJobServiceImpl";

    private static void createJob(PurchaseBiddingHead purchaseHead, Date time, String jobName) {
        String elsAccount = TenantContext.getTenant();
        String cron = DateUtils.formatDate((Date)time, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey(String.valueOf(jobName) + "_" + purchaseHead.getBiddingNumber() + "_" + elsAccount);
        JSONObject paramObj = new JSONObject();
        paramObj.put("id", (Object)purchaseHead.getId());
        paramObj.put("jobKey", (Object)job.getJobNameKey());
        paramObj.put("tenantId", (Object)elsAccount);
        paramObj.put("jobImplName", (Object)jobName);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(elsAccount);
        try {
            inquriyInvokeJobRpcService.createJob(job);
        }
        catch (Exception e) {
            if (e.getMessage().contains("will never fire")) {
                if (OPEN_BID_ALERT_JOB.equals(jobName)) {
                    String minute = purchaseHead.getOpenBidAlertMinute() == null ? "5" : "" + purchaseHead.getOpenBidAlertMinute();
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tEvBKITfUAPKIWWWWzsIX_6e547406", (String)"\u8ba1\u5212\u5f00\u6807\u65f6\u95f4\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4${0}\u5206\u949f\u4ee5\u4e0a", (String[])new String[]{minute}));
                }
                if (FAILURE_BID_BY_REPLY_JOB.equals(jobName)) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_dByRKITfUAPKI_dc0ae2d1", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
                }
                if (FAILURE_BID_BY_QUOTE_JOB.equals(jobName)) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eByRKITfUAPKI_d6a7ed52", (String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
                }
            }
            log.error(e.getMessage());
            throw new ELSBootException(e.getMessage());
        }
    }

    public static void createOpenBidAlertJob(PurchaseBiddingHead purchaseHead, Date time) {
        BiddingJobUtil.createJob(purchaseHead, time, OPEN_BID_ALERT_JOB);
    }

    public static void createFailureBidByReplyJob(PurchaseBiddingHead purchaseHead, Date time) {
        BiddingJobUtil.createJob(purchaseHead, time, FAILURE_BID_BY_REPLY_JOB);
    }

    public static void createFailureBidByQuoteJob(PurchaseBiddingHead purchaseHead, Date time) {
        BiddingJobUtil.createJob(purchaseHead, time, FAILURE_BID_BY_QUOTE_JOB);
    }

    public static void updateEndJob(PurchaseBiddingHead purchaseHead, Date endTime) {
        String elsAccount = purchaseHead.getElsAccount();
        String cron = DateUtils.formatDate((Date)endTime, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey("openBidAlertJobServiceImpl_" + purchaseHead.getBiddingNumber() + "_" + elsAccount);
        try {
            List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(job.getJobNameKey());
            if (!jobList.isEmpty()) {
                job.setId(jobList.get(0).getId());
                job.setParameter(jobList.get(0).getParameter());
            }
            inquriyInvokeJobRpcService.updateJob(job);
        }
        catch (Exception e) {
            if (e.getMessage().contains("will never fire")) {
                String minute = purchaseHead.getOpenBidAlertMinute() == null ? "5" : "" + purchaseHead.getOpenBidAlertMinute();
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tEvBKITfUAPKIWWWWzsIX_6e547406", (String)"\u8ba1\u5212\u5f00\u6807\u65f6\u95f4\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4${0}\u5206\u949f\u4ee5\u4e0a", (String[])new String[]{minute}));
            }
            throw new ELSBootException((Throwable)e);
        }
    }

    public static void deleteJob(String jobKey) {
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(jobKey);
        if (!jobList.isEmpty()) {
            inquriyInvokeJobRpcService.deleteJob(jobList.get(0));
        }
    }
}

