/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.api.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseRequestCreateServiceImpl
implements OpenApiRpcService {
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseRequestHead> headList = new ArrayList<PurchaseRequestHead>();
        ArrayList<PurchaseRequestItem> headItem = new ArrayList<PurchaseRequestItem>();
        for (Object obj : array) {
            List purchaseRequestItems;
            JSONArray itemListJsonArray;
            JSONObject object = (JSONObject)obj;
            PurchaseRequestHead head = (PurchaseRequestHead)((Object)JSONObject.parseObject((String)object.toString(), PurchaseRequestHead.class));
            head.setElsAccount(account);
            head.setCreateTime(currentTime);
            head.setCreateBy("interface");
            head.setUpdateBy(head.getCreateBy());
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setId(IdWorker.getIdStr());
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(String.valueOf(templateHead.getTemplateVersion()));
            head.setTemplateAccount(templateHead.getElsAccount());
            BeanUtil.copyProperties(defaultHeadMap, (Object)((Object)head), (String[])new String[0]);
            headList.add(head);
            if (!object.containsKey((Object)"itemList") || (itemListJsonArray = object.getJSONArray("itemList")) == null || itemListJsonArray.isEmpty() || (purchaseRequestItems = JSON.parseArray((String)itemListJsonArray.toJSONString(), PurchaseRequestItem.class)) == null || CollectionUtils.isEmpty((Collection)purchaseRequestItems)) continue;
            for (PurchaseRequestItem purchaseRequestItem : purchaseRequestItems) {
                purchaseRequestItem.setHeadId(head.getId());
                purchaseRequestItem.setElsAccount(account);
                purchaseRequestItem.setCreateTime(currentTime);
                purchaseRequestItem.setCreateBy("interface");
                purchaseRequestItem.setUpdateBy("interface");
                purchaseRequestItem.setDeleted(CommonConstant.DEL_FLAG_0);
                BeanUtil.copyProperties(defaultItemMap, (Object)((Object)purchaseRequestItem), (String[])new String[0]);
                headItem.add(purchaseRequestItem);
            }
        }
        if (!headList.isEmpty()) {
            this.purchaseRequestHeadService.saveBatch(headList, 200);
        }
        if (!headItem.isEmpty()) {
            this.purchaseRequestItemService.saveBatch(headItem, 200);
        }
        return null;
    }

    public String getBusinessType() {
        return "purchaseRequest";
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }
}

