/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.rocketMq.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.LoginUserContext;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component
public class PublishEnquiryConsumer {
    private static final Logger log = LoggerFactory.getLogger(PublishEnquiryConsumer.class);
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;

    @StreamListener(value="inputPublishEnquiry")
    @SrmTransaction
    public void publish(Message<String> message) {
        String msgBody = (String)message.getPayload();
        log.info("msgBody: " + msgBody);
        JSONObject body = JSONObject.parseObject((String)msgBody);
        PurchaseEnquiryHeadVO headVO = (PurchaseEnquiryHeadVO)((Object)JSONObject.toJavaObject((JSON)body.getJSONObject("content"), PurchaseEnquiryHeadVO.class));
        try {
            try {
                LoginUser user = (LoginUser)JSONObject.toJavaObject((JSON)body.getJSONObject("user"), LoginUser.class);
                String tenant = body.getString("tenant");
                TenantContext.setTenant((String)tenant);
                LoginUserContext.setUser((LoginUser)user);
                PurchaseEnquiryHead head = new PurchaseEnquiryHead();
                head.setId(headVO.getId());
                head.setEnquiryStatus(EnquiryStatusEnum.QUOTING.getValue());
                this.purchaseEnquiryHeadService.updateById((Object)head);
                this.purchaseEnquiryHeadService.publishEnquiry(headVO, headVO.getPurchaseEnquiryItemList(), headVO.getEnquirySupplierListList(), headVO.getPurchaseAttachmentDemandList());
            }
            catch (Exception e) {
                log.error("InitTableConsumer_receive_msgBody:" + msgBody, (Throwable)e);
                String times = (String)message.getHeaders().get((Object)"rocketmq_RECONSUME_TIMES");
                if (times == null || Integer.parseInt(times) < 6) {
                    throw e;
                }
                PurchaseEnquiryHead head = new PurchaseEnquiryHead();
                head.setId(headVO.getId());
                head.setEnquiryStatus(EnquiryStatusEnum.PUBLISH_FAILED.getValue());
                this.purchaseEnquiryHeadService.updateById((Object)head);
                this.purchaseEnquiryHeadService.insertData(headVO, headVO.getPurchaseEnquiryItemList(), headVO.getEnquirySupplierListList(), headVO.getPurchaseAttachmentDemandList());
                TenantContext.clear();
                LoginUserContext.clear();
            }
        }
        finally {
            TenantContext.clear();
            LoginUserContext.clear();
        }
    }
}

