/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.specialist.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.specialist.entity.SpecialistEducationExperienceInfo;
import com.els.modules.specialist.entity.SpecialistHistoryBiddingInfo;
import com.els.modules.specialist.entity.SpecialistInfo;
import com.els.modules.specialist.entity.SpecialistProfessionalResumeInfo;
import com.els.modules.specialist.entity.SpecialistProfessionalSuccessInfo;
import com.els.modules.specialist.mapper.SpecialistEducationExperienceInfoMapper;
import com.els.modules.specialist.mapper.SpecialistHistoryBiddingInfoMapper;
import com.els.modules.specialist.mapper.SpecialistInfoMapper;
import com.els.modules.specialist.mapper.SpecialistProfessionalResumeInfoMapper;
import com.els.modules.specialist.mapper.SpecialistProfessionalSuccessInfoMapper;
import com.els.modules.specialist.rpc.service.SpecialistInvokeOrgRpcService;
import com.els.modules.specialist.service.SpecialistEducationExperienceInfoService;
import com.els.modules.specialist.service.SpecialistHistoryBiddingInfoService;
import com.els.modules.specialist.service.SpecialistInfoService;
import com.els.modules.specialist.service.SpecialistProfessionalResumeInfoService;
import com.els.modules.specialist.service.SpecialistProfessionalSuccessInfoService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpecialistInfoServiceImpl
extends ServiceImpl<SpecialistInfoMapper, SpecialistInfo>
implements SpecialistInfoService {
    @Autowired
    private SpecialistInfoMapper specialistInfoMapper;
    @Autowired
    private SpecialistEducationExperienceInfoMapper specialistEducationExperienceInfoMapper;
    @Autowired
    private SpecialistEducationExperienceInfoService specialistEducationExperienceInfoService;
    @Autowired
    private SpecialistHistoryBiddingInfoMapper specialistHistoryBiddingInfoMapper;
    @Autowired
    private SpecialistHistoryBiddingInfoService specialistHistoryBiddingInfoService;
    @Autowired
    private SpecialistProfessionalResumeInfoMapper specialistProfessionalResumeInfoMapper;
    @Autowired
    private SpecialistProfessionalResumeInfoService specialistProfessionalResumeInfoService;
    @Autowired
    private SpecialistProfessionalSuccessInfoMapper specialistProfessionalSuccessInfoMapper;
    @Autowired
    private SpecialistProfessionalSuccessInfoService specialistProfessionalSuccessInfoService;
    @Autowired
    private SpecialistInvokeOrgRpcService specialistInvokeOrgRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SpecialistInfo specialistInfo, List<SpecialistEducationExperienceInfo> specialistEducationExperienceInfoList, List<SpecialistHistoryBiddingInfo> specialistHistoryBiddingInfoList, List<SpecialistProfessionalResumeInfo> specialistProfessionalResumeInfoList, List<SpecialistProfessionalSuccessInfo> specialistProfessionalSuccessInfoList) {
        this.specialistInfoMapper.insert((Object)specialistInfo);
        this.insertData(specialistInfo, specialistEducationExperienceInfoList, specialistHistoryBiddingInfoList, specialistProfessionalResumeInfoList, specialistProfessionalSuccessInfoList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SpecialistInfo specialistInfo, List<SpecialistEducationExperienceInfo> specialistEducationExperienceInfoList, List<SpecialistHistoryBiddingInfo> specialistHistoryBiddingInfoList, List<SpecialistProfessionalResumeInfo> specialistProfessionalResumeInfoList, List<SpecialistProfessionalSuccessInfo> specialistProfessionalSuccessInfoList) {
        int count;
        if (StringUtils.isNotBlank((CharSequence)specialistInfo.getPurchaseOrg())) {
            String orgDesc = "";
            if (specialistInfo.getPurchaseOrg().contains(",")) {
                String[] orgs;
                String[] stringArray = orgs = specialistInfo.getPurchaseOrg().split(",");
                int n = orgs.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    PurchaseOrganizationInfoDTO organizationInfo = this.specialistInvokeOrgRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "purchaseOrganization", string);
                    if (organizationInfo == null) {
                        organizationInfo = this.specialistInvokeOrgRpcService.selectByElsAccountAndCode("100000", "purchaseOrganization", string);
                    }
                    orgDesc = String.valueOf(orgDesc) + string + "_" + organizationInfo.getOrgName() + ",";
                    ++n2;
                }
            } else {
                PurchaseOrganizationInfoDTO organizationInfo = this.specialistInvokeOrgRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "purchaseOrganization", specialistInfo.getPurchaseOrg());
                if (organizationInfo == null) {
                    organizationInfo = this.specialistInvokeOrgRpcService.selectByElsAccountAndCode("100000", "purchaseOrganization", specialistInfo.getPurchaseOrg());
                }
                orgDesc = String.valueOf(specialistInfo.getPurchaseOrg()) + "_" + organizationInfo.getOrgName();
            }
            specialistInfo.setPurchaseOrgDesc(orgDesc);
        }
        if ((count = this.specialistInfoMapper.updateById((Object)specialistInfo)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.specialistEducationExperienceInfoMapper.deleteByMainId(specialistInfo.getId());
        this.specialistHistoryBiddingInfoMapper.deleteByMainId(specialistInfo.getId());
        this.specialistProfessionalResumeInfoMapper.deleteByMainId(specialistInfo.getId());
        this.specialistProfessionalSuccessInfoMapper.deleteByMainId(specialistInfo.getId());
        this.insertData(specialistInfo, specialistEducationExperienceInfoList, specialistHistoryBiddingInfoList, specialistProfessionalResumeInfoList, specialistProfessionalSuccessInfoList);
    }

    private void insertData(SpecialistInfo specialistInfo, List<SpecialistEducationExperienceInfo> specialistEducationExperienceInfoList, List<SpecialistHistoryBiddingInfo> specialistHistoryBiddingInfoList, List<SpecialistProfessionalResumeInfo> specialistProfessionalResumeInfoList, List<SpecialistProfessionalSuccessInfo> specialistProfessionalSuccessInfoList) {
        if (specialistEducationExperienceInfoList != null) {
            for (SpecialistEducationExperienceInfo specialistEducationExperienceInfo : specialistEducationExperienceInfoList) {
                specialistEducationExperienceInfo.setHeadId(specialistInfo.getId());
                SysUtil.setSysParam((BaseEntity)specialistEducationExperienceInfo, (BaseEntity)specialistInfo);
            }
            if (!specialistEducationExperienceInfoList.isEmpty()) {
                this.specialistEducationExperienceInfoService.saveBatch(specialistEducationExperienceInfoList, 2000);
            }
        }
        if (specialistHistoryBiddingInfoList != null) {
            for (SpecialistHistoryBiddingInfo specialistHistoryBiddingInfo : specialistHistoryBiddingInfoList) {
                specialistHistoryBiddingInfo.setHeadId(specialistInfo.getId());
                SysUtil.setSysParam((BaseEntity)specialistHistoryBiddingInfo, (BaseEntity)specialistInfo);
            }
            if (!specialistHistoryBiddingInfoList.isEmpty()) {
                this.specialistHistoryBiddingInfoService.saveBatch(specialistHistoryBiddingInfoList, 2000);
            }
        }
        if (specialistProfessionalResumeInfoList != null) {
            for (SpecialistProfessionalResumeInfo specialistProfessionalResumeInfo : specialistProfessionalResumeInfoList) {
                specialistProfessionalResumeInfo.setHeadId(specialistInfo.getId());
                SysUtil.setSysParam((BaseEntity)specialistProfessionalResumeInfo, (BaseEntity)specialistInfo);
            }
            if (!specialistProfessionalResumeInfoList.isEmpty()) {
                this.specialistProfessionalResumeInfoService.saveBatch(specialistProfessionalResumeInfoList);
            }
        }
        if (specialistProfessionalSuccessInfoList != null) {
            for (SpecialistProfessionalSuccessInfo specialistProfessionalSuccessInfo : specialistProfessionalSuccessInfoList) {
                specialistProfessionalSuccessInfo.setHeadId(specialistInfo.getId());
                SysUtil.setSysParam((BaseEntity)specialistProfessionalSuccessInfo, (BaseEntity)specialistInfo);
            }
            if (!specialistProfessionalSuccessInfoList.isEmpty()) {
                this.specialistProfessionalSuccessInfoService.saveBatch(specialistProfessionalSuccessInfoList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.specialistEducationExperienceInfoMapper.deleteByMainId(id);
        this.specialistHistoryBiddingInfoMapper.deleteByMainId(id);
        this.specialistProfessionalResumeInfoMapper.deleteByMainId(id);
        this.specialistProfessionalSuccessInfoMapper.deleteByMainId(id);
        this.specialistInfoMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.specialistEducationExperienceInfoMapper.deleteByMainId(serializable.toString());
            this.specialistHistoryBiddingInfoMapper.deleteByMainId(serializable.toString());
            this.specialistProfessionalResumeInfoMapper.deleteByMainId(serializable.toString());
            this.specialistProfessionalSuccessInfoMapper.deleteByMainId(serializable.toString());
            this.specialistInfoMapper.deleteById(serializable);
        }
    }
}

