/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.ebidding.entity.PurchaseEbiddingConfirm;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.entity.SaleEbiddingItemHis;
import com.els.modules.ebidding.enumerate.EbiddingDelayRuleEnum;
import com.els.modules.ebidding.enumerate.EbiddingItemStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingRangeUnitEnum;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingShowEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.job.utils.EbiddingJobUtil;
import com.els.modules.ebidding.mapper.PurchaseEbiddingHeadMapper;
import com.els.modules.ebidding.mapper.PurchaseEbiddingItemMapper;
import com.els.modules.ebidding.mapper.SaleEbiddingHeadMapper;
import com.els.modules.ebidding.mapper.SaleEbiddingItemMapper;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemHisService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingConfirmService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingItemHisService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingHeadServiceImpl;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingItemHisServiceImpl;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingItemServiceImpl;
import com.els.modules.ebidding.service.impl.SaleEbiddingItemHisServiceImpl;
import com.els.modules.ebidding.vo.SaleEbiddingConfirmVO;
import com.els.modules.ebidding.vo.SaleEbiddingHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleEbiddingHeadServiceImpl
extends ServiceImpl<SaleEbiddingHeadMapper, SaleEbiddingHead>
implements SaleEbiddingHeadService {
    private static final Logger log = LoggerFactory.getLogger(SaleEbiddingHeadServiceImpl.class);
    @Resource
    private SaleEbiddingItemMapper saleEbiddingItemMapper;
    @Resource
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Resource
    private PurchaseEbiddingHeadMapper purchaseEbiddingHeadMapper;
    @Resource
    private PurchaseEbiddingItemMapper purchaseEbiddingItemMapper;
    @Autowired
    private SaleEbiddingItemService saleEbiddingItemService;
    @Autowired
    private SaleEbiddingConfirmService saleEbiddingConfirmService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private SaleEbiddingItemHisService saleEbiddingItemHisService;
    @Autowired
    private RedisUtil redis;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public Map<String, String> publish(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseEbiddingConfirm> confirmList) {
        ArrayList<SaleEbiddingHead> saleHeadList = new ArrayList<SaleEbiddingHead>();
        LoginUser user = SysUtil.getLoginUser();
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            SaleEbiddingHead saleHead = new SaleEbiddingHead();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)saleHead));
            SysUtil.setSysParam((BaseEntity)saleHead, (BaseEntity)head);
            saleHead.setId(IdWorker.getIdStr());
            saleHead.setRelationId(head.getId());
            saleHead.setElsAccount(supplier.getToElsAccount());
            saleHead.setToElsAccount(supplier.getElsAccount());
            saleHead.setPurchaseName(user.getEnterpriseName());
            saleHead.setSupplierListId(supplier.getId());
            BigDecimal targetTotalAmount = "1".equals(head.getSendTargetPrice()) ? head.getTargetTotalAmount() : null;
            saleHead.setTargetTotalAmount(targetTotalAmount);
            String ebiddingStatus = "1".equals(head.getNeedEcho()) ? EbiddingStatusEnum.WAIT_REPLY.getValue() : EbiddingStatusEnum.WAIT_BIDDING.getValue();
            saleHead.setEbiddingStatus(ebiddingStatus);
            saleHeadList.add(saleHead);
        }
        this.saveBatch(saleHeadList, 2000);
        Map<String, String> idMap = saleHeadList.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, BaseEntity::getId));
        this.saleEbiddingItemService.publish(head, itemList, idMap);
        this.saleEbiddingConfirmService.publish(head, confirmList, idMap);
        return idMap;
    }

    @Override
    public void acceptResponse(SaleEbiddingHeadVO webVO) {
        List<SaleEbiddingConfirmVO> confirmList = webVO.getSaleEbiddingConfirmList();
        SaleEbiddingHead saleHead = new SaleEbiddingHead();
        saleHead.setId(webVO.getId());
        saleHead.setEbiddingStatus(CollectionUtil.isEmpty(confirmList) ? EbiddingStatusEnum.WAIT_BIDDING.getValue() : EbiddingStatusEnum.ALREADY_REPLY.getValue());
        saleHead.setTaxCode(webVO.getTaxCode());
        saleHead.setTaxRate(webVO.getTaxRate());
        ((SaleEbiddingHeadMapper)this.baseMapper).updateById((Object)saleHead);
        PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
        supplier.setId(webVO.getSupplierListId());
        supplier.setReplyTime(new Date());
        supplier.setReplyStatus(EbiddingReplyStatusEnum.HAS_REPLY.getValue());
        this.purchaseEbiddingSupplierService.updateById((Object)supplier);
        PurchaseEbiddingHead dbPurchaseHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)webVO.getRelationId())));
        Integer replyQuantity = dbPurchaseHead.getReplyQuantity() == null ? 1 : dbPurchaseHead.getReplyQuantity() + 1;
        dbPurchaseHead.setReplyQuantity(replyQuantity);
        this.purchaseEbiddingHeadMapper.updateById((Object)dbPurchaseHead);
        if (EbiddingStatusEnum.WAIT_BIDDING.getValue().equals(saleHead.getEbiddingStatus())) {
            this.updatePurchaseWaiteEbidding(webVO.getRelationId());
        }
        this.saleEbiddingItemService.acceptResponse(webVO);
        this.saleEbiddingConfirmService.acceptResponse(confirmList);
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setHeadId(webVO.getId());
        sendVO.setElsAccount(webVO.getElsAccount());
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>();
        toSend.put(webVO.getRelationId(), webVO.getToElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
    }

    @Override
    public void updatePurchaseWaiteEbidding(String purchaseHeadId) {
        List<SaleEbiddingHead> dbHeadList = this.getByRelationId(purchaseHeadId);
        long waiteCount = dbHeadList.stream().filter(head -> EbiddingStatusEnum.WAIT_BIDDING.getValue().equals(head.getEbiddingStatus())).count();
        if (waiteCount == (long)dbHeadList.size()) {
            PurchaseEbiddingHead update = new PurchaseEbiddingHead();
            update.setId(purchaseHeadId);
            update.setEbiddingStatus(EbiddingStatusEnum.WAIT_BIDDING.getValue());
            this.purchaseEbiddingHeadMapper.updateById((Object)update);
        }
    }

    @Override
    public void refuseResponse(SaleEbiddingHead dbHead) {
        dbHead.setEbiddingStatus(EbiddingStatusEnum.NOT_JOINING.getValue());
        ((SaleEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
        supplier.setId(dbHead.getSupplierListId());
        supplier.setReplyTime(new Date());
        supplier.setReplyStatus(EbiddingReplyStatusEnum.REJECT.getValue());
        this.purchaseEbiddingSupplierService.updateById((Object)supplier);
    }

    @Override
    public void startEbidding(PurchaseEbiddingHead dbHead, List<String> itemIdList) {
        SaleEbiddingHead saleHead = new SaleEbiddingHead();
        saleHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING.getValue());
        saleHead.setCurrentItemNumber(dbHead.getCurrentItemNumber());
        saleHead.setCurrentMaterialDesc(dbHead.getCurrentMaterialDesc());
        saleHead.setBeginTime(dbHead.getBeginTime());
        saleHead.setStartTime(dbHead.getStartTime());
        saleHead.setEndTime(dbHead.getEndTime());
        saleHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
        this.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.WAIT_BIDDING.getValue()));
        this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getRelationId, itemIdList)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING.getValue()));
    }

    @Override
    public void endEbidding(PurchaseEbiddingHead dbHead, List<String> itemIdList) {
        SaleEbiddingHead saleHead = new SaleEbiddingHead();
        saleHead.setEbiddingStatus(dbHead.getEbiddingStatus());
        saleHead.setCurrentItemNumber(dbHead.getCurrentItemNumber());
        saleHead.setCurrentMaterialDesc(dbHead.getCurrentMaterialDesc());
        saleHead.setBeginTime(dbHead.getBeginTime());
        saleHead.setStartTime(dbHead.getStartTime());
        saleHead.setEndTime(dbHead.getEndTime());
        saleHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
        this.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue()));
        this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getRelationId, itemIdList)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
    }

    private BigDecimal getPrice(String ebiddingType, String ebiddingWay, String quoteType, List<PurchaseEbiddingItem> purchaseItemList) {
        BigDecimal resultPrice = null;
        if (EbiddingWayEnum.SINGLE.getValue().equals(ebiddingWay)) {
            if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
                for (PurchaseEbiddingItem item : purchaseItemList) {
                    BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getPrice() : item.getNetPrice();
                    if (price == null || resultPrice != null && price.compareTo(resultPrice) <= 0) continue;
                    resultPrice = price;
                }
            } else {
                for (PurchaseEbiddingItem item : purchaseItemList) {
                    BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getPrice() : item.getNetPrice();
                    if (price == null || resultPrice != null && price.compareTo(resultPrice) >= 0) continue;
                    resultPrice = price;
                }
            }
        } else if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
            for (PurchaseEbiddingItem item : purchaseItemList) {
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getTotalAmount() : item.getNetTotalAmount();
                if (price == null || resultPrice != null && price.compareTo(resultPrice) <= 0) continue;
                resultPrice = price;
            }
        } else {
            for (PurchaseEbiddingItem item : purchaseItemList) {
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getTotalAmount() : item.getNetTotalAmount();
                if (price == null || resultPrice != null && price.compareTo(resultPrice) >= 0) continue;
                resultPrice = price;
            }
        }
        return resultPrice;
    }

    private void checkStartPrice(SaleEbiddingHead dbHead, String ebiddingType, BigDecimal startPrice, BigDecimal webPrice) {
        boolean flag;
        if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType) && "1".equals(dbHead.getSetStartPrice())) {
            flag = startPrice == null || startPrice.compareTo(BigDecimal.ZERO) == 0 || startPrice.compareTo(webPrice) <= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_idOuWsulTfUEUAAu_dc6d22a8", (String)"\u6b63\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
        }
        if (EbiddingTypeEnum.REVERSE_BID.getValue().equals(ebiddingType) && "1".equals(dbHead.getSetStartPrice())) {
            flag = startPrice == null || startPrice.compareTo(BigDecimal.ZERO) == 0 || startPrice.compareTo(webPrice) >= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_vdOuWsulTXUEUAAu_53224de6", (String)"\u53cd\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
        }
    }

    private void checkQuote(SaleEbiddingHead dbSaleHead, List<SaleEbiddingItem> quoteList, Map<String, SaleEbiddingItem> dbItemMap, Date currentTime, PurchaseEbiddingSupplier supplier, Map<String, List<PurchaseEbiddingItem>> purchaseMap) {
        BigDecimal dbPrice;
        BigDecimal webPrice;
        SaleEbiddingItem currentItem;
        SaleEbiddingItem quoteItem;
        String supplierShow;
        Assert.isTrue((boolean)dbSaleHead.getEndTime().after(currentTime), (String)I18nUtil.translate((String)"i18n_alert_OuyWKIIuWxOsuW_f1045134", (String)"\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u5df2\u5230\uff0c\u4e0d\u80fd\u62a5\u4ef7\uff01"));
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING.getValue().equals(dbSaleHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjOuszEnqsu_10a99734", (String)"\u53ea\u6709\u7ade\u4ef7\u4e2d\u72b6\u6001\u624d\u53ef\u62a5\u4ef7"));
        if ("1".equals(dbSaleHead.getNeedEcho())) {
            Assert.isTrue((boolean)EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus()), (String)I18nUtil.translate((String)"i18n_alert_dBSnqsu_7140f4af", (String)"\u5e94\u6807\u540e\u624d\u53ef\u62a5\u4ef7"));
        }
        for (SaleEbiddingItem quoteItem2 : quoteList) {
            if (quoteItem2.getExpiryDate() == null || quoteItem2.getEffectiveDate() == null || !quoteItem2.getEffectiveDate().after(quoteItem2.getExpiryDate())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBAxOfUKXBAW_70448216", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65e5\u671f\uff01"));
        }
        String ebiddingType = dbSaleHead.getEbiddingType();
        String string = supplierShow = dbSaleHead.getSupplierShow() == null ? "" : dbSaleHead.getSupplierShow();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            quoteItem = quoteList.get(0);
            currentItem = dbItemMap.get(quoteItem.getItemNumber());
            Assert.isTrue((boolean)quoteItem.getItemNumber().equals(dbSaleHead.getCurrentItemNumber()), (String)I18nUtil.translate((String)"i18n_alert_rSLxqsu_4c371469", (String)"\u8be5\u7269\u6599\u4e0d\u53ef\u62a5\u4ef7"));
            webPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem.getPrice() : quoteItem.getNetPrice();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            this.checkStartPrice(dbSaleHead, ebiddingType, currentItem.getStartPrice(), webPrice);
            dbPrice = supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) ? this.getPrice(ebiddingType, EbiddingWayEnum.SINGLE.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get(quoteItem.getItemNumber())) : (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem.getPrice() : currentItem.getNetPrice());
        } else if (EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            quoteItem = quoteList.get(0);
            currentItem = dbItemMap.get("1");
            webPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem.getTotalAmount() : quoteItem.getNetTotalAmount();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            this.checkStartPrice(dbSaleHead, ebiddingType, dbSaleHead.getStartTotalAmount(), webPrice);
            dbPrice = supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) ? this.getPrice(ebiddingType, EbiddingWayEnum.PACKAGE.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get("1")) : (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem.getTotalAmount() : currentItem.getNetTotalAmount());
        } else {
            SaleEbiddingItem currentItem2 = dbItemMap.get("1");
            BigDecimal quotePrice = BigDecimal.ZERO;
            for (SaleEbiddingItem quoteItem3 : quoteList) {
                BigDecimal itemPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem3.getPrice() : quoteItem3.getNetPrice();
                Assert.notNull((Object)itemPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                BigDecimal requireQuantity = quoteItem3.getRequireQuantity() == null ? BigDecimal.ONE : quoteItem3.getRequireQuantity();
                quotePrice = quotePrice.add(itemPrice.multiply(requireQuantity));
            }
            webPrice = quotePrice;
            this.checkStartPrice(dbSaleHead, ebiddingType, dbSaleHead.getStartTotalAmount(), webPrice);
            if (supplierShow.contains(EbiddingShowEnum.PRICE.getValue())) {
                dbPrice = this.getPrice(ebiddingType, EbiddingWayEnum.BATCH.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get("1"));
            } else {
                BigDecimal bigDecimal = dbPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem2.getTotalAmount() : currentItem2.getNetTotalAmount();
            }
        }
        if (dbPrice != null && dbPrice.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal changeRange = dbSaleHead.getChangeRange();
            String rangeUnit = dbSaleHead.getRangeUnit();
            if (EbiddingRangeUnitEnum.PERCENT.getValue().equals(rangeUnit)) {
                changeRange = dbPrice.multiply(changeRange.divide(BigDecimal.valueOf(100L), 6, 4));
            }
            log.info("checkQuote->webPrice:{},dbPrice:{}, flag:{}", new Object[]{webPrice, dbPrice, webPrice.subtract(changeRange).compareTo(dbPrice)});
            boolean flag = EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType) ? webPrice.subtract(changeRange).compareTo(dbPrice) >= 0 : webPrice.add(changeRange).compareTo(dbPrice) <= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_APsuxBnOuBzWVVVsuW_6e488384", (String)"\u5f53\u524d\u62a5\u4ef7\u4e0d\u7b26\u5408\u7ade\u4ef7\u5e45\u5ea6\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\uff01"));
            BigDecimal changeRangeUpper = dbSaleHead.getChangeRangeUpper();
            if (changeRangeUpper != null && changeRangeUpper.compareTo(BigDecimal.ZERO) != 0) {
                if (EbiddingRangeUnitEnum.PERCENT.getValue().equals(rangeUnit)) {
                    changeRangeUpper = dbPrice.multiply(changeRangeUpper.divide(BigDecimal.valueOf(100L), 6, 4));
                }
                boolean upperFlag = EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType) ? webPrice.subtract(changeRangeUpper).compareTo(dbPrice) < 0 : webPrice.add(changeRangeUpper).compareTo(dbPrice) > 0;
                Assert.isTrue((boolean)upperFlag, (String)I18nUtil.translate((String)"i18n_alert_APsuBRBzXWWVVVsuW_d9dc1bcc", (String)"\u5f53\u524d\u62a5\u4ef7\u8d85\u8fc7\u5e45\u5ea6\u4e0a\u9650\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\uff01"));
            }
        }
    }

    private void autoDelay(SaleEbiddingHead dbSaleHead) {
        int delayMinute = dbSaleHead.getDelayMinute() == null ? 1 : dbSaleHead.getDelayMinute();
        DateTime endTime = DateUtil.offsetMinute((Date)dbSaleHead.getEndTime(), (int)delayMinute);
        SaleEbiddingHead updateSaleHead = new SaleEbiddingHead();
        updateSaleHead.setEndTime((Date)endTime);
        int currentDelayCount = dbSaleHead.getCurrentDelayCount() == null ? 0 : dbSaleHead.getCurrentDelayCount();
        updateSaleHead.setCurrentDelayCount(currentDelayCount + 1);
        ((SaleEbiddingHeadMapper)this.baseMapper).update((Object)updateSaleHead, (Wrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbSaleHead.getRelationId()));
        PurchaseEbiddingHead purchaseHead = new PurchaseEbiddingHead();
        purchaseHead.setId(dbSaleHead.getRelationId());
        purchaseHead.setEndTime((Date)endTime);
        purchaseHead.setCurrentDelayCount(updateSaleHead.getCurrentDelayCount());
        this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
        EbiddingJobUtil.updateEndJob(dbSaleHead, (Date)endTime);
    }

    private void checkDelay(SaleEbiddingHead dbSaleHead, Date currentTime) {
        String delayRule = dbSaleHead.getDelayRule();
        if (!EbiddingDelayRuleEnum.NOT_ALLOW_DELAY.getValue().equals(delayRule)) {
            int beforeEndMinute = dbSaleHead.getBeforeEndMinute() == null ? 1 : dbSaleHead.getBeforeEndMinute();
            Date endTime = dbSaleHead.getEndTime();
            DateTime checkDate = DateUtil.offsetMinute((Date)currentTime, (int)beforeEndMinute);
            if (checkDate.compareTo(endTime) > 0) {
                if (EbiddingDelayRuleEnum.LIMIT_DELAY_COUNT.getValue().equals(delayRule)) {
                    int currentDelayCount;
                    int delayCount = dbSaleHead.getDelayCount() == null ? 1 : dbSaleHead.getDelayCount();
                    int n = currentDelayCount = dbSaleHead.getCurrentDelayCount() == null ? 0 : dbSaleHead.getCurrentDelayCount();
                    if (delayCount > currentDelayCount) {
                        this.autoDelay(dbSaleHead);
                    }
                } else {
                    this.autoDelay(dbSaleHead);
                }
            }
        }
    }

    private void compute(SaleEbiddingHead dbSaleHead, List<SaleEbiddingItem> quoteList, Map<String, SaleEbiddingItem> dbItemMap, Date currentTime) {
        SaleEbiddingItem currentItem;
        SaleEbiddingItem quoteItem;
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            BigDecimal requireQuantity;
            quoteItem = quoteList.get(0);
            currentItem = dbItemMap.get(quoteItem.getItemNumber());
            BigDecimal bigDecimal = requireQuantity = currentItem.getRequireQuantity() == null ? BigDecimal.ONE : currentItem.getRequireQuantity();
            if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType())) {
                BigDecimal price = quoteItem.getPrice();
                BigDecimal netPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(currentItem.getTaxRate(), price);
                quoteItem.setNetPrice(netPrice);
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
            } else {
                BigDecimal netPrice = quoteItem.getNetPrice();
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(currentItem.getTaxRate(), netPrice);
                quoteItem.setPrice(price);
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
            }
        } else if (EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            quoteItem = quoteList.get(0);
            currentItem = dbItemMap.get(quoteItem.getItemNumber());
            if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType())) {
                BigDecimal totalAmount = quoteItem.getTotalAmount();
                BigDecimal netTotalAmount = EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(currentItem.getTaxRate(), totalAmount);
                quoteItem.setNetTotalAmount(netTotalAmount);
            } else {
                BigDecimal netTotalAmount = quoteItem.getNetTotalAmount();
                BigDecimal totalAmount = EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(currentItem.getTaxRate(), netTotalAmount);
                quoteItem.setTotalAmount(totalAmount);
            }
        } else {
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal netTotalAmount = BigDecimal.ZERO;
            for (SaleEbiddingItem quoteItem2 : quoteList) {
                BigDecimal requireQuantity;
                SaleEbiddingItem currentItem2 = dbItemMap.get(quoteItem2.getItemNumber());
                BigDecimal bigDecimal = requireQuantity = currentItem2.getRequireQuantity() == null ? BigDecimal.ONE : currentItem2.getRequireQuantity();
                if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType())) {
                    BigDecimal price = quoteItem2.getPrice();
                    BigDecimal netPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(currentItem2.getTaxRate(), price);
                    quoteItem2.setNetPrice(netPrice);
                    quoteItem2.setTaxAmount(price.multiply(requireQuantity));
                    totalAmount = totalAmount.add(quoteItem2.getTaxAmount());
                    quoteItem2.setNetAmount(netPrice.multiply(requireQuantity));
                    netTotalAmount = netTotalAmount.add(quoteItem2.getNetAmount());
                    continue;
                }
                BigDecimal netPrice = quoteItem2.getNetPrice();
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(currentItem2.getTaxRate(), netPrice);
                quoteItem2.setPrice(price);
                quoteItem2.setTaxAmount(price.multiply(requireQuantity));
                totalAmount = totalAmount.add(quoteItem2.getTaxAmount());
                quoteItem2.setNetAmount(netPrice.multiply(requireQuantity));
                netTotalAmount = netTotalAmount.add(quoteItem2.getNetAmount());
            }
            for (SaleEbiddingItem quoteItem2 : quoteList) {
                quoteItem2.setTotalAmount(totalAmount);
                quoteItem2.setNetTotalAmount(netTotalAmount);
            }
        }
        for (SaleEbiddingItem quoteItem3 : quoteList) {
            SaleEbiddingItem currentItem3 = dbItemMap.get(quoteItem3.getItemNumber());
            quoteItem3.setHeadId(dbSaleHead.getId());
            quoteItem3.setQuoteTime(currentTime);
            quoteItem3.setQuoteCount(currentItem3.getQuoteCount() == null ? 1 : currentItem3.getQuoteCount() + 1);
            quoteItem3.setQuoteIp(IPUtils.getIpAddr());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void quotePrice(SaleEbiddingHeadVO saleHeadVO) {
        Date currentTime = new Date();
        SaleEbiddingHead dbSaleHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)saleHeadVO.getId())));
        List<SaleEbiddingItem> quoteList = saleHeadVO.getSaleEbiddingItemList();
        Map<String, SaleEbiddingItem> dbItemMap = this.saleEbiddingItemService.selectByMainId(saleHeadVO.getId()).stream().collect(Collectors.toMap(SaleEbiddingItem::getItemNumber, Function.identity(), (newVal, oldVal) -> oldVal));
        PurchaseEbiddingSupplier supplier = (PurchaseEbiddingSupplier)((Object)this.purchaseEbiddingSupplierService.getById((Serializable)((Object)dbSaleHead.getSupplierListId())));
        Map<String, List<PurchaseEbiddingItem>> purchaseMap = this.purchaseEbiddingItemMapper.selectByMainId(dbSaleHead.getRelationId()).stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
        this.checkQuote(dbSaleHead, quoteList, dbItemMap, currentTime, supplier, purchaseMap);
        this.checkDelay(dbSaleHead, currentTime);
        this.compute(dbSaleHead, quoteList, dbItemMap, currentTime);
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            SaleEbiddingItem quoteItem = quoteList.get(0);
            int count = this.saleEbiddingItemMapper.updateById((Object)quoteItem);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            PurchaseEbiddingItem purchaseItem = this.getPurchaseItemByQuote(dbSaleHead, quoteItem);
            this.purchaseEbiddingItemMapper.updateById((Object)purchaseItem);
        } else if (EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            SaleEbiddingItem quoteItem = quoteList.get(0);
            this.saleEbiddingItemMapper.quotePriceByHeadId(quoteItem);
            PurchaseEbiddingItem purchaseItem = this.getPurchaseItemByQuote(dbSaleHead, quoteItem);
            this.purchaseEbiddingItemMapper.quotePriceByHeadId(purchaseItem);
        } else {
            ArrayList<PurchaseEbiddingItem> purchaseList = new ArrayList<PurchaseEbiddingItem>();
            for (SaleEbiddingItem quoteItem : quoteList) {
                purchaseList.add(this.getPurchaseItemByQuote(dbSaleHead, quoteItem));
            }
            this.saleEbiddingItemService.updateBatchById(quoteList);
            this.purchaseEbiddingItemService.updateBatchById(purchaseList);
        }
        this.saleEbiddingItemHisService.save(dbSaleHead, quoteList, supplier);
        this.redis.publish("quote-price-topic", (Object)dbSaleHead.getRelationId());
    }

    private PurchaseEbiddingItem getPurchaseItemByQuote(SaleEbiddingHead dbSaleHead, SaleEbiddingItem quoteItem) {
        PurchaseEbiddingItem purchaseItem = new PurchaseEbiddingItem();
        BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)purchaseItem));
        purchaseItem.setId(quoteItem.getRelationId());
        purchaseItem.setHeadId(dbSaleHead.getRelationId());
        purchaseItem.setRelationId(quoteItem.getId());
        purchaseItem.setToElsAccount(dbSaleHead.getElsAccount());
        purchaseItem.setElsAccount(dbSaleHead.getToElsAccount());
        return purchaseItem;
    }

    @Override
    public void priced(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> purchaseItemList, List<PurchaseEbiddingSupplier> supplierList) {
        SaleEbiddingItem saleItem;
        ArrayList<SaleEbiddingItem> saleItemList = new ArrayList<SaleEbiddingItem>();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItem item : purchaseItemList) {
                saleItem = new SaleEbiddingItem();
                saleItem.setId(item.getRelationId());
                saleItem.setItemStatus(item.getItemStatus());
                saleItem.setQuota(item.getQuota());
                saleItemList.add(saleItem);
            }
            this.saleEbiddingItemService.updateBatchById(saleItemList);
        } else {
            for (PurchaseEbiddingItem item : purchaseItemList) {
                saleItem = new SaleEbiddingItem();
                saleItem.setEbiddingNumber(dbHead.getEbiddingNumber());
                saleItem.setElsAccount(item.getToElsAccount());
                saleItem.setToElsAccount(item.getElsAccount());
                saleItem.setCurrentRound(item.getCurrentRound());
                saleItem.setQuota(item.getQuota());
                saleItem.setItemStatus(item.getItemStatus());
                saleItemList.add(saleItem);
            }
            this.saleEbiddingItemMapper.updateBidResultByNumber(saleItemList);
        }
        ArrayList<SaleEbiddingHead> updateHeadList = new ArrayList<SaleEbiddingHead>();
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            SaleEbiddingHead head = new SaleEbiddingHead();
            head.setRelationId(dbHead.getId());
            head.setElsAccount(supplier.getToElsAccount());
            head.setEbiddingStatus(supplier.getBiddingStatus());
            updateHeadList.add(head);
        }
        ((SaleEbiddingHeadMapper)this.baseMapper).updateBidResultByRelationId(updateHeadList);
    }

    @Override
    public void regret(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> itemList) {
        List<SaleEbiddingHead> dbHeadList = ((SaleEbiddingHeadMapper)this.baseMapper).selectByMainId(dbHead.getId());
        dbHeadList.forEach(head -> head.setEbiddingStatus(EbiddingStatusEnum.REGRET.getValue()));
        this.updateBatchById(dbHeadList);
        List headIdList = dbHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.REGRET.getValue()));
    }

    @Override
    public void failed(PurchaseEbiddingHead dbHead) {
        List<SaleEbiddingHead> dbHeadList = ((SaleEbiddingHeadMapper)this.baseMapper).selectByMainId(dbHead.getId());
        dbHeadList.forEach(head -> head.setEbiddingStatus(EbiddingStatusEnum.BID_FAILED.getValue()));
        this.updateBatchById(dbHeadList);
    }

    @Override
    @SrmTransaction
    public void quoteAccept(SaleEbiddingHead dbHead, SaleEbiddingItemHis dbItemHis, SaleEbiddingItem quoteItem, BigDecimal acceptPrice) {
        SaleEbiddingItemHisService hisService = (SaleEbiddingItemHisService)SpringContextUtils.getBean(SaleEbiddingItemHisServiceImpl.class);
        hisService.quoteAccept(dbItemHis);
        quoteItem.setQuoteIp(IPUtils.getIpAddr());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            this.saleEbiddingItemService.updateById((Object)quoteItem);
            PurchaseEbiddingItem item = this.getPurchaseItemByQuote(dbHead, quoteItem);
            this.purchaseEbiddingItemService.updateById((Object)item);
        } else {
            this.saleEbiddingItemMapper.quotePriceByHeadId(quoteItem);
            PurchaseEbiddingItem purchaseItem = this.getPurchaseItemByQuote(dbHead, quoteItem);
            this.purchaseEbiddingItemMapper.quotePriceByHeadId(purchaseItem);
        }
        List<String> headIdList = this.getByRelationId(dbHead.getRelationId()).stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            this.endEbiddingByDutch(dbHead, headIdList);
        } else if (EbiddingTypeEnum.REVERSE_BID.getValue().equals(dbHead.getEbiddingType()) && acceptPrice.compareTo(BigDecimal.ZERO) <= 0) {
            this.endEbiddingByJapan(dbHead, quoteItem, headIdList);
        } else if ("1".equals(dbHead.getPurchaseAutoQuote()) && acceptPrice.compareTo(BigDecimal.ZERO) > 0) {
            this.autoQuotePrice(dbHead.getRelationId(), quoteItem.getRelationId());
        }
        this.redis.publish("quote-price-topic", (Object)dbHead.getRelationId());
    }

    private void endEbiddingByDutch(SaleEbiddingHead dbHead, List<String> headIdList) {
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            String currentItemNumber = dbHead.getCurrentItemNumber();
            String nextItemNumber = String.valueOf(Integer.parseInt(currentItemNumber) + 1);
            SaleEbiddingItem nextItem = this.saleEbiddingItemService.selectOneByMainIdAndItemNumber(dbHead.getId(), nextItemNumber);
            String updateItemNumber = nextItem != null ? nextItemNumber : "";
            String updateMaterialDesc = nextItem != null ? nextItem.getMaterialDesc() : "";
            String updateEbiddingStatus = nextItem != null ? EbiddingStatusEnum.BIDDING.getValue() : EbiddingStatusEnum.BIDDING_END.getValue();
            SaleEbiddingHead saleHead = new SaleEbiddingHead();
            saleHead.setCurrentItemNumber(updateItemNumber);
            saleHead.setCurrentMaterialDesc(updateMaterialDesc);
            saleHead.setEbiddingStatus(updateEbiddingStatus);
            ((SaleEbiddingHeadMapper)this.baseMapper).update((Object)saleHead, (Wrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getRelationId()));
            PurchaseEbiddingHead head = new PurchaseEbiddingHead();
            head.setId(dbHead.getRelationId());
            head.setCurrentItemNumber(updateItemNumber);
            head.setCurrentMaterialDesc(updateMaterialDesc);
            head.setEbiddingStatus(updateEbiddingStatus);
            this.purchaseEbiddingHeadMapper.updateById((Object)head);
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).eq(SaleEbiddingItem::getItemNumber, (Object)currentItemNumber)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getRelationId())).eq(PurchaseEbiddingItem::getItemNumber, (Object)currentItemNumber)).set(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
            if (nextItem != null) {
                this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).eq(SaleEbiddingItem::getItemNumber, (Object)nextItemNumber)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING.getValue()));
                this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getRelationId())).eq(PurchaseEbiddingItem::getItemNumber, (Object)nextItemNumber)).set(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING.getValue()));
                if ("1".equals(dbHead.getPurchaseAutoQuote())) {
                    List<String> purchaseItemIdList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> item.getItemNumber().equals(nextItemNumber)).map(BaseEntity::getId).collect(Collectors.toList());
                    this.autoQuotePrice(dbHead.getRelationId(), purchaseItemIdList);
                }
            }
        } else {
            SaleEbiddingHead saleHead = new SaleEbiddingHead();
            saleHead.setCurrentMaterialDesc("");
            saleHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
            ((SaleEbiddingHeadMapper)this.baseMapper).update((Object)saleHead, (Wrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getRelationId()));
            PurchaseEbiddingHead head = new PurchaseEbiddingHead();
            head.setId(dbHead.getRelationId());
            head.setCurrentMaterialDesc(dbHead.getCurrentMaterialDesc());
            head.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
            this.purchaseEbiddingHeadMapper.updateById((Object)head);
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getRelationId())).set(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
        }
    }

    @Override
    @SrmTransaction
    public void quoteReject(SaleEbiddingHead dbHead, SaleEbiddingItemHis dbItemHis, SaleEbiddingItem quoteItem) {
        SaleEbiddingItemHisService hisService = (SaleEbiddingItemHisService)SpringContextUtils.getBean(SaleEbiddingItemHisServiceImpl.class);
        long rejectCount = hisService.quoteReject(dbItemHis);
        BigDecimal price = dbHead.getEbiddingWay().equals(EbiddingWayEnum.PACKAGE.getValue()) ? dbItemHis.getTotalAmount() : dbItemHis.getPrice();
        if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod())) {
            int quoteRejections;
            int n = quoteRejections = dbHead.getQuoteRejections() == null ? 5 : dbHead.getQuoteRejections();
            if ((long)quoteRejections <= rejectCount || BigDecimal.ZERO.compareTo(price) >= 0) {
                List<String> headIdList = this.getByRelationId(dbHead.getRelationId()).stream().map(BaseEntity::getId).collect(Collectors.toList());
                this.endEbiddingByJapan(dbHead, quoteItem, headIdList);
            } else if ("1".equals(dbHead.getPurchaseAutoQuote())) {
                this.autoQuotePrice(dbHead.getRelationId(), quoteItem.getRelationId());
            }
        } else if ("1".equals(dbHead.getPurchaseAutoQuote())) {
            this.autoQuotePrice(dbHead.getRelationId(), quoteItem.getRelationId());
        }
        this.redis.publish("quote-price-topic", (Object)dbHead.getRelationId());
    }

    private void endEbiddingByJapan(SaleEbiddingHead dbHead, SaleEbiddingItem quoteItem, List<String> headIdList) {
        PurchaseEbiddingHead purchaseHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)dbHead.getRelationId())));
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            String saleItemId = quoteItem.getId();
            String purchaseItemId = quoteItem.getRelationId();
            SaleEbiddingItem saleItem = new SaleEbiddingItem();
            saleItem.setId(saleItemId);
            saleItem.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue());
            this.saleEbiddingItemService.updateById((Object)saleItem);
            PurchaseEbiddingItem purchaseItem = new PurchaseEbiddingItem();
            purchaseItem.setId(purchaseItemId);
            purchaseItem.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue());
            this.purchaseEbiddingItemMapper.updateById((Object)purchaseItem);
            if ("1".equals(purchaseHead.getRespectiveQuotations())) {
                List<SaleEbiddingItem> dbSaleItemList = this.saleEbiddingItemService.selectByMainId(dbHead.getId());
                long endItemCount = dbSaleItemList.stream().filter(item -> EbiddingItemStatusEnum.BIDDING_END.getValue().equals(item.getItemStatus())).count();
                if (endItemCount == (long)dbSaleItemList.size()) {
                    dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
                    this.updateById((Object)dbHead);
                    List<SaleEbiddingHead> dbHeadList = this.getByRelationId(dbHead.getRelationId());
                    long endHeadCount = dbHeadList.stream().filter(head -> EbiddingStatusEnum.BIDDING_END.getValue().equals(head.getEbiddingStatus())).count();
                    if (endHeadCount == (long)dbHeadList.size()) {
                        purchaseHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
                        this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
                    }
                }
            } else {
                String currentItemNumber = dbHead.getCurrentItemNumber() == null ? "1" : dbHead.getCurrentItemNumber();
                String nextItemNumber = String.valueOf(Integer.parseInt(currentItemNumber) + 1);
                SaleEbiddingItem nextItem = this.saleEbiddingItemService.selectOneByMainIdAndItemNumber(dbHead.getId(), nextItemNumber);
                if (nextItem == null) {
                    dbHead.setCurrentItemNumber("");
                    dbHead.setCurrentMaterialDesc("");
                    dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
                    this.updateById((Object)dbHead);
                    List<SaleEbiddingHead> dbHeadList = this.getByRelationId(dbHead.getRelationId());
                    long endHeadCount = dbHeadList.stream().filter(head -> EbiddingStatusEnum.BIDDING_END.getValue().equals(head.getEbiddingStatus())).count();
                    if (endHeadCount == (long)dbHeadList.size()) {
                        purchaseHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
                        this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
                    }
                } else {
                    List currentItemList = this.purchaseEbiddingItemMapper.selectByMainId(dbHead.getRelationId()).stream().filter(item -> currentItemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                    long endCount = currentItemList.stream().filter(item -> EbiddingItemStatusEnum.BIDDING_END.getValue().equals(item.getItemStatus())).count();
                    if (endCount == (long)currentItemList.size()) {
                        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getRelationId())).set(SaleEbiddingHead::getCurrentItemNumber, (Object)nextItemNumber)).set(SaleEbiddingHead::getCurrentMaterialDesc, (Object)nextItem.getMaterialDesc())).set(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue()));
                        PurchaseEbiddingHead head2 = new PurchaseEbiddingHead();
                        head2.setId(dbHead.getRelationId());
                        head2.setCurrentItemNumber(nextItemNumber);
                        head2.setCurrentMaterialDesc(nextItem.getMaterialDesc());
                        head2.setEbiddingStatus(EbiddingStatusEnum.BIDDING.getValue());
                        this.purchaseEbiddingHeadMapper.updateById((Object)head2);
                        this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getHeadId, headIdList)).eq(SaleEbiddingItem::getItemNumber, (Object)nextItemNumber)).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING.getValue()));
                        this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getRelationId())).eq(PurchaseEbiddingItem::getItemNumber, (Object)nextItemNumber)).set(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING.getValue()));
                        if ("1".equals(dbHead.getPurchaseAutoQuote())) {
                            List<String> purchaseItemIdList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> item.getItemNumber().equals(nextItemNumber)).map(BaseEntity::getId).collect(Collectors.toList());
                            this.autoQuotePrice(dbHead.getRelationId(), purchaseItemIdList);
                        }
                    } else {
                        dbHead.setCurrentItemNumber(nextItemNumber);
                        dbHead.setCurrentMaterialDesc(nextItem.getMaterialDesc());
                        this.updateById((Object)dbHead);
                    }
                }
            }
        } else {
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingItem::getHeadId, (Object)dbHead.getId())).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getRelationId())).eq(PurchaseEbiddingItem::getToElsAccount, (Object)dbHead.getElsAccount())).set(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING_END.getValue()));
            dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
            this.updateById((Object)dbHead);
            List<SaleEbiddingHead> dbHeadList = this.getByRelationId(dbHead.getRelationId());
            long endHeadCount = dbHeadList.stream().filter(head -> EbiddingStatusEnum.BIDDING_END.getValue().equals(head.getEbiddingStatus())).count();
            if (endHeadCount == (long)dbHeadList.size()) {
                purchaseHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
                this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
            }
        }
    }

    private void autoQuotePrice(PurchaseEbiddingHead purchaseDbHead, String purchaseItemId) {
        BigDecimal quotePrice;
        PurchaseEbiddingItemService purchaseEbiddingItemService = (PurchaseEbiddingItemService)SpringContextUtils.getBean(PurchaseEbiddingItemServiceImpl.class);
        PurchaseEbiddingItem dbItem = (PurchaseEbiddingItem)((Object)purchaseEbiddingItemService.getById((Serializable)((Object)purchaseItemId)));
        PurchaseEbiddingItemHisService purchaseEbiddingItemHisService = (PurchaseEbiddingItemHisService)SpringContextUtils.getBean(PurchaseEbiddingItemHisServiceImpl.class);
        PurchaseEbiddingItem quoteItem = new PurchaseEbiddingItem();
        BeanUtils.copyProperties((Object)((Object)dbItem), (Object)((Object)quoteItem));
        purchaseEbiddingItemHisService.queryAddQuoteSite(purchaseDbHead, quoteItem);
        if (EbiddingWayEnum.SINGLE.getValue().equals(purchaseDbHead.getEbiddingWay())) {
            quotePrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(purchaseDbHead.getQuoteType()) ? quoteItem.getNetPrice() : quoteItem.getPrice();
        } else {
            BigDecimal bigDecimal = quotePrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(purchaseDbHead.getQuoteType()) ? quoteItem.getNetTotalAmount() : quoteItem.getTotalAmount();
        }
        if (quotePrice != null) {
            PurchaseEbiddingHeadService purchaseEbiddingHeadService = (PurchaseEbiddingHeadService)SpringContextUtils.getBean(PurchaseEbiddingHeadServiceImpl.class);
            purchaseEbiddingHeadService.quote(purchaseDbHead, dbItem, quoteItem);
        }
    }

    private void autoQuotePrice(String purchaseHeadId, List<String> purchaseItemIdList) {
        PurchaseEbiddingHead purchaseDbHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)purchaseHeadId)));
        for (String purchaseItemId : purchaseItemIdList) {
            this.autoQuotePrice(purchaseDbHead, purchaseItemId);
        }
    }

    private void autoQuotePrice(String purchaseHeadId, String purchaseItemId) {
        PurchaseEbiddingHead purchaseDbHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)purchaseHeadId)));
        this.autoQuotePrice(purchaseDbHead, purchaseItemId);
    }

    @Override
    public List<SaleEbiddingHead> getByRelationId(String relationId) {
        return ((SaleEbiddingHeadMapper)this.baseMapper).selectByMainId(relationId);
    }
}

