/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.calibration.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetter;
import com.els.modules.tender.attachment.entity.PurchaseTenderPriceOpeningsTemplate;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterService;
import com.els.modules.tender.attachment.service.PurchaseTenderPriceOpeningsTemplateService;
import com.els.modules.tender.attachment.vo.TenderFieldCategoryPriceVo;
import com.els.modules.tender.calibration.entity.BidWinningAffirmHead;
import com.els.modules.tender.calibration.entity.BidWinningAffirmItem;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmHeadStatusEnum;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmItemStatusEnum;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmTypeStatusEnum;
import com.els.modules.tender.calibration.mapper.BidWinningAffirmHeadMapper;
import com.els.modules.tender.calibration.service.BidWinningAffirmHeadService;
import com.els.modules.tender.calibration.service.BidWinningAffirmItemService;
import com.els.modules.tender.calibration.vo.BidWinningAffirmHeadVO;
import com.els.modules.tender.calibration.vo.BidWinningAffirmPriceItemVo;
import com.els.modules.tender.column.enumerate.CustomerFieldCategoryEnum;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidWinningCandidate;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidWinningCandidateService;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.sale.vo.SaleQuoteColumnVO;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BidWinningAffirmHeadServiceImpl
extends BaseServiceImpl<BidWinningAffirmHeadMapper, BidWinningAffirmHead>
implements BidWinningAffirmHeadService {
    private static final Logger log = LoggerFactory.getLogger(BidWinningAffirmHeadServiceImpl.class);
    @Autowired
    private BidWinningAffirmItemService bidWinningAffirmItemService;
    @Autowired
    private PurchaseTenderProjectBidWinningCandidateService bidWinningCandidateService;
    @Autowired
    private TenderProjectSupplierService supplierService;
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseTenderBidLetterService tenderBidLetterService;
    @Autowired
    private PurchaseTenderPriceOpeningsTemplateService purchasePriceOpeningsService;
    @Autowired
    private SaleTenderPriceOpeningsService salePriceOpeningsService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(BidWinningAffirmHead purchaseTenderProjectBidWinningAffirmHead, List<BidWinningAffirmItem> purchaseTenderProjectBidWinningAffirmItemList, List<PurchaseAttachmentDTO> attachmentList) {
        purchaseTenderProjectBidWinningAffirmHead.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseTenderProjectBidWinningAffirmHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        purchaseTenderProjectBidWinningAffirmHead.setStatus(BidWinningAffirmHeadStatusEnum.NEW.getValue());
        purchaseTenderProjectBidWinningAffirmHead.setAffirmNumber(this.invokeBaseRpcService.getNextCode("tenderWinningAffirmNumber", (Object)purchaseTenderProjectBidWinningAffirmHead));
        ((BidWinningAffirmHeadMapper)this.baseMapper).insert((Object)purchaseTenderProjectBidWinningAffirmHead);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseTenderProjectBidWinningAffirmHead.getId());
        attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(purchaseTenderProjectBidWinningAffirmHead.getId()));
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentList);
        this.insertData(purchaseTenderProjectBidWinningAffirmHead, purchaseTenderProjectBidWinningAffirmItemList);
        if ("0".equals(purchaseTenderProjectBidWinningAffirmHead.getAffirmType())) {
            this.updateTenderProjectSubpackageInfo(purchaseTenderProjectBidWinningAffirmHead, TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_EDIT.getValue() + "");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(BidWinningAffirmHead purchaseTenderProjectBidWinningAffirmHead, List<BidWinningAffirmItem> purchaseTenderProjectBidWinningAffirmItemList, List<PurchaseAttachmentDTO> attachmentList) {
        purchaseTenderProjectBidWinningAffirmHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        purchaseTenderProjectBidWinningAffirmHead.setStatus(BidWinningAffirmHeadStatusEnum.NEW.getValue());
        if (StringUtils.isBlank((CharSequence)purchaseTenderProjectBidWinningAffirmHead.getAffirmNumber())) {
            purchaseTenderProjectBidWinningAffirmHead.setAffirmNumber(this.invokeBaseRpcService.getNextCode("tenderWinningAffirmNumber", (Object)purchaseTenderProjectBidWinningAffirmHead));
        }
        int count = ((BidWinningAffirmHeadMapper)this.baseMapper).updateById((Object)purchaseTenderProjectBidWinningAffirmHead);
        this.bidWinningAffirmItemService.deleteByMainId(purchaseTenderProjectBidWinningAffirmHead.getId());
        this.insertData(purchaseTenderProjectBidWinningAffirmHead, purchaseTenderProjectBidWinningAffirmItemList);
        if ("0".equals(purchaseTenderProjectBidWinningAffirmHead.getAffirmType())) {
            this.updateTenderProjectSubpackageInfo(purchaseTenderProjectBidWinningAffirmHead, TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_EDIT.getValue() + "");
        }
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseTenderProjectBidWinningAffirmHead.getId());
        attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(purchaseTenderProjectBidWinningAffirmHead.getId()));
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(BidWinningAffirmHead purchaseTenderProjectBidWinningAffirmHead) {
        BidWinningAffirmHead bidWinningAffirmHead = (BidWinningAffirmHead)((Object)((BidWinningAffirmHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseTenderProjectBidWinningAffirmHead.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)bidWinningAffirmHead)), (String)I18nUtil.translate((String)"i18n_alert_VWsMWFW_50306557", (String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e!"));
        Assert.isTrue((boolean)BidWinningAffirmHeadStatusEnum.NEW.getValue().equals(bidWinningAffirmHead.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_APzExqDJUzW_9316aa0e", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u63d0\u4ea4\u5ba1\u6279!"));
        bidWinningAffirmHead.setStatus(BidWinningAffirmHeadStatusEnum.AUDIT.getValue());
        String businessType = "bidWinningAffirm";
        String auditSubject = "\u4e2d\u6807\u5019\u9009\u4eba\u786e\u8ba4\u5355\u53f7:";
        if (BidWinningAffirmTypeStatusEnum.RE_CONFIRM.getValue().equals(purchaseTenderProjectBidWinningAffirmHead.getAffirmType())) {
            businessType = "againBidWinningAffirm";
            auditSubject = "\u4e2d\u6807\u5019\u9009\u4eba\u91cd\u65b0\u786e\u8ba4\u5355\u53f7:";
        }
        AuditInputParamDTO dto = new AuditInputParamDTO();
        dto.setBusinessId(purchaseTenderProjectBidWinningAffirmHead.getId());
        dto.setBusinessType(businessType);
        dto.setAuditSubject(auditSubject + purchaseTenderProjectBidWinningAffirmHead.getAffirmNumber());
        dto.setParams(JSONObject.toJSONString((Object)((Object)purchaseTenderProjectBidWinningAffirmHead)));
        this.inquiryInvokeWorkFlowRpcService.submit(dto);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateAuditStatus(String id, String processInstanceId, String auditStatus, String bpmnType) {
        BidWinningAffirmHead bidWinningAffirmHead = (BidWinningAffirmHead)((Object)this.getById((Serializable)((Object)id)));
        bidWinningAffirmHead.setFlowId(processInstanceId);
        bidWinningAffirmHead.setAuditStatus(auditStatus);
        bidWinningAffirmHead.setWorkFlowType(bpmnType);
        String status = null;
        String subPackageStatus = null;
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            status = BidWinningAffirmHeadStatusEnum.FINISH.getValue();
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_AUDIT.getValue() + "";
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_REJECT.getValue() + "";
            status = BidWinningAffirmHeadStatusEnum.NEW.getValue();
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            status = BidWinningAffirmHeadStatusEnum.NEW.getValue();
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_EDIT.getValue() + "";
        } else {
            status = BidWinningAffirmHeadStatusEnum.AUDIT.getValue();
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_AUDIT.getValue() + "";
        }
        if ("0".equals(bidWinningAffirmHead.getAffirmType())) {
            this.updateTenderProjectSubpackageInfo(bidWinningAffirmHead, subPackageStatus);
        }
        bidWinningAffirmHead.setStatus(status);
        this.updateById((Object)bidWinningAffirmHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(BidWinningAffirmHead bidWinningAffirmHead) {
        BidWinningAffirmHead bidWinningAffirm = (BidWinningAffirmHead)((Object)this.getById((Serializable)((Object)bidWinningAffirmHead.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)bidWinningAffirm)), (String)I18nUtil.translate((String)"i18n_alert_sBSiLRLVHxMKW_8e091838", (String)"\u4e2d\u6807\u5019\u9009\u4eba\u786e\u8ba4\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        bidWinningAffirm.setStatus(BidWinningAffirmHeadStatusEnum.FINISH.getValue());
        bidWinningAffirm.setPublishTime(new Date());
        this.updateById((Object)bidWinningAffirm);
        List<BidWinningAffirmItem> winningAffirmItemList = this.bidWinningAffirmItemService.selectByMainId(bidWinningAffirm.getId());
        List affirmSupplierList = winningAffirmItemList.stream().filter(bidWinningAffirmItem -> "1".equals(bidWinningAffirmItem.getAffirm())).map(BidWinningAffirmItem::getSupplierAccount).collect(Collectors.toList());
        TenderProjectSupplier tenderProjectSupplier = new TenderProjectSupplier();
        tenderProjectSupplier.setSubpackageId(bidWinningAffirm.getSubpackageId());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.supplierService.selectBySubpackageId(tenderProjectSupplier);
        for (TenderProjectSupplier supplier : tenderProjectSupplierList) {
            if (affirmSupplierList.contains(supplier.getSupplierAccount())) {
                supplier.setWinner("1");
                continue;
            }
            supplier.setWinner("0");
        }
        this.supplierService.updateBatchById(tenderProjectSupplierList);
        List purchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(bidWinningAffirm.getId());
        if (CollectionUtil.isNotEmpty((Collection)purchaseAttachmentDTOList)) {
            ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOList, bidWinningAffirm.getId(), bidWinningAffirm.getSubpackageId(), bidWinningAffirm.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.TENDER_WINNING_AFFIRM_PREFIX.getValue());
        }
        if ("0".equals(bidWinningAffirm.getAffirmType())) {
            this.updateTenderProjectSubpackageInfo(bidWinningAffirm, TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_PASS.getValue() + "");
        }
    }

    private void updateTenderProjectSubpackageInfo(BidWinningAffirmHead bidWinningAffirmHead, String subPackageStatus) {
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)bidWinningAffirmHead).subpackageId(bidWinningAffirmHead.getSubpackageId()).subpackageStatus(subPackageStatus).build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    private void insertData(BidWinningAffirmHead purchaseTenderProjectBidWinningAffirmHead, List<BidWinningAffirmItem> purchaseTenderProjectBidWinningAffirmItemList) {
        if (!CollectionUtils.isEmpty(purchaseTenderProjectBidWinningAffirmItemList)) {
            for (BidWinningAffirmItem entity : purchaseTenderProjectBidWinningAffirmItemList) {
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
                entity.setHeadId(purchaseTenderProjectBidWinningAffirmHead.getId());
                entity.setStatus(BidWinningAffirmItemStatusEnum.NEW.getValue());
                entity.setId(null);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseTenderProjectBidWinningAffirmHead);
            }
            this.bidWinningAffirmItemService.saveBatch(purchaseTenderProjectBidWinningAffirmItemList, 2000);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.bidWinningAffirmItemService.deleteByMainId(id);
        ((BidWinningAffirmHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.bidWinningAffirmItemService.deleteByMainId(serializable.toString());
            ((BidWinningAffirmHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public List<BidWinningAffirmHead> queryBidWinningBySubpackageAndAffirmType(String subpackageId, String affirmType) {
        return ((BidWinningAffirmHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, affirmType);
    }

    @Override
    public BidWinningAffirmHeadVO queryBidWinningConfirmInfo(BidWinningAffirmHead bidWinningAffirmHead, String affirmType) {
        BidWinningAffirmHeadVO bidWinningAffirmHeadVO = this.queryBidWinningConfirmInitInfoBySubpackage(bidWinningAffirmHead, affirmType);
        if (StringUtils.isNotBlank((CharSequence)bidWinningAffirmHead.getId())) {
            List purchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(bidWinningAffirmHead.getId());
            bidWinningAffirmHeadVO.setAttachmentList(purchaseAttachmentDTOList);
        }
        return bidWinningAffirmHeadVO;
    }

    @Override
    public List<TenderFieldCategoryPriceVo> queryFieldCategoryBySubpackageId(String subpackageId) {
        ArrayList<TenderFieldCategoryPriceVo> priceVoList = new ArrayList<TenderFieldCategoryPriceVo>();
        List<PurchaseTenderBidLetter> purchaseTenderBidLetters = this.tenderBidLetterService.queryPurchaseTenderBidLetter(subpackageId);
        List<String> bidLetters = purchaseTenderBidLetters.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<PurchaseTenderPriceOpeningsTemplate> priceOpeningsTemplates = this.purchasePriceOpeningsService.selectByMainIds(bidLetters);
        Map<String, List<PurchaseTenderPriceOpeningsTemplate>> priceOpeningsMaps = priceOpeningsTemplates.stream().collect(Collectors.groupingBy(PurchaseTenderPriceOpeningsTemplate::getBidLetterId));
        for (PurchaseTenderBidLetter purchaseTenderBidLetter : purchaseTenderBidLetters) {
            TenderFieldCategoryPriceVo tenderFieldCategoryPriceVo = new TenderFieldCategoryPriceVo();
            ArrayList<CustomColumnModel> quoteColumnList = new ArrayList<CustomColumnModel>();
            List<PurchaseTenderPriceOpeningsTemplate> openingsTemplates = priceOpeningsMaps.get(purchaseTenderBidLetter.getId());
            for (PurchaseTenderPriceOpeningsTemplate priceOpeningsTemplate : openingsTemplates) {
                String customizeFieldModel = priceOpeningsTemplate.getCustomizeFieldModel();
                List customColumnModelList = JSONArray.parseArray((String)customizeFieldModel, CustomColumnModel.class);
                List quoteColumns = customColumnModelList.stream().filter(columnModel -> CustomerFieldCategoryEnum.TENDER_OFFERS_COLUMN.getValue().equals(columnModel.getFieldCategory())).collect(Collectors.toList());
                if (!CollectionUtil.isNotEmpty(quoteColumns)) continue;
                quoteColumnList.addAll(quoteColumns);
            }
            if (!CollectionUtil.isNotEmpty(quoteColumnList)) continue;
            tenderFieldCategoryPriceVo.setTitle(purchaseTenderBidLetter.getName());
            tenderFieldCategoryPriceVo.setId(purchaseTenderBidLetter.getId());
            tenderFieldCategoryPriceVo.setQuoteColumnList(quoteColumnList);
            priceVoList.add(tenderFieldCategoryPriceVo);
        }
        return priceVoList;
    }

    @Override
    public BidWinningAffirmHeadVO queryBidWinningConfirmInitInfoBySubpackage(BidWinningAffirmHead bidWinningAffirmHead, String affirmType) {
        BidWinningAffirmHeadVO affirmHeadVO = (BidWinningAffirmHeadVO)((Object)SysUtil.copyProperties((Object)((Object)bidWinningAffirmHead), BidWinningAffirmHeadVO.class));
        List<BidWinningAffirmItem> bidWinningAffirmItemList = null;
        if (bidWinningAffirmHead != null) {
            bidWinningAffirmItemList = this.bidWinningAffirmItemService.selectByMainId(bidWinningAffirmHead.getId());
        }
        if (CollectionUtil.isEmpty(bidWinningAffirmItemList)) {
            if (BidWinningAffirmTypeStatusEnum.CONFIRM.getValue().equals(affirmType)) {
                List<PurchaseTenderProjectBidWinningCandidate> bidWinningCandidateList = this.bidWinningCandidateService.selectBidWinningResultBySubpackageId(bidWinningAffirmHead.getSubpackageId(), null);
                log.info("\u5019\u9009\u4eba\u6570\u636e\uff1a{}", JSON.toJSON(bidWinningCandidateList));
                if (CollectionUtil.isEmpty(bidWinningCandidateList)) {
                    return affirmHeadVO;
                }
                bidWinningAffirmItemList = new ArrayList<BidWinningAffirmItem>();
                bidWinningCandidateList = bidWinningCandidateList.stream().sorted(Comparator.comparing(PurchaseTenderProjectBidWinningCandidate::getTotalScore).reversed()).collect(Collectors.toList());
                for (int i = 0; i < bidWinningCandidateList.size(); ++i) {
                    BidWinningAffirmItem bidWinningAffirmItem = (BidWinningAffirmItem)((Object)SysUtil.copyProperties((Object)((Object)bidWinningCandidateList.get(i)), BidWinningAffirmItem.class));
                    bidWinningAffirmItem.setScopeSort(String.valueOf(i + 1));
                    bidWinningAffirmItemList.add(bidWinningAffirmItem);
                }
            } else {
                List<BidWinningAffirmHead> affirmHeads = this.queryBidWinningBySubpackageAndAffirmType(bidWinningAffirmHead.getSubpackageId(), null);
                if (CollectionUtil.isNotEmpty(affirmHeads)) {
                    BidWinningAffirmHead winningAffirmHead = affirmHeads.get(affirmHeads.size() - 1);
                    bidWinningAffirmItemList = this.bidWinningAffirmItemService.selectByMainId(winningAffirmHead.getId());
                }
            }
        }
        if (CollectionUtil.isEmpty(bidWinningAffirmItemList)) {
            return affirmHeadVO;
        }
        List supplierAccountList = bidWinningAffirmItemList.stream().map(BidWinningAffirmItem::getSupplierAccount).collect(Collectors.toList());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getSubpackageId, (Object)bidWinningAffirmHead.getSubpackageId());
        lambdaQueryWrapper.in(BaseEntity::getElsAccount, supplierAccountList);
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getStageQuote, (Object)"0");
        List saleTenderPriceOpenings = this.salePriceOpeningsService.getBaseMapper().selectList((Wrapper)lambdaQueryWrapper);
        Map<String, List<SaleTenderPriceOpenings>> salePriceOpeningMaps = saleTenderPriceOpenings.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
        ArrayList winningAffirmPriceItemVos = SysUtil.copyProperties(bidWinningAffirmItemList, BidWinningAffirmPriceItemVo.class);
        for (BidWinningAffirmPriceItemVo bidWinningAffirmPriceItemVo : winningAffirmPriceItemVos) {
            List<SaleTenderPriceOpenings> priceOpeningsList = salePriceOpeningMaps.get(bidWinningAffirmPriceItemVo.getSupplierAccount());
            ArrayList<SaleQuoteColumnVO> saleQuoteColumnVOS = new ArrayList<SaleQuoteColumnVO>();
            for (SaleTenderPriceOpenings tenderPriceOpenings : priceOpeningsList) {
                String customizeFieldData = tenderPriceOpenings.getCustomizeFieldData();
                JSONArray dataJsonArray = JSONArray.parseArray((String)customizeFieldData);
                for (int i = 0; i < dataJsonArray.size(); ++i) {
                    JSONObject jsonObject = dataJsonArray.getJSONObject(i);
                    Set keySet = jsonObject.keySet();
                    for (String key : keySet) {
                        SaleQuoteColumnVO saleQuoteColumnVO = new SaleQuoteColumnVO();
                        saleQuoteColumnVO.setBidLetterId(tenderPriceOpenings.getBidLetterId());
                        saleQuoteColumnVO.setField(key);
                        saleQuoteColumnVO.setValue(jsonObject.get((Object)key));
                        saleQuoteColumnVOS.add(saleQuoteColumnVO);
                    }
                }
            }
            bidWinningAffirmPriceItemVo.setSaleQuoteColumnVOS(saleQuoteColumnVOS);
        }
        affirmHeadVO.setBidWinningAffirmPriceItemVoList(winningAffirmPriceItemVos);
        return affirmHeadVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpdate(BidWinningAffirmHead bidWinningAffirmHead, List<BidWinningAffirmItem> bidWinningAffirmItemList, List<PurchaseAttachmentDTO> attachmentList) {
        if (StringUtils.isNotBlank((CharSequence)bidWinningAffirmHead.getId())) {
            this.updateMain(bidWinningAffirmHead, bidWinningAffirmItemList, attachmentList);
        } else {
            this.saveMain(bidWinningAffirmHead, bidWinningAffirmItemList, attachmentList);
        }
        if ("1".equals(bidWinningAffirmHead.getAudit())) {
            this.submit(bidWinningAffirmHead);
            return;
        }
        this.publish(bidWinningAffirmHead);
    }

    @Override
    public List<BidWinningAffirmPriceItemVo> queryAffirmItemVoList(String subpackageId) {
        BidWinningAffirmHead affirmHead = null;
        ArrayList<BidWinningAffirmPriceItemVo> bidWinningAffirmItemVoList = new ArrayList<BidWinningAffirmPriceItemVo>();
        List<BidWinningAffirmHead> winningAffirmHeadList = ((BidWinningAffirmHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, BidWinningAffirmTypeStatusEnum.RE_CONFIRM.getValue());
        if (CollectionUtil.isNotEmpty(winningAffirmHeadList) && null != winningAffirmHeadList.get(winningAffirmHeadList.size() - 1).getPublishTime()) {
            affirmHead = winningAffirmHeadList.get(winningAffirmHeadList.size() - 1);
        } else {
            List<BidWinningAffirmHead> winningConfirmHeadList = ((BidWinningAffirmHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, BidWinningAffirmTypeStatusEnum.CONFIRM.getValue());
            if (CollectionUtil.isNotEmpty(winningConfirmHeadList)) {
                affirmHead = winningConfirmHeadList.get(0);
            }
        }
        if (null == affirmHead) {
            return bidWinningAffirmItemVoList;
        }
        List<BidWinningAffirmItem> bidWinningAffirmItemList = this.bidWinningAffirmItemService.selectByMainId(affirmHead.getId());
        if (CollectionUtil.isNotEmpty(bidWinningAffirmItemList)) {
            bidWinningAffirmItemList = bidWinningAffirmItemList.stream().filter(item -> "1".equals(item.getAffirm())).collect(Collectors.toList());
            Collections.sort(bidWinningAffirmItemList, new Comparator<BidWinningAffirmItem>(){

                @Override
                public int compare(BidWinningAffirmItem o1, BidWinningAffirmItem o2) {
                    Integer scopeSort1 = StringUtils.isBlank((CharSequence)o1.getScopeSort()) ? CommonConstant.STATUS_NO : Integer.valueOf(o1.getScopeSort());
                    Integer scopeSort2 = StringUtils.isBlank((CharSequence)o2.getScopeSort()) ? CommonConstant.STATUS_NO : Integer.valueOf(o2.getScopeSort());
                    return Integer.valueOf(scopeSort2).compareTo(scopeSort1);
                }
            });
        }
        if (CollectionUtil.isEmpty(bidWinningAffirmItemList)) {
            return bidWinningAffirmItemVoList;
        }
        List supplierAccountList = bidWinningAffirmItemList.stream().map(BidWinningAffirmItem::getSupplierAccount).collect(Collectors.toList());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getSubpackageId, (Object)affirmHead.getSubpackageId());
        lambdaQueryWrapper.in(BaseEntity::getElsAccount, supplierAccountList);
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getStageQuote, (Object)"0");
        List saleTenderPriceOpenings = this.salePriceOpeningsService.getBaseMapper().selectList((Wrapper)lambdaQueryWrapper);
        Map<String, List<SaleTenderPriceOpenings>> salePriceOpeningMaps = saleTenderPriceOpenings.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
        ArrayList winningAffirmPriceItemVos = SysUtil.copyProperties(bidWinningAffirmItemList, BidWinningAffirmPriceItemVo.class);
        for (BidWinningAffirmPriceItemVo bidWinningAffirmPriceItemVo : winningAffirmPriceItemVos) {
            List<SaleTenderPriceOpenings> priceOpeningsList = salePriceOpeningMaps.get(bidWinningAffirmPriceItemVo.getSupplierAccount());
            ArrayList<SaleQuoteColumnVO> saleQuoteColumnVOS = new ArrayList<SaleQuoteColumnVO>();
            for (SaleTenderPriceOpenings tenderPriceOpenings : priceOpeningsList) {
                String customizeFieldData = tenderPriceOpenings.getCustomizeFieldData();
                JSONArray dataJsonArray = JSONArray.parseArray((String)customizeFieldData);
                for (int i = 0; i < dataJsonArray.size(); ++i) {
                    JSONObject jsonObject = dataJsonArray.getJSONObject(i);
                    Set keySet = jsonObject.keySet();
                    for (String key : keySet) {
                        SaleQuoteColumnVO saleQuoteColumnVO = new SaleQuoteColumnVO();
                        saleQuoteColumnVO.setBidLetterId(tenderPriceOpenings.getBidLetterId());
                        saleQuoteColumnVO.setField(key);
                        saleQuoteColumnVO.setValue(jsonObject.get((Object)key));
                        saleQuoteColumnVOS.add(saleQuoteColumnVO);
                    }
                }
            }
            bidWinningAffirmPriceItemVo.setSaleQuoteColumnVOS(saleQuoteColumnVOS);
        }
        return winningAffirmPriceItemVos;
    }
}

