/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.project.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.archive.entity.TenderProjectArchiveAttachmentHead;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.service.TenderProjectArchiveAttachmentHeadService;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectItem;
import com.els.modules.tender.project.entity.PurchaseTenderProjectMember;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.PurchaseOrgTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectStatusEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.mapper.PurchaseTenderProjectHeadMapper;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectItemService;
import com.els.modules.tender.project.service.PurchaseTenderProjectMemberService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.tender.project.vo.PurchaseTenderProjectSubpackageInfoVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class PurchaseTenderProjectHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectHeadMapper, PurchaseTenderProjectHead>
implements PurchaseTenderProjectHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectHeadServiceImpl.class);
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService purchaseTenderProjectSubpackageInfoService;
    @Autowired
    private PurchaseTenderProjectItemService purchaseTenderProjectItemService;
    @Autowired
    private PurchaseTenderProjectMemberService purchaseTenderProjectMemberService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseTenderProjectHead purchaseTenderProjectHead, List<PurchaseTenderProjectSubpackageInfoVO> subpackageInfoVOList, List<PurchaseTenderProjectItem> purchaseTenderProjectItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseTenderProjectHead.setTenderProjectNumber(this.invokeBaseRpcService.getNextCode("tenderProjectNumber", (Object)purchaseTenderProjectHead));
        purchaseTenderProjectHead.setElsAccount(TenantContext.getTenant());
        purchaseTenderProjectHead.setTenderStatus(TenderProjectStatusEnum.NEW.getValue());
        super.setHeadDefaultValue((BaseEntity)purchaseTenderProjectHead);
        if ("0".equals(purchaseTenderProjectHead.getAudit())) {
            purchaseTenderProjectHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseTenderProjectHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        purchaseTenderProjectHead.setDeleted(CommonConstant.DEL_FLAG_0);
        this.save((Object)purchaseTenderProjectHead);
        this.insertData(purchaseTenderProjectHead, subpackageInfoVOList, purchaseTenderProjectItemList, purchaseAttachmentList);
    }

    public void checkAndSetParam(PurchaseTenderProjectHead purchaseTenderProjectHead, List<PurchaseTenderProjectSubpackageInfo> purchaseTenderProjectItemList) {
        Assert.isTrue((boolean)StringUtils.hasText((String)purchaseTenderProjectHead.getTenderProjectType()), (String)I18nUtil.translate((String)"i18n_field_YBdIAcxOLVW_5e2b2640", (String)"\u62db\u6807\u9879\u76ee\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((purchaseTenderProjectHead.getProjectBudget() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_YBdIUdxOLVW_ebaedafd", (String)"\u62db\u6807\u9879\u76ee\u9884\u7b97\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((purchaseTenderProjectHead.getProjectBudget().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u62db\u6807\u9879\u76ee\u9884\u7b97\u5fc5\u987b\u8981\u5927\u4e8e\u96f6\uff01"));
        if (PurchaseOrgTypeEnum.SELF_PURCHASE.getValue().equals(purchaseTenderProjectHead.getPurchaseOrgType())) {
            Assert.isTrue((boolean)StringUtils.hasText((String)purchaseTenderProjectHead.getPurchaseExecutorSubAccount()), (String)I18nUtil.translate((String)"i18n_field_nRRcLxOLVW_210d6bc2", (String)"\u91c7\u8d2d\u6267\u884c\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((boolean)purchaseTenderProjectHead.getElsAccount().equals(purchaseTenderProjectHead.getPurchaseExecutorAccount()), (String)I18nUtil.translate((String)"i18n_alert_YBtLUnRRcLxKeIVRW_b401770a", (String)"\u62db\u6807\u5355\u4f4d\u4e0e\u91c7\u8d2d\u6267\u884c\u4eba\u4e0d\u5728\u540c\u4e00\u7ec4\u7ec7\uff01"));
        } else {
            Assert.isTrue((boolean)StringUtils.hasText((String)purchaseTenderProjectHead.getAgencyElsAccount()), (String)I18nUtil.translate((String)"i18n_field_ovtRxOLVW_943d90c4", (String)"\u4ee3\u7406\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((boolean)purchaseTenderProjectHead.getPurchaseExecutorAccount().equals(purchaseTenderProjectHead.getAgencyElsAccount()), (String)I18nUtil.translate((String)"i18n_alert_ovtRUnRRcLxKeIVRW_e4830181", (String)"\u4ee3\u7406\u673a\u6784\u4e0e\u91c7\u8d2d\u6267\u884c\u4eba\u4e0d\u5728\u540c\u4e00\u7ec4\u7ec7\uff01"));
        }
        Assert.isTrue((boolean)StringUtils.hasText((String)purchaseTenderProjectHead.getElsRealname()), (String)I18nUtil.translate((String)"i18n_field_YBLxOLVW_ea4b1a03", (String)"\u62db\u6807\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((!purchaseTenderProjectItemList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_RRPjImzscW_399cd384", (String)"\u81f3\u5c11\u8981\u6709\u4e00\u4e2a\u5206\u5305\u884c\uff01"));
        purchaseTenderProjectItemList.parallelStream().forEach(purchaseTenderProjectItemVO -> {
            Assert.isTrue((boolean)StringUtils.hasText((String)purchaseTenderProjectItemVO.getTenderType()), (String)I18nUtil.translate((String)"i18n_field_YBCKxOLVW_27e1d02f", (String)"\u62db\u6807\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((boolean)StringUtils.hasText((String)purchaseTenderProjectItemVO.getCheckType()), (String)I18nUtil.translate((String)"i18n_field_UJCKxOLVW_e56fad57", (String)"\u5ba1\u67e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((boolean)StringUtils.hasText((String)purchaseTenderProjectItemVO.getProcessType()), (String)I18nUtil.translate((String)"i18n_field_YBLTxOLVW_3bd58f81", (String)"\u62db\u6807\u7a0b\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((boolean)StringUtils.hasText((String)purchaseTenderProjectItemVO.getSubpackageName()), (String)I18nUtil.translate((String)"i18n_field_zsRLxOLVW_44e428af", (String)"\u5206\u5305\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        });
    }

    @Override
    public void insertData(PurchaseTenderProjectHead purchaseTenderProjectHead, List<PurchaseTenderProjectSubpackageInfoVO> subpackageInfoVOList, List<PurchaseTenderProjectItem> purchaseTenderProjectItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        ArrayList subpackageInfoList = SysUtil.copyProperties(subpackageInfoVOList, PurchaseTenderProjectSubpackageInfo.class);
        List nextCodes = this.invokeBaseRpcService.getNextCodes("subpackageNumber", (Object)subpackageInfoList, subpackageInfoList.size());
        if (CollectionUtil.isNotEmpty((Collection)subpackageInfoList)) {
            int index = 0;
            for (PurchaseTenderProjectSubpackageInfo subpackageInfo : subpackageInfoList) {
                subpackageInfo.setHeadId(purchaseTenderProjectHead.getId());
                subpackageInfo.setTenderProjectName(purchaseTenderProjectHead.getTenderProjectName());
                subpackageInfo.setSubpackageNumber((String)nextCodes.get(index++));
                subpackageInfo.setStatus(TenderProjectSubpackageStatusEnum.NEW.getValue());
                subpackageInfo.setDeleted(CommonConstant.DEL_FLAG_0);
            }
            this.purchaseTenderProjectSubpackageInfoService.delMain(purchaseTenderProjectHead.getId());
            this.purchaseTenderProjectSubpackageInfoService.saveBatch(subpackageInfoList, 1000);
        }
        if (CollectionUtil.isNotEmpty(purchaseTenderProjectItemList)) {
            int itemNumber = 1;
            for (PurchaseTenderProjectItem purchaseTenderProjectItem : purchaseTenderProjectItemList) {
                purchaseTenderProjectItem.setHeadId(purchaseTenderProjectHead.getId());
                purchaseTenderProjectItem.setTenderProjectNumber(purchaseTenderProjectHead.getTenderProjectNumber());
                purchaseTenderProjectItem.setItemStatus("0");
                purchaseTenderProjectItem.setDeleted(CommonConstant.DEL_FLAG_0);
                purchaseTenderProjectItem.setItemNumber(++itemNumber + "");
                SysUtil.setSysParam((BaseEntity)purchaseTenderProjectItem, (BaseEntity)purchaseTenderProjectHead);
            }
            this.purchaseTenderProjectItemService.deleteByMainId(purchaseTenderProjectHead.getId());
            this.purchaseTenderProjectItemService.saveBatch(purchaseTenderProjectItemList);
        }
        if (CollectionUtil.isNotEmpty(purchaseAttachmentList)) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseTenderProjectHead.getId());
            purchaseAttachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(purchaseTenderProjectHead.getId()));
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    public void replenish(PurchaseTenderProjectHead purchaseTenderProjectHead, List<PurchaseTenderProjectItem> projectItemList) {
        int itemNumber = 1;
        for (PurchaseTenderProjectItem purchaseTenderProjectItem : projectItemList) {
            purchaseTenderProjectItem.setHeadId(purchaseTenderProjectHead.getId());
            purchaseTenderProjectItem.setTenderProjectNumber(purchaseTenderProjectHead.getTenderProjectNumber());
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)purchaseTenderProjectItem.getItemStatus())) {
                purchaseTenderProjectItem.setItemStatus("0");
            }
            purchaseTenderProjectItem.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseTenderProjectItem.setItemNumber(++itemNumber + "");
            SysUtil.setSysParam((BaseEntity)purchaseTenderProjectItem, (BaseEntity)purchaseTenderProjectHead);
        }
        this.purchaseTenderProjectItemService.deleteByMainId(purchaseTenderProjectHead.getId());
        this.purchaseTenderProjectItemService.saveBatch(projectItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseTenderProjectHead purchaseTenderProjectHead, List<PurchaseTenderProjectSubpackageInfoVO> subpackageInfoVOList, List<PurchaseTenderProjectItem> purchaseTenderProjectItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if ("0".equals(purchaseTenderProjectHead.getAudit())) {
            purchaseTenderProjectHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseTenderProjectHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        purchaseTenderProjectHead.setTenderStatus(TenderProjectStatusEnum.NEW.getValue());
        this.updateById((Object)purchaseTenderProjectHead);
        this.insertData(purchaseTenderProjectHead, subpackageInfoVOList, purchaseTenderProjectItemList, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.removeById((Serializable)((Object)id));
        this.purchaseTenderProjectItemService.deleteByMainId(id);
        this.purchaseTenderProjectSubpackageInfoService.delMain(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
    }

    @Override
    public PurchaseTenderProjectHeadVO queryById(String id) {
        PurchaseTenderProjectHead purchaseTenderProjectHead = (PurchaseTenderProjectHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseTenderProjectHeadVO purchaseTenderProjectHeadVO = new PurchaseTenderProjectHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectHead), (Object)((Object)purchaseTenderProjectHeadVO));
        List<PurchaseTenderProjectItem> purchaseTenderProjectItems = this.purchaseTenderProjectItemService.selectByMainId(id);
        purchaseTenderProjectHeadVO.setProjectItemList(purchaseTenderProjectItems);
        List<PurchaseTenderProjectSubpackageInfo> purchaseTenderProjectItemList = this.purchaseTenderProjectSubpackageInfoService.selectByMainId(id);
        ArrayList subpackageInfoVOList = SysUtil.copyProperties(purchaseTenderProjectItemList, PurchaseTenderProjectSubpackageInfoVO.class);
        purchaseTenderProjectHeadVO.setSubpackageInfoVOList(subpackageInfoVOList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseTenderProjectHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return purchaseTenderProjectHeadVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancel(String id) {
        PurchaseTenderProjectHead purchaseTenderProjectHead = (PurchaseTenderProjectHead)((Object)this.getById((Serializable)((Object)id)));
        if (!TenderProjectStatusEnum.NEW.getValue().equals(purchaseTenderProjectHead.getTenderStatus()) && !TenderProjectStatusEnum.BIDDING.getValue().equals(purchaseTenderProjectHead.getTenderStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_APtFxOkuW_3f56f85b", (String)(TenderProjectStatusEnum.valueOf(purchaseTenderProjectHead.getTenderStatus()).getDesc() + "\u7684\u5355\u636e\u4e0d\u80fd\u4f5c\u5e9f\uff01")));
        }
        purchaseTenderProjectHead.setTenderStatus(TenderProjectStatusEnum.CANCEL.getValue());
        this.updateById((Object)purchaseTenderProjectHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(String id) {
        PurchaseTenderProjectHead purchaseTenderProjectHead = (PurchaseTenderProjectHead)((Object)this.getById((Serializable)((Object)id)));
        List<PurchaseTenderProjectSubpackageInfo> purchaseTenderProjectItemList = this.purchaseTenderProjectSubpackageInfoService.selectByMainId(id);
        purchaseTenderProjectItemList.parallelStream().forEach(item -> item.setStatus(TenderProjectSubpackageStatusEnum.ENABLED.getValue()));
        this.checkAndSetParam(purchaseTenderProjectHead, purchaseTenderProjectItemList);
        purchaseTenderProjectHead.setTenderStatus(TenderProjectStatusEnum.BIDDING.getValue());
        this.updateById((Object)purchaseTenderProjectHead);
        this.purchaseTenderProjectSubpackageInfoService.updateBatchById(purchaseTenderProjectItemList);
        TenderProjectArchiveAttachmentHeadService archiveAttachmentHeadService = (TenderProjectArchiveAttachmentHeadService)SpringContextUtils.getBean(TenderProjectArchiveAttachmentHeadService.class);
        TenderProjectArchiveAttachmentHead archiveAttachmentHead = this.builderArchiveAttachmentHead(purchaseTenderProjectHead);
        archiveAttachmentHeadService.save((Object)archiveAttachmentHead);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentList, purchaseTenderProjectHead.getId(), null, purchaseTenderProjectHead.getId(), TenderProjectArchiveAttachmentEnum.TENDER_PROJECT_PREFIX.getValue());
    }

    @Override
    public List<PurchaseTenderProjectSubpackageInfoVO> querySubpackageByHeadId(String headId) {
        List<PurchaseTenderProjectSubpackageInfo> purchaseTenderProjectItemList = this.purchaseTenderProjectSubpackageInfoService.selectByMainId(headId);
        ArrayList result = SysUtil.copyProperties(purchaseTenderProjectItemList, PurchaseTenderProjectSubpackageInfoVO.class);
        if (CollectionUtil.isNotEmpty((Collection)result)) {
            result.parallelStream().forEach(infoVo -> infoVo.setStatusDesc(TenderProjectSubpackageStatusEnum.getSubpackageStatusDesc(infoVo.getStatus())));
        }
        return result;
    }

    @Override
    public PurchaseTenderProjectInfoVO queryProjectInfoBySubpackageId(String subpackageId) {
        return ((PurchaseTenderProjectHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId);
    }

    @Override
    public PurchaseTenderProjectHeadVO queryProjectHeadBySubpackageId(String subpackageId) {
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.purchaseTenderProjectSubpackageInfoService.selectById(subpackageId);
        PurchaseTenderProjectSubpackageInfoVO subpackageInfoVO = (PurchaseTenderProjectSubpackageInfoVO)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderProjectSubpackageInfo), PurchaseTenderProjectSubpackageInfoVO.class));
        PurchaseTenderProjectHead tenderProjectHead = (PurchaseTenderProjectHead)((Object)this.getById((Serializable)((Object)purchaseTenderProjectSubpackageInfo.getHeadId())));
        PurchaseTenderProjectHeadVO purchaseTenderProjectHeadVO = (PurchaseTenderProjectHeadVO)((Object)SysUtil.copyProperties((Object)((Object)tenderProjectHead), PurchaseTenderProjectHeadVO.class));
        ArrayList<PurchaseTenderProjectSubpackageInfoVO> subpackageInfoVOList = new ArrayList<PurchaseTenderProjectSubpackageInfoVO>();
        subpackageInfoVOList.add(subpackageInfoVO);
        purchaseTenderProjectHeadVO.setSubpackageInfoVOList(subpackageInfoVOList);
        return purchaseTenderProjectHeadVO;
    }

    @Override
    public List<CountVO> queryTabsCount(String elsAccount) {
        return ((PurchaseTenderProjectHeadMapper)this.baseMapper).queryTabsCount(elsAccount);
    }

    @Override
    public List<PurchaseTenderProjectHead> selectBatchIds(Set<String> projectIds) {
        return ((PurchaseTenderProjectHeadMapper)this.baseMapper).selectBatchIds(projectIds);
    }

    private TenderProjectArchiveAttachmentHead builderArchiveAttachmentHead(PurchaseTenderProjectHead tenderProjectHead) {
        TenderProjectArchiveAttachmentHead archiveAttachmentHead = new TenderProjectArchiveAttachmentHead().setTenderProjectId(tenderProjectHead.getId()).setTenderProjectName(tenderProjectHead.getTenderProjectName()).setTenderProjectNumber(tenderProjectHead.getTenderProjectNumber()).setTenderApprovalId(tenderProjectHead.getProjectId()).setStatus("0");
        return archiveAttachmentHead;
    }

    @Override
    public List<PurchaseTenderProjectSubpackageInfo> queryDiscardSubpckageByProjectId(String projectId) {
        List<PurchaseTenderProjectSubpackageInfo> purchaseTenderProjectItemList = this.purchaseTenderProjectSubpackageInfoService.selectByMainId(projectId);
        if (CollectionUtil.isEmpty(purchaseTenderProjectItemList)) {
            return null;
        }
        purchaseTenderProjectItemList = purchaseTenderProjectItemList.stream().filter(item -> "1".equals(item.getInvalid())).collect(Collectors.toList());
        return purchaseTenderProjectItemList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void copyData(PurchaseTenderProjectHead purchaseTenderProjectHead, List<PurchaseTenderProjectSubpackageInfo> subpackageInfoVOList, List<PurchaseTenderProjectItem> purchaseTenderProjectItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.builderCopyData(purchaseTenderProjectHead, subpackageInfoVOList, purchaseTenderProjectItemList, purchaseAttachmentList);
    }

    private void builderCopyData(PurchaseTenderProjectHead purchaseTenderProjectHead, List<PurchaseTenderProjectSubpackageInfo> subpackageInfoList, List<PurchaseTenderProjectItem> purchaseTenderProjectItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseTenderProjectHead.setId(IdWorker.getIdStr());
        purchaseTenderProjectHead.setTenderProjectNumber(null);
        if (CollectionUtil.isNotEmpty(subpackageInfoList)) {
            ArrayList subpackageInfoVOS = SysUtil.copyProperties(subpackageInfoList, PurchaseTenderProjectSubpackageInfoVO.class);
            subpackageInfoVOS.parallelStream().forEach(info -> info.setId(null));
            this.saveMain(purchaseTenderProjectHead, subpackageInfoVOS, purchaseTenderProjectItemList, purchaseAttachmentList);
            subpackageInfoList = SysUtil.copyProperties((List)subpackageInfoVOS, PurchaseTenderProjectSubpackageInfo.class);
        }
    }

    @Override
    public String getExecutorAuthority(String projectId) {
        PurchaseTenderProjectHead projectHead;
        LoginUser loginUser = SysUtil.getLoginUser();
        String executorAccount = loginUser.getElsAccount() + "_" + loginUser.getSubAccount();
        boolean isExecutorAuthority = executorAccount.equals((projectHead = (PurchaseTenderProjectHead)((Object)((PurchaseTenderProjectHeadMapper)this.baseMapper).selectById((Serializable)((Object)projectId)))).getPurchaseExecutorAccount() + "_" + projectHead.getPurchaseExecutorSubAccount());
        if (isExecutorAuthority) {
            return "1";
        }
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(PurchaseTenderProjectMember::getHeadId, (Object)projectId)).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount());
        List list = this.purchaseTenderProjectMemberService.list((Wrapper)qw);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return "0";
        }
        for (PurchaseTenderProjectMember projectMember : list) {
            String memberExecutorAccount = projectMember.getElsAccount() + "_" + projectMember.getSubAccount();
            if (!executorAccount.equals(memberExecutorAccount)) continue;
            if ("1".equals(projectMember.getMemberRole())) {
                return "1";
            }
            return "2";
        }
        return "0";
    }
}

