/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.service.IntegrateInvokeInquiryDataService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.integrated.api.dto.IntegratedSerachConditionDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IntegrateInvokeInquiryDataServiceImpl
implements IntegrateInvokeInquiryDataService {
    private static final Logger log = LoggerFactory.getLogger(IntegrateInvokeInquiryDataServiceImpl.class);
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;

    @Override
    public JSONArray listInquiryData(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessDataType()) && "head".equals(integratedSerachConditionDTO.getBusinessDataType())) {
            String businessTypeCore = integratedSerachConditionDTO.getBusinessTypeCore();
            String businessTypeOther = integratedSerachConditionDTO.getBusinessTypeOther();
            List<Object> arrayList = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)businessTypeCore)) {
                JSONArray objectsCore = new JSONArray();
                switch (businessTypeCore) {
                    case "purchaseRequest": {
                        List<PurchaseRequestHead> purchaseContractHeads = this.getRequestDataByIntegraSerach(integratedSerachConditionDTO);
                        if (CollectionUtils.isEmpty(purchaseContractHeads)) break;
                        List<String> collect = purchaseContractHeads.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                        arrayList = purchaseContractHeads.stream().map(PurchaseRequestHead::getDocumentId).distinct().collect(Collectors.toList());
                        objectsCore = this.purchaseRequestHeadService.getRequestDataById(collect);
                        break;
                    }
                    case "bidding": {
                        List<PurchaseBiddingHead> biddingDataByIntegraSerach = this.getBiddingDataByIntegraSerach(integratedSerachConditionDTO);
                        if (CollectionUtils.isEmpty(biddingDataByIntegraSerach)) break;
                        List<String> collect = biddingDataByIntegraSerach.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                        arrayList = biddingDataByIntegraSerach.stream().map(PurchaseBiddingHead::getDocumentId).distinct().collect(Collectors.toList());
                        objectsCore = this.purchaseBiddingHeadService.getBiddingDataById(collect);
                        break;
                    }
                    case "ebidding": {
                        List<PurchaseEbiddingHead> ebiddingDataByIntegraSerach = this.getEbiddingDataByIntegraSerach(integratedSerachConditionDTO);
                        if (CollectionUtils.isEmpty(ebiddingDataByIntegraSerach)) break;
                        List<String> collect = ebiddingDataByIntegraSerach.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                        arrayList = ebiddingDataByIntegraSerach.stream().map(PurchaseEbiddingHead::getDocumentId).distinct().collect(Collectors.toList());
                        objectsCore = this.purchaseEbiddingHeadService.getEbinddingDataById(collect);
                        break;
                    }
                    case "enquiry": {
                        List<PurchaseEnquiryHead> enquiryDataByIntegraSerach = this.getEnquiryDataByIntegraSerach(integratedSerachConditionDTO);
                        if (CollectionUtils.isEmpty(enquiryDataByIntegraSerach)) break;
                        List<String> collect = enquiryDataByIntegraSerach.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                        arrayList = enquiryDataByIntegraSerach.stream().map(PurchaseEnquiryHead::getDocumentId).distinct().collect(Collectors.toList());
                        objectsCore = this.purchaseEnquiryHeadService.getEnquiryDataById(collect);
                    }
                }
            } else {
                arrayList = Arrays.stream(integratedSerachConditionDTO.getIntegratedId().split(",")).collect(Collectors.toList());
            }
        }
        return null;
    }

    private List<PurchaseRequestHead> getRequestDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseRequestHead::getRequestNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchaseRequestHeadService.list((Wrapper)queryWrapper);
    }

    private List<PurchaseEnquiryHead> getEnquiryDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseEnquiryHead::getEnquiryNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchaseEnquiryHeadService.list((Wrapper)queryWrapper);
    }

    private List<PurchaseBiddingHead> getBiddingDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseBiddingHead::getBiddingNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchaseBiddingHeadService.list((Wrapper)queryWrapper);
    }

    private List<PurchaseEbiddingHead> getEbiddingDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseEbiddingHead::getEbiddingNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchaseEbiddingHeadService.list((Wrapper)queryWrapper);
    }
}

