/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.utils.CompareIPUtils;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.mapper.PurchaseEnquiryItemMapper;
import com.els.modules.enquiry.service.EnquirySubstituteItemService;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseEnquiryItemServiceImpl
extends ServiceImpl<PurchaseEnquiryItemMapper, PurchaseEnquiryItem>
implements PurchaseEnquiryItemService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEnquiryItemServiceImpl.class);
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private EnquirySubstituteItemService enquirySubstituteItemService;
    @Autowired
    private DictAspect dictAspect;

    @Override
    public List<PurchaseEnquiryItem> selectByMainId(String mainId) {
        return ((PurchaseEnquiryItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseEnquiryItemMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public void hideQuotePrice(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> itemList) {
        boolean showPrice;
        boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
        if (!showPrice) {
            for (PurchaseEnquiryItem item : itemList) {
                Object object2;
                item.setPrice(null);
                item.setNetPrice(null);
                item.setTaxAmount(null);
                item.setNetAmount(null);
                if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())) {
                    JSONArray ladderPriceJson = StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson()) ? JSONArray.parseArray((String)item.getLadderPriceJson()) : new JSONArray();
                    for (Object object2 : ladderPriceJson) {
                        JSONObject ladderItem = (JSONObject)object2;
                        ladderItem.put("price", null);
                        ladderItem.put("netPrice", null);
                        ladderItem.put("taxAmount", null);
                        ladderItem.put("netAmount", null);
                    }
                    item.setLadderPriceJson(ladderPriceJson.toJSONString());
                }
                if (!EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())) continue;
                JSONObject costFormJson = StrUtil.isNotBlank((CharSequence)item.getCostFormJson()) ? JSONObject.parseObject((String)item.getCostFormJson()) : new JSONObject();
                JSONArray groups = costFormJson.getJSONArray("groups") == null ? new JSONArray() : costFormJson.getJSONArray("groups");
                object2 = groups.iterator();
                while (object2.hasNext()) {
                    Object object3 = object2.next();
                    JSONObject group = (JSONObject)object3;
                    group.put("totalValue", null);
                }
                JSONObject data = costFormJson.getJSONObject("data") == null ? new JSONObject() : costFormJson.getJSONObject("data");
                for (String key : data.keySet()) {
                    data.put(key, (Object)new JSONArray());
                }
                item.setCostFormJson(costFormJson.toJSONString());
            }
        }
    }

    @Override
    public void replenishMaterialNumber(PurchaseEnquiryItem webItem) {
        List<PurchaseEnquiryItem> itemList = this.selectByMainId(webItem.getHeadId());
        this.checkMaterialNumber(webItem, itemList);
        List<PurchaseEnquiryItem> items = this.handlePurchaseEnquiyItemList(webItem, itemList);
        this.updateBatchById(items);
        this.saleEnquiryItemService.replenishMaterialNumber(items);
        this.enquirySubstituteItemService.replenishMaterialNumber(items);
        PurchaseEnquiryItem item = items.get(0);
        if (SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType()) && StringUtils.isNotBlank((CharSequence)item.getSourceItemId())) {
            this.purchaseRequestItemService.replenishMaterial(item.getSourceItemId(), item.getMaterialNumber(), item.getMaterialDesc(), item.getMaterialGroup(), item.getMaterialSpec());
        }
    }

    private List<PurchaseEnquiryItem> handlePurchaseEnquiyItemList(PurchaseEnquiryItem webItem, List<PurchaseEnquiryItem> itemList) {
        List<PurchaseEnquiryItem> items = itemList.stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).collect(Collectors.toList());
        items.forEach(item -> {
            item.setMaterialNumber(webItem.getMaterialNumber());
            item.setMaterialDesc(webItem.getMaterialDesc());
            item.setMaterialGroup(webItem.getMaterialGroup());
            item.setMaterialSpec(webItem.getMaterialSpec());
            item.setMaterialGroupName(webItem.getMaterialGroupName());
        });
        return items;
    }

    private void checkMaterialNumber(PurchaseEnquiryItem webItem, List<PurchaseEnquiryItem> itemList) {
        List materialNumbers = itemList.stream().map(PurchaseEnquiryItem::getMaterialNumber).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialNumbers)) {
            return;
        }
        boolean b = materialNumbers.stream().anyMatch(item -> item.equals(webItem.getMaterialNumber()));
        if (b) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__SLAoxOVB_f1d5e3eb", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u91cd\u590d"));
        }
    }

    @Override
    public void exportCompare(PurchaseEnquiryHead dbHead, HttpServletResponse response) {
        List<PurchaseEnquiryItem> itemList = ((PurchaseEnquiryItemMapper)this.baseMapper).selectByMainId(dbHead.getId());
        this.hideQuotePrice(dbHead, itemList);
        List distinctList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItem>(Comparator.comparing(PurchaseEnquiryItem::getItemNumber))), ArrayList::new));
        List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(dbHead.getId());
        ExcelWriter writer = new ExcelWriter(true, "\u5e38\u89c4\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u540d\u79f0", "\u7269\u6599\u63cf\u8ff0", "\u7269\u6599\u89c4\u683c", "\u9700\u6c42\u6570\u91cf", "\u91c7\u8d2d\u5355\u4f4d", "\u76ee\u6807\u5355\u4ef7", "\u5de5\u5382", "\u5e93\u5b58\u5730\u70b9", "\u5bf9\u6bd4\u9879"));
        int firstRow = 1;
        ArrayList itemList1 = new ArrayList();
        distinctList.forEach(e -> {
            PurchaseEnquiryItem item = new PurchaseEnquiryItem();
            BeanUtils.copyProperties((Object)e, (Object)((Object)item));
            itemList1.add(item);
        });
        Result dbResult = Result.ok(itemList1);
        this.dictAspect.parseDictText((Object)dbResult);
        List data = (List)dbResult.getResult();
        int i = 0;
        for (Object item2 : distinctList) {
            JSONObject jsonObject = (JSONObject)data.get(i);
            log.info("dbResult-JSON:{}, \u91c7\u8d2d\u5355\u4f4d:{}", (Object)jsonObject.toJSONString(), (Object)jsonObject.getString("purchaseUnit_dictText"));
            writer.merge(firstRow, firstRow + 9, 0, 0, (Object)((PurchaseEnquiryItem)((Object)item2)).getEnquiryNumber(), false);
            writer.merge(firstRow, firstRow + 9, 1, 1, (Object)((PurchaseEnquiryItem)((Object)item2)).getItemNumber(), false);
            writer.merge(firstRow, firstRow + 9, 2, 2, (Object)((PurchaseEnquiryItem)((Object)item2)).getMaterialNumber(), false);
            writer.merge(firstRow, firstRow + 9, 3, 3, (Object)((PurchaseEnquiryItem)((Object)item2)).getMaterialName(), false);
            writer.merge(firstRow, firstRow + 9, 4, 4, (Object)((PurchaseEnquiryItem)((Object)item2)).getMaterialDesc(), false);
            writer.merge(firstRow, firstRow + 9, 5, 5, (Object)((PurchaseEnquiryItem)((Object)item2)).getMaterialSpec(), false);
            writer.merge(firstRow, firstRow + 9, 6, 6, (Object)((PurchaseEnquiryItem)((Object)item2)).getRequireQuantity(), false);
            writer.merge(firstRow, firstRow + 9, 7, 7, (Object)jsonObject.getString("purchaseUnit_dictText"), false);
            writer.merge(firstRow, firstRow + 9, 8, 8, (Object)((PurchaseEnquiryItem)((Object)item2)).getFuturePrice(), false);
            writer.merge(firstRow, firstRow + 9, 9, 9, (Object)jsonObject.getString("factory_dictText"), false);
            writer.merge(firstRow, firstRow + 9, 10, 10, (Object)jsonObject.getString("storageLocation_dictText"), false);
            ++i;
            writer.writeCellValue(11, firstRow, (Object)"\u542b\u7a0e\u4ef7");
            writer.writeCellValue(11, firstRow + 1, (Object)"\u672a\u7a0e\u5355\u4ef7");
            writer.writeCellValue(11, firstRow + 2, (Object)"\u7a0e\u7387");
            writer.writeCellValue(11, firstRow + 3, (Object)"\u4ea4\u8d27\u65e5\u671f");
            writer.writeCellValue(11, firstRow + 4, (Object)"\u62a5\u4ef7\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 5, (Object)"\u6700\u5c0f\u5305\u88c5\u91cf");
            writer.writeCellValue(11, firstRow + 6, (Object)"\u6700\u5c0f\u8ba2\u5355\u91cf");
            writer.writeCellValue(11, firstRow + 7, (Object)"\u4ef7\u683c\u751f\u6548\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 8, (Object)"\u4ef7\u683c\u5931\u6548\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 9, (Object)"\u62a5\u4ef7\u8f6e\u6b21");
            firstRow += 10;
        }
        int x = 12;
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            int y = 1;
            for (PurchaseEnquiryItem item3 : dataList) {
                writer.writeCellValue(x, y, (Object)item3.getPrice());
                writer.writeCellValue(x, y + 1, (Object)item3.getNetPrice());
                writer.writeCellValue(x, y + 2, (Object)item3.getTaxRate());
                writer.writeCellValue(x, y + 3, item3.getDeliveryDate() == null ? null : DateUtil.format((Date)item3.getDeliveryDate(), (String)"yyyy-MM-dd"));
                writer.writeCellValue(x, y + 4, item3.getQuoteTime() == null ? null : DateUtil.format((Date)item3.getQuoteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                writer.writeCellValue(x, y + 5, (Object)item3.getMinPackQuantity());
                writer.writeCellValue(x, y + 6, (Object)item3.getMinOrderQuantity());
                writer.writeCellValue(x, y + 7, item3.getEffectiveDate() == null ? null : DateUtil.format((Date)item3.getEffectiveDate(), (String)"yyyy-MM-dd"));
                writer.writeCellValue(x, y + 8, item3.getExpiryDate() == null ? null : DateUtil.format((Date)item3.getExpiryDate(), (String)"yyyy-MM-dd"));
                writer.writeCellValue(x, y + 9, (Object)item3.getQuoteCount());
                writer.setColumnWidth(x, 16);
                y += 10;
            }
            ++x;
        }
        this.ladderCompare(writer, itemList, distinctList, supplierList);
        this.costCompare(writer, itemList, distinctList, supplierList);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u6bd4\u4ef7\u62a5\u8868.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (IOException e2) {
            log.error("IO\u5f02\u5e38:", (Throwable)e2);
        }
    }

    @Override
    public Map<String, Long> getSupplierPortraitCount(String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItem::getToElsAccount, (Object)toElsAccount);
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List allList = this.list((Wrapper)queryWrapper);
        long participationCount = allList.stream().map(PurchaseEnquiryItem::getHeadId).distinct().count();
        long biddingWinCount = allList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItem::getHeadId).distinct().count();
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        returnMap.put("participationCount", participationCount);
        returnMap.put("biddingWinCount", biddingWinCount);
        return returnMap;
    }

    @Override
    public List<PurchaseEnquiryItem> queryEnquiryByDesc(List<String> materialDescs) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(PurchaseEnquiryItem::getItemStatus, new Object[]{EnquiryStatusEnum.ACCEPT.getValue(), EnquiryStatusEnum.PRICED.getValue()});
        lambdaQueryWrapper.in(PurchaseEnquiryItem::getMaterialDesc, materialDescs);
        lambdaQueryWrapper.and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(PurchaseEnquiryItem::getMaterialNumber)).or(qw1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)qw1.eq(PurchaseEnquiryItem::getMaterialNumber, (Object)"");
            });
        });
        return ((PurchaseEnquiryItemMapper)this.baseMapper).selectList((Wrapper)lambdaQueryWrapper);
    }

    private void ladderCompare(ExcelWriter writer, List<PurchaseEnquiryItem> itemList, List<PurchaseEnquiryItem> distinctList, List<EnquirySupplierList> supplierList) {
        writer.setSheet("\u9636\u68af\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u63cf\u8ff0", "\u5355\u4f4d", "\u9700\u6c42\u6570\u91cf", "\u9636\u68af\u7ea7"));
        int firstRow = 1;
        for (PurchaseEnquiryItem item2 : distinctList) {
            if (!EnquiryQuoteWayEnum.LADDER.getValue().equals(item2.getQuotePriceWay()) || !StrUtil.isNotBlank((CharSequence)item2.getLadderPriceJson())) continue;
            JSONArray array = JSONArray.parseArray((String)item2.getLadderPriceJson());
            this.mergeCell(writer, firstRow, array, item2);
            for (int index = 0; index < array.size(); ++index) {
                JSONObject ladder = array.getJSONObject(index);
                writer.writeCellValue(6, firstRow + index, (Object)ladder.getString("ladder"));
            }
            firstRow += array.size();
        }
        int x = 7;
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson())).filter(item -> EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            int y = 1;
            for (PurchaseEnquiryItem item3 : dataList) {
                JSONArray array = JSONArray.parseArray((String)item3.getLadderPriceJson());
                for (int index = 0; index < array.size(); ++index) {
                    JSONObject ladder = array.getJSONObject(index);
                    writer.writeCellValue(x, y + index, (Object)ladder.getBigDecimal("price"));
                }
                y += array.size();
            }
            ++x;
        }
    }

    private void costCompare(ExcelWriter writer, List<PurchaseEnquiryItem> itemList, List<PurchaseEnquiryItem> distinctList, List<EnquirySupplierList> supplierList) {
        writer.setSheet("\u6210\u672c\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u63cf\u8ff0", "\u5355\u4f4d", "\u9700\u6c42\u6570\u91cf", "\u6210\u672c\u9879"));
        int firstRow = 1;
        for (PurchaseEnquiryItem item2 : distinctList) {
            JSONObject jsonObject;
            JSONArray groups;
            if (!EnquiryQuoteWayEnum.COST.getValue().equals(item2.getQuotePriceWay()) || !StrUtil.isNotBlank((CharSequence)item2.getCostFormJson()) || (groups = (jsonObject = JSONObject.parseObject((String)item2.getCostFormJson())).getJSONArray("groups")) == null) continue;
            this.mergeCell(writer, firstRow, groups, item2);
            for (int index = 0; index < groups.size(); ++index) {
                JSONObject group = groups.getJSONObject(index);
                writer.writeCellValue(6, firstRow + index, (Object)group.getString("groupName"));
            }
            firstRow += groups.size();
        }
        int x = 7;
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> StrUtil.isNotBlank((CharSequence)item.getCostFormJson())).filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            int y = 1;
            for (PurchaseEnquiryItem item3 : dataList) {
                JSONObject jsonObject = JSONObject.parseObject((String)item3.getCostFormJson());
                JSONArray groups = jsonObject.getJSONArray("groups") == null ? new JSONArray() : jsonObject.getJSONArray("groups");
                for (int index = 0; index < groups.size(); ++index) {
                    JSONObject group = groups.getJSONObject(index);
                    writer.writeCellValue(x, y + index, (Object)group.getBigDecimal("totalValue"));
                }
                y += groups.size();
            }
            ++x;
        }
    }

    private void mergeCell(ExcelWriter writer, int firstRow, JSONArray ladderOrGroups, PurchaseEnquiryItem item) {
        if (ladderOrGroups.size() > 1) {
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 0, 0, (Object)item.getEnquiryNumber(), false);
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 1, 1, (Object)item.getItemNumber(), false);
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 2, 2, (Object)item.getMaterialNumber(), false);
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 3, 3, (Object)item.getMaterialDesc(), false);
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 4, 4, (Object)item.getPriceUnit(), false);
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 5, 5, (Object)item.getRequireQuantity(), false);
        } else {
            writer.writeCellValue(0, firstRow, (Object)item.getEnquiryNumber());
            writer.writeCellValue(1, firstRow, (Object)item.getItemNumber());
            writer.writeCellValue(2, firstRow, (Object)item.getMaterialNumber());
            writer.writeCellValue(3, firstRow, (Object)item.getMaterialDesc());
            writer.writeCellValue(4, firstRow, (Object)item.getPriceUnit());
            writer.writeCellValue(5, firstRow, (Object)item.getRequireQuantity());
        }
    }

    private List<String> getHeaderList(List<EnquirySupplierList> supplierList, String ... headText) {
        ArrayList<String> excelHeader = new ArrayList<String>(Arrays.asList(headText));
        for (EnquirySupplierList supplier : supplierList) {
            excelHeader.add(supplier.getSupplierName());
        }
        return excelHeader;
    }

    @Override
    public List<SupplierRelationFindResultVO> probeIP(List<PurchaseEnquiryItem> purchaseBiddingItemList) {
        ArrayList<SupplierRelationFindResultVO> result = new ArrayList<SupplierRelationFindResultVO>();
        List accountIpList = purchaseBiddingItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getQuoteIp())).map(item -> item.getToElsAccount() + "_" + item.getQuoteIp()).distinct().collect(Collectors.toList());
        Map<String, PurchaseEnquiryItem> supplierMap = purchaseBiddingItemList.stream().collect(Collectors.toMap(PurchaseEnquiryItem::getToElsAccount, Function.identity(), (supplier1, supplier2) -> supplier2));
        for (String sourceAccountIp : accountIpList) {
            for (String targetAccountIp : accountIpList) {
                if (sourceAccountIp.equals(targetAccountIp)) continue;
                CompareIPUtils.compareEnquiryIp(sourceAccountIp, targetAccountIp, supplierMap, result);
            }
        }
        return result;
    }
}

