/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.priceEvaluationManagement.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.priceEvaluationManagement.entity.PurchaseManagementClassifyItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationStandardHead;
import com.els.modules.priceEvaluationManagement.entity.PurchaseProcessingProcedurePriceItem;
import com.els.modules.priceEvaluationManagement.enumerate.PurchasePriceEvaluationStandardStatusEnum;
import com.els.modules.priceEvaluationManagement.service.PurchaseManagementClassifyItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationStandardHeadService;
import com.els.modules.priceEvaluationManagement.service.PurchaseProcessingProcedurePriceItemService;
import com.els.modules.priceEvaluationManagement.vo.PurchasePriceEvaluationStandardHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PriceEvaluationStanderAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PriceEvaluationStanderAuditOptCallBackServiceImpl.class);
    @Autowired
    private PurchasePriceEvaluationStandardHeadService purchasePriceEvaluationStandardHeadService;
    @Autowired
    private PurchasePriceEvaluationItemService purchasePriceEvaluationItemService;
    @Autowired
    private PurchaseProcessingProcedurePriceItemService purchaseProcessingProcedurePriceItemService;
    @Autowired
    private PurchaseManagementClassifyItemService purchaseManagementClassifyItemService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StringUtils.isEmpty((Object)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        this.updateStatus(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchasePriceEvaluationStandardHead purchasePriceEvaluationStandardHead = (PurchasePriceEvaluationStandardHead)((Object)this.purchasePriceEvaluationStandardHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        if (purchasePriceEvaluationStandardHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_HemhxurtFW_1f2b4ae7", (String)"\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e!"));
        }
        PurchasePriceEvaluationStandardHead head = new PurchasePriceEvaluationStandardHead();
        head.setId(inputParamVO.getBusinessId());
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        log.info("xxxxxxxxxxxx");
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            head.setDocumentStatus(PurchasePriceEvaluationStandardStatusEnum.START.getValue());
            if ("1".equals(purchasePriceEvaluationStandardHead.getPublish())) {
                PurchasePriceEvaluationStandardHeadVO purchasePriceEvaluationStandardHeadVO = new PurchasePriceEvaluationStandardHeadVO();
                BeanUtil.copyProperties((Object)((Object)purchasePriceEvaluationStandardHead), (Object)((Object)purchasePriceEvaluationStandardHeadVO), (String[])new String[0]);
                List<PurchasePriceEvaluationItem> purchasePriceEvaluationItemList = this.purchasePriceEvaluationItemService.selectByMainId(inputParamVO.getBusinessId());
                List<PurchaseProcessingProcedurePriceItem> purchaseProcessingProcedurePriceItemList = this.purchaseProcessingProcedurePriceItemService.selectByMainId(inputParamVO.getBusinessId());
                List<PurchaseManagementClassifyItem> purchaseManagementClassifyItemList = this.purchaseManagementClassifyItemService.selectByMainId(inputParamVO.getBusinessId());
                purchasePriceEvaluationStandardHeadVO.setPurchasePriceEvaluationItemList(purchasePriceEvaluationItemList);
                purchasePriceEvaluationStandardHeadVO.setPurchaseProcessingProcedurePriceItemList(purchaseProcessingProcedurePriceItemList);
                purchasePriceEvaluationStandardHeadVO.setPurchaseManagementClassifyItemList(purchaseManagementClassifyItemList);
                this.purchasePriceEvaluationStandardHeadService.publish(purchasePriceEvaluationStandardHeadVO);
            }
        }
        this.purchasePriceEvaluationStandardHeadService.updateById((Object)head);
        log.info("\u6838\u4ef7\u6807\u51c6\u5ba1\u6279\u5b8c\u6210");
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        Map<String, String> paramMap = inputParamVO.getVariables() == null ? new HashMap() : inputParamVO.getVariables();
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams(paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

