/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.priceEvaluationManagement.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.priceEvaluationManagement.entity.PurchaseManagementClassifyItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationStandardHead;
import com.els.modules.priceEvaluationManagement.entity.PurchaseProcessingProcedurePriceItem;
import com.els.modules.priceEvaluationManagement.entity.PurchaseSupplierEvaluationStander;
import com.els.modules.priceEvaluationManagement.entity.SaleManagementClassifyItem;
import com.els.modules.priceEvaluationManagement.entity.SalePriceEvaluationItem;
import com.els.modules.priceEvaluationManagement.entity.SalePriceEvaluationStandardHead;
import com.els.modules.priceEvaluationManagement.entity.SaleProcessingProcedurePriceItem;
import com.els.modules.priceEvaluationManagement.enumerate.PurchasePriceEvaluationStandardStatusEnum;
import com.els.modules.priceEvaluationManagement.enumerate.PurchasePriceEvaluationStandardSupplierStatusEnum;
import com.els.modules.priceEvaluationManagement.job.utils.PriceEvaluationJobUtil;
import com.els.modules.priceEvaluationManagement.mapper.PurchasePriceEvaluationStandardHeadMapper;
import com.els.modules.priceEvaluationManagement.service.PurchaseManagementClassifyItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationStandardHeadService;
import com.els.modules.priceEvaluationManagement.service.PurchaseProcessingProcedurePriceItemService;
import com.els.modules.priceEvaluationManagement.service.PurchaseSupplierEvaluationStanderService;
import com.els.modules.priceEvaluationManagement.service.SaleManagementClassifyItemService;
import com.els.modules.priceEvaluationManagement.service.SalePriceEvaluationItemService;
import com.els.modules.priceEvaluationManagement.service.SalePriceEvaluationStandardHeadService;
import com.els.modules.priceEvaluationManagement.service.SaleProcessingProcedurePriceItemService;
import com.els.modules.priceEvaluationManagement.vo.PurchasePriceEvaluationStandardHeadVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PurchasePriceEvaluationStandardHeadServiceImpl
extends BaseServiceImpl<PurchasePriceEvaluationStandardHeadMapper, PurchasePriceEvaluationStandardHead>
implements PurchasePriceEvaluationStandardHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePriceEvaluationStandardHeadServiceImpl.class);
    @Autowired
    private PurchasePriceEvaluationItemService purchasePriceEvaluationItemService;
    @Autowired
    private PurchaseProcessingProcedurePriceItemService purchaseProcessingProcedurePriceItemService;
    @Autowired
    private PurchaseManagementClassifyItemService purchaseManagementClassifyItemService;
    @Autowired
    private SalePriceEvaluationItemService salePriceEvaluationItemService;
    @Autowired
    private SaleProcessingProcedurePriceItemService saleProcessingProcedurePriceItemService;
    @Autowired
    private SaleManagementClassifyItemService saleManagementClassifyItemService;
    @Autowired
    private SalePriceEvaluationStandardHeadService salePriceEvaluationStandardHeadService;
    @Autowired
    private PurchaseSupplierEvaluationStanderService purchaseSupplierEvaluationStanderService;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Resource
    private InvokeAccountRpcService accountRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePriceEvaluationStandardHead purchasePriceEvaluationStandardHead, List<PurchasePriceEvaluationItem> purchasePriceEvaluationItemList, List<PurchaseProcessingProcedurePriceItem> purchaseProcessingProcedurePriceItemList, List<PurchaseManagementClassifyItem> purchaseManagementClassifyItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseSupplierEvaluationStander> purchaseSupplierEvaluationStanderList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        purchasePriceEvaluationStandardHead.setDocumentNumber(this.baseRpcService.getNextCode("purchasePriceEvaluationStandardHeadNumber", (Object)purchasePriceEvaluationStandardHead));
        purchasePriceEvaluationStandardHead.setBusAccount(loginUser.getElsAccount());
        if ("1".equals(purchasePriceEvaluationStandardHead.getIsAudit())) {
            purchasePriceEvaluationStandardHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchasePriceEvaluationStandardHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        ((PurchasePriceEvaluationStandardHeadMapper)this.baseMapper).insert((Object)purchasePriceEvaluationStandardHead);
        super.setHeadDefaultValue((BaseEntity)purchasePriceEvaluationStandardHead);
        this.insertData(purchasePriceEvaluationStandardHead, purchasePriceEvaluationItemList, purchaseProcessingProcedurePriceItemList, purchaseManagementClassifyItemList, purchaseAttachmentList, purchaseSupplierEvaluationStanderList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePriceEvaluationStandardHead purchasePriceEvaluationStandardHead, List<PurchasePriceEvaluationItem> purchasePriceEvaluationItemList, List<PurchaseProcessingProcedurePriceItem> purchaseProcessingProcedurePriceItemList, List<PurchaseManagementClassifyItem> purchaseManagementClassifyItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseSupplierEvaluationStander> purchaseSupplierEvaluationStanderList) {
        if ("1".equals(purchasePriceEvaluationStandardHead.getIsAudit())) {
            purchasePriceEvaluationStandardHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchasePriceEvaluationStandardHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        int count = ((PurchasePriceEvaluationStandardHeadMapper)this.baseMapper).updateById((Object)purchasePriceEvaluationStandardHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchasePriceEvaluationItemService.deleteByMainId(purchasePriceEvaluationStandardHead.getId());
        this.purchaseProcessingProcedurePriceItemService.deleteByMainId(purchasePriceEvaluationStandardHead.getId());
        this.purchaseManagementClassifyItemService.deleteByMainId(purchasePriceEvaluationStandardHead.getId());
        this.purchaseSupplierEvaluationStanderService.deleteByMainId(purchasePriceEvaluationStandardHead.getId());
        this.baseRpcService.deletePurchaseAttachmentByMainId(purchasePriceEvaluationStandardHead.getId());
        this.insertData(purchasePriceEvaluationStandardHead, purchasePriceEvaluationItemList, purchaseProcessingProcedurePriceItemList, purchaseManagementClassifyItemList, purchaseAttachmentList, purchaseSupplierEvaluationStanderList);
    }

    private void insertData(PurchasePriceEvaluationStandardHead purchasePriceEvaluationStandardHead, List<PurchasePriceEvaluationItem> purchasePriceEvaluationItemList, List<PurchaseProcessingProcedurePriceItem> purchaseProcessingProcedurePriceItemList, List<PurchaseManagementClassifyItem> purchaseManagementClassifyItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, List<PurchaseSupplierEvaluationStander> purchaseSupplierEvaluationStanderList) {
        if (!CollectionUtils.isEmpty(purchasePriceEvaluationItemList)) {
            for (PurchasePriceEvaluationItem purchasePriceEvaluationItem : purchasePriceEvaluationItemList) {
                purchasePriceEvaluationItem.setHeadId(purchasePriceEvaluationStandardHead.getId());
                SysUtil.setSysParam((BaseEntity)purchasePriceEvaluationItem, (BaseEntity)purchasePriceEvaluationStandardHead);
                purchasePriceEvaluationItem.setId(IdWorker.getIdStr());
            }
            this.purchasePriceEvaluationItemService.saveBatch(purchasePriceEvaluationItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(purchaseProcessingProcedurePriceItemList)) {
            for (PurchaseProcessingProcedurePriceItem purchaseProcessingProcedurePriceItem : purchaseProcessingProcedurePriceItemList) {
                purchaseProcessingProcedurePriceItem.setHeadId(purchasePriceEvaluationStandardHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseProcessingProcedurePriceItem, (BaseEntity)purchasePriceEvaluationStandardHead);
                purchaseProcessingProcedurePriceItem.setId(IdWorker.getIdStr());
            }
            this.purchaseProcessingProcedurePriceItemService.saveBatch(purchaseProcessingProcedurePriceItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(purchaseManagementClassifyItemList)) {
            for (PurchaseManagementClassifyItem purchaseManagementClassifyItem : purchaseManagementClassifyItemList) {
                purchaseManagementClassifyItem.setHeadId(purchasePriceEvaluationStandardHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseManagementClassifyItem, (BaseEntity)purchasePriceEvaluationStandardHead);
                purchaseManagementClassifyItem.setId(IdWorker.getIdStr());
            }
            this.purchaseManagementClassifyItemService.saveBatch(purchaseManagementClassifyItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentList) {
                purchaseAttachmentDTO.setHeadId(purchasePriceEvaluationStandardHead.getId());
                SysUtil.setSysParam((BaseDTO)purchaseAttachmentDTO, (BaseEntity)purchasePriceEvaluationStandardHead);
                purchaseAttachmentDTO.setId(IdWorker.getIdStr());
            }
            this.baseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
        if (!CollectionUtils.isEmpty(purchaseSupplierEvaluationStanderList)) {
            for (PurchaseSupplierEvaluationStander purchaseSupplierEvaluationStander : purchaseSupplierEvaluationStanderList) {
                purchaseSupplierEvaluationStander.setHeadId(purchasePriceEvaluationStandardHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseSupplierEvaluationStander, (BaseEntity)purchasePriceEvaluationStandardHead);
                purchaseSupplierEvaluationStander.setId(IdWorker.getIdStr());
            }
            this.purchaseSupplierEvaluationStanderService.saveBatch(purchaseSupplierEvaluationStanderList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchasePriceEvaluationItemService.deleteByMainId(id);
        this.purchaseProcessingProcedurePriceItemService.deleteByMainId(id);
        this.purchaseManagementClassifyItemService.deleteByMainId(id);
        this.purchaseSupplierEvaluationStanderService.deleteByMainId(id);
        this.baseRpcService.deletePurchaseAttachmentByMainId(id);
        ((PurchasePriceEvaluationStandardHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchasePriceEvaluationItemService.deleteByMainId(serializable.toString());
            this.purchaseProcessingProcedurePriceItemService.deleteByMainId(serializable.toString());
            this.purchaseManagementClassifyItemService.deleteByMainId(serializable.toString());
            this.baseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            ((PurchasePriceEvaluationStandardHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void submit(PurchasePriceEvaluationStandardHead purchasePriceEvaluationStandardHead) {
        PurchasePriceEvaluationStandardHead priceEvaluationStandardHead = new PurchasePriceEvaluationStandardHead();
        priceEvaluationStandardHead.setDocumentStatus(PurchasePriceEvaluationStandardStatusEnum.START.getValue());
        priceEvaluationStandardHead.setId(purchasePriceEvaluationStandardHead.getId());
        priceEvaluationStandardHead.setDataVersion(purchasePriceEvaluationStandardHead.getDataVersion());
        int count = ((PurchasePriceEvaluationStandardHeadMapper)this.baseMapper).updateById((Object)priceEvaluationStandardHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void start(PurchasePriceEvaluationStandardHead purchasePriceEvaluationStandardHead) {
        PurchasePriceEvaluationStandardHead dbPriceEvaluationStandardHead = (PurchasePriceEvaluationStandardHead)((Object)((PurchasePriceEvaluationStandardHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchasePriceEvaluationStandardHead.getId())));
        if (dbPriceEvaluationStandardHead == null) {
            throw new ELSBootException("\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        String documentStatus = PurchasePriceEvaluationStandardStatusEnum.START.getValue().equals(dbPriceEvaluationStandardHead.getDocumentStatus()) ? PurchasePriceEvaluationStandardStatusEnum.NOT.getValue() : PurchasePriceEvaluationStandardStatusEnum.START.getValue();
        PurchasePriceEvaluationStandardHead priceEvaluationStandardHead = new PurchasePriceEvaluationStandardHead();
        priceEvaluationStandardHead.setDocumentStatus(documentStatus);
        priceEvaluationStandardHead.setId(purchasePriceEvaluationStandardHead.getId());
        priceEvaluationStandardHead.setDataVersion(purchasePriceEvaluationStandardHead.getDataVersion());
        int count = ((PurchasePriceEvaluationStandardHeadMapper)this.baseMapper).updateById((Object)priceEvaluationStandardHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void publish(PurchasePriceEvaluationStandardHeadVO purchasePriceEvaluationStandardHeadPage) {
        ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = this.accountRpcService.getByElsAccount(purchasePriceEvaluationStandardHeadPage.getElsAccount());
        List<PurchaseSupplierEvaluationStander> purchaseSupplierEvaluationStanderList = this.purchaseSupplierEvaluationStanderService.selectByMainId(purchasePriceEvaluationStandardHeadPage.getId());
        if (!CollectionUtils.isEmpty(purchaseSupplierEvaluationStanderList)) {
            List<PurchasePriceEvaluationItem> purchasePriceEvaluationItemList = purchasePriceEvaluationStandardHeadPage.getPurchasePriceEvaluationItemList();
            List<PurchaseProcessingProcedurePriceItem> purchaseProcessingProcedurePriceItemList = purchasePriceEvaluationStandardHeadPage.getPurchaseProcessingProcedurePriceItemList();
            List<PurchaseManagementClassifyItem> purchaseManagementClassifyItemList = purchasePriceEvaluationStandardHeadPage.getPurchaseManagementClassifyItemList();
            ArrayList<PurchasePriceEvaluationItem> paramsPurchasePriceEvaluationItemList = new ArrayList<PurchasePriceEvaluationItem>();
            ArrayList<PurchaseProcessingProcedurePriceItem> paramsPurchaseProcessingProcedurePriceItemList = new ArrayList<PurchaseProcessingProcedurePriceItem>();
            ArrayList<PurchaseManagementClassifyItem> paramsPurchaseManagementClassifyItemList = new ArrayList<PurchaseManagementClassifyItem>();
            ArrayList<SalePriceEvaluationItem> paramsSalePriceEvaluationItemList = new ArrayList<SalePriceEvaluationItem>();
            ArrayList<SaleProcessingProcedurePriceItem> paramsSaleProcessingProcedurePriceItemList = new ArrayList<SaleProcessingProcedurePriceItem>();
            ArrayList<SaleManagementClassifyItem> paramsSaleManagementClassifyItemList = new ArrayList<SaleManagementClassifyItem>();
            ArrayList<SalePriceEvaluationStandardHead> paramsSalePriceEvaluationStandardHeadList = new ArrayList<SalePriceEvaluationStandardHead>();
            for (PurchaseSupplierEvaluationStander purchaseSupplierEvaluationStander : purchaseSupplierEvaluationStanderList) {
                SalePriceEvaluationStandardHead salePriceEvaluationStandardHead = new SalePriceEvaluationStandardHead();
                BeanUtils.copyProperties((Object)((Object)purchasePriceEvaluationStandardHeadPage), (Object)((Object)salePriceEvaluationStandardHead));
                salePriceEvaluationStandardHead.setId(IdWorker.getIdStr());
                salePriceEvaluationStandardHead.setRelationId(purchasePriceEvaluationStandardHeadPage.getId());
                salePriceEvaluationStandardHead.setElsAccount(purchaseSupplierEvaluationStander.getToElsAccount());
                salePriceEvaluationStandardHead.setToElsAccount(purchasePriceEvaluationStandardHeadPage.getElsAccount());
                salePriceEvaluationStandardHead.setSupplierCode(purchaseSupplierEvaluationStander.getSupplierCode());
                salePriceEvaluationStandardHead.setSupplierName(purchaseSupplierEvaluationStander.getSupplierName());
                salePriceEvaluationStandardHead.setEvaluationSupplierId(purchaseSupplierEvaluationStander.getId());
                salePriceEvaluationStandardHead.setSaleDocumentStatus(PurchasePriceEvaluationStandardSupplierStatusEnum.WAIT_CONFIRM.getValue());
                if (elsEnterpriseInfoDTO != null) {
                    salePriceEvaluationStandardHead.setPurchaseName(elsEnterpriseInfoDTO.getName());
                }
                salePriceEvaluationStandardHead.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                paramsSalePriceEvaluationStandardHeadList.add(salePriceEvaluationStandardHead);
                if (!CollectionUtils.isEmpty(purchasePriceEvaluationItemList)) {
                    for (PurchasePriceEvaluationItem purchasePriceEvaluationItem : purchasePriceEvaluationItemList) {
                        PurchasePriceEvaluationItem paramsPurchasePriceEvaluationItem = new PurchasePriceEvaluationItem();
                        SalePriceEvaluationItem paramsSalePriceEvaluationItem = new SalePriceEvaluationItem();
                        BeanUtils.copyProperties((Object)((Object)purchasePriceEvaluationItem), (Object)((Object)paramsSalePriceEvaluationItem));
                        paramsSalePriceEvaluationItem.setId(IdWorker.getIdStr());
                        paramsSalePriceEvaluationItem.setRelationId(purchasePriceEvaluationItem.getId());
                        paramsSalePriceEvaluationItem.setHeadId(salePriceEvaluationStandardHead.getId());
                        paramsPurchasePriceEvaluationItem.setId(purchasePriceEvaluationItem.getId());
                        paramsPurchasePriceEvaluationItem.setRelationId(paramsSalePriceEvaluationItem.getId());
                        paramsPurchasePriceEvaluationItemList.add(paramsPurchasePriceEvaluationItem);
                        paramsSalePriceEvaluationItemList.add(paramsSalePriceEvaluationItem);
                    }
                }
                if (!CollectionUtils.isEmpty(purchaseProcessingProcedurePriceItemList)) {
                    for (PurchaseProcessingProcedurePriceItem purchaseProcessingProcedurePriceItem : purchaseProcessingProcedurePriceItemList) {
                        PurchaseProcessingProcedurePriceItem paramsPurchaseProcessingProcedurePriceItem = new PurchaseProcessingProcedurePriceItem();
                        SaleProcessingProcedurePriceItem paramsSaleProcessingProcedurePriceItem = new SaleProcessingProcedurePriceItem();
                        BeanUtils.copyProperties((Object)((Object)purchaseProcessingProcedurePriceItem), (Object)((Object)paramsSaleProcessingProcedurePriceItem));
                        paramsSaleProcessingProcedurePriceItem.setId(IdWorker.getIdStr());
                        paramsSaleProcessingProcedurePriceItem.setRelationId(purchaseProcessingProcedurePriceItem.getId());
                        paramsSaleProcessingProcedurePriceItem.setHeadId(salePriceEvaluationStandardHead.getId());
                        paramsPurchaseProcessingProcedurePriceItem.setId(purchaseProcessingProcedurePriceItem.getId());
                        paramsPurchaseProcessingProcedurePriceItem.setRelationId(purchaseProcessingProcedurePriceItem.getId());
                        paramsPurchaseProcessingProcedurePriceItemList.add(paramsPurchaseProcessingProcedurePriceItem);
                        paramsSaleProcessingProcedurePriceItemList.add(paramsSaleProcessingProcedurePriceItem);
                    }
                }
                if (CollectionUtils.isEmpty(purchaseManagementClassifyItemList)) continue;
                for (PurchaseManagementClassifyItem purchaseManagementClassifyItem : purchaseManagementClassifyItemList) {
                    PurchaseManagementClassifyItem paramsPurchaseManagementClassifyItem = new PurchaseManagementClassifyItem();
                    SaleManagementClassifyItem paramsSaleManagementClassifyItem = new SaleManagementClassifyItem();
                    BeanUtils.copyProperties((Object)((Object)purchaseManagementClassifyItem), (Object)((Object)paramsSaleManagementClassifyItem));
                    paramsSaleManagementClassifyItem.setId(IdWorker.getIdStr());
                    paramsSaleManagementClassifyItem.setRelationId(purchaseManagementClassifyItem.getId());
                    paramsSaleManagementClassifyItem.setHeadId(salePriceEvaluationStandardHead.getId());
                    paramsPurchaseManagementClassifyItem.setId(purchaseManagementClassifyItem.getId());
                    paramsPurchaseManagementClassifyItem.setRelationId(purchaseManagementClassifyItem.getId());
                    paramsPurchaseManagementClassifyItemList.add(paramsPurchaseManagementClassifyItem);
                    paramsSaleManagementClassifyItemList.add(paramsSaleManagementClassifyItem);
                }
            }
            if (CollUtil.isNotEmpty(paramsSalePriceEvaluationStandardHeadList)) {
                this.salePriceEvaluationStandardHeadService.saveBatch(paramsSalePriceEvaluationStandardHeadList);
            }
            if (CollUtil.isNotEmpty(paramsPurchasePriceEvaluationItemList)) {
                this.purchasePriceEvaluationItemService.updateBatchById(paramsPurchasePriceEvaluationItemList);
            }
            if (CollUtil.isNotEmpty(paramsSalePriceEvaluationItemList)) {
                this.salePriceEvaluationItemService.saveBatch(paramsSalePriceEvaluationItemList);
            }
            if (CollUtil.isNotEmpty(paramsPurchaseProcessingProcedurePriceItemList)) {
                this.purchaseProcessingProcedurePriceItemService.updateBatchById(paramsPurchaseProcessingProcedurePriceItemList);
            }
            if (CollUtil.isNotEmpty(paramsSaleProcessingProcedurePriceItemList)) {
                this.saleProcessingProcedurePriceItemService.saveBatch(paramsSaleProcessingProcedurePriceItemList);
            }
            if (CollUtil.isNotEmpty(paramsPurchaseManagementClassifyItemList)) {
                this.purchaseManagementClassifyItemService.updateBatchById(paramsPurchaseManagementClassifyItemList);
            }
            if (CollUtil.isNotEmpty(paramsSaleManagementClassifyItemList)) {
                this.saleManagementClassifyItemService.saveBatch(paramsSaleManagementClassifyItemList);
            }
            for (SalePriceEvaluationStandardHead salePriceEvaluationStandardHead : paramsSalePriceEvaluationStandardHeadList) {
                PriceEvaluationJobUtil.createEndJob(salePriceEvaluationStandardHead.getElsAccount(), salePriceEvaluationStandardHead.getId(), salePriceEvaluationStandardHead.getDocumentNumber(), salePriceEvaluationStandardHead.getDeadline());
            }
        } else {
            throw new ELSBootException("\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u884c\u4f9b\u5e94\u5546\u4fe1\u606f");
        }
        log.info("\u6838\u4ef7\u6807\u51c6\u53d1\u5e03\u5b8c\u6bd5");
    }

    @Override
    public void generatePrice(PurchasePriceEvaluationStandardHeadVO purchasePriceEvaluationStandardHeadPage) {
        ArrayList<PurchaseInformationRecordsDTO> recordsList;
        List<PurchaseSupplierEvaluationStander> purchaseSupplierEvaluationStanderList = purchasePriceEvaluationStandardHeadPage.getPurchaseSupplierEvaluationStanderList();
        if (!CollectionUtils.isEmpty(purchaseSupplierEvaluationStanderList)) {
            recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
            for (PurchaseSupplierEvaluationStander purchaseSupplierEvaluationStander : purchaseSupplierEvaluationStanderList) {
                PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
                records.setMaterialId(purchasePriceEvaluationStandardHeadPage.getMaterialId());
                records.setMaterialGroup(purchasePriceEvaluationStandardHeadPage.getMaterialGroup());
                records.setMaterialName(purchasePriceEvaluationStandardHeadPage.getMaterialName());
                records.setMaterialNumber(purchasePriceEvaluationStandardHeadPage.getMaterialNumber());
                records.setPurchaseGroup(purchasePriceEvaluationStandardHeadPage.getPurchaseGroup());
                records.setPurchaseOrg(purchasePriceEvaluationStandardHeadPage.getPurchaseOrg());
                records.setCompany(purchasePriceEvaluationStandardHeadPage.getCompany());
                records.setPurchaseUnit(purchasePriceEvaluationStandardHeadPage.getPurchaseUnit());
                records.setSourceId(purchasePriceEvaluationStandardHeadPage.getId());
                records.setSourceItemId(purchaseSupplierEvaluationStander.getId());
                records.setSourceType(PriceSourceTypeEnum.EVALUATION_STANDARD.getValue());
                records.setSourceNumber(purchasePriceEvaluationStandardHeadPage.getDocumentNumber());
                records.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
                records.setCurrencyCode(purchasePriceEvaluationStandardHeadPage.getCurrency());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
                records.setEffectiveDate(purchasePriceEvaluationStandardHeadPage.getEffectiveDate());
                records.setExpiryDate(purchasePriceEvaluationStandardHeadPage.getExpiryDate());
                recordsList.add(records);
            }
        } else {
            throw new ELSBootException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5df2\u786e\u8ba4\u7684\u4f9b\u5e94\u5546\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e");
        }
        this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
        this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
    }

    @Override
    public String copyPriceEvaluationStandard(String id) {
        PurchasePriceEvaluationStandardHead purchasePriceEvaluationStandardHead = (PurchasePriceEvaluationStandardHead)((Object)this.getById((Serializable)((Object)id)));
        if (purchasePriceEvaluationStandardHead != null) {
            LoginUser loginUser = SysUtil.getLoginUser();
            PurchasePriceEvaluationStandardHead paramsEvaluationHead = new PurchasePriceEvaluationStandardHead();
            BeanUtils.copyProperties((Object)((Object)purchasePriceEvaluationStandardHead), (Object)((Object)paramsEvaluationHead));
            paramsEvaluationHead.setId(IdWorker.getIdStr());
            paramsEvaluationHead.setRelationId(null);
            paramsEvaluationHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            paramsEvaluationHead.setDocumentStatus(PurchasePriceEvaluationStandardStatusEnum.NEW.getValue());
            paramsEvaluationHead.setDocumentNumber(this.baseRpcService.getNextCode("purchasePriceEvaluationStandardHeadNumber", (Object)purchasePriceEvaluationStandardHead));
            paramsEvaluationHead.setCreateTime(new Date());
            paramsEvaluationHead.setCreateBy(loginUser.getSubAccount());
            paramsEvaluationHead.setUpdateBy(loginUser.getSubAccount());
            paramsEvaluationHead.setUpdateTime(new Date());
            this.save((Object)paramsEvaluationHead);
            List<PurchasePriceEvaluationItem> purchasePriceEvaluationItems = this.purchasePriceEvaluationItemService.selectByMainId(id);
            List<PurchaseProcessingProcedurePriceItem> purchaseProcessingProcedurePriceItems = this.purchaseProcessingProcedurePriceItemService.selectByMainId(id);
            List<PurchaseManagementClassifyItem> purchaseManagementClassifyItems = this.purchaseManagementClassifyItemService.selectByMainId(id);
            if (!CollectionUtils.isEmpty(purchasePriceEvaluationItems)) {
                ArrayList<PurchasePriceEvaluationItem> paramsPurchasePriceEvaluationItems = new ArrayList<PurchasePriceEvaluationItem>();
                for (PurchasePriceEvaluationItem purchasePriceEvaluationItem : purchasePriceEvaluationItems) {
                    PurchasePriceEvaluationItem paramsPurchasePriceEvaluationItem = new PurchasePriceEvaluationItem();
                    BeanUtils.copyProperties((Object)((Object)purchasePriceEvaluationItem), (Object)((Object)paramsPurchasePriceEvaluationItem));
                    paramsPurchasePriceEvaluationItem.setHeadId(paramsEvaluationHead.getId());
                    paramsPurchasePriceEvaluationItem.setId(IdWorker.getIdStr());
                    SysUtil.setSysParam((BaseEntity)paramsPurchasePriceEvaluationItem, (BaseEntity)paramsEvaluationHead);
                    paramsPurchasePriceEvaluationItems.add(paramsPurchasePriceEvaluationItem);
                }
                this.purchasePriceEvaluationItemService.saveBatch(paramsPurchasePriceEvaluationItems);
            }
            if (!CollectionUtils.isEmpty(purchaseProcessingProcedurePriceItems)) {
                ArrayList<PurchaseProcessingProcedurePriceItem> paramsPurchaseProcessingProcedurePriceItems = new ArrayList<PurchaseProcessingProcedurePriceItem>();
                for (PurchaseProcessingProcedurePriceItem purchaseProcessingProcedurePriceItem : purchaseProcessingProcedurePriceItems) {
                    PurchaseProcessingProcedurePriceItem paramsPurchaseProcessingProcedurePriceItem = new PurchaseProcessingProcedurePriceItem();
                    BeanUtils.copyProperties((Object)((Object)purchaseProcessingProcedurePriceItem), (Object)((Object)paramsPurchaseProcessingProcedurePriceItem));
                    paramsPurchaseProcessingProcedurePriceItem.setHeadId(paramsEvaluationHead.getId());
                    SysUtil.setSysParam((BaseEntity)paramsPurchaseProcessingProcedurePriceItem, (BaseEntity)paramsEvaluationHead);
                    paramsPurchaseProcessingProcedurePriceItem.setId(IdWorker.getIdStr());
                    paramsPurchaseProcessingProcedurePriceItems.add(paramsPurchaseProcessingProcedurePriceItem);
                }
                this.purchaseProcessingProcedurePriceItemService.saveBatch(paramsPurchaseProcessingProcedurePriceItems);
            }
            if (!CollectionUtils.isEmpty(purchaseManagementClassifyItems)) {
                ArrayList<PurchaseManagementClassifyItem> paramsPurchaseManagementClassifyItems = new ArrayList<PurchaseManagementClassifyItem>();
                for (PurchaseManagementClassifyItem purchaseManagementClassifyItem : purchaseManagementClassifyItems) {
                    PurchaseManagementClassifyItem paramsPurchaseManagementClassifyItem = new PurchaseManagementClassifyItem();
                    BeanUtils.copyProperties((Object)((Object)purchaseManagementClassifyItem), (Object)((Object)paramsPurchaseManagementClassifyItem));
                    paramsPurchaseManagementClassifyItem.setHeadId(paramsEvaluationHead.getId());
                    SysUtil.setSysParam((BaseEntity)paramsPurchaseManagementClassifyItem, (BaseEntity)paramsEvaluationHead);
                    paramsPurchaseManagementClassifyItem.setId(IdWorker.getIdStr());
                    paramsPurchaseManagementClassifyItems.add(paramsPurchaseManagementClassifyItem);
                }
                this.purchaseManagementClassifyItemService.saveBatch(paramsPurchaseManagementClassifyItems);
            }
            return "\u590d\u5236\u6210\u529f\uff0c\u5355\u636e\u53f7:" + paramsEvaluationHead.getDocumentNumber();
        }
        return null;
    }

    @Override
    public String upVersion(String id) {
        PurchasePriceEvaluationStandardHead purchasePriceEvaluationStandardHead = (PurchasePriceEvaluationStandardHead)((Object)this.getById((Serializable)((Object)id)));
        if (purchasePriceEvaluationStandardHead != null) {
            LoginUser loginUser = SysUtil.getLoginUser();
            PurchasePriceEvaluationStandardHead paramsEvaluationHead = new PurchasePriceEvaluationStandardHead();
            BeanUtils.copyProperties((Object)((Object)purchasePriceEvaluationStandardHead), (Object)((Object)paramsEvaluationHead));
            paramsEvaluationHead.setId(IdWorker.getIdStr());
            paramsEvaluationHead.setRelationId(null);
            paramsEvaluationHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            paramsEvaluationHead.setDocumentStatus(PurchasePriceEvaluationStandardStatusEnum.NEW.getValue());
            paramsEvaluationHead.setDocumentNumber(this.baseRpcService.getNextCode("purchasePriceEvaluationStandardHeadNumber", (Object)purchasePriceEvaluationStandardHead));
            paramsEvaluationHead.setCreateTime(new Date());
            paramsEvaluationHead.setCreateBy(loginUser.getSubAccount());
            paramsEvaluationHead.setUpdateBy(loginUser.getSubAccount());
            paramsEvaluationHead.setUpdateTime(new Date());
            String documentVersion = purchasePriceEvaluationStandardHead.getDocumentVersion();
            if (StringUtils.isEmpty((Object)documentVersion)) {
                documentVersion = "1";
            }
            Integer documentVersionInt = Integer.parseInt(documentVersion);
            paramsEvaluationHead.setDocumentVersion(documentVersionInt + 1 + "");
            this.save((Object)paramsEvaluationHead);
            List<PurchasePriceEvaluationItem> purchasePriceEvaluationItems = this.purchasePriceEvaluationItemService.selectByMainId(id);
            List<PurchaseProcessingProcedurePriceItem> purchaseProcessingProcedurePriceItems = this.purchaseProcessingProcedurePriceItemService.selectByMainId(id);
            List<PurchaseManagementClassifyItem> purchaseManagementClassifyItems = this.purchaseManagementClassifyItemService.selectByMainId(id);
            if (!CollectionUtils.isEmpty(purchasePriceEvaluationItems)) {
                ArrayList<PurchasePriceEvaluationItem> paramsPurchasePriceEvaluationItems = new ArrayList<PurchasePriceEvaluationItem>();
                for (PurchasePriceEvaluationItem purchasePriceEvaluationItem : purchasePriceEvaluationItems) {
                    PurchasePriceEvaluationItem paramsPurchasePriceEvaluationItem = new PurchasePriceEvaluationItem();
                    BeanUtils.copyProperties((Object)((Object)purchasePriceEvaluationItem), (Object)((Object)paramsPurchasePriceEvaluationItem));
                    paramsPurchasePriceEvaluationItem.setHeadId(paramsEvaluationHead.getId());
                    paramsPurchasePriceEvaluationItem.setId(IdWorker.getIdStr());
                    SysUtil.setSysParam((BaseEntity)paramsPurchasePriceEvaluationItem, (BaseEntity)paramsEvaluationHead);
                    paramsPurchasePriceEvaluationItems.add(paramsPurchasePriceEvaluationItem);
                }
                this.purchasePriceEvaluationItemService.saveBatch(paramsPurchasePriceEvaluationItems);
            }
            if (!CollectionUtils.isEmpty(purchaseProcessingProcedurePriceItems)) {
                ArrayList<PurchaseProcessingProcedurePriceItem> paramsPurchaseProcessingProcedurePriceItems = new ArrayList<PurchaseProcessingProcedurePriceItem>();
                for (PurchaseProcessingProcedurePriceItem purchaseProcessingProcedurePriceItem : purchaseProcessingProcedurePriceItems) {
                    PurchaseProcessingProcedurePriceItem paramsPurchaseProcessingProcedurePriceItem = new PurchaseProcessingProcedurePriceItem();
                    BeanUtils.copyProperties((Object)((Object)purchaseProcessingProcedurePriceItem), (Object)((Object)paramsPurchaseProcessingProcedurePriceItem));
                    paramsPurchaseProcessingProcedurePriceItem.setHeadId(paramsEvaluationHead.getId());
                    SysUtil.setSysParam((BaseEntity)paramsPurchaseProcessingProcedurePriceItem, (BaseEntity)paramsEvaluationHead);
                    paramsPurchaseProcessingProcedurePriceItem.setId(IdWorker.getIdStr());
                    paramsPurchaseProcessingProcedurePriceItems.add(paramsPurchaseProcessingProcedurePriceItem);
                }
                this.purchaseProcessingProcedurePriceItemService.saveBatch(paramsPurchaseProcessingProcedurePriceItems);
            }
            if (!CollectionUtils.isEmpty(purchaseManagementClassifyItems)) {
                ArrayList<PurchaseManagementClassifyItem> paramsPurchaseManagementClassifyItems = new ArrayList<PurchaseManagementClassifyItem>();
                for (PurchaseManagementClassifyItem purchaseManagementClassifyItem : purchaseManagementClassifyItems) {
                    PurchaseManagementClassifyItem paramsPurchaseManagementClassifyItem = new PurchaseManagementClassifyItem();
                    BeanUtils.copyProperties((Object)((Object)purchaseManagementClassifyItem), (Object)((Object)paramsPurchaseManagementClassifyItem));
                    paramsPurchaseManagementClassifyItem.setHeadId(paramsEvaluationHead.getId());
                    SysUtil.setSysParam((BaseEntity)paramsPurchaseManagementClassifyItem, (BaseEntity)paramsEvaluationHead);
                    paramsPurchaseManagementClassifyItem.setId(IdWorker.getIdStr());
                    paramsPurchaseManagementClassifyItems.add(paramsPurchaseManagementClassifyItem);
                }
                this.purchaseManagementClassifyItemService.saveBatch(paramsPurchaseManagementClassifyItems);
            }
            return "\u5347\u7ea7\u6210\u529f\uff0c\u5355\u636e\u53f7:" + paramsEvaluationHead.getDocumentNumber();
        }
        return null;
    }
}

