/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.abnormal.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.tender.abnormal.entity.PurchaseTenderAgainSubpackageHead;
import com.els.modules.tender.abnormal.entity.PurchaseTenderAgainSubpackageItem;
import com.els.modules.tender.abnormal.mapper.PurchaseTenderAgainSubpackageHeadMapper;
import com.els.modules.tender.abnormal.service.PurchaseTenderAgainSubpackageHeadService;
import com.els.modules.tender.abnormal.service.PurchaseTenderAgainSubpackageItemService;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmNoticeEnum;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectItem;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.enumerate.TenderSubpackageDiscardTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectItemService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectSubpackageInfoVO;
import com.els.modules.tender.sale.enumerate.TenderInvitationSupplierReceiptSourceTypeEnum;
import com.els.modules.tender.sale.enumerate.TenderInvitationSupplierReceiptStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectPurchaseBidStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSignUpStatusEnum;
import com.els.modules.tender.sale.vo.TenderProjectPurchaseBidVO;
import com.els.modules.tender.sale.vo.TenderProjectSignUpVO;
import com.els.modules.tender.supplier.entity.TenderInvitationSupplierReceipt;
import com.els.modules.tender.supplier.entity.TenderProjectPurchaseBid;
import com.els.modules.tender.supplier.entity.TenderProjectSignUp;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderInvitationSupplierReceiptService;
import com.els.modules.tender.supplier.service.TenderProjectPurchaseBidService;
import com.els.modules.tender.supplier.service.TenderProjectSignUpService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderAgainSubpackageHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderAgainSubpackageHeadMapper, PurchaseTenderAgainSubpackageHead>
implements PurchaseTenderAgainSubpackageHeadService {
    @Autowired
    private PurchaseTenderAgainSubpackageItemService againSubpackageItemService;
    @Autowired
    private PurchaseTenderProjectItemService projectItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    @Resource
    private PurchaseTenderProjectHeadService tenderProjectHeadService;
    @Resource
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private TenderProjectSignUpService tenderProjectSignUpService;
    @Autowired
    private TenderProjectSupplierService supplierService;
    @Resource
    private TenderProjectPurchaseBidService purchaseBidService;
    @Autowired
    private TenderInvitationSupplierReceiptService invitationSupplierReceiptService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead, List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        if ("1".equals(purchaseTenderAgainSubpackageHead.getAudit())) {
            purchaseTenderAgainSubpackageHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseTenderAgainSubpackageHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        purchaseTenderAgainSubpackageHead.setStatus("0");
        purchaseTenderAgainSubpackageHead.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseTenderAgainSubpackageHead.setAgainNumber(this.invokeBaseRpcService.getNextCode("tenderAgainSubpackageNumber", (Object)purchaseTenderAgainSubpackageHead));
        ((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).insert((Object)purchaseTenderAgainSubpackageHead);
        this.insertData(purchaseTenderAgainSubpackageHead, purchaseTenderAgainSubpackageItemList, attachmentDTOList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead, List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        if ("1".equals(purchaseTenderAgainSubpackageHead.getAudit())) {
            purchaseTenderAgainSubpackageHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseTenderAgainSubpackageHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        int count = ((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).updateById((Object)purchaseTenderAgainSubpackageHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.againSubpackageItemService.deleteByMainId(purchaseTenderAgainSubpackageHead.getId());
        this.insertData(purchaseTenderAgainSubpackageHead, purchaseTenderAgainSubpackageItemList, attachmentDTOList);
    }

    private void insertData(PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead, List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        if (CollectionUtil.isNotEmpty(purchaseTenderAgainSubpackageItemList)) {
            for (PurchaseTenderAgainSubpackageItem entity : purchaseTenderAgainSubpackageItemList) {
                entity.setHeadId(purchaseTenderAgainSubpackageHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseTenderAgainSubpackageHead);
            }
            this.againSubpackageItemService.saveBatch(purchaseTenderAgainSubpackageItemList, 2000);
        }
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseTenderAgainSubpackageHead.getId());
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            attachmentDTOList.parallelStream().forEach(attachment -> attachment.setHeadId(purchaseTenderAgainSubpackageHead.getId()));
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentDTOList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.againSubpackageItemService.deleteByMainId(id);
        ((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.againSubpackageItemService.deleteByMainId(serializable.toString());
            ((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public PurchaseTenderAgainSubpackageHead queryAgainSubpackageBySubpackageId(String subpackageId) {
        return ((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).queryAgainSubpackageBySubpackageId(subpackageId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead, List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList) {
        this.checkParam(purchaseTenderAgainSubpackageHead, purchaseTenderAgainSubpackageItemList);
        purchaseTenderAgainSubpackageHead.setStatus(BidWinningAffirmNoticeEnum.ISSUE.getValue());
        ((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).updateById((Object)purchaseTenderAgainSubpackageHead);
        List<TenderProjectSupplier> supplierList = this.againSubpackage(purchaseTenderAgainSubpackageHead, purchaseTenderAgainSubpackageItemList);
        PurchaseTenderProjectSubpackageInfo projectSubpackageInfo = this.subpackageInfoService.selectById(purchaseTenderAgainSubpackageHead.getSubpackageId());
        projectSubpackageInfo.setStatus(TenderProjectSubpackageStatusEnum.BIDDING_HAS_AGAIN.getValue());
        projectSubpackageInfo.setInvalid("1");
        projectSubpackageInfo.setInvalidType(TenderSubpackageDiscardTypeEnum.RE_TENDER.getValue());
        this.subpackageInfoService.updateById((Object)projectSubpackageInfo);
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(purchaseTenderAgainSubpackageHead.getProjectId()).append("&subpackageId=").append(purchaseTenderAgainSubpackageHead.getSubpackageId()).append("&businessId=").append(purchaseTenderAgainSubpackageHead.getId());
        List toElsAccountList = supplierList.stream().map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
        this.sendMsg(TenantContext.getTenant(), toElsAccountList, (Object)projectSubpackageInfo, urlParams.toString(), "tender", "tenderAgainSubpackage");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead, List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList) {
        this.checkParam(purchaseTenderAgainSubpackageHead, purchaseTenderAgainSubpackageItemList);
        PurchaseTenderAgainSubpackageHead newVersionAgain = (PurchaseTenderAgainSubpackageHead)((Object)((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseTenderAgainSubpackageHead.getId())));
        purchaseTenderAgainSubpackageHead.setDataVersion(newVersionAgain.getDataVersion());
        AuditInputParamDTO dto = new AuditInputParamDTO();
        dto.setBusinessId(purchaseTenderAgainSubpackageHead.getId());
        dto.setBusinessType("againSubpackage");
        dto.setAuditSubject("\u91cd\u65b0\u62db\u6807 \u5355\u53f7: " + purchaseTenderAgainSubpackageHead.getAgainNumber());
        dto.setParams(JSONObject.toJSONString((Object)((Object)purchaseTenderAgainSubpackageHead)));
        this.inquiryInvokeWorkFlowRpcService.submit(dto);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<TenderProjectSupplier> againSubpackage(PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead, List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList) {
        String againProject = purchaseTenderAgainSubpackageHead.getAgainProject();
        String againSupplier = purchaseTenderAgainSubpackageHead.getAgainSupplier();
        String oldProjectId = purchaseTenderAgainSubpackageHead.getProjectId();
        String newProjectId = purchaseTenderAgainSubpackageHead.getProjectId();
        PurchaseTenderProjectHead purchaseTenderProjectHead = (PurchaseTenderProjectHead)((Object)this.tenderProjectHeadService.getBaseMapper().selectById((Serializable)((Object)oldProjectId)));
        List<PurchaseTenderProjectItem> tenderProjectItemList = this.projectItemService.selectByMainId(oldProjectId);
        List<String> oldIds = purchaseTenderAgainSubpackageItemList.stream().map(PurchaseTenderAgainSubpackageItem::getSubpackageId).collect(Collectors.toList());
        List<PurchaseTenderProjectSubpackageInfo> oldSubpackageInfos = this.subpackageInfoService.selectBatchIds(oldIds);
        ArrayList<PurchaseTenderProjectSubpackageInfo> newSubpackageInfos = new ArrayList<PurchaseTenderProjectSubpackageInfo>();
        List<TenderProjectSupplier> oldTenderProjectSupplierList = this.supplierService.selectByMainIds(oldIds);
        Map<Object, Object> oldsupplierMaps = new HashMap();
        List<TenderProjectSupplier> newTenderProjectSuppliers = new ArrayList<TenderProjectSupplier>();
        if (CollectionUtil.isNotEmpty(oldTenderProjectSupplierList)) {
            oldsupplierMaps = oldTenderProjectSupplierList.stream().collect(Collectors.groupingBy(TenderProjectSupplier::getSubpackageId));
        }
        List<TenderInvitationSupplierReceipt> supplierReceipts = this.invitationSupplierReceiptService.selectByMainIds(oldIds);
        Map<Object, Object> oldSupplierReceiptMaps = new HashMap();
        List<Object> newSupplierReceipts = new ArrayList();
        if (CollectionUtil.isNotEmpty(supplierReceipts)) {
            oldSupplierReceiptMaps = supplierReceipts.stream().collect(Collectors.groupingBy(TenderInvitationSupplierReceipt::getSubpackageId));
        }
        List<TenderProjectSignUpVO> oldTenderSignUpVo = this.tenderProjectSignUpService.selectByMainIds(oldIds);
        Map<Object, Object> oldSignUpMaps = new HashMap();
        ArrayList<TenderProjectSignUpVO> newTenderProjectSignUpVOS = new ArrayList();
        if (CollectionUtil.isNotEmpty(oldTenderSignUpVo)) {
            oldSignUpMaps = oldTenderSignUpVo.stream().collect(Collectors.groupingBy(TenderProjectSignUp::getSubpackageId));
        }
        List<TenderProjectPurchaseBidVO> oldPurchaseBidVo = this.purchaseBidService.selectByMainIds(oldIds);
        Map<Object, Object> oldPurchaseBidMaps = new HashMap();
        ArrayList<TenderProjectPurchaseBidVO> newTenderProjectPurchaseBidVOS = new ArrayList();
        if (CollectionUtil.isNotEmpty(oldPurchaseBidVo)) {
            oldPurchaseBidMaps = oldPurchaseBidVo.stream().collect(Collectors.groupingBy(TenderProjectPurchaseBid::getSubpackageId));
        }
        if ("1".equals(againProject)) {
            newProjectId = IdWorker.getIdStr();
            purchaseTenderProjectHead.setId(newProjectId);
            this.tenderProjectHeadService.saveMain(purchaseTenderProjectHead, new ArrayList<PurchaseTenderProjectSubpackageInfoVO>(), tenderProjectItemList, new ArrayList<PurchaseAttachmentDTO>());
        }
        for (PurchaseTenderAgainSubpackageItem oldSubpackageInfo : purchaseTenderAgainSubpackageItemList) {
            PurchaseTenderProjectSubpackageInfo oldSubpackage = (PurchaseTenderProjectSubpackageInfo)((Object)SysUtil.copyProperties((Object)((Object)oldSubpackageInfo), PurchaseTenderProjectSubpackageInfo.class));
            PurchaseTenderProjectSubpackageInfo newSubpackage = (PurchaseTenderProjectSubpackageInfo)((Object)SysUtil.copyProperties((Object)((Object)oldSubpackageInfo), PurchaseTenderProjectSubpackageInfo.class));
            this.builderSubpackageInfo(newSubpackage, newProjectId, oldProjectId, "1".equals(againProject), purchaseTenderProjectHead);
            if (oldsupplierMaps != null && oldsupplierMaps.size() > 0) {
                List tenderProjectSuppliers = (List)oldsupplierMaps.get(oldSubpackage.getId());
                newTenderProjectSuppliers = this.builderTenderSupplier(tenderProjectSuppliers, newSubpackage, "1".equals(againProject));
            }
            if (oldSupplierReceiptMaps != null && oldSupplierReceiptMaps.size() > 0) {
                List invitationSupplierReceipts = (List)oldSupplierReceiptMaps.get(oldSubpackage.getId());
                newSupplierReceipts = this.builderTenderInvitaionSupplier(invitationSupplierReceipts, newSubpackage, "1".equals(againProject), purchaseTenderProjectHead);
            }
            if (oldSignUpMaps != null && oldSignUpMaps.size() > 0) {
                List tenderProjectSignUpVOS = (List)oldSignUpMaps.get(oldSubpackage.getId());
                newTenderProjectSignUpVOS = this.builderSignUp(tenderProjectSignUpVOS, newSubpackage, "1".equals(againProject));
            }
            if (oldPurchaseBidMaps != null && oldPurchaseBidMaps.size() > 0) {
                List tenderProjectPurchaseBidVOS = (List)oldPurchaseBidMaps.get(oldSubpackage.getId());
                newTenderProjectPurchaseBidVOS = this.builderBidding(tenderProjectPurchaseBidVOS, newSubpackage, "1".equals(againProject));
            }
            newSubpackageInfos.add(newSubpackage);
        }
        oldSubpackageInfos.stream().forEach(item -> {
            item.setStatus(TenderProjectSubpackageStatusEnum.BIDDING_HAS_AGAIN.getValue());
            item.setInvalid("1");
            item.setInvalidType(TenderSubpackageDiscardTypeEnum.RE_TENDER.getValue());
        });
        this.subpackageInfoService.updateBatchById(oldSubpackageInfos);
        this.subpackageInfoService.saveBatch(newSubpackageInfos);
        if ("1".equals(againSupplier)) {
            List newSubpackageIds = newSubpackageInfos.stream().filter(newSubpackageInfo -> SubpackageTypeEnum.INVITE_TENDER.getValue().equals(newSubpackageInfo.getTenderType()) || SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(newSubpackageInfo.getCheckType())).map(BaseEntity::getId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(newTenderProjectSuppliers = newTenderProjectSuppliers.stream().filter(supplier -> !newSubpackageIds.contains(supplier.getSubpackageId())).collect(Collectors.toList()))) {
                this.supplierService.saveBatch(newTenderProjectSuppliers);
            }
            if (CollectionUtil.isNotEmpty(newSupplierReceipts = newSupplierReceipts.stream().filter(supplierReceipt -> !newSubpackageIds.contains(supplierReceipt.getSubpackageId())).collect(Collectors.toList()))) {
                this.invitationSupplierReceiptService.saveBatch(newSupplierReceipts);
            }
            if (CollectionUtil.isNotEmpty(newTenderProjectSignUpVOS = newTenderProjectSignUpVOS.stream().filter(projectSignUp -> !newSubpackageIds.contains(projectSignUp.getSubpackageId())).collect(Collectors.toList()))) {
                this.tenderProjectSignUpService.dataVoSaveBatch(newTenderProjectSignUpVOS);
            }
            if (CollectionUtil.isNotEmpty(newTenderProjectPurchaseBidVOS = newTenderProjectPurchaseBidVOS.stream().filter(purchaseBid -> !newSubpackageIds.contains(purchaseBid.getSubpackageId())).collect(Collectors.toList()))) {
                this.purchaseBidService.dataVoSaveBatch(newTenderProjectPurchaseBidVOS);
            }
        }
        return newTenderProjectSuppliers;
    }

    private void builderSubpackageInfo(PurchaseTenderProjectSubpackageInfo subpackageInfo, String newProjectId, String oldProjectId, boolean againProject, PurchaseTenderProjectHead purchaseTenderProjectHead) {
        subpackageInfo.setId(IdWorker.getIdStr());
        subpackageInfo.setTenderProjectName(purchaseTenderProjectHead.getTenderProjectName());
        if (againProject) {
            subpackageInfo.setHeadId(newProjectId);
            subpackageInfo.setStatus(TenderProjectSubpackageStatusEnum.NEW.getValue());
        } else {
            subpackageInfo.setHeadId(oldProjectId);
            subpackageInfo.setStatus(TenderProjectSubpackageStatusEnum.ENABLED.getValue());
        }
        subpackageInfo.setSubpackageNumber(this.invokeBaseRpcService.getNextCode("subpackageNumber", (Object)subpackageInfo));
        subpackageInfo.setDeleted(CommonConstant.DEL_FLAG_0);
    }

    private List<TenderProjectSupplier> builderTenderSupplier(List<TenderProjectSupplier> tenderProjectSuppliers, PurchaseTenderProjectSubpackageInfo subpackageInfo, boolean againProject) {
        for (TenderProjectSupplier tenderProjectSupplier : tenderProjectSuppliers) {
            tenderProjectSupplier.setSubpackageId(subpackageInfo.getId());
            tenderProjectSupplier.setTenderProjectId(subpackageInfo.getHeadId());
            tenderProjectSupplier.setCheckType(subpackageInfo.getCheckType());
            tenderProjectSupplier.setSubpackageName(subpackageInfo.getSubpackageName());
            if (againProject) {
                tenderProjectSupplier.setSignUp("0");
                tenderProjectSupplier.setPurchaseBid("0");
                tenderProjectSupplier.setPrePurchaseBid("0");
            }
            tenderProjectSupplier.setPreSignIn("0");
            tenderProjectSupplier.setPreDecrypt("0");
            tenderProjectSupplier.setSignature("0");
            tenderProjectSupplier.setPreShortlisted("0");
            tenderProjectSupplier.setInvite("0");
            tenderProjectSupplier.setDecrypt("0");
            tenderProjectSupplier.setResultDecrypt("0");
            tenderProjectSupplier.setWinner("0");
            tenderProjectSupplier.setOpenBidStatus(PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue());
            tenderProjectSupplier.setSignIn("0");
            tenderProjectSupplier.setDeleted(CommonConstant.DEL_FLAG_0);
            tenderProjectSupplier.setShortlisted("0");
            tenderProjectSupplier.setResultShortlisted("0");
            tenderProjectSupplier.setId(null);
            tenderProjectSupplier.setPreResponseStatus("0");
            tenderProjectSupplier.setPreResponseTime(null);
            tenderProjectSupplier.setResponseStatus("0");
            tenderProjectSupplier.setResponseTime(null);
            tenderProjectSupplier.setResultResponseTime(null);
            tenderProjectSupplier.setResultResponseStatus("0");
            tenderProjectSupplier.setFilePassword(null);
            tenderProjectSupplier.setPreFilePassword(null);
        }
        return tenderProjectSuppliers;
    }

    private List<TenderInvitationSupplierReceipt> builderTenderInvitaionSupplier(List<TenderInvitationSupplierReceipt> invitationSupplierReceipts, PurchaseTenderProjectSubpackageInfo newSubpackage, boolean againProject, PurchaseTenderProjectHead purchaseTenderProjectHead) {
        for (TenderInvitationSupplierReceipt invitationSupplierReceipt : invitationSupplierReceipts) {
            invitationSupplierReceipt.setSubpackageId(newSubpackage.getId());
            invitationSupplierReceipt.setSourceType(TenderInvitationSupplierReceiptSourceTypeEnum.ON_LINE.getValue());
            invitationSupplierReceipt.setSubpackageName(newSubpackage.getSubpackageName());
            invitationSupplierReceipt.setTenderProjectId(newSubpackage.getHeadId());
            invitationSupplierReceipt.setId(null);
            if (!againProject) continue;
            invitationSupplierReceipt.setReceiptStatus(TenderInvitationSupplierReceiptStatusEnum.NEW.getValue());
            invitationSupplierReceipt.setReceiptPerson(null);
            invitationSupplierReceipt.setReceiptPhone(null);
            invitationSupplierReceipt.setReceiptTime(null);
            invitationSupplierReceipt.setTenderProjectNumber(purchaseTenderProjectHead.getTenderProjectNumber());
            invitationSupplierReceipt.setTenderProjectName(purchaseTenderProjectHead.getTenderProjectName());
        }
        return invitationSupplierReceipts;
    }

    private List<TenderProjectSignUpVO> builderSignUp(List<TenderProjectSignUpVO> tenderProjectSignUpVOs, PurchaseTenderProjectSubpackageInfo subpackageInfo, boolean againProject) {
        for (TenderProjectSignUpVO tenderProjectSignUpVO : tenderProjectSignUpVOs) {
            tenderProjectSignUpVO.setId(IdWorker.getIdStr());
            tenderProjectSignUpVO.setSubpackageId(subpackageInfo.getId());
            tenderProjectSignUpVO.setSubpackageName(subpackageInfo.getSubpackageName());
            tenderProjectSignUpVO.setTenderProjectId(subpackageInfo.getHeadId());
            tenderProjectSignUpVO.setTenderProjectName(subpackageInfo.getTenderProjectName());
            tenderProjectSignUpVO.getAttachmentList().stream().forEach(item -> {
                item.setId(null);
                item.setHeadId(tenderProjectSignUpVO.getId());
            });
            if (!againProject) continue;
            tenderProjectSignUpVO.setStatus(TenderProjectSignUpStatusEnum.NEW.getValue());
        }
        return tenderProjectSignUpVOs;
    }

    private List<TenderProjectPurchaseBidVO> builderBidding(List<TenderProjectPurchaseBidVO> tenderProjectPurchaseBidVos, PurchaseTenderProjectSubpackageInfo subpackageInfo, boolean againProject) {
        for (TenderProjectPurchaseBidVO tenderProjectPurchaseBidVo : tenderProjectPurchaseBidVos) {
            tenderProjectPurchaseBidVo.setId(IdWorker.getIdStr());
            tenderProjectPurchaseBidVo.setSubpackageId(subpackageInfo.getId());
            tenderProjectPurchaseBidVo.setTenderProjectId(subpackageInfo.getHeadId());
            tenderProjectPurchaseBidVo.setTenderProjectName(subpackageInfo.getTenderProjectName());
            if (CollectionUtil.isNotEmpty(tenderProjectPurchaseBidVo.getSaleTenderInvoiceInfoList())) {
                tenderProjectPurchaseBidVo.getSaleTenderInvoiceInfoList().stream().forEach(item -> item.setId(tenderProjectPurchaseBidVo.getId()));
            }
            if (CollectionUtil.isNotEmpty(tenderProjectPurchaseBidVo.getAttachmentList())) {
                tenderProjectPurchaseBidVo.getAttachmentList().stream().forEach(item -> {
                    item.setId(null);
                    item.setHeadId(tenderProjectPurchaseBidVo.getId());
                });
            }
            if (!againProject) continue;
            tenderProjectPurchaseBidVo.setStatus(TenderProjectPurchaseBidStatusEnum.NEW.getValue());
        }
        return tenderProjectPurchaseBidVos;
    }

    private void checkParam(PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead, List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList) {
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(purchaseTenderAgainSubpackageItemList), (String)I18nUtil.translate((String)"", (String)"\u5206\u5305\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
    }
}

