/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.attachment.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetter;
import com.els.modules.tender.attachment.entity.PurchaseTenderPriceOpeningsTemplate;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentHead;
import com.els.modules.tender.attachment.enumerate.PurchaseTenderBidLetterFormatTypeEnum;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderProjectAttachmentHeadVO;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u62db\u6807\u5927\u5385-\u62db\u6807\u6587\u4ef6-\u5934\u8868\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/tender/tenderProjectAttachmentInfo"})
public class PurchaseTenderProjectAttachmentHeadController
extends BaseController<PurchaseTenderProjectAttachmentHead, PurchaseTenderProjectAttachmentHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectAttachmentHeadController.class);
    @Autowired
    private PurchaseTenderProjectAttachmentHeadService purchaseTenderProjectAttachmentHeadService;

    @AutoLog(value="\u62db\u6807\u6587\u4ef6-\u67e5\u8be2\u62db\u6807\u6587\u4ef6\u4e0b\u6240\u6709\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u8be2\u62db\u6807\u6587\u4ef6\u4e0b\u6240\u6709\u4fe1\u606f", notes="\u67e5\u8be2\u62db\u6807\u6587\u4ef6\u4e0b\u6240\u6709\u4fe1\u606f")
    @GetMapping(value={"/query"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> query(@RequestParam(name="subpackageId") String subpackageId) {
        PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectAttachmentHeadVo = this.purchaseTenderProjectAttachmentHeadService.queryAll(subpackageId);
        return Result.ok((Object)((Object)purchaseTenderProjectAttachmentHeadVo));
    }

    @AutoLog(value="\u62db\u6807\u6587\u4ef6-\u6dfb\u52a0\u6240\u6709")
    @ApiOperation(value="\u6dfb\u52a0\u62db\u6807\u6587\u4ef6\u4e2d\u6240\u6709\u4fe1\u606f", notes="\u6dfb\u52a0\u62db\u6807\u6587\u4ef6\u4e2d\u6240\u6709\u4fe1\u606f")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:add"})
    public Result<?> add(@RequestBody PurchaseTenderProjectAttachmentHeadVO tenderProjectAttachmentInfoVo) {
        long start = System.currentTimeMillis();
        this.setCustomizeFieldParam(tenderProjectAttachmentInfoVo);
        this.purchaseTenderProjectAttachmentHeadService.insertMain(tenderProjectAttachmentInfoVo);
        long end = System.currentTimeMillis();
        log.info("\u62db\u6807\u6587\u4ef6\u6dfb\u52a0\u6240\u6709\u6267\u884c\u65f6\u95f4\u4e3a\uff1a" + (end - start));
        return Result.ok((Object)((Object)this.purchaseTenderProjectAttachmentHeadService.queryAll(tenderProjectAttachmentInfoVo.getSubpackageId())));
    }

    public void setCustomizeFieldParam(PurchaseTenderProjectAttachmentHeadVO tenderProjectAttachmentInfoVo) {
        PurchaseTenderBidLetterFormatGroupVO tenderBidLetterFormatGroupVo = tenderProjectAttachmentInfoVo.getTenderBidLetterFormatGroupVo();
        List<PurchaseTenderBidLetterVO> tenderBidTetterVoList = tenderBidLetterFormatGroupVo.getTenderBidTetterVoList();
        for (PurchaseTenderBidLetterVO purchaseTenderBidLetterVO : tenderBidTetterVoList) {
            String customizeFieldModel = purchaseTenderBidLetterVO.getCustomizeFieldModel();
            String customizeFieldData = purchaseTenderBidLetterVO.getCustomizeFieldData();
            PurchaseTenderPriceOpeningsTemplate priceOpenings = new PurchaseTenderPriceOpeningsTemplate();
            priceOpenings.setCustomizeFieldData(customizeFieldData);
            priceOpenings.setCustomizeFieldModel(customizeFieldModel);
            purchaseTenderBidLetterVO.setPriceOpenings(priceOpenings);
        }
    }

    @AutoLog(value="\u62db\u6807\u6587\u4ef6-\u7f16\u8f91\u6240\u6709")
    @ApiOperation(value="\u7f16\u8f91\u6240\u6709", notes="\u7f16\u8f91\u6240\u6709")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    public Result<?> edit(@RequestBody PurchaseTenderProjectAttachmentHeadVO tenderProjectAttachmentInfoVo) {
        long start = System.currentTimeMillis();
        this.setCustomizeFieldParam(tenderProjectAttachmentInfoVo);
        this.purchaseTenderProjectAttachmentHeadService.updateMain(tenderProjectAttachmentInfoVo);
        long end = System.currentTimeMillis();
        log.info("\u62db\u6807\u6587\u4ef6\u7f16\u8f91\u6240\u6709\u6267\u884c\u65f6\u95f4\u4e3a\uff1a" + (end - start));
        return Result.ok((Object)((Object)this.purchaseTenderProjectAttachmentHeadService.queryAll(tenderProjectAttachmentInfoVo.getSubpackageId())));
    }

    @AutoLog(value="\u62db\u6807\u6587\u4ef6-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> publish(@RequestBody PurchaseTenderProjectAttachmentHeadVO tenderProjectAttachmentInfoVo) {
        long start = System.currentTimeMillis();
        this.setCustomizeFieldParam(tenderProjectAttachmentInfoVo);
        this.purchaseTenderProjectAttachmentHeadService.publish(tenderProjectAttachmentInfoVo);
        long end = System.currentTimeMillis();
        log.info("\u62db\u6807\u6587\u4ef6\u53d1\u5e03\u6240\u6709\u6267\u884c\u65f6\u95f4\u4e3a\uff1a" + (end - start));
        return Result.ok((Object)((Object)this.purchaseTenderProjectAttachmentHeadService.queryAll(tenderProjectAttachmentInfoVo.getSubpackageId())));
    }

    @AutoLog(value="\u62db\u6807\u6587\u4ef6-\u83b7\u53d6\u6295\u6807\u51fd\u5217\u8868")
    @ApiOperation(value="\u83b7\u53d6\u6295\u6807\u51fd\u5217\u8868", notes="\u83b7\u53d6\u6295\u6807\u51fd\u5217\u8868")
    @GetMapping(value={"/queryTenderBidLetter"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryTenderBidLetterList(@RequestParam(name="subpackageId") String subpackageId, @RequestParam(name="currentStep", required=false) String currentStep) {
        TenderFlagInjectionContext.setTenderCurrentStep(currentStep);
        List<PurchaseTenderBidLetter> customColumnList = this.purchaseTenderProjectAttachmentHeadService.queryTenderBidLetterList(subpackageId);
        if ("1".equals(TenderFlagInjectionContext.getTenderProcessType()) && CollectionUtil.isNotEmpty(customColumnList)) {
            customColumnList = customColumnList.parallelStream().filter(purchaseTenderBidLetter -> !PurchaseTenderBidLetterFormatTypeEnum.OTHER.getValue().equals(purchaseTenderBidLetter.getFormatType())).collect(Collectors.toList());
        }
        return Result.ok(customColumnList);
    }

    @AutoLog(value="\u62db\u6807\u6587\u4ef6-\u83b7\u53d6\u4ef7\u683c\u5217\u4fe1\u606f")
    @ApiOperation(value="\u83b7\u53d6\u4ef7\u683c\u5217\u4fe1\u606f", notes="\u83b7\u53d6\u4ef7\u683c\u5217\u4fe1\u606f")
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @GetMapping(value={"/queryPriceColumn"})
    public Result<?> queryPriceColumn(@RequestParam(name="bidLetterId") String bidLetterId) {
        List<CustomColumnModel> customColumnList = this.purchaseTenderProjectAttachmentHeadService.queryPriceColumn(bidLetterId);
        return Result.ok(customColumnList);
    }
}

