/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationHead;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationItem;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationRecord;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationSupplier;
import com.els.modules.tender.clarification.entity.SaleTenderEvaClarificationHead;
import com.els.modules.tender.clarification.enumerate.PurchaseTenderEvaClarificationHeadStatusEnum;
import com.els.modules.tender.clarification.enumerate.TenderMentoringStatusEnum;
import com.els.modules.tender.clarification.mapper.PurchaseTenderEvaClarificationHeadMapper;
import com.els.modules.tender.clarification.service.PurchaseTenderEvaClarificationHeadService;
import com.els.modules.tender.clarification.service.PurchaseTenderEvaClarificationItemService;
import com.els.modules.tender.clarification.service.PurchaseTenderEvaClarificationRecordService;
import com.els.modules.tender.clarification.service.PurchaseTenderEvaClarificationSupplierService;
import com.els.modules.tender.clarification.service.SaleTenderEvaClarificationHeadService;
import com.els.modules.tender.clarification.vo.SaleTenderEvaClarificationItemVO;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaInfo;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaInfoService;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseTenderEvaClarificationHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderEvaClarificationHeadMapper, PurchaseTenderEvaClarificationHead>
implements PurchaseTenderEvaClarificationHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderEvaClarificationHeadServiceImpl.class);
    @Autowired
    private PurchaseTenderEvaClarificationItemService purchaseTenderEvaClarificationItemService;
    @Autowired
    private PurchaseTenderEvaClarificationRecordService purchaseTenderEvaClarificationRecordService;
    @Autowired
    private PurchaseTenderEvaClarificationSupplierService purchaseTenderEvaClarificationSupplierService;
    @Autowired
    private PurchaseTenderProjectEvaInfoService purchaseTenderProjectEvaInfoService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleTenderEvaClarificationHeadService saleTenderEvaClarificationHeadService;
    @Resource
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Resource
    @Lazy
    private PurchaseTenderProjectEvaInfoService evaInfoService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead, List<PurchaseTenderEvaClarificationSupplier> purchaseTenderEvaClarificationSupplierList, List<PurchaseAttachmentDTO> attachmentList) {
        this.checkBaseAndSetParam(purchaseTenderEvaClarificationHead);
        ((PurchaseTenderEvaClarificationHeadMapper)this.baseMapper).insert((Object)purchaseTenderEvaClarificationHead);
        super.setHeadDefaultValue((BaseEntity)purchaseTenderEvaClarificationHead);
        this.insertData(purchaseTenderEvaClarificationHead, purchaseTenderEvaClarificationSupplierList);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseTenderEvaClarificationHead.getId());
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(purchaseTenderEvaClarificationHead.getId()));
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead, List<PurchaseTenderEvaClarificationSupplier> purchaseTenderEvaClarificationSupplierList, List<PurchaseAttachmentDTO> attachmentList) {
        PurchaseTenderEvaClarificationHead evaClarificationHead = (PurchaseTenderEvaClarificationHead)((Object)((PurchaseTenderEvaClarificationHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseTenderEvaClarificationHead.getId())));
        Assert.notNull((Object)((Object)evaClarificationHead), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        Assert.isTrue((boolean)PurchaseTenderEvaClarificationHeadStatusEnum.NEW.getValue().equals(evaClarificationHead.getStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u4fee\u6539\uff01"));
        LoginUser loginUser = SysUtil.getLoginUser();
        Assert.isTrue((boolean)loginUser.getSubAccount().equals(evaClarificationHead.getSubAccount()), (String)I18nUtil.translate((String)"", (String)"\u65e0\u6743\u9650\u4fee\u6539\uff01"));
        this.checkBaseAndSetParam(purchaseTenderEvaClarificationHead);
        purchaseTenderEvaClarificationHead.setDataVersion(evaClarificationHead.getDataVersion());
        int count = ((PurchaseTenderEvaClarificationHeadMapper)this.baseMapper).updateById((Object)purchaseTenderEvaClarificationHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchaseTenderEvaClarificationSupplierService.deleteByMainId(purchaseTenderEvaClarificationHead.getId());
        this.insertData(purchaseTenderEvaClarificationHead, purchaseTenderEvaClarificationSupplierList);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseTenderEvaClarificationHead.getId());
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(purchaseTenderEvaClarificationHead.getId()));
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead, List<PurchaseAttachmentDTO> attachmentList) {
        PurchaseTenderEvaClarificationHead evaClarificationHead = (PurchaseTenderEvaClarificationHead)((Object)((PurchaseTenderEvaClarificationHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseTenderEvaClarificationHead.getId())));
        Assert.notNull((Object)((Object)evaClarificationHead), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        Assert.isTrue((boolean)PurchaseTenderEvaClarificationHeadStatusEnum.NEW.getValue().equals(evaClarificationHead.getStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d1\u5e03\uff01"));
        List<PurchaseTenderEvaClarificationSupplier> clarcificationSuppliers = this.purchaseTenderEvaClarificationSupplierService.selectByMainId(purchaseTenderEvaClarificationHead.getId());
        this.checkParam(evaClarificationHead, clarcificationSuppliers);
        evaClarificationHead.setStatus(PurchaseTenderEvaClarificationHeadStatusEnum.HAS_BEEN_SENT.getValue());
        int count = ((PurchaseTenderEvaClarificationHeadMapper)this.baseMapper).updateById((Object)evaClarificationHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.saleTenderEvaClarificationHeadService.add(purchaseTenderEvaClarificationHead, clarcificationSuppliers, attachmentList);
        PurchaseTenderProjectEvaInfo evaInfo = (PurchaseTenderProjectEvaInfo)((Object)this.evaInfoService.getById((Serializable)((Object)purchaseTenderEvaClarificationHead.getEvaInfoId())));
        if (StringUtils.isEmpty((CharSequence)TenderFlagInjectionContext.getTenderCheckType()) || StringUtils.isEmpty((CharSequence)TenderFlagInjectionContext.getTenderProcessType()) || StringUtils.isEmpty((CharSequence)TenderFlagInjectionContext.getTenderCurrentStep())) {
            TenderFlagInjectionContext.setTenderCheckType(evaInfo.getCheckType());
            TenderFlagInjectionContext.setTenderProcessType(evaInfo.getProcessType());
            TenderFlagInjectionContext.setTenderCurrentStep(evaInfo.getCurrentStep());
        }
        String operation = null;
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType())) {
            operation = "preTenderEvaPublishClarify";
        } else if (SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(TenderFlagInjectionContext.getTenderProcessType())) {
            operation = "tenderEvaPublishClarify";
        } else if (SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(TenderFlagInjectionContext.getTenderCurrentStep())) {
            operation = "firstTenderEvaPublishClarify";
        } else if (SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(TenderFlagInjectionContext.getTenderCurrentStep())) {
            operation = "secondTenderEvaPublishClarify";
        }
        if (StringUtils.isEmpty((CharSequence)operation)) {
            log.error("\u672a\u77e5\u64cd\u4f5c\u72b6\u6001\uff0c\u5934\u8868\u4fe1\u606f\uff1a{},CheckType:{},ProcessType:{},CurrentStep:{}", new Object[]{JSON.toJSONString((Object)((Object)evaClarificationHead)), TenderFlagInjectionContext.getTenderCheckType(), TenderFlagInjectionContext.getTenderProcessType(), TenderFlagInjectionContext.getTenderCurrentStep()});
            return;
        }
        this.sendMsg(evaClarificationHead, clarcificationSuppliers, operation);
    }

    private void sendMsg(PurchaseTenderEvaClarificationHead evaClarificationHead, List<PurchaseTenderEvaClarificationSupplier> clarcificationSuppliers, String operation) {
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(evaClarificationHead.getTenderProjectId()).append("&subpackageId=").append(evaClarificationHead.getSubpackageId()).append("&businessId=").append(evaClarificationHead.getId());
        if (!clarcificationSuppliers.isEmpty()) {
            List toElsAccountList = clarcificationSuppliers.stream().map(PurchaseTenderEvaClarificationSupplier::getSupplierAccount).collect(Collectors.toList());
            PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)evaClarificationHead.getSubpackageId())));
            Map params = FastJsonUtils.toMap((Object)subpackageInfo);
            params.put("title", evaClarificationHead.getClarificationTitle());
            this.sendMsg(TenantContext.getTenant(), toElsAccountList, params, urlParams.toString(), "tender", operation);
        }
    }

    private void checkParam(PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead, List<PurchaseTenderEvaClarificationSupplier> purchaseTenderEvaClarificationSuppliers) {
        Assert.hasText((String)purchaseTenderEvaClarificationHead.getClarificationTitle(), (String)I18nUtil.translate((String)"", (String)"\u6f84\u6e05\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.notNull((Object)purchaseTenderEvaClarificationHead.getFileClarificationEndTime(), (String)I18nUtil.translate((String)"", (String)"\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.hasText((String)purchaseTenderEvaClarificationHead.getContent(), (String)I18nUtil.translate((String)"", (String)"\u6f84\u6e05\u5185\u5bb9\u4e0d\u80fd\u672a\u7a7a\uff01"));
        Assert.notEmpty(purchaseTenderEvaClarificationSuppliers, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u9009\u62e9\u63a5\u6536\u4f9b\u5e94\u5546"));
        for (PurchaseTenderEvaClarificationSupplier purchaseTenderEvaClarificationSupplier : purchaseTenderEvaClarificationSuppliers) {
            Assert.hasText((String)purchaseTenderEvaClarificationSupplier.getSupplierAccount(), (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u4e3a\u7a7a\uff01"));
            Assert.hasText((String)purchaseTenderEvaClarificationSupplier.getSupplierName(), (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u4e3a\u7a7a\uff01"));
        }
    }

    private void checkBaseAndSetParam(PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead) {
        Assert.hasText((String)purchaseTenderEvaClarificationHead.getEvaInfoId(), (String)I18nUtil.translate((String)"", (String)"\u8bc4\u6807\u4fe1\u606fId\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        PurchaseTenderProjectEvaInfo evaInfo = (PurchaseTenderProjectEvaInfo)((Object)this.purchaseTenderProjectEvaInfoService.getById((Serializable)((Object)purchaseTenderEvaClarificationHead.getEvaInfoId())));
        Assert.notNull((Object)((Object)evaInfo), (String)I18nUtil.translate((String)"", (String)"\u8bc4\u6807\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        purchaseTenderEvaClarificationHead.setTenderProjectId(evaInfo.getTenderProjectId());
        purchaseTenderEvaClarificationHead.setSubpackageId(evaInfo.getSubpackageId());
        purchaseTenderEvaClarificationHead.setCheckType(evaInfo.getCheckType());
        purchaseTenderEvaClarificationHead.setStatus(PurchaseTenderEvaClarificationHeadStatusEnum.NEW.getValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseTenderEvaClarificationHead.setElsAccount(loginUser.getElsAccount());
        purchaseTenderEvaClarificationHead.setSubAccount(loginUser.getSubAccount());
        purchaseTenderEvaClarificationHead.setPurchaseEnterpriseAccount(loginUser.getElsAccount());
        purchaseTenderEvaClarificationHead.setPurchaseEnterpriseName(loginUser.getAliasName());
        purchaseTenderEvaClarificationHead.setRealName(loginUser.getRealname());
    }

    private void insertData(PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead, List<PurchaseTenderEvaClarificationSupplier> purchaseTenderEvaClarificationSupplierList) {
        if (!CollectionUtils.isEmpty(purchaseTenderEvaClarificationSupplierList)) {
            for (PurchaseTenderEvaClarificationSupplier entity : purchaseTenderEvaClarificationSupplierList) {
                entity.setHeadId(purchaseTenderEvaClarificationHead.getId());
                entity.setStatus(TenderMentoringStatusEnum.NEW.getValue());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseTenderEvaClarificationHead);
            }
            this.purchaseTenderEvaClarificationSupplierService.saveBatch(purchaseTenderEvaClarificationSupplierList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        PurchaseTenderEvaClarificationHead evaClarificationHead = (PurchaseTenderEvaClarificationHead)((Object)((PurchaseTenderEvaClarificationHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)evaClarificationHead), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        Assert.isTrue((boolean)PurchaseTenderEvaClarificationHeadStatusEnum.NEW.getValue().equals(evaClarificationHead.getStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664\uff01"));
        this.purchaseTenderEvaClarificationSupplierService.deleteByMainId(id);
        ((PurchaseTenderEvaClarificationHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void changeRecord(PurchaseTenderEvaClarificationRecord purchaseTenderEvaClarificationRecord) {
        Assert.hasText((String)purchaseTenderEvaClarificationRecord.getHeadId(), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        Assert.notNull((Object)purchaseTenderEvaClarificationRecord.getFileClarificationEndTime(), (String)I18nUtil.translate((String)"", (String)"\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.hasText((String)purchaseTenderEvaClarificationRecord.getRemark(), (String)I18nUtil.translate((String)"", (String)"\u53d8\u66f4\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        PurchaseTenderEvaClarificationHead evaClarificationHead = (PurchaseTenderEvaClarificationHead)((Object)((PurchaseTenderEvaClarificationHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseTenderEvaClarificationRecord.getHeadId())));
        Assert.notNull((Object)((Object)evaClarificationHead), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        Assert.isTrue((boolean)PurchaseTenderEvaClarificationHeadStatusEnum.HAS_BEEN_SENT.getValue().equals(evaClarificationHead.getStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u53d8\u66f4\uff01"));
        LoginUser loginUser = SysUtil.getLoginUser();
        Assert.isTrue((boolean)loginUser.getSubAccount().equals(evaClarificationHead.getSubAccount()), (String)I18nUtil.translate((String)"", (String)"\u65e0\u6743\u9650\u4fee\u6539\uff01"));
        purchaseTenderEvaClarificationRecord.setSubpackageId(evaClarificationHead.getSubpackageId());
        purchaseTenderEvaClarificationRecord.setTenderProjectId(evaClarificationHead.getTenderProjectId());
        this.purchaseTenderEvaClarificationRecordService.save((Object)purchaseTenderEvaClarificationRecord);
        evaClarificationHead.setFileClarificationEndTime(purchaseTenderEvaClarificationRecord.getFileClarificationEndTime());
        ((PurchaseTenderEvaClarificationHeadMapper)this.baseMapper).updateById((Object)evaClarificationHead);
        this.saleTenderEvaClarificationHeadService.changeRecord(evaClarificationHead);
        List<PurchaseTenderEvaClarificationSupplier> clarcificationSuppliers = this.purchaseTenderEvaClarificationSupplierService.selectByMainId(evaClarificationHead.getId());
        PurchaseTenderProjectEvaInfo evaInfo = (PurchaseTenderProjectEvaInfo)((Object)this.evaInfoService.getById((Serializable)((Object)evaClarificationHead.getEvaInfoId())));
        if (StringUtils.isEmpty((CharSequence)TenderFlagInjectionContext.getTenderCheckType()) || StringUtils.isEmpty((CharSequence)TenderFlagInjectionContext.getTenderProcessType()) || StringUtils.isEmpty((CharSequence)TenderFlagInjectionContext.getTenderCurrentStep())) {
            TenderFlagInjectionContext.setTenderCheckType(evaInfo.getCheckType());
            TenderFlagInjectionContext.setTenderProcessType(evaInfo.getProcessType());
            TenderFlagInjectionContext.setTenderCurrentStep(evaInfo.getCurrentStep());
        }
        String operation = null;
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType())) {
            operation = "preTenderEvaChangeClarify";
        } else if (SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(TenderFlagInjectionContext.getTenderProcessType())) {
            operation = "tenderEvaChangeClarify";
        } else if (SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(TenderFlagInjectionContext.getTenderCurrentStep())) {
            operation = "firstTenderEvaChangeClarify";
        } else if (SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(TenderFlagInjectionContext.getTenderCurrentStep())) {
            operation = "secondTenderEvaChangeClarify";
        }
        this.sendMsg(evaClarificationHead, clarcificationSuppliers, operation);
    }

    @Override
    public void reply(SaleTenderEvaClarificationHead saleTenderEvaClarificationHead, SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItemVO) {
        PurchaseTenderEvaClarificationSupplier evaClarificationSupplier = (PurchaseTenderEvaClarificationSupplier)((Object)this.purchaseTenderEvaClarificationSupplierService.getById((Serializable)((Object)saleTenderEvaClarificationHead.getRelationId())));
        Assert.notNull((Object)((Object)evaClarificationSupplier), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        evaClarificationSupplier.setStatus(TenderMentoringStatusEnum.REPLIED.getValue());
        this.purchaseTenderEvaClarificationSupplierService.updateById((Object)evaClarificationSupplier);
        PurchaseTenderEvaClarificationItem purchaseTenderEvaClarificationItem = (PurchaseTenderEvaClarificationItem)((Object)SysUtil.copyProperties((Object)((Object)saleTenderEvaClarificationItemVO), PurchaseTenderEvaClarificationItem.class));
        purchaseTenderEvaClarificationItem.setHeadId(saleTenderEvaClarificationHead.getEvaClarificationId());
        purchaseTenderEvaClarificationItem.setId(IdWorker.getIdStr());
        this.purchaseTenderEvaClarificationItemService.save((Object)purchaseTenderEvaClarificationItem);
        List<SaleAttachmentDTO> saleAttachmentList = saleTenderEvaClarificationItemVO.getAttachmentList();
        if (CollectionUtil.isNotEmpty(saleAttachmentList)) {
            ArrayList attachmentList = SysUtil.copyProperties(saleAttachmentList, PurchaseAttachmentDTO.class);
            attachmentList.forEach(attachment -> attachment.setHeadId(purchaseTenderEvaClarificationItem.getId()));
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn((List)attachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpdate(PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead, List<PurchaseTenderEvaClarificationSupplier> purchaseTenderEvaClarificationSupplierList, List<PurchaseAttachmentDTO> attachmentList) {
        if (StringUtils.isBlank((CharSequence)purchaseTenderEvaClarificationHead.getId())) {
            this.saveMain(purchaseTenderEvaClarificationHead, purchaseTenderEvaClarificationSupplierList, attachmentList);
        } else {
            this.updateMain(purchaseTenderEvaClarificationHead, purchaseTenderEvaClarificationSupplierList, attachmentList);
        }
        this.publish(purchaseTenderEvaClarificationHead, attachmentList);
    }
}

