/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.clarification.entity.PurchaseTenderClarificationInfo;
import com.els.modules.tender.clarification.entity.SaleTenderClarificationInfo;
import com.els.modules.tender.clarification.enumerate.SaleTenderClarificationStatusEnum;
import com.els.modules.tender.clarification.mapper.SaleTenderClarificationInfoMapper;
import com.els.modules.tender.clarification.service.PurchaseTenderClarificationInfoService;
import com.els.modules.tender.clarification.service.SaleTenderClarificationInfoService;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.utils.TenderProjectMemberUtils;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class SaleTenderClarificationInfoServiceImpl
extends BaseServiceImpl<SaleTenderClarificationInfoMapper, SaleTenderClarificationInfo>
implements SaleTenderClarificationInfoService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    private PurchaseTenderClarificationInfoService purchaseTenderClarificationInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectHeadService projectHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void batchAdd(PurchaseTenderClarificationInfo purchaseTenderClarificationInfo, List<PurchaseAttachmentDTO> purchaseAttachmentDTOS) {
        SaleTenderClarificationInfo saleTenderClarificationInfo = (SaleTenderClarificationInfo)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderClarificationInfo), SaleTenderClarificationInfo.class));
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(TenderProjectSupplier::getSubpackageId, (Object)saleTenderClarificationInfo.getSubpackageId())).eq(TenderProjectSupplier::getEffective, (Object)"1");
        List tenderProjectSuppliers = this.tenderProjectSupplierService.list((Wrapper)qw);
        if (CollectionUtil.isEmpty((Collection)tenderProjectSuppliers)) {
            return;
        }
        ArrayList saleTenderClarificationInfos = new ArrayList();
        ArrayList saleAttachmentDTOS = new ArrayList();
        tenderProjectSuppliers.forEach(supplier -> {
            SaleTenderClarificationInfo tenderClarificationInfo = new SaleTenderClarificationInfo();
            this.bulidSaleTenderClarificationInfoParam(tenderClarificationInfo, saleTenderClarificationInfo, (TenderProjectSupplier)((Object)supplier));
            saleTenderClarificationInfos.add(tenderClarificationInfo);
            this.bulidSaleAttachmentDTOParam(saleAttachmentDTOS, purchaseAttachmentDTOS, tenderClarificationInfo);
        });
        ((SaleTenderClarificationInfoMapper)this.baseMapper).insertBatchSomeColumn(saleTenderClarificationInfos);
        if (CollectionUtil.isEmpty(saleAttachmentDTOS)) {
            return;
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOS);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SaleTenderClarificationInfo confirm(String id) {
        SaleTenderClarificationInfo saleTenderClarificationInfo = (SaleTenderClarificationInfo)((Object)((SaleTenderClarificationInfoMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)saleTenderClarificationInfo)), (String)I18nUtil.translate((String)"i18n_alert_uhtkWVXVsKW_7413de8f", (String)"\u975e\u6cd5\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)saleTenderClarificationInfo.getRelationId()), (String)I18nUtil.translate((String)"i18n_alert_WFIHWVKHRvjW_e5feb3d4", (String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!"));
        Assert.isTrue((boolean)SaleTenderClarificationStatusEnum.NOT_CONFIRM.getValue().equals(saleTenderClarificationInfo.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_xqVBRLW_40b96ac9", (String)"\u4e0d\u53ef\u91cd\u590d\u786e\u8ba4!"));
        this.purchaseTenderClarificationInfoService.addConfirmNumber(saleTenderClarificationInfo.getRelationId());
        saleTenderClarificationInfo.setStatus(SaleTenderClarificationStatusEnum.CONFIRM.getValue());
        ((SaleTenderClarificationInfoMapper)this.baseMapper).updateById((Object)saleTenderClarificationInfo);
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(saleTenderClarificationInfo.getSubpackageId());
        String operation = "preConfirmClarification";
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(saleTenderClarificationInfo.getCheckType())) {
            operation = "confirmClarification";
        }
        List<ElsSubAccountDTO> accountDTOList = TenderProjectMemberUtils.getTenderProjectMember(saleTenderClarificationInfo.getTenderProjectId());
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(saleTenderClarificationInfo.getTenderProjectId()).append("&subpackageId=").append(saleTenderClarificationInfo.getSubpackageId());
        LoginUser loginUser = SysUtil.getLoginUser();
        Map params = FastJsonUtils.toMap((Object)saleTenderClarificationInfo);
        params.put("subpackageName", subpackageInfo.getSubpackageName());
        params.put("tenderProjectName", subpackageInfo.getTenderProjectName());
        params.put("supplierName", loginUser.getCompanySet().get((Object)"companyName"));
        super.sendMsgToSubAccount(TenantContext.getTenant(), accountDTOList, (Object)params, urlParams.toString(), "tender", operation);
        return saleTenderClarificationInfo;
    }

    private void bulidSaleTenderClarificationInfoParam(SaleTenderClarificationInfo saleTenderClarificationInfo, SaleTenderClarificationInfo dataSource, TenderProjectSupplier tenderProjectSupplier) {
        saleTenderClarificationInfo.setId(IdWorker.getIdStr());
        saleTenderClarificationInfo.setElsAccount(tenderProjectSupplier.getSupplierAccount());
        saleTenderClarificationInfo.setSubpackageId(dataSource.getSubpackageId());
        saleTenderClarificationInfo.setTenderProjectId(dataSource.getTenderProjectId());
        saleTenderClarificationInfo.setRelationId(dataSource.getId());
        saleTenderClarificationInfo.setClarificationNumber(dataSource.getClarificationNumber());
        saleTenderClarificationInfo.setTitle(dataSource.getTitle());
        saleTenderClarificationInfo.setPublishTime(dataSource.getPublishTime());
        saleTenderClarificationInfo.setConfirmNumber(0);
        saleTenderClarificationInfo.setTotal(0);
        saleTenderClarificationInfo.setCheckType(dataSource.getCheckType());
        saleTenderClarificationInfo.setStatus(SaleTenderClarificationStatusEnum.NOT_CONFIRM.getValue());
        saleTenderClarificationInfo.setFileClarificationEndTime(dataSource.getFileClarificationEndTime());
        saleTenderClarificationInfo.setOpenBiddingTime(dataSource.getOpenBiddingTime());
        saleTenderClarificationInfo.setFileSubmitEndTime(dataSource.getFileSubmitEndTime());
        saleTenderClarificationInfo.setContent(dataSource.getContent());
        saleTenderClarificationInfo.setDeleted(CommonConstant.DEL_FLAG_0);
        Date nowData = new Date();
        saleTenderClarificationInfo.setUpdateBy(dataSource.getUpdateBy());
        saleTenderClarificationInfo.setUpdateTime(nowData);
        saleTenderClarificationInfo.setCreateBy(dataSource.getCreateBy());
        saleTenderClarificationInfo.setCreateTime(nowData);
    }

    private void bulidSaleAttachmentDTOParam(List<SaleAttachmentDTO> SaleAttachmentDTOS, List<PurchaseAttachmentDTO> purchaseAttachmentDTOS, SaleTenderClarificationInfo saleTenderClarificationInfo) {
        if (CollectionUtil.isEmpty(purchaseAttachmentDTOS)) {
            return;
        }
        ArrayList saleAttachmentDTOS = SysUtil.copyProperties(purchaseAttachmentDTOS, SaleAttachmentDTO.class);
        saleAttachmentDTOS.forEach(saleAttachmentDTO -> {
            saleAttachmentDTO.setId(IdWorker.getIdStr());
            saleAttachmentDTO.setHeadId(saleTenderClarificationInfo.getId());
        });
        SaleAttachmentDTOS.addAll(saleAttachmentDTOS);
    }
}

