/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.SpringContextUtils;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.process.entity.TenderProcessNode;
import com.els.modules.tender.process.service.TenderProcessNodeService;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class TenderFlagInjectionInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TenderFlagInjectionInterceptor.class);
    private static final String X_NODE_ID = "xNodeId";
    private static final String CHECK_TYPE = "checkType";
    private static final String PROCESS_TYPE = "processType";
    private static final String CURRENT_STEP = "currentStep";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String nodeId = request.getHeader(X_NODE_ID);
        log.info("\u62db\u6807\u9879\u76ee\uff1a\u81ea\u52a8\u6ce8\u5165\u9884\u5ba1\u548c\u4e00\u6b65\u6cd5\u3001\u4e24\u6b65\u6cd5\u62e6\u622a\u5668\u8fdb\u5165\uff01\u53c2\u6570nodeId:{}", (Object)nodeId);
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            try {
                String checkType = null;
                String processType = null;
                String currentStep = null;
                if (nodeId.indexOf("_") == -1) {
                    TenderProcessNodeService nodeService = (TenderProcessNodeService)SpringContextUtils.getBean(TenderProcessNodeService.class);
                    TenderProcessNode processNode = (TenderProcessNode)((Object)nodeService.getById((Serializable)((Object)nodeId)));
                    if (processNode != null && StringUtils.isNotBlank((CharSequence)processNode.getExtend())) {
                        JSONObject jsonObject = JSON.parseObject((String)processNode.getExtend());
                        log.info("\u83b7\u53d6\u8282\u70b9\u6269\u5c55\u53c2\u6570:{}", (Object)processNode.getExtend());
                        checkType = jsonObject.getString(CHECK_TYPE);
                        processType = jsonObject.getString(PROCESS_TYPE);
                        if (jsonObject.containsKey((Object)CURRENT_STEP) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(processType)) {
                            currentStep = jsonObject.getString(CURRENT_STEP);
                        }
                    }
                } else {
                    String[] splits = nodeId.split("_");
                    checkType = splits[0];
                    if (splits.length > 1) {
                        processType = splits[1];
                    }
                    if (splits.length > 2 && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(splits[1])) {
                        currentStep = splits[2];
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)checkType) && !"null".equals(checkType)) {
                    TenderFlagInjectionContext.setTenderCheckType(checkType);
                }
                if (StringUtils.isNotBlank((CharSequence)processType) && !"null".equals(processType)) {
                    TenderFlagInjectionContext.setTenderProcessType(processType);
                }
                if (StringUtils.isNotBlank(currentStep) && !"null".equals(currentStep)) {
                    TenderFlagInjectionContext.setTenderCurrentStep(currentStep);
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u8282\u70b9\u6269\u5c55\u53c2\u6570\u5f02\u5e38{}", (Object)e.getMessage());
            }
        } else {
            String currentStep;
            String processType;
            String checkType = request.getParameter(CHECK_TYPE);
            if (StringUtils.isNotBlank((CharSequence)checkType)) {
                TenderFlagInjectionContext.setTenderCheckType(checkType);
            }
            if (StringUtils.isNotBlank((CharSequence)(processType = request.getParameter(PROCESS_TYPE)))) {
                TenderFlagInjectionContext.setTenderProcessType(processType);
            }
            if (StringUtils.isNotBlank((CharSequence)(currentStep = request.getParameter(CURRENT_STEP)))) {
                TenderFlagInjectionContext.setTenderCurrentStep(currentStep);
            }
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        log.info("\u62db\u6807\u9879\u76ee\uff1a\u81ea\u52a8\u6ce8\u5165\u9884\u5ba1\u548c\u4e00\u6b65\u6cd5\u3001\u4e24\u6b65\u6cd5\u62e6\u622a\u5668\u9000\u51fa\uff01");
        TenderFlagInjectionContext.clear();
    }
}

