/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.strategy.price.handler;

import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPriceRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.attachment.enumerate.PriceRegulationInfoRankingRulesEnum;
import com.els.modules.tender.attachment.vo.PurchaseTenderEvaluationGroupVO;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.strategy.price.TemplatePriceStrategy;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectBidEvaRegulationResultVO;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component(value="operationPriceComparisonStrategy")
public class OperationPriceComparisonStrategy
implements TemplatePriceStrategy {
    @Override
    public void priceScoreCalculate(List<PurchaseTenderProjectBidEvaRegulationResultVO> regulationCalList, PurchaseTenderEvaluationGroupVO evaluationGroupVO, PurchaseTenderEvaluationPrinciples evaluationPrinciples) {
        PurchaseTenderEvaluationPriceRegulationInfo regulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
        String rankingRules = regulationInfo.getRankingRules();
        regulationCalList.stream().forEach(regulationResult -> {
            BigDecimal quote = regulationResult.getEvaPrice();
            if (quote == null) {
                regulationResult.setEvaPrice(BigDecimal.ZERO);
            }
        });
        regulationCalList = PriceRegulationInfoRankingRulesEnum.QUOTES_SORT_FROM_LOW_TO_HIGH.getValue().equals(rankingRules) ? regulationCalList.stream().sorted(Comparator.comparing(PurchaseTenderProjectBidEvaRegulationResult::getEvaPrice)).collect(Collectors.toList()) : regulationCalList.stream().sorted(Comparator.comparing(PurchaseTenderProjectBidEvaRegulationResult::getEvaPrice).reversed()).collect(Collectors.toList());
        LinkedHashMap<Double, Integer> orderByMap = new LinkedHashMap<Double, Integer>();
        Integer orderBy = 1;
        for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : regulationCalList) {
            Integer index = (Integer)orderByMap.get(regulationResultVO.getEvaPrice().doubleValue());
            if (index == null) {
                index = orderBy;
            }
            regulationResultVO.setScore(regulationResultVO.getEvaPrice());
            regulationResultVO.setOrderBy(index);
            orderByMap.put(regulationResultVO.getEvaPrice().doubleValue(), orderBy);
            orderBy = index = Integer.valueOf(index + 1);
        }
    }
}

