/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.openbid.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.openbid.entity.PurchaseTenderProjectOpenInfoRecords;
import com.els.modules.tender.openbid.entity.PurchaseTenderProjectOpenSettingAttendees;
import com.els.modules.tender.openbid.mapper.PurchaseTenderProjectOpenInfoRecordsMapper;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenInfoRecordsService;
import com.els.modules.tender.openbid.service.impl.PurchaseTenderProjectOpenSettingHeadServiceImpl;
import com.els.modules.tender.openbid.vo.PurchaseOpenSettingHeadVO;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class PurchaseTenderProjectOpenInfoRecordsServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectOpenInfoRecordsMapper, PurchaseTenderProjectOpenInfoRecords>
implements PurchaseTenderProjectOpenInfoRecordsService {
    @Override
    public void deleteByMainId(String subpackageId) {
        ((PurchaseTenderProjectOpenInfoRecordsMapper)this.baseMapper).deleteBySubpackageId(subpackageId, TenderFlagInjectionContext.getTenderCheckType(), TenderFlagInjectionContext.getTenderProcessType(), TenderFlagInjectionContext.getTenderCurrentStep());
    }

    @Override
    public List<PurchaseTenderProjectOpenInfoRecords> queryOpenInfoRecordsBySubpackageId(String subpackageId) {
        PurchaseTenderProjectHeadService projectHeadService = (PurchaseTenderProjectHeadService)SpringContextUtils.getBean(PurchaseTenderProjectHeadService.class);
        PurchaseTenderProjectHeadVO tenderProjectHeadVO = projectHeadService.queryProjectHeadBySubpackageId(subpackageId);
        PurchaseTenderProjectOpenSettingHeadServiceImpl openSettingHeadService = (PurchaseTenderProjectOpenSettingHeadServiceImpl)SpringContextUtils.getBean(PurchaseTenderProjectOpenSettingHeadServiceImpl.class);
        PurchaseOpenSettingHeadVO purchaseOpenSettingHeadVO = openSettingHeadService.queryBySubpackageId(subpackageId);
        String elsAccount = TenantContext.getTenant();
        String agencyElsAccount = tenderProjectHeadVO.getAgencyElsAccount();
        String purchaseExecutorAccount = tenderProjectHeadVO.getPurchaseExecutorAccount();
        List<PurchaseTenderProjectOpenSettingAttendees> attendeesList = purchaseOpenSettingHeadVO.getAttendeesList();
        List attendeesElsAccounts = null;
        if (CollectionUtil.isNotEmpty(attendeesList)) {
            attendeesElsAccounts = attendeesList.stream().map(x -> x.getAttendeesElsAccount()).collect(Collectors.toList());
        }
        if (elsAccount.equals(purchaseExecutorAccount) || elsAccount.equals(agencyElsAccount) || CollectionUtil.isNotEmpty(attendeesElsAccounts) && attendeesElsAccounts.contains(elsAccount)) {
            elsAccount = "";
        }
        return ((PurchaseTenderProjectOpenInfoRecordsMapper)this.baseMapper).selectBySubpackageId(subpackageId, TenderFlagInjectionContext.getTenderCheckType(), TenderFlagInjectionContext.getTenderProcessType(), TenderFlagInjectionContext.getTenderCurrentStep(), purchaseExecutorAccount, elsAccount);
    }

    @Override
    public List<PurchaseTenderProjectOpenInfoRecords> queryOpenInfoRecordsSignMessageBySubpackageId(String subpackageId, String elsAccount) {
        TenantContext.setTenant((String)elsAccount);
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(PurchaseTenderProjectOpenInfoRecords::getSubpackageId, (Object)subpackageId);
        lambdaQueryWrapper.eq(PurchaseTenderProjectOpenInfoRecords::getCheckType, (Object)TenderFlagInjectionContext.getTenderCheckType());
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType)) {
            lambdaQueryWrapper.eq(PurchaseTenderProjectOpenInfoRecords::getProcessType, (Object)TenderFlagInjectionContext.getTenderProcessType());
            lambdaQueryWrapper.eq(PurchaseTenderProjectOpenInfoRecords::getCurrentStep, (Object)TenderFlagInjectionContext.getTenderCurrentStep());
        }
        return this.list((Wrapper)lambdaQueryWrapper);
    }
}

