/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.project.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.clarification.entity.PurchaseTenderClarificationInfo;
import com.els.modules.tender.column.utils.DictColumnTranslateUtils;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeItem;
import com.els.modules.tender.notice.enumerate.PurchaseTenderNoticeStatusEnum;
import com.els.modules.tender.notice.enumerate.PurchaseTenderNoticeTypeEnum;
import com.els.modules.tender.notice.vo.PurchaseTenderNoticeHeadVO;
import com.els.modules.tender.openbid.entity.PurchaseTenderProjectOpenInfoRecords;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.openbid.job.TenderJobUtil;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenInfoRecordsService;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenSettingHeadService;
import com.els.modules.tender.openbid.vo.PurchaseOpenSettingHeadVO;
import com.els.modules.tender.openbid.websocket.TenderOnlineWebSocket;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.mapper.PurchaseTenderProjectSubpackageInfoMapper;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectOpenInfoHeadVO;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.enumerate.TenderProjectSupplieResponseStatusEnum;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class PurchaseTenderProjectSubpackageInfoServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectSubpackageInfoMapper, PurchaseTenderProjectSubpackageInfo>
implements PurchaseTenderProjectSubpackageInfoService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectSubpackageInfoServiceImpl.class);
    @Autowired
    @Lazy
    private TenderProjectSupplierService projectSupplierService;

    @Override
    public List<PurchaseTenderProjectSubpackageInfo> selectByMainId(String id) {
        return ((PurchaseTenderProjectSubpackageInfoMapper)this.baseMapper).selectByMainId(id);
    }

    @Override
    public List<PurchaseTenderProjectSubpackageInfo> selectBatchIds(List<String> ids) {
        return ((PurchaseTenderProjectSubpackageInfoMapper)this.baseMapper).selectBatchIds(ids);
    }

    @Override
    public PurchaseTenderProjectSubpackageInfo selectById(String id) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)((PurchaseTenderProjectSubpackageInfoMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        String statusDesc = TenderProjectSubpackageStatusEnum.getSubpackageStatusDesc(subpackageInfo.getStatus());
        subpackageInfo.setStatusDesc(statusDesc);
        return subpackageInfo;
    }

    @Override
    public void delMain(String headId) {
        ((PurchaseTenderProjectSubpackageInfoMapper)this.baseMapper).deleteByMainId(headId);
    }

    @Override
    public void updateByEvent(TenderWriteBackSubpackageInfoEventDTO writeBackSubpackageInfo) {
        log.info("\u66f4\u65b0\u5206\u5305\u72b6\u6001{}", JSON.toJSON((Object)writeBackSubpackageInfo));
        Object event = writeBackSubpackageInfo.getEvent();
        if (event instanceof PurchaseTenderClarificationInfo) {
            PurchaseTenderClarificationInfo tenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)event);
            log.info("\u6f84\u6e05\u7b54\u7591\u56de\u5199\u5355\u636e\u4fe1\u606f\uff0c\u5f00\u6807\u65f6\u95f4{0}\uff0c\u6f84\u6e05\u622a\u6b62\u65f6\u95f4{1},\u9012\u4ea4\u622a\u6b62\u65f6\u95f4{2}", new Object[]{tenderClarificationInfo.getOpenBiddingTime(), tenderClarificationInfo.getFileClarificationEndTime(), tenderClarificationInfo.getFileSubmitEndTime()});
            PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.getById((Serializable)((Object)tenderClarificationInfo.getSubpackageId())));
            if (SubpackageInfoCheckTypeEnum.hasPreTrial(tenderClarificationInfo.getCheckType())) {
                purchaseTenderProjectSubpackageInfo.setPreOpenBiddingTime(tenderClarificationInfo.getOpenBiddingTime());
                purchaseTenderProjectSubpackageInfo.setPreFileClarificationEndTime(tenderClarificationInfo.getFileClarificationEndTime());
                purchaseTenderProjectSubpackageInfo.setPreFileSubmitEndTime(tenderClarificationInfo.getFileSubmitEndTime());
            } else {
                if (SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(purchaseTenderProjectSubpackageInfo.getProcessType())) {
                    purchaseTenderProjectSubpackageInfo.setOpenBiddingTime(tenderClarificationInfo.getOpenBiddingTime());
                } else {
                    purchaseTenderProjectSubpackageInfo.setResultOpenBiddingTime(tenderClarificationInfo.getOpenBiddingTime());
                }
                purchaseTenderProjectSubpackageInfo.setFileClarificationEndTime(tenderClarificationInfo.getFileClarificationEndTime());
                purchaseTenderProjectSubpackageInfo.setFileSubmitEndTime(tenderClarificationInfo.getFileSubmitEndTime());
            }
            this.updateById((Object)purchaseTenderProjectSubpackageInfo);
        } else if (event instanceof PurchaseTenderNoticeHeadVO) {
            PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadVO = (PurchaseTenderNoticeHeadVO)((Object)event);
            List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList = purchaseTenderNoticeHeadVO.getPurchaseTenderNoticeItemList();
            if (purchaseTenderNoticeItemList.isEmpty()) {
                return;
            }
            List<String> subpackageIds = purchaseTenderNoticeItemList.stream().map(PurchaseTenderNoticeItem::getSubpackageId).distinct().collect(Collectors.toList());
            log.info("\u53d1\u5e03\u62db\u6807\u516c\u544a\uff0c\u66f4\u65b0{}\u9879\u76ee\u72b6\u6001", JSON.toJSON(subpackageIds));
            List<PurchaseTenderProjectSubpackageInfo> purchaseTenderProjectSubpackageInfos = this.selectBatchIds(subpackageIds);
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty(purchaseTenderProjectSubpackageInfos), (String)I18nUtil.translate((String)"", (String)"\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u4e0d\u5b58\u5728!"));
            if (PurchaseTenderNoticeStatusEnum.PUBLISHED.getValue().equals(purchaseTenderNoticeHeadVO.getNoticeStatus())) {
                this.buildPurchaseTenderProjectSubpackageInfoParam(purchaseTenderNoticeHeadVO, purchaseTenderProjectSubpackageInfos, writeBackSubpackageInfo.getSubpackageStatus());
            } else {
                if (PurchaseTenderNoticeTypeEnum.hasChange(purchaseTenderNoticeHeadVO.getNoticeType())) {
                    return;
                }
                purchaseTenderProjectSubpackageInfos.forEach(subpackageInfo -> {
                    subpackageInfo.setStatus(Integer.valueOf(writeBackSubpackageInfo.getSubpackageStatus()));
                    subpackageInfo.setConsortiumBidding(purchaseTenderNoticeHeadVO.getConsortiumBidding());
                });
            }
            this.updateBatchById(purchaseTenderProjectSubpackageInfos);
        } else {
            PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.getById((Serializable)((Object)writeBackSubpackageInfo.getSubpackageId())));
            purchaseTenderProjectSubpackageInfo.setStatus(Integer.valueOf(writeBackSubpackageInfo.getSubpackageStatus()));
            this.updateById((Object)purchaseTenderProjectSubpackageInfo);
        }
    }

    private void buildPurchaseTenderProjectSubpackageInfoParam(PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadVO, List<PurchaseTenderProjectSubpackageInfo> purchaseTenderProjectSubpackageInfos, String subPackageStatus) {
        List<PurchaseTenderNoticeItem> purchaseTenderNoticeItems = purchaseTenderNoticeHeadVO.getPurchaseTenderNoticeItemList();
        Map<String, PurchaseTenderNoticeItem> noticeItemMap = purchaseTenderNoticeItems.stream().collect(Collectors.toMap(PurchaseTenderNoticeItem::getSubpackageId, noticeItem -> noticeItem, (o1, o2) -> o1));
        purchaseTenderProjectSubpackageInfos.forEach(projectItem -> {
            if (PurchaseTenderNoticeTypeEnum.CHANGE_NOTICE.getValue().equals(purchaseTenderNoticeHeadVO.getNoticeType()) || PurchaseTenderNoticeTypeEnum.CHANGE_INVITATION_BID.getValue().equals(purchaseTenderNoticeHeadVO.getNoticeType())) {
                projectItem.setSignUpBeginTime(purchaseTenderNoticeHeadVO.getSignUpBeginTime());
                projectItem.setSignUpEndTime(purchaseTenderNoticeHeadVO.getSignUpEndTime());
                projectItem.setBiddingBeginTime(purchaseTenderNoticeHeadVO.getBiddingBeginTime());
                projectItem.setBiddingEndTime(purchaseTenderNoticeHeadVO.getBiddingEndTime());
                projectItem.setFileClarificationEndTime(purchaseTenderNoticeHeadVO.getFileClarificationEndTime());
                projectItem.setFileSubmitEndTime(purchaseTenderNoticeHeadVO.getFileSubmitEndTime());
                if (SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(projectItem.getProcessType())) {
                    projectItem.setResultOpenBiddingTime(purchaseTenderNoticeHeadVO.getOpenBiddingTime());
                } else {
                    projectItem.setOpenBiddingTime(purchaseTenderNoticeHeadVO.getOpenBiddingTime());
                }
            } else if (PurchaseTenderNoticeTypeEnum.PRE_CHANGE_NOTICE.getValue().equals(purchaseTenderNoticeHeadVO.getNoticeType())) {
                projectItem.setPreBiddingBeginTime(purchaseTenderNoticeHeadVO.getBiddingBeginTime());
                projectItem.setPreBiddingEndTime(purchaseTenderNoticeHeadVO.getBiddingEndTime());
                projectItem.setPreFileClarificationEndTime(purchaseTenderNoticeHeadVO.getFileClarificationEndTime());
                projectItem.setPreFileSubmitEndTime(purchaseTenderNoticeHeadVO.getFileSubmitEndTime());
                projectItem.setPreOpenBiddingTime(purchaseTenderNoticeHeadVO.getOpenBiddingTime());
                projectItem.setSignUpBeginTime(purchaseTenderNoticeHeadVO.getSignUpBeginTime());
                projectItem.setSignUpEndTime(purchaseTenderNoticeHeadVO.getSignUpEndTime());
            } else {
                projectItem.setStatus(Integer.valueOf(subPackageStatus));
                projectItem.setConsortiumBidding(purchaseTenderNoticeHeadVO.getConsortiumBidding());
                projectItem.setSignUpBeginTime(purchaseTenderNoticeHeadVO.getSignUpBeginTime());
                projectItem.setSignUpEndTime(purchaseTenderNoticeHeadVO.getSignUpEndTime());
                PurchaseTenderNoticeItem purchaseTenderNoticeItem = (PurchaseTenderNoticeItem)((Object)((Object)noticeItemMap.get(projectItem.getId())));
                boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(projectItem.getCheckType());
                if (!hasPreTrial || !PurchaseTenderNoticeTypeEnum.hasInvitationBid(purchaseTenderNoticeHeadVO.getNoticeType())) {
                    projectItem.setMarginCollectionType(purchaseTenderNoticeItem.getMarginCollectionType());
                    projectItem.setMargin(purchaseTenderNoticeItem.getMargin());
                    projectItem.setVirtualAccount(purchaseTenderNoticeItem.getVirtualAccount());
                }
                projectItem.setSignUpType(purchaseTenderNoticeHeadVO.getSignUpType());
                if (PurchaseTenderNoticeTypeEnum.PRE_NOTICE.getValue().equals(purchaseTenderNoticeHeadVO.getNoticeType())) {
                    projectItem.setPreBiddingType(purchaseTenderNoticeHeadVO.getBiddingType());
                    projectItem.setPreBiddingBeginTime(purchaseTenderNoticeHeadVO.getBiddingBeginTime());
                    projectItem.setPreBiddingEndTime(purchaseTenderNoticeHeadVO.getBiddingEndTime());
                    projectItem.setPreFileClarificationEndTime(purchaseTenderNoticeHeadVO.getFileClarificationEndTime());
                    projectItem.setPreBidding(purchaseTenderNoticeHeadVO.getBidding());
                    projectItem.setPreFileSubmitEndTime(purchaseTenderNoticeHeadVO.getFileSubmitEndTime());
                    projectItem.setPreOpenBiddingTime(purchaseTenderNoticeHeadVO.getOpenBiddingTime());
                } else {
                    projectItem.setBiddingType(purchaseTenderNoticeHeadVO.getBiddingType());
                    projectItem.setBiddingBeginTime(purchaseTenderNoticeHeadVO.getBiddingBeginTime());
                    projectItem.setBiddingEndTime(purchaseTenderNoticeHeadVO.getBiddingEndTime());
                    projectItem.setFileClarificationEndTime(purchaseTenderNoticeHeadVO.getFileClarificationEndTime());
                    projectItem.setFileSubmitEndTime(purchaseTenderNoticeHeadVO.getFileSubmitEndTime());
                    if (SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(projectItem.getProcessType())) {
                        projectItem.setResultOpenBiddingTime(purchaseTenderNoticeHeadVO.getOpenBiddingTime());
                    } else {
                        projectItem.setOpenBiddingTime(purchaseTenderNoticeHeadVO.getOpenBiddingTime());
                    }
                }
            }
        });
    }

    @Override
    public PurchaseTenderProjectOpenInfoHeadVO queryOpenInfoById(String id) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)((PurchaseTenderProjectSubpackageInfoMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        PurchaseTenderProjectOpenInfoHeadVO purchaseTenderProjectOpenInfoHeadVO = (PurchaseTenderProjectOpenInfoHeadVO)((Object)SysUtil.copyProperties((Object)((Object)subpackageInfo), PurchaseTenderProjectOpenInfoHeadVO.class));
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        Assert.hasText((String)tenderCheckType, (String)I18nUtil.translate((String)"", (String)"\u5ba1\u67e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(id);
        List<TenderProjectSupplier> tenderProjectSuppliers = this.projectSupplierService.selectBySubpackageId(querySupplier);
        long submitFileTotal = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "responseStatus"))).count();
        long signInTotal = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "signIn"))).count();
        long decryptTotal = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "decrypt"))).count();
        long signatureTotal = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "signature"))).count();
        purchaseTenderProjectOpenInfoHeadVO.setFileSubmitNumber(submitFileTotal);
        purchaseTenderProjectOpenInfoHeadVO.setSignInNumber(signInTotal);
        purchaseTenderProjectOpenInfoHeadVO.setDecryptNumber(decryptTotal);
        purchaseTenderProjectOpenInfoHeadVO.setSignatureNumber(signatureTotal);
        PurchaseTenderProjectOpenInfoRecordsService openInfoRecordsService = (PurchaseTenderProjectOpenInfoRecordsService)SpringContextUtils.getBean(PurchaseTenderProjectOpenInfoRecordsService.class);
        List<PurchaseTenderProjectOpenInfoRecords> openInfoRecords = openInfoRecordsService.queryOpenInfoRecordsBySubpackageId(purchaseTenderProjectOpenInfoHeadVO.getId());
        purchaseTenderProjectOpenInfoHeadVO.setOpenInfoRecords(openInfoRecords);
        return purchaseTenderProjectOpenInfoHeadVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseTenderProjectOpenInfoHeadVO updateOpenBidStatus(PurchaseTenderProjectSubpackageInfo subpackageInfo) {
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)subpackageInfo);
        if (!"1".equals(subpackageInfo.getOpenBidEncrypt()) && PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openBidStatus)) {
            TenderOperationFieldUtils.setEndBidSubpackageStatus((Object)subpackageInfo);
            TenderOperationFieldUtils.setOpenBidStatus((Object)subpackageInfo, PurchaseOpenBidStatusEnum.END_BID.getValue());
            this.updateById((Object)subpackageInfo);
            this.supplierAutoSignAndDecrypting(subpackageInfo);
            PurchaseTenderProjectOpenInfoHeadVO purchaseTenderProjectOpenInfoHeadVO = (PurchaseTenderProjectOpenInfoHeadVO)((Object)SysUtil.copyProperties((Object)((Object)subpackageInfo), PurchaseTenderProjectOpenInfoHeadVO.class));
            return purchaseTenderProjectOpenInfoHeadVO;
        }
        Date decryptionTime = null;
        if (PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openBidStatus)) {
            TenderOperationFieldUtils.setAnnounceOpenBidTime((Object)subpackageInfo, DateUtils.getDate());
            PurchaseTenderProjectOpenSettingHeadService projectOpenSettingHeadService = (PurchaseTenderProjectOpenSettingHeadService)SpringContextUtils.getBean(PurchaseTenderProjectOpenSettingHeadService.class);
            PurchaseOpenSettingHeadVO purchaseOpenSettingHeadVO = projectOpenSettingHeadService.queryBySubpackageId(subpackageInfo.getId());
            Date announceOpenBidTime = TenderOperationFieldUtils.getFieldDateValue((Object)subpackageInfo, "announceOpenBidTime");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(announceOpenBidTime);
            calendar.add(12, purchaseOpenSettingHeadVO.getDecryptionTime() == null ? 0 : purchaseOpenSettingHeadVO.getDecryptionTime());
            decryptionTime = calendar.getTime();
            TenderJobUtil.createOrUpdateOpenBidDecryptAlertJob(subpackageInfo, decryptionTime);
        }
        this.updateById((Object)subpackageInfo);
        TenderOnlineWebSocket webSocket = (TenderOnlineWebSocket)SpringContextUtils.getBean(TenderOnlineWebSocket.class);
        JSONObject messageJson = new JSONObject();
        messageJson.put("type", (Object)"updateOpenBidStatus");
        messageJson.put("result", (Object)subpackageInfo);
        webSocket.sendQuoteMessage(subpackageInfo.getId(), messageJson.toString());
        PurchaseTenderProjectOpenInfoHeadVO purchaseTenderProjectOpenInfoHeadVO = (PurchaseTenderProjectOpenInfoHeadVO)((Object)SysUtil.copyProperties((Object)((Object)subpackageInfo), PurchaseTenderProjectOpenInfoHeadVO.class));
        this.sendMsg(subpackageInfo, openBidStatus, decryptionTime);
        return purchaseTenderProjectOpenInfoHeadVO;
    }

    private void sendMsg(PurchaseTenderProjectSubpackageInfo subpackageInfo, String openBidStatus, Date decryptionTime) {
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(subpackageInfo.getHeadId()).append("&subpackageId=").append(subpackageInfo.getId());
        TenderProjectSupplier supplier = new TenderProjectSupplier();
        supplier.setSubpackageId(subpackageInfo.getId());
        supplier.setInvalid("0");
        List<TenderProjectSupplier> tenderProjectSuppliers = this.projectSupplierService.selectBySubpackageId(supplier);
        if (!tenderProjectSuppliers.isEmpty()) {
            List<Object> toElsAccountList = new ArrayList();
            String operation = null;
            if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType())) {
                toElsAccountList = tenderProjectSuppliers.stream().map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
                if (PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openBidStatus)) {
                    operation = "preTenderOpenBid";
                } else if (PurchaseOpenBidStatusEnum.END_BID.getValue().equals(openBidStatus)) {
                    operation = "preTenderEndBid";
                }
            } else if (SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(TenderFlagInjectionContext.getTenderProcessType())) {
                toElsAccountList = tenderProjectSuppliers.stream().filter(temp -> "1".equals(temp.getPreShortlisted())).map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
                if (PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openBidStatus)) {
                    operation = "tenderOpenBid";
                } else if (PurchaseOpenBidStatusEnum.END_BID.getValue().equals(openBidStatus)) {
                    operation = "tenderEndBid";
                }
            } else if (SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(TenderFlagInjectionContext.getTenderCurrentStep())) {
                toElsAccountList = tenderProjectSuppliers.stream().filter(temp -> "1".equals(temp.getPreShortlisted())).map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
                if (PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openBidStatus)) {
                    operation = "firstTenderOpenBid";
                } else if (PurchaseOpenBidStatusEnum.END_BID.getValue().equals(openBidStatus)) {
                    operation = "firstTenderEndBid";
                }
            } else if (SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(TenderFlagInjectionContext.getTenderCurrentStep())) {
                toElsAccountList = tenderProjectSuppliers.stream().filter(temp -> "1".equals(temp.getShortlisted())).map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
                if (PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openBidStatus)) {
                    operation = "secondTenderOpenBid";
                } else if (PurchaseOpenBidStatusEnum.END_BID.getValue().equals(openBidStatus)) {
                    operation = "secondTenderEndBid";
                }
            }
            if (!StringUtils.hasText((String)operation)) {
                log.error("\u672a\u77e5\u64cd\u4f5c\u72b6\u6001\uff0c\u5206\u5305\u4fe1\u606f\uff1a{},CheckType:{},ProcessType:{},CurrentStep:{}", new Object[]{JSON.toJSONString((Object)((Object)subpackageInfo)), TenderFlagInjectionContext.getTenderCheckType(), TenderFlagInjectionContext.getTenderProcessType(), TenderFlagInjectionContext.getTenderCurrentStep()});
                return;
            }
            Map params = FastJsonUtils.toMap((Object)subpackageInfo);
            if (decryptionTime == null) {
                params.put("decryptionTime", decryptionTime);
            }
            this.sendMsg(TenantContext.getTenant(), toElsAccountList, params, urlParams.toString(), "tender", operation);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void supplierAutoSignAndDecrypting(PurchaseTenderProjectSubpackageInfo subpackageInfo) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageInfo.getId());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.projectSupplierService.selectBySubpackageId(querySupplier);
        if (CollectionUtil.isEmpty(tenderProjectSupplierList)) {
            return;
        }
        for (TenderProjectSupplier tenderProjectSupplier : tenderProjectSupplierList) {
            String responseStatus = TenderOperationFieldUtils.getFieldStringValue((Object)tenderProjectSupplier, "responseStatus");
            String signIn = TenderOperationFieldUtils.getFieldStringValue((Object)tenderProjectSupplier, "signIn");
            if (!TenderProjectSupplieResponseStatusEnum.RESPONSE_BID.getValue().equals(responseStatus)) continue;
            TenderOperationFieldUtils.setFieldValue((Object)tenderProjectSupplier, "1", "signIn");
            TenderOperationFieldUtils.setFieldValue((Object)tenderProjectSupplier, "1", "decrypt");
        }
        this.projectSupplierService.updateBatchById(tenderProjectSupplierList);
    }

    @Override
    public List<SaleTenderPriceOpenings> getPurchasePriceOpeningsById(String id) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.getById((Serializable)((Object)id)));
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)subpackageInfo);
        if (PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openBidStatus) || PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(openBidStatus)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u67e5\u770b\u5f00\u6807\u4e00\u89c8\u8868\uff01"));
        }
        TenderProjectSupplierService projectSupplierService = (TenderProjectSupplierService)SpringContextUtils.getBean(TenderProjectSupplierService.class);
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(id);
        List<TenderProjectSupplier> tenderProjectSuppliers = projectSupplierService.selectBySubpackageId(querySupplier);
        List<String> supplierAccountList = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "decrypt"))).map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
        SaleTenderPriceOpeningsService saleTenderPriceOpeningsService = (SaleTenderPriceOpeningsService)SpringContextUtils.getBean(SaleTenderPriceOpeningsService.class);
        List<SaleTenderPriceOpenings> tenderPriceOpeningsList = saleTenderPriceOpeningsService.getSalePriceOpeningsBySubpackageId(subpackageInfo.getId(), supplierAccountList, "0");
        DictColumnTranslateUtils.dictColumnTranslate(tenderPriceOpeningsList);
        return tenderPriceOpeningsList;
    }

    @Override
    public void exportPriceOpenings(String id, HttpServletResponse response) {
        List<SaleTenderPriceOpenings> saleTenderPriceOpenings = this.getPurchasePriceOpeningsById(id);
        DictColumnTranslateUtils.dictColumnTranslate(saleTenderPriceOpenings);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(saleTenderPriceOpenings), (String)"\u5f00\u6807\u4ef7\u683c\u4e00\u89c8\u8868\u4e3a\u7a7a");
        ExcelWriter writer = new ExcelWriter(true, "\u5f00\u6807\u4ef7\u683c\u4e00\u89c8\u8868");
        List<List<String>> rows = this.exportData(saleTenderPriceOpenings);
        writer.write(rows, true);
        this.setSizeColumn(writer.getSheet(), rows.get(0).size());
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=333");
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (Exception e) {
            log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
    }

    @Override
    public void exportPriceOpeningsPDF(String id, HttpServletResponse response) {
        int widthPercentage = 100;
        int high = 25;
        PdfWriter writer = null;
        Document document = null;
        OutputStream os = null;
        response.setContentType("application/x-download");
        try {
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u5f00\u6807\u4e00\u89c8\u8868", "UTF-8") + ".pdf");
            os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            document = new Document(PageSize.A4, 20.0f, 20.0f, 20.0f, 20.0f);
            writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
            document.open();
            BaseFont baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font size14font = new Font(baseFont, 14.0f, 1);
            Font size10font = new Font(baseFont, 10.0f, 0);
            PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.getById((Serializable)((Object)id)));
            PdfPTable tableName = new PdfPTable(1);
            tableName.setWidthPercentage((float)widthPercentage);
            tableName.addCell(this.pdfTableStyle("\u5f00\u6807\u4e00\u89c8\u8868", size14font, 50, true, true));
            document.add((Element)tableName);
            PdfPTable twotableName = new PdfPTable(2);
            twotableName.setWidthPercentage((float)widthPercentage);
            twotableName.addCell(this.pdfTableStyle("\u9879\u76ee\u540d\u79f0: " + subpackageInfo.getTenderProjectName(), size10font, 30, false, true, 0, -1));
            twotableName.addCell(this.pdfTableStyle("\u6807\u6bb5\u7f16\u53f7: " + subpackageInfo.getSubpackageNumber(), size10font, 30, false, true, 2, -1));
            document.add((Element)twotableName);
            PdfPTable threetableName = new PdfPTable(2);
            threetableName.setWidthPercentage((float)widthPercentage);
            threetableName.addCell(this.pdfTableStyle("\u5206\u5305\u540d\u79f0: " + subpackageInfo.getSubpackageName(), size10font, 30, false, true, 0, -1));
            threetableName.addCell(this.pdfTableStyle("\u5b9e\u9645\u5f00\u6807\u65f6\u95f4: " + DateUtils.formatTime((Date)TenderOperationFieldUtils.getFieldDateValue((Object)subpackageInfo, "announceOpenBidTime")), size10font, 30, false, true, 2, -1));
            document.add((Element)threetableName);
            List<SaleTenderPriceOpenings> saleTenderPriceOpenings = this.getPurchasePriceOpeningsById(id);
            DictColumnTranslateUtils.dictColumnTranslate(saleTenderPriceOpenings);
            List<List<String>> rows = this.exportData(saleTenderPriceOpenings);
            for (int i = 0; i < rows.size(); ++i) {
                List<String> params = rows.get(i);
                PdfPTable dataTable = new PdfPTable(params.size());
                dataTable.setWidthPercentage((float)widthPercentage);
                for (int j = 0; j < params.size(); ++j) {
                    dataTable.addCell(this.pdfTableStyle(params.get(j), size10font, high, true, true));
                }
                document.add((Element)dataTable);
            }
            PdfPTable lastTable = new PdfPTable(1);
            lastTable.setWidthPercentage((float)widthPercentage);
            PdfPCell pdfPCell = new PdfPCell(new Phrase("\u751f\u6210\u65f6\u95f4\u4e3a:" + DateUtil.now(), size10font));
            pdfPCell.setHorizontalAlignment(2);
            lastTable.addCell(pdfPCell);
            document.add((Element)lastTable);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ELSBootException(I18nUtil.translate((String)"i18n_title_fileDownloadFailed", (String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a") + e.getMessage());
        }
        finally {
            if (document != null) {
                document.close();
            }
            if (writer != null) {
                writer.close();
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public List<List<String>> exportData(List<SaleTenderPriceOpenings> saleTenderPriceOpenings) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        ArrayList head = new ArrayList();
        rows.add(head);
        List customColumnModelList = new ArrayList();
        for (int i = 0; i < saleTenderPriceOpenings.size(); ++i) {
            if (i == 0) {
                String customizeFieldModel = saleTenderPriceOpenings.get(i).getCustomizeFieldModel();
                customColumnModelList = JSONArray.parseArray((String)customizeFieldModel, CustomColumnModel.class);
                customColumnModelList.stream().forEach(column -> head.add(column.getTitle()));
            }
            String customizeFieldData = saleTenderPriceOpenings.get(i).getCustomizeFieldData();
            JSONArray dataJsonArray = JSONArray.parseArray((String)customizeFieldData);
            ArrayList<String> paramRow = new ArrayList<String>();
            for (CustomColumnModel customColumnModel : customColumnModelList) {
                for (int j = 0; j < dataJsonArray.size(); ++j) {
                    JSONObject jsonObject = dataJsonArray.getJSONObject(j);
                    Object value = jsonObject.get((Object)customColumnModel.getField());
                    if (value == null) {
                        paramRow.add("");
                        continue;
                    }
                    paramRow.add(value + "");
                }
            }
            rows.add(paramRow);
        }
        return rows;
    }

    private PdfPCell pdfTableStyle(String content, Font font, int high, boolean isAlignCenter, boolean isAlignMidde) {
        PdfPCell pdfPCell = new PdfPCell(new Phrase(content, font));
        pdfPCell.setMinimumHeight((float)high);
        pdfPCell.setUseAscender(true);
        if (isAlignCenter) {
            pdfPCell.setHorizontalAlignment(1);
        }
        if (isAlignMidde) {
            pdfPCell.setVerticalAlignment(5);
        }
        return pdfPCell;
    }

    private PdfPCell pdfTableStyle(String content, Font font, int high, boolean isAlignCenter, boolean isAlignMidde, int align, int midde) {
        PdfPCell pdfPCell = new PdfPCell(new Phrase(content, font));
        pdfPCell.setMinimumHeight((float)high);
        pdfPCell.setUseAscender(true);
        if (isAlignCenter) {
            pdfPCell.setHorizontalAlignment(1);
        } else {
            pdfPCell.setHorizontalAlignment(align);
        }
        if (isAlignMidde) {
            pdfPCell.setVerticalAlignment(5);
        } else {
            pdfPCell.setVerticalAlignment(midde);
        }
        return pdfPCell;
    }

    public void setSizeColumn(Sheet sheet, int size) {
        for (int columnNum = 0; columnNum <= size; ++columnNum) {
            int columnWidth = sheet.getColumnWidth(columnNum) / 256;
            for (int rowNum = 0; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                int length;
                Cell currentCell;
                Row currentRow = sheet.getRow(rowNum) == null ? sheet.createRow(rowNum) : sheet.getRow(rowNum);
                if (currentRow.getCell(columnNum) == null || (currentCell = currentRow.getCell(columnNum)).getCellType() != CellType.STRING || columnWidth >= (length = currentCell.getStringCellValue().getBytes().length)) continue;
                columnWidth = length;
            }
            sheet.setColumnWidth(columnNum, columnWidth * 256);
        }
    }
}

