/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.encryption.AesEncryptUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.attachment.entity.PriceModel;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetter;
import com.els.modules.tender.attachment.entity.PurchaseTenderPriceOpeningsTemplate;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterService;
import com.els.modules.tender.attachment.service.PurchaseTenderPriceOpeningsTemplateService;
import com.els.modules.tender.clarification.entity.SaleTenderClarificationInfo;
import com.els.modules.tender.clarification.service.SaleTenderClarificationInfoService;
import com.els.modules.tender.column.enumerate.CustomerFieldCategoryEnum;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.entity.BaseCheckTypeEntity;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceItem;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.utils.TenderProjectMemberUtils;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.enumerate.SaleTenderDocumentSubmitEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSignUpStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSupplieResponseStatusEnum;
import com.els.modules.tender.sale.mapper.SaleTenderPriceOpeningsMapper;
import com.els.modules.tender.sale.service.SaleTenderEvaluationAttachmentService;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.sale.vo.SaleTenderBidLetterVo;
import com.els.modules.tender.sale.vo.SaleTenderProjectDocumentSubmitInfoVO;
import com.els.modules.tender.sale.vo.SaleTenderProjectDocumentSubmitInfoViewVO;
import com.els.modules.tender.supplier.entity.TenderProjectSignUp;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderInvitationSupplierReceiptService;
import com.els.modules.tender.supplier.service.TenderProjectSignUpService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class SaleTenderPriceOpeningsServiceImpl
extends BaseServiceImpl<SaleTenderPriceOpeningsMapper, SaleTenderPriceOpenings>
implements SaleTenderPriceOpeningsService {
    private static final Logger log = LoggerFactory.getLogger(SaleTenderPriceOpeningsServiceImpl.class);
    @Autowired
    private TenderProjectSupplierService saleTenderProjectSupplierServiceImpl;
    @Autowired
    private SaleTenderEvaluationAttachmentService saleTenderEvaluationAttachmentServiceImpl;
    @Autowired
    private TenderProjectSignUpService tenderProjectSignUpService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderBidLetterService purchaseTenderBidLetterService;
    @Autowired
    private PurchaseTenderPriceOpeningsTemplateService purchaseTenderPriceOpeningsTemplateServiceImpl;
    @Lazy
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService purchaseTenderProjectSubpackageInfoService;
    @Autowired
    private TenderInvitationSupplierReceiptService tenderInvitationSupplierReceiptService;

    @Override
    public List<SaleTenderPriceOpenings> selectByMainId(String mainId) {
        return ((SaleTenderPriceOpeningsMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addAll(SaleTenderProjectDocumentSubmitInfoVO supplierTenderProjectMasterInfoPage) {
        TenderProjectSupplier masterInfo = (TenderProjectSupplier)((Object)this.saleTenderProjectSupplierServiceImpl.getById((Serializable)((Object)supplierTenderProjectMasterInfoPage.getId())));
        this.checkParam(supplierTenderProjectMasterInfoPage, masterInfo);
        masterInfo.setDeleted(CommonConstant.DEL_FLAG_0);
        masterInfo.setContacts(supplierTenderProjectMasterInfoPage.getContacts());
        masterInfo.setContactsPhone(supplierTenderProjectMasterInfoPage.getContactsPhone());
        masterInfo.setCombination(supplierTenderProjectMasterInfoPage.getCombination());
        masterInfo.setCombinationName(supplierTenderProjectMasterInfoPage.getCombinationName());
        masterInfo.setSubmitFileIp(IPUtils.getIpAddr());
        boolean hasReject = this.tenderInvitationSupplierReceiptService.hasReject(masterInfo.getSupplierAccount(), masterInfo.getSubpackageId());
        Assert.isTrue((!hasReject ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u9080\u8bf7\u5df2\u62d2\u7edd\uff0c\u4e0d\u53ef\u9012\u4ea4\u6587\u4ef6!"));
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(TenderFlagInjectionContext.getTenderCheckType());
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.purchaseTenderProjectSubpackageInfoService.selectById(masterInfo.getSubpackageId());
        String filePassword = "";
        if ("1".equals(subpackageInfo.getOpenBidEncrypt())) {
            filePassword = AesEncryptUtil.encrypt((String)supplierTenderProjectMasterInfoPage.getFilePassword());
        }
        if (hasPreTrial) {
            masterInfo.setPreFilePassword(filePassword);
            masterInfo.setPreResponseStatus("1");
            masterInfo.setPreResponseTime(new Date());
        } else {
            masterInfo.setFilePassword(filePassword);
            masterInfo.setResultResponseStatus("1");
            masterInfo.setResultResponseTime(new Date());
            masterInfo.setResponseStatus("1");
            masterInfo.setResponseTime(new Date());
        }
        this.saleTenderProjectSupplierServiceImpl.updateById((Object)masterInfo);
        this.deleteAll(supplierTenderProjectMasterInfoPage);
        this.add(supplierTenderProjectMasterInfoPage);
        String operation = "documentSubmitFile";
        if (hasPreTrial) {
            operation = "preDocumentSubmitFile";
        }
        this.sendMsg(masterInfo, operation);
    }

    private void sendMsg(TenderProjectSupplier masterInfo, String operation) {
        List<ElsSubAccountDTO> accountDTOList = TenderProjectMemberUtils.getTenderProjectMember(masterInfo.getTenderProjectId());
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(masterInfo.getTenderProjectId()).append("&subpackageId=").append(masterInfo.getSubpackageId());
        this.sendMsgToSubAccount(TenantContext.getTenant(), accountDTOList, (Object)masterInfo, urlParams.toString(), "tender", operation);
    }

    private void checkParam(SaleTenderProjectDocumentSubmitInfoVO supplierTenderProjectMasterInfoPage, TenderProjectSupplier newSupplier) {
        String purchaseBid;
        Assert.hasText((String)supplierTenderProjectMasterInfoPage.getTenderProjectNumber(), (String)I18nUtil.translate((String)"i18n_alert_dIAyxOLVW_a6e5f3db", (String)"\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)supplierTenderProjectMasterInfoPage.getTenderProjectName(), (String)I18nUtil.translate((String)"i18n_alert_dIRLxOLVW_eb0fa139", (String)"\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)supplierTenderProjectMasterInfoPage.getSubpackageId(), (String)I18nUtil.translate((String)"i18n_alert_zsxOLVW_2edb7bb2", (String)"\u5206\u5305\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)supplierTenderProjectMasterInfoPage.getSupplierName(), (String)I18nUtil.translate((String)"i18n_alert_eBtLRLWAERLWxOLVW_351757df", (String)"\u6295\u6807\u5355\u4f4d\u540d\u79f0(\u4f01\u4e1a\u540d\u79f0)\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)supplierTenderProjectMasterInfoPage.getPurchaseEnterpriseAccount(), (String)I18nUtil.translate((String)"i18n_alert_YBtLeyxOLVW_e92a07c", (String)"\u62db\u6807\u5355\u4f4d\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<SaleAttachmentDTO> saleAttachmentDTOList = supplierTenderProjectMasterInfoPage.getSaleAttachmentDTOList();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(saleAttachmentDTOList), (String)I18nUtil.translate((String)"i18n_alert_QIVHxOLVW_3eef2cf4", (String)"\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
        Map<String, Long> fileTypeCount = saleAttachmentDTOList.stream().collect(Collectors.groupingBy(SaleAttachmentDTO::getFileType, Collectors.counting()));
        if ("1".equals(TenderFlagInjectionContext.getTenderCheckType())) {
            if ("1".equals(TenderFlagInjectionContext.getTenderProcessType())) {
                Assert.isTrue((Long.valueOf("1").equals(fileTypeCount.get(SaleTenderDocumentSubmitEnum.ONE_STEP_PROCESS.getValue())) && Long.valueOf("1").equals(fileTypeCount.get(SaleTenderDocumentSubmitEnum.TWO_STEP_PROCESS.getValue())) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u7b2c\u4e00\u6b65\u6295\u6807\u6587\u4ef6\u548c\u7b2c\u4e8c\u6b65\u6295\u6807\u6587\u4ef6\u5404\u9700\u8981\u4e00\u4e2a!"));
            } else {
                Assert.isTrue((boolean)Long.valueOf("1").equals(fileTypeCount.get(SaleTenderDocumentSubmitEnum.PROCESS.getValue())), (String)I18nUtil.translate((String)"", (String)"\u6295\u6807\u6587\u4ef6\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a!"));
            }
        } else {
            Assert.isTrue((boolean)Long.valueOf("1").equals(fileTypeCount.get(SaleTenderDocumentSubmitEnum.PRE_PROCESS.getValue())), (String)I18nUtil.translate((String)"", (String)"\u9884\u5ba1\u6587\u4ef6\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a!"));
        }
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.purchaseTenderProjectSubpackageInfoService.selectById(supplierTenderProjectMasterInfoPage.getSubpackageId());
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(TenderProjectSignUp::getSubpackageId, (Object)supplierTenderProjectMasterInfoPage.getSubpackageId())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List tenderProjectSignUps = this.tenderProjectSignUpService.list((Wrapper)qw);
        if (CollectionUtils.isNotEmpty((Collection)tenderProjectSignUps)) {
            TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)tenderProjectSignUps.get(0));
            Assert.isTrue((boolean)TenderProjectSignUpStatusEnum.AUDIT_PASS.getValue().equals(tenderProjectSignUp.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_sRUJeRSnOtkQInJ_bd180235", (String)"\u62a5\u540d\u5ba1\u67e5\u901a\u8fc7\u540e\u624d\u80fd\u64cd\u4f5c\u6587\u4ef6\u9012\u4ea4!"));
        }
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        Assert.hasText((String)tenderCheckType, (String)I18nUtil.translate((String)"", (String)"\u5ba1\u67e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType);
        Date fileSubmitEndTime = hasPreTrial ? subpackageInfo.getPreFileSubmitEndTime() : subpackageInfo.getFileSubmitEndTime();
        Assert.isTrue((boolean)new Date().before(fileSubmitEndTime), (String)I18nUtil.translate((String)"i18n_alert_QInJKIIRW_ebbbb46d", (String)"\u6587\u4ef6\u9012\u4ea4\u65f6\u95f4\u5df2\u8fc7!"));
        if (hasPreTrial) {
            if ("1".equals(subpackageInfo.getBidding())) {
                purchaseBid = newSupplier.getPrePurchaseBid();
                Assert.isTrue((boolean)"1".equals(purchaseBid), (String)I18nUtil.translate((String)"i18n_alert_SUURBVHVImW_c7c1e16a", (String)"\u65e0\u9884\u5ba1\u8d2d\u6807\u4fe1\u606f\u8bf7\u68c0\u67e5!"));
            }
        } else if ("1".equals(subpackageInfo.getBidding())) {
            purchaseBid = newSupplier.getPurchaseBid();
            Assert.isTrue((boolean)"1".equals(purchaseBid), (String)I18nUtil.translate((String)"i18n_alert_SRBVHVImW_dd43f2cd", (String)"\u65e0\u8d2d\u6807\u4fe1\u606f\u8bf7\u68c0\u67e5!"));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SaleTenderClarificationInfo::getSubpackageId, (Object)subpackageInfo.getId());
        wrapper.eq(BaseCheckTypeEntity::getCheckType, (Object)TenderFlagInjectionContext.getTenderCheckType());
        wrapper.eq(SaleTenderClarificationInfo::getStatus, (Object)"0");
        SaleTenderClarificationInfoService saleTenderClarificationInfoService = (SaleTenderClarificationInfoService)SpringContextUtils.getBean(SaleTenderClarificationInfoService.class);
        List clarificationList = saleTenderClarificationInfoService.getBaseMapper().selectList((Wrapper)wrapper);
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)clarificationList), (String)I18nUtil.translate((String)"", (String)"\u6f84\u6e05\u7b54\u7591\u4e2d\u6709\u672a\u786e\u8ba4\u7684\u6f84\u6e05,\u8bf7\u68c0\u67e5!"));
        if ("1".equals(subpackageInfo.getUseCa())) {
            return;
        }
        List<SaleTenderPriceOpenings> saleTenderPriceOpeningsList = supplierTenderProjectMasterInfoPage.getSaleTenderPriceOpeningsList();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(saleTenderPriceOpeningsList), (String)I18nUtil.translate((String)"i18n_alert_eBxIumIBBxOLVW_13a6c6d6", (String)"\u6295\u6807\u51fd\u4e0b\u4ef7\u683c\u4e00\u89c8\u8868\u4e0d\u80fd\u4e3a\u7a7a!"));
        saleTenderPriceOpeningsList.stream().forEach(priceOpenings -> {
            String customizeFieldModel = priceOpenings.getCustomizeFieldModel();
            Assert.hasText((String)customizeFieldModel, (String)I18nUtil.translate((String)"i18n_alert_umIBBAxOLV_3476f42c", (String)"\u4ef7\u683c\u4e00\u89c8\u8868\u5217\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((!"[]".equals(customizeFieldModel) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_umIBBAxOLV_3476f42c", (String)"\u4ef7\u683c\u4e00\u89c8\u8868\u5217\u4e0d\u80fd\u4e3a\u7a7a!"));
            String customizeFieldData = priceOpenings.getCustomizeFieldData();
            Assert.hasText((String)customizeFieldData, (String)I18nUtil.translate((String)"i18n_alert_umIBBWFxOLV_75313029", (String)"\u4ef7\u683c\u4e00\u89c8\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((!"[]".equals(customizeFieldData) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_umIBBWFxOLV_75313029", (String)"\u4ef7\u683c\u4e00\u89c8\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
            List columnList = JSONArray.parseArray((String)customizeFieldModel, CustomColumnModel.class);
            JSONArray dataJsonArray = JSONArray.parseArray((String)customizeFieldData);
            for (CustomColumnModel customColumnModel : columnList) {
                if (!"1".equals(customColumnModel.getMust()) || !"0".equals(customColumnModel.getInputOrg())) continue;
                for (int i = 0; i < dataJsonArray.size(); ++i) {
                    JSONObject jsonObject = dataJsonArray.getJSONObject(i);
                    Assert.isTrue((boolean)jsonObject.containsKey((Object)customColumnModel.getField()), (String)I18nUtil.translate((String)"i18n_alert_umIBBsMKeBtLlSAWVImW_d773ff2c", (String)"\u4ef7\u683c\u4e00\u89c8\u8868\u4e2d\u5b58\u5728\u6295\u6807\u5355\u4f4d\u5fc5\u586b\u5217,\u8bf7\u68c0\u67e5!"));
                    Assert.isTrue((null != jsonObject.get((Object)customColumnModel.getField()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_umIBBsMKeBtLlSAWVImW_d773ff2c", (String)"\u4ef7\u683c\u4e00\u89c8\u8868\u4e2d\u5b58\u5728\u6295\u6807\u5355\u4f4d\u5fc5\u586b\u5217,\u8bf7\u68c0\u67e5!"));
                    Assert.isTrue((!"".equals(jsonObject.get((Object)customColumnModel.getField())) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_umIBBsMKeBtLlSAWVImW_d773ff2c", (String)"\u4ef7\u683c\u4e00\u89c8\u8868\u4e2d\u5b58\u5728\u6295\u6807\u5355\u4f4d\u5fc5\u586b\u5217,\u8bf7\u68c0\u67e5!"));
                }
            }
        });
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void editAll(SaleTenderProjectDocumentSubmitInfoVO supplierTenderProjectMasterInfoPage) {
        TenderProjectSupplier masterInfo = new TenderProjectSupplier();
        BeanUtils.copyProperties((Object)((Object)supplierTenderProjectMasterInfoPage), (Object)((Object)masterInfo));
        boolean hasReject = this.tenderInvitationSupplierReceiptService.hasReject(masterInfo.getSupplierAccount(), masterInfo.getSubpackageId());
        Assert.isTrue((!hasReject ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u9080\u8bf7\u5df2\u62d2\u7edd\uff0c\u4e0d\u53ef\u9012\u4ea4\u6587\u4ef6!"));
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(TenderFlagInjectionContext.getTenderCheckType());
        TenderOperationFieldUtils.setFieldValue((Object)masterInfo, TenderProjectSupplieResponseStatusEnum.RESPONSE_BID.getValue(), "responseStatus");
        TenderOperationFieldUtils.setFieldValue((Object)masterInfo, new Date(), "responseTime");
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.purchaseTenderProjectSubpackageInfoService.selectById(masterInfo.getSubpackageId());
        String filePassword = "";
        if ("1".equals(subpackageInfo.getOpenBidEncrypt())) {
            filePassword = AesEncryptUtil.encrypt((String)masterInfo.getFilePassword());
        }
        if (hasPreTrial) {
            masterInfo.setPreFilePassword(filePassword);
            masterInfo.setFilePassword(null);
        } else {
            masterInfo.setFilePassword(filePassword);
        }
        masterInfo.setSubmitFileIp(IPUtils.getIpAddr());
        this.saleTenderProjectSupplierServiceImpl.updateById((Object)masterInfo);
        this.deleteAll(supplierTenderProjectMasterInfoPage);
        this.add(supplierTenderProjectMasterInfoPage);
        String operation = "documentSubmitFile";
        if (hasPreTrial) {
            operation = "preDocumentSubmitFile";
        }
        this.sendMsg(masterInfo, operation);
    }

    @Override
    public SaleTenderProjectDocumentSubmitInfoViewVO queryDocumentSubmitInfo(TenderProjectSupplier tenderProjectSupplier) {
        TenderFlagInjectionContext.setTenderCurrentStep(null);
        SaleTenderProjectDocumentSubmitInfoViewVO documentSubmitInfoVO = new SaleTenderProjectDocumentSubmitInfoViewVO();
        TenderProjectSupplier projectSupplier = new TenderProjectSupplier();
        projectSupplier.setSubpackageId(tenderProjectSupplier.getSubpackageId());
        projectSupplier.setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSuppliers = this.saleTenderProjectSupplierServiceImpl.selectBySubpackageId(projectSupplier);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty(tenderProjectSuppliers), (String)I18nUtil.translate((String)"", (String)"\u65e0\u62a5\u540d\u4fe1\u606f,\u8bf7\u68c0\u67e5!"));
        TenderProjectSupplier masterInfo = tenderProjectSuppliers.get(0);
        BeanUtils.copyProperties((Object)((Object)masterInfo), (Object)((Object)documentSubmitInfoVO));
        List saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(masterInfo.getId() + "_" + TenderFlagInjectionContext.getTenderCheckType());
        documentSubmitInfoVO.setSaleAttachmentDTOList(saleAttachmentDTOList);
        List<SaleTenderBidLetterVo> tenderBidLetterVo = this.selectTenderBidLetterVo(masterInfo.getSubpackageId(), null, TenantContext.getTenant(), false);
        documentSubmitInfoVO.setTenderBidLetterVoList(tenderBidLetterVo);
        return documentSubmitInfoVO;
    }

    @Override
    public List<SaleTenderBidLetterVo> queryQuotedPriceInfo(String subpackageId) {
        List<SaleTenderBidLetterVo> saleTenderBidLetterVos = this.selectTenderBidLetterVo(subpackageId, null, TenantContext.getTenant(), true);
        return saleTenderBidLetterVos;
    }

    @Override
    public List<SaleTenderBidLetterVo> selectByQuotedPriceItemId(TenderEvaQuotedPriceItem tenderEvaQuotedPriceItem) {
        List<SaleTenderBidLetterVo> saleTenderBidLetterVos = this.selectTenderBidLetterVo(tenderEvaQuotedPriceItem.getSubpackageId(), tenderEvaQuotedPriceItem.getId(), tenderEvaQuotedPriceItem.getSupplierAccount(), true);
        return saleTenderBidLetterVos;
    }

    private List<SaleTenderBidLetterVo> selectTenderBidLetterVo(String subpackageId, String quotedPriceItemId, String supplierAccount, boolean hasStagePrice) {
        List<PurchaseTenderBidLetter> purchaseTenderBidLetters = this.purchaseTenderBidLetterService.queryPurchaseTenderBidLetter(subpackageId, hasStagePrice);
        if (CollectionUtils.isEmpty(purchaseTenderBidLetters)) {
            return null;
        }
        List<String> bidIds = purchaseTenderBidLetters.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper priceOpeningQueryWapper = new LambdaQueryWrapper();
        priceOpeningQueryWapper.in(SaleTenderPriceOpenings::getBidLetterId, bidIds);
        priceOpeningQueryWapper.eq(BaseEntity::getElsAccount, (Object)supplierAccount);
        if (!hasStagePrice) {
            priceOpeningQueryWapper.eq(SaleTenderPriceOpenings::getStageQuote, (Object)"0");
        } else if (StringUtils.hasText((String)quotedPriceItemId)) {
            priceOpeningQueryWapper.eq(SaleTenderPriceOpenings::getQuotedPriceItemId, (Object)quotedPriceItemId);
        } else {
            priceOpeningQueryWapper.apply(" stage = (SELECT MAX(stage) FROM sale_tender_price_openings WHERE is_deleted = 0 AND els_account = {0} and bid_letter_id in ({1}))", new Object[]{supplierAccount, CollectionUtil.join(bidIds, (CharSequence)",")});
        }
        List saleTenderPriceOpeningList = ((SaleTenderPriceOpeningsMapper)this.baseMapper).selectList((Wrapper)priceOpeningQueryWapper);
        if (CollectionUtils.isEmpty((Collection)saleTenderPriceOpeningList)) {
            List<PurchaseTenderPriceOpeningsTemplate> purchaseTenderPriceOpeningTemplates = this.purchaseTenderPriceOpeningsTemplateServiceImpl.selectByMainIds(bidIds);
            saleTenderPriceOpeningList = SysUtil.copyProperties(purchaseTenderPriceOpeningTemplates, SaleTenderPriceOpenings.class);
            saleTenderPriceOpeningList.parallelStream().forEach(item -> item.setId(null));
        }
        List finalSaleTenderPriceOpeningList = Optional.ofNullable(saleTenderPriceOpeningList).orElse(new ArrayList());
        List<SaleTenderBidLetterVo> tenderBidLetterVo = purchaseTenderBidLetters.stream().map(purchaseTenderBidLetter -> {
            SaleTenderBidLetterVo saleTenderBidLetterVo = new SaleTenderBidLetterVo();
            BeanUtils.copyProperties((Object)purchaseTenderBidLetter, (Object)((Object)saleTenderBidLetterVo));
            List<SaleTenderPriceOpenings> openingsList = finalSaleTenderPriceOpeningList.stream().filter(priceOpening -> priceOpening.getBidLetterId().equals(purchaseTenderBidLetter.getId())).collect(Collectors.toList());
            saleTenderBidLetterVo.setPriceOpeningsList(openingsList);
            return saleTenderBidLetterVo;
        }).collect(Collectors.toList());
        return tenderBidLetterVo;
    }

    public void deleteAll(SaleTenderProjectDocumentSubmitInfoVO supplierTenderProjectMasterInfoPage) {
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        this.deleteByMainId(supplierTenderProjectMasterInfoPage.getId());
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(supplierTenderProjectMasterInfoPage.getId() + "_" + checkType);
        this.saleTenderEvaluationAttachmentServiceImpl.deleteByMainId(supplierTenderProjectMasterInfoPage.getId());
    }

    public void add(SaleTenderProjectDocumentSubmitInfoVO supplierTenderProjectMasterInfoPage) {
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        List<SaleAttachmentDTO> saleAttachmentDTOList = supplierTenderProjectMasterInfoPage.getSaleAttachmentDTOList();
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(supplierTenderProjectMasterInfoPage.getId() + "_" + checkType);
        if (CollectionUtils.isNotEmpty(saleAttachmentDTOList)) {
            saleAttachmentDTOList.stream().forEach(attachment -> attachment.setHeadId(supplierTenderProjectMasterInfoPage.getId() + "_" + checkType));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOList);
            ArchiveUtil.saveArchiveBySaleAttachmentDTO(saleAttachmentDTOList, supplierTenderProjectMasterInfoPage.getId() + "_" + checkType, supplierTenderProjectMasterInfoPage.getSubpackageId(), supplierTenderProjectMasterInfoPage.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.DOCUMENT_SUBMIT_PREFIX.getValue());
        }
        LoginUser user = SysUtil.getLoginUser();
        List<SaleTenderPriceOpenings> priceOpeningsList = supplierTenderProjectMasterInfoPage.getSaleTenderPriceOpeningsList();
        List<String> bidLetterIdList = priceOpeningsList.stream().map(SaleTenderPriceOpenings::getBidLetterId).collect(Collectors.toList());
        List<PurchaseTenderBidLetter> tenderBidLetterList = this.purchaseTenderBidLetterService.selectBatchIds(bidLetterIdList);
        Map bidLetterMap = tenderBidLetterList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        for (SaleTenderPriceOpenings saleTenderPriceOpenings : priceOpeningsList) {
            saleTenderPriceOpenings.setSupplierName(user.getRealname());
            saleTenderPriceOpenings.setElsAccount(user.getElsAccount());
            PurchaseTenderBidLetter purchaseTenderBidLetter = (PurchaseTenderBidLetter)((Object)bidLetterMap.get(saleTenderPriceOpenings.getBidLetterId()));
            saleTenderPriceOpenings.setCheckType(purchaseTenderBidLetter.getCheckType());
            saleTenderPriceOpenings.setProcessType(purchaseTenderBidLetter.getProcessType());
            saleTenderPriceOpenings.setCurrentStep(purchaseTenderBidLetter.getCurrentStep());
            saleTenderPriceOpenings.setStageQuote("0");
            saleTenderPriceOpenings.setStage(CommonConstant.STATUS_NO);
        }
        this.deleteByBidLetter(bidLetterIdList, user.getElsAccount(), CommonConstant.DEL_FLAG_0);
        this.saveBatch(priceOpeningsList, 2000);
    }

    private void deleteByBidLetter(List<String> bidLetterIdList, String elsAccount, Integer stage) {
        ((SaleTenderPriceOpeningsMapper)this.baseMapper).deleteByBidLetter(bidLetterIdList, elsAccount, stage);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((SaleTenderPriceOpeningsMapper)this.baseMapper).deleteByMainId(mainId, TenderFlagInjectionContext.getTenderCheckType());
    }

    @Override
    public List<SaleTenderPriceOpenings> getSalePriceOpeningsBySubpackageId(String subpackageId, List<String> supplierAccountList, String stageQuote) {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String processType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getSubpackageId, (Object)subpackageId);
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getCheckType, (Object)tenderCheckType);
        if (supplierAccountList.isEmpty()) {
            return new ArrayList<SaleTenderPriceOpenings>();
        }
        lambdaQueryWrapper.in(BaseEntity::getElsAccount, supplierAccountList);
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getStageQuote, (Object)stageQuote);
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(processType)) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getProcessType, (Object)processType)).eq(SaleTenderPriceOpenings::getCurrentStep, (Object)currentStep);
        }
        return this.list((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<SaleTenderPriceOpenings> getSalePriceOpeningsByBidLetterId(String tenderBidLetterId) {
        return ((SaleTenderPriceOpeningsMapper)this.baseMapper).selectWithoutElsAccount(tenderBidLetterId);
    }

    @Override
    public List<SaleTenderPriceOpenings> queryByBidLetterIdIn(List<String> bidLetterIds, String supplierAccount) {
        return ((SaleTenderPriceOpeningsMapper)this.baseMapper).queryByBidLetterIdIn(bidLetterIds, supplierAccount);
    }

    @Override
    public void revokeSave(SaleTenderProjectDocumentSubmitInfoVO supplierTenderProjectMasterInfoPage) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.purchaseTenderProjectSubpackageInfoService.selectById(supplierTenderProjectMasterInfoPage.getSubpackageId());
        if (null != subpackageInfo) {
            Date fileSubmitEndTime = null;
            fileSubmitEndTime = "0".equals(TenderFlagInjectionContext.getTenderCheckType()) ? subpackageInfo.getPreFileSubmitEndTime() : subpackageInfo.getFileSubmitEndTime();
            Assert.isTrue((boolean)new Date().before(fileSubmitEndTime), (String)I18nUtil.translate((String)"i18n_alert_QInJKIIRW_ebbbb46d", (String)"\u6587\u4ef6\u9012\u4ea4\u65f6\u95f4\u5df2\u8fc7!"));
        }
        TenderProjectSupplier tenderProjectSupplier = (TenderProjectSupplier)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectMasterInfoPage), TenderProjectSupplier.class));
        this.saleTenderProjectSupplierServiceImpl.updateResponseById(tenderProjectSupplier);
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(TenderFlagInjectionContext.getTenderCheckType());
        String operation = "documentRevokeSubmitFile";
        if (hasPreTrial) {
            operation = "preDocumentRevokeSubmitFile";
        }
        this.sendMsg(tenderProjectSupplier, operation);
    }

    @Override
    public List<SaleAttachmentDTO> queryAttachmentBySubpackageId(String subpackageId, String supplierAccount) {
        TenderProjectSupplier projectSupplier = new TenderProjectSupplier();
        projectSupplier.setSubpackageId(subpackageId);
        projectSupplier.setSupplierAccount(supplierAccount);
        List<TenderProjectSupplier> tenderProjectSuppliers = this.saleTenderProjectSupplierServiceImpl.selectBySubpackageId(projectSupplier);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty(tenderProjectSuppliers), (String)I18nUtil.translate((String)"", (String)"\u65e0\u62a5\u540d\u4fe1\u606f,\u8bf7\u68c0\u67e5!"));
        TenderProjectSupplier masterInfo = tenderProjectSuppliers.get(0);
        List<SaleAttachmentDTO> saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(masterInfo.getId() + "_" + TenderFlagInjectionContext.getTenderCheckType());
        saleAttachmentDTOList = this.getStepSaleAttachmentDTO(saleAttachmentDTOList);
        return saleAttachmentDTOList;
    }

    @Override
    public void addQuotedPriceInfo(List<SaleTenderPriceOpenings> priceOpeningsList, Integer stage, String quotedPriceItemId) {
        List<String> bidLetterIdList = priceOpeningsList.stream().map(SaleTenderPriceOpenings::getBidLetterId).collect(Collectors.toList());
        this.buildQuotedPriceInfo(priceOpeningsList, stage, bidLetterIdList, quotedPriceItemId);
        this.saveBatch(priceOpeningsList, 2000);
    }

    @Override
    public void revokeQuotedPriceInfo(String quotedPriceItemId) {
        LoginUser user = SysUtil.getLoginUser();
        ((SaleTenderPriceOpeningsMapper)this.baseMapper).deleteByBidLetterQuotedPriceItemId(quotedPriceItemId, user.getElsAccount());
    }

    private void buildQuotedPriceInfo(List<SaleTenderPriceOpenings> priceOpeningsList, Integer stage, List<String> bidLetterIdList, String quotedPriceItemId) {
        LoginUser user = SysUtil.getLoginUser();
        List<PurchaseTenderBidLetter> tenderBidLetterList = this.purchaseTenderBidLetterService.selectBatchIds(bidLetterIdList);
        Map bidLetterMap = tenderBidLetterList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        for (SaleTenderPriceOpenings saleTenderPriceOpenings : priceOpeningsList) {
            saleTenderPriceOpenings.setId(IdWorker.getIdStr());
            saleTenderPriceOpenings.setSupplierName(user.getRealname());
            saleTenderPriceOpenings.setElsAccount(user.getElsAccount());
            PurchaseTenderBidLetter purchaseTenderBidLetter = (PurchaseTenderBidLetter)((Object)bidLetterMap.get(saleTenderPriceOpenings.getBidLetterId()));
            saleTenderPriceOpenings.setCheckType(purchaseTenderBidLetter.getCheckType());
            saleTenderPriceOpenings.setProcessType(purchaseTenderBidLetter.getProcessType());
            saleTenderPriceOpenings.setCurrentStep(purchaseTenderBidLetter.getCurrentStep());
            saleTenderPriceOpenings.setStageQuote("1");
            saleTenderPriceOpenings.setStage(stage);
            saleTenderPriceOpenings.setQuotedPriceItemId(quotedPriceItemId);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void encryptionOrDecryptionLetterStatus(SaleTenderPriceOpenings saleTenderPriceOpenings, String status) {
        SaleTenderPriceOpenings priceOpenings = new SaleTenderPriceOpenings();
        priceOpenings.setId(saleTenderPriceOpenings.getId());
        priceOpenings.setEncryption(status);
        ((SaleTenderPriceOpeningsMapper)this.baseMapper).updateById((Object)priceOpenings);
    }

    @Override
    public void rankQuotedPrice(String subpackageId) {
        List<SaleTenderPriceOpenings> saleTenderPriceOpeningsList = ((SaleTenderPriceOpeningsMapper)this.baseMapper).selectByMainSubpackageId(subpackageId);
        Map<String, List<SaleTenderPriceOpenings>> bidLetterPriceMap = saleTenderPriceOpeningsList.stream().collect(Collectors.groupingBy(SaleTenderPriceOpenings::getBidLetterId));
        List<String> bidLetterIds = saleTenderPriceOpeningsList.stream().map(SaleTenderPriceOpenings::getBidLetterId).distinct().collect(Collectors.toList());
        List<PurchaseTenderPriceOpeningsTemplate> purchaseTenderPriceOpeningsTemplates = this.purchaseTenderPriceOpeningsTemplateServiceImpl.selectByMainIds(bidLetterIds);
        Map<String, PurchaseTenderPriceOpeningsTemplate> priceOpeningsTemplateMap = purchaseTenderPriceOpeningsTemplates.stream().collect(Collectors.toMap(PurchaseTenderPriceOpeningsTemplate::getBidLetterId, priceOpeningsTemplate -> priceOpeningsTemplate, (o1, o2) -> o1));
        ArrayList priceModelAllList = new ArrayList();
        bidLetterPriceMap.forEach((bidLetterId, saleTenderPriceOpeningList) -> {
            Map<String, List<SaleTenderPriceOpenings>> supplierPriceMap = saleTenderPriceOpeningList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
            ArrayList supplierMaxStagePriceList = new ArrayList();
            supplierPriceMap.forEach((supplierAccount, supplierPriceList) -> {
                SaleTenderPriceOpenings saleTenderPriceOpenings = supplierPriceList.stream().max(Comparator.comparing(SaleTenderPriceOpenings::getStage)).get();
                supplierMaxStagePriceList.add(saleTenderPriceOpenings);
            });
            PurchaseTenderPriceOpeningsTemplate priceOpeningsTemplate = (PurchaseTenderPriceOpeningsTemplate)((Object)((Object)priceOpeningsTemplateMap.get(bidLetterId)));
            String customizeFieldModel = priceOpeningsTemplate.getCustomizeFieldModel();
            List columnList = JSONArray.parseArray((String)customizeFieldModel, CustomColumnModel.class);
            List filterColumnList = columnList.stream().filter(column -> CustomerFieldCategoryEnum.TENDER_OFFERS_COLUMN.getValue().equals(column.getFieldCategory())).collect(Collectors.toList());
            for (CustomColumnModel customColumnModel : filterColumnList) {
                ArrayList priceModels = new ArrayList();
                String field = customColumnModel.getField();
                supplierMaxStagePriceList.forEach(supplierMaxStagePrice -> {
                    if (supplierMaxStagePrice.getCustomizeFieldData().indexOf(field) != -1) {
                        PriceModel priceModel = new PriceModel();
                        priceModel.setField(customColumnModel.getField());
                        priceModel.setPriceOpeningsId(supplierMaxStagePrice.getId());
                        priceModel.setTitle(customColumnModel.getTitle());
                        JSONArray dataJsonArray = JSONArray.parseArray((String)supplierMaxStagePrice.getCustomizeFieldData());
                        for (int j = 0; j < dataJsonArray.size(); ++j) {
                            JSONObject jsonObject = dataJsonArray.getJSONObject(j);
                            String value = (String)jsonObject.get((Object)customColumnModel.getField());
                            if (value == null) continue;
                            priceModel.setPrice(new BigDecimal(value));
                            break;
                        }
                        priceModels.add(priceModel);
                    }
                });
                Collections.sort(priceModels, Comparator.comparing(PriceModel::getPrice));
                for (int i = 0; i < priceModels.size(); ++i) {
                    PriceModel priceModel = (PriceModel)priceModels.get(i);
                    priceModel.setSort(i + 1);
                }
                priceModelAllList.addAll(priceModels);
            }
        });
        ArrayList<SaleTenderPriceOpenings> updSaleTenderPriceOpeningsList = new ArrayList<SaleTenderPriceOpenings>();
        Map<String, List<PriceModel>> priceModelAllMap = priceModelAllList.stream().collect(Collectors.groupingBy(PriceModel::getPriceOpeningsId));
        for (SaleTenderPriceOpenings saleTenderPriceOpenings : saleTenderPriceOpeningsList) {
            List<PriceModel> priceModels = priceModelAllMap.get(saleTenderPriceOpenings.getId());
            if (!CollectionUtil.isNotEmpty(priceModels)) continue;
            saleTenderPriceOpenings.setPriceData(JSONObject.toJSONString(priceModels));
            updSaleTenderPriceOpeningsList.add(saleTenderPriceOpenings);
        }
        log.info("\u591a\u8f6e\u62a5\u4ef7\u7ed3\u675f\u66f4\u65b0\u7684\u62a5\u4ef7\u4fe1\u606f:{}", (Object)JSONObject.toJSONString(updSaleTenderPriceOpeningsList));
        if (CollectionUtil.isNotEmpty(updSaleTenderPriceOpeningsList)) {
            this.updateBatchById(updSaleTenderPriceOpeningsList);
        }
    }

    @Override
    public SaleTenderProjectDocumentSubmitInfoViewVO querySaleSubmitInfoBySubpackageId(String subpackageId, String supplierId) {
        TenderProjectSupplier tenderProjectSupplier = (TenderProjectSupplier)((Object)this.saleTenderProjectSupplierServiceImpl.getById((Serializable)((Object)supplierId)));
        Assert.isTrue((tenderProjectSupplier != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u67e5\u65e0\u6570\u636e!"));
        if (!TenderProjectSupplieResponseStatusEnum.RESPONSE_BID.getValue().equals(TenderOperationFieldUtils.getFieldStringValue((Object)tenderProjectSupplier, "responseStatus"))) {
            return null;
        }
        SaleTenderProjectDocumentSubmitInfoViewVO submitInfoViewVO = (SaleTenderProjectDocumentSubmitInfoViewVO)((Object)SysUtil.copyProperties((Object)((Object)tenderProjectSupplier), SaleTenderProjectDocumentSubmitInfoViewVO.class));
        List<SaleAttachmentDTO> saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectSupplier.getId() + "_" + TenderFlagInjectionContext.getTenderCheckType());
        saleAttachmentDTOList = this.getStepSaleAttachmentDTO(saleAttachmentDTOList);
        submitInfoViewVO.setSaleAttachmentDTOList(saleAttachmentDTOList);
        List<SaleTenderBidLetterVo> tenderBidLetterVo = this.selectTenderBidLetterVoByNew(tenderProjectSupplier.getSubpackageId(), null, tenderProjectSupplier.getSupplierAccount(), true);
        submitInfoViewVO.setTenderBidLetterVoList(tenderBidLetterVo);
        return submitInfoViewVO;
    }

    private List<SaleAttachmentDTO> getStepSaleAttachmentDTO(List<SaleAttachmentDTO> saleAttachmentDTOList) {
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        String processType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        String fileType = "";
        if ("0".equals(checkType)) {
            fileType = SaleTenderDocumentSubmitEnum.PRE_PROCESS.getValue();
        } else if ("0".equals(processType)) {
            fileType = SaleTenderDocumentSubmitEnum.PROCESS.getValue();
        } else if ("0".equals(currentStep)) {
            fileType = SaleTenderDocumentSubmitEnum.ONE_STEP_PROCESS.getValue();
        }
        if (CollectionUtil.isNotEmpty(saleAttachmentDTOList)) {
            String finalFileType = fileType;
            saleAttachmentDTOList = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)finalFileType) ? saleAttachmentDTOList.stream().filter(item -> SaleTenderDocumentSubmitEnum.ONE_STEP_PROCESS.getValue().equals(item.getFileType()) || SaleTenderDocumentSubmitEnum.TWO_STEP_PROCESS.getValue().equals(item.getFileType())).collect(Collectors.toList()) : saleAttachmentDTOList.stream().filter(item -> finalFileType.equals(item.getFileType())).collect(Collectors.toList());
        }
        return saleAttachmentDTOList;
    }

    private List<SaleTenderBidLetterVo> selectTenderBidLetterVoByNew(String subpackageId, String quotedPriceItemId, String supplierAccount, boolean hasStagePrice) {
        List<PurchaseTenderBidLetter> purchaseTenderBidLetters = this.purchaseTenderBidLetterService.queryPurchaseTenderBidLetter(subpackageId);
        if (CollectionUtils.isEmpty(purchaseTenderBidLetters)) {
            return null;
        }
        List<String> bidIds = purchaseTenderBidLetters.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper priceOpeningQueryWapper = new LambdaQueryWrapper();
        priceOpeningQueryWapper.in(SaleTenderPriceOpenings::getBidLetterId, bidIds);
        priceOpeningQueryWapper.eq(BaseEntity::getElsAccount, (Object)supplierAccount);
        if (!hasStagePrice) {
            priceOpeningQueryWapper.eq(SaleTenderPriceOpenings::getStageQuote, (Object)"0");
        } else if (StringUtils.hasText((String)quotedPriceItemId)) {
            priceOpeningQueryWapper.eq(SaleTenderPriceOpenings::getQuotedPriceItemId, (Object)quotedPriceItemId);
        } else {
            priceOpeningQueryWapper.apply(" stage = (SELECT MAX(stage) FROM sale_tender_price_openings WHERE is_deleted = 0 AND els_account = {0} and bid_letter_id in ({1}))", new Object[]{supplierAccount, CollectionUtil.join(bidIds, (CharSequence)",")});
        }
        List saleTenderPriceOpeningList = ((SaleTenderPriceOpeningsMapper)this.baseMapper).selectList((Wrapper)priceOpeningQueryWapper);
        if (CollectionUtils.isEmpty((Collection)saleTenderPriceOpeningList)) {
            List<PurchaseTenderPriceOpeningsTemplate> purchaseTenderPriceOpeningTemplates = this.purchaseTenderPriceOpeningsTemplateServiceImpl.selectByMainIds(bidIds);
            saleTenderPriceOpeningList = SysUtil.copyProperties(purchaseTenderPriceOpeningTemplates, SaleTenderPriceOpenings.class);
            saleTenderPriceOpeningList.parallelStream().forEach(item -> item.setId(null));
        }
        List finalSaleTenderPriceOpeningList = saleTenderPriceOpeningList;
        List<SaleTenderBidLetterVo> tenderBidLetterVo = purchaseTenderBidLetters.stream().map(purchaseTenderBidLetter -> {
            SaleTenderBidLetterVo saleTenderBidLetterVo = new SaleTenderBidLetterVo();
            BeanUtils.copyProperties((Object)purchaseTenderBidLetter, (Object)((Object)saleTenderBidLetterVo));
            List<SaleTenderPriceOpenings> openingsList = finalSaleTenderPriceOpeningList.stream().filter(priceOpening -> priceOpening.getBidLetterId().equals(purchaseTenderBidLetter.getId())).collect(Collectors.toList());
            saleTenderBidLetterVo.setPriceOpeningsList(openingsList);
            return saleTenderBidLetterVo;
        }).collect(Collectors.toList());
        return tenderBidLetterVo;
    }
}

