/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.SubAccountOrgDTO;
import com.els.modules.base.api.dto.ElsBusinessTransferHisDTO;
import com.els.modules.demand.api.dto.RequestMatchInfomationDTO;
import com.els.modules.demand.entity.PurchaseOrderRequestInformation;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.mapper.PurchaseRequestItemMapper;
import com.els.modules.demand.rpc.ElsBusinessTransferHisLocalRpcService;
import com.els.modules.demand.rpc.ElsTacticsLocalRpcService;
import com.els.modules.demand.rpc.InquiryInvokeOtherService;
import com.els.modules.demand.rpc.InquiryInvokeSubaccountRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.rpc.service.PurchaseRequestItemSelfService;
import com.els.modules.demand.service.PurchaseOrderRequestInformationService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeOrderRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.dto.PurchaseMaterialUnitDTO;
import com.els.modules.material.api.service.PurchaseMaterialHeadRpcService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.order.api.dto.PurchaseOrderProgressTemplateDistributionDTO;
import com.els.modules.order.api.enumerate.OrderItemSendStatusEnum;
import com.els.modules.order.api.enumerate.OrderItemStatusEnum;
import com.els.modules.order.api.enumerate.OrderSourceTypeEnum;
import com.els.modules.tactics.api.dto.ElsTacticsHeadDTO;
import com.els.modules.tactics.api.dto.ElsTacticsItemDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseRequestItemServiceImpl
extends BaseServiceImpl<PurchaseRequestItemMapper, PurchaseRequestItem>
implements PurchaseRequestItemService {
    @Resource
    private PurchaseRequestItemMapper purchaseRequestItemMapper;
    @Resource
    private ElsBusinessTransferHisLocalRpcService elsBusinessTransferHisLocalRpcService;
    @Resource
    private ElsTacticsLocalRpcService elsTacticsLocalRpcService;
    @Resource
    private InquiryInvokeSubaccountRpcService inquiryInvokeSubaccountRpcService;
    @Resource
    private InquiryInvokeOtherService inquiryInvokeOtherService;
    @Resource
    private InquiryInvokeOrderRpcService inquiryInvokeOrderRpcService;
    @Resource
    private PurchaseRequestItemSelfService purchaseRequestItemSelfService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    @Resource
    private PurchaseMaterialHeadRpcService purchaseMaterialHeadRpcService;
    @Autowired
    private PurchaseOrderRequestInformationService purchaseOrderRequestInformationService;
    private static final String PURCHASE_UNIT_TYPE = "0";
    private static final String REPERTORY_UNIT_TYPE = "1";

    @Override
    public List<PurchaseRequestItem> selectByMainId(String mainId) {
        return this.purchaseRequestItemMapper.selectByMainId(mainId);
    }

    @Override
    public void toDemandPool(PurchaseRequestHeadVO purchaseRequestHeadPage) {
        List<ElsTacticsHeadDTO> list = this.elsTacticsLocalRpcService.getByBusinessType(purchaseRequestHeadPage.getElsAccount(), "demandPool");
        if (!CollectionUtils.isEmpty(list)) {
            for (ElsTacticsHeadDTO elsTacticsHead : list) {
                List<ElsTacticsItemDTO> elsTacticsItems = this.elsTacticsLocalRpcService.listMainId(elsTacticsHead.getId());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(PurchaseRequestItem::getRequestNumber, (Object)purchaseRequestHeadPage.getRequestNumber());
                updateWrapper.and(q -> ((LambdaUpdateWrapper)((LambdaUpdateWrapper)q.isNull(PurchaseRequestItem::getTacticsObject)).or()).eq(PurchaseRequestItem::getTacticsObject, (Object)""));
                updateWrapper.in(PurchaseRequestItem::getItemStatus, new Object[]{PurchaseRequestStatusItemEnum.APPROVED.getValue(), PurchaseRequestStatusItemEnum.SEND_BACK.getValue()});
                updateWrapper.eq(BaseEntity::getElsAccount, (Object)purchaseRequestHeadPage.getElsAccount());
                updateWrapper.set(PurchaseRequestItem::getTacticsObject, (Object)elsTacticsHead.getTacticsObject());
                if ("sumit".equals(elsTacticsHead.getTacticsObject())) {
                    LoginUser loginUser = SysUtil.getLoginUser();
                    updateWrapper.set(PurchaseRequestItem::getTacticsEntity, (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                } else {
                    updateWrapper.set(PurchaseRequestItem::getTacticsEntity, (Object)elsTacticsHead.getTacticsEntity());
                }
                if (!CollectionUtils.isEmpty(elsTacticsItems)) {
                    String sql = "SELECT a.id FROM ( SELECT id FROM purchase_request_item WHERE 1 = 1 ";
                    for (ElsTacticsItemDTO elsTacticsItem : elsTacticsItems) {
                        String rightBracket;
                        String leftBracket = elsTacticsItem.getLeftBracket() == null ? "" : elsTacticsItem.getLeftBracket();
                        String string = rightBracket = elsTacticsItem.getRightBracket() == null ? "" : elsTacticsItem.getRightBracket();
                        if ("like".equals(elsTacticsItem.getLogic())) {
                            sql = sql + elsTacticsItem.getConnector() + " " + leftBracket + elsTacticsItem.getPropertyCode() + " " + elsTacticsItem.getLogic() + " '%" + elsTacticsItem.getPropertyValue() + "%' " + rightBracket;
                            continue;
                        }
                        sql = sql + elsTacticsItem.getConnector() + " " + leftBracket + elsTacticsItem.getPropertyCode() + " " + elsTacticsItem.getLogic() + " '" + elsTacticsItem.getPropertyValue() + "' " + rightBracket;
                    }
                    sql = sql + ")a";
                    updateWrapper.inSql(BaseEntity::getId, sql);
                }
                updateWrapper.set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                this.update((Wrapper)updateWrapper);
            }
        }
    }

    @Override
    public void updateStatus(List<PurchaseRequestItem> purchaseRequestItemList, String status) {
        List courseIds = purchaseRequestItemList.parallelStream().map(map -> map.getRequestNumber() + "_" + map.getItemNumber()).collect(Collectors.toList());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().set(PurchaseRequestItem::getItemStatus, (Object)status);
        updateWrapper.in((Object)"concat(request_number,'_',item_number)", courseIds);
        updateWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    @SrmTransaction
    public void updateItem(PurchaseRequestItem requestItem) {
        PurchaseRequestItem item = new PurchaseRequestItem();
        BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)item));
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(StrUtil.isNotBlank((CharSequence)requestItem.getTacticsEntity()), PurchaseRequestItem::getTacticsEntity, (Object)requestItem.getTacticsEntity()).set(StrUtil.isNotBlank((CharSequence)requestItem.getTacticsObject()), PurchaseRequestItem::getTacticsObject, (Object)requestItem.getTacticsObject());
        wrapper.eq(BaseEntity::getId, (Object)requestItem.getId());
        ((PurchaseRequestItemMapper)this.baseMapper).update(null, (Wrapper)wrapper);
        LoginUser loginUser = SysUtil.getLoginUser();
        ElsBusinessTransferHisDTO elsBusinessTransferHis = requestItem.getElsBusinessTransferHis();
        elsBusinessTransferHis.setTransferBy(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        elsBusinessTransferHis.setTransferTime(new Date());
        this.elsBusinessTransferHisLocalRpcService.add(requestItem.getElsBusinessTransferHis());
    }

    @Override
    @SrmTransaction
    public void returnItem(PurchaseRequestItem head) {
        this.updateStatus(Arrays.asList(head), PurchaseRequestStatusItemEnum.SEND_BACK.getValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        ElsBusinessTransferHisDTO elsBusinessTransferHis = head.getElsBusinessTransferHis();
        elsBusinessTransferHis.setTransferBy(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        elsBusinessTransferHis.setTransferTime(new Date());
        this.elsBusinessTransferHisLocalRpcService.add(head.getElsBusinessTransferHis());
    }

    @Override
    public boolean queryPermissionById(String id) {
        PurchaseRequestItem byId = (PurchaseRequestItem)((Object)this.getById((Serializable)((Object)id)));
        if (StringUtils.isEmpty((CharSequence)byId.getTacticsEntity())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u91c7\u8d2d\u7533\u8bf7\u53f7:" + byId.getRequestNumber() + "\u91c7\u8d2d\u7533\u8bf7\u884c\u53f7:" + byId.getItemNumber() + "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u534f\u52a9\u8f6c\u529e\u6216\u9000\u56de")));
        }
        String tacticsObject = byId.getTacticsObject();
        if ("role".equals(tacticsObject)) {
            String tacticsEntity = byId.getTacticsEntity();
            if (tacticsEntity.contains("_")) {
                tacticsEntity = tacticsEntity.split("_")[0];
            }
            List<ElsSubAccountDTO> accountListByRolesCode = this.inquiryInvokeSubaccountRpcService.getAccountListByRolesCode(tacticsEntity);
            List subList = accountListByRolesCode.stream().map(item -> item.getSubAccount() + "_" + item.getRealname()).distinct().collect(Collectors.toList());
            String loginSubAndName = this.getLoginSubAndName();
            return subList.contains(loginSubAndName);
        }
        if ("group".equals(tacticsObject)) {
            List<SubAccountOrgDTO> accountOrgMsg;
            String id1 = SysUtil.getLoginUser().getId();
            String tacticsEntity = byId.getTacticsEntity();
            if (tacticsEntity.contains("_")) {
                tacticsEntity = tacticsEntity.split("_")[0];
            }
            if (CollectionUtils.isEmpty(accountOrgMsg = this.inquiryInvokeSubaccountRpcService.getAccountOrgMsg(id1, ""))) {
                return false;
            }
            List collect = accountOrgMsg.stream().map(SubAccountOrgDTO::getOrgCode).distinct().collect(Collectors.toList());
            return collect.contains(tacticsEntity);
        }
        if ("person".equals(tacticsObject)) {
            String loginSubAndName = this.getLoginSubAndName();
            return loginSubAndName.equals(byId.getTacticsEntity());
        }
        return false;
    }

    @Override
    @SrmTransaction
    public void returnSample(PurchaseRequestItem head) {
        this.updateStatus(Arrays.asList(head), PurchaseRequestStatusItemEnum.SEND_BACK.getValue());
        this.purchaseRequestItemSelfService.updateSampleItem(head.getSourceItemId());
    }

    @Override
    @SrmTransaction
    public void updateStatusById(List<String> idList, String status) {
        if (CollectionUtil.isNotEmpty(idList)) {
            ArrayList<PurchaseRequestItem> itemList = new ArrayList<PurchaseRequestItem>();
            for (String id : idList) {
                PurchaseRequestItem item = new PurchaseRequestItem();
                item.setId(id);
                item.setItemStatus(status);
                itemList.add(item);
            }
            this.updateBatchById(itemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<PurchaseOrderHeadDTO> createOrder(PurchaseRequestHeadVO requestToOrderHeadVO) {
        ArrayList<RequestMatchInfomationDTO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationDTO>();
        List<PurchaseRequestItem> requestItemList = requestToOrderHeadVO.getPurchaseRequestItemList();
        List ids = requestItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        PurchaseRequestItemService purchaseRequestItemService = (PurchaseRequestItemService)SpringContextUtils.getBean(PurchaseRequestItemService.class);
        List dbPurchaseRequestItems = purchaseRequestItemService.listByIds(ids);
        Assert.notEmpty((Collection)dbPurchaseRequestItems, (String)I18nUtil.translate((String)"i18n_alert_HemhxuiFjWFtHWVXVABSsKW_221943", (String)"\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u9009\u62e9\u7684\u6570\u636e\u8bb0\u5f55,\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5!"));
        Map requestItemByNumber = dbPurchaseRequestItems.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        for (PurchaseRequestItem item : requestItemList) {
            BigDecimal toOrderQuantity;
            PurchaseRequestItem dbRequestItem = (PurchaseRequestItem)((Object)requestItemByNumber.get(item.getId()));
            if (dbRequestItem == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVyWWWWWWnRUVEyWWWWWWKHexMKWVXVABSsKW_43435b50", (String)"\u91c7\u8d2d\u7533\u8bf7\u53f7[${0}]\u91c7\u8d2d\u7533\u8bf7\u884c\u53f7[${1}]\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5!", (String[])new String[]{item.getRequestNumber(), item.getItemNumber()}));
            }
            BigDecimal bigDecimal = toOrderQuantity = dbRequestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : dbRequestItem.getToOrderQuantity();
            if (toOrderQuantity.compareTo(dbRequestItem.getQuantity()) >= 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_TVtWWWWWWEyWWWWWWjIsItWRlTXUTVWRW_fddab5f6", (String)("\u9700\u6c42\u5355[" + item.getRequestNumber() + "]\u884c\u53f7[" + item.getItemNumber() + "]\u7684\u5df2\u8f6c\u8ba2\u5355\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e\u9700\u6c42\u6570\u91cf!"), (String[])new String[]{item.getRequestNumber(), item.getItemNumber()}));
            }
            RequestMatchInfomationDTO requestMatchInfomationVO = new RequestMatchInfomationDTO();
            BeanUtils.copyProperties((Object)((Object)item), (Object)requestMatchInfomationVO);
            requestMatchInfomationVO.setToElsAccount(item.getExpectSupplierEls());
            requestMatchInfomationVO.setSupplierName(item.getExpectSupplierName());
            requestMatchInfomationVO.setToOrderQuantity(item.getQuantity());
            requestMatchInfomationVO.setRequireDate(item.getDeliveryDate());
            if ("mall".equals(item.getSourceType())) {
                requestMatchInfomationVO.setSourceType(OrderSourceTypeEnum.SHOP_PURCHASE_REQUEST.getValue());
            } else {
                requestMatchInfomationVO.setSourceType(OrderSourceTypeEnum.SAMPLE_APPLICATION.getValue());
            }
            requestMatchInfomationVO.setRequestItemId(item.getId());
            requestMatchInfomationVO.setRequestItemNumber(item.getItemNumber());
            requestMatchInfomationVOList.add(requestMatchInfomationVO);
        }
        List<PurchaseOrderHeadDTO> msg = this.sampleToCreateOrder(requestToOrderHeadVO, requestMatchInfomationVOList);
        ArrayList<PurchaseRequestItem> updateRequestItemList = new ArrayList<PurchaseRequestItem>();
        for (PurchaseRequestItem item : requestItemList) {
            PurchaseRequestItem updateItem = new PurchaseRequestItem();
            updateItem.setId(item.getId());
            updateItem.setItemStatus(PurchaseRequestStatusItemEnum.ORDER_ALL_TRANSFER.getValue());
            updateItem.setToOrderQuantity(item.getQuantity());
            updateRequestItemList.add(updateItem);
        }
        if (CollectionUtil.isNotEmpty(updateRequestItemList)) {
            purchaseRequestItemService.updateBatchById(updateRequestItemList);
        }
        return msg;
    }

    private void doRelationData(List<PurchaseOrderItemDTO> orderItem) {
        ArrayList<PurchaseOrderRequestInformation> orderRequestInformations = new ArrayList<PurchaseOrderRequestInformation>();
        BigDecimal toOrderSumQuantity = orderItem.stream().map(PurchaseOrderItemDTO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (PurchaseOrderItemDTO orderItemDTO : orderItem) {
            if (BigDecimal.ZERO.compareTo(toOrderSumQuantity) >= 0) break;
            BigDecimal toOrderQuantity = orderItemDTO.getQuantity() == null ? BigDecimal.ZERO : orderItemDTO.getQuantity();
            BigDecimal remainToOrderQuantity = orderItemDTO.getQuantity().subtract(toOrderQuantity);
            BigDecimal tempToOrderQuantity = toOrderSumQuantity.subtract(remainToOrderQuantity);
            PurchaseOrderRequestInformation requestInformation = new PurchaseOrderRequestInformation();
            if (BigDecimal.ZERO.compareTo(tempToOrderQuantity) > 0) {
                requestInformation.setToOrderQuantity(toOrderSumQuantity);
            } else if (BigDecimal.ZERO.compareTo(tempToOrderQuantity) <= 0) {
                requestInformation.setToOrderQuantity(remainToOrderQuantity);
            }
            toOrderSumQuantity = tempToOrderQuantity;
            requestInformation.setId(IdWorker.getIdStr());
            requestInformation.setElsAccount(orderItemDTO.getElsAccount());
            requestInformation.setOrderHeadId(orderItemDTO.getHeadId());
            requestInformation.setOrderItemId(orderItemDTO.getId());
            requestInformation.setRequestHeadId(orderItemDTO.getSourceId());
            requestInformation.setRequestItemId(orderItemDTO.getSourceItemId());
            requestInformation.setRelaseOrderQuantity(BigDecimal.ZERO);
            requestInformation.setRequestQuantity(orderItemDTO.getQuantity());
            SysUtil.setSysParam((BaseEntity)requestInformation, (BaseDTO)orderItemDTO);
            orderRequestInformations.add(requestInformation);
        }
        this.purchaseOrderRequestInformationService.saveBatch(orderRequestInformations);
    }

    public List<PurchaseOrderHeadDTO> sampleToCreateOrder(PurchaseRequestHeadVO requestToOrderHeadVO, List<RequestMatchInfomationDTO> requestMatchInfomationVOList) {
        List<PurchaseOrderHeadDTO> msg = null;
        ArrayList<PurchaseOrderHeadDTO> purchaseOrderHeadVOList = new ArrayList<PurchaseOrderHeadDTO>();
        Assert.notEmpty(requestMatchInfomationVOList, (String)I18nUtil.translate((String)"i18n_alert_TVsItjcxOLVW_b97d5a4c", (String)"\u9700\u6c42\u8f6c\u8ba2\u5355\u7684\u884c\u4e0d\u80fd\u4e3a\u7a7a!"));
        Map<String, List<RequestMatchInfomationDTO>> requestMatchInfomationToElsMap = requestMatchInfomationVOList.stream().collect(Collectors.groupingBy(RequestMatchInfomationDTO::getToElsAccount));
        Set<String> keys = requestMatchInfomationToElsMap.keySet();
        for (String key : keys) {
            List<RequestMatchInfomationDTO> RequestMatchInfomationDTOS = requestMatchInfomationToElsMap.get(key);
            HashMap orgRequestInfoMap = new HashMap();
            for (RequestMatchInfomationDTO item2 : RequestMatchInfomationDTOS) {
                List<RequestMatchInfomationDTO> RequestMatchInfomationDTOs;
                String itemKey = item2.getPurchaseOrg() + "_" + item2.getPurchaseGroup() + "_" + item2.getCompany() + "_" + item2.getCurrency();
                if (orgRequestInfoMap.containsKey(itemKey)) {
                    RequestMatchInfomationDTOs = (List)orgRequestInfoMap.get(itemKey);
                    RequestMatchInfomationDTOs.add(item2);
                    continue;
                }
                RequestMatchInfomationDTOs = new ArrayList();
                RequestMatchInfomationDTOs.add(item2);
                orgRequestInfoMap.put(itemKey, RequestMatchInfomationDTOs);
            }
            Set groupAndOrgkeys = orgRequestInfoMap.keySet();
            ArrayList<PurchaseRequestItem> requestItemList = new ArrayList<PurchaseRequestItem>();
            for (String key1 : groupAndOrgkeys) {
                List RequestMatchInfomationDTOS1 = (List)orgRequestInfoMap.get(key1);
                PurchaseOrderHeadDTO purchaseOrderHead = new PurchaseOrderHeadDTO();
                ArrayList<PurchaseOrderItemDTO> purchaseOrderItemList = new ArrayList<PurchaseOrderItemDTO>();
                ArrayList purchaseOrderDeliveryPlanList = new ArrayList();
                int i = 1;
                String orderHeadId = IdWorker.getIdStr();
                for (RequestMatchInfomationDTO RequestMatchInfomationDTO2 : RequestMatchInfomationDTOS1) {
                    PurchaseOrderItemDTO purchaseOrderItem = new PurchaseOrderItemDTO();
                    PurchaseRequestItem requestItem = new PurchaseRequestItem();
                    PurchaseMaterialHeadDTO materialHeadDTO = this.purchaseMaterialHeadRpcService.getMaterialHeadByNumber(RequestMatchInfomationDTO2.getMaterialNumber());
                    purchaseOrderItem.setItemNumber("" + i++);
                    purchaseOrderItem.setId(IdWorker.getIdStr());
                    purchaseOrderItem.setHeadId(orderHeadId);
                    purchaseOrderItem.setMaterialId(materialHeadDTO.getId());
                    purchaseOrderItem.setMaterialName(materialHeadDTO.getMaterialName());
                    purchaseOrderItem.setMaterialGroup(materialHeadDTO.getMaterialGroup());
                    purchaseOrderItem.setMaterialGroupName(materialHeadDTO.getMaterialGroupName());
                    purchaseOrderItem.setMaterialNumber(materialHeadDTO.getMaterialNumber());
                    purchaseOrderItem.setCateCode(materialHeadDTO.getCateCode());
                    purchaseOrderItem.setCateName(materialHeadDTO.getCateName());
                    purchaseOrderItem.setMaterialDesc(materialHeadDTO.getMaterialDesc());
                    purchaseOrderItem.setMaterialSpec(materialHeadDTO.getMaterialSpec());
                    purchaseOrderItem.setQuantity(RequestMatchInfomationDTO2.getToOrderQuantity());
                    purchaseOrderItem.setPrice(RequestMatchInfomationDTO2.getPrice());
                    purchaseOrderItem.setNetPrice(RequestMatchInfomationDTO2.getNetPrice());
                    purchaseOrderItem.setTaxRate(RequestMatchInfomationDTO2.getTaxRate());
                    purchaseOrderItem.setTaxCode(RequestMatchInfomationDTO2.getTaxCode());
                    purchaseOrderItem.setTaxAmount(purchaseOrderItem.getQuantity().multiply(purchaseOrderItem.getPrice()));
                    if (StringUtils.isNotEmpty((CharSequence)purchaseOrderItem.getTaxRate()) && !"".equals(purchaseOrderItem.getTaxRate())) {
                        BigDecimal temp = BigDecimal.ONE.add(new BigDecimal(purchaseOrderItem.getTaxRate()).multiply(new BigDecimal("0.01")));
                        purchaseOrderItem.setNetAmount(purchaseOrderItem.getTaxAmount().divide(temp, 4, 4));
                    } else {
                        purchaseOrderItem.setNetAmount(BigDecimal.ZERO);
                    }
                    purchaseOrderItem.setRequireDate(RequestMatchInfomationDTO2.getRequireDate());
                    purchaseOrderItem.setCurrency(RequestMatchInfomationDTO2.getCurrency());
                    purchaseOrderItem.setReceiveQuantity(BigDecimal.ZERO);
                    purchaseOrderItem.setOnWayQuantity(BigDecimal.ZERO);
                    purchaseOrderItem.setDeliveryQuantity(BigDecimal.ZERO);
                    purchaseOrderItem.setClose(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
                    purchaseOrderItem.setFreeze(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
                    purchaseOrderItem.setItemStatus(OrderItemStatusEnum.UN_CONFIRM.getValue());
                    purchaseOrderItem.setSendStatus(OrderItemSendStatusEnum.NO_PUBLISH.getValue());
                    purchaseOrderItem.setJit(RequestMatchInfomationDTO2.getJit());
                    purchaseOrderItem.setDeleteOrder(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
                    purchaseOrderItem.setFactory(RequestMatchInfomationDTO2.getFactory());
                    purchaseOrderItem.setReturned(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
                    purchaseOrderItem.setStorageLocation(RequestMatchInfomationDTO2.getStorageLocation());
                    if (OrderSourceTypeEnum.SHOP_PURCHASE_REQUEST.getValue().equals(RequestMatchInfomationDTO2.getSourceType())) {
                        purchaseOrderItem.setSourceType(OrderSourceTypeEnum.SHOP_PURCHASE_REQUEST.getValue());
                    } else {
                        purchaseOrderItem.setSourceType(OrderSourceTypeEnum.SAMPLE_APPLICATION.getValue());
                    }
                    purchaseOrderItem.setSourceNumber(RequestMatchInfomationDTO2.getRequestNumber());
                    purchaseOrderItem.setSourceItemNumber(RequestMatchInfomationDTO2.getRequestItemNumber());
                    purchaseOrderItem.setSourceId(RequestMatchInfomationDTO2.getSourceId());
                    purchaseOrderItem.setSourceItemId(RequestMatchInfomationDTO2.getRequestItemId());
                    purchaseOrderItem.setPurchaseUnit(RequestMatchInfomationDTO2.getPurchaseUnit());
                    purchaseOrderItem.setRequireDate(RequestMatchInfomationDTO2.getRequireDate());
                    List<PurchaseOrderProgressTemplateDistributionDTO> purchaseOrderProgressTemplateDistributionDTO = this.inquiryInvokeOrderRpcService.selectOrderProgressTemplateList(RequestMatchInfomationDTO2.getCateCode(), RequestMatchInfomationDTO2.getToElsAccount(), "");
                    if (CollectionUtil.isNotEmpty(purchaseOrderProgressTemplateDistributionDTO)) {
                        purchaseOrderItem.setOrderProgressTemplateName(purchaseOrderProgressTemplateDistributionDTO.get(0).getProgressTemplateName());
                        purchaseOrderItem.setOrderProgressTemplateNumber(purchaseOrderProgressTemplateDistributionDTO.get(0).getProgressTemplateNumber());
                        purchaseOrderItem.setOrderProgressTemplateId(purchaseOrderProgressTemplateDistributionDTO.get(0).getHeadId());
                    } else {
                        purchaseOrderItem.setOrderProgressTemplateName("");
                        purchaseOrderItem.setOrderProgressTemplateNumber("");
                        purchaseOrderItem.setOrderProgressTemplateId("");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)purchaseOrderItem.getMaterialNumber())) {
                        purchaseOrderItem.setMaterialGroup(RequestMatchInfomationDTO2.getMaterialGroup());
                        purchaseOrderItem.setJit("4");
                    }
                    requestItem.setRequestNumber(RequestMatchInfomationDTO2.getRequestNumber());
                    requestItem.setItemNumber(RequestMatchInfomationDTO2.getRequestItemNumber());
                    requestItem.setId(RequestMatchInfomationDTO2.getRequestItemId());
                    requestItemList.add(requestItem);
                    purchaseOrderItemList.add(purchaseOrderItem);
                }
                this.doRelationData(purchaseOrderItemList);
                purchaseOrderHead.setId(orderHeadId);
                purchaseOrderHead.setSupplierName(((RequestMatchInfomationDTO)RequestMatchInfomationDTOS1.get(0)).getSupplierName());
                purchaseOrderHead.setToElsAccount(((RequestMatchInfomationDTO)RequestMatchInfomationDTOS1.get(0)).getToElsAccount());
                purchaseOrderHead.setPurchaseGroup(((RequestMatchInfomationDTO)RequestMatchInfomationDTOS1.get(0)).getPurchaseGroup());
                purchaseOrderHead.setPurchaseOrg(((RequestMatchInfomationDTO)RequestMatchInfomationDTOS1.get(0)).getPurchaseOrg());
                purchaseOrderHead.setCompany(((RequestMatchInfomationDTO)RequestMatchInfomationDTOS1.get(0)).getCompany());
                purchaseOrderHead.setCurrency(((RequestMatchInfomationDTO)RequestMatchInfomationDTOS1.get(0)).getCurrency());
                purchaseOrderHead.setTemplateName(requestToOrderHeadVO.getTemplateName());
                purchaseOrderHead.setTemplateNumber(requestToOrderHeadVO.getTemplateNumber());
                purchaseOrderHead.setTemplateVersion(requestToOrderHeadVO.getTemplateVersion());
                purchaseOrderHead.setTemplateAccount(requestToOrderHeadVO.getTemplateAccount());
                if ("mall".equals(requestToOrderHeadVO.getPurchaseRequestItemList().get(0).getSourceType())) {
                    purchaseOrderHead.setSourceType(OrderSourceTypeEnum.SHOP_PURCHASE_REQUEST.getValue());
                } else {
                    purchaseOrderHead.setSourceType(OrderSourceTypeEnum.SAMPLE_APPLICATION.getValue());
                }
                purchaseOrderHead.setBusAccount(TenantContext.getTenant());
                purchaseOrderHead.setPurchaseOrderItemList(purchaseOrderItemList);
                purchaseOrderHead.setTotalNetAmount(purchaseOrderItemList.stream().map(PurchaseOrderItemDTO::getNetAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                purchaseOrderHead.setTotalTaxAmount(purchaseOrderItemList.stream().map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                purchaseOrderHeadVOList.add(purchaseOrderHead);
            }
            msg = this.inquiryInvokeOrderRpcService.requestToCreateOrder(purchaseOrderHeadVOList);
            PurchaseRequestHeadService requestHeadService = (PurchaseRequestHeadService)SpringContextUtils.getBean(PurchaseRequestHeadService.class);
            requestHeadService.syncRequestToOrderQuantity(requestItemList);
            requestHeadService.syncRequestatus(requestItemList);
            List<String> sampleItemList = requestToOrderHeadVO.getPurchaseRequestItemList().stream().filter(item -> "sample".equals(item.getSourceType())).map(PurchaseRequestItem::getSourceItemId).collect(Collectors.toList());
            if (sampleItemList.size() <= 0) continue;
            this.inquiryInvokeOtherService.updateOrderStatusToSample(sampleItemList);
        }
        return msg;
    }

    @Override
    public void replenishMaterial(String id, String materialNumber, String materialDesc, String materialGroup, String materialSpec) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(PurchaseRequestItem::getMaterialNumber, (Object)materialNumber)).set(PurchaseRequestItem::getMaterialDesc, (Object)materialDesc)).set(PurchaseRequestItem::getMaterialGroup, (Object)materialGroup)).set(PurchaseRequestItem::getMaterialSpec, (Object)materialSpec)).eq(BaseEntity::getId, (Object)id));
    }

    @Override
    public void sendPoolMsg(List<PurchaseRequestHead> headList, List<PurchaseRequestItem> purchaseRequestItemList, String opt) {
        if ("transfer".equals(opt)) {
            purchaseRequestItemList.forEach(item -> super.sendMessage(TenantContext.getTenant(), "demandPool", opt, item.getId(), "requestItemBusDataServiceImpl", Arrays.asList(item.getElsAccount())));
        } else if ("refund".equals(opt)) {
            for (PurchaseRequestHead purchaseRequestHead : headList) {
                super.sendMessage(TenantContext.getTenant(), "demandPool", opt, purchaseRequestHead.getId(), "requestItemBusDataServiceImpl", Arrays.asList(purchaseRequestHead.getElsAccount()));
            }
        }
    }

    @Override
    public Boolean saveBatchOfSample(List<PurchaseRequestItem> itemList) {
        itemList.forEach(item -> this.computeQuantity((PurchaseRequestItem)((Object)item)));
        return this.saveBatch(itemList);
    }

    private void computeQuantity(PurchaseRequestItem entity) {
        BigDecimal repertoryQuantity = entity.getRepertoryQuantity();
        String repertoryUnit = entity.getRepertoryUnit();
        List<PurchaseMaterialUnitDTO> units = this.purchaseMaterialHeadLocalRpcService.selectByMaterialNumber(entity.getMaterialNumber());
        for (PurchaseMaterialUnitDTO unitDTO : units) {
            String ObjectUnit = unitDTO.getObjectUnit();
            if (!PURCHASE_UNIT_TYPE.equals(unitDTO.getType()) || ObjectUnit == null) continue;
            entity.setPurchaseUnit(ObjectUnit);
            break;
        }
        PurchaseMaterialUnitDTO repertoryUnitDto = this.getRePertoryUnit(units, repertoryUnit);
        for (PurchaseMaterialUnitDTO unitDTO : units) {
            if (!unitDTO.getBasicUnit().equals(repertoryUnitDto.getBasicUnit()) || !unitDTO.getObjectUnit().equals(entity.getPurchaseUnit())) continue;
            BigDecimal multiply = repertoryQuantity.multiply(repertoryUnitDto.getBasicAmount()).divide(repertoryUnitDto.getObjectAmount(), 6, RoundingMode.HALF_UP).divide(unitDTO.getBasicAmount(), 6, RoundingMode.HALF_UP).multiply(unitDTO.getObjectAmount());
            entity.setQuantity(multiply);
        }
    }

    private PurchaseMaterialUnitDTO getRePertoryUnit(List<PurchaseMaterialUnitDTO> units, String repertoryUnit) {
        for (PurchaseMaterialUnitDTO unitDTO : units) {
            String ObjectUnit = unitDTO.getObjectUnit();
            if (!REPERTORY_UNIT_TYPE.equals(unitDTO.getType()) || ObjectUnit == null || !ObjectUnit.equals(repertoryUnit)) continue;
            return unitDTO;
        }
        return new PurchaseMaterialUnitDTO();
    }

    @Override
    public List<PurchaseRequestItem> mergeRequest(List<PurchaseRequestItem> dbItemList) {
        List hasMaterials;
        LoginUser loginUser = SysUtil.getLoginUser();
        JSONObject companySet = loginUser.getCompanySet() == null ? new JSONObject() : loginUser.getCompanySet();
        boolean bool = REPERTORY_UNIT_TYPE.equals(companySet.getString("mergeRequestToSourcing"));
        if (!bool) {
            return dbItemList;
        }
        ArrayList<PurchaseRequestItem> newItems = new ArrayList<PurchaseRequestItem>();
        List noMaterials = dbItemList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getMaterialNumber())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(noMaterials)) {
            newItems.addAll(noMaterials);
        }
        if (CollectionUtils.isEmpty(hasMaterials = dbItemList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getMaterialNumber())).collect(Collectors.toList()))) {
            return newItems;
        }
        Map requestItemMap = hasMaterials.stream().collect(Collectors.toMap(item -> {
            String materialNumber = item.getMaterialNumber() == null ? "" : item.getMaterialNumber();
            String purchaseOrg = item.getPurchaseOrg() == null ? "" : item.getPurchaseOrg();
            String company = item.getCompany() == null ? "" : item.getCompany();
            String factory = item.getFactory() == null ? "" : item.getFactory();
            String storageLocation = item.getStorageLocation() == null ? "" : item.getStorageLocation();
            return materialNumber + "_" + purchaseOrg + "_" + company + "_" + factory + "_" + storageLocation;
        }, Function.identity(), (newVal, oldVal) -> {
            BigDecimal oldQuantity = oldVal.getQuantity() == null ? BigDecimal.ZERO : oldVal.getQuantity();
            BigDecimal newQuantity = newVal.getQuantity() == null ? BigDecimal.ZERO : newVal.getQuantity();
            oldVal.setQuantity(oldQuantity.add(newQuantity));
            Date newApplyDate = newVal.getApplyDate();
            Date oldApplyDate = oldVal.getApplyDate();
            oldVal.setApplyDate(DateUtil.compare((Date)newApplyDate, (Date)oldApplyDate) > 0 ? oldApplyDate : newApplyDate);
            Date deliveryDate = DateUtil.compare((Date)newVal.getDeliveryDate(), (Date)oldVal.getDeliveryDate()) > 0 ? oldVal.getDeliveryDate() : newVal.getDeliveryDate();
            oldVal.setDeliveryDate(deliveryDate);
            oldVal.setRequestNumber(oldVal.getRequestNumber() + "," + newVal.getRequestNumber());
            oldVal.setItemNumber(oldVal.getItemNumber() + "," + newVal.getItemNumber());
            oldVal.setDocumentId(this.stitchingString(oldVal.getDocumentId(), newVal.getDocumentId()));
            oldVal.setDocumentItemId(this.stitchingString(oldVal.getDocumentItemId(), newVal.getDocumentItemId()));
            oldVal.setId(this.stitchingString(oldVal.getId(), newVal.getId()));
            oldVal.setHeadId(this.stitchingString(oldVal.getHeadId(), newVal.getHeadId()));
            return oldVal;
        }));
        newItems.addAll(new ArrayList(requestItemMap.values()));
        return newItems;
    }

    private String stitchingString(String front, String later) {
        if (StringUtils.isNotBlank((CharSequence)front) && StringUtils.isNotBlank((CharSequence)later)) {
            return front + "," + later;
        }
        if (StringUtils.isBlank((CharSequence)front) && StringUtils.isBlank((CharSequence)later)) {
            return "";
        }
        return StringUtils.isNotBlank((CharSequence)front) ? front : later;
    }

    @Override
    public void deleteByMainId(String id) {
        ((PurchaseRequestItemMapper)this.baseMapper).deleteByMainId(id);
    }

    @Override
    public void deleteByHeadIds(List<String> headIds) {
        ((PurchaseRequestItemMapper)this.baseMapper).deleteByMainIds(headIds);
    }

    @Override
    public boolean queryPermissionByIds(String ids) {
        String[] idArray = ids.split(",");
        for (int i = 0; i < idArray.length; ++i) {
            boolean result = this.queryPermissionById(idArray[i]);
            if (result) continue;
            PurchaseRequestItem requestItem = (PurchaseRequestItem)((Object)this.getById((Serializable)((Object)idArray[i])));
            throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u91c7\u8d2d\u7533\u8bf7\u53f7:" + requestItem.getRequestNumber() + "\u91c7\u8d2d\u7533\u8bf7\u884c\u53f7:" + requestItem.getItemNumber() + "\u5f53\u524d\u8d26\u53f7\u65e0\u64cd\u4f5c\u6743\u9650\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458")));
        }
        return true;
    }
}

