/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.entity.SaleEbiddingItemHis;
import com.els.modules.ebidding.enumerate.EbiddingItemStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingShowEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingConfirmService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingItemHisService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.vo.SaleEbiddingConfirmVO;
import com.els.modules.ebidding.vo.SaleEbiddingHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ebidding/saleEbiddingHead"})
@Api(tags={"\u9500\u552e\u7ade\u4ef7\u5934"})
public class SaleEbiddingHeadController
extends BaseController<SaleEbiddingHead, SaleEbiddingHeadService> {
    @Autowired
    private SaleEbiddingItemService saleEbiddingItemService;
    @Autowired
    private SaleEbiddingItemHisService saleEbiddingItemHisService;
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private SaleEbiddingConfirmService saleEbiddingConfirmService;
    @Autowired
    private RedisUtil redis;
    private final long LOCK_TIME_OUT = 100000L;
    private final long LOCK_WAIT_TIME = 900L;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"ebidding#saleEbiddingHead:list"})
    public Result<?> queryPageList(SaleEbiddingHead saleHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((SaleEbiddingHeadService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"ebidding#saleEbiddingHead:list"})
    public Result<?> queryTabsCount(SaleEbiddingHead saleEbiddingHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        String[] ids = null;
        Map stringMap = req.getParameterMap();
        if (StringUtils.isNotBlank((CharSequence)saleEbiddingHead.getId())) {
            ids = saleEbiddingHead.getId().replace(" ", "").split(",");
            saleEbiddingHead.setId(null);
            stringMap.remove("id");
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleEbiddingHead), (Map)stringMap);
        if (ids != null && ids.length > 0) {
            queryWrapper.in((Object)"id", (Object[])ids);
        }
        queryWrapper.select(new String[]{"ebidding_status", "count(0) as template_version"});
        queryWrapper.groupBy((Object)"ebidding_status");
        List list = ((SaleEbiddingHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleEbiddingHead::getEbiddingStatus, SaleEbiddingHead::getTemplateVersion));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "ebiddingStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmEbiddingStatus", TenantContext.getTenant());
        String[] statuses = new String[]{"1", "3", "4", "5", "9", "8", "7", "12"};
        List<String> statusList = Arrays.asList(statuses);
        for (DictDTO status : srmContractStatus) {
            if (!statusList.contains(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "ebiddingStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"ebidding#saleEbiddingHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)id)));
        SaleEbiddingHeadVO headVO = new SaleEbiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        PurchaseEbiddingSupplier supplier = (PurchaseEbiddingSupplier)((Object)this.purchaseEbiddingSupplierService.getById((Serializable)((Object)headVO.getSupplierListId())));
        if (supplier != null) {
            headVO.setReplyStatus(supplier.getReplyStatus());
        }
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            List<SaleEbiddingItemHis> saleEbiddingItemHisList = this.saleEbiddingItemHisService.queryAcceptDetail(dbHead);
            headVO.setPurchaseEbiddingItemHis(saleEbiddingItemHisList);
        }
        List<SaleEbiddingItem> itemList = this.saleEbiddingItemService.selectByMainId(id);
        headVO.setSaleEbiddingItemList(itemList);
        List<SaleEbiddingConfirmVO> confirmList = this.saleEbiddingConfirmService.selectByMainId(id);
        headVO.setSaleEbiddingConfirmList(confirmList);
        List demandList = this.invokeBaseRpcService.selectSaleAttachmentDemandByMainId(id);
        headVO.setSaleAttachmentDemandList(demandList);
        List attachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        headVO.setSaleAttachmentList(attachmentList);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(value="\u9500\u552e\u7ade\u4ef7\u5934-\u5e94\u6807")
    @ApiOperation(value="\u5e94\u6807", notes="\u5e94\u6807")
    @PostMapping(value={"/acceptResponse"})
    @RequiresPermissions(value={"ebidding#saleEbiddingHead:acceptResponse"})
    @SrmValidated
    public Result<?> acceptResponse(@RequestBody SaleEbiddingHeadVO webVO) {
        String headId = webVO.getId();
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        SaleEbiddingHead dbSaleHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)EbiddingStatusEnum.WAIT_REPLY.getValue().equals(dbSaleHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_APSTdB_625ba16d", (String)"\u5f53\u524d\u65e0\u9700\u5e94\u6807"));
        Assert.isTrue((boolean)dbSaleHead.getEchoEndTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_dByRKIIRWxqdB_49648f43", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5e94\u6807"));
        List demandList = this.invokeBaseRpcService.selectSaleAttachmentDemandByMainId(headId).stream().filter(demand -> "1".equals(demand.getRequired())).filter(demand -> StageTypeEnum.RESPONSE.getValue().equals(demand.getStageType())).collect(Collectors.toList());
        List<SaleAttachmentDTO> saleAttachmentList = webVO.getSaleAttachmentList();
        Map<String, List<SaleAttachmentDTO>> checkMap = saleAttachmentList.stream().filter(attachment -> StrUtil.isNotBlank((CharSequence)attachment.getFileType())).collect(Collectors.groupingBy(SaleAttachmentDTO::getFileType));
        for (Object demand2 : demandList) {
            Assert.isTrue((boolean)checkMap.containsKey(demand2.getFileType()), (String)I18nUtil.translate((String)"i18n_alert_VpYPVXVIdAcjQIW_61f8e1a5", (String)"\u8bf7\u6309\u7167\u8981\u6c42\u4e0a\u4f20\u5bf9\u5e94\u7c7b\u578b\u7684\u6587\u4ef6\uff01"));
        }
        List<SaleEbiddingItem> itemList = webVO.getSaleEbiddingItemList();
        if ("1".equals(dbSaleHead.getSupplierTaxRate())) {
            if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
                Object demand2;
                demand2 = itemList.iterator();
                while (demand2.hasNext()) {
                    SaleEbiddingItem item2;
                    item2.setTaxRate(StrUtil.isBlank((CharSequence)(item2 = (SaleEbiddingItem)((Object)demand2.next())).getTaxRate()) ? webVO.getTaxRate() : item2.getTaxRate());
                    item2.setTaxCode(StrUtil.isBlank((CharSequence)item2.getTaxCode()) ? webVO.getTaxCode() : item2.getTaxCode());
                    Assert.hasText((String)item2.getTaxCode(), (String)I18nUtil.translate((String)"i18n_alert_cVHfoxOLV_76b200bd", (String)"\u884c\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.hasText((String)item2.getTaxRate(), (String)I18nUtil.translate((String)"i18n_alert_cVHfIxOLV_379cc943", (String)"\u884c\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            } else {
                Assert.hasText((String)webVO.getTaxCode(), (String)I18nUtil.translate((String)"i18n_alert_eVHfoxOLV_ffe669a5", (String)"\u5934\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.hasText((String)webVO.getTaxRate(), (String)I18nUtil.translate((String)"i18n_alert_eVHfIxOLV_c0d1322b", (String)"\u5934\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                itemList.forEach(item -> {
                    item.setTaxCode(webVO.getTaxCode());
                    item.setTaxRate(webVO.getTaxRate());
                });
            }
        } else {
            itemList.forEach(item -> {
                item.setTaxCode(null);
                item.setTaxRate(null);
            });
        }
        List<SaleEbiddingConfirmVO> saleEbiddingConfirmList = webVO.getSaleEbiddingConfirmList();
        for (SaleEbiddingConfirmVO confirm : saleEbiddingConfirmList) {
            if (!"1".equals(confirm.getMust())) continue;
            Assert.hasText((String)confirm.getContent(), (String)I18nUtil.translate((String)"i18n_alert_RLdlS_e2d502c9", (String)"\u786e\u8ba4\u9879\u5fc5\u586b"));
        }
        ((SaleEbiddingHeadService)this.service).acceptResponse(webVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u7ade\u4ef7\u5934-\u62d2\u7edd")
    @ApiOperation(value="\u62d2\u7edd", notes="\u62d2\u7edd")
    @GetMapping(value={"/rejectResponse"})
    @RequiresPermissions(value={"ebidding#saleEbiddingHead:reject"})
    public Result<?> rejectResponse(@RequestParam(name="id") String id) {
        SaleEbiddingHead dbSaleHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)EbiddingStatusEnum.WAIT_REPLY.getValue().equals(dbSaleHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_APxqFK_568c05a7", (String)"\u5f53\u524d\u4e0d\u53ef\u62d2\u7edd"));
        ((SaleEbiddingHeadService)this.service).refuseResponse(dbSaleHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u7ade\u4ef7\u5934-\u62a5\u4ef7")
    @ApiOperation(value="\u62a5\u4ef7", notes="\u62a5\u4ef7")
    @PostMapping(value={"/quotePrice"})
    @RequiresPermissions(value={"ebidding#saleEbiddingHead:quotePrice"})
    @SrmValidated
    public Result<?> quotePrice(@RequestBody SaleEbiddingHeadVO headVO) {
        SaleEbiddingHead dbSaleHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)headVO.getId())));
        if (this.redis.tryLockWithTimeout(dbSaleHead.getRelationId(), dbSaleHead.getRelationId(), 61000L, 60L)) {
            try {
                ((SaleEbiddingHeadService)this.service).quotePrice(headVO);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.redis.releaseDistributedLock(dbSaleHead.getRelationId(), dbSaleHead.getRelationId());
            }
        } else {
            throw new ELSBootException("\u5f53\u524d\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u7ade\u4ef7\u5927\u5385\u5934\u884c\u4fe1\u606f\u67e5\u8be2", notes="\u7ade\u4ef7\u5927\u5385\u5934\u884c\u4fe1\u606f\u67e5\u8be2")
    @GetMapping(value={"/queryBidLobbyDetail"})
    @RequiresPermissions(value={"ebidding#saleEbiddingHead:queryById"})
    public Result<?> queryBidLobbyDetail(@RequestParam(name="id") String id) {
        SaleEbiddingHeadVO saleHeadVO = new SaleEbiddingHeadVO();
        SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)saleHeadVO));
        List<SaleEbiddingItem> itemList = this.saleEbiddingItemService.selectByMainId(id);
        saleHeadVO.setSaleEbiddingItemList(itemList);
        saleHeadVO.setServiceTime(new Date());
        return Result.ok((Object)((Object)saleHeadVO));
    }

    @ApiOperation(value="\u82f1\u5f0f\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u4fe1\u606f\u67e5\u8be2", notes="\u82f1\u5f0f\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u4fe1\u606f\u67e5\u8be2")
    @GetMapping(value={"/queryBidLobbyQuote"})
    @RequiresPermissions(value={"ebidding#saleEbiddingHead:queryById"})
    public Result<?> queryBidLobbyQuote(@RequestParam(name="id") String id, @RequestParam(name="itemNumber") String itemNumber) {
        List<Object> saleItemList;
        SaleEbiddingHeadVO saleHeadVO = new SaleEbiddingHeadVO();
        SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)saleHeadVO));
        List<PurchaseEbiddingItem> allList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> item.getItemNumber().equals(itemNumber)).collect(Collectors.toList());
        String supplierShow = dbHead.getSupplierShow() == null ? "" : dbHead.getSupplierShow();
        List<String> statusList = Arrays.asList(EbiddingStatusEnum.NEW.getValue(), EbiddingStatusEnum.WAIT_REPLY.getValue(), EbiddingStatusEnum.BIDDING.getValue(), EbiddingStatusEnum.WAIT_BIDDING.getValue());
        if (supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) || supplierShow.contains(EbiddingShowEnum.NAME.getValue())) {
            saleItemList = SysUtil.copyProperties(allList, SaleEbiddingItem.class);
            for (SaleEbiddingItem saleEbiddingItem : saleItemList) {
                String relationId = saleEbiddingItem.getRelationId();
                saleEbiddingItem.setRelationId(saleEbiddingItem.getId());
                saleEbiddingItem.setId(relationId);
                String toElsAccount = saleEbiddingItem.getToElsAccount();
                saleEbiddingItem.setToElsAccount(saleEbiddingItem.getElsAccount());
                saleEbiddingItem.setElsAccount(toElsAccount);
                if (statusList.contains(dbHead.getEbiddingStatus()) && !supplierShow.contains(EbiddingShowEnum.NAME.getValue())) {
                    saleEbiddingItem.setSupplierName(null);
                }
                if (supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) || this.getTenantId().equals(saleEbiddingItem.getElsAccount())) continue;
                saleEbiddingItem.setPrice(null);
                saleEbiddingItem.setNetPrice(null);
                saleEbiddingItem.setTaxAmount(null);
                saleEbiddingItem.setNetAmount(null);
                saleEbiddingItem.setTotalAmount(null);
                saleEbiddingItem.setNetTotalAmount(null);
            }
        } else {
            saleItemList = this.saleEbiddingItemService.selectByMainId(id).stream().filter(item -> item.getItemNumber().equals(itemNumber)).collect(Collectors.toList());
        }
        if (supplierShow.contains(EbiddingShowEnum.RANK.getValue())) {
            for (SaleEbiddingItem saleEbiddingItem : saleItemList) {
                this.rank(allList, saleEbiddingItem, dbHead.getEbiddingWay(), dbHead.getEbiddingType());
            }
        }
        saleItemList.sort(Comparator.comparing(SaleEbiddingItem::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
        saleHeadVO.setSaleEbiddingItemList(saleItemList);
        saleHeadVO.setServiceTime(new Date());
        return Result.ok((Object)((Object)saleHeadVO));
    }

    private void rank(List<PurchaseEbiddingItem> allList, SaleEbiddingItem saleItem, String ebiddingWay, String ebiddingType) {
        List<PurchaseEbiddingItem> sortList = EbiddingTypeEnum.getEnumByValue(ebiddingType).sort(ebiddingWay, allList);
        for (int i = 0; i < sortList.size(); ++i) {
            if (EbiddingWayEnum.SINGLE.getValue().equals(ebiddingWay)) {
                if (!saleItem.getId().equals(sortList.get(i).getRelationId())) continue;
                int rank = i + 1;
                saleItem.setQuoteRank(rank);
                break;
            }
            if (!saleItem.getElsAccount().equals(sortList.get(i).getToElsAccount())) continue;
            int rank = i + 1;
            saleItem.setQuoteRank(rank);
            break;
        }
    }

    @AutoLog(value="\u9500\u552e\u7ade\u4ef7\u5934-\u7ade\u4ef7\u5927\u5385\u8bbe\u7f6e\u5e45\u5ea6\u4e0a\u9650")
    @ApiOperation(value="\u7ade\u4ef7\u5927\u5385\u8bbe\u7f6e\u5e45\u5ea6\u4e0a\u9650", notes="\u7ade\u4ef7\u5927\u5385\u8bbe\u7f6e\u5e45\u5ea6\u4e0a\u9650")
    @PostMapping(value={"/setUpper"})
    @RequiresPermissions(value={"ebidding#saleEbiddingHead:setUpper"})
    @SrmValidated
    public Result<?> setUpper(@RequestBody SaleEbiddingHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getChangeRangeUpper(), (String)I18nUtil.translate((String)"i18n_alert_BzXWxOLV_1bde1ed7", (String)"\u5e45\u5ea6\u4e0a\u9650\u4e0d\u80fd\u4e3a\u7a7a"));
        SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)headVO.getId())));
        Assert.isTrue((EbiddingStatusEnum.BIDDING.getValue().equals(dbHead.getEbiddingStatus()) || EbiddingStatusEnum.WAIT_BIDDING.getValue().equals(dbHead.getEbiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_RjoOuSOusntFqIGRBzXW_6c2eabad", (String)"\u53ea\u6709\u5f85\u7ade\u4ef7\u6216\u7ade\u4ef7\u4e2d\u7684\u5355\u636e\u53ef\u4ee5\u8bbe\u7f6e\u5e45\u5ea6\u4e0a\u9650"));
        Assert.isTrue((headVO.getChangeRangeUpper().compareTo(dbHead.getChangeRange()) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_BzXWlTfUBzIW_6c25d5b9", (String)"\u5e45\u5ea6\u4e0a\u9650\u5fc5\u987b\u5927\u4e8e\u5e45\u5ea6\u4e0b\u7ebf"));
        dbHead.setChangeRangeUpper(headVO.getChangeRangeUpper());
        ((SaleEbiddingHeadService)this.service).updateById((Object)dbHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u65e5\u5f0f/\u8377\u5f0f-\u63a5\u53d7\u62a5\u4ef7", busModule="\u9500\u552e\u7ade\u4ef7\u5934")
    @ApiOperation(value="\u65e5\u5f0f/\u8377\u5f0f-\u63a5\u53d7\u62a5\u4ef7", notes="\u65e5\u5f0f/\u8377\u5f0f-\u63a5\u53d7\u62a5\u4ef7")
    @GetMapping(value={"/quoteAccept"})
    @RequiresPermissions(value={"ebidding#saleEbiddingHead:acceptResponse"})
    public Result<?> quoteAccept(@RequestParam(value="itemHisId") String itemHisId, BigDecimal bidNumber) throws InterruptedException {
        SaleEbiddingItemHis dbItemHis = ((SaleEbiddingItemHis)((Object)this.saleEbiddingItemHisService.getById((Serializable)((Object)itemHisId)))).setBidNumber(bidNumber);
        SaleEbiddingItem dbItem = (SaleEbiddingItem)((Object)this.saleEbiddingItemService.getById((Serializable)((Object)dbItemHis.getItemId())));
        Assert.isTrue((boolean)EbiddingItemStatusEnum.BIDDING.getValue().equals(dbItem.getItemStatus()), (String)I18nUtil.translate((String)"i18n_alert_OusncWFnqyl_36ffc64e", (String)"\u7ade\u4ef7\u4e2d\u7684\u884c\u6570\u636e\u624d\u53ef\u63a5\u53d7"));
        SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)dbItemHis.getHeadId())));
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            Assert.isTrue((boolean)new Date().before(dbHead.getEndTime()), (String)I18nUtil.translate((String)"i18n_alert_vVsuIyWxOylSNFKum_f16d567e", (String)"\u672c\u8f6e\u62a5\u4ef7\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u63a5\u53d7\u6216\u8005\u62d2\u7edd\u4ef7\u683c\uff01"));
        }
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            String lockKey = "ebidding_quote_accept";
            try {
                if (this.redis.tryLockWithTimeout(lockKey, dbHead.getRelationId(), 100000L, 900L)) {
                    if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
                        bidNumber = BigDecimal.ONE;
                    }
                    if (bidNumber == null || bidNumber.compareTo(BigDecimal.ZERO) == 0) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBWRxOLVSNL0_3f48889b", (String)"\u6295\u6807\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3a0\uff01"));
                    }
                    if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) && "0".equals(dbHead.getAllowModifyQuantity()) && bidNumber.compareTo(dbItem.getRequireQuantity()) != 0) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_OutxiTcrBnWReBWRdrATVWRIR_3c58466c", (String)"\u7ade\u4ef7\u5355\u4e0d\u5141\u8bb8\u4fee\u6539\u6807\u7684\u6570\u91cf\uff0c\u6295\u6807\u6570\u91cf\u5e94\u8be5\u8ddf\u9700\u6c42\u6570\u91cf\u4e00\u81f4\uff01"));
                    }
                    dbItemHis = ((SaleEbiddingItemHis)((Object)this.saleEbiddingItemHisService.getById((Serializable)((Object)itemHisId)))).setBidNumber(bidNumber);
                    dbItem = (SaleEbiddingItem)((Object)this.saleEbiddingItemService.getById((Serializable)((Object)dbItemHis.getItemId())));
                    dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)dbItemHis.getHeadId())));
                    SaleEbiddingItem quoteItem = new SaleEbiddingItem();
                    BeanUtils.copyProperties((Object)((Object)dbItemHis), (Object)((Object)quoteItem));
                    quoteItem.setId(dbItem.getId());
                    quoteItem.setRelationId(dbItem.getRelationId());
                    quoteItem.setRemainingQuantity(dbItem.getRemainingQuantity());
                    BigDecimal acceptPrice = this.checkPrice(dbHead, dbItem, quoteItem);
                    ((SaleEbiddingHeadService)this.service).quoteAccept(dbHead, dbItemHis, quoteItem, acceptPrice);
                    Result result = this.commonSuccessResult(3);
                    return result;
                }
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_HeiJWVRSKKW_c75d5308", (String)"\u7cfb\u7edf\u6b63\u5fd9\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\uff01"));
            }
            finally {
                this.redis.releaseDistributedLock(lockKey, dbHead.getRelationId());
            }
        }
        SaleEbiddingItem quoteItem = new SaleEbiddingItem();
        BeanUtils.copyProperties((Object)((Object)dbItemHis), (Object)((Object)quoteItem));
        quoteItem.setId(dbItem.getId());
        quoteItem.setRelationId(dbItem.getRelationId());
        BigDecimal acceptPrice = this.checkPrice(dbHead, dbItem, quoteItem);
        ((SaleEbiddingHeadService)this.service).quoteAccept(dbHead, dbItemHis, quoteItem, acceptPrice);
        return this.commonSuccessResult(3);
    }

    private BigDecimal checkPrice(SaleEbiddingHead dbHead, SaleEbiddingItem dbItem, SaleEbiddingItem quoteItem) {
        BigDecimal dbPrice;
        BigDecimal acceptPrice;
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            acceptPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetPrice() : quoteItem.getPrice();
            dbPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? dbItem.getNetPrice() : dbItem.getPrice();
        } else {
            acceptPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetTotalAmount() : quoteItem.getTotalAmount();
            BigDecimal bigDecimal = dbPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? dbItem.getNetTotalAmount() : dbItem.getTotalAmount();
        }
        if (dbPrice != null && dbPrice.compareTo(BigDecimal.ZERO) > 0) {
            boolean flag = EbiddingTypeEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType()) ? acceptPrice.compareTo(dbPrice) > 0 : acceptPrice.compareTo(dbPrice) < 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_IylHBnOuAcjumWxqylmum_96fe5d97", (String)"\u5df2\u63a5\u53d7\u66f4\u7b26\u5408\u7ade\u4ef7\u7c7b\u578b\u7684\u4ef7\u683c\uff0c\u4e0d\u53ef\u63a5\u53d7\u6b64\u4ef7\u683c"));
        }
        return acceptPrice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="\u65e5\u5f0f/\u8377\u5f0f-\u62d2\u7edd\u62a5\u4ef7", busModule="\u9500\u552e\u7ade\u4ef7\u5934")
    @ApiOperation(value="\u65e5\u5f0f/\u8377\u5f0f-\u62d2\u7edd\u62a5\u4ef7", notes="\u65e5\u5f0f/\u8377\u5f0f-\u62d2\u7edd\u62a5\u4ef7")
    @GetMapping(value={"/quoteReject"})
    @RequiresPermissions(value={"ebidding#saleEbiddingHead:reject"})
    public Result<?> quoteReject(@RequestParam(value="itemHisId") String itemHisId) throws InterruptedException {
        block6: {
            SaleEbiddingItemHis dbItemHis = (SaleEbiddingItemHis)((Object)this.saleEbiddingItemHisService.getById((Serializable)((Object)itemHisId)));
            SaleEbiddingItem dbItem = (SaleEbiddingItem)((Object)this.saleEbiddingItemService.getById((Serializable)((Object)dbItemHis.getItemId())));
            Assert.isTrue((boolean)EbiddingItemStatusEnum.BIDDING.getValue().equals(dbItem.getItemStatus()), (String)I18nUtil.translate((String)"i18n_alert_OusncWFnqFK_36ffd7c7", (String)"\u7ade\u4ef7\u4e2d\u7684\u884c\u6570\u636e\u624d\u53ef\u62d2\u7edd"));
            SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)dbItemHis.getHeadId())));
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
                Assert.isTrue((boolean)new Date().before(dbHead.getEndTime()), (String)I18nUtil.translate((String)"i18n_alert_vVsuIyWxOylSNFKum_f16d567e", (String)"\u672c\u8f6e\u62a5\u4ef7\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u63a5\u53d7\u6216\u8005\u62d2\u7edd\u4ef7\u683c\uff01"));
            }
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
                String lockKey = "ebidding_quote_reject";
                try {
                    if (this.redis.tryLockWithTimeout(lockKey, dbHead.getRelationId(), 100000L, 900L)) {
                        SaleEbiddingItem quoteItem = new SaleEbiddingItem();
                        BeanUtils.copyProperties((Object)((Object)dbItemHis), (Object)((Object)quoteItem));
                        quoteItem.setId(dbItem.getId());
                        quoteItem.setRelationId(dbItem.getRelationId());
                        ((SaleEbiddingHeadService)this.service).quoteReject(dbHead, dbItemHis, quoteItem);
                        break block6;
                    }
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_HeiJWVRSKKW_c75d5308", (String)"\u7cfb\u7edf\u6b63\u5fd9\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\uff01"));
                }
                finally {
                    this.redis.releaseDistributedLock(lockKey, dbHead.getRelationId());
                }
            }
            SaleEbiddingItem quoteItem = new SaleEbiddingItem();
            BeanUtils.copyProperties((Object)((Object)dbItemHis), (Object)((Object)quoteItem));
            quoteItem.setId(dbItem.getId());
            quoteItem.setRelationId(dbItem.getRelationId());
            ((SaleEbiddingHeadService)this.service).quoteReject(dbHead, dbItemHis, quoteItem);
        }
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5728\u7ebf\u4f9b\u72b6\u6001", notes="\u8bbe\u7f6e\u5728\u7ebf\u4f9b\u72b6\u6001")
    @GetMapping(value={"/setOnlineAccount"})
    @RequiresPermissions(value={"ebidding#saleEbiddingHead:queryById"})
    public Result<?> setOnlineAccount(@RequestParam(value="headRelationId") String headRelationId) {
        String redisKey = "online:cache:users:" + headRelationId + ":" + TenantContext.getTenant();
        this.redis.del(new String[]{redisKey});
        this.redis.set(redisKey, (Object)TenantContext.getTenant(), 6L);
        return Result.ok();
    }

    @AutoLog(value="\u4ef7\u683c\u63d0\u4ea4", busModule="\u4ef7\u683c\u63d0\u4ea4")
    @ApiOperation(value="\u4ef7\u683c\u63d0\u4ea4", notes="\u4ef7\u683c\u63d0\u4ea4")
    @PostMapping(value={"/priceSubmission"})
    public Result<?> priceSubmission(@RequestBody SaleEbiddingHeadVO headVO) {
        ((SaleEbiddingHeadService)this.service).priceSubmission(headVO);
        return Result.ok();
    }
}

