/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.service.OtherInquiryToEbiddingService;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.ebidding.vo.ToEbiddingVO;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class OtherInquiryToEbiddingServiceImpl
implements OtherInquiryToEbiddingService {
    private static final Logger log = LoggerFactory.getLogger(OtherInquiryToEbiddingServiceImpl.class);
    @Resource
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Resource
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Resource
    private EnquirySupplierListService enquirySupplierListService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Resource
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Resource
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;

    private void checkParam(ToEbiddingVO ebiddingVO) {
        if (StrUtil.isBlank((CharSequence)ebiddingVO.getId())) {
            throw new ELSBootException("id \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)ebiddingVO.getTemplateNumber())) {
            throw new ELSBootException("templateNumber \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseEbiddingHeadVO enquiryToEbidding(ToEbiddingVO ebiddingVO) {
        List<EnquirySupplierList> enquirySupplierList;
        this.checkParam(ebiddingVO);
        PurchaseEnquiryHead enquiryHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)ebiddingVO.getId())));
        if (enquiryHead == null) {
            throw new ELSBootException("id \u4e0d\u5b58\u5728\uff01");
        }
        List<PurchaseEnquiryItem> enquiryItemList = this.purchaseEnquiryItemService.selectByMainId(ebiddingVO.getId());
        Map<String, List<PurchaseEnquiryItem>> itemMap = enquiryItemList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItem::getItemNumber));
        HashMap<String, BigDecimal> targetPriceMap = new HashMap<String, BigDecimal>();
        String quoteType = enquiryHead.getQuoteType();
        BigDecimal startTotalAmount = BigDecimal.ZERO;
        for (String itemNumber : itemMap.keySet()) {
            List<PurchaseEnquiryItem> itemList = itemMap.get(itemNumber);
            BigDecimal quantity = itemList.get(0).getRequireQuantity() == null ? BigDecimal.ONE : itemList.get(0).getRequireQuantity();
            BigDecimal price = null;
            price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? (BigDecimal)itemList.stream().min(Comparator.comparing(PurchaseEnquiryItem::getPrice)).map(PurchaseEnquiryItem::getPrice).orElse(null) : (BigDecimal)itemList.stream().min(Comparator.comparing(PurchaseEnquiryItem::getNetPrice)).map(PurchaseEnquiryItem::getNetPrice).orElse(null);
            if (price == null) {
                price = BigDecimal.ZERO;
            }
            targetPriceMap.put(itemNumber, price);
            startTotalAmount = startTotalAmount.add(quantity.multiply(price));
        }
        PurchaseEbiddingHead ebiddingHead = new PurchaseEbiddingHead();
        BeanUtils.copyProperties((Object)((Object)enquiryHead), (Object)((Object)ebiddingHead));
        ebiddingHead.setId(IdWorker.getIdStr());
        ebiddingHead.setDocumentParentId(enquiryHead.getId());
        ebiddingHead.setEbiddingNumber(this.invokeBaseRpcService.getNextCode("srmEbiddingNumber", (Object)ebiddingHead));
        ebiddingHead.setTemplateAccount(ebiddingVO.getTemplateAccount());
        ebiddingHead.setTemplateName(ebiddingVO.getTemplateName());
        ebiddingHead.setTemplateNumber(ebiddingVO.getTemplateNumber());
        ebiddingHead.setTemplateVersion(ebiddingVO.getTemplateVersion());
        ebiddingHead.setPublishTime(null);
        ebiddingHead.setPublishUser(null);
        ebiddingHead.setEbiddingStatus(EbiddingStatusEnum.NEW.getValue());
        ebiddingHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        ebiddingHead.setFlowId(null);
        ebiddingHead.setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        ebiddingHead.setResultFlowId(null);
        ebiddingHead.setCreateBy(null);
        ebiddingHead.setCreateById(null);
        ebiddingHead.setCreateTime(null);
        ebiddingHead.setUpdateBy(null);
        ebiddingHead.setUpdateById(null);
        ebiddingHead.setUpdateTime(null);
        ebiddingHead.setSourceId(enquiryHead.getId());
        ebiddingHead.setSourceNumber(enquiryHead.getEnquiryNumber());
        ebiddingHead.setSourceType("enquiry");
        ebiddingHead.setStartTotalAmount(startTotalAmount);
        this.purchaseEbiddingHeadService.save((Object)ebiddingHead);
        PurchaseEbiddingHeadVO ebiddingHeadVO = new PurchaseEbiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)ebiddingHead), (Object)((Object)ebiddingHeadVO));
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(ebiddingVO.getId());
        if (initInfo != null) {
            log.error("......\u884c\u4fe1\u606fjson:" + initInfo.getBusinessInfoJson());
            List itemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEnquiryItem.class);
            if (itemList != null && !itemList.isEmpty()) {
                ArrayList<PurchaseEbiddingItem> ebiddingItemList = new ArrayList<PurchaseEbiddingItem>();
                for (PurchaseEnquiryItem enquiryItem : itemList) {
                    PurchaseEbiddingItem ebiddingItem = new PurchaseEbiddingItem();
                    String itemNumber = enquiryItem.getItemNumber();
                    PurchaseEnquiryItem dbItem = itemMap.get(itemNumber).get(0);
                    BeanUtils.copyProperties((Object)((Object)enquiryItem), (Object)((Object)ebiddingItem));
                    ebiddingItem.setId(IdWorker.getIdStr());
                    ebiddingItem.setHeadId(ebiddingHead.getId());
                    ebiddingItem.setEbiddingNumber(ebiddingHead.getEbiddingNumber());
                    ebiddingItem.setSourceType("enquiry");
                    ebiddingItem.setSourceId(dbItem.getHeadId());
                    ebiddingItem.setSourceItemId(dbItem.getId());
                    ebiddingItem.setSourceNumber(enquiryHead.getEnquiryNumber());
                    ebiddingItem.setSourceItemNumber(itemNumber);
                    ebiddingItem.setDocumentParentId(dbItem.getId());
                    ebiddingItem.setCreateBy(null);
                    ebiddingItem.setCreateById(null);
                    ebiddingItem.setCreateTime(null);
                    ebiddingItem.setUpdateBy(null);
                    ebiddingItem.setUpdateById(null);
                    ebiddingItem.setUpdateTime(null);
                    ebiddingItem.setTargetPrice((BigDecimal)targetPriceMap.get(itemNumber));
                    ebiddingItemList.add(ebiddingItem);
                }
                this.purchaseEbiddingItemService.saveBatch(ebiddingItemList);
                ebiddingHeadVO.setPurchaseEbiddingItemList(ebiddingItemList);
            }
        }
        if (!(enquirySupplierList = this.enquirySupplierListService.selectByMainId(ebiddingVO.getId())).isEmpty()) {
            ArrayList<PurchaseEbiddingSupplier> ebiddingSupplierList = new ArrayList<PurchaseEbiddingSupplier>();
            for (EnquirySupplierList enquirySupplier : enquirySupplierList) {
                PurchaseEbiddingSupplier ebiddingSupplier = new PurchaseEbiddingSupplier();
                BeanUtils.copyProperties((Object)((Object)enquirySupplier), (Object)((Object)ebiddingSupplier));
                ebiddingSupplier.setId(IdWorker.getIdStr());
                ebiddingSupplier.setHeadId(ebiddingHead.getId());
                ebiddingSupplier.setEbiddingNumber(ebiddingHead.getEbiddingNumber());
                ebiddingSupplier.setCreateBy(null);
                ebiddingSupplier.setCreateById(null);
                ebiddingSupplier.setCreateTime(null);
                ebiddingSupplier.setUpdateBy(null);
                ebiddingSupplier.setUpdateById(null);
                ebiddingSupplier.setUpdateTime(null);
                ebiddingSupplierList.add(ebiddingSupplier);
            }
            this.purchaseEbiddingSupplierService.saveBatch(ebiddingSupplierList);
            ebiddingHeadVO.setPurchaseEbiddingSupplierList(ebiddingSupplierList);
        }
        PurchaseEnquiryHead updateEnquiryHead = new PurchaseEnquiryHead();
        updateEnquiryHead.setId(ebiddingVO.getId());
        updateEnquiryHead.setEnquiryStatus(EnquiryStatusEnum.TRANSFERRED.getValue());
        this.purchaseEnquiryHeadService.updateById((Object)updateEnquiryHead);
        return ebiddingHeadVO;
    }

    @Override
    public PurchaseEbiddingHeadVO biddingToEbidding(ToEbiddingVO ebiddingVO) {
        return null;
    }
}

