/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.utils;

import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.enumerate.EbiddingShowEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeHisEnum;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class EbiddingShowUtil {
    public static void purchaseShow(List<PurchaseEbiddingItem> itemList, PurchaseEbiddingHead head, boolean rank) {
        List<String> statusList;
        String purchaseShow;
        String ebiddingWay = head.getEbiddingWay();
        String ebiddingType = head.getEbiddingType();
        String string = purchaseShow = head.getPurchaseShow() == null ? "" : head.getPurchaseShow();
        if (EbiddingStatusEnum.BIDDING.getValue().equals(head.getEbiddingStatus())) {
            if (purchaseShow.contains(EbiddingShowEnum.RANK.getValue()) && rank) {
                EbiddingShowUtil.rank(itemList, ebiddingWay, ebiddingType);
            }
            if (!purchaseShow.contains(EbiddingShowEnum.PRICE.getValue())) {
                itemList.forEach(item -> {
                    item.setPrice(null);
                    item.setNetPrice(null);
                    item.setTotalAmount(null);
                    item.setNetTotalAmount(null);
                    item.setTaxAmount(null);
                    item.setNetAmount(null);
                });
            }
        } else if (rank) {
            EbiddingShowUtil.rank(itemList, ebiddingWay, ebiddingType);
        }
        if ((statusList = Arrays.asList(EbiddingStatusEnum.NEW.getValue(), EbiddingStatusEnum.WAIT_REPLY.getValue(), EbiddingStatusEnum.BIDDING.getValue(), EbiddingStatusEnum.WAIT_BIDDING.getValue())).contains(head.getEbiddingStatus()) && !purchaseShow.contains(EbiddingShowEnum.NAME.getValue())) {
            itemList.forEach(item -> item.setSupplierName(null));
        }
        if (statusList.contains(head.getEbiddingStatus()) && !purchaseShow.contains(EbiddingShowEnum.PRICE.getValue())) {
            itemList.forEach(item -> {
                item.setPrice(null);
                item.setNetPrice(null);
            });
        }
        if (statusList.contains(head.getEbiddingStatus()) && !purchaseShow.contains(EbiddingShowEnum.RANK.getValue())) {
            itemList.forEach(item -> item.setQuoteRank(null));
        }
    }

    private static void rank(List<PurchaseEbiddingItem> itemList, String ebiddingWay, String ebiddingType) {
        List<PurchaseEbiddingItem> sortList = EbiddingTypeEnum.getEnumByValue(ebiddingType).sort(ebiddingWay, itemList);
        block0: for (int i = 0; i < sortList.size(); ++i) {
            for (PurchaseEbiddingItem item : itemList) {
                if (!item.getId().equals(sortList.get(i).getId())) continue;
                int rank = i + 1;
                item.setQuoteRank(rank);
                continue block0;
            }
        }
        itemList.sort(Comparator.comparing(PurchaseEbiddingItem::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
    }

    public static void purchaseShowHis(List<PurchaseEbiddingItemHis> itemList, PurchaseEbiddingHead head, boolean rank) {
        String purchaseShow;
        String ebiddingWay = head.getEbiddingWay();
        String ebiddingType = head.getEbiddingType();
        String string = purchaseShow = head.getPurchaseShow() == null ? "" : head.getPurchaseShow();
        if (EbiddingStatusEnum.BIDDING.getValue().equals(head.getEbiddingStatus())) {
            if (purchaseShow.contains(EbiddingShowEnum.RANK.getValue()) && rank) {
                EbiddingShowUtil.rankHis(itemList, ebiddingWay, ebiddingType);
            }
            if (!purchaseShow.contains(EbiddingShowEnum.PRICE.getValue())) {
                itemList.forEach(item -> {
                    item.setPrice(null);
                    item.setNetPrice(null);
                    item.setTotalAmount(null);
                    item.setNetTotalAmount(null);
                    item.setTaxAmount(null);
                    item.setNetAmount(null);
                });
            }
            if (!purchaseShow.contains(EbiddingShowEnum.NAME.getValue())) {
                itemList.forEach(item -> item.setSupplierName(null));
            }
        } else if (rank) {
            EbiddingShowUtil.rankHis(itemList, ebiddingWay, ebiddingType);
        }
    }

    private static void rankHis(List<PurchaseEbiddingItemHis> itemList, String ebiddingWay, String ebiddingType) {
        List<PurchaseEbiddingItemHis> sortList = EbiddingTypeHisEnum.getEnumByValue(ebiddingType).sort(ebiddingWay, itemList);
        block0: for (int i = 0; i < sortList.size(); ++i) {
            for (PurchaseEbiddingItemHis item : itemList) {
                if (!item.getId().equals(sortList.get(i).getId())) continue;
                int rank = i + 1;
                item.setQuoteRank(rank);
                continue block0;
            }
        }
        itemList.sort(Comparator.comparing(PurchaseEbiddingItemHis::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
    }
}

