/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.utils.CompareIPUtils;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.PurchaseEnquiryItemHis;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.mapper.PurchaseEnquiryItemHisMapper;
import com.els.modules.enquiry.mapper.PurchaseEnquiryItemMapper;
import com.els.modules.enquiry.service.EnquirySubstituteItemService;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemHisService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.enquiry.vo.EnquiryItemPriceVO;
import com.els.modules.enquiry.vo.SupplierEnquiryItemAmountVO;
import com.els.modules.enquiry.vo.SupplierEnquiryItemPriceVO;
import com.els.modules.enquiry.vo.SupplierEnquiryItemQuantityVO;
import com.els.modules.exchange.rpc.dto.BpExchangeRateDTO;
import com.els.modules.inquiry.enumerate.QuoteTypeEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialUnitNewDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseEnquiryItemServiceImpl
extends ServiceImpl<PurchaseEnquiryItemMapper, PurchaseEnquiryItem>
implements PurchaseEnquiryItemService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEnquiryItemServiceImpl.class);
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;
    @Autowired
    @Lazy
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private EnquirySubstituteItemService enquirySubstituteItemService;
    @Autowired
    private DictAspect dictAspect;
    @Autowired
    private PurchaseEnquiryItemHisMapper purchaseEnquiryItemHisMapper;
    @Autowired
    private PurchaseEnquiryItemHisService enquiryItemHisService;
    @Autowired
    private InquiryInvokeMainDataRpcService mainDataRpcService;
    @Autowired
    private CoreInvokeSupplierRpcService supplierRpcService;

    @Override
    public List<PurchaseEnquiryItem> selectByMainId(String mainId) {
        return ((PurchaseEnquiryItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseEnquiryItemMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public void hideQuotePrice(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> itemList) {
        boolean showPrice;
        boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
        if (!showPrice) {
            for (PurchaseEnquiryItem item : itemList) {
                Object object2;
                item.setPrice(null);
                item.setNetPrice(null);
                item.setTaxAmount(null);
                item.setNetAmount(null);
                if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())) {
                    JSONArray ladderPriceJson = StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson()) ? JSONArray.parseArray((String)item.getLadderPriceJson()) : new JSONArray();
                    for (Object object2 : ladderPriceJson) {
                        JSONObject ladderItem = (JSONObject)object2;
                        ladderItem.put("price", null);
                        ladderItem.put("netPrice", null);
                        ladderItem.put("taxAmount", null);
                        ladderItem.put("netAmount", null);
                    }
                    item.setLadderPriceJson(ladderPriceJson.toJSONString());
                }
                if (!EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())) continue;
                JSONObject costFormJson = StrUtil.isNotBlank((CharSequence)item.getCostFormJson()) ? JSONObject.parseObject((String)item.getCostFormJson()) : new JSONObject();
                JSONArray groups = costFormJson.getJSONArray("groups") == null ? new JSONArray() : costFormJson.getJSONArray("groups");
                object2 = groups.iterator();
                while (object2.hasNext()) {
                    Object object3 = object2.next();
                    JSONObject group = (JSONObject)object3;
                    group.put("totalValue", null);
                }
                JSONObject data = costFormJson.getJSONObject("data") == null ? new JSONObject() : costFormJson.getJSONObject("data");
                for (String key : data.keySet()) {
                    data.put(key, (Object)new JSONArray());
                }
                item.setCostFormJson(costFormJson.toJSONString());
            }
        }
    }

    @Override
    public void replenishMaterialNumber(PurchaseEnquiryItem webItem) {
        List<PurchaseEnquiryItem> itemList = this.selectByMainId(webItem.getHeadId());
        this.checkMaterialNumber(webItem, itemList);
        List<PurchaseEnquiryItem> items = this.handlePurchaseEnquiryItemList(webItem, itemList);
        this.updateBatchById(items);
        this.saleEnquiryItemService.replenishMaterialNumber(items);
        this.enquirySubstituteItemService.replenishMaterialNumber(items);
        PurchaseEnquiryItem item = items.get(0);
        if (SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType()) && StringUtils.isNotBlank((CharSequence)item.getSourceItemId())) {
            this.purchaseRequestItemService.replenishMaterial(item.getSourceItemId(), item.getMaterialNumber(), item.getMaterialDesc(), item.getMaterialGroup(), item.getMaterialSpec());
        }
    }

    private List<PurchaseEnquiryItem> handlePurchaseEnquiryItemList(PurchaseEnquiryItem webItem, List<PurchaseEnquiryItem> itemList) {
        List<PurchaseEnquiryItem> items = itemList.stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).collect(Collectors.toList());
        items.forEach(item -> {
            item.setMaterialNumber(webItem.getMaterialNumber());
            item.setMaterialDesc(webItem.getMaterialDesc());
            item.setMaterialGroup(webItem.getMaterialGroup());
            item.setMaterialSpec(webItem.getMaterialSpec());
            item.setMaterialGroupName(webItem.getMaterialGroupName());
            item.setMaterialId(webItem.getMaterialId());
        });
        return items;
    }

    private void checkMaterialNumber(PurchaseEnquiryItem webItem, List<PurchaseEnquiryItem> itemList) {
        List materialNumbers = itemList.stream().map(PurchaseEnquiryItem::getMaterialNumber).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialNumbers)) {
            return;
        }
        boolean b = materialNumbers.stream().anyMatch(item -> item.equals(webItem.getMaterialNumber()));
        if (b) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__SLAoxOVB_f1d5e3eb", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u91cd\u590d"));
        }
    }

    @Override
    public void exportCompare(PurchaseEnquiryHead dbHead, HttpServletResponse response) {
        List<PurchaseEnquiryItem> itemList = ((PurchaseEnquiryItemMapper)this.baseMapper).selectByMainId(dbHead.getId());
        List itemHisList = this.purchaseEnquiryItemHisMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(PurchaseEnquiryItemHis::getHeadId, (Object)dbHead.getId()));
        this.hidePriceHis(dbHead, itemHisList);
        this.hideQuotePrice(dbHead, itemList);
        Map<String, List<PurchaseEnquiryItemHis>> groupItem = itemHisList.stream().collect(Collectors.groupingBy(item -> item.getMaterialNumber() + "_" + item.getQuoteCount()));
        itemHisList.clear();
        for (Map.Entry<String, List<PurchaseEnquiryItemHis>> entry : groupItem.entrySet()) {
            this.enquiryItemHisService.initCompareMsg(dbHead, entry.getValue());
            itemHisList.addAll((Collection)entry.getValue());
        }
        Result dbResult = Result.ok((Object)((Object)dbHead));
        this.dictAspect.parseDictText((Object)dbResult);
        JSONObject headObject = (JSONObject)dbResult.getResult();
        List distinctList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItem>(Comparator.comparing(PurchaseEnquiryItem::getItemNumber))), ArrayList::new));
        List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(dbHead.getId());
        ExcelWriter writer = new ExcelWriter(true, "\u5e38\u89c4\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u540d\u79f0", "\u7269\u6599\u63cf\u8ff0", "\u7269\u6599\u89c4\u683c", "\u9700\u6c42\u6570\u91cf", "\u91c7\u8d2d\u5355\u4f4d", "\u76ee\u6807\u5355\u4ef7", "\u5de5\u5382", "\u5e93\u5b58\u5730\u70b9", "\u5bf9\u6bd4\u9879"));
        int firstRow = 1;
        List<JSONObject> data = this.getDictJsonObjects(distinctList);
        List normalItemList = distinctList.stream().filter(item -> EnquiryQuoteWayEnum.NORMAL.getValue().equals(item.getQuotePriceWay())).collect(Collectors.toList());
        int i = 0;
        for (Object item2 : normalItemList) {
            JSONObject jsonObject = data.get(i);
            log.info("dbResult-JSON:{}, \u91c7\u8d2d\u5355\u4f4d:{}", (Object)jsonObject.toJSONString(), (Object)jsonObject.getString("purchaseUnit_dictText"));
            writer.merge(firstRow, firstRow + 16, 0, 0, (Object)((PurchaseEnquiryItem)((Object)item2)).getEnquiryNumber(), false);
            writer.merge(firstRow, firstRow + 16, 1, 1, (Object)((PurchaseEnquiryItem)((Object)item2)).getItemNumber(), false);
            writer.merge(firstRow, firstRow + 16, 2, 2, (Object)((PurchaseEnquiryItem)((Object)item2)).getMaterialNumber(), false);
            writer.merge(firstRow, firstRow + 16, 3, 3, (Object)((PurchaseEnquiryItem)((Object)item2)).getMaterialName(), false);
            writer.merge(firstRow, firstRow + 16, 4, 4, (Object)((PurchaseEnquiryItem)((Object)item2)).getMaterialDesc(), false);
            writer.merge(firstRow, firstRow + 16, 5, 5, (Object)((PurchaseEnquiryItem)((Object)item2)).getMaterialSpec(), false);
            writer.merge(firstRow, firstRow + 16, 6, 6, (Object)((PurchaseEnquiryItem)((Object)item2)).getRequireQuantity(), false);
            writer.merge(firstRow, firstRow + 16, 7, 7, (Object)jsonObject.getString("purchaseUnit_dictText"), false);
            writer.merge(firstRow, firstRow + 16, 8, 8, (Object)((PurchaseEnquiryItem)((Object)item2)).getFuturePrice(), false);
            writer.merge(firstRow, firstRow + 16, 9, 9, (Object)jsonObject.getString("factory_dictText"), false);
            writer.merge(firstRow, firstRow + 16, 10, 10, (Object)jsonObject.getString("storageLocation_dictText"), false);
            ++i;
            writer.writeCellValue(11, firstRow, (Object)"\u542b\u7a0e\u4ef7");
            writer.writeCellValue(11, firstRow + 1, (Object)"\u672a\u7a0e\u5355\u4ef7");
            writer.writeCellValue(11, firstRow + 2, (Object)"\u7a0e\u7387");
            writer.writeCellValue(11, firstRow + 3, (Object)"\u4ea4\u8d27\u65e5\u671f");
            writer.writeCellValue(11, firstRow + 4, (Object)"\u62a5\u4ef7\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 5, (Object)"\u6700\u5c0f\u5305\u88c5\u91cf");
            writer.writeCellValue(11, firstRow + 6, (Object)"\u6700\u5c0f\u8ba2\u5355\u91cf");
            writer.writeCellValue(11, firstRow + 7, (Object)"\u4ef7\u683c\u751f\u6548\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 8, (Object)"\u4ef7\u683c\u5931\u6548\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 9, (Object)"\u62a5\u4ef7\u8f6e\u6b21");
            writer.writeCellValue(11, firstRow + 10, (Object)"\u4ed8\u6b3e\u6761\u4ef6");
            writer.writeCellValue(11, firstRow + 11, (Object)"\u56fd\u8d38\u6761\u4ef6");
            writer.writeCellValue(11, firstRow + 12, (Object)"\u5386\u53f2\u6700\u4f4e\u4ef7");
            writer.writeCellValue(11, firstRow + 13, (Object)"\u4f9b\u5e94\u5546\u5386\u53f2\u6700\u4f4e\u4ef7");
            writer.writeCellValue(11, firstRow + 14, (Object)"\u7d2f\u8ba1\u91c7\u8d2d\u989d");
            writer.writeCellValue(11, firstRow + 15, (Object)"\u7d2f\u8ba1\u91c7\u8d2d\u91cf");
            writer.writeCellValue(11, firstRow + 16, (Object)"\u8fd1\u4e09\u4e2a\u6708\u603b\u91c7\u8d2d\u989d");
            firstRow += 17;
        }
        AtomicInteger x = new AtomicInteger(12);
        if (!CollectionUtils.isEmpty(normalItemList)) {
            for (EnquirySupplierList supplier : supplierList) {
                List dataList = itemHisList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).filter(item -> EnquiryQuoteWayEnum.NORMAL.getValue().equals(item.getQuotePriceWay())).collect(Collectors.toList());
                Map<String, List<PurchaseEnquiryItemHis>> itemByNumberMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getItemNumber));
                AtomicInteger y = new AtomicInteger(1);
                int[] row = new int[]{0};
                AtomicInteger finalX1 = x;
                itemByNumberMap.forEach((itemNumber, v) -> {
                    if (v.size() > row[0]) {
                        row[0] = v.size();
                    }
                    AtomicInteger finalX = new AtomicInteger(finalX1.get());
                    v.forEach(item -> {
                        writer.writeCellValue(finalX.get(), y.get(), (Object)item.getPrice());
                        writer.writeCellValue(finalX.get(), y.get() + 1, (Object)item.getNetPrice());
                        writer.writeCellValue(finalX.get(), y.get() + 2, (Object)item.getTaxRate());
                        writer.writeCellValue(finalX.get(), y.get() + 3, item.getDeliveryDate() == null ? null : DateUtil.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), y.get() + 4, item.getQuoteTime() == null ? null : DateUtil.format((Date)item.getQuoteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        writer.writeCellValue(finalX.get(), y.get() + 5, (Object)item.getMinPackQuantity());
                        writer.writeCellValue(finalX.get(), y.get() + 6, (Object)item.getMinOrderQuantity());
                        writer.writeCellValue(finalX.get(), y.get() + 7, item.getEffectiveDate() == null ? null : DateUtil.format((Date)item.getEffectiveDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), y.get() + 8, item.getExpiryDate() == null ? null : DateUtil.format((Date)item.getExpiryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), y.get() + 9, (Object)item.getQuoteCount());
                        writer.writeCellValue(finalX.get(), y.get() + 10, headObject.get((Object)"payTermsCode_dictText"));
                        writer.writeCellValue(finalX.get(), y.get() + 11, headObject.get((Object)"tradeCondition_dictText"));
                        writer.writeCellValue(finalX.get(), y.get() + 12, (Object)item.getHisMinPrice());
                        writer.writeCellValue(finalX.get(), y.get() + 13, (Object)item.getSupplierHisMinPrice());
                        writer.writeCellValue(finalX.get(), y.get() + 14, (Object)item.getSupplierSumAmount());
                        writer.writeCellValue(finalX.get(), y.get() + 15, (Object)item.getSumQuantity());
                        writer.writeCellValue(finalX.get(), y.get() + 16, (Object)item.getThreeMonthsSumAmount());
                        writer.setColumnWidth(finalX.get(), 16);
                        finalX.getAndIncrement();
                    });
                    y.addAndGet(17);
                });
                if (row[0] > 1) {
                    writer.merge(0, 0, x.get(), x.addAndGet(row[0]) - 1, (Object)supplier.getSupplierName(), true);
                    continue;
                }
                x.addAndGet(row[0]);
            }
        }
        this.ladderCompare(headObject, writer, itemHisList, distinctList, supplierList);
        this.costCompare(headObject, writer, itemHisList, distinctList, supplierList);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u6bd4\u4ef7\u62a5\u8868.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (IOException e) {
            log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
    }

    private void hidePriceHis(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItemHis> itemHisList) {
        boolean showPrice;
        boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
        if (!showPrice) {
            for (PurchaseEnquiryItemHis itemHis : itemHisList) {
                Object object2;
                itemHis.setPrice(null);
                itemHis.setNetPrice(null);
                itemHis.setTaxAmount(null);
                itemHis.setNetAmount(null);
                if (EnquiryQuoteWayEnum.LADDER.getValue().equals(itemHis.getQuotePriceWay())) {
                    JSONArray ladderPriceJson = StrUtil.isNotBlank((CharSequence)itemHis.getLadderPriceJson()) ? JSONArray.parseArray((String)itemHis.getLadderPriceJson()) : new JSONArray();
                    for (Object object2 : ladderPriceJson) {
                        JSONObject ladderItem = (JSONObject)object2;
                        ladderItem.put("price", null);
                        ladderItem.put("netPrice", null);
                        ladderItem.put("taxAmount", null);
                        ladderItem.put("netAmount", null);
                    }
                    itemHis.setLadderPriceJson(ladderPriceJson.toJSONString());
                }
                if (!EnquiryQuoteWayEnum.COST.getValue().equals(itemHis.getQuotePriceWay())) continue;
                JSONObject costFormJson = StrUtil.isNotBlank((CharSequence)itemHis.getCostFormJson()) ? JSONObject.parseObject((String)itemHis.getCostFormJson()) : new JSONObject();
                JSONArray groups = costFormJson.getJSONArray("groups") == null ? new JSONArray() : costFormJson.getJSONArray("groups");
                object2 = groups.iterator();
                while (object2.hasNext()) {
                    Object object3 = object2.next();
                    JSONObject group = (JSONObject)object3;
                    group.put("totalValue", null);
                }
                JSONObject data = costFormJson.getJSONObject("data") == null ? new JSONObject() : costFormJson.getJSONObject("data");
                for (String key : data.keySet()) {
                    data.put(key, (Object)new JSONArray());
                }
                itemHis.setCostFormJson(costFormJson.toJSONString());
            }
        }
    }

    @Override
    public Map<String, Long> getSupplierPortraitCount(String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItem::getToElsAccount, (Object)toElsAccount);
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List allList = this.list((Wrapper)queryWrapper);
        long participationCount = allList.stream().map(PurchaseEnquiryItem::getHeadId).distinct().count();
        long biddingWinCount = allList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItem::getHeadId).distinct().count();
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        returnMap.put("participationCount", participationCount);
        returnMap.put("biddingWinCount", biddingWinCount);
        return returnMap;
    }

    @Override
    public List<PurchaseEnquiryItem> queryEnquiryByDesc(List<String> materialDescs) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(PurchaseEnquiryItem::getItemStatus, new Object[]{EnquiryStatusEnum.ACCEPT.getValue(), EnquiryStatusEnum.PRICED.getValue()});
        lambdaQueryWrapper.in(PurchaseEnquiryItem::getMaterialDesc, materialDescs);
        lambdaQueryWrapper.and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(PurchaseEnquiryItem::getMaterialNumber)).or(qw1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)qw1.eq(PurchaseEnquiryItem::getMaterialNumber, (Object)"");
            });
        });
        return ((PurchaseEnquiryItemMapper)this.baseMapper).selectList((Wrapper)lambdaQueryWrapper);
    }

    private void ladderCompare(JSONObject headObject, ExcelWriter writer, List<PurchaseEnquiryItemHis> itemHisList, List<PurchaseEnquiryItem> distinctList, List<EnquirySupplierList> supplierList) {
        writer.setSheet("\u9636\u68af\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u540d\u79f0", "\u7269\u6599\u63cf\u8ff0", "\u7269\u6599\u89c4\u683c", "\u9700\u6c42\u6570\u91cf", "\u91c7\u8d2d\u5355\u4f4d", "\u76ee\u6807\u5355\u4ef7", "\u5de5\u5382", "\u5e93\u5b58\u5730\u70b9", "\u9636\u68af\u7ea7", ""));
        writer.merge(0, 0, 11, 12, (Object)"\u9636\u68af\u6bd4\u4ef7", true);
        int firstRow = 1;
        List<JSONObject> data = this.getDictJsonObjects(distinctList);
        int i = 0;
        for (PurchaseEnquiryItem item2 : distinctList) {
            JSONObject jsonObject = data.get(i);
            if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item2.getQuotePriceWay()) && StrUtil.isNotBlank((CharSequence)item2.getLadderPriceJson())) {
                JSONArray array = JSONArray.parseArray((String)item2.getLadderPriceJson());
                this.mergeCell(writer, firstRow, array, item2, jsonObject);
                for (int index = 0; index < array.size(); ++index) {
                    JSONObject ladder = array.getJSONObject(index);
                    writer.writeCellValue(12, firstRow + index, (Object)ladder.getString("ladder"));
                }
                int index2 = 0;
                for (int index = array.size(); index < array.size() * 2; ++index) {
                    JSONObject ladder = array.getJSONObject(index2);
                    writer.writeCellValue(12, firstRow + index, (Object)ladder.getString("ladder"));
                    ++index2;
                }
                int rows = array.size() * 2 + 15;
                firstRow += rows;
            }
            ++i;
        }
        AtomicInteger x = new AtomicInteger(13);
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemHisList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson())).filter(item -> EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            Map<String, List<PurchaseEnquiryItemHis>> itemByNumberMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getItemNumber));
            AtomicInteger y = new AtomicInteger(1);
            int[] row = new int[]{0};
            AtomicInteger finalX1 = x;
            itemByNumberMap.forEach((itemNumber, v) -> {
                if (v.size() > row[0]) {
                    row[0] = v.size();
                }
                JSONArray array1 = JSONArray.parseArray((String)((PurchaseEnquiryItemHis)((Object)((Object)v.get(0)))).getLadderPriceJson());
                int size = array1.size();
                AtomicInteger finalX = new AtomicInteger(finalX1.get());
                v.forEach(item -> {
                    JSONArray array = JSONArray.parseArray((String)item.getLadderPriceJson());
                    for (int index = 0; index < array.size(); ++index) {
                        JSONObject ladder = array.getJSONObject(index);
                        writer.writeCellValue(finalX.get(), y.get() + index, (Object)ladder.getBigDecimal("price"));
                    }
                    int index2 = 0;
                    for (int index = array.size(); index < array.size() * 2; ++index) {
                        JSONObject ladder = array.getJSONObject(index2);
                        writer.writeCellValue(finalX.get(), y.get() + index, (Object)ladder.getBigDecimal("netPrice"));
                        ++index2;
                    }
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2, (Object)item.getTaxRate());
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 1, item.getDeliveryDate() == null ? null : DateUtil.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd"));
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 2, item.getQuoteTime() == null ? null : DateUtil.format((Date)item.getQuoteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 3, (Object)item.getMinPackQuantity());
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 4, (Object)item.getMinOrderQuantity());
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 5, item.getEffectiveDate() == null ? null : DateUtil.format((Date)item.getEffectiveDate(), (String)"yyyy-MM-dd"));
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 6, item.getExpiryDate() == null ? null : DateUtil.format((Date)item.getExpiryDate(), (String)"yyyy-MM-dd"));
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 7, (Object)item.getQuoteCount());
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 8, headObject.get((Object)"payTermsCode_dictText"));
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 9, headObject.get((Object)"tradeCondition_dictText"));
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 10, (Object)item.getHisMinPrice());
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 11, (Object)item.getSupplierHisMinPrice());
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 12, (Object)item.getSupplierSumAmount());
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 13, (Object)item.getSumQuantity());
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 14, (Object)item.getThreeMonthsSumAmount());
                    writer.setColumnWidth(finalX.get(), 16);
                    finalX.getAndIncrement();
                });
                int rows = size * 2 + 15;
                y.addAndGet(rows);
            });
            if (row[0] > 1) {
                writer.merge(0, 0, x.get(), x.addAndGet(row[0]) - 1, (Object)supplier.getSupplierName(), true);
                continue;
            }
            x.addAndGet(row[0]);
        }
    }

    private List<JSONObject> getDictJsonObjects(List<PurchaseEnquiryItem> distinctList) {
        ArrayList itemList1 = new ArrayList();
        distinctList.forEach(e -> {
            PurchaseEnquiryItem item = new PurchaseEnquiryItem();
            BeanUtils.copyProperties((Object)e, (Object)((Object)item));
            itemList1.add(item);
        });
        Result dbResult = Result.ok(itemList1);
        this.dictAspect.parseDictText((Object)dbResult);
        return (List)dbResult.getResult();
    }

    private void costCompare(JSONObject headObject, ExcelWriter writer, List<PurchaseEnquiryItemHis> itemHisList, List<PurchaseEnquiryItem> distinctList, List<EnquirySupplierList> supplierList) {
        writer.setSheet("\u6210\u672c\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u540d\u79f0", "\u7269\u6599\u63cf\u8ff0", "\u7269\u6599\u89c4\u683c", "\u9700\u6c42\u6570\u91cf", "\u91c7\u8d2d\u5355\u4f4d", "\u76ee\u6807\u5355\u4ef7", "\u5de5\u5382", "\u5e93\u5b58\u5730\u70b9", "\u6210\u672c\u9879", ""));
        writer.merge(0, 0, 11, 12, (Object)"\u6210\u672c\u9879", true);
        int firstRow = 1;
        int i = 0;
        List distinctList1 = distinctList.stream().filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay()) && CharSequenceUtil.isNotBlank((CharSequence)item.getCostFormJson()) && !ObjectUtils.isEmpty((Object)JSON.parseObject((String)item.getCostFormJson()).getJSONArray("groups"))).sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItem>(Comparator.comparing(PurchaseEnquiryItem::getItemNumber))), ArrayList::new));
        List<JSONObject> data = this.getDictJsonObjects(distinctList1);
        for (PurchaseEnquiryItem item2 : distinctList1) {
            JSONObject dictJsonObject = data.get(i);
            if (EnquiryQuoteWayEnum.COST.getValue().equals(item2.getQuotePriceWay()) && CharSequenceUtil.isNotBlank((CharSequence)item2.getCostFormJson())) {
                JSONObject jsonObject = JSON.parseObject((String)item2.getCostFormJson());
                log.info("costCompare-jsonObject:{}", (Object)jsonObject.toJSONString());
                JSONArray groups = jsonObject.getJSONArray("groups");
                if (groups != null) {
                    this.mergeCell(writer, firstRow, groups, item2, dictJsonObject);
                    for (int index = 0; index < groups.size(); ++index) {
                        JSONObject group = groups.getJSONObject(index);
                        writer.writeCellValue(12, firstRow + index, (Object)group.getString("groupName"));
                    }
                    int index2 = 0;
                    for (int index = groups.size(); index < groups.size() * 2; ++index) {
                        JSONObject group = groups.getJSONObject(index2);
                        writer.writeCellValue(12, firstRow + index, (Object)group.getString("groupName"));
                        ++index2;
                    }
                    int rows = groups.size() * 2 + 15;
                    firstRow += rows;
                }
            }
            ++i;
        }
        AtomicInteger x = new AtomicInteger(13);
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemHisList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> StrUtil.isNotBlank((CharSequence)item.getCostFormJson())).filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            Map<String, List<PurchaseEnquiryItemHis>> itemByNumberMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getItemNumber));
            AtomicInteger y = new AtomicInteger(1);
            int[] row = new int[]{0};
            AtomicInteger finalX1 = x;
            itemByNumberMap.forEach((itemNumber, v) -> {
                JSONObject jsonObject1;
                if (v.size() > row[0]) {
                    row[0] = v.size();
                }
                JSONArray groups1 = (jsonObject1 = JSONObject.parseObject((String)((PurchaseEnquiryItemHis)((Object)((Object)v.get(0)))).getCostFormJson())).getJSONArray("groups") == null ? new JSONArray() : jsonObject1.getJSONArray("groups");
                int size = groups1.size();
                AtomicInteger finalX = new AtomicInteger(finalX1.get());
                v.forEach(item -> {
                    JSONObject jsonObject = JSONObject.parseObject((String)item.getCostFormJson());
                    JSONArray groups = jsonObject.getJSONArray("groups") == null ? new JSONArray() : jsonObject.getJSONArray("groups");
                    for (int index = 0; index < groups.size(); ++index) {
                        JSONObject group = groups.getJSONObject(index);
                        writer.writeCellValue(finalX.get(), y.get() + index, (Object)group.getBigDecimal("totalValue"));
                    }
                    int index2 = 0;
                    for (int index = groups.size(); index < groups.size() * 2; ++index) {
                        JSONObject group = groups.getJSONObject(index2);
                        writer.writeCellValue(finalX.get(), y.get() + index, (Object)group.getBigDecimal("netPrice"));
                        ++index2;
                    }
                    if (!groups.isEmpty()) {
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2, (Object)item.getTaxRate());
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 1, item.getDeliveryDate() == null ? null : DateUtil.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 2, item.getQuoteTime() == null ? null : DateUtil.format((Date)item.getQuoteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 3, (Object)item.getMinPackQuantity());
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 4, (Object)item.getMinOrderQuantity());
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 5, item.getEffectiveDate() == null ? null : DateUtil.format((Date)item.getEffectiveDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 6, item.getExpiryDate() == null ? null : DateUtil.format((Date)item.getExpiryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 7, (Object)item.getQuoteCount());
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 8, headObject.get((Object)"payTermsCode_dictText"));
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 9, headObject.get((Object)"tradeCondition_dictText"));
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 10, (Object)item.getHisMinPrice());
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 11, (Object)item.getSupplierHisMinPrice());
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 12, (Object)item.getSupplierSumAmount());
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 13, (Object)item.getSumQuantity());
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 14, (Object)item.getThreeMonthsSumAmount());
                        writer.setColumnWidth(finalX.get(), 16);
                        finalX.getAndIncrement();
                    }
                });
                int rows = size * 2 + 15;
                y.addAndGet(rows);
            });
            if (row[0] > 1) {
                writer.merge(0, 0, x.get(), x.addAndGet(row[0]) - 1, (Object)supplier.getSupplierName(), true);
                continue;
            }
            x.addAndGet(row[0]);
        }
    }

    private void mergeCell(ExcelWriter writer, int firstRow, JSONArray ladderOrGroups, PurchaseEnquiryItem item, JSONObject jsonObject) {
        if (ladderOrGroups.size() > 1) {
            writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 0, 0, (Object)item.getEnquiryNumber(), false);
            writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 1, 1, (Object)item.getItemNumber(), false);
            writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 2, 2, (Object)item.getMaterialNumber(), false);
            writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 3, 3, (Object)item.getMaterialName(), false);
            writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 4, 4, (Object)item.getMaterialDesc(), false);
            writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 5, 5, (Object)item.getMaterialSpec(), false);
            writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 6, 6, (Object)item.getRequireQuantity(), false);
            writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 7, 7, (Object)jsonObject.getString("purchaseUnit_dictText"), false);
            writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 8, 8, (Object)item.getFuturePrice(), false);
            writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 9, 9, (Object)jsonObject.getString("factory_dictText"), false);
            writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 10, 10, (Object)jsonObject.getString("storageLocation_dictText"), false);
            this.getWriteRows(writer, firstRow, ladderOrGroups);
        } else {
            writer.writeCellValue(0, 14 + firstRow, (Object)item.getEnquiryNumber());
            writer.writeCellValue(1, 14 + firstRow, (Object)item.getItemNumber());
            writer.writeCellValue(2, 14 + firstRow, (Object)item.getMaterialNumber());
            writer.writeCellValue(3, 14 + firstRow, (Object)item.getMaterialName());
            writer.writeCellValue(4, 14 + firstRow, (Object)item.getMaterialDesc());
            writer.writeCellValue(5, 14 + firstRow, (Object)item.getMaterialSpec());
            writer.writeCellValue(6, 14 + firstRow, (Object)item.getRequireQuantity());
            writer.writeCellValue(7, 14 + firstRow, (Object)jsonObject.getString("purchaseUnit_dictText"));
            writer.writeCellValue(8, 14 + firstRow, (Object)item.getFuturePrice());
            writer.writeCellValue(9, 14 + firstRow, (Object)jsonObject.getString("factory_dictText"));
            writer.writeCellValue(10, 14 + firstRow, (Object)jsonObject.getString("storageLocation_dictText"));
            this.getWriteRows(writer, firstRow, ladderOrGroups);
        }
    }

    private void getWriteRows(ExcelWriter writer, int firstRow, JSONArray ladderOrGroups) {
        int row = ladderOrGroups.size() * 2;
        writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 11, 11, (Object)"\u542b\u7a0e\u4ef7", false);
        writer.merge(firstRow + ladderOrGroups.size(), firstRow + ladderOrGroups.size() * 2 - 1, 11, 11, (Object)"\u672a\u7a0e\u4ef7", false);
        writer.merge(firstRow + row, firstRow + row, 11, 12, (Object)"\u7a0e\u7387", false);
        writer.merge(firstRow + row + 1, firstRow + row + 1, 11, 12, (Object)"\u4ea4\u8d27\u65e5\u671f", false);
        writer.merge(firstRow + row + 2, firstRow + row + 2, 11, 12, (Object)"\u62a5\u4ef7\u65f6\u95f4", false);
        writer.merge(firstRow + row + 3, firstRow + row + 3, 11, 12, (Object)"\u6700\u5c0f\u5305\u88c5\u91cf", false);
        writer.merge(firstRow + row + 4, firstRow + row + 4, 11, 12, (Object)"\u6700\u5c0f\u8ba2\u5355\u91cf", false);
        writer.merge(firstRow + row + 5, firstRow + row + 5, 11, 12, (Object)"\u4ef7\u683c\u751f\u6548\u65f6\u95f4", false);
        writer.merge(firstRow + row + 6, firstRow + row + 6, 11, 12, (Object)"\u4ef7\u683c\u5931\u6548\u65f6\u95f4", false);
        writer.merge(firstRow + row + 7, firstRow + row + 7, 11, 12, (Object)"\u62a5\u4ef7\u8f6e\u6b21", false);
        writer.merge(firstRow + row + 8, firstRow + row + 8, 11, 12, (Object)"\u4ed8\u6b3e\u6761\u4ef6", false);
        writer.merge(firstRow + row + 9, firstRow + row + 9, 11, 12, (Object)"\u56fd\u8d38\u6761\u4ef6", false);
        writer.merge(firstRow + row + 10, firstRow + row + 10, 11, 12, (Object)"\u5386\u53f2\u6700\u4f4e\u4ef7", false);
        writer.merge(firstRow + row + 11, firstRow + row + 11, 11, 12, (Object)"\u4f9b\u5e94\u5546\u5386\u53f2\u6700\u4f4e\u4ef7", false);
        writer.merge(firstRow + row + 12, firstRow + row + 12, 11, 12, (Object)"\u7d2f\u8ba1\u91c7\u8d2d\u989d", false);
        writer.merge(firstRow + row + 13, firstRow + row + 13, 11, 12, (Object)"\u7d2f\u8ba1\u91c7\u8d2d\u91cf", false);
        writer.merge(firstRow + row + 14, firstRow + row + 14, 11, 12, (Object)"\u8fd1\u4e09\u4e2a\u6708\u603b\u91c7\u8d2d\u989d", false);
    }

    private List<String> getHeaderList(List<EnquirySupplierList> supplierList, String ... headText) {
        ArrayList<String> excelHeader = new ArrayList<String>(Arrays.asList(headText));
        for (EnquirySupplierList supplier : supplierList) {
            excelHeader.add(supplier.getSupplierName());
        }
        return excelHeader;
    }

    @Override
    public List<SupplierRelationFindResultVO> probeIP(List<PurchaseEnquiryItem> purchaseBiddingItemList) {
        ArrayList<SupplierRelationFindResultVO> result = new ArrayList<SupplierRelationFindResultVO>();
        List accountIpList = purchaseBiddingItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getQuoteIp())).map(item -> item.getToElsAccount() + "_" + item.getQuoteIp()).distinct().collect(Collectors.toList());
        Map<String, PurchaseEnquiryItem> supplierMap = purchaseBiddingItemList.stream().collect(Collectors.toMap(PurchaseEnquiryItem::getToElsAccount, Function.identity(), (supplier1, supplier2) -> supplier2));
        for (String sourceAccountIp : accountIpList) {
            for (String targetAccountIp : accountIpList) {
                if (sourceAccountIp.equals(targetAccountIp)) continue;
                CompareIPUtils.compareEnquiryIp(sourceAccountIp, targetAccountIp, supplierMap, result);
            }
        }
        return result;
    }

    @Override
    public List<PurchaseEnquiryItem> findBySourceItemId(List<String> headIdList, List<String> sourceIdList) {
        return ((PurchaseEnquiryItemMapper)this.baseMapper).findBySourceItemId(headIdList, sourceIdList);
    }

    public void initHeadMsg(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items) {
        items.forEach(item -> item.setPayTermsCode(head.getPayTermsCode()).setTradeCondition(head.getTradeCondition()));
    }

    public void initHisMinPrice(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items, Date pricedTime) {
        List<EnquiryItemPriceVO> priceVOs = ((PurchaseEnquiryItemMapper)this.baseMapper).hisMinPrice(head.getQuoteType(), items.get(0).getMaterialNumber(), pricedTime);
        if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(head.getQuoteType())) {
            List<String> currencies = priceVOs.stream().filter(priceVO -> StringUtils.isNotBlank((CharSequence)priceVO.getItemCurrency()) && !Objects.equals(priceVO.getItemCurrency(), head.getCurrency())).map(EnquiryItemPriceVO::getItemCurrency).collect(Collectors.toList());
            List<BpExchangeRateDTO> rates = this.mainDataRpcService.getRateByCurrencys(currencies, head.getCurrency());
            for (BpExchangeRateDTO rateDTO : rates) {
                if (rateDTO.getExchange() == null) continue;
                for (EnquiryItemPriceVO priceVO2 : priceVOs) {
                    if (!Objects.equals(rateDTO.getOriginalCurrency(), priceVO2.getItemCurrency())) continue;
                    BigDecimal tempPrice = priceVO2.getPrice() == null ? BigDecimal.ZERO : priceVO2.getPrice();
                    BigDecimal result = tempPrice.multiply(rateDTO.getExchange()).setScale(6, 4).stripTrailingZeros();
                    priceVO2.setPrice(result);
                }
            }
            priceVOs = priceVOs.stream().sorted(Comparator.comparing(EnquiryItemPriceVO::getPrice)).collect(Collectors.toList());
        }
        BigDecimal price = CollectionUtils.isEmpty(priceVOs) || priceVOs.get(0).getPrice() == null ? null : priceVOs.get(0).getPrice().stripTrailingZeros();
        for (PurchaseEnquiryItem item : items) {
            item.setHisMinPrice(price);
        }
    }

    public void initSupplierHisMinPrice(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items, Date pricedTime) {
        List<String> toElsAccounts = items.stream().map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList());
        List<SupplierEnquiryItemPriceVO> priceVOS = ((PurchaseEnquiryItemMapper)this.baseMapper).supplierHisMinPrice(head.getQuoteType(), toElsAccounts, items.get(0).getMaterialNumber(), pricedTime);
        if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(head.getQuoteType())) {
            List<String> currencies = priceVOS.stream().filter(priceVO -> StringUtils.isNotBlank((CharSequence)priceVO.getItemCurrency()) && !Objects.equals(priceVO.getItemCurrency(), head.getCurrency())).map(SupplierEnquiryItemPriceVO::getItemCurrency).distinct().collect(Collectors.toList());
            List<BpExchangeRateDTO> rates = this.mainDataRpcService.getRateByCurrencys(currencies, head.getCurrency());
            for (BpExchangeRateDTO rateDTO : rates) {
                if (rateDTO.getExchange() == null) continue;
                for (SupplierEnquiryItemPriceVO priceVO2 : priceVOS) {
                    if (!Objects.equals(rateDTO.getOriginalCurrency(), priceVO2.getItemCurrency())) continue;
                    BigDecimal tempPrice = priceVO2.getPrice() == null ? BigDecimal.ZERO : priceVO2.getPrice();
                    BigDecimal result = tempPrice.multiply(rateDTO.getExchange()).setScale(6, 4).stripTrailingZeros();
                    priceVO2.setPrice(result);
                }
            }
        }
        Map<String, List<SupplierEnquiryItemPriceVO>> groupVOS = priceVOS.stream().collect(Collectors.groupingBy(item -> item.getToElsAccount()));
        for (PurchaseEnquiryItem item2 : items) {
            List<SupplierEnquiryItemPriceVO> tempVOS = groupVOS.get(item2.getToElsAccount());
            if (CollectionUtils.isEmpty(tempVOS)) continue;
            BigDecimal min = tempVOS.stream().map(SupplierEnquiryItemPriceVO::getPrice).min(BigDecimal::compareTo).get();
            item2.setSupplierHisMinPrice(min);
        }
    }

    public void sumAmount(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items, String startTime, Date pricedTime) {
        List<String> toElsAccounts = items.stream().map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList());
        List<SupplierEnquiryItemAmountVO> amountVOS = ((PurchaseEnquiryItemMapper)this.baseMapper).supplierSumAmount(head.getQuoteType(), toElsAccounts, items.get(0).getMaterialNumber(), startTime, pricedTime);
        if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(head.getQuoteType())) {
            List<String> currencies = amountVOS.stream().filter(priceVO -> StringUtils.isNotBlank((CharSequence)priceVO.getItemCurrency()) && !Objects.equals(priceVO.getItemCurrency(), head.getCurrency())).map(SupplierEnquiryItemAmountVO::getItemCurrency).distinct().collect(Collectors.toList());
            List<BpExchangeRateDTO> rates = this.mainDataRpcService.getRateByCurrencys(currencies, head.getCurrency());
            for (BpExchangeRateDTO rateDTO : rates) {
                if (rateDTO.getExchange() == null) continue;
                for (SupplierEnquiryItemAmountVO amountVO : amountVOS) {
                    if (!Objects.equals(rateDTO.getOriginalCurrency(), amountVO.getItemCurrency())) continue;
                    BigDecimal tempPrice = amountVO.getSumAmount() == null ? BigDecimal.ZERO : amountVO.getSumAmount();
                    BigDecimal result = tempPrice.multiply(rateDTO.getExchange()).setScale(6, 4).stripTrailingZeros();
                    amountVO.setSumAmount(result);
                }
            }
        }
        Map<String, BigDecimal> sumGroup = amountVOS.stream().collect(Collectors.groupingBy(SupplierEnquiryItemAmountVO::getToElsAccount, Collectors.mapping(SupplierEnquiryItemAmountVO::getSumAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        for (PurchaseEnquiryItem item : items) {
            BigDecimal sumAmount;
            BigDecimal bigDecimal = sumAmount = sumGroup.get(item.getToElsAccount()) == null ? null : sumGroup.get(item.getToElsAccount()).stripTrailingZeros();
            if (startTime == null) {
                item.setSupplierSumAmount(sumAmount);
                continue;
            }
            item.setThreeMonthsSumAmount(sumAmount);
        }
    }

    public void threeMonthsSumAmount(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items, Date pricedTime) {
        LocalDateTime localDateTime = LocalDateTimeUtil.of((Date)pricedTime);
        String startTime = LocalDateTimeUtil.format((LocalDateTime)localDateTime.minusMonths(3L), (String)"yyyy-MM-dd HH:mm:ss");
        this.sumAmount(head, items, startTime, pricedTime);
    }

    public void sumQuantity(List<PurchaseEnquiryItem> items, Date pricedTime) {
        List<String> toElsAccounts = items.stream().map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList());
        List<SupplierEnquiryItemQuantityVO> quantityVOS = ((PurchaseEnquiryItemMapper)this.baseMapper).supplierSumQuantity(toElsAccounts, items.get(0).getMaterialNumber(), pricedTime);
        List<PurchaseMaterialUnitNewDTO> materialUnits = this.mainDataRpcService.getByMaterialNumber(items.get(0).getMaterialNumber());
        for (SupplierEnquiryItemQuantityVO quantityVO : quantityVOS) {
            if (Objects.equals(quantityVO.getPurchaseUnit(), items.get(0).getPurchaseUnit())) continue;
            for (PurchaseMaterialUnitNewDTO dto : materialUnits) {
                BigDecimal basicAmount;
                BigDecimal quantity = quantityVO.getQuantities() == null ? BigDecimal.ZERO : quantityVO.getQuantities();
                BigDecimal objectAmount = dto.getObjectAmount() == null ? BigDecimal.ONE : dto.getObjectAmount();
                BigDecimal bigDecimal = basicAmount = dto.getBasicAmount() == null ? BigDecimal.ONE : dto.getBasicAmount();
                if (Objects.equals(quantityVO.getPurchaseUnit(), dto.getObjectUnit()) && Objects.equals(items.get(0).getPurchaseUnit(), dto.getBasicUnit())) {
                    quantity = quantity.multiply(basicAmount).divide(objectAmount, 6, RoundingMode.HALF_UP);
                }
                if (Objects.equals(quantityVO.getPurchaseUnit(), dto.getBasicUnit()) && Objects.equals(items.get(0).getPurchaseUnit(), dto.getObjectUnit())) {
                    quantity = quantity.multiply(objectAmount).divide(basicAmount, 6, RoundingMode.HALF_UP);
                }
                quantityVO.setQuantities(quantity);
            }
        }
        Map<String, BigDecimal> sumGroup = quantityVOS.stream().collect(Collectors.groupingBy(SupplierEnquiryItemQuantityVO::getToElsAccount, Collectors.mapping(SupplierEnquiryItemQuantityVO::getQuantities, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        for (PurchaseEnquiryItem item : items) {
            BigDecimal sumQuantity = sumGroup.get(item.getToElsAccount()) == null ? null : sumGroup.get(item.getToElsAccount()).stripTrailingZeros();
            item.setSumQuantity(sumQuantity);
        }
    }

    @Override
    public void initCompareMsg(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items) {
        if (CollectionUtils.isEmpty(items) || StringUtils.isBlank((CharSequence)items.get(0).getMaterialNumber())) {
            return;
        }
        Date pricedTime = head.getPricedTime() != null ? head.getPricedTime() : new Date();
        this.initHeadMsg(head, items);
        this.initHisMinPrice(head, items, pricedTime);
        this.initSupplierHisMinPrice(head, items, pricedTime);
        this.sumAmount(head, items, null, pricedTime);
        this.threeMonthsSumAmount(head, items, pricedTime);
        this.sumQuantity(items, pricedTime);
    }

    @Override
    public void initPackageCompareMsg(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        this.initHeadMsg(head, items);
        List toElsAccounts = items.stream().map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList());
        List dtos = this.supplierRpcService.selectSupplerList(TenantContext.getTenant(), toElsAccounts);
        block0: for (PurchaseEnquiryItem item : items) {
            for (SupplierMasterDataDTO dto : dtos) {
                if (!Objects.equals(item.getToElsAccount(), dto.getToElsAccount())) continue;
                item.setSupplierStatus(dto.getSupplierStatus());
                continue block0;
            }
        }
    }
}

