/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteTypeEnum;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.mapper.SaleEnquiryHeadMapper;
import com.els.modules.enquiry.service.EnquirySubstituteHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryItemHisService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.enquiry.service.impl.PurchaseEnquiryHeadServiceImpl;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleEnquiryHeadServiceImpl
extends BaseServiceImpl<SaleEnquiryHeadMapper, SaleEnquiryHead>
implements SaleEnquiryHeadService {
    private static final Logger log = LoggerFactory.getLogger(SaleEnquiryHeadServiceImpl.class);
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Autowired
    private SaleEnquiryItemHisService saleEnquiryItemHisService;
    @Autowired
    private EnquirySubstituteHeadService enquirySubstituteHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public List<SaleEnquiryHead> selectByMainId(String relationId) {
        return ((SaleEnquiryHeadMapper)this.baseMapper).selectByMainId(relationId);
    }

    @Override
    public SaleEnquiryHead selectByElsAccount(String relationId, String elsAccount) {
        return ((SaleEnquiryHeadMapper)this.baseMapper).selectByElsAccount(relationId, elsAccount);
    }

    @Override
    public Map<String, SaleEnquiryHead> add(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> itemList, List<EnquirySupplierList> supplierList, String enterpriseName, String loginSubAccount) {
        ArrayList<SaleEnquiryHead> saleHeadList = new ArrayList<SaleEnquiryHead>();
        for (EnquirySupplierList supplier : supplierList) {
            SaleEnquiryHead saleHead = new SaleEnquiryHead();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)saleHead));
            SysUtil.setSysParam((BaseEntity)saleHead, (BaseEntity)head);
            saleHead.setId(null);
            saleHead.setRelationId(head.getId());
            saleHead.setElsAccount(supplier.getToElsAccount());
            saleHead.setToElsAccount(supplier.getElsAccount());
            saleHead.setPurchaseName(enterpriseName);
            saleHead.setSupplierName(supplier.getSupplierName());
            saleHead.setSupplierListId(supplier.getId());
            saleHead.setEnquiryStatus(head.getEnquiryStatus());
            saleHead.setCreateBy(loginSubAccount);
            saleHead.setQuoteConfirmFlag(saleHead.getQuoteConfirmTime() == null ? "1" : "0");
            saleHeadList.add(saleHead);
        }
        this.saveBatch(saleHeadList, 2000);
        Map<String, SaleEnquiryHead> supplierMap = saleHeadList.parallelStream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity()));
        ArrayList<SaleEnquiryItem> saleItemList = new ArrayList<SaleEnquiryItem>();
        for (PurchaseEnquiryItem item : itemList) {
            SaleEnquiryItem saleItem = new SaleEnquiryItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)saleItem));
            saleItem.setId(item.getRelationId());
            saleItem.setElsAccount(item.getToElsAccount());
            saleItem.setRelationId(item.getId());
            saleItem.setHeadId(supplierMap.get(item.getToElsAccount()).getId());
            saleItem.setToElsAccount(item.getElsAccount());
            saleItem.setCreateBy(loginSubAccount);
            saleItemList.add(saleItem);
        }
        this.saleEnquiryItemService.saveBatch(saleItemList, 2000);
        this.enquirySubstituteHeadService.add(saleHeadList, saleItemList, supplierList);
        return supplierMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void save(SaleEnquiryHead saleHead, List<SaleEnquiryItem> saleItemList) {
        List<SaleEnquiryItem> updateList;
        if (CollectionUtil.isNotEmpty(saleItemList) && CollectionUtil.isNotEmpty(updateList = this.getOptList(saleHead, saleItemList))) {
            this.saleEnquiryItemService.updateBatchById(updateList);
            SaleEnquiryHead newSaleHead = new SaleEnquiryHead();
            BeanUtils.copyProperties((Object)((Object)saleHead), (Object)((Object)newSaleHead));
            ((SaleEnquiryHeadMapper)this.baseMapper).updateById((Object)saleHead);
            this.enquirySubstituteHeadService.save(newSaleHead, updateList);
        }
    }

    private List<SaleEnquiryItem> getOptList(SaleEnquiryHead saleHead, List<SaleEnquiryItem> saleItemList) {
        List<SaleEnquiryItem> optList = EnquiryStatusEnum.QUOTING.getValue().equals(saleHead.getEnquiryStatus()) ? saleItemList.stream().filter(item -> item.getQuoteEndTime().after(new Date())).collect(Collectors.toList()) : saleItemList.stream().filter(item -> EnquiryStatusEnum.RE_QUOTE.getValue().equals(item.getItemStatus()) || EnquiryStatusEnum.QUOTING.getValue().equals(item.getItemStatus())).filter(item -> item.getQuoteEndTime().after(new Date())).collect(Collectors.toList());
        return optList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void quote(SaleEnquiryHead dbHead, List<SaleEnquiryItem> saleItemList) {
        List<SaleEnquiryItem> quoteList = this.getOptList(dbHead, saleItemList);
        Assert.notEmpty(quoteList, (String)I18nUtil.translate((String)"i18n_alert_BjqIsujcdI_b6f15cad", (String)"\u6ca1\u6709\u53ef\u4ee5\u62a5\u4ef7\u7684\u884c\u9879\u76ee"));
        quoteList.forEach(item -> {
            if ("1".equals(dbHead.getSupplierTaxRate()) && "1".equals(item.getQuotePrice())) {
                item.setTaxRate(StrUtil.isBlank((CharSequence)item.getTaxRate()) ? dbHead.getTaxRate() : item.getTaxRate());
                item.setTaxCode(StrUtil.isBlank((CharSequence)item.getTaxCode()) ? dbHead.getTaxCode() : item.getTaxCode());
                Assert.hasText((String)item.getTaxCode(), (String)I18nUtil.translate((String)"i18n_alert_cVHfoxOLV_76b200bd", (String)"\u884c\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.hasText((String)item.getTaxRate(), (String)I18nUtil.translate((String)"i18n_alert_cVHfIxOLV_379cc943", (String)"\u884c\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            this.compute(dbHead.getQuoteType(), (SaleEnquiryItem)((Object)item));
        });
        SaleEnquiryHead newDbHead = new SaleEnquiryHead();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)newDbHead));
        this.updateById((Object)dbHead);
        this.saleEnquiryItemService.updateBatchById(quoteList);
        ArrayList<PurchaseEnquiryItem> purchaseList = new ArrayList<PurchaseEnquiryItem>();
        for (SaleEnquiryItem saleItem : quoteList) {
            PurchaseEnquiryItem purchaseItem = new PurchaseEnquiryItem();
            BeanUtils.copyProperties((Object)((Object)saleItem), (Object)((Object)purchaseItem));
            purchaseItem.setHeadId(dbHead.getRelationId());
            purchaseItem.setId(saleItem.getRelationId());
            purchaseItem.setRelationId(saleItem.getId());
            purchaseItem.setElsAccount(saleItem.getToElsAccount());
            purchaseItem.setToElsAccount(saleItem.getElsAccount());
            purchaseList.add(purchaseItem);
        }
        this.purchaseEnquiryItemService.updateBatchById(purchaseList);
        this.enquirySubstituteHeadService.quote(newDbHead, quoteList);
        List<SaleEnquiryItem> needRecordList = quoteList.stream().filter(item -> "1".equals(item.getQuotePrice())).collect(Collectors.toList());
        this.saleEnquiryItemHisService.saveQuoteItemHis(dbHead, needRecordList);
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setElsAccount(TenantContext.getTenant());
        sendVO.setHeadId(dbHead.getId());
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>(1);
        toSend.put(dbHead.getRelationId(), dbHead.getToElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
        ((PurchaseEnquiryHeadServiceImpl)SpringContextUtils.getBean(PurchaseEnquiryHeadServiceImpl.class)).updateQuotedSupplier(dbHead.getRelationId());
        String url = "id=" + dbHead.getRelationId() + "&templateNumber=" + dbHead.getTemplateNumber() + "&=templateAccount" + dbHead.getTemplateAccount() + "&templateVersion=" + dbHead.getTemplateVersion();
        super.sendMessage(dbHead.getBusAccount(), "enquiry", "quote", dbHead.getId(), "enquiryBusinessDataRpcService", Arrays.asList(dbHead.getToElsAccount()));
    }

    private void compute(String quoteType, SaleEnquiryItem item) {
        item.setQuotePrice(StrUtil.isBlank((CharSequence)item.getQuotePrice()) ? "1" : item.getQuotePrice());
        if ("1".equals(item.getQuotePrice())) {
            BigDecimal taxRate = StrUtil.isBlank((CharSequence)item.getTaxRate()) ? BigDecimal.ZERO : new BigDecimal(item.getTaxRate()).divide(BigDecimal.valueOf(100L), 6, 4);
            BigDecimal requireQuantity = item.getRequireQuantity() == null ? BigDecimal.ONE : item.getRequireQuantity();
            BigDecimal price = item.getPrice();
            BigDecimal netPrice = item.getNetPrice();
            if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())) {
                Assert.hasText((String)item.getLadderPriceJson(), (String)I18nUtil.translate((String)"i18n_alert_yDVHxOLV_4e601437", (String)"\u9636\u68af\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
                JSONArray ladderPriceArray = JSONArray.parseArray((String)item.getLadderPriceJson());
                boolean flag = true;
                for (Object obj : ladderPriceArray) {
                    JSONObject ladderPriceJson = (JSONObject)obj;
                    BigDecimal ladderPrice = ladderPriceJson.getBigDecimal("price");
                    BigDecimal ladderNetPrice = ladderPriceJson.getBigDecimal("netPrice");
                    BigDecimal ladderQuantity = ladderPriceJson.getBigDecimal("ladderQuantity");
                    Assert.notNull((Object)ladderQuantity, (String)I18nUtil.translate((String)"i18n_alert_yDWRxOV_8ad66f92", (String)"\u9636\u68af\u6570\u91cf\u4e0d\u80fd\u7a7a"));
                    if (EnquiryQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType)) {
                        Assert.notNull((Object)ladderPrice, (String)I18nUtil.translate((String)"i18n_alert_yDVHsxfuxOLV_cabd5ffe", (String)"\u9636\u68af\u4fe1\u606f\u4e2d\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                        ladderNetPrice = ladderPrice.divide(BigDecimal.ONE.add(taxRate), 6, 4);
                    } else {
                        Assert.notNull((Object)ladderNetPrice, (String)I18nUtil.translate((String)"i18n_alert_yDVHsxxfuxOLV_68dce0dd", (String)"\u9636\u68af\u4fe1\u606f\u4e2d\u4e0d\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                        ladderPrice = ladderNetPrice.multiply(BigDecimal.ONE.add(taxRate)).setScale(6, 4);
                    }
                    ladderPriceJson.put("price", (Object)ladderPrice.setScale(6, 4));
                    ladderPriceJson.put("netPrice", (Object)ladderNetPrice.setScale(6, 4));
                    ladderPriceJson.put("taxAmount", (Object)ladderPrice.multiply(requireQuantity).setScale(6, 4));
                    ladderPriceJson.put("netAmount", (Object)ladderNetPrice.multiply(requireQuantity).setScale(6, 4));
                    if (requireQuantity.compareTo(ladderQuantity) < 0) continue;
                    price = ladderPrice.setScale(6, 4);
                    netPrice = ladderNetPrice.setScale(6, 4);
                    flag = false;
                }
                if (flag) {
                    price = ladderPriceArray.getJSONObject(0).getBigDecimal("price").setScale(6, 4);
                    netPrice = ladderPriceArray.getJSONObject(0).getBigDecimal("netPrice").setScale(6, 4);
                }
            }
            if (EnquiryQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType)) {
                Assert.notNull((Object)price, (String)I18nUtil.translate((String)"i18n_alert_empty_notPrice", (String)"\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                netPrice = price.divide(BigDecimal.ONE.add(taxRate), 6, 4);
            } else {
                Assert.notNull((Object)netPrice, (String)I18nUtil.translate((String)"i18n_alert_empty_notNetPrice", (String)"\u4e0d\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                price = netPrice.multiply(BigDecimal.ONE.add(taxRate)).setScale(6, 4);
            }
            item.setPrice(price.setScale(6, 4));
            item.setNetPrice(netPrice.setScale(6, 4));
            item.setTaxAmount(price.multiply(requireQuantity).setScale(6, 4));
            item.setNetAmount(netPrice.multiply(requireQuantity).setScale(6, 4));
            item.setItemStatus(EnquiryStatusEnum.QUOTED.getValue());
            item.setQuoteTime(new Date());
            item.setQuoteCount(item.getQuoteCount() == null ? 1 : item.getQuoteCount() + 1);
            item.setQuoteIp(IPUtils.getIpAddr());
        } else {
            this.cleanPrice(item);
            item.setItemStatus(EnquiryStatusEnum.CAN_NOT_QUOTE.getValue());
        }
    }

    private void cleanPrice(SaleEnquiryItem item) {
        String quotePriceWay = item.getQuotePriceWay();
        if (EnquiryQuoteWayEnum.LADDER.getValue().equals(quotePriceWay)) {
            JSONArray ladderPriceArray = StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson()) ? JSONArray.parseArray((String)item.getLadderPriceJson()) : new JSONArray();
            for (Object obj : ladderPriceArray) {
                JSONObject ladderPriceJson = (JSONObject)obj;
                ladderPriceJson.put("taxAmount", null);
                ladderPriceJson.put("netAmount", null);
                ladderPriceJson.put("price", null);
                ladderPriceJson.put("netPrice", null);
            }
        }
        item.setPrice(null);
        item.setNetPrice(null);
        item.setTaxAmount(null);
        item.setNetAmount(null);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)item.getId());
        updateWrapper.set(SaleEnquiryItem::getPrice, (Object)item.getPrice());
        updateWrapper.set(SaleEnquiryItem::getNetAmount, (Object)item.getNetAmount());
        updateWrapper.set(SaleEnquiryItem::getNetPrice, (Object)item.getNetPrice());
        updateWrapper.set(SaleEnquiryItem::getTaxAmount, (Object)item.getTaxAmount());
        updateWrapper.set(SaleEnquiryItem::getLadderPriceJson, (Object)item.getLadderPriceJson());
        this.saleEnquiryItemService.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public List<SaleEnquiryHead> updateQuoteEntTime(String purchaseHeadId, Date quoteEndTime, List<PurchaseEnquiryItem> itemList) {
        List<SaleEnquiryHead> headList = ((SaleEnquiryHeadMapper)this.baseMapper).selectByMainId(purchaseHeadId);
        headList.forEach(head -> {
            head.setQuoteEndTime(quoteEndTime);
            if (EnquiryStatusEnum.NO_QUOTE.getValue().equals(head.getEnquiryStatus())) {
                head.setEnquiryStatus(EnquiryStatusEnum.QUOTING.getValue());
            }
        });
        this.updateBatchById(headList);
        List<String> idList = itemList.stream().map(PurchaseEnquiryItem::getRelationId).collect(Collectors.toList());
        List saleItemList = this.saleEnquiryItemService.listByIds(idList);
        for (SaleEnquiryItem saleItem : saleItemList) {
            saleItem.setQuoteEndTime(quoteEndTime);
            if (!EnquiryStatusEnum.NO_QUOTE.getValue().equals(saleItem.getItemStatus())) continue;
            saleItem.setItemStatus(EnquiryStatusEnum.QUOTING.getValue());
        }
        this.saleEnquiryItemService.updateBatchById(saleItemList);
        this.enquirySubstituteHeadService.updateQuoteEntTime(purchaseHeadId, quoteEndTime, idList);
        return headList;
    }

    @Override
    public void openBid(String purchaseHeadId, List<PurchaseEnquiryItem> itemList) {
        List<SaleEnquiryHead> headList = ((SaleEnquiryHeadMapper)this.baseMapper).selectByMainId(purchaseHeadId);
        Map<String, List<SaleEnquiryHead>> accountHeadMap = headList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
        List<String> idList = itemList.stream().map(PurchaseEnquiryItem::getRelationId).collect(Collectors.toList());
        List saleItemList = this.saleEnquiryItemService.listByIds(idList);
        Map<String, List<SaleEnquiryItem>> accountItemMap = saleItemList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
        accountItemMap.forEach((key, value) -> {
            String enquiryStatus;
            List accountHeadList = (List)accountHeadMap.get(key);
            List quotingList = value.stream().filter(item -> EnquiryStatusEnum.QUOTING.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            String string = enquiryStatus = value.size() == quotingList.size() ? EnquiryStatusEnum.NO_QUOTE.getValue() : EnquiryStatusEnum.BARGAIN.getValue();
            if (CollectionUtil.isEmpty((Collection)accountHeadList)) {
                return;
            }
            accountHeadList.forEach(head -> head.setEnquiryStatus(enquiryStatus));
        });
        headList.forEach(head -> {
            String key = head.getElsAccount();
            head.setEnquiryStatus(((SaleEnquiryHead)((Object)((Object)((List)accountHeadMap.get(key)).get(0)))).getEnquiryStatus());
        });
        this.updateBatchById(headList);
        saleItemList.forEach(item -> {
            String itemStatus = EnquiryStatusEnum.QUOTING.getValue().equals(item.getItemStatus()) ? EnquiryStatusEnum.NO_QUOTE.getValue() : item.getItemStatus();
            item.setItemStatus(itemStatus);
        });
        this.saleEnquiryItemService.updateBatchById(saleItemList);
        this.enquirySubstituteHeadService.openBid(purchaseHeadId, idList);
    }

    @Override
    public Map<String, SaleEnquiryHead> reQuote(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> reQuoteList) {
        List<SaleEnquiryItem> updateList = this.getUpdateList(reQuoteList);
        this.saleEnquiryItemService.updateBatchById(updateList);
        List elsAccountList = reQuoteList.stream().map(PurchaseEnquiryItem::getToElsAccount).distinct().collect(Collectors.toList());
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SaleEnquiryHead::getEnquiryStatus, (Object)dbHead.getEnquiryStatus())).eq(SaleEnquiryHead::getRelationId, (Object)dbHead.getId())).in(BaseEntity::getElsAccount, elsAccountList));
        List headList = ((SaleEnquiryHeadMapper)this.baseMapper).selectByMainId(dbHead.getId()).stream().filter(head -> elsAccountList.contains(head.getElsAccount())).collect(Collectors.toList());
        this.enquirySubstituteHeadService.reQuote(dbHead, updateList);
        return headList.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity()));
    }

    @Override
    public void priced(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> pricedList) {
        List<SaleEnquiryItem> updateList = this.getUpdateList(pricedList);
        this.saleEnquiryItemService.updateBatchById(updateList);
        if (EnquiryStatusEnum.PRICED.getValue().equals(dbHead.getEnquiryStatus())) {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEnquiryHead::getRelationId, (Object)dbHead.getId())).set(SaleEnquiryHead::getEnquiryStatus, (Object)EnquiryStatusEnum.PRICED.getValue()));
        }
        this.enquirySubstituteHeadService.priced(dbHead, updateList);
    }

    private List<SaleEnquiryItem> getUpdateList(List<PurchaseEnquiryItem> itemList) {
        ArrayList<SaleEnquiryItem> updateList = new ArrayList<SaleEnquiryItem>();
        for (PurchaseEnquiryItem item : itemList) {
            SaleEnquiryItem saleItem = new SaleEnquiryItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)saleItem));
            saleItem.setId(item.getRelationId());
            saleItem.setElsAccount(item.getToElsAccount());
            saleItem.setRelationId(item.getId());
            saleItem.setHeadId(null);
            saleItem.setToElsAccount(item.getElsAccount());
            updateList.add(saleItem);
        }
        return updateList;
    }

    @Override
    public void cancel(String purchaseHeadId) {
        List<SaleEnquiryHead> headList = ((SaleEnquiryHeadMapper)this.baseMapper).selectByMainId(purchaseHeadId);
        if (headList.isEmpty()) {
            return;
        }
        headList.forEach(head -> head.setEnquiryStatus(EnquiryStatusEnum.CANCEL.getValue()));
        this.updateBatchById(headList);
        List headIdList = headList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.saleEnquiryItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEnquiryItem::getHeadId, headIdList)).set(SaleEnquiryItem::getItemStatus, (Object)EnquiryStatusEnum.CANCEL.getValue()));
        this.enquirySubstituteHeadService.cancel(purchaseHeadId);
    }

    @Override
    public void regret(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> webList) {
        List<SaleEnquiryItem> updateList = this.getUpdateList(webList);
        this.saleEnquiryItemService.updateBatchById(updateList);
        List elsAccountList = webList.stream().map(PurchaseEnquiryItem::getToElsAccount).distinct().collect(Collectors.toList());
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(BaseEntity::getElsAccount, elsAccountList)).eq(SaleEnquiryHead::getRelationId, (Object)head.getId())).set(SaleEnquiryHead::getEnquiryStatus, (Object)head.getEnquiryStatus()));
        this.enquirySubstituteHeadService.regret(head, updateList);
    }
}

