/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.archive.utils;

import com.els.api.dto.BaseDTO;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.archive.entity.TenderProjectArchiveAttachmentInfo;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.service.TenderProjectArchiveAttachmentInfoService;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.rpc.service.InvokeAccountRpcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchiveUtil {
    private static final Logger log = LoggerFactory.getLogger(ArchiveUtil.class);

    private ArchiveUtil() {
    }

    private static TenderProjectArchiveAttachmentInfoService getArchiveService() {
        return (TenderProjectArchiveAttachmentInfoService)SpringContextUtils.getBean(TenderProjectArchiveAttachmentInfoService.class);
    }

    public static void saveArchiveByPurchaseAttachmentDTO(List<PurchaseAttachmentDTO> attachmentDTOList, String headId, String subpackageId, String projectId, String businessType) {
        if (CollectionUtils.isEmpty(attachmentDTOList)) {
            return;
        }
        try {
            InvokeAccountRpcService accountRpcService = (InvokeAccountRpcService)SpringContextUtils.getBean(InvokeAccountRpcService.class);
            TenderProjectArchiveAttachmentInfoService archiveService = ArchiveUtil.getArchiveService();
            ArrayList archiveAttachmentInfoList = SysUtil.copyProperties(attachmentDTOList, TenderProjectArchiveAttachmentInfo.class);
            LoginUser user = SysUtil.getLoginUser();
            List tenantList = accountRpcService.getTenantList(Arrays.asList(user.getElsAccount()));
            Map tenantListMap = tenantList.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, Function.identity()));
            archiveAttachmentInfoList.stream().forEach(archiveAttachmentInfo -> {
                archiveAttachmentInfo.setSubpackageId(subpackageId);
                archiveAttachmentInfo.setTenderProjectId(projectId);
                archiveAttachmentInfo.setBusinessType(businessType);
                archiveAttachmentInfo.setFileType(ArchiveUtil.businessTypeConvert(businessType, archiveAttachmentInfo.getFileType()));
                archiveAttachmentInfo.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
                archiveAttachmentInfo.setProtocolType(TenderFlagInjectionContext.getTenderProcessType());
                archiveAttachmentInfo.setCurrentStep(TenderFlagInjectionContext.getTenderCurrentStep());
                if (StringUtils.isBlank((CharSequence)archiveAttachmentInfo.getUploadElsAccount()) && null != user) {
                    archiveAttachmentInfo.setUploadElsAccount(user.getElsAccount());
                }
                if (StringUtils.isBlank((CharSequence)archiveAttachmentInfo.getUploadSubAccount()) && null != user) {
                    archiveAttachmentInfo.setUploadSubAccount(user.getSubAccount());
                }
                archiveAttachmentInfo.setUploadEnterpriseAccount(archiveAttachmentInfo.getUploadElsAccount());
                ElsTenantDTO elsTenantDTO = (ElsTenantDTO)tenantListMap.get(archiveAttachmentInfo.getUploadElsAccount());
                if (elsTenantDTO != null) {
                    archiveAttachmentInfo.setUploadEnterpriseName(elsTenantDTO.getCompanyName());
                }
            });
            if (TenderProjectArchiveAttachmentEnum.ARCHIVE_ATTACHMENT_PREFIX.getValue().equals(businessType)) {
                List<String> ids = archiveAttachmentInfoList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                archiveService.deleteBatchByIds(ids);
            } else {
                List<String> headIds = archiveAttachmentInfoList.stream().map(TenderProjectArchiveAttachmentInfo::getHeadId).collect(Collectors.toList());
                archiveService.deleteByMainIds(headIds);
            }
            archiveService.saveBatch(archiveAttachmentInfoList, 1000);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static void saveArchiveBySaleAttachmentDTO(List<SaleAttachmentDTO> attachmentDTOList, String headId, String subpackageId, String projectId, String businessType) {
        try {
            if (CollectionUtils.isEmpty(attachmentDTOList)) {
                return;
            }
            InvokeAccountRpcService accountRpcService = (InvokeAccountRpcService)SpringContextUtils.getBean(InvokeAccountRpcService.class);
            TenderProjectArchiveAttachmentInfoService archiveService = ArchiveUtil.getArchiveService();
            LoginUser user = SysUtil.getLoginUser();
            List tenantList = accountRpcService.getTenantList(Arrays.asList(user.getElsAccount()));
            Map tenantListMap = tenantList.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, Function.identity()));
            ArrayList archiveAttachmentInfoList = SysUtil.copyProperties(attachmentDTOList, TenderProjectArchiveAttachmentInfo.class);
            archiveAttachmentInfoList.stream().forEach(archiveAttachmentInfo -> {
                archiveAttachmentInfo.setSubpackageId(subpackageId);
                archiveAttachmentInfo.setTenderProjectId(projectId);
                archiveAttachmentInfo.setBusinessType(businessType);
                archiveAttachmentInfo.setFileType(ArchiveUtil.businessTypeConvert(businessType, archiveAttachmentInfo.getFileType()));
                archiveAttachmentInfo.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
                archiveAttachmentInfo.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
                archiveAttachmentInfo.setCurrentStep(TenderFlagInjectionContext.getTenderCurrentStep());
                if (StringUtils.isBlank((CharSequence)archiveAttachmentInfo.getUploadElsAccount()) && null != user) {
                    archiveAttachmentInfo.setUploadElsAccount(user.getElsAccount());
                }
                if (StringUtils.isBlank((CharSequence)archiveAttachmentInfo.getUploadSubAccount()) && null != user) {
                    archiveAttachmentInfo.setUploadSubAccount(user.getSubAccount());
                }
                archiveAttachmentInfo.setUploadEnterpriseAccount(archiveAttachmentInfo.getUploadElsAccount());
                ElsTenantDTO elsTenantDTO = (ElsTenantDTO)tenantListMap.get(archiveAttachmentInfo.getUploadElsAccount());
                if (elsTenantDTO != null) {
                    archiveAttachmentInfo.setUploadEnterpriseName(elsTenantDTO.getCompanyName());
                }
            });
            List<String> headIds = archiveAttachmentInfoList.stream().map(TenderProjectArchiveAttachmentInfo::getHeadId).collect(Collectors.toList());
            archiveService.deleteByMainIds(headIds);
            archiveService.saveBatch(archiveAttachmentInfoList, 1000);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private static String businessTypeConvert(String businessType, String fileType) {
        String buildUpStr;
        TenderProjectArchiveAttachmentEnum archiveAttachmentEnum;
        if (StringUtils.isBlank((CharSequence)fileType)) {
            fileType = "0";
        }
        if ((archiveAttachmentEnum = TenderProjectArchiveAttachmentEnum.getTenderProjectArchiveAttachmentEnum(businessType)) == null) {
            return fileType;
        }
        StringBuilder resultFileType = new StringBuilder();
        String string = buildUpStr = archiveAttachmentEnum.isAppend() ? resultFileType.append(archiveAttachmentEnum.getValue()).append("_").append(fileType).toString() : resultFileType.append(fileType).toString();
        if ("0".equals(TenderFlagInjectionContext.getTenderCheckType())) {
            buildUpStr = TenderProjectArchiveAttachmentEnum.PREFIX_PRE.getValue() + "_" + buildUpStr;
        } else if ("1".equals(TenderFlagInjectionContext.getTenderCheckType())) {
            if ("0".equals(TenderFlagInjectionContext.getTenderProcessType())) {
                buildUpStr = TenderProjectArchiveAttachmentEnum.PREFIX_ONE_STEP.getValue() + "_" + buildUpStr;
            } else if ("1".equals(TenderFlagInjectionContext.getTenderProcessType())) {
                if ("0".equals(TenderFlagInjectionContext.getTenderCurrentStep())) {
                    buildUpStr = TenderProjectArchiveAttachmentEnum.PREFIX_TWO_STEP.getValue() + "_" + buildUpStr;
                } else if ("1".equals(TenderFlagInjectionContext.getTenderCurrentStep())) {
                    buildUpStr = TenderProjectArchiveAttachmentEnum.PREFIX_RESULT_TWO_STEP.getValue() + "_" + buildUpStr;
                }
            }
        }
        return buildUpStr;
    }
}

