/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationRegulationInfo;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatQuoteTypeEnum;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterFormatGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationGroupService;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderEvaluationGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderProjectAttachmentHeadViewVO;
import com.els.modules.tender.common.service.PurchaseTenderDataParse;
import com.els.modules.tender.common.service.impl.PurchaseTenderTemplateParsetImpl;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaExpertTask;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaSettingHead;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectJuryHead;
import com.els.modules.tender.evaluation.enumerate.TenderEvaGroupTypeEnum;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaHeadService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaRegulationResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaExpertTaskService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaInfoService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaSettingHeadService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectJuryHeadService;
import com.els.modules.tender.evaluation.vo.EvaGroupVO;
import com.els.modules.tender.evaluation.vo.EvaLeaderOpinionVO;
import com.els.modules.tender.evaluation.vo.EvaResultVO;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectBidEvaRegulationResultVO;
import com.els.modules.tender.evaluation.vo.SummaryEvaGroupResultVO;
import com.els.modules.tender.evaluation.vo.SupplierEvaGroupResultVO;
import com.els.modules.tender.evaluation.vo.SupplierEvaRankingVO;
import com.els.modules.tender.evaluation.vo.SupplierVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.tender.template.entity.PurchaseTenderVariableLibrary;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseTenderDataParseEvaBiddingImpl
implements PurchaseTenderDataParse {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderDataParseEvaBiddingImpl.class);
    @Autowired
    private PurchaseTenderProjectJuryHeadService projectJuryHeadService;
    @Autowired
    private PurchaseTenderProjectEvaSettingHeadService evaSettingHeadService;
    @Autowired
    private TenderProjectSupplierService projectSupplierService;
    @Autowired
    private PurchaseTenderProjectBidEvaHeadService bidEvaHeadService;
    @Autowired
    PurchaseTenderEvaluationGroupService purchaseTenderEvaluationGroupService;
    @Autowired
    PurchaseTenderProjectEvaInfoService purchaseTenderProjectEvaInfoService;
    @Autowired
    PurchaseTenderProjectBidEvaRegulationResultService bidEvaRegulationResultService;
    @Autowired
    PurchaseTenderProjectEvaExpertTaskService tenderProjectEvaExpertTaskService;
    @Autowired
    PurchaseTenderBidLetterFormatGroupService bidLetterFormatGroupService;

    @Override
    public void parse(String businessId, Map<String, Object> dataSource, List<String> variableList, List<PurchaseTenderVariableLibrary> lists, Map<String, Object> paramMap) {
        List<String> paramNameList = lists.stream().map(PurchaseTenderVariableLibrary::getParamName).collect(Collectors.toList());
        if (dataSource.get("subpackageName") == null) {
            PurchaseTenderProjectSubpackageInfo subpackageInfo = PurchaseTenderTemplateParsetImpl.subpackageInfoThreadLocal.get();
            dataSource.put("subpackageName", subpackageInfo.getSubpackageName());
            dataSource.put("subpackageNumber", subpackageInfo.getSubpackageNumber());
        }
        LambdaQueryWrapper juryQueryWrapper = new LambdaQueryWrapper();
        juryQueryWrapper.eq(PurchaseTenderProjectJuryHead::getSubpackageId, (Object)businessId);
        List juryHeads = this.projectJuryHeadService.list((Wrapper)juryQueryWrapper);
        LambdaQueryWrapper evaSettingQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)evaSettingQueryWrapper.eq(PurchaseTenderProjectEvaSettingHead::getSubpackageId, (Object)businessId)).eq(PurchaseTenderProjectEvaSettingHead::getHeadStatus, (Object)"1");
        List evaSettingHeads = this.evaSettingHeadService.list((Wrapper)evaSettingQueryWrapper);
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(businessId);
        List<TenderProjectSupplier> tenderProjectSuppliers = this.projectSupplierService.selectBySubpackageId(querySupplier);
        this.setDataByPre(businessId, dataSource, juryHeads, evaSettingHeads, tenderProjectSuppliers, paramNameList);
        this.setDataByPostTrial(businessId, dataSource, juryHeads, evaSettingHeads, tenderProjectSuppliers, paramNameList);
    }

    private void setDataByPostTrial(String businessId, Map<String, Object> dataSource, List<PurchaseTenderProjectJuryHead> juryHeads, List<PurchaseTenderProjectEvaSettingHead> evaSettingHeads, List<TenderProjectSupplier> tenderProjectSuppliers, List<String> paramNameList) {
        PurchaseTenderProjectJuryHead juryHead = juryHeads.stream().filter(projectJuryHead -> SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(projectJuryHead.getCheckType())).findFirst().orElse(new PurchaseTenderProjectJuryHead());
        dataSource.put("countTotal", juryHead.getCountTotal() == null ? 0 : juryHead.getCountTotal());
        dataSource.put("bidRepresentTotal", juryHead.getBidRepresentTotal() == null ? 0 : juryHead.getBidRepresentTotal());
        dataSource.put("evaExpertTotal", juryHead.getEvaExpertTotal() == null ? 0 : juryHead.getEvaExpertTotal());
        List postTrialEvaSettingHeads = evaSettingHeads.stream().filter(preEvaSettingHead -> SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(preEvaSettingHead.getCheckType())).collect(Collectors.toList());
        postTrialEvaSettingHeads.stream().filter(preEvaSettingHead -> SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(preEvaSettingHead.getCheckType())).collect(Collectors.toList());
        Map<String, String> judgesMap = postTrialEvaSettingHeads.stream().collect(Collectors.toMap(PurchaseTenderProjectEvaSettingHead::getJudgesElsSubAccount, PurchaseTenderProjectEvaSettingHead::getJudgesName, (v1, v2) -> v2));
        dataSource.put("juryRoster", CollectionUtil.join(judgesMap.values(), (CharSequence)","));
        PurchaseTenderProjectEvaSettingHead oneStepEvaSettingHead = postTrialEvaSettingHeads.stream().filter(preEvaSettingHead -> "1".equals(preEvaSettingHead.getJudgesGroupLeader()) && SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(preEvaSettingHead.getCurrentStep())).findFirst().orElse(new PurchaseTenderProjectEvaSettingHead());
        dataSource.put("oneStepJudgesGroupLeader", oneStepEvaSettingHead.getJudgesName() == null ? "" : oneStepEvaSettingHead.getJudgesName());
        PurchaseTenderProjectEvaSettingHead resultEvaSettingHead = postTrialEvaSettingHeads.stream().filter(preEvaSettingHead -> "1".equals(preEvaSettingHead.getJudgesGroupLeader()) && !SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(preEvaSettingHead.getCurrentStep())).findFirst().orElse(new PurchaseTenderProjectEvaSettingHead());
        dataSource.put("judgesGroupLeader", resultEvaSettingHead.getJudgesName() == null ? "" : resultEvaSettingHead.getJudgesName());
        List oneStepShortlistedSupplierList = tenderProjectSuppliers.stream().filter(suppler -> "1".equals(suppler.getShortlisted())).collect(Collectors.toList());
        List oneStepShortlistedSupplierNameList = oneStepShortlistedSupplierList.stream().map(TenderProjectSupplier::getSupplierName).collect(Collectors.toList());
        dataSource.put("oneStepShortlistedSupplierList", CollectionUtil.join(oneStepShortlistedSupplierNameList, (CharSequence)"<br>"));
        List shortlistedSupplierList = tenderProjectSuppliers.stream().filter(suppler -> "1".equals(suppler.getResultShortlisted())).collect(Collectors.toList());
        List shortlistedSupplierNameList = shortlistedSupplierList.stream().map(TenderProjectSupplier::getSupplierName).collect(Collectors.toList());
        dataSource.put("shortlistedSupplierList", CollectionUtil.join(shortlistedSupplierNameList, (CharSequence)"<br>"));
        if (paramNameList.contains("${\u7b2c\u4e00\u6b65\u8bc4\u5ba1\u6392\u540d\u8868}")) {
            this.reviewRank(businessId, dataSource, oneStepEvaSettingHead.getEvaInfoId(), SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue(), false);
        }
        if (paramNameList.contains("${\u7b2c\u4e00\u6b65\u8bc4\u5ba1\u8be6\u7ec6\u8bb0\u5f55\u53ca\u6392\u540d}")) {
            this.evaRecordAndRank(businessId, dataSource, oneStepEvaSettingHead.getEvaInfoId(), SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue());
        }
        if (paramNameList.contains("${\u7b2c\u4e8c\u6b65\u8bc4\u5ba1\u6392\u540d\u8868}") || paramNameList.contains("${\u8bc4\u5ba1\u6392\u540d\u8868}")) {
            this.reviewRank(businessId, dataSource, resultEvaSettingHead.getEvaInfoId(), SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue(), false);
        }
        if (paramNameList.contains("${\u7b2c\u4e8c\u6b65\u8bc4\u5ba1\u8be6\u7ec6\u8bb0\u5f55\u53ca\u6392\u540d}") || paramNameList.contains("${\u8bc4\u5ba1\u8be6\u7ec6\u8bb0\u5f55\u53ca\u6392\u540d}")) {
            this.evaRecordAndRank(businessId, dataSource, resultEvaSettingHead.getEvaInfoId(), SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue());
        }
    }

    private void setDataByPre(String businessId, Map<String, Object> dataSource, List<PurchaseTenderProjectJuryHead> juryHeads, List<PurchaseTenderProjectEvaSettingHead> evaSettingHeads, List<TenderProjectSupplier> tenderProjectSuppliers, List<String> paramNameList) {
        this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue(), null, null);
        PurchaseTenderProjectJuryHead juryHead = juryHeads.stream().filter(projectJuryHead -> SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(projectJuryHead.getCheckType())).findFirst().orElse(new PurchaseTenderProjectJuryHead());
        dataSource.put("preCountTotal", juryHead.getCountTotal() == null ? 0 : juryHead.getCountTotal());
        dataSource.put("preBidRepresentTotal", juryHead.getBidRepresentTotal() == null ? 0 : juryHead.getBidRepresentTotal());
        dataSource.put("preEvaExpertTotal", juryHead.getEvaExpertTotal() == null ? 0 : juryHead.getEvaExpertTotal());
        List preEvaSettingHeads = evaSettingHeads.stream().filter(preEvaSettingHead -> SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(preEvaSettingHead.getCheckType())).collect(Collectors.toList());
        List judgesNames = preEvaSettingHeads.stream().map(PurchaseTenderProjectEvaSettingHead::getJudgesName).collect(Collectors.toList());
        dataSource.put("preJuryRoster", CollectionUtil.join(judgesNames, (CharSequence)","));
        PurchaseTenderProjectEvaSettingHead judgesGroupLeader = preEvaSettingHeads.stream().filter(projectJuryHead -> "1".equals(projectJuryHead.getJudgesGroupLeader())).findFirst().orElse(new PurchaseTenderProjectEvaSettingHead());
        dataSource.put("preJudgesGroupLeader", judgesGroupLeader.getJudgesName() == null ? "" : judgesGroupLeader.getJudgesName());
        List preShortlistedSupplierList = tenderProjectSuppliers.stream().filter(suppler -> "1".equals(suppler.getPreShortlisted())).collect(Collectors.toList());
        List preShortlistedSupplierNameList = preShortlistedSupplierList.stream().map(TenderProjectSupplier::getSupplierName).collect(Collectors.toList());
        dataSource.put("preShortlistedSupplierList", CollectionUtil.join(preShortlistedSupplierNameList, (CharSequence)"<br>"));
        if (paramNameList.contains("${\u9884\u5ba1\u8bc4\u5ba1\u6392\u540d\u8868}")) {
            this.reviewRank(businessId, dataSource, judgesGroupLeader.getEvaInfoId(), SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue(), SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue(), false);
        }
        if (paramNameList.contains("${\u9884\u5ba1\u8bc4\u6807\u8be6\u7ec6\u8bb0\u5f55\u53ca\u6392\u540d}")) {
            this.evaRecordAndRank(businessId, dataSource, judgesGroupLeader.getEvaInfoId(), SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue(), SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue());
        }
    }

    private Map<String, List<List<Object>>> reviewRank(String businessId, Map<String, Object> dataSource, String evaInfoId, String chekcType, String currentStep, boolean isReviewRankQuery) {
        List evaGroupVOS;
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(chekcType);
        boolean hasFirstStep = SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(currentStep);
        String requestType = "0";
        if (hasPreTrial) {
            this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue(), null, null);
        } else if (hasFirstStep) {
            this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoProcessTypeEnum.TWO_STEP.getValue(), SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue());
        } else {
            requestType = "1";
            PurchaseTenderProjectSubpackageInfo subpackageInfo = PurchaseTenderTemplateParsetImpl.subpackageInfoThreadLocal.get();
            if (SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(subpackageInfo.getProcessType())) {
                this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoProcessTypeEnum.TWO_STEP.getValue(), SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue());
            } else {
                this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoProcessTypeEnum.ONE_STEP.getValue(), null);
            }
        }
        try {
            evaGroupVOS = this.evaSettingHeadService.queryEvaGroupBySubpackageId(businessId, requestType);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            evaGroupVOS = Collections.EMPTY_LIST;
        }
        ArrayList<String> reviewRankThList = new ArrayList<String>();
        reviewRankThList.add("\u5e8f\u53f7");
        reviewRankThList.add("\u4f9b\u5e94\u5546\u540d\u79f0");
        ArrayList reviewRankTrList = new ArrayList();
        for (EvaGroupVO evaGroupVO : evaGroupVOS) {
            reviewRankThList.add(evaGroupVO.getName());
        }
        reviewRankThList.add("\u603b\u5206");
        reviewRankThList.add("\u6392\u540d");
        try {
            EvaResultVO evaResultVO = this.bidEvaHeadService.getSupplierEvaRanking(evaInfoId);
            List<SupplierEvaRankingVO> supplierEvaRanking = evaResultVO.getSupplierEvaRanking();
            int serialNo = 0;
            for (SupplierEvaRankingVO supplierEvaRankingVO : supplierEvaRanking) {
                Map<String, SupplierEvaRankingVO.EvaGroupSummaryResult> result = supplierEvaRankingVO.getResult();
                ArrayList<Object> preReviewRankTdList = new ArrayList<Object>();
                preReviewRankTdList.add(++serialNo);
                preReviewRankTdList.add(supplierEvaRankingVO.getSupplierName());
                for (EvaGroupVO evaGroupVO : evaGroupVOS) {
                    SupplierEvaRankingVO.EvaGroupSummaryResult evaGroupSummaryResult = result.get(evaGroupVO.getId());
                    if (TenderEvaGroupTypeEnum.REVIEW.getValue().equals(evaGroupSummaryResult.getEvaGroupType())) {
                        preReviewRankTdList.add("1".equals(evaGroupSummaryResult.getEvaGroupResult()) ? "\u901a\u8fc7" : "\u4e0d\u901a\u8fc7");
                        continue;
                    }
                    preReviewRankTdList.add(evaGroupSummaryResult.getTotalScore());
                }
                preReviewRankTdList.add(supplierEvaRankingVO.getTotalScore());
                preReviewRankTdList.add(supplierEvaRankingVO.getOrder());
                reviewRankTrList.add(preReviewRankTdList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6a21\u677f\u89e3\u6790\u8bc4\u5ba1\u6392\u540d\u8868{}", (Object)e.getMessage());
        }
        HashMap<String, List<List<Object>>> tableMap = new HashMap<String, List<List<Object>>>();
        if (isReviewRankQuery) {
            ArrayList allList = new ArrayList();
            allList.add(reviewRankThList);
            allList.addAll(reviewRankTrList);
            tableMap.put("\u8bc4\u5ba1\u6392\u540d\u8868", allList);
        } else if (hasPreTrial) {
            dataSource.put("preReviewRankThList", reviewRankThList);
            dataSource.put("preReviewRankTrList", reviewRankTrList);
        } else if (hasFirstStep) {
            dataSource.put("oneStepReviewRankThList", reviewRankThList);
            dataSource.put("oneStepReviewRankTrList", reviewRankTrList);
        } else {
            dataSource.put("reviewRankThList", reviewRankThList);
            dataSource.put("reviewRankTrList", reviewRankTrList);
        }
        return tableMap;
    }

    private void evaRecordAndRank(String businessId, Map<String, Object> dataSource, String evaInfoId, String chekcType, String currentStep) {
        List evaGroupVOS;
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(chekcType);
        boolean hasFirstStep = SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(currentStep);
        String requestType = "0";
        if (hasPreTrial) {
            this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue(), null, null);
        } else if (hasFirstStep) {
            this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoProcessTypeEnum.TWO_STEP.getValue(), SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue());
        } else {
            PurchaseTenderProjectSubpackageInfo subpackageInfo = PurchaseTenderTemplateParsetImpl.subpackageInfoThreadLocal.get();
            if (SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(subpackageInfo.getProcessType())) {
                currentStep = SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue();
                this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoProcessTypeEnum.TWO_STEP.getValue(), currentStep);
            } else {
                currentStep = null;
                this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoProcessTypeEnum.ONE_STEP.getValue(), null);
            }
            requestType = "1";
        }
        try {
            evaGroupVOS = this.evaSettingHeadService.queryEvaGroupBySubpackageId(businessId, requestType);
            if (SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(currentStep)) {
                evaGroupVOS = evaGroupVOS.stream().filter(evaGroupVO -> SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(evaGroupVO.getCurrentStep())).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            evaGroupVOS = Collections.EMPTY_LIST;
        }
        ArrayList<Map<Object, Object>> evaGroupResultList = new ArrayList<Map<Object, Object>>();
        ArrayList<HashMap<String, List<List<Object>>>> evaGroupResulDesctList = new ArrayList<HashMap<String, List<List<Object>>>>();
        List<PurchaseTenderProjectEvaExpertTask> purchaseTenderProjectEvaExpertTasks = this.tenderProjectEvaExpertTaskService.selectByEvaInfoId(evaInfoId);
        Map<String, List<PurchaseTenderProjectEvaExpertTask>> groupTaskMap = purchaseTenderProjectEvaExpertTasks.stream().collect(Collectors.groupingBy(PurchaseTenderProjectEvaExpertTask::getEvaGroupId));
        List<PurchaseTenderProjectBidEvaRegulationResult> purchaseTenderProjectBidEvaRegulationResults = this.bidEvaRegulationResultService.selectBySubpackageId(businessId, null);
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> groupRegulationResultMap = purchaseTenderProjectBidEvaRegulationResults.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getEvaGroupId));
        for (EvaGroupVO evaGroupVO2 : evaGroupVOS) {
            boolean hasPriceStrategy;
            List bidEvaRegulationResults = groupRegulationResultMap.get(evaGroupVO2.getId());
            if (CollectionUtil.isEmpty(bidEvaRegulationResults)) {
                bidEvaRegulationResults = Collections.EMPTY_LIST;
            }
            Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> regulationMap = bidEvaRegulationResults.stream().collect(Collectors.groupingBy(bidEvaRegulationResult -> bidEvaRegulationResult.getRegulationId() + "_" + bidEvaRegulationResult.getSupplierAccount()));
            Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> scoreRegulationMap = bidEvaRegulationResults.stream().collect(Collectors.groupingBy(bidEvaRegulationResult -> bidEvaRegulationResult.getJudgesElsAccount() + "_" + bidEvaRegulationResult.getJudgesElsSubAccount() + "_" + bidEvaRegulationResult.getSupplierAccount()));
            PurchaseTenderProjectAttachmentHeadViewVO purchaseTenderProjectAttachmentHeadViewVO = this.bidLetterFormatGroupService.queryBidLetterFormatGroup(businessId);
            PurchaseTenderBidLetterFormatGroupVO tenderBidLetterFormatGroupVo = purchaseTenderProjectAttachmentHeadViewVO.getTenderBidLetterFormatGroupVo();
            SummaryEvaGroupResultVO supplierEvaGroupResultVO = this.bidEvaHeadService.querySummaryEvaGroupResultByGroupId(evaGroupVO2.getId(), evaInfoId);
            EvaLeaderOpinionVO evaLeaderOpinionVO = this.bidEvaHeadService.queryLeaderOpinion(evaInfoId, evaGroupVO2.getId());
            List<SupplierVO> supplierList = supplierEvaGroupResultVO.getSupplierList();
            ArrayList<Object> evaRecordThList = new ArrayList<Object>();
            ArrayList<Object> evaRecordDescList = new ArrayList<Object>();
            ArrayList<List<Object>> evaRecordTrList = new ArrayList<List<Object>>();
            ArrayList<List<Object>> evaRecordDescTrList = new ArrayList<List<Object>>();
            evaRecordTrList.add(evaRecordThList);
            evaRecordDescTrList.add(evaRecordThList);
            evaRecordDescTrList.add(evaRecordDescList);
            evaRecordThList.add("\u5e8f\u53f7");
            int evaGroupResultCount = 1;
            boolean bl = hasPriceStrategy = TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue().equals(evaGroupVO2.getType()) || TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue().equals(evaGroupVO2.getType());
            if (hasPriceStrategy) {
                this.priceStrategy(purchaseTenderProjectEvaExpertTasks, evaGroupVO2, tenderBidLetterFormatGroupVo, evaRecordThList, evaGroupResultCount, supplierList, evaRecordTrList, evaLeaderOpinionVO, evaRecordDescTrList);
            } else {
                boolean hasDetailShow;
                this.evaReviewAndScore(evaGroupVO2, evaRecordThList, evaRecordTrList, supplierList, evaRecordDescList, supplierEvaGroupResultVO, evaGroupResultCount, scoreRegulationMap, regulationMap, evaRecordDescTrList, evaLeaderOpinionVO);
                boolean bl2 = hasDetailShow = TenderEvaGroupTypeEnum.REVIEW.getValue().equals(evaGroupVO2.getType()) || TenderEvaGroupTypeEnum.SCORE.getValue().equals(evaGroupVO2.getType());
                if (hasDetailShow) {
                    HashMap<String, List<List<Object>>> descTableMap = new HashMap<String, List<List<Object>>>();
                    this.evaReviewAndScoreDesc(evaGroupVO2, purchaseTenderProjectEvaExpertTasks, descTableMap);
                    if (CollectionUtil.isNotEmpty(descTableMap)) {
                        evaGroupResulDesctList.add(descTableMap);
                    }
                }
            }
            HashMap<String, ArrayList<List<Object>>> tableMap = new HashMap<String, ArrayList<List<Object>>>();
            String key = evaGroupVO2.getName();
            if (!TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue().equals(evaGroupVO2.getType()) && !TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue().equals(evaGroupVO2.getType())) {
                key = key + "-\u6c47\u603b";
            }
            if (!TenderEvaGroupTypeEnum.REVIEW.getValue().equals(evaGroupVO2.getType()) && !TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue().equals(evaGroupVO2.getType())) {
                key = key + "\uff08\u603b\u5206" + evaGroupVO2.getScore() + "\uff09";
            }
            tableMap.put(key, evaRecordTrList);
            evaGroupResultList.add(tableMap);
        }
        Map<String, List<List<Object>>> listMap = this.reviewRank(businessId, dataSource, evaInfoId, chekcType, currentStep, true);
        evaGroupResultList.add(listMap);
        if (hasPreTrial) {
            dataSource.put("preEvaGroupResultList", evaGroupResultList);
            dataSource.put("preEvaGroupResulDesctList", evaGroupResulDesctList);
        } else if (hasFirstStep) {
            dataSource.put("oneStepEvaGroupResultList", evaGroupResultList);
            dataSource.put("oneStepEvaGroupResulDesctList", evaGroupResulDesctList);
        } else {
            dataSource.put("evaGroupResultList", evaGroupResultList);
            dataSource.put("evaGroupResulDesctList", evaGroupResulDesctList);
        }
    }

    private void priceStrategy(List<PurchaseTenderProjectEvaExpertTask> purchaseTenderProjectEvaExpertTasks, EvaGroupVO evaGroupVO, PurchaseTenderBidLetterFormatGroupVO tenderBidLetterFormatGroupVo, List<Object> evaRecordThList, int evaGroupResultCount, List<SupplierVO> supplierList, List<List<Object>> evaRecordTrList, EvaLeaderOpinionVO evaLeaderOpinionVO, List<List<Object>> evaRecordDescTrList) {
        String evaRecordThName;
        SupplierEvaGroupResultVO evaGroupResultVO;
        if (CollectionUtil.isNotEmpty(purchaseTenderProjectEvaExpertTasks)) {
            PurchaseTenderProjectEvaExpertTask purchaseTenderProjectEvaExpertTask = purchaseTenderProjectEvaExpertTasks.stream().filter(evaExpertTask -> evaGroupVO.getId().equals(evaExpertTask.getEvaGroupId()) && "1".equals(evaExpertTask.getJudgesGroupLeader())).findFirst().orElse(new PurchaseTenderProjectEvaExpertTask());
            evaGroupResultVO = this.bidEvaHeadService.querySupplierResultByGroupId(evaGroupVO.getId(), purchaseTenderProjectEvaExpertTask.getId());
        } else {
            evaGroupResultVO = new SupplierEvaGroupResultVO();
        }
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResultVO>> evaResultListMap = evaGroupResultVO.getEvaResultListMap();
        if (CollectionUtil.isEmpty(evaResultListMap)) {
            evaResultListMap = new HashMap<String, List<PurchaseTenderProjectBidEvaRegulationResultVO>>();
        }
        if (BidLetterFormatQuoteTypeEnum.ITEMIZED_QUOTATION.getValue().equals(tenderBidLetterFormatGroupVo.getQuoteType())) {
            boolean hasPriceReview = TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue().equals(evaGroupVO.getType());
            evaRecordThName = hasPriceReview ? "\u7269\u6599\u540d\u79f0/\u5f97\u5206" : "\u7269\u6599\u540d\u79f0/\u6392\u540d";
            evaRecordThList.add(evaRecordThName);
            ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO> allSupplierMaterialList = new ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO>();
            if (CollectionUtil.isNotEmpty(evaResultListMap)) {
                for (List<PurchaseTenderProjectBidEvaRegulationResultVO> list : evaResultListMap.values()) {
                    allSupplierMaterialList.addAll(list.get(0).getSupplierMaterialList());
                }
            }
            Map<String, List<PurchaseTenderProjectBidEvaRegulationResultVO>> materialMap = allSupplierMaterialList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getMaterialId));
            for (List<PurchaseTenderProjectBidEvaRegulationResultVO> list : materialMap.values()) {
                ArrayList<Object> evaRecordTdList = new ArrayList<Object>();
                evaRecordTdList.add(evaGroupResultCount);
                evaRecordTdList.add(list.get(0).getMaterialName());
                Map<String, PurchaseTenderProjectBidEvaRegulationResultVO> suppliermaterialMap = list.stream().collect(Collectors.toMap(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount, suppliermaterial -> suppliermaterial, (o1, o2) -> o1));
                for (SupplierVO supplierVO : supplierList) {
                    PurchaseTenderProjectBidEvaRegulationResultVO bidEvaRegulationResultVO = suppliermaterialMap.get(supplierVO.getSupplierAccount());
                    if (bidEvaRegulationResultVO == null) {
                        evaRecordTdList.add("/");
                        continue;
                    }
                    if (hasPriceReview) {
                        evaRecordTdList.add(bidEvaRegulationResultVO.getScore() == null ? "/" : bidEvaRegulationResultVO.getScore());
                        continue;
                    }
                    evaRecordTdList.add(bidEvaRegulationResultVO.getOrderBy() == null ? "/" : bidEvaRegulationResultVO.getOrderBy());
                }
                ++evaGroupResultCount;
                evaRecordTrList.add((List<Object>)evaRecordTdList);
            }
            if (hasPriceReview) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(++evaGroupResultCount);
                arrayList.add("\u6743\u91cd");
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(++evaGroupResultCount);
                arrayList2.add("\u5b9e\u9645\u5f97\u5206");
                for (SupplierVO supplierVO : supplierList) {
                    List<PurchaseTenderProjectBidEvaRegulationResultVO> bidEvaRegulationResultVOList = evaResultListMap.get(supplierVO.getSupplierAccount());
                    BigDecimal weight = null;
                    BigDecimal evaScore = null;
                    if (CollectionUtil.isNotEmpty(bidEvaRegulationResultVOList)) {
                        PurchaseTenderProjectBidEvaRegulationResultVO bidEvaRegulationResultVO = bidEvaRegulationResultVOList.get(0);
                        weight = bidEvaRegulationResultVO.getWeight();
                        evaScore = bidEvaRegulationResultVO.getWeightScore();
                    }
                    arrayList.add(weight == null ? "" : weight + "%");
                    arrayList2.add(evaScore == null ? "/" : evaScore);
                }
                evaRecordTrList.add(arrayList);
                evaRecordTrList.add(arrayList2);
            }
        } else {
            evaRecordThName = "\u8bc4\u6807\u6761\u4f8b";
            evaRecordThList.add(evaRecordThName);
            List<Object> rowName = Arrays.asList("\u6295\u6807\u62a5\u4ef7", "\u4fee\u6b63\u91d1\u989d", "\u8bc4\u6807\u4ef7", "\u57fa\u51c6\u4ef7", "\u6743\u91cd", "\u5b9e\u9645\u5f97\u5206");
            for (int i = 0; i < rowName.size(); ++i) {
                ArrayList<Object> evaRecordTdList = new ArrayList<Object>();
                evaRecordTdList.add(evaGroupResultCount);
                evaRecordTdList.add(rowName.get(i));
                for (SupplierVO supplierVO : supplierList) {
                    List<PurchaseTenderProjectBidEvaRegulationResultVO> bidEvaRegulationResultVOList = evaResultListMap.get(supplierVO.getSupplierAccount());
                    if (CollectionUtil.isNotEmpty(bidEvaRegulationResultVOList)) {
                        PurchaseTenderProjectBidEvaRegulationResultVO bidEvaRegulationResultVO = bidEvaRegulationResultVOList.get(0);
                        switch (i) {
                            case 0: {
                                evaRecordTdList.add(bidEvaRegulationResultVO.getQuote() == null ? "/" : bidEvaRegulationResultVO.getQuote());
                                break;
                            }
                            case 1: {
                                evaRecordTdList.add(bidEvaRegulationResultVO.getPriceCorrection() == null ? "/" : bidEvaRegulationResultVO.getPriceCorrection());
                                break;
                            }
                            case 2: {
                                evaRecordTdList.add(bidEvaRegulationResultVO.getEvaPrice() == null ? "/" : bidEvaRegulationResultVO.getEvaPrice());
                                break;
                            }
                            case 3: {
                                evaRecordTdList.add(bidEvaRegulationResultVO.getBasePrice() == null ? "/" : bidEvaRegulationResultVO.getBasePrice());
                                break;
                            }
                            case 4: {
                                evaRecordTdList.add(bidEvaRegulationResultVO.getWeight() == null ? "/" : bidEvaRegulationResultVO.getWeight());
                                break;
                            }
                            case 5: {
                                evaRecordTdList.add(bidEvaRegulationResultVO.getScore() == null ? "/" : bidEvaRegulationResultVO.getScore());
                                break;
                            }
                            default: {
                                evaRecordTdList.add("");
                                break;
                            }
                        }
                        continue;
                    }
                    evaRecordTdList.add("");
                }
                ++evaGroupResultCount;
                evaRecordTrList.add(evaRecordTdList);
            }
        }
        for (SupplierVO supplierVO : supplierList) {
            evaRecordThList.add(supplierVO.getSupplierName());
        }
        ArrayList<Object> lastTrList = new ArrayList<Object>();
        lastTrList.add(evaGroupResultCount);
        lastTrList.add("\u8bc4\u5ba1\u8bf4\u660e");
        String opinion = "";
        if (evaLeaderOpinionVO != null) {
            opinion = evaLeaderOpinionVO.getOpinion() == null ? "" : evaLeaderOpinionVO.getOpinion();
        }
        lastTrList.add(opinion);
        evaRecordTrList.add(lastTrList);
        evaRecordDescTrList.add(lastTrList);
    }

    private void evaReviewAndScore(EvaGroupVO evaGroupVO, List<Object> evaRecordThList, List<List<Object>> evaRecordTrList, List<SupplierVO> supplierList, List<Object> evaRecordDescList, SummaryEvaGroupResultVO supplierEvaGroupResultVO, int evaGroupResultCount, Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> scoreRegulationMap, Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> regulationMap, List<List<Object>> evaRecordDescTrList, EvaLeaderOpinionVO evaLeaderOpinionVO) {
        boolean bl;
        ArrayList<Object> evaRecordTdList;
        boolean hasScore = TenderEvaGroupTypeEnum.SCORE.getValue().equals(evaGroupVO.getType()) && "0".equals(evaGroupVO.getSummaryCalType());
        boolean hasDetailShow = TenderEvaGroupTypeEnum.REVIEW.getValue().equals(evaGroupVO.getType()) || TenderEvaGroupTypeEnum.SCORE.getValue().equals(evaGroupVO.getType()) && !"0".equals(evaGroupVO.getSummaryCalType());
        String evaRecordThName = hasScore && !hasDetailShow ? "\u8bc4\u59d4\u540d\u79f0" : "\u8bc4\u6807\u6761\u4f8b";
        evaRecordThList.add(evaRecordThName);
        for (SupplierVO supplierVO : supplierList) {
            evaRecordThList.add(supplierVO.getSupplierName());
            evaRecordDescList.add("\u8bc4\u5ba1\u5185\u5bb9");
            evaRecordDescList.add("\u8bc4\u5ba1\u63cf\u8ff0");
        }
        List<Map<String, Object>> resultList = supplierEvaGroupResultVO.getResultList();
        for (Map<String, Object> map : resultList) {
            evaRecordTdList = new ArrayList<Object>();
            ArrayList<Object> evaRecordDescTdList = new ArrayList<Object>();
            evaRecordTdList.add(evaGroupResultCount);
            evaRecordDescTdList.add(evaGroupResultCount);
            Iterator<SupplierVO> evaluationName = map.get("name");
            evaRecordTdList.add(evaluationName);
            evaRecordDescTdList.add(evaluationName);
            for (SupplierVO supplierVO : supplierList) {
                Object resultStr;
                Object supplierResult;
                String supplierResultKey;
                String supplierAccount = supplierVO.getSupplierAccount();
                if (TenderEvaGroupTypeEnum.REVIEW.getValue().equals(evaGroupVO.getType()) || TenderEvaGroupTypeEnum.REVIEW_SCORE.getValue().equals(evaGroupVO.getType())) {
                    supplierResultKey = supplierAccount + "_result";
                    supplierResult = map.get(supplierResultKey);
                    resultStr = "1".equals(supplierResult) ? "\u7b26\u5408" : "\u4e0d\u7b26\u5408";
                    evaRecordTdList.add(resultStr);
                    evaRecordDescTdList.add(resultStr);
                } else {
                    supplierResultKey = supplierAccount + "_totalScope";
                    supplierResult = map.get(supplierResultKey);
                    resultStr = supplierResult == null ? "/" : supplierResult;
                    evaRecordTdList.add(resultStr);
                    evaRecordDescTdList.add(resultStr);
                }
                List<PurchaseTenderProjectBidEvaRegulationResult> evaRegulationResultList = hasScore ? scoreRegulationMap.get(map.get("id") + "_" + supplierVO.getSupplierAccount()) : regulationMap.get(map.get("id") + "_" + supplierVO.getSupplierAccount());
                String descResult = "";
                if (CollectionUtil.isNotEmpty(evaRegulationResultList)) {
                    for (PurchaseTenderProjectBidEvaRegulationResult evaRegulationResult : evaRegulationResultList) {
                        if (evaRegulationResult.getRemark() != null) continue;
                        evaRegulationResult.setRemark("");
                    }
                    descResult = evaRegulationResultList.stream().map(PurchaseTenderProjectBidEvaRegulationResult::getRemark).collect(Collectors.joining("<br/>"));
                }
                evaRecordDescTdList.add(descResult);
            }
            evaRecordTrList.add(evaRecordTdList);
            evaRecordDescTrList.add(evaRecordDescTdList);
            ++evaGroupResultCount;
        }
        boolean bl2 = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(evaGroupResultCount);
        arrayList.add("\u6743\u91cd");
        evaRecordTdList = new ArrayList();
        evaRecordTdList.add(evaGroupResultCount);
        evaRecordTdList.add("\u7ed3\u8bba");
        ArrayList<Object> lastTrList = new ArrayList<Object>();
        lastTrList.add(evaGroupResultCount);
        lastTrList.add("\u8bc4\u5ba1\u8bf4\u660e");
        for (SupplierVO supplierVO : supplierList) {
            if (TenderEvaGroupTypeEnum.REVIEW.getValue().equals(evaGroupVO.getType()) || TenderEvaGroupTypeEnum.REVIEW_SCORE.getValue().equals(evaGroupVO.getType())) {
                evaRecordTdList.add("1".equals(supplierVO.getEvaGroupResult()) ? "\u7b26\u5408" : "\u4e0d\u7b26\u5408");
                continue;
            }
            if (!bl) {
                bl = true;
            }
            arrayList.add(supplierVO.getWeights() == null ? "/" : supplierVO.getWeights().stripTrailingZeros().toPlainString() + "%");
            evaRecordTdList.add(supplierVO.getWeightScore() == null ? "/" : supplierVO.getWeightScore().stripTrailingZeros().toPlainString());
        }
        if (bl) {
            evaRecordTrList.add(arrayList);
            evaRecordDescTrList.add(arrayList);
            evaRecordTdList.set(0, ++evaGroupResultCount);
        }
        evaRecordTrList.add(evaRecordTdList);
        evaRecordDescTrList.add(evaRecordTdList);
        lastTrList.set(0, ++evaGroupResultCount);
        String opinion = "";
        if (evaLeaderOpinionVO != null) {
            opinion = evaLeaderOpinionVO.getOpinion() == null ? "" : evaLeaderOpinionVO.getOpinion();
        }
        lastTrList.add(opinion);
        evaRecordTrList.add(lastTrList);
        evaRecordDescTrList.add(lastTrList);
    }

    private void evaReviewAndScoreDesc(EvaGroupVO evaGroupVO, List<PurchaseTenderProjectEvaExpertTask> purchaseTenderProjectEvaExpertTasks, Map<String, List<List<Object>>> expertEvaRegulationGroupResultMap) {
        String evaRecordThName = "\u6761\u4f8b\u540d\u79f0";
        if (CollectionUtil.isNotEmpty(purchaseTenderProjectEvaExpertTasks)) {
            List evaExpertTasks = purchaseTenderProjectEvaExpertTasks.stream().filter(evaExpertTask -> evaGroupVO.getId().equals(evaExpertTask.getEvaGroupId())).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(evaExpertTasks)) {
                return;
            }
            for (PurchaseTenderProjectEvaExpertTask purchaseTenderProjectEvaExpertTask : evaExpertTasks) {
                ArrayList evaRecordDescTrList = new ArrayList();
                ArrayList<String> evaRecordThList = new ArrayList<String>();
                ArrayList<String> evaRecordDescList = new ArrayList<String>();
                int evaGroupResultCount = 1;
                evaRecordDescTrList.add(evaRecordThList);
                evaRecordDescTrList.add(evaRecordDescList);
                SupplierEvaGroupResultVO evaGroupResultVO = this.bidEvaHeadService.querySupplierResultByGroupId(evaGroupVO.getId(), purchaseTenderProjectEvaExpertTask.getId());
                List<SupplierVO> supplierList = evaGroupResultVO.getSupplierList();
                evaRecordThList.add("\u5e8f\u53f7");
                evaRecordThList.add(evaRecordThName);
                for (SupplierVO supplierVO : supplierList) {
                    evaRecordThList.add(supplierVO.getSupplierName());
                    evaRecordDescList.add("\u8bc4\u5ba1\u5185\u5bb9");
                    evaRecordDescList.add("\u8bc4\u5ba1\u63cf\u8ff0");
                }
                Map<String, List<PurchaseTenderProjectBidEvaRegulationResultVO>> supplierAccountevaResultListMap = evaGroupResultVO.getEvaResultListMap();
                ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO> allEvaRegulationResultVO = new ArrayList<PurchaseTenderProjectBidEvaRegulationResultVO>();
                for (List<PurchaseTenderProjectBidEvaRegulationResultVO> value : supplierAccountevaResultListMap.values()) {
                    allEvaRegulationResultVO.addAll(value);
                }
                Map regulationSupplierEvaResultMap = allEvaRegulationResultVO.stream().collect(Collectors.toMap(evaRegulationResultVO -> evaRegulationResultVO.getRegulationId() + "_" + evaRegulationResultVO.getSupplierAccount(), Function.identity(), (v1, v2) -> v2));
                boolean hasReviewOrReviewScore = TenderEvaGroupTypeEnum.REVIEW.getValue().equals(evaGroupVO.getType()) || TenderEvaGroupTypeEnum.REVIEW_SCORE.getValue().equals(evaGroupVO.getType());
                List<PurchaseTenderEvaluationRegulationInfo> tenderEvaluationTemplateRegulationInfoList = evaGroupResultVO.getEvaluationGroupVO().getTenderEvaluationTemplateRegulationInfoList();
                for (PurchaseTenderEvaluationRegulationInfo purchaseTenderEvaluationRegulationInfo : tenderEvaluationTemplateRegulationInfoList) {
                    ArrayList<Object> evaRecordDescTdList = new ArrayList<Object>();
                    evaRecordDescTrList.add(evaRecordDescTdList);
                    evaRecordDescTdList.add(evaGroupResultCount);
                    ++evaGroupResultCount;
                    evaRecordDescTdList.add(purchaseTenderEvaluationRegulationInfo.getRegulationName());
                    for (SupplierVO supplierVO : supplierList) {
                        String regulationSupplierKey = purchaseTenderEvaluationRegulationInfo.getId() + "_" + supplierVO.getSupplierAccount();
                        PurchaseTenderProjectBidEvaRegulationResultVO bidEvaRegulationResultVO = (PurchaseTenderProjectBidEvaRegulationResultVO)((Object)regulationSupplierEvaResultMap.get(regulationSupplierKey));
                        if (bidEvaRegulationResultVO == null) {
                            evaRecordDescTdList.add("");
                            evaRecordDescTdList.add("");
                            continue;
                        }
                        if (hasReviewOrReviewScore) {
                            String resultStr = "1".equals(bidEvaRegulationResultVO.getResult()) ? "\u7b26\u5408" : "\u4e0d\u7b26\u5408";
                            evaRecordDescTdList.add(resultStr);
                        } else {
                            evaRecordDescTdList.add(bidEvaRegulationResultVO.getScore() == null ? "" : bidEvaRegulationResultVO.getScore());
                        }
                        String remark = bidEvaRegulationResultVO.getRemark() == null ? "" : bidEvaRegulationResultVO.getRemark();
                        evaRecordDescTdList.add(remark);
                    }
                }
                if (hasReviewOrReviewScore) {
                    ArrayList<Object> evaRecordDescConclusionTdList = new ArrayList<Object>();
                    evaRecordDescConclusionTdList.add(evaGroupResultCount);
                    evaRecordDescTrList.add(evaRecordDescConclusionTdList);
                    ++evaGroupResultCount;
                    evaRecordDescConclusionTdList.add("\u7ed3\u8bba");
                    for (SupplierVO supplierVO : supplierList) {
                        if (!hasReviewOrReviewScore) continue;
                        String resultStr = "1".equals(supplierVO.getEvaGroupResult()) ? "\u7b26\u5408" : "\u4e0d\u7b26\u5408";
                        evaRecordDescConclusionTdList.add(resultStr);
                    }
                }
                if (TenderEvaGroupTypeEnum.SCORE.getValue().equals(evaGroupVO.getType()) || TenderEvaGroupTypeEnum.REVIEW_SCORE.getValue().equals(evaGroupVO.getType())) {
                    ArrayList<Object> evaRecordDescWeightTdList = new ArrayList<Object>();
                    evaRecordDescWeightTdList.add(evaGroupResultCount);
                    evaRecordDescWeightTdList.add("\u6743\u91cd");
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(evaGroupResultCount);
                    arrayList.add("\u5f97\u5206");
                    PurchaseTenderEvaluationGroupVO evaluationGroupVO = evaGroupResultVO.getEvaluationGroupVO();
                    for (SupplierVO supplierVO : supplierList) {
                        if (evaluationGroupVO == null) {
                            evaRecordDescWeightTdList.add("100%");
                            arrayList.add("");
                            continue;
                        }
                        BigDecimal weigh = evaluationGroupVO.getWeights() == null ? BigDecimal.valueOf(100L) : evaluationGroupVO.getWeights();
                        evaRecordDescWeightTdList.add(weigh.stripTrailingZeros().toPlainString() + "%");
                        BigDecimal score = supplierVO.getTotalScore() == null ? BigDecimal.ZERO : supplierVO.getTotalScore();
                        arrayList.add(weigh.multiply(score).divide(BigDecimal.valueOf(100L)).stripTrailingZeros().toPlainString());
                    }
                    evaRecordDescWeightTdList.set(0, evaGroupResultCount);
                    evaRecordDescTrList.add(evaRecordDescWeightTdList);
                    arrayList.set(0, ++evaGroupResultCount);
                    evaRecordDescTrList.add(arrayList);
                }
                String key = evaGroupVO.getName();
                if (TenderEvaGroupTypeEnum.REVIEW.getValue().equals(evaGroupVO.getType())) {
                    key = key + "\uff08" + purchaseTenderProjectEvaExpertTask.getJudgesName() + "\uff09";
                }
                if (TenderEvaGroupTypeEnum.SCORE.getValue().equals(evaGroupVO.getType()) || TenderEvaGroupTypeEnum.REVIEW_SCORE.getValue().equals(evaGroupVO.getType())) {
                    key = key + "\uff08\u603b\u5206" + evaGroupVO.getScore() + " " + purchaseTenderProjectEvaExpertTask.getJudgesName() + "\uff09";
                }
                expertEvaRegulationGroupResultMap.put(key, evaRecordDescTrList);
            }
        }
    }
}

