/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetter;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterService;
import com.els.modules.tender.attachment.vo.SaleQuoteMaterialDataVO;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaHead;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaExpertTask;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaInfo;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceHead;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceItem;
import com.els.modules.tender.evaluation.enumerate.PurchaseTenderProjectEvaInfoStageQuoteOperatorEnum;
import com.els.modules.tender.evaluation.enumerate.TenderEvaGroupTypeEnum;
import com.els.modules.tender.evaluation.enumerate.TenderEvaQuotedPriceHeadStatusEnum;
import com.els.modules.tender.evaluation.enumerate.TenderEvaQuotedPriceItemStatusEnum;
import com.els.modules.tender.evaluation.mapper.TenderEvaQuotedPriceHeadMapper;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaHeadService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaRegulationResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaExpertTaskService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaInfoService;
import com.els.modules.tender.evaluation.service.TenderEvaQuotedPriceHeadService;
import com.els.modules.tender.evaluation.service.TenderEvaQuotedPriceItemService;
import com.els.modules.tender.evaluation.vo.TenderEvaQuotedPriceItemVO;
import com.els.modules.tender.openbid.job.TenderJobUtil;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.enumerate.TenderProjectSupplieInviteQuotedPriceStatusEnum;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TenderEvaQuotedPriceHeadServiceImpl
extends BaseServiceImpl<TenderEvaQuotedPriceHeadMapper, TenderEvaQuotedPriceHead>
implements TenderEvaQuotedPriceHeadService {
    @Autowired
    private TenderEvaQuotedPriceItemService tenderEvaQuotedPriceItemService;
    @Autowired
    private PurchaseTenderProjectEvaInfoService purchaseTenderProjectEvaInfoService;
    @Autowired
    private PurchaseTenderProjectBidEvaRegulationResultService purchaseTenderProjectBidEvaRegulationResultService;
    @Autowired
    private PurchaseTenderProjectEvaExpertTaskService evaExpertTaskService;
    @Autowired
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Autowired
    private SaleTenderPriceOpeningsService saleTenderPriceOpeningsService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectBidEvaHeadService purchaseTenderProjectBidEvaHeadService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderBidLetterService bidLetterService;
    @Resource
    private RedisUtil redisUtil;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead, List<TenderEvaQuotedPriceItem> tenderEvaQuotedPriceItemList) {
        String subpackageId = tenderEvaQuotedPriceHead.getSubpackageId();
        Assert.notNull((Object)tenderEvaQuotedPriceHead.getQuotedPriceEndTime(), (String)I18nUtil.translate((String)"i18n_field_suyRKIxOLVW_139ebec9", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Date currentDate = new Date();
        Assert.isTrue((currentDate.compareTo(tenderEvaQuotedPriceHead.getQuotedPriceEndTime()) != 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_suyRKIxOXUAPKIW_b365a2b2", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\uff01"));
        Assert.notEmpty(tenderEvaQuotedPriceItemList, (String)I18nUtil.translate((String)"i18n_field_ViFRdXW_6cf56d4b", (String)"\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546\uff01"));
        if ("0".equals(tenderEvaQuotedPriceHead.getQuotedType())) {
            PurchaseTenderProjectEvaInfo evaInfo = (PurchaseTenderProjectEvaInfo)((Object)this.purchaseTenderProjectEvaInfoService.getById((Serializable)((Object)tenderEvaQuotedPriceHead.getEvaInfoId())));
            if (subpackageId == null) {
                subpackageId = evaInfo.getSubpackageId();
            }
            tenderEvaQuotedPriceHead.setProcessType(evaInfo.getProcessType());
            tenderEvaQuotedPriceHead.setCurrentStep(evaInfo.getCurrentStep());
            tenderEvaQuotedPriceHead.setTenderProjectId(evaInfo.getTenderProjectId());
            tenderEvaQuotedPriceHead.setSubpackageId(subpackageId);
            Assert.notNull((Object)((Object)evaInfo), (String)I18nUtil.translate((String)"i18n_field_VGRUBVHW_17e6f329", (String)"\u8bf7\u8bbe\u7f6e\u8bc4\u6807\u4fe1\u606f\uff01"));
            Assert.isTrue((boolean)"1".equals(evaInfo.getStageQuote()), (String)I18nUtil.translate((String)"i18n_field_PSbWW_d46b78d6", (String)"\u4e0d\u5141\u8bb8\u591a\u8f6e\u62a5\u4ef7\uff01"));
            List<PurchaseTenderProjectEvaExpertTask> purchaseTenderProjectEvaExpertTasks = this.evaExpertTaskService.selectByEvaInfoId(tenderEvaQuotedPriceHead.getEvaInfoId());
            LoginUser loginUser = SysUtil.getLoginUser();
            if (PurchaseTenderProjectEvaInfoStageQuoteOperatorEnum.PURCHASE.getValue().equals(evaInfo.getStageQuoteOperator())) {
                PurchaseTenderProjectHead projectHead = (PurchaseTenderProjectHead)((Object)this.purchaseTenderProjectHeadService.getById((Serializable)((Object)evaInfo.getTenderProjectId())));
                Assert.isTrue((boolean)loginUser.getElsAccount().equals(projectHead.getPurchaseExecutorAccount()), (String)I18nUtil.translate((String)"i18n_field_PSbWW_d46b78d6", (String)"\u6682\u65e0\u6743\u9650\uff01"));
            } else if (PurchaseTenderProjectEvaInfoStageQuoteOperatorEnum.EVA_BID_LEADER.getValue().equals(evaInfo.getStageQuoteOperator())) {
                List<PurchaseTenderProjectBidEvaHead> bidEvaHeadList = this.purchaseTenderProjectBidEvaHeadService.selectByMainId(evaInfo.getId());
                Assert.isTrue((!bidEvaHeadList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_PSbWW_d46b78d6", (String)"\u6682\u65e0\u6743\u9650\uff01"));
                String loginUserAccount = loginUser.getElsAccount() + "_" + loginUser.getSubAccount();
                List evaHeadList = bidEvaHeadList.stream().filter(bidEvaHead -> "1".equals(bidEvaHead.getJudgesGroupLeader()) && loginUserAccount.equals(bidEvaHead.getElsAccount() + "_" + bidEvaHead.getElsSubAccount())).collect(Collectors.toList());
                Assert.isTrue((!evaHeadList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_PSbWW_d46b78d6", (String)"\u6682\u65e0\u6743\u9650\uff01"));
            }
            for (PurchaseTenderProjectEvaExpertTask evaExpertTask : purchaseTenderProjectEvaExpertTasks) {
                List<PurchaseTenderProjectBidEvaRegulationResult> bidEvaRegulationResults = this.purchaseTenderProjectBidEvaRegulationResultService.selectBySubpackageId(subpackageId, evaExpertTask.getEvaGroupId());
                if (!CollectionUtil.isNotEmpty(bidEvaRegulationResults)) continue;
                Map<String, PurchaseTenderProjectEvaExpertTask> evaExpertTaskMap = purchaseTenderProjectEvaExpertTasks.stream().collect(Collectors.toMap(PurchaseTenderProjectEvaExpertTask::getEvaGroupId, projectEvaExpertTask -> projectEvaExpertTask, (o1, o2) -> o1));
                for (PurchaseTenderProjectBidEvaRegulationResult bidEvaRegulationResult : bidEvaRegulationResults) {
                    PurchaseTenderProjectEvaExpertTask purchaseTenderProjectEvaExpertTask;
                    if (!TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue().equals(bidEvaRegulationResult.getEvaGroupType()) || (purchaseTenderProjectEvaExpertTask = evaExpertTaskMap.get(bidEvaRegulationResult.getEvaGroupId())) == null) continue;
                    Assert.isTrue((boolean)"0".equals(evaExpertTask.getEvaGroupStatus()), (String)I18nUtil.translate((String)"i18n_field_umUUdIMLWxiTOVsuW_d5fb18a4", (String)"\u4ef7\u683c\u8bc4\u5ba1\u9879\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u591a\u8f6e\u62a5\u4ef7\uff01"));
                }
            }
        }
        List<TenderProjectSupplier> decryptSupplier = this.tenderProjectSupplierService.getDecryptSupplier(subpackageId, null, "0");
        List supplierAccounts = tenderEvaQuotedPriceItemList.stream().map(TenderEvaQuotedPriceItem::getSupplierAccount).collect(Collectors.toList());
        List filterSupplier = decryptSupplier.stream().filter(supplier -> TenderProjectSupplieInviteQuotedPriceStatusEnum.INVITED.getValue().equals(supplier.getInviteQuotedPriceStatus())).collect(Collectors.toList());
        for (TenderProjectSupplier supplier2 : filterSupplier) {
            Assert.isTrue((!supplierAccounts.contains(supplier2.getSupplierAccount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_MKIPVRdXWxqVBPVW_8632d610", (String)"\u5b58\u5728\u5df2\u9080\u8bf7\u4f9b\u5e94\u5546\uff0c\u4e0d\u53ef\u91cd\u590d\u9080\u8bf7\uff01"));
        }
        this.tenderProjectSupplierService.updateInviteQuotedPriceStatus(supplierAccounts, subpackageId, TenderProjectSupplieInviteQuotedPriceStatusEnum.INVITED.getValue());
        Integer stage = ((TenderEvaQuotedPriceHeadMapper)this.baseMapper).selectMaxStage(subpackageId);
        if (stage == null) {
            stage = 0;
        }
        tenderEvaQuotedPriceHead.setStage(stage + 1);
        tenderEvaQuotedPriceHead.setStatus(TenderEvaQuotedPriceHeadStatusEnum.EVA_QUOTED_PRICE.getValue());
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
        tenderEvaQuotedPriceHead.setTenderProjectId(subpackageInfo.getHeadId());
        ((TenderEvaQuotedPriceHeadMapper)this.baseMapper).insert((Object)tenderEvaQuotedPriceHead);
        super.setHeadDefaultValue((BaseEntity)tenderEvaQuotedPriceHead);
        this.insertData(tenderEvaQuotedPriceHead, tenderEvaQuotedPriceItemList);
        TenderJobUtil.createEvaQuotedPriceJob(tenderEvaQuotedPriceHead);
        String operateType = "tenderEvaQuotedPrice";
        if ("1".equals(tenderEvaQuotedPriceHead.getQuotedType())) {
            operateType = "tenderEvaFinalQuotedPrice";
        }
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(tenderEvaQuotedPriceHead.getTenderProjectId()).append("&subpackageId=").append(tenderEvaQuotedPriceHead.getSubpackageId()).append("&businessId=").append(tenderEvaQuotedPriceHead.getId());
        List toElsAccountList = tenderEvaQuotedPriceItemList.stream().map(TenderEvaQuotedPriceItem::getSupplierAccount).collect(Collectors.toList());
        String idStr = IdWorker.getIdStr();
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)subpackageInfo)));
        jsonObject.put("urlParams", (Object)urlParams);
        this.redisUtil.set(idStr, (Object)jsonObject, 172800L);
        super.sendMessage(TenantContext.getTenant(), "tender", operateType, idStr, "tenderBusDataServiceImpl", toElsAccountList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void finish(String id) {
        TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead = (TenderEvaQuotedPriceHead)((Object)((TenderEvaQuotedPriceHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)tenderEvaQuotedPriceHead), (String)I18nUtil.translate((String)"i18n_field_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        List<TenderEvaQuotedPriceItem> tenderEvaQuotedPriceItems = this.tenderEvaQuotedPriceItemService.selectByMainId(tenderEvaQuotedPriceHead.getId());
        Date currentDate = new Date();
        if (currentDate.compareTo(tenderEvaQuotedPriceHead.getQuotedPriceEndTime()) == -1) {
            tenderEvaQuotedPriceItems.forEach(item -> Assert.isTrue((boolean)TenderEvaQuotedPriceItemStatusEnum.EVA_QUOTED_PRICE.getValue().equals(item.getStatus()), (String)I18nUtil.translate((String)"i18n_field_MKLsuRdXWxqDPyWsuW_a37d40b9", (String)"\u5b58\u5728\u672a\u62a5\u4ef7\u4f9b\u5e94\u5546\uff0c\u4e0d\u53ef\u63d0\u524d\u7ed3\u675f\u62a5\u4ef7\uff01")));
        }
        tenderEvaQuotedPriceHead.setStatus(TenderEvaQuotedPriceHeadStatusEnum.EVA_QUOTED_PRICE_FINISH.getValue());
        ((TenderEvaQuotedPriceHeadMapper)this.baseMapper).updateById((Object)tenderEvaQuotedPriceHead);
        List supplierAccounts = tenderEvaQuotedPriceItems.stream().map(TenderEvaQuotedPriceItem::getSupplierAccount).collect(Collectors.toList());
        this.tenderProjectSupplierService.updateInviteQuotedPriceStatus(supplierAccounts, tenderEvaQuotedPriceHead.getSubpackageId(), TenderProjectSupplieInviteQuotedPriceStatusEnum.UNINVITED.getValue());
        this.saleTenderPriceOpeningsService.rankQuotedPrice(tenderEvaQuotedPriceHead.getSubpackageId());
        TenderJobUtil.deleteEvaQuotedPriceJob(tenderEvaQuotedPriceHead);
    }

    @Override
    public List<TenderEvaQuotedPriceHead> selectBySubpackageId(TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead) {
        return ((TenderEvaQuotedPriceHeadMapper)this.baseMapper).selectBySubpackageId(tenderEvaQuotedPriceHead);
    }

    @Override
    public List<TenderEvaQuotedPriceHead> selectBatchIds(Collection mainIds) {
        return ((TenderEvaQuotedPriceHeadMapper)this.baseMapper).selectBatchIds(mainIds);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addQuotedPriceInfo(TenderEvaQuotedPriceItemVO tenderEvaQuotedPriceItemVO) {
        List<SaleTenderPriceOpenings> saleTenderPriceOpeningsList = tenderEvaQuotedPriceItemVO.getPriceOpeningsList();
        List<String> bidLetterIdList = saleTenderPriceOpeningsList.stream().map(SaleTenderPriceOpenings::getBidLetterId).collect(Collectors.toList());
        List<PurchaseTenderBidLetter> tenderBidLetterList = this.bidLetterService.selectBatchIds(bidLetterIdList);
        Map<String, PurchaseTenderBidLetter> bidLetterMap = tenderBidLetterList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        for (SaleTenderPriceOpenings saleTenderPriceOpenings : saleTenderPriceOpeningsList) {
            String customizeFieldModel = saleTenderPriceOpenings.getCustomizeFieldModel();
            String customizeFieldData = saleTenderPriceOpenings.getCustomizeFieldData();
            PurchaseTenderBidLetter bidLetter = (PurchaseTenderBidLetter)((Object)bidLetterMap.get(saleTenderPriceOpenings.getBidLetterId()));
            JSONArray jsonArray = JSONArray.parseArray((String)customizeFieldData);
            List<CustomColumnModel> columnModelList = FastJsonUtils.toList(customizeFieldModel, CustomColumnModel.class);
            for (CustomColumnModel customColumnModel : columnModelList) {
                if (!"1".equals(customColumnModel.getMust()) || !"0".equals(customColumnModel.getInputOrg())) continue;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                    Assert.isTrue((boolean)jsonObject.containsKey((Object)customColumnModel.getField()), (String)I18nUtil.translate((String)"i18n_alert_eBx[0]sMKeBtLlSALSMVSMMLSDJ_3866db00", (String)"\u6295\u6807\u51fd[${0}]\u4e2d\u5b58\u5728\u6295\u6807\u5355\u4f4d\u5fc5\u586b\u5217\u672a\u586b\u5199\uff0c\u8bf7\u586b\u5199\u5b8c\u6210\u540e\u63d0\u4ea4", (String[])new String[]{bidLetter.getName()}));
                    Assert.isTrue((null != jsonObject.get((Object)customColumnModel.getField()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_eBx[0]sMKeBtLlSALSMVSMMLSDJ_3866db00", (String)"\u6295\u6807\u51fd[${0}]\u4e2d\u5b58\u5728\u6295\u6807\u5355\u4f4d\u5fc5\u586b\u5217\u672a\u586b\u5199\uff0c\u8bf7\u586b\u5199\u5b8c\u6210\u540e\u63d0\u4ea4", (String[])new String[]{bidLetter.getName()}));
                    Assert.isTrue((!"".equals(jsonObject.get((Object)customColumnModel.getField())) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_eBx[0]sMKeBtLlSALSMVSMMLSDJ_3866db00", (String)"\u6295\u6807\u51fd[${0}]\u4e2d\u5b58\u5728\u6295\u6807\u5355\u4f4d\u5fc5\u586b\u5217\u672a\u586b\u5199\uff0c\u8bf7\u586b\u5199\u5b8c\u6210\u540e\u63d0\u4ea4", (String[])new String[]{bidLetter.getName()}));
                }
            }
        }
        List<SaleQuoteMaterialDataVO> materialDataVOList = tenderEvaQuotedPriceItemVO.getSaleQuoteMaterialDataVOList();
        TenderEvaQuotedPriceItem tenderEvaQuotedPriceItem = (TenderEvaQuotedPriceItem)((Object)this.tenderEvaQuotedPriceItemService.getById((Serializable)((Object)tenderEvaQuotedPriceItemVO.getId())));
        Assert.notNull((Object)((Object)tenderEvaQuotedPriceItem), (String)I18nUtil.translate((String)"i18n_field_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        Assert.isTrue((boolean)TenantContext.getTenant().equals(tenderEvaQuotedPriceItem.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_field_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead = (TenderEvaQuotedPriceHead)((Object)((TenderEvaQuotedPriceHeadMapper)this.baseMapper).selectById((Serializable)((Object)tenderEvaQuotedPriceItem.getHeadId())));
        Date date = new Date();
        Assert.isTrue((date.compareTo(tenderEvaQuotedPriceHead.getQuotedPriceEndTime()) != 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_xiTVBsuW_c57a8c8b", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff01"));
        Assert.isTrue((boolean)TenderEvaQuotedPriceHeadStatusEnum.EVA_QUOTED_PRICE.getValue().equals(tenderEvaQuotedPriceHead.getStatus()), (String)I18nUtil.translate((String)"i18n_field_IyWsuW_7b4fab31", (String)"\u5df2\u7ed3\u675f\u62a5\u4ef7\uff01"));
        Assert.isTrue((boolean)TenderEvaQuotedPriceItemStatusEnum.NOT_EVA_QUOTED_PRICE.getValue().equals(tenderEvaQuotedPriceItem.getStatus()), (String)I18nUtil.translate((String)"i18n_field_xiTVBsuW_c57a8c8b", (String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u62a5\u4ef7\uff01"));
        tenderEvaQuotedPriceItem.setStatus(TenderEvaQuotedPriceItemStatusEnum.EVA_QUOTED_PRICE.getValue());
        tenderEvaQuotedPriceItem.setQuotedPriceTime(date);
        this.tenderEvaQuotedPriceItemService.updateById((Object)tenderEvaQuotedPriceItem);
        String finalQuote = "1".equals(tenderEvaQuotedPriceHead.getQuotedType()) ? "1" : "0";
        this.saleTenderPriceOpeningsService.addQuotedPriceInfo(bidLetterMap, saleTenderPriceOpeningsList, materialDataVOList, tenderEvaQuotedPriceHead.getStage(), tenderEvaQuotedPriceItem.getId(), finalQuote);
    }

    @Override
    public void revokeQuotedPriceInfo(String quotedPriceItemId) {
        TenderEvaQuotedPriceItem tenderEvaQuotedPriceItem = (TenderEvaQuotedPriceItem)((Object)this.tenderEvaQuotedPriceItemService.getById((Serializable)((Object)quotedPriceItemId)));
        Assert.notNull((Object)((Object)tenderEvaQuotedPriceItem), (String)I18nUtil.translate((String)"i18n_field_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        Assert.isTrue((boolean)TenderEvaQuotedPriceItemStatusEnum.EVA_QUOTED_PRICE.getValue().equals(tenderEvaQuotedPriceItem.getStatus()), (String)I18nUtil.translate((String)"i18n_field_LsuWxiTqXW_f32c02b1", (String)"\u672a\u62a5\u4ef7\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\uff01"));
        TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead = (TenderEvaQuotedPriceHead)((Object)((TenderEvaQuotedPriceHeadMapper)this.baseMapper).selectById((Serializable)((Object)tenderEvaQuotedPriceItem.getHeadId())));
        Date date = new Date();
        Assert.isTrue((date.compareTo(tenderEvaQuotedPriceHead.getQuotedPriceEndTime()) != 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_suyRKIIRW_892fe964", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u64a4\u56de\uff01"));
        Assert.isTrue((boolean)TenderEvaQuotedPriceHeadStatusEnum.EVA_QUOTED_PRICE.getValue().equals(tenderEvaQuotedPriceHead.getStatus()), (String)I18nUtil.translate((String)"i18n_field_LsuWxiTqXW_f32c02b1", (String)"\u5df2\u7ed3\u675f\u62a5\u4ef7\uff0c\u4e0d\u53ef\u64a4\u56de\uff01"));
        tenderEvaQuotedPriceItem.setStatus(TenderEvaQuotedPriceItemStatusEnum.NOT_EVA_QUOTED_PRICE.getValue());
        tenderEvaQuotedPriceItem.setQuotedPriceTime(null);
        this.tenderEvaQuotedPriceItemService.updateByStatus(tenderEvaQuotedPriceItem);
        this.saleTenderPriceOpeningsService.revokeQuotedPriceInfo(tenderEvaQuotedPriceItem.getId());
    }

    private void insertData(TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead, List<TenderEvaQuotedPriceItem> tenderEvaQuotedPriceItemList) {
        if (!CollectionUtils.isEmpty(tenderEvaQuotedPriceItemList)) {
            for (TenderEvaQuotedPriceItem entity : tenderEvaQuotedPriceItemList) {
                entity.setHeadId(tenderEvaQuotedPriceHead.getId());
                entity.setStatus(TenderEvaQuotedPriceItemStatusEnum.NOT_EVA_QUOTED_PRICE.getValue());
                entity.setEvaInfoId(tenderEvaQuotedPriceHead.getEvaInfoId());
                entity.setSubpackageId(tenderEvaQuotedPriceHead.getSubpackageId());
                entity.setTenderProjectId(tenderEvaQuotedPriceHead.getTenderProjectId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)tenderEvaQuotedPriceHead);
            }
            this.tenderEvaQuotedPriceItemService.saveBatch(tenderEvaQuotedPriceItemList, 2000);
        }
    }
}

