/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.utils;

import com.alibaba.fastjson.JSONArray;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.html2pdf.resolver.font.DefaultFontProvider;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.events.Event;
import com.itextpdf.kernel.events.IEventHandler;
import com.itextpdf.kernel.events.PdfDocumentEvent;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.VerticalAlignment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class HtmlToPdfUtil {
    private static final Logger log = LoggerFactory.getLogger(HtmlToPdfUtil.class);

    public static byte[] htmlToPdf(String html, String fileName, boolean water, final String waterString, PageSize pageSize) {
        if (pageSize == null) {
            pageSize = PageSize.A4;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PdfWriter pdfWriter = new PdfWriter((OutputStream)outputStream);
        PdfDocument pdfDocument = new PdfDocument(pdfWriter);
        pdfDocument.setDefaultPageSize(pageSize);
        ConverterProperties pro = new ConverterProperties();
        DefaultFontProvider fontProvider = new DefaultFontProvider();
        fontProvider.addDirectory("/usr/share/fonts/chinese");
        Collection fonts = fontProvider.getFontSet().getFonts();
        log.info(":::contract font path: /usr/share/fonts/chinese/\u5b57\u4f53\u5217\u8868" + JSONArray.toJSONString((Object)fonts));
        pro.setFontProvider((FontProvider)fontProvider);
        if (water) {
            IEventHandler handlerEndPage = new IEventHandler(){

                public void handleEvent(Event event) {
                    PdfDocumentEvent docEvent = (PdfDocumentEvent)event;
                    PdfDocument pdf = docEvent.getDocument();
                    PdfPage page = docEvent.getPage();
                    PdfCanvas pdfCanvas = new PdfCanvas(page.newContentStreamBefore(), page.getResources(), pdf);
                    PdfFont font = null;
                    try {
                        String path = ClassUtils.getDefaultClassLoader().getResource("").getPath();
                        if (path.startsWith("file:/")) {
                            InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("static/simfang.ttf");
                            font = PdfFontFactory.createFont((byte[])HtmlToPdfUtil.toByteArray(resourceAsStream), (String)"Identity-H", (boolean)false);
                        } else {
                            log.info(":::contract font path:" + path + "static/simfang.ttf");
                            font = PdfFontFactory.createFont((String)(path + "static/simfang.ttf"), (String)"Identity-H", (boolean)false);
                        }
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    ((Canvas)((Canvas)((Canvas)((Canvas)new Canvas(pdfCanvas, pdf, page.getPageSize()).setFontSize(36.0f)).setOpacity(Float.valueOf(0.2f))).setFont(font)).setFontColor((Color)new DeviceRgb(255, 0, 0))).showTextAligned(new Paragraph(waterString), 298.0f, 421.0f, pdf.getPageNumber(page), TextAlignment.CENTER, VerticalAlignment.MIDDLE, 45.0f);
                }
            };
            pdfDocument.addEventHandler("EndPdfPage", handlerEndPage);
        }
        HtmlConverter.convertToPdf((String)html.replaceAll("\u21b5", "").replaceAll("<!-- pagebreak -->", "<div style=\"page-break-after: always;\">&nbsp;</div>").replaceAll("<table border=\"1\" style=\"border-collapse: collapse; width: 100%; border-color: #000000;\" .*?>", "<table border=\"1\" style=\"border-collapse: collapse; width: 100%; border-color: #000000;\">"), (PdfDocument)pdfDocument, (ConverterProperties)pro);
        byte[] bytes = outputStream.toByteArray();
        outputStream.close();
        pdfWriter.close();
        return bytes;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }
}

