/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.openbid.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.openbid.entity.TenderOpenBidRecordAttachment;
import com.els.modules.tender.openbid.entity.TenderOpenBidRecordHead;
import com.els.modules.tender.openbid.entity.TenderOpenBidRecordSupplier;
import com.els.modules.tender.openbid.service.TenderOpenBidRecordAttachmentService;
import com.els.modules.tender.openbid.service.TenderOpenBidRecordHeadService;
import com.els.modules.tender.openbid.service.TenderOpenBidRecordSupplierService;
import com.els.modules.tender.openbid.vo.TenderOpenBidRecordHeadVO;
import com.els.modules.tender.openbid.vo.TenderOpenBidRecordSupplierVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/openbid/tenderOpenBidRecordHead"})
@Api(tags={"\u7ebf\u4e0b\u5f00\u6807\u8bb0\u5f55\u5934\u4fe1\u606f"})
public class TenderOpenBidRecordHeadController
extends BaseController<TenderOpenBidRecordHead, TenderOpenBidRecordHeadService> {
    private static final Logger log = LoggerFactory.getLogger(TenderOpenBidRecordHeadController.class);
    @Autowired
    private TenderOpenBidRecordHeadService tenderOpenBidRecordHeadService;
    @Autowired
    private TenderOpenBidRecordSupplierService tenderOpenBidRecordSupplierService;
    @Autowired
    private TenderOpenBidRecordAttachmentService tenderOpenBidRecordAttachmentService;
    @Autowired
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryPageList(TenderOpenBidRecordHead tenderOpenBidRecordHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderOpenBidRecordHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.tenderOpenBidRecordHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u7ebf\u4e0b\u5f00\u6807\u8bb0\u5f55\u5934\u4fe1\u606f", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> add(@RequestBody TenderOpenBidRecordHeadVO tenderOpenBidRecordHeadPage) {
        TenderOpenBidRecordHead tenderOpenBidRecordHead = new TenderOpenBidRecordHead();
        BeanUtils.copyProperties((Object)((Object)tenderOpenBidRecordHeadPage), (Object)((Object)tenderOpenBidRecordHead));
        this.tenderOpenBidRecordHeadService.saveMain(tenderOpenBidRecordHead, tenderOpenBidRecordHeadPage.getTenderOpenBidRecordSupplierList(), tenderOpenBidRecordHeadPage.getTenderOpenBidRecordAttachmentList());
        return Result.ok((Object)((Object)tenderOpenBidRecordHead));
    }

    @AutoLog(busModule="\u7ebf\u4e0b\u5f00\u6807\u8bb0\u5f55\u5934\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> edit(@RequestBody TenderOpenBidRecordHeadVO tenderOpenBidRecordHeadPage) {
        TenderOpenBidRecordHead tenderOpenBidRecordHead = new TenderOpenBidRecordHead();
        BeanUtils.copyProperties((Object)((Object)tenderOpenBidRecordHeadPage), (Object)((Object)tenderOpenBidRecordHead));
        this.tenderOpenBidRecordHeadService.updateMain(tenderOpenBidRecordHead, tenderOpenBidRecordHeadPage.getTenderOpenBidRecordSupplierList(), tenderOpenBidRecordHeadPage.getTenderOpenBidRecordAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u7ebf\u4e0b\u5f00\u6807\u8bb0\u5f55\u5934\u4fe1\u606f", value="\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> submit(@RequestBody TenderOpenBidRecordHeadVO tenderOpenBidRecordHeadPage) {
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u7ebf\u4e0b\u5f00\u6807\u8bb0\u5f55\u5934\u4fe1\u606f", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> publish(@RequestBody TenderOpenBidRecordHeadVO tenderOpenBidRecordHeadPage) {
        this.tenderOpenBidRecordHeadService.publish(tenderOpenBidRecordHeadPage);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TenderOpenBidRecordHead tenderOpenBidRecordHead = (TenderOpenBidRecordHead)((Object)this.tenderOpenBidRecordHeadService.getById((Serializable)((Object)id)));
        TenderOpenBidRecordHeadVO tenderOpenBidRecordHeadVO = this.queryDetail(tenderOpenBidRecordHead);
        return Result.ok((Object)((Object)tenderOpenBidRecordHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2", notes="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2")
    @GetMapping(value={"/queryBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryBySubpackageId(@RequestParam(name="subpackageId") String subpackageId) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        ((LambdaQueryWrapper)qw.eq(TenderOpenBidRecordHead::getSubpackageId, (Object)subpackageId)).eq(TenderOpenBidRecordHead::getCheckType, (Object)tenderCheckType);
        List recordHeads = this.tenderOpenBidRecordHeadService.list((Wrapper)qw);
        if (CollectionUtil.isEmpty((Collection)recordHeads)) {
            TenderOpenBidRecordHeadVO tenderOpenBidRecordHeadVO = new TenderOpenBidRecordHeadVO();
            TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId);
            List<TenderProjectSupplier> tenderProjectSuppliers = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier);
            if (CollectionUtil.isNotEmpty(tenderProjectSuppliers)) {
                PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
                if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(subpackageInfo.getCheckType())) {
                    tenderProjectSuppliers = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(tenderProjectSupplier.getPreShortlisted())).collect(Collectors.toList());
                }
                ArrayList tenderOpenBidRecordSupplierVOS = SysUtil.copyProperties(tenderProjectSuppliers, TenderOpenBidRecordSupplierVO.class);
                for (TenderOpenBidRecordSupplierVO tenderOpenBidRecordSupplierVO : tenderOpenBidRecordSupplierVOS) {
                    tenderOpenBidRecordSupplierVO.setId(null);
                    tenderOpenBidRecordSupplierVO.setCreateBy(null);
                    tenderOpenBidRecordSupplierVO.setCreateById(null);
                    tenderOpenBidRecordSupplierVO.setCreateTime(null);
                }
                tenderOpenBidRecordHeadVO.setTenderOpenBidRecordSupplierList(tenderOpenBidRecordSupplierVOS);
            }
            return Result.ok((Object)((Object)tenderOpenBidRecordHeadVO));
        }
        TenderOpenBidRecordHead tenderOpenBidRecordHead = (TenderOpenBidRecordHead)((Object)recordHeads.get(0));
        TenderOpenBidRecordHeadVO tenderOpenBidRecordHeadVO = this.queryDetail(tenderOpenBidRecordHead);
        return Result.ok((Object)((Object)tenderOpenBidRecordHeadVO));
    }

    private TenderOpenBidRecordHeadVO queryDetail(TenderOpenBidRecordHead tenderOpenBidRecordHead) {
        List purchaseAttachmentDTOList;
        TenderOpenBidRecordHeadVO tenderOpenBidRecordHeadVO = new TenderOpenBidRecordHeadVO();
        BeanUtils.copyProperties((Object)((Object)tenderOpenBidRecordHead), (Object)((Object)tenderOpenBidRecordHeadVO));
        List<TenderOpenBidRecordSupplier> tenderOpenBidRecordSupplierList = this.tenderOpenBidRecordSupplierService.selectByMainId(tenderOpenBidRecordHead.getId());
        ArrayList recordSupplierList = SysUtil.copyProperties(tenderOpenBidRecordSupplierList, TenderOpenBidRecordSupplierVO.class);
        List recordSupplierIds = tenderOpenBidRecordSupplierList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(recordSupplierIds) && CollectionUtil.isNotEmpty((Collection)(purchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainIds(recordSupplierIds)))) {
            Map<String, List<PurchaseAttachmentDTO>> purchaseAttachmentDTOMap = purchaseAttachmentDTOList.stream().collect(Collectors.groupingBy(PurchaseAttachmentDTO::getHeadId));
            for (TenderOpenBidRecordSupplierVO tenderOpenBidRecordSupplierVO : recordSupplierList) {
                tenderOpenBidRecordSupplierVO.setAttachmentDTOList(purchaseAttachmentDTOMap.get(tenderOpenBidRecordSupplierVO.getId()));
            }
        }
        tenderOpenBidRecordHeadVO.setTenderOpenBidRecordSupplierList(recordSupplierList);
        List<TenderOpenBidRecordAttachment> tenderOpenBidRecordAttachmentList = this.tenderOpenBidRecordAttachmentService.selectByMainId(tenderOpenBidRecordHead.getId());
        tenderOpenBidRecordHeadVO.setTenderOpenBidRecordAttachmentList(tenderOpenBidRecordAttachmentList);
        return tenderOpenBidRecordHeadVO;
    }
}

