/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.sale.entity.PurchaseTenderBidWinningServiceFeeHead;
import com.els.modules.tender.sale.entity.PurchaseTenderBidWinningServiceFeeItem;
import com.els.modules.tender.sale.entity.SaleTenderProjectMarginDeductRecord;
import com.els.modules.tender.sale.entity.SaleTenderProjectMarginHead;
import com.els.modules.tender.sale.entity.SaleTenderProjectMarginItem;
import com.els.modules.tender.sale.entity.SaleTenderProjectRefund;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginDeductTypeEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginHeadStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginItemMarginCollectionTypeEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginItemStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginRefundStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginRefundTypeEnum;
import com.els.modules.tender.sale.service.SaleTenderProjectMarginDeductRecordService;
import com.els.modules.tender.sale.service.SaleTenderProjectMarginHeadService;
import com.els.modules.tender.sale.vo.SaleTenderProjectMarginItemVO;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectMarginDeductRecord;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectMarginHead;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectMarginItem;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectRefund;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.mapper.PurchaseTenderProjectMarginHeadMapper;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectMarginDeductRecordService;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectMarginHeadService;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectMarginItemService;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectRefundService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginHeadVO;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginHeanInfoVO;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginItemVO;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginStatVO;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginTypeInfoVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderProjectMarginHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectMarginHeadMapper, PurchaseTenderProjectMarginHead>
implements PurchaseTenderProjectMarginHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectMarginHeadServiceImpl.class);
    @Autowired
    private PurchaseTenderProjectMarginItemService purchaseTenderProjectMarginItemService;
    @Autowired
    private SaleTenderProjectMarginHeadService saleTenderProjectMarginHeadService;
    @Autowired
    private PurchaseTenderProjectRefundService purchaseTenderProjectRefundService;
    @Autowired
    private PurchaseTenderProjectMarginDeductRecordService tenderProjectMarginDeductRecordService;
    @Autowired
    private SaleTenderProjectMarginDeductRecordService saleTenderProjectMarginDeductRecordService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    @Lazy
    private TenderProjectSupplierService supplierService;
    @Resource
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Resource
    private RedisUtil redisUtil;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(PurchaseTenderProjectMarginHead tenderProjectMarginHead) {
        ((PurchaseTenderProjectMarginHeadMapper)this.baseMapper).insert((Object)tenderProjectMarginHead);
    }

    @Override
    public void addBatch(List<PurchaseTenderProjectMarginHead> purchaseTenderProjectMarginHeads) {
        this.saveBatch(purchaseTenderProjectMarginHeads, 1000);
    }

    @Override
    public List<PurchaseTenderProjectMarginHeadVO> queryList(String subpackageId) {
        List<PurchaseTenderProjectMarginHead> purchaseTenderProjectMarginHeads = ((PurchaseTenderProjectMarginHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, null);
        if (CollectionUtil.isEmpty(purchaseTenderProjectMarginHeads)) {
            return null;
        }
        ArrayList marginHeadVOS = SysUtil.copyProperties(purchaseTenderProjectMarginHeads, PurchaseTenderProjectMarginHeadVO.class);
        List<String> statusList = Arrays.asList(TenderProjectMarginItemStatusEnum.SUBMIT.getValue(), TenderProjectMarginItemStatusEnum.CONFIRMED.getValue());
        PurchaseTenderProjectMarginItem queryItem = new PurchaseTenderProjectMarginItem();
        queryItem.setSubpackageId(subpackageId);
        List<PurchaseTenderProjectMarginItem> purchaseTenderProjectMarginItems = this.purchaseTenderProjectMarginItemService.selectBySubpackageId(queryItem, statusList);
        Map<String, List<PurchaseTenderProjectMarginItem>> projectMarginItemMap = purchaseTenderProjectMarginItems.stream().collect(Collectors.groupingBy(PurchaseTenderProjectMarginItem::getHeadId));
        List<PurchaseTenderProjectRefund> refundList = this.purchaseTenderProjectRefundService.selectBySubpackageId(subpackageId, null, null);
        Map<String, List<PurchaseTenderProjectRefund>> refundMap = refundList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectRefund::getHeadId));
        for (PurchaseTenderProjectMarginHeadVO marginHeadVO : marginHeadVOS) {
            List<PurchaseTenderProjectMarginItem> marginItems;
            HashMap<String, PurchaseTenderProjectMarginHeanInfoVO> marginStatMap = new HashMap<String, PurchaseTenderProjectMarginHeanInfoVO>();
            BigDecimal toPayAmount = marginHeadVO.getDueAmount().compareTo(marginHeadVO.getPaidAmount()) == 1 ? marginHeadVO.getDueAmount().subtract(marginHeadVO.getPaidAmount()) : BigDecimal.ZERO;
            marginHeadVO.setToPayAmount(toPayAmount);
            List<PurchaseTenderProjectRefund> refunds = refundMap.get(marginHeadVO.getId());
            if (CollectionUtil.isNotEmpty(refunds)) {
                Map<String, List<PurchaseTenderProjectRefund>> refundTypeMap = refunds.stream().collect(Collectors.groupingBy(PurchaseTenderProjectRefund::getRefundType));
                for (Map.Entry<String, List<PurchaseTenderProjectRefund>> refundListEntry : refundTypeMap.entrySet()) {
                    PurchaseTenderProjectMarginHeanInfoVO refundStatVO = new PurchaseTenderProjectMarginHeanInfoVO();
                    refundStatVO.setMarginCollectionType(refundListEntry.getKey());
                    BigDecimal refundAmount = refundListEntry.getValue().stream().filter(refund -> TenderProjectMarginRefundStatusEnum.REFUNDED.getValue().equals(refund.getStatus())).map(PurchaseTenderProjectRefund::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal lockedAmount = refundListEntry.getValue().stream().filter(refund -> TenderProjectMarginRefundStatusEnum.REFUNDING.getValue().equals(refund.getStatus())).map(PurchaseTenderProjectRefund::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    refundStatVO.setLockedAmount(lockedAmount);
                    refundStatVO.setRefundAmount(refundAmount);
                    marginStatMap.put(refundListEntry.getKey(), refundStatVO);
                }
            }
            if (CollectionUtil.isNotEmpty(marginItems = projectMarginItemMap.get(marginHeadVO.getId()))) {
                Map<String, List<PurchaseTenderProjectMarginItem>> marginItemMap = marginItems.stream().collect(Collectors.groupingBy(PurchaseTenderProjectMarginItem::getMarginCollectionType));
                for (Map.Entry<String, List<PurchaseTenderProjectMarginItem>> marginItemEntry : marginItemMap.entrySet()) {
                    PurchaseTenderProjectMarginHeanInfoVO marginStatVO = (PurchaseTenderProjectMarginHeanInfoVO)marginStatMap.get(marginItemEntry.getKey());
                    if (marginStatVO == null) {
                        marginStatVO = new PurchaseTenderProjectMarginHeanInfoVO();
                        marginStatVO.setMarginCollectionType(marginItemEntry.getKey());
                    }
                    List<PurchaseTenderProjectMarginItem> marginItemList = marginItemEntry.getValue();
                    marginStatVO.setPayNumber(marginItemList.size());
                    long count = marginItemList.stream().filter(item -> TenderProjectMarginItemStatusEnum.CONFIRMED.getValue().equals(item.getStatus())).count();
                    marginStatVO.setConfirmNumber(count);
                    BigDecimal paidAmount = marginItemList.stream().map(PurchaseTenderProjectMarginItem::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal frozenAmount = marginHeadVO.getFrozenAmount() == null ? BigDecimal.ZERO : marginHeadVO.getFrozenAmount();
                    marginStatVO.setPaidAmount(paidAmount);
                    marginStatVO.setAvailableAmount(paidAmount.subtract(marginStatVO.getRefundAmount()).subtract(frozenAmount));
                    if (TenderProjectMarginItemMarginCollectionTypeEnum.OTHER.getValue().equals(marginItemEntry.getKey())) {
                        marginStatVO.setAvailableAmount(marginStatVO.getAvailableAmount().subtract(marginHeadVO.getDeductAmount()));
                    }
                    marginStatMap.put(marginItemEntry.getKey(), marginStatVO);
                }
            }
            List<PurchaseTenderProjectMarginHeanInfoVO> MarginStatList = marginStatMap.values().parallelStream().collect(Collectors.toList());
            marginHeadVO.setMarginList(MarginStatList);
        }
        return marginHeadVOS;
    }

    @Override
    public PurchaseTenderProjectMarginStatVO queryStat(String subpackageId) {
        PurchaseTenderProjectMarginStatVO marginStatVO = new PurchaseTenderProjectMarginStatVO();
        List<PurchaseTenderProjectMarginHead> marginHeads = ((PurchaseTenderProjectMarginHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, null);
        if (CollectionUtil.isEmpty(marginHeads)) {
            return marginStatVO;
        }
        long unpaidNumber = marginHeads.stream().filter(marginHead -> TenderProjectMarginHeadStatusEnum.UNPAID.getValue().equals(marginHead.getStatus()) || TenderProjectMarginHeadStatusEnum.PART_PAID.getValue().equals(marginHead.getStatus())).count();
        long paidNumber = marginHeads.stream().filter(marginHead -> TenderProjectMarginHeadStatusEnum.PAID.getValue().equals(marginHead.getStatus())).count();
        long refundNumber = marginHeads.stream().filter(marginHead -> TenderProjectMarginHeadStatusEnum.REFUNDED.getValue().equals(marginHead.getStatus())).count();
        long toRefundedNumber = marginHeads.stream().filter(marginHead -> marginHead.getPaidAmount().compareTo(marginHead.getGuaranteePaidAmount()) == 1).count();
        BigDecimal paidTotalAmount = marginHeads.stream().filter(marginHead -> TenderProjectMarginHeadStatusEnum.PART_PAID.getValue().equals(marginHead.getStatus()) || TenderProjectMarginHeadStatusEnum.PAID.getValue().equals(marginHead.getStatus())).map(PurchaseTenderProjectMarginHead::getPaidTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal paidAmount = marginHeads.stream().filter(marginHead -> TenderProjectMarginHeadStatusEnum.PART_PAID.getValue().equals(marginHead.getStatus()) || TenderProjectMarginHeadStatusEnum.PAID.getValue().equals(marginHead.getStatus())).map(PurchaseTenderProjectMarginHead::getPaidAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal guaranteePaidAmount = marginHeads.stream().filter(marginHead -> TenderProjectMarginHeadStatusEnum.PART_PAID.getValue().equals(marginHead.getStatus()) || TenderProjectMarginHeadStatusEnum.PAID.getValue().equals(marginHead.getStatus())).map(PurchaseTenderProjectMarginHead::getGuaranteePaidAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal frozenAmount = marginHeads.stream().filter(marginHead -> marginHead.getFrozenAmount() != null).map(PurchaseTenderProjectMarginHead::getFrozenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal deductAmount = marginHeads.stream().filter(marginHead -> marginHead.getDeductAmount() != null).map(PurchaseTenderProjectMarginHead::getDeductAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<PurchaseTenderProjectRefund> refundList = this.purchaseTenderProjectRefundService.selectBySubpackageId(subpackageId, TenderProjectMarginRefundStatusEnum.REFUNDED.getValue(), null);
        if (CollectionUtil.isNotEmpty(refundList)) {
            BigDecimal refundedAmount = refundList.stream().map(PurchaseTenderProjectRefund::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            marginStatVO.setRefundedAmount(refundedAmount);
        }
        marginStatVO.setUnpaidNumber(unpaidNumber);
        marginStatVO.setPaidNumber(paidNumber);
        marginStatVO.setToRefundNumber(toRefundedNumber);
        marginStatVO.setRefundedNumber(refundNumber);
        marginStatVO.setPaidTotalAmount(paidTotalAmount.subtract(guaranteePaidAmount));
        BigDecimal totalBalance = paidAmount.subtract(guaranteePaidAmount).subtract(frozenAmount).subtract(deductAmount);
        marginStatVO.setTotalBalance(totalBalance);
        return marginStatVO;
    }

    @Override
    public List<PurchaseTenderProjectMarginTypeInfoVO> queryMarginInfo(String subpackageId, String refundType) {
        PurchaseTenderProjectMarginHeadVO marginHeadVO;
        List<PurchaseTenderProjectMarginItem> marginItems;
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)subpackageId), (String)I18nUtil.translate((String)"i18n_field_zsWWxOLVW_b61e1b17", (String)"\u5206\u5305id\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)refundType), (String)I18nUtil.translate((String)"i18n_field_YVAcxOLVW_9e93bca3", (String)"\u9000\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<PurchaseTenderProjectMarginHead> purchaseTenderProjectMarginHeads = ((PurchaseTenderProjectMarginHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, null);
        if (CollectionUtil.isEmpty(purchaseTenderProjectMarginHeads)) {
            return null;
        }
        ArrayList<PurchaseTenderProjectMarginTypeInfoVO> marginTypeInfoVOS = new ArrayList<PurchaseTenderProjectMarginTypeInfoVO>();
        ArrayList marginHeadVOS = SysUtil.copyProperties(purchaseTenderProjectMarginHeads, PurchaseTenderProjectMarginHeadVO.class);
        List<String> statusList = Arrays.asList(TenderProjectMarginItemStatusEnum.CONFIRMED.getValue());
        PurchaseTenderProjectMarginItem queryItem = new PurchaseTenderProjectMarginItem();
        queryItem.setSubpackageId(subpackageId);
        queryItem.setMarginCollectionType(refundType);
        List<PurchaseTenderProjectMarginItem> purchaseTenderProjectMarginItems = this.purchaseTenderProjectMarginItemService.selectBySubpackageId(queryItem, statusList);
        Map<String, List<PurchaseTenderProjectMarginItem>> projectMarginItemMap = purchaseTenderProjectMarginItems.stream().collect(Collectors.groupingBy(PurchaseTenderProjectMarginItem::getHeadId));
        List<PurchaseTenderProjectRefund> refundList = this.purchaseTenderProjectRefundService.selectBySubpackageId(subpackageId, null, refundType);
        Map<String, List<PurchaseTenderProjectRefund>> refundMap = refundList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectRefund::getHeadId));
        Iterator iterator = marginHeadVOS.iterator();
        while (iterator.hasNext() && !CollectionUtil.isEmpty(marginItems = projectMarginItemMap.get((marginHeadVO = (PurchaseTenderProjectMarginHeadVO)((Object)iterator.next())).getId()))) {
            BigDecimal dueAmount = marginItems.stream().map(PurchaseTenderProjectMarginItem::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            PurchaseTenderProjectMarginTypeInfoVO marginTypeInfoVO = new PurchaseTenderProjectMarginTypeInfoVO();
            marginTypeInfoVO.setRefundType(refundType);
            marginTypeInfoVO.setSupplierAccount(marginHeadVO.getSupplierAccount());
            marginTypeInfoVO.setSupplierName(marginHeadVO.getSupplierName());
            marginTypeInfoVO.setSubpackageId(marginHeadVO.getSubpackageId());
            marginTypeInfoVO.setTenderProjectId(marginHeadVO.getTenderProjectId());
            BigDecimal refundAmount = BigDecimal.ZERO;
            BigDecimal lockedAmount = BigDecimal.ZERO;
            BigDecimal frozenAmount = marginHeadVO.getFrozenAmount() == null ? BigDecimal.ZERO : marginHeadVO.getFrozenAmount();
            BigDecimal deductAmount = marginHeadVO.getDeductAmount() == null ? BigDecimal.ZERO : marginHeadVO.getDeductAmount();
            List<PurchaseTenderProjectRefund> refunds = refundMap.get(marginHeadVO.getId());
            if (CollectionUtil.isNotEmpty(refunds)) {
                refundAmount = refunds.stream().filter(refund -> TenderProjectMarginRefundStatusEnum.REFUNDED.getValue().equals(refund.getStatus())).map(PurchaseTenderProjectRefund::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                lockedAmount = refunds.stream().filter(refund -> TenderProjectMarginRefundStatusEnum.REFUNDING.getValue().equals(refund.getStatus())).map(PurchaseTenderProjectRefund::getLockedAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            marginTypeInfoVO.setLockedAmount(lockedAmount);
            marginTypeInfoVO.setAvailableAmount(dueAmount.subtract(refundAmount).subtract(lockedAmount).subtract(frozenAmount).subtract(deductAmount));
            marginTypeInfoVOS.add(marginTypeInfoVO);
        }
        return marginTypeInfoVOS;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseTenderProjectMarginItem addMargin(PurchaseTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItemVO.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_field_eBtLxOLVW_df534627", (String)"\u6295\u6807\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<PurchaseTenderProjectMarginHead> tenderProjectMarginHeadList = ((PurchaseTenderProjectMarginHeadMapper)this.baseMapper).selectBySubpackageId(tenderProjectMarginItemVO.getSubpackageId(), tenderProjectMarginItemVO.getSupplierAccount());
        PurchaseTenderProjectMarginHead tenderProjectMarginHead = null;
        if (CollectionUtil.isEmpty(tenderProjectMarginHeadList)) {
            TenderProjectSupplier supplier = new TenderProjectSupplier();
            supplier.setSubpackageId(tenderProjectMarginItemVO.getSubpackageId());
            supplier.setSupplierAccount(TenantContext.getTenant());
            supplier.setInvalid("0");
            List<TenderProjectSupplier> supplierList = this.supplierService.selectBySubpackageId(supplier);
            Assert.isTrue((boolean)CollectionUtil.isNotEmpty(supplierList), (String)I18nUtil.translate((String)"i18n_field_LsRxqSusiHtH_a9f5ac19", (String)"\u672a\u62a5\u540d\u4e0d\u53ef\u6dfb\u52a0\u4fdd\u8bc1\u91d1\u8bb0\u5f55"));
            SaleTenderProjectMarginHead saleTenderProjectMarginHead = this.saleTenderProjectMarginHeadService.add(supplierList.get(0));
            Assert.notNull((Object)((Object)saleTenderProjectMarginHead), (String)I18nUtil.translate((String)"i18n_alert_JmUUyOxqSusiHtH_4168a0f7", (String)"\u8d44\u683c\u9884\u5ba1\u9636\u6bb5\u4e0d\u53ef\u6dfb\u52a0\u4fdd\u8bc1\u91d1\u8bb0\u5f55"));
            tenderProjectMarginHead.setId(saleTenderProjectMarginHead.getRelationId());
        } else {
            tenderProjectMarginHead = tenderProjectMarginHeadList.get(0);
        }
        tenderProjectMarginItemVO.setHeadId(tenderProjectMarginHead.getId());
        tenderProjectMarginItemVO.setTenderProjectId(IdWorker.getIdStr());
        tenderProjectMarginItemVO.setElsAccount(tenderProjectMarginHead.getElsAccount());
        PurchaseTenderProjectMarginItem tenderProjectMarginItem = new PurchaseTenderProjectMarginItem();
        BeanUtils.copyProperties((Object)((Object)tenderProjectMarginItemVO), (Object)((Object)tenderProjectMarginItem));
        this.purchaseTenderProjectMarginItemService.save((Object)tenderProjectMarginItem);
        this.saveAttachment(tenderProjectMarginItemVO.getId(), tenderProjectMarginItemVO.getAttachmentDTOList());
        return tenderProjectMarginItem;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseTenderProjectMarginItem editMargin(PurchaseTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        PurchaseTenderProjectMarginItem tenderProjectMarginItem = (PurchaseTenderProjectMarginItem)((Object)this.purchaseTenderProjectMarginItemService.getById((Serializable)((Object)tenderProjectMarginItemVO.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)tenderProjectMarginItem)), (String)I18nUtil.translate((String)"i18n_field_WFxMKW_b697ca02", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        BeanUtils.copyProperties((Object)((Object)tenderProjectMarginItemVO), (Object)((Object)tenderProjectMarginItem), (String[])new String[]{"headId", "status", "supplierAccount", "supplierName", "elsAccount"});
        this.purchaseTenderProjectMarginItemService.updateById((Object)tenderProjectMarginItem);
        this.saveAttachment(tenderProjectMarginItemVO.getId(), tenderProjectMarginItemVO.getAttachmentDTOList());
        return tenderProjectMarginItem;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseTenderProjectMarginItem submitMargin(PurchaseTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        String status = tenderProjectMarginItemVO.getStatus();
        PurchaseTenderProjectMarginItem tenderProjectMarginItem = (PurchaseTenderProjectMarginItem)((Object)this.purchaseTenderProjectMarginItemService.getById((Serializable)((Object)tenderProjectMarginItemVO.getId())));
        this.checkMarginItemParam(tenderProjectMarginItem);
        tenderProjectMarginItem.setStatus(TenderProjectMarginItemStatusEnum.SUBMIT.getValue());
        this.saveAttachment(tenderProjectMarginItemVO.getId(), tenderProjectMarginItemVO.getAttachmentDTOList());
        SaleTenderProjectMarginItemVO saleTenderProjectMarginItemVO = (SaleTenderProjectMarginItemVO)((Object)SysUtil.copyProperties((Object)((Object)tenderProjectMarginItem), SaleTenderProjectMarginItemVO.class));
        ArrayList attachmentDTOList = SysUtil.copyProperties(tenderProjectMarginItemVO.getAttachmentDTOList(), SaleAttachmentDTO.class);
        saleTenderProjectMarginItemVO.setAttachmentDTOList(attachmentDTOList);
        saleTenderProjectMarginItemVO.setRelationId(tenderProjectMarginItemVO.getId());
        SaleTenderProjectMarginItem saleTenderProjectMarginItem = this.saleTenderProjectMarginHeadService.addMargin(saleTenderProjectMarginItemVO);
        tenderProjectMarginItem.setRelationId(saleTenderProjectMarginItem.getId());
        boolean marginItemCount = this.purchaseTenderProjectMarginItemService.updateById((Object)tenderProjectMarginItem);
        Assert.isTrue((boolean)marginItemCount, (String)I18nUtil.translate((String)"i18n_field_DJKmWAPcWFIKXWVVVXVSDJHrW_5e42679e", (String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5f53\u524d\u884c\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        if (TenderProjectMarginItemStatusEnum.CONFIRMED.getValue().equals(status)) {
            this.confirmMargin(Arrays.asList(tenderProjectMarginItem.getId()));
        }
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(tenderProjectMarginItemVO.getAttachmentDTOList(), tenderProjectMarginItemVO.getId(), tenderProjectMarginItemVO.getSubpackageId(), tenderProjectMarginItemVO.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.EARNEST_MONEY.getValue());
        return tenderProjectMarginItem;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmMargin(List<String> ids) {
        LambdaQueryWrapper marginItemQw = new LambdaQueryWrapper();
        marginItemQw.in(BaseEntity::getId, ids);
        List tenderProjectMarginItems = this.purchaseTenderProjectMarginItemService.list((Wrapper)marginItemQw);
        tenderProjectMarginItems.forEach(tenderProjectMarginItem -> {
            Assert.isTrue((boolean)TenderProjectMarginItemStatusEnum.SUBMIT.getValue().equals(tenderProjectMarginItem.getStatus()), (String)I18nUtil.translate((String)"i18n_field_APWFzExiTRL_21934657", (String)"\u5f53\u524d\u6570\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u786e\u8ba4"));
            tenderProjectMarginItem.setStatus(TenderProjectMarginItemStatusEnum.CONFIRMED.getValue());
        });
        boolean marginItemCount = this.purchaseTenderProjectMarginItemService.updateBatchById(tenderProjectMarginItems);
        Assert.isTrue((boolean)marginItemCount, (String)I18nUtil.translate((String)"i18n_field_RLKmWAPcWFIKXWVVVXVSDJHrW_1921253c", (String)"\u786e\u8ba4\u5931\u8d25\uff0c\u5f53\u524d\u884c\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        Map<String, List<PurchaseTenderProjectMarginItem>> marginItemMap = tenderProjectMarginItems.stream().collect(Collectors.groupingBy(PurchaseTenderProjectMarginItem::getHeadId));
        Set headIds = tenderProjectMarginItems.stream().map(PurchaseTenderProjectMarginItem::getHeadId).collect(Collectors.toSet());
        List purchaseTenderProjectMarginHeads = ((PurchaseTenderProjectMarginHeadMapper)this.baseMapper).selectBatchIds(headIds);
        log.info("\u7f34\u7eb3\u4fe1\u606fheadIds\uff1a{}\uff0c\u67e5\u8be2\u7ed3\u679c{}", headIds, JSON.toJSON((Object)purchaseTenderProjectMarginHeads));
        Assert.isTrue((headIds.size() == purchaseTenderProjectMarginHeads.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_MKSXWFWVXVsK_54dec862", (String)"\u5b58\u5728\u65e0\u6548\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5"));
        for (PurchaseTenderProjectMarginHead marginHead : purchaseTenderProjectMarginHeads) {
            List<PurchaseTenderProjectMarginItem> marginItemList = marginItemMap.get(marginHead.getId());
            BigDecimal totalAmount = marginItemList.stream().map(PurchaseTenderProjectMarginItem::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal paidTotalAmount = marginHead.getPaidTotalAmount() == null ? BigDecimal.ZERO : marginHead.getPaidTotalAmount();
            BigDecimal paidAmount = marginHead.getPaidAmount() == null ? BigDecimal.ZERO : marginHead.getPaidAmount();
            marginHead.setPaidTotalAmount(paidTotalAmount.add(totalAmount));
            marginHead.setPaidAmount(paidAmount.add(totalAmount));
            BigDecimal guaranteePaidAmount = marginItemList.stream().filter(item -> TenderProjectMarginItemMarginCollectionTypeEnum.LETTER_GUARANTEE.getValue().equals(item.getMarginCollectionType())).map(PurchaseTenderProjectMarginItem::getAmount).reduce(marginHead.getGuaranteePaidAmount(), BigDecimal::add);
            marginHead.setGuaranteePaidAmount(guaranteePaidAmount);
            String marginHeadStatus = marginHead.getDueAmount().compareTo(marginHead.getPaidAmount()) == 1 ? TenderProjectMarginHeadStatusEnum.PART_PAID.getValue() : TenderProjectMarginHeadStatusEnum.PAID.getValue();
            marginHead.setStatus(marginHeadStatus);
        }
        boolean marginHeadCount = this.updateBatchById(purchaseTenderProjectMarginHeads);
        Assert.isTrue((boolean)marginHeadCount, (String)I18nUtil.translate((String)"i18n_field_RLKmWAPWFIKXWVVVXVSDJHrW_875c750", (String)"\u786e\u8ba4\u5931\u8d25\uff0c\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.saleTenderProjectMarginHeadService.confirmMargin(purchaseTenderProjectMarginHeads, tenderProjectMarginItems);
        PurchaseTenderProjectMarginItem marginItem = (PurchaseTenderProjectMarginItem)((Object)tenderProjectMarginItems.get(0));
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(marginItem.getTenderProjectId()).append("&subpackageId=").append(marginItem.getSubpackageId());
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)marginItem.getSubpackageId())));
        List accountList = tenderProjectMarginItems.stream().map(PurchaseTenderProjectMarginItem::getSupplierAccount).collect(Collectors.toList());
        String idStr = IdWorker.getIdStr();
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)subpackageInfo)));
        jsonObject.put("urlParams", (Object)urlParams);
        this.redisUtil.set(idStr, (Object)jsonObject, 172800L);
        super.sendMessage(TenantContext.getTenant(), "tender", "tenderConfirmPayment", idStr, "tenderBusDataServiceImpl", accountList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void reject(String id) {
        PurchaseTenderProjectMarginItem tenderProjectMarginItem = (PurchaseTenderProjectMarginItem)((Object)this.purchaseTenderProjectMarginItemService.getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)TenderProjectMarginItemStatusEnum.SUBMIT.getValue().equals(tenderProjectMarginItem.getStatus()), (String)I18nUtil.translate((String)"i18n_field_APWFzExiTYM_2195ec3f", (String)"\u5f53\u524d\u6570\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u9000\u56de"));
        tenderProjectMarginItem.setStatus(TenderProjectMarginItemStatusEnum.REFUSED.getValue());
        boolean marginItemCount = this.purchaseTenderProjectMarginItemService.updateById((Object)tenderProjectMarginItem);
        Assert.isTrue((boolean)marginItemCount, (String)I18nUtil.translate((String)"i18n_field_FKKmWAPcWFIKXWVVVXVSDJHrW_9d78a047", (String)"\u62d2\u7edd\u5931\u8d25\uff0c\u5f53\u524d\u884c\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.saleTenderProjectMarginHeadService.reject(tenderProjectMarginItem.getRelationId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void refund(List<PurchaseTenderProjectRefund> purchaseTenderProjectRefunds) {
        Set<String> supplierList = purchaseTenderProjectRefunds.stream().map(PurchaseTenderProjectRefund::getSupplierAccount).collect(Collectors.toSet());
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(supplierList), (String)I18nUtil.translate((String)"i18n_field_sWxOLVW_5bfbf8e3", (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!"));
        this.checkRefundParam(purchaseTenderProjectRefunds);
        LambdaQueryWrapper marginHeadQw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)marginHeadQw.eq(PurchaseTenderProjectMarginHead::getSubpackageId, (Object)purchaseTenderProjectRefunds.get(0).getSubpackageId())).in(PurchaseTenderProjectMarginHead::getSupplierAccount, supplierList);
        List tenderProjectMarginHeads = ((PurchaseTenderProjectMarginHeadMapper)this.baseMapper).selectList((Wrapper)marginHeadQw);
        this.checkRefundAmount(purchaseTenderProjectRefunds, supplierList, tenderProjectMarginHeads);
        Assert.isTrue((tenderProjectMarginHeads.size() == supplierList.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_eBtLxOLVW_df534627", (String)"\u6295\u6807\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!"));
        Map<String, PurchaseTenderProjectMarginHead> supplierMap = tenderProjectMarginHeads.stream().collect(Collectors.toMap(PurchaseTenderProjectMarginHead::getSupplierAccount, marginHead -> marginHead, (o1, o2) -> o1));
        for (PurchaseTenderProjectRefund purchaseTenderProjectRefund : purchaseTenderProjectRefunds) {
            PurchaseTenderProjectMarginHead purchaseTenderProjectMarginHead = supplierMap.get(purchaseTenderProjectRefund.getSupplierAccount());
            purchaseTenderProjectRefund.setHeadId(purchaseTenderProjectMarginHead.getId());
            purchaseTenderProjectRefund.setId(IdWorker.getIdStr());
            purchaseTenderProjectRefund.setElsAccount(purchaseTenderProjectMarginHead.getElsAccount());
            if (TenderProjectMarginRefundTypeEnum.OTHER.getValue().equals(purchaseTenderProjectRefund.getRefundType())) {
                purchaseTenderProjectRefund.setLockedAmount(BigDecimal.ZERO);
                purchaseTenderProjectRefund.setStatus(TenderProjectMarginRefundStatusEnum.REFUNDED.getValue());
            }
            BigDecimal paidAmount = purchaseTenderProjectMarginHead.getPaidAmount().subtract(purchaseTenderProjectRefund.getRefundAmount()).subtract(purchaseTenderProjectRefund.getLockedAmount());
            purchaseTenderProjectMarginHead.setPaidAmount(paidAmount);
            if (BigDecimal.ZERO.compareTo(paidAmount) != 0) continue;
            purchaseTenderProjectMarginHead.setStatus(TenderProjectMarginHeadStatusEnum.REFUNDED.getValue());
        }
        ArrayList saleTenderProjectRefunds = SysUtil.copyProperties(purchaseTenderProjectRefunds, SaleTenderProjectRefund.class);
        for (int i = 0; i < saleTenderProjectRefunds.size(); ++i) {
            SaleTenderProjectRefund saleTenderProjectRefund = (SaleTenderProjectRefund)((Object)saleTenderProjectRefunds.get(i));
            PurchaseTenderProjectRefund purchaseTenderProjectRefund = purchaseTenderProjectRefunds.get(i);
            saleTenderProjectRefund.setRelationId(purchaseTenderProjectRefund.getId());
            saleTenderProjectRefund.setId(IdWorker.getIdStr());
            purchaseTenderProjectRefund.setRelationId(saleTenderProjectRefund.getId());
        }
        this.saleTenderProjectMarginHeadService.refund(tenderProjectMarginHeads, saleTenderProjectRefunds);
        this.purchaseTenderProjectRefundService.saveBatch(purchaseTenderProjectRefunds);
        boolean marginHeadCount = this.updateBatchById(tenderProjectMarginHeads);
        Assert.isTrue((boolean)marginHeadCount, (String)I18nUtil.translate((String)"i18n_field_YVKmWVVVXVSDJHrW_84245fd3", (String)"\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        PurchaseTenderProjectMarginHead marginHead2 = (PurchaseTenderProjectMarginHead)((Object)tenderProjectMarginHeads.get(0));
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(marginHead2.getTenderProjectId()).append("&subpackageId=").append(marginHead2.getSubpackageId());
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)marginHead2.getSubpackageId())));
        ArrayList<String> accountList = new ArrayList<String>(supplierList);
        this.sendMsg(TenantContext.getTenant(), accountList, (Object)subpackageInfo, urlParams.toString(), "tender", "tenderRefundPayment");
        String idStr = IdWorker.getIdStr();
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)subpackageInfo)));
        jsonObject.put("urlParams", (Object)urlParams);
        this.redisUtil.set(idStr, (Object)jsonObject, 172800L);
        super.sendMessage(TenantContext.getTenant(), "tender", "tenderRefundPayment", idStr, "tenderBusDataServiceImpl", accountList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addFrozenAmount(String subpackageId, String supplierAccount, BigDecimal frozenAmount) {
        LambdaQueryWrapper marginHeadQw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)marginHeadQw.eq(PurchaseTenderProjectMarginHead::getSubpackageId, (Object)subpackageId)).eq(PurchaseTenderProjectMarginHead::getSupplierAccount, (Object)supplierAccount);
        List tenderProjectMarginHeads = ((PurchaseTenderProjectMarginHeadMapper)this.baseMapper).selectList((Wrapper)marginHeadQw);
        PurchaseTenderProjectMarginHead purchaseTenderProjectMarginHead = (PurchaseTenderProjectMarginHead)((Object)tenderProjectMarginHeads.get(0));
        BigDecimal dbFrozenAmount = purchaseTenderProjectMarginHead.getFrozenAmount() == null ? BigDecimal.ZERO : purchaseTenderProjectMarginHead.getFrozenAmount();
        BigDecimal deductAmount = purchaseTenderProjectMarginHead.getDeductAmount() == null ? BigDecimal.ZERO : purchaseTenderProjectMarginHead.getDeductAmount();
        BigDecimal availableAmount = purchaseTenderProjectMarginHead.getPaidAmount().subtract(purchaseTenderProjectMarginHead.getGuaranteePaidAmount()).subtract(purchaseTenderProjectMarginHead.getFrozenAmount()).subtract(deductAmount);
        Assert.isTrue((availableAmount.compareTo(frozenAmount) > -1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_siHUfxVWShnV_d3907398", (String)"\u4fdd\u8bc1\u91d1\u4f59\u989d\u4e0d\u8db3,\u65e0\u6cd5\u62b5\u6263"));
        purchaseTenderProjectMarginHead.setFrozenAmount(dbFrozenAmount.add(frozenAmount));
        ((PurchaseTenderProjectMarginHeadMapper)this.baseMapper).updateById((Object)purchaseTenderProjectMarginHead);
        SaleTenderProjectMarginHead saleTenderProjectMarginHead = new SaleTenderProjectMarginHead();
        saleTenderProjectMarginHead.setId(purchaseTenderProjectMarginHead.getRelationId());
        saleTenderProjectMarginHead.setFrozenAmount(purchaseTenderProjectMarginHead.getFrozenAmount());
        this.saleTenderProjectMarginHeadService.updateById((Object)saleTenderProjectMarginHead);
    }

    @Override
    public List<PurchaseTenderProjectMarginHead> selectBySubpackageIds(List<String> supackageIdList) {
        if (CollectionUtil.isEmpty(supackageIdList)) {
            return Collections.emptyList();
        }
        return ((PurchaseTenderProjectMarginHeadMapper)this.baseMapper).selectBySubpackageIds(supackageIdList);
    }

    @Override
    public void addMarginDeductRecord(PurchaseTenderBidWinningServiceFeeHead purchaseTenderBidWinningServiceFeeHead, List<PurchaseTenderBidWinningServiceFeeItem> purchaseTenderBidWinningServiceFeeItems) {
        LambdaQueryWrapper marginHeadQw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)marginHeadQw.eq(PurchaseTenderProjectMarginHead::getSubpackageId, (Object)purchaseTenderBidWinningServiceFeeHead.getSubpackageId())).eq(PurchaseTenderProjectMarginHead::getSupplierAccount, (Object)purchaseTenderBidWinningServiceFeeHead.getSupplierAccount());
        List tenderProjectMarginHeads = ((PurchaseTenderProjectMarginHeadMapper)this.baseMapper).selectList((Wrapper)marginHeadQw);
        PurchaseTenderProjectMarginHead purchaseTenderProjectMarginHead = (PurchaseTenderProjectMarginHead)((Object)tenderProjectMarginHeads.get(0));
        BigDecimal totalPaymentMarginAmount = purchaseTenderBidWinningServiceFeeItems.stream().map(PurchaseTenderBidWinningServiceFeeItem::getPaymentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        purchaseTenderProjectMarginHead.setFrozenAmount(purchaseTenderProjectMarginHead.getFrozenAmount().subtract(totalPaymentMarginAmount));
        SaleTenderProjectMarginHead saleTenderProjectMarginHead = new SaleTenderProjectMarginHead();
        if (TenderProjectMarginHeadStatusEnum.PAID.getValue().equals(purchaseTenderBidWinningServiceFeeHead.getStatus())) {
            PurchaseTenderProjectMarginDeductRecord deductRecord = new PurchaseTenderProjectMarginDeductRecord();
            deductRecord.setHeadId(purchaseTenderProjectMarginHead.getId());
            deductRecord.setServiceFeeId(purchaseTenderBidWinningServiceFeeHead.getId());
            deductRecord.setTenderProjectId(purchaseTenderBidWinningServiceFeeHead.getTenderProjectId());
            deductRecord.setSubpackageId(purchaseTenderBidWinningServiceFeeHead.getSubpackageId());
            deductRecord.setSupplierAccount(purchaseTenderBidWinningServiceFeeHead.getSupplierAccount());
            deductRecord.setSupplierName(purchaseTenderBidWinningServiceFeeHead.getSupplierName());
            deductRecord.setDeductAmount(totalPaymentMarginAmount);
            deductRecord.setDeductType(TenderProjectMarginDeductTypeEnum.BID_WINNING_SERVICE_FEE.getValue());
            this.tenderProjectMarginDeductRecordService.save((Object)deductRecord);
            SaleTenderProjectMarginDeductRecord saleTenderProjectMarginDeductRecord = (SaleTenderProjectMarginDeductRecord)((Object)SysUtil.copyProperties((Object)((Object)deductRecord), SaleTenderProjectMarginDeductRecord.class));
            saleTenderProjectMarginDeductRecord.setId(IdWorker.getIdStr());
            saleTenderProjectMarginDeductRecord.setHeadId(purchaseTenderProjectMarginHead.getRelationId());
            saleTenderProjectMarginDeductRecord.setElsAccount(purchaseTenderBidWinningServiceFeeHead.getSupplierAccount());
            this.saleTenderProjectMarginDeductRecordService.save((Object)saleTenderProjectMarginDeductRecord);
            BigDecimal deductAmount = purchaseTenderProjectMarginHead.getDeductAmount() == null ? BigDecimal.ZERO : purchaseTenderProjectMarginHead.getDeductAmount();
            purchaseTenderProjectMarginHead.setDeductAmount(deductAmount.add(totalPaymentMarginAmount));
            saleTenderProjectMarginHead.setDeductAmount(deductAmount.add(totalPaymentMarginAmount));
        }
        ((PurchaseTenderProjectMarginHeadMapper)this.baseMapper).updateById((Object)purchaseTenderProjectMarginHead);
        saleTenderProjectMarginHead.setId(purchaseTenderProjectMarginHead.getRelationId());
        saleTenderProjectMarginHead.setFrozenAmount(purchaseTenderProjectMarginHead.getFrozenAmount());
        this.saleTenderProjectMarginHeadService.updateById((Object)saleTenderProjectMarginHead);
    }

    private void checkMarginItemParam(PurchaseTenderProjectMarginItem tenderProjectMarginItem) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getTenderProjectId()), (String)I18nUtil.translate((String)"i18n_field_dIxOLVW_2db2c59c", (String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getSubpackageId()), (String)I18nUtil.translate((String)"i18n_alert_zsxOLVW_2edb7bb2", (String)"\u5206\u5305\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_field_eBtLxOLVW_df534627", (String)"\u6295\u6807\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getSupplierName()), (String)I18nUtil.translate((String)"i18n_field_eBtLRLxOLVW_b6922b04", (String)"\u6295\u6807\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getMarginCollectionType()), (String)I18nUtil.translate((String)"i18n_field_siHlMCKxOLVW_d85cd1ce", (String)"\u4fdd\u8bc1\u91d1\u6536\u53d6\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)tenderProjectMarginItem.getAmount()), (String)I18nUtil.translate((String)"i18n_field_siHHfxOLVW_62315538", (String)"\u4fdd\u8bc1\u91d1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!"));
        if (TenderProjectMarginItemMarginCollectionTypeEnum.LETTER_GUARANTEE.getValue().equals(tenderProjectMarginItem.getMarginCollectionType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getGuarantor()), (String)I18nUtil.translate((String)"i18n_field_tsLxOLVW_b99c6f4f", (String)"\u62c5\u4fdd\u4eba\u4e0d\u80fd\u4e3a\u7a7a!"));
        } else if (TenderProjectMarginItemMarginCollectionTypeEnum.OTHER.getValue().equals(tenderProjectMarginItem.getMarginCollectionType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getPayAccount()), (String)I18nUtil.translate((String)"i18n_field_MVeyxOLVW_bc58ed69", (String)"\u6c47\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getPayName()), (String)I18nUtil.translate((String)"i18n_field_MVeDRxOLVW_2553840c", (String)"\u6c47\u6b3e\u8d26\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getBankName()), (String)I18nUtil.translate((String)"i18n_field_vDcxOLVW_2c48a33c", (String)"\u5f00\u6237\u884c\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getPayType()), (String)I18nUtil.translate((String)"i18n_field_JpCKCKxOLVW_40b60f06", (String)"\u7f34\u7eb3\u65b9\u5f0f\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        } else {
            Assert.isTrue((boolean)false, (String)I18nUtil.translate((String)"i18n_field_PxRuWTxJeyeRWCKRBW_2dc93e83", (String)"\u6682\u4e0d\u652f\u6301\u3010\u865a\u62df\u5b50\u8d26\u53f7\u6258\u7ba1\u3011\u65b9\u5f0f\u652f\u4ed8!"));
        }
    }

    private void checkRefundParam(List<PurchaseTenderProjectRefund> purchaseTenderProjectRefunds) {
        for (PurchaseTenderProjectRefund tenderProjectRefund : purchaseTenderProjectRefunds) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectRefund.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_field_eBtLxOLVW_df534627", (String)"\u6295\u6807\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectRefund.getSupplierName()), (String)I18nUtil.translate((String)"i18n_field_eBtLRLxOLVW_b6922b04", (String)"\u6295\u6807\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectRefund.getRefundType()), (String)I18nUtil.translate((String)"i18n_field_YVCKCKxOLVW_192a90a7", (String)"\u9000\u6b3e\u65b9\u5f0f\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)tenderProjectRefund.getRefundAmount()), (String)I18nUtil.translate((String)"i18n_field_YVHfxOLVW_507f93a7", (String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((BigDecimal.ZERO.compareTo(tenderProjectRefund.getRefundAmount()) == -1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_YVHfxOXUWWWW_dde28d72", (String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e[0]!"));
            if (TenderProjectMarginRefundTypeEnum.OTHER.getValue().equals(tenderProjectRefund.getRefundType())) {
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectRefund.getRefundAccount()), (String)I18nUtil.translate((String)"i18n_field_YVeyxOLVW_3cfa4822", (String)"\u9000\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectRefund.getRefundName()), (String)I18nUtil.translate((String)"i18n_field_YVeyDRxOLVW_e4d8d0ec", (String)"\u9000\u6b3e\u8d26\u53f7\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectRefund.getBankName()), (String)I18nUtil.translate((String)"i18n_field_YVeDvDcxOLVW_82cf21cb", (String)"\u9000\u6b3e\u8d26\u6237\u5f00\u6237\u884c\u4e0d\u80fd\u4e3a\u7a7a!"));
                continue;
            }
            Assert.isTrue((boolean)false, (String)I18nUtil.translate((String)"i18n_field_PxRuW_c9880304", (String)"\u6682\u4e0d\u652f\u6301!"));
        }
    }

    private void checkRefundAmount(List<PurchaseTenderProjectRefund> purchaseTenderProjectRefunds, Set<String> supplierList, List<PurchaseTenderProjectMarginHead> tenderProjectMarginHeads) {
        PurchaseTenderProjectRefund projectRefund = purchaseTenderProjectRefunds.get(0);
        LambdaQueryWrapper marginRefundQw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)marginRefundQw.eq(PurchaseTenderProjectRefund::getSubpackageId, (Object)projectRefund.getSubpackageId())).eq(PurchaseTenderProjectRefund::getRefundType, (Object)projectRefund.getRefundType())).in(PurchaseTenderProjectRefund::getSupplierAccount, supplierList);
        List purchaseTenderProjectRefundList = this.purchaseTenderProjectRefundService.list((Wrapper)marginRefundQw);
        Map<String, List<PurchaseTenderProjectRefund>> refundMap = purchaseTenderProjectRefundList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectRefund::getSupplierAccount));
        Map<String, PurchaseTenderProjectMarginHead> marginHeadMap = tenderProjectMarginHeads.stream().collect(Collectors.toMap(PurchaseTenderProjectMarginHead::getSupplierAccount, marginHead -> marginHead, (o1, o2) -> o1));
        LambdaQueryWrapper marginItemQw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)marginItemQw.eq(PurchaseTenderProjectMarginItem::getSubpackageId, (Object)projectRefund.getSubpackageId())).eq(PurchaseTenderProjectMarginItem::getMarginCollectionType, (Object)projectRefund.getRefundType())).eq(PurchaseTenderProjectMarginItem::getStatus, (Object)TenderProjectMarginItemStatusEnum.CONFIRMED.getValue())).in(PurchaseTenderProjectMarginItem::getSupplierAccount, supplierList);
        List purchaseTenderProjectMarginItems = this.purchaseTenderProjectMarginItemService.list((Wrapper)marginItemQw);
        Map<String, List<PurchaseTenderProjectMarginItem>> marginItemMap = purchaseTenderProjectMarginItems.stream().collect(Collectors.groupingBy(PurchaseTenderProjectMarginItem::getSupplierAccount));
        for (PurchaseTenderProjectRefund purchaseTenderProjectRefund : purchaseTenderProjectRefunds) {
            BigDecimal usrAmount;
            PurchaseTenderProjectMarginHead purchaseTenderProjectMarginHead = marginHeadMap.get(purchaseTenderProjectRefund.getSupplierAccount());
            List<PurchaseTenderProjectRefund> refunds = refundMap.get(purchaseTenderProjectRefund.getSupplierAccount());
            List<PurchaseTenderProjectMarginItem> marginItemList = marginItemMap.get(purchaseTenderProjectRefund.getSupplierAccount());
            Assert.isTrue((boolean)CollectionUtil.isNotEmpty(marginItemList), (String)I18nUtil.translate((String)"i18n_field_MKRdXrSrAcJutHWxqYVW_eb3710fc", (String)"\u5b58\u5728\u4f9b\u5e94\u5546\u8be5\u65e0\u8be5\u7c7b\u578b\u7f34\u8d39\u8bb0\u5f55\uff0c\u4e0d\u53ef\u9000\u6b3e!"));
            BigDecimal paidAmount = marginItemList.stream().map(PurchaseTenderProjectMarginItem::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal frozenAmount = purchaseTenderProjectMarginHead.getFrozenAmount() == null ? BigDecimal.ZERO : purchaseTenderProjectMarginHead.getFrozenAmount();
            BigDecimal deductAmount = purchaseTenderProjectMarginHead.getDeductAmount() == null ? BigDecimal.ZERO : purchaseTenderProjectMarginHead.getDeductAmount();
            BigDecimal lockedTotalAmount = purchaseTenderProjectRefund.getLockedAmount().add(frozenAmount).add(deductAmount);
            BigDecimal refundTotalAmount = purchaseTenderProjectRefund.getRefundAmount();
            if (CollectionUtil.isNotEmpty(refunds)) {
                lockedTotalAmount = refunds.stream().filter(refund -> TenderProjectMarginRefundStatusEnum.REFUNDING.getValue().equals(refund.getStatus())).map(PurchaseTenderProjectRefund::getLockedAmount).reduce(lockedTotalAmount, BigDecimal::add);
                refundTotalAmount = refunds.stream().filter(refund -> TenderProjectMarginRefundStatusEnum.REFUNDING.getValue().equals(refund.getStatus())).map(PurchaseTenderProjectRefund::getRefundAmount).reduce(refundTotalAmount, BigDecimal::add);
            }
            Assert.isTrue((paidAmount.compareTo(usrAmount = lockedTotalAmount.add(refundTotalAmount)) > -1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_YVHfBGqjUfW_b9c32ea5", (String)"\u9000\u6b3e\u91d1\u989d\u8d85\u51fa\u53ef\u7528\u4f59\u989d!"));
        }
    }

    private void saveAttachment(String mainId, List<PurchaseAttachmentDTO> attachmentDTOList) {
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(mainId);
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            attachmentDTOList.parallelStream().forEach(attachment -> {
                attachment.setHeadId(mainId);
                attachment.setId(IdWorker.getIdStr());
            });
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentDTOList);
        }
    }
}

