/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.template.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.common.service.PurchaseTenderTemplateParse;
import com.els.modules.tender.common.service.impl.PurchaseTenderTemplateParsetImpl;
import com.els.modules.tender.common.vo.GenerateTemplateVO;
import com.els.modules.tender.common.vo.ParseTemplateParamVO;
import com.els.modules.tender.template.entity.PurchaseTenderTemplateLibrary;
import com.els.modules.tender.template.entity.PurchaseTenderVariableLibrary;
import com.els.modules.tender.template.enumerate.TemplateLibraryStatusEnum;
import com.els.modules.tender.template.mapper.PurchaseTenderTemplateLibraryMapper;
import com.els.modules.tender.template.service.PurchaseTenderTemplateLibraryService;
import com.els.modules.tender.template.service.PurchaseTenderVariableLibraryService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderTemplateLibraryServiceImpl
extends BaseServiceImpl<PurchaseTenderTemplateLibraryMapper, PurchaseTenderTemplateLibrary>
implements PurchaseTenderTemplateLibraryService {
    @Autowired
    PurchaseTenderTemplateParse parseTemplate;
    @Autowired
    PurchaseTenderVariableLibraryService variableLibraryService;
    @Resource
    private InvokeBaseRpcService baseRpcService;

    @Override
    public void add(PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary) {
        purchaseTenderTemplateLibrary.setBusinessType("tender");
        purchaseTenderTemplateLibrary.setTemplateLibraryNumber(this.baseRpcService.getNextCode("tenderTemplateLibraryNumber", (Object)purchaseTenderTemplateLibrary));
        purchaseTenderTemplateLibrary.setStatus(TemplateLibraryStatusEnum.NEW.getValue());
        ((PurchaseTenderTemplateLibraryMapper)this.baseMapper).insert((Object)purchaseTenderTemplateLibrary);
    }

    @Override
    public void edit(PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary) {
        purchaseTenderTemplateLibrary.setStatus(TemplateLibraryStatusEnum.NEW.getValue());
        int count = ((PurchaseTenderTemplateLibraryMapper)this.baseMapper).updateById((Object)purchaseTenderTemplateLibrary);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseTenderTemplateLibraryMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseTenderTemplateLibraryMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary) {
        if (StringUtils.isBlank((CharSequence)purchaseTenderTemplateLibrary.getId())) {
            this.add(purchaseTenderTemplateLibrary);
        } else {
            this.edit(purchaseTenderTemplateLibrary);
        }
        PurchaseTenderTemplateLibrary templateLibrary = (PurchaseTenderTemplateLibrary)((Object)((PurchaseTenderTemplateLibraryMapper)this.baseMapper).selectById((Serializable)((Object)purchaseTenderTemplateLibrary.getId())));
        Assert.notNull((Object)((Object)templateLibrary), (String)I18nUtil.translate((String)"i18n_alert_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c!"));
        Assert.hasText((String)purchaseTenderTemplateLibrary.getTemplateTitle(), (String)I18nUtil.translate((String)"i18n_alert_IrRLxOLVW_6b53c530", (String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)purchaseTenderTemplateLibrary.getTemplateContent(), (String)I18nUtil.translate((String)"i18n_alert_IrCcxOLVW_f5509c7f", (String)"\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)purchaseTenderTemplateLibrary.getTemplateType(), (String)I18nUtil.translate((String)"i18n_alert_IrAcxOLVW_6e64ce63", (String)"\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)purchaseTenderTemplateLibrary.getPurchaseType(), (String)I18nUtil.translate((String)"i18n_alert_nRCKxOLVW_19d23855", (String)"\u91c7\u8d2d\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)purchaseTenderTemplateLibrary.getProjectType(), (String)I18nUtil.translate((String)"i18n_alert_dIzAxOLVW_3305cc7", (String)"\u9879\u76ee\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a!"));
        String templateContent = templateLibrary.getTemplateContent();
        Matcher matcher = PurchaseTenderTemplateParsetImpl.p1.matcher(templateContent);
        TreeSet<String> variableSet = new TreeSet<String>();
        while (matcher.find()) {
            variableSet.add(matcher.group());
        }
        if (CollectionUtil.isNotEmpty(variableSet)) {
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.in(PurchaseTenderVariableLibrary::getParamName, variableSet)).eq(PurchaseTenderVariableLibrary::getStatus, (Object)TemplateLibraryStatusEnum.PUBLISH.getValue())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            List variableLibraryList = this.variableLibraryService.list((Wrapper)qw);
            if (CollectionUtil.isEmpty((Collection)variableLibraryList)) {
                qw.clear();
                ((LambdaQueryWrapper)qw.eq(PurchaseTenderVariableLibrary::getStatus, (Object)TemplateLibraryStatusEnum.PUBLISH.getValue())).eq(BaseEntity::getElsAccount, (Object)"100000");
                variableLibraryList = this.variableLibraryService.list((Wrapper)qw);
            }
            List paramNameList = variableLibraryList.stream().map(PurchaseTenderVariableLibrary::getParamName).collect(Collectors.toList());
            for (String paramName : variableSet) {
                Assert.isTrue((boolean)paramNameList.contains(paramName), (String)I18nUtil.translate((String)"i18n_alert_IrhxKmWMKShKqARWWWWVeRjiARVtAtIrW_75efe356", (String)"\u6a21\u677f\u53d1\u5e03\u5931\u8d25\uff0c\u5b58\u5728\u65e0\u6cd5\u8bc6\u522b\u53d8\u91cf{0}\uff0c\u8bf7\u901a\u8fc7\u53f3\u4fa7\u53d8\u91cf\u6e05\u5355\u7f16\u8f91\u6a21\u677f!", (String[])new String[]{paramName}));
            }
        }
        Assert.isTrue((boolean)TemplateLibraryStatusEnum.NEW.getValue().equals(templateLibrary.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_VSVBhxW_dd300447", (String)"\u8bf7\u52ff\u91cd\u590d\u53d1\u5e03!"));
        purchaseTenderTemplateLibrary.setStatus(TemplateLibraryStatusEnum.PUBLISH.getValue());
        ((PurchaseTenderTemplateLibraryMapper)this.baseMapper).updateById((Object)purchaseTenderTemplateLibrary);
    }

    @Override
    public GenerateTemplateVO generate(ParseTemplateParamVO parseTemplateParamVO) {
        Assert.hasText((String)parseTemplateParamVO.getTemplateLibraryId(), (String)I18nUtil.translate((String)"i18n_alert_IrWWxOLVW_a5f3a298", (String)"\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)parseTemplateParamVO.getBusinessId(), (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLVW_6f2a282f", (String)"\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a!"));
        return new GenerateTemplateVO(this.parseTemplate.parseTemplate(parseTemplateParamVO));
    }

    @Override
    public GenerateTemplateVO templatePreview(PurchaseTenderTemplateLibrary templateLibrary) {
        return this.parseTemplate.templatePreview(templateLibrary);
    }

    @Override
    public PurchaseTenderTemplateLibrary copyTemplate(String id) {
        PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary = (PurchaseTenderTemplateLibrary)((Object)((PurchaseTenderTemplateLibraryMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)purchaseTenderTemplateLibrary), (String)I18nUtil.translate((String)"i18n_alert_uhtkW_8806a13b", (String)"\u975e\u6cd5\u64cd\u4f5c!"));
        Assert.isTrue((boolean)TemplateLibraryStatusEnum.PUBLISH.getValue().equals(purchaseTenderTemplateLibrary.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_VhxKHcBRW_82c52f63", (String)"\u8bf7\u53d1\u5e03\u518d\u8fdb\u884c\u590d\u5236!"));
        PurchaseTenderTemplateLibrary templateLibrary = (PurchaseTenderTemplateLibrary)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderTemplateLibrary), PurchaseTenderTemplateLibrary.class));
        templateLibrary.setId(IdWorker.getIdStr());
        this.add(templateLibrary);
        return templateLibrary;
    }
}

