/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSAgainException;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.impl.PurchaseClarificationInfoServiceImpl;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.PurchaseContractItemDTO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.entity.PurchaseEbiddingConfirm;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.entity.SaleEbiddingItemHis;
import com.els.modules.ebidding.enumerate.EbiddingDelayRuleEnum;
import com.els.modules.ebidding.enumerate.EbiddingItemStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingRangeUnitEnum;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingScopeEnum;
import com.els.modules.ebidding.enumerate.EbiddingStartWayEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeHisEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.job.utils.EbiddingJobUtil;
import com.els.modules.ebidding.mapper.PurchaseEbiddingHeadMapper;
import com.els.modules.ebidding.mapper.PurchaseEbiddingItemHisMapper;
import com.els.modules.ebidding.service.PublicEbiddingService;
import com.els.modules.ebidding.service.PurchaseEbiddingConfirmService;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemHisService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingItemHisService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.service.impl.SaleEbiddingHeadServiceImpl;
import com.els.modules.ebidding.service.impl.SaleEbiddingItemHisServiceImpl;
import com.els.modules.ebidding.service.impl.SaleEbiddingItemServiceImpl;
import com.els.modules.ebidding.vo.PurchaseAwardOpinionVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingConfirmVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingMessageVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingPrintVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingSupplierVO;
import com.els.modules.inquiry.entity.PurchaseAwardOpinion;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.enumerate.PricingNoticeEnum;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.enumerate.QuotaWayEnum;
import com.els.modules.inquiry.enumerate.RegretFlagEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.enumerate.SrmPublicScopeEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.inquiry.rpc.service.InquiryWorkflowAuditDataRpcService;
import com.els.modules.inquiry.service.PublishToB2BService;
import com.els.modules.inquiry.service.PurchaseAwardOpinionService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.rocketMq.util.InitTableMqUtil;
import com.els.modules.rpc.service.InquiryInvokeContractService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.workflow.dto.A1FlowTaskTrajectoryDTO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseEbiddingHeadServiceImpl
extends BaseServiceImpl<PurchaseEbiddingHeadMapper, PurchaseEbiddingHead>
implements PurchaseEbiddingHeadService,
PurchaseExecuteReviewService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEbiddingHeadServiceImpl.class);
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingConfirmService purchaseEbiddingConfirmService;
    @Autowired
    private SaleEbiddingHeadService saleEbiddingHeadService;
    @Autowired
    @Lazy
    private PublicEbiddingService publicEbiddingService;
    @Autowired
    private PublishToB2BService publishToB2BService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PurchaseAwardOpinionService purchaseAwardOpinionService;
    @Autowired
    private PurchaseEbiddingItemHisService purchaseEbiddingItemHisService;
    @Autowired
    private RedisUtil redis;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Resource
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Autowired
    private PurchaseEbiddingSupplierService ebiddingSupplierService;
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Resource
    private InquiryWorkflowAuditDataRpcService workflowAuditDataService;
    @Resource
    private InquiryInvokeContractService inquiryInvokeContractService;
    @Resource
    private PurchaseEbiddingItemHisMapper purchaseEbiddingItemHisMapper;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadService;
    private static final String START_PRICE_FLAG = "1";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmVO> confirmList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        SysUtil.setNullCreate((BaseEntity)head);
        head.setEbiddingStatus(EbiddingStatusEnum.NEW.getValue());
        head.setResultAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setDeleted(CommonConstant.DEL_FLAG_0);
        head.setCurrentRound(head.getCurrentRound() == null ? 1 : head.getCurrentRound());
        head.setQuoteFlag(null);
        head.setInviteQuantity(null);
        head.setReplyQuantity(null);
        super.setHeadDefaultValue((BaseEntity)head);
        ((PurchaseEbiddingHeadMapper)this.baseMapper).insert((Object)head);
        if (StringUtils.isNotBlank((CharSequence)head.getDocumentId())) {
            this.invokeBaseRpcService.updateIntegratedDocumentMain("ebiddingHeadId", head.getDocumentId(), head.getDocumentParentId(), head.getId());
        }
        this.insertData(head, itemList, supplierList, attachmentDemandList, confirmList);
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            for (PurchaseAttachmentDTO dto : attachmentDTOList) {
                dto.setHeadId(head.getId());
                dto.setId(IdWorker.getIdStr());
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentDTOList);
        }
        this.sendLink(head, itemList);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmVO> confirmList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        head.setResultAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)head);
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        this.deleteSubTable(head.getId());
        this.insertData(head, itemList, supplierList, attachmentDemandList, confirmList);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(head.getId());
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            for (PurchaseAttachmentDTO dto : attachmentDTOList) {
                dto.setHeadId(head.getId());
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentDTOList);
        }
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
        this.sendLink(head, itemList);
    }

    @Override
    @SrmTransaction
    public void copy(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmVO> confirmList) {
        List<String> headFieldList = Arrays.asList("id", "documentId", "publishTime", "publishUser", "updateBy", "updateTime", "updateById", "createBy", "createTime", "createById", "currentRound", "endTime", "currentDelayCount", "ebiddingAmount", "savingAmount", "savingRate", "savingAmount", "startTime", "currentItemNumber", "flowId", "resultFlowId", "hasQuote");
        super.setFieldValueNull((Object)head, headFieldList);
        head.setEbiddingNumber(this.invokeBaseRpcService.getNextCode("srmEbiddingNumber", (Object)head));
        if (CollectionUtil.isNotEmpty(supplierList)) {
            supplierList.forEach(e -> e.setNeedCoordination(null));
        }
        this.saveMain(head, itemList, supplierList, attachmentDemandList, confirmList, null);
    }

    private void sendLink(PurchaseEbiddingHead headVO, List<PurchaseEbiddingItem> items) {
        JSONArray objects = new JSONArray();
        LoginUser loginUser = SysUtil.getLoginUser();
        JSONObject object = new JSONObject();
        if (headVO != null) {
            object.put("integratedId", (Object)headVO.getDocumentId());
            object.put("elsAccount", (Object)TenantContext.getTenant());
            object.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
            object.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
            object.put("businessType", (Object)"ebidding");
            object.put("businessParentType", null);
            object.put("businessId", (Object)headVO.getId());
            object.put("businessParentId", (Object)headVO.getDocumentParentId());
            object.put("businessDataType", (Object)"head");
            objects.add((Object)object);
        }
        if (!CollectionUtils.isEmpty(items)) {
            for (PurchaseEbiddingItem item : items) {
                JSONObject objectItem = new JSONObject();
                objectItem.put("integratedId", (Object)item.getDocumentItemId());
                objectItem.put("elsAccount", (Object)TenantContext.getTenant());
                objectItem.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                objectItem.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                objectItem.put("businessType", (Object)"ebidding");
                objectItem.put("businessParentType", null);
                objectItem.put("businessId", (Object)item.getId());
                objectItem.put("businessParentId", (Object)item.getDocumentParentId());
                objectItem.put("businessDataType", (Object)"item");
                objects.add((Object)objectItem);
            }
        }
        if (!objects.isEmpty()) {
            MqUtil.sendIntegrateDataLinkMsg((JSONArray)objects, null, null);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        PurchaseEbiddingHead head = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)id)));
        if (StringUtils.isNotBlank((CharSequence)head.getDocumentId())) {
            this.invokeBaseRpcService.delIntegratedDocumentMain("ebiddingHeadId", head.getDocumentId(), head.getDocumentParentId(), head.getId());
        }
        Assert.isTrue((boolean)EbiddingStatusEnum.NEW.getValue().equals(head.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjVIzEIjtFqQG_85452cad", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u4e0b\u7684\u5355\u636e\u53ef\u5220\u9664"));
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.deleteSubTable(id);
    }

    private void deleteSubTable(String headId) {
        List<PurchaseEbiddingItem> items = this.purchaseEbiddingItemService.selectByMainId(headId);
        if (!CollectionUtils.isEmpty(items)) {
            List stringList = items.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            MqUtil.sendIntegrateDataLinkMsg(null, stringList, null);
        }
        this.purchaseEbiddingItemService.deleteByMainId(headId);
        this.purchaseEbiddingSupplierService.deleteByMainId(headId);
        this.purchaseEbiddingConfirmService.deleteByMainId(headId);
        this.goBackDemandUseForDel(items, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(headId);
    }

    private void insertData(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmVO> confirmList) {
        this.purchaseEbiddingItemService.addBatch(head, itemList);
        this.purchaseEbiddingSupplierService.addBatch(head, supplierList);
        this.purchaseEbiddingConfirmService.addBatch(head, confirmList);
        this.invokeBaseRpcService.addPurchaseAttachmentDemandBatch(attachmentDemandList, head.getId(), "ebidding");
    }

    @Override
    public void goBackDemand(List<PurchaseEbiddingItem> itemList, String status) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            ArrayList<String> idList = new ArrayList<String>();
            List<String> idList1 = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId()) && SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType())).map(PurchaseEbiddingItem::getSourceItemId).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(idList1)) {
                idList1.forEach(str -> idList.addAll(Arrays.stream(str.split(",")).collect(Collectors.toList())));
            }
            if (PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue().equals(status) && CollectionUtil.isNotEmpty(idList)) {
                List<String> headIdList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getHeadId())).map(PurchaseEbiddingItem::getHeadId).distinct().collect(Collectors.toList());
                List<PurchaseEbiddingItem> list = this.purchaseEbiddingItemService.findBySourceItemId(headIdList, idList);
                if (!CollectionUtils.isEmpty(list)) {
                    Map<String, List> collect = list.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).collect(Collectors.toMap(PurchaseEbiddingItem::getSourceItemId, p -> {
                        ArrayList<PurchaseEbiddingItem> enquiryItems = new ArrayList<PurchaseEbiddingItem>();
                        enquiryItems.add((PurchaseEbiddingItem)((Object)p));
                        return enquiryItems;
                    }, (value1, value2) -> {
                        value1.addAll(value2);
                        return value1;
                    }));
                    ArrayList<String> ListDauctionsBuilt = new ArrayList<String>();
                    ArrayList<String> ListCompletionOfTheAuction = new ArrayList<String>();
                    Set<String> strings = collect.keySet();
                    for (String string : strings) {
                        List purchaseEbiddingItems = collect.get(string);
                        if (purchaseEbiddingItems.isEmpty()) continue;
                        List collect2 = purchaseEbiddingItems.stream().map(PurchaseEbiddingItem::getHeadId).distinct().collect(Collectors.toList());
                        List purchaseEbiddingHeads = this.listByIds(collect2);
                        List collect3 = purchaseEbiddingHeads.stream().filter(item -> EbiddingStatusEnum.BID_SUCCESS.equals(item.getEbiddingStatus())).collect(Collectors.toList());
                        if (collect3.isEmpty()) {
                            ListDauctionsBuilt.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                            continue;
                        }
                        ListCompletionOfTheAuction.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                    }
                    idList.removeAll(ListDauctionsBuilt);
                    idList.removeAll(ListCompletionOfTheAuction);
                    if (!ListDauctionsBuilt.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListDauctionsBuilt, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
                    }
                    if (!ListCompletionOfTheAuction.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListCompletionOfTheAuction, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
                    }
                    if (!idList.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(idList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                    }
                } else {
                    this.purchaseRequestItemService.updateStatusById(idList, status);
                }
            } else {
                this.purchaseRequestItemService.updateStatusById(idList, status);
            }
        }
    }

    public void goBackDemandUseForDel(List<PurchaseEbiddingItem> itemList, String status) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            ArrayList<String> idList = new ArrayList<String>();
            List<String> idList1 = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId()) && SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType())).map(PurchaseEbiddingItem::getSourceItemId).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(idList1)) {
                idList1.forEach(str -> idList.addAll(Arrays.stream(str.split(",")).collect(Collectors.toList())));
            }
            if (PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue().equals(status) && CollectionUtil.isNotEmpty(idList)) {
                List<String> headIdList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getHeadId())).map(PurchaseEbiddingItem::getHeadId).distinct().collect(Collectors.toList());
                List<PurchaseEbiddingItem> list = this.purchaseEbiddingItemService.findBySourceItemId(headIdList, idList);
                if (!CollectionUtils.isEmpty(list)) {
                    Map<String, List> collect = list.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).collect(Collectors.toMap(PurchaseEbiddingItem::getSourceItemId, p -> {
                        ArrayList<PurchaseEbiddingItem> enquiryItems = new ArrayList<PurchaseEbiddingItem>();
                        enquiryItems.add((PurchaseEbiddingItem)((Object)p));
                        return enquiryItems;
                    }, (value1, value2) -> {
                        value1.addAll(value2);
                        return value1;
                    }));
                    ArrayList<String> ListDauctionsBuilt = new ArrayList<String>();
                    ArrayList<String> ListCompletionOfTheAuction = new ArrayList<String>();
                    Set<String> strings = collect.keySet();
                    for (String string : strings) {
                        List purchaseEbiddingItems = collect.get(string);
                        if (purchaseEbiddingItems.isEmpty()) continue;
                        List collect2 = purchaseEbiddingItems.stream().map(PurchaseEbiddingItem::getHeadId).distinct().collect(Collectors.toList());
                        List purchaseEbiddingHeads = this.listByIds(collect2);
                        List collect3 = purchaseEbiddingHeads.stream().filter(item -> EbiddingStatusEnum.BID_SUCCESS.equals(item.getEbiddingStatus())).collect(Collectors.toList());
                        if (collect3.isEmpty()) {
                            ListDauctionsBuilt.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                            continue;
                        }
                        ListCompletionOfTheAuction.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                    }
                    idList.removeAll(ListDauctionsBuilt);
                    idList.removeAll(ListCompletionOfTheAuction);
                    if (!ListDauctionsBuilt.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListDauctionsBuilt, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
                    }
                    if (!ListCompletionOfTheAuction.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListCompletionOfTheAuction, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
                    }
                    if (!idList.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(idList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                    }
                } else {
                    ArrayList<PurchaseRequestItem> purchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
                    for (String id : idList) {
                        PurchaseRequestItem purchaseRequestItem = (PurchaseRequestItem)((Object)this.purchaseRequestItemService.getById((Serializable)((Object)id)));
                        purchaseRequestItemList.add(purchaseRequestItem);
                    }
                    if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
                        this.purchaseRequestHeadService.matchPrice(purchaseRequestItemList);
                    }
                }
            } else {
                this.purchaseRequestItemService.updateStatusById(idList, status);
            }
        }
    }

    private void checkAndSetParam(PurchaseEbiddingHeadVO headVO) {
        List startPriceList;
        Date beginTime = headVO.getBeginTime();
        Assert.notNull((Object)beginTime, (String)I18nUtil.translate((String)"i18n_alert_OuvKKIxOLVW_50f9240f", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)beginTime.after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_OuvKKIlTfUAPKIW_22eb88a", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff01"));
        BigDecimal keepMinute = headVO.getKeepMinute();
        Assert.notNull((Object)headVO.getChangeRange(), (String)I18nUtil.translate((String)"i18n_alert_umDiBzxOLV_2cd60c7", (String)"\u4ef7\u683c\u8c03\u6574\u5e45\u5ea6\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getRangeUnit(), (String)I18nUtil.translate((String)"i18n_alert_BztLxOLV_3b65a2e9", (String)"\u5e45\u5ea6\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a"));
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            Assert.notNull((Object)keepMinute, (String)I18nUtil.translate((String)"i18n_alert_uTKIWzsWKIxOLVW_78c93f21", (String)"\u6301\u7eed\u65f6\u95f4\uff08\u5206\u949f\uff09\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (START_PRICE_FLAG.equals(headVO.getPurchaseAutoQuote()) && !EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getSetStartPrice()), (String)I18nUtil.translate((String)"i18n_alert_JOsuWlTGRAAu_6bbab75f", (String)"\u81ea\u52a8\u62a5\u4ef7\uff0c\u5fc5\u987b\u8bbe\u7f6e\u8d77\u62cd\u4ef7"));
        }
        if (!EbiddingDelayRuleEnum.NOT_ALLOW_DELAY.getValue().equals(headVO.getDelayRule()) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)headVO.getKeepMinute()) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)headVO.getBeforeEndMinute())) {
            Integer keepMinute1 = Double.valueOf(String.valueOf(headVO.getKeepMinute())).intValue();
            Assert.isTrue((headVO.getBeforeEndMinute() <= keepMinute1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__yWPORzslTXUuTKI_8cb9e8b0", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6301\u7eed\u65f6\u95f4"));
        }
        Integer participateQuantity = headVO.getParticipateQuantity();
        Assert.notNull((Object)participateQuantity, (String)I18nUtil.translate((String)"i18n_alert_sUWRxOLV_988f07b", (String)"\u53c2\u4e0e\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        headVO.setInviteQuantity(supplierList.size());
        String ebiddingScope = StrUtil.isNotBlank((CharSequence)headVO.getEbiddingScope()) ? headVO.getEbiddingScope() : EbiddingScopeEnum.INVITE.getValue();
        headVO.setEbiddingScope(ebiddingScope);
        if (EbiddingScopeEnum.INVITE.getValue().equals(ebiddingScope)) {
            Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_RdXABxOLV_453a9d0e", (String)"\u4f9b\u5e94\u5546\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((participateQuantity.compareTo(headVO.getInviteQuantity()) <= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_RdXjWRlTfUsUWR_3340063e", (String)"\u4f9b\u5e94\u5546\u7684\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u53c2\u4e0e\u6570\u91cf"));
        }
        List<String> checkWayList = Arrays.asList(EbiddingWayEnum.PACKAGE.getValue(), EbiddingWayEnum.BATCH.getValue());
        if (START_PRICE_FLAG.equals(headVO.getSetStartPrice()) && checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.notNull((Object)headVO.getStartTotalAmount(), (String)I18nUtil.translate((String)"i18n_alert_eVHAAuxOLV_8dad61ef", (String)"\u5934\u4fe1\u606f\u8d77\u62cd\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((headVO.getStartTotalAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__AAtudrfUW_6a4d7760", (String)"\u8d77\u62cd\u5355\u4ef7\u5e94\u8be5\u5927\u4e8e0"));
        }
        if (START_PRICE_FLAG.equals(headVO.getSendTargetPrice()) && checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.notNull((Object)headVO.getTargetTotalAmount(), (String)I18nUtil.translate((String)"i18n_alert_eVHIBuxOLV_6094452c", (String)"\u5934\u4fe1\u606f\u76ee\u6807\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (START_PRICE_FLAG.equals(headVO.getSupplierTaxRate())) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getNeedEcho()), (String)I18nUtil.translate((String)"i18n_alert_RdXfIWTPdBlTLK_542b7b05", (String)"\u4f9b\u5e94\u5546\u7a0e\u7387\uff0c\u9700\u8981\u5e94\u6807\u5fc5\u987b\u4e3a\u662f"));
        } else if (checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.hasText((String)headVO.getTaxCode(), (String)I18nUtil.translate((String)"i18n_alert_eVHfoxOLV_ffe669a5", (String)"\u5934\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.hasText((String)headVO.getTaxRate(), (String)I18nUtil.translate((String)"i18n_alert_eVHfIxOLV_c0d1322b", (String)"\u5934\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (START_PRICE_FLAG.equals(headVO.getNeedEcho())) {
            Assert.notNull((Object)headVO.getEchoEndTime(), (String)I18nUtil.translate((String)"i18n_alert_dByRKIxOLV_29c03139", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((boolean)headVO.getEchoEndTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_dByRKIlTfUAPKI_bc6345de", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
            Assert.isTrue((boolean)headVO.getEchoEndTime().before(beginTime), (String)I18nUtil.translate((String)"i18n_alert_dByRKIlTXUOuvKKI_e41cb500", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4"));
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                Assert.notNull((Object)headVO.getIntervalMinute(), (String)I18nUtil.translate((String)"i18n_alert_ImKIxOLV_f1534aee", (String)"\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((headVO.getIntervalMinute().compareTo(BigDecimal.ONE) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_ImKIlTfUEUW_39975591", (String)"\u95f4\u9694\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1"));
            }
            String delayRule = headVO.getDelayRule();
            if (EbiddingDelayRuleEnum.UNLIMITED_DELAY_COUNT.getValue().equals(delayRule)) {
                Assert.notNull((Object)headVO.getBeforeEndMinute(), (String)I18nUtil.translate((String)"i18n_alert_yWPORzsxOLV_61d00fc1", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.notNull((Object)headVO.getDelayMinute(), (String)I18nUtil.translate((String)"i18n_alert_OAzsWxOLV_1b9f0ebe", (String)"\u5ef6\u671f\u5206\u949f\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (EbiddingDelayRuleEnum.LIMIT_DELAY_COUNT.getValue().equals(delayRule)) {
                Assert.notNull((Object)headVO.getBeforeEndMinute(), (String)I18nUtil.translate((String)"i18n_alert_yWPORzsxOLV_61d00fc1", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.notNull((Object)headVO.getDelayMinute(), (String)I18nUtil.translate((String)"i18n_alert_OAzsWxOLV_1b9f0ebe", (String)"\u5ef6\u671f\u5206\u949f\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.notNull((Object)headVO.getDelayCount(), (String)I18nUtil.translate((String)"i18n_alert_qOAmWxOLV_b027dc17", (String)"\u53ef\u5ef6\u671f\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((headVO.getDelayCount() >= 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__qIOAmWlTfUEU1_be835c81", (String)"\u53ef\u4ee5\u5ef6\u671f\u6b21\u6570\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1"));
            }
            if (EbiddingScopeEnum.PUBLIC.getValue().equals(ebiddingScope)) {
                Assert.notNull((Object)headVO.getApplyEndTime(), (String)I18nUtil.translate((String)"i18n_alert_RvOuWsRyRKIxOLV_e89e5a4d", (String)"\u516c\u5f00\u7ade\u4ef7\uff0c\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
                Date time = START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? headVO.getEchoEndTime() : headVO.getBeginTime();
                String message = START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? I18nUtil.translate((String)"i18n_alert_sRyRKIlTXUdByRKI_3a02a1dc", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u5e94\u6807\u622a\u6b62\u65f6\u95f4") : I18nUtil.translate((String)"i18n_alert_sRyRKIlTXUOuvKKI_1d1b5655", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4");
                Assert.isTrue((boolean)time.after(headVO.getApplyEndTime()), (String)message);
            }
        } else if (headVO.getPurchaseAutoQuote().equals(START_PRICE_FLAG) && EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay()) && (CollectionUtils.isEmpty(startPriceList = headVO.getPurchaseEbiddingItemList().stream().filter(e -> e.getStartPrice().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList())) || headVO.getPurchaseEbiddingItemList().size() != startPriceList.size())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__AAtudrfUW_6a4d7760", (String)"\u8d77\u62cd\u5355\u4ef7\u5e94\u8be5\u5927\u4e8e0"));
        }
        if (EbiddingMethodEnum.DUTCH.getValue().equals(headVO.getEbiddingMethod())) {
            Assert.notNull((Object)keepMinute, (String)I18nUtil.translate((String)"i18n_alert_uTKIWzsWKIxOLVW_78c93f21", (String)"\u6301\u7eed\u65f6\u95f4\uff08\u5206\u949f\uff09\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                Assert.notNull((Object)headVO.getIntervalMinute(), (String)I18nUtil.translate((String)"i18n_alert_ImKIxOLV_f1534aee", (String)"\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((headVO.getIntervalMinute().compareTo(BigDecimal.ONE) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_ImKIlTfUEUW_39975591", (String)"\u95f4\u9694\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1"));
            }
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) || EbiddingMethodEnum.DUTCH.getValue().equals(headVO.getEbiddingMethod())) {
            Assert.notNull((Object)keepMinute, (String)I18nUtil.translate((String)"i18n_alert_uTKIWzsWKIxOLVW_78c93f21", (String)"\u6301\u7eed\u65f6\u95f4\uff08\u5206\u949f\uff09\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((keepMinute.compareTo(BigDecimal.ONE) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_uTKIzslTfUEU1_c98a9b5d", (String)"\u6301\u7eed\u65f6\u95f4\uff08\u5206\u949f\uff09\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1"));
        }
        List<PurchaseEbiddingItem> itemList = headVO.getPurchaseEbiddingItemList();
        Assert.notEmpty(itemList, (String)I18nUtil.translate((String)"i18n_alert_cVHxOLV_c6f5290a", (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        for (PurchaseEbiddingItem item : itemList) {
            PurchaseEbiddingHeadServiceImpl.headToItem(headVO, item);
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay()) || EbiddingWayEnum.DISPOSABLE.getValue().equals(headVO.getEbiddingWay())) {
                if (START_PRICE_FLAG.equals(headVO.getSendTargetPrice())) {
                    Assert.notNull((Object)item.getTargetPrice(), (String)I18nUtil.translate((String)"i18n_alert_cVHIBuxOLV_c33b9114", (String)"\u884c\u4fe1\u606f\u76ee\u6807\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                if (START_PRICE_FLAG.equals(headVO.getSetStartPrice())) {
                    Assert.notNull((Object)item.getStartPrice(), (String)I18nUtil.translate((String)"i18n_alert_cVHAAuxOLV_f054add7", (String)"\u884c\u4fe1\u606f\u8d77\u62cd\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.isTrue((item.getStartPrice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__AAtudrfUW_6a4d7760", (String)"\u8d77\u62cd\u5355\u4ef7\u5e94\u8be5\u5927\u4e8e0"));
                }
                if (!START_PRICE_FLAG.equals(headVO.getSupplierTaxRate())) {
                    Assert.hasText((String)item.getTaxCode(), (String)I18nUtil.translate((String)"i18n_alert_cVHfoxOLV_76b200bd", (String)"\u884c\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.hasText((String)item.getTaxRate(), (String)I18nUtil.translate((String)"i18n_alert_cVHfIxOLV_379cc943", (String)"\u884c\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            }
            if (START_PRICE_FLAG.equals(headVO.getMustMaterialNumber())) {
                Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_cVHSLAoxOLV_f66aee85", (String)"\u884c\u4fe1\u606f\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (item.getDeliveryDate() != null) continue;
            item.setDeliveryDate(item.getRequireDate());
        }
        List needEchoList = headVO.getPurchaseAttachmentDemandList().stream().filter(demand -> START_PRICE_FLAG.equals(demand.getRequired())).filter(demand -> StageTypeEnum.RESPONSE.getValue().equals(demand.getStageType())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(needEchoList)) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getNeedEcho()), (String)I18nUtil.translate((String)"i18n_alert_WWWWWWBIlVWTPdBlTLK_1eae1d00", (String)"[${0}]\u9644\u4ef6\u5fc5\u4f20\uff0c\u9700\u8981\u5e94\u6807\u5fc5\u987b\u4e3a\u662f", (String[])new String[]{StageTypeEnum.RESPONSE.getDesc()}));
        }
        this.checkConfirm(headVO);
        List purchaseEbiddingConfirmList = headVO.getPurchaseEbiddingConfirmList().stream().filter(confirm -> START_PRICE_FLAG.equals(confirm.getMust())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(purchaseEbiddingConfirmList)) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getNeedEcho()), (String)I18nUtil.translate((String)"i18n_alert_WWWWWWjRLdlSWTPdBlTLK_74e3d92d", (String)"[${0}]\u6709\u786e\u8ba4\u9879\u5fc5\u586b\uff0c\u9700\u8981\u5e94\u6807\u5fc5\u987b\u4e3a\u662f", (String[])new String[]{StageTypeEnum.RESPONSE.getDesc()}));
        }
        headVO.setEbiddingStatus(START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? EbiddingStatusEnum.WAIT_REPLY.getValue() : EbiddingStatusEnum.WAIT_BIDDING.getValue());
        DateTime endTime = DateUtil.offsetSecond((Date)beginTime, (int)SysUtil.minuteToSecond((BigDecimal)keepMinute, (int)1));
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) || EbiddingMethodEnum.DUTCH.getValue().equals(headVO.getEbiddingMethod())) {
            headVO.setEndTime((Date)endTime);
        }
        headVO.setStartTime(beginTime);
        headVO.setCurrentRound(headVO.getCurrentRound() == null ? 1 : headVO.getCurrentRound());
        LoginUser user = SysUtil.getLoginUser();
        headVO.setPublishUser(user.getSubAccount() + "_" + user.getRealname());
        headVO.setPublishTime(new Date());
        headVO.setDeleted(CommonConstant.DEL_FLAG_0);
        if ((EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) || EbiddingMethodEnum.DUTCH.getValue().equals(headVO.getEbiddingMethod())) && !EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
            headVO.setIntervalMinute(BigDecimal.ZERO);
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) && headVO.getIntervalMinute() == null) {
            headVO.setIntervalMinute(BigDecimal.ZERO);
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) && EbiddingDelayRuleEnum.NOT_ALLOW_DELAY.getValue().equals(headVO.getDelayRule())) {
            headVO.setBeforeEndMinute(0);
            headVO.setDelayMinute(0);
            headVO.setDelayCount(0);
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) && EbiddingDelayRuleEnum.UNLIMITED_DELAY_COUNT.getValue().equals(headVO.getDelayRule())) {
            headVO.setDelayCount(0);
        }
        if (!EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            if (!EbiddingMethodEnum.DUTCH.getValue().equals(headVO.getEbiddingMethod())) {
                headVO.setKeepMinute(BigDecimal.ZERO);
                headVO.setIntervalMinute(BigDecimal.ZERO);
            }
            headVO.setDelayRule("");
            headVO.setBeforeEndMinute(0);
            headVO.setDelayMinute(0);
            headVO.setDelayCount(0);
        }
        if ("0".equals(headVO.getNeedEcho())) {
            headVO.setEchoEndTime(null);
        }
        if (EbiddingScopeEnum.INVITE.getValue().equals(headVO.getEbiddingScope())) {
            headVO.setApplyEndTime(null);
        }
    }

    private void checkConfirm(PurchaseEbiddingHeadVO headVO) {
        List<PurchaseEbiddingConfirmVO> confirmList = headVO.getPurchaseEbiddingConfirmList();
        if (CollectionUtils.isEmpty(confirmList)) {
            return;
        }
        AtomicInteger i = new AtomicInteger(1);
        confirmList.forEach(e -> {
            if (!"2".equals(e.getWriteType())) {
                Assert.isTrue((!CollectionUtils.isEmpty(e.getConfirmItemList()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__n[0]cURidBjSM_9579f2", (String)"\u786e\u8ba4\u9879\uff0c\u7b2c[${0}]\u884c\u9884\u5236\u9009\u9879\u6ca1\u6709\u586b\u5199", (String[])new String[]{i.toString()}));
            }
            i.getAndIncrement();
        });
    }

    private static void headToItem(PurchaseEbiddingHead head, PurchaseEbiddingItem item) {
        List<String> checkWayList = Arrays.asList(EbiddingWayEnum.PACKAGE.getValue(), EbiddingWayEnum.BATCH.getValue());
        if (checkWayList.contains(head.getEbiddingWay())) {
            item.setTaxRate(StrUtil.isBlank((CharSequence)head.getTaxRate()) ? item.getTaxRate() : head.getTaxRate());
            item.setTaxCode(StrUtil.isBlank((CharSequence)head.getTaxCode()) ? item.getTaxCode() : head.getTaxCode());
            item.setCurrency(StrUtil.isBlank((CharSequence)head.getCurrency()) ? item.getCurrency() : head.getCurrency());
        } else {
            item.setTaxRate(StrUtil.isBlank((CharSequence)item.getTaxRate()) ? head.getTaxRate() : item.getTaxRate());
            item.setTaxCode(StrUtil.isBlank((CharSequence)item.getTaxCode()) ? head.getTaxCode() : item.getTaxCode());
            item.setCurrency(StrUtil.isBlank((CharSequence)item.getCurrency()) ? head.getCurrency() : item.getCurrency());
        }
        item.setEffectiveDate(item.getEffectiveDate() == null ? head.getEffectiveDate() : item.getEffectiveDate());
        item.setExpiryDate(item.getExpiryDate() == null ? head.getExpiryDate() : item.getExpiryDate());
        item.setAuditStatus(head.getResultAuditStatus());
        item.setEffectiveDate(head.getEffectiveDate());
        item.setExpiryDate(head.getExpiryDate());
    }

    private boolean publishAudit(PurchaseEbiddingHeadVO headVO) {
        if (START_PRICE_FLAG.equals(headVO.getPublishAudit()) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(headVO.getAuditStatus())) {
            List<PurchaseEbiddingItem> itemList = headVO.getPurchaseEbiddingItemList();
            List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
            List<PurchaseAttachmentDemandDTO> demandList = headVO.getPurchaseAttachmentDemandList();
            List<PurchaseEbiddingConfirmVO> confirmList = headVO.getPurchaseEbiddingConfirmList();
            if (StrUtil.isBlank((CharSequence)headVO.getId())) {
                this.saveMain(headVO, itemList, supplierList, demandList, confirmList, new ArrayList<PurchaseAttachmentDTO>());
            } else {
                this.updateMain(headVO, itemList, supplierList, demandList, confirmList, headVO.getPurchaseAttachmentList());
            }
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(headVO.getId());
            dto.setBusinessType("publishEbidding");
            String name = StringUtils.isNotBlank((CharSequence)headVO.getProjectName()) ? headVO.getProjectName() : "";
            dto.setAuditSubject("\u7ade\u4ef7\u53d1\u5e03\u524d\u5ba1\u6279\uff0c\u5355\u53f7\uff1a" + headVO.getEbiddingNumber() + " " + name);
            dto.setParams(JSONObject.toJSONString((Object)((Object)headVO)));
            this.inquiryInvokeWorkFlowRpcService.submit(dto);
            return true;
        }
        return false;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseEbiddingHeadVO headVO) {
        this.checkEnquirySameMaterial(headVO.getPurchaseEbiddingItemList());
        this.checkMaterialNumber(headVO.getPurchaseEbiddingItemList());
        this.checkAndSetParam(headVO);
        if (this.publishAudit(headVO)) {
            return;
        }
        PurchaseEbiddingHead head = new PurchaseEbiddingHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        if (StrUtil.isBlank((CharSequence)head.getId())) {
            ((PurchaseEbiddingHeadMapper)this.baseMapper).insert((Object)head);
        } else {
            int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)head);
            this.updatePurchaseEbiddingHead(head);
            Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            this.deleteSubTable(head.getId());
        }
        headVO.setId(head.getId());
        if (EbiddingStartWayEnum.AUTO.getValue().equals(head.getStartWay())) {
            EbiddingJobUtil.createStartJob(head, head.getBeginTime());
        }
        this.insertInitTable(head.getId(), headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingConfirmList());
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        this.handleEnquirySupplierList(head, supplierList);
        if (CollectionUtil.isNotEmpty(supplierList)) {
            this.publishEbidding(head, headVO.getPurchaseEbiddingItemList(), supplierList, headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        } else {
            this.insertData(head, headVO.getPurchaseEbiddingItemList(), supplierList, headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        }
        this.goBackDemand(headVO.getPurchaseEbiddingItemList(), PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
        if (EbiddingScopeEnum.PUBLIC.getValue().equals(headVO.getEbiddingScope())) {
            String publicScope = head.getPublicScope() == null ? "" : head.getPublicScope();
            switch (SrmPublicScopeEnum.toType(publicScope)) {
                case ALL: {
                    this.publishToB2BService.publishToB2B(head, headVO.getPurchaseEbiddingItemList());
                }
                case SRM: {
                    this.publicEbiddingService.publishNotice(head);
                }
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void newRoundPublish(PurchaseEbiddingHeadVO headVO) {
        this.checkAndSetParam(headVO);
        if (this.publishAudit(headVO)) {
            return;
        }
        PurchaseEbiddingHead head = new PurchaseEbiddingHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        if (StrUtil.isBlank((CharSequence)head.getId())) {
            ((PurchaseEbiddingHeadMapper)this.baseMapper).insert((Object)head);
        } else {
            int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)head);
            this.updatePurchaseEbiddingHead(head);
            Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            this.deleteSubTable(head.getId());
        }
        headVO.setId(head.getId());
        this.saveNewPurchaseAttachmentList(headVO);
        if (EbiddingStartWayEnum.AUTO.getValue().equals(head.getStartWay())) {
            EbiddingJobUtil.createStartJob(head, head.getBeginTime());
        }
        this.insertInitTable(head.getId(), headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingConfirmList());
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        this.handleEnquirySupplierList(head, supplierList);
        if (CollectionUtil.isNotEmpty(supplierList)) {
            this.publishEbidding(head, headVO.getPurchaseEbiddingItemList(), supplierList, headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        } else {
            this.insertData(head, headVO.getPurchaseEbiddingItemList(), supplierList, headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        }
        if (EbiddingScopeEnum.PUBLIC.getValue().equals(headVO.getEbiddingScope())) {
            String publicScope;
            String string = publicScope = head.getPublicScope() == null ? "" : head.getPublicScope();
            if (publicScope.equals(SrmPublicScopeEnum.SRM.getValue()) || publicScope.equals(SrmPublicScopeEnum.ALL.getValue())) {
                this.publicEbiddingService.publishNotice(head);
                if (publicScope.equals(SrmPublicScopeEnum.ALL.getValue())) {
                    this.publishToB2BService.publishToB2B(head, headVO.getPurchaseEbiddingItemList());
                }
            }
        }
    }

    @Override
    public List<PurchaseContractHeadDTO> generateContract(PurchaseEbiddingHeadVO headVO) {
        String templateNumber = headVO.getTemplateNumber();
        String templateName = headVO.getTemplateName();
        String templateAccount = headVO.getTemplateAccount();
        Integer templateVersion = headVO.getTemplateVersion();
        String id = headVO.getId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
        Map<String, List<PurchaseEbiddingItem>> accountMap = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.groupingBy(PurchaseEbiddingItem::getToElsAccount));
        if (CollectionUtil.isNotEmpty(accountMap)) {
            ArrayList<PurchaseContractHeadDTO> headDTOS = new ArrayList<PurchaseContractHeadDTO>();
            ArrayList<PurchaseContractItemDTO> itemDTOList = new ArrayList<PurchaseContractItemDTO>();
            accountMap.forEach((key, value) -> {
                PurchaseContractHeadDTO contractHead = this.generateContractHeadDTO(dbHead, (List<PurchaseEbiddingItem>)value);
                contractHead.setTemplateName(templateName);
                contractHead.setTemplateAccount(templateAccount);
                contractHead.setTemplateNumber(templateNumber);
                contractHead.setTemplateVersion(templateVersion + "");
                List<PurchaseContractItemDTO> itemDTOList1 = this.generateContractItemDTO(dbHead, (List<PurchaseEbiddingItem>)value, contractHead.getId());
                headDTOS.add(contractHead);
                itemDTOList.addAll(itemDTOList1);
            });
            List<PurchaseContractHeadDTO> strings = this.inquiryInvokeContractService.generateContract(headDTOS, itemDTOList, null);
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseEbiddingHead::getGenerateContract, (Object)START_PRICE_FLAG)).eq(BaseEntity::getId, (Object)id)).update((Object)new PurchaseEbiddingHead());
            List<PurchaseEbiddingItem> collect1 = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            this.goBackDemandUseForDel(collect1, PurchaseRequestStatusItemEnum.CONTRACT_BUILT.getValue());
            return strings;
        }
        return null;
    }

    @Override
    public List<PurchaseContractHeadDTO> generateContractByHis(PurchaseEbiddingHeadVO headVO) {
        String templateNumber = headVO.getTemplateNumber();
        String templateName = headVO.getTemplateName();
        String templateAccount = headVO.getTemplateAccount();
        Integer templateVersion = headVO.getTemplateVersion();
        String id = headVO.getId();
        PurchaseEbiddingHead purchaseEbiddingHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEbiddingItemHis> purchaseEbiddingItems = this.purchaseEbiddingItemHisService.selectByMainId(id);
        Map<String, List> collect = purchaseEbiddingItems.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toMap(PurchaseEbiddingItemHis::getToElsAccount, p -> {
            ArrayList<PurchaseEbiddingItemHis> getNameList = new ArrayList<PurchaseEbiddingItemHis>();
            getNameList.add((PurchaseEbiddingItemHis)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        if (!CollectionUtils.isEmpty(collect)) {
            Iterator iterator = collect.keySet().stream().iterator();
            ArrayList<PurchaseContractHeadDTO> headDTOS = new ArrayList<PurchaseContractHeadDTO>();
            ArrayList<PurchaseContractItemDTO> itemDTOList = new ArrayList<PurchaseContractItemDTO>();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                List purchaseEbiddingItems1 = collect.get(next);
                PurchaseContractHeadDTO purchaseContractHeadDTO = this.generateContractHeadDTOByHis(purchaseEbiddingHead, (PurchaseEbiddingItemHis)((Object)purchaseEbiddingItems1.get(0)));
                purchaseContractHeadDTO.setTemplateName(templateName);
                purchaseContractHeadDTO.setTemplateAccount(templateAccount);
                purchaseContractHeadDTO.setTemplateNumber(templateNumber);
                purchaseContractHeadDTO.setTemplateVersion(templateVersion + "");
                List<PurchaseContractItemDTO> itemDTOList1 = this.generateContractItemDTOByHis(purchaseEbiddingHead, purchaseEbiddingItems1, purchaseContractHeadDTO.getId());
                headDTOS.add(purchaseContractHeadDTO);
                itemDTOList.addAll(itemDTOList1);
            }
            List<PurchaseContractHeadDTO> strings = this.inquiryInvokeContractService.generateContract(headDTOS, itemDTOList, null);
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseEbiddingHead::getGenerateContract, (Object)START_PRICE_FLAG)).eq(BaseEntity::getId, (Object)id)).update((Object)new PurchaseEbiddingHead());
            return strings;
        }
        return null;
    }

    private PurchaseContractHeadDTO generateContractHeadDTO(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList) {
        PurchaseContractHeadDTO purchaseContractHeadDTO = new PurchaseContractHeadDTO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)purchaseContractHeadDTO);
        PurchaseEbiddingItem item = itemList.get(0);
        purchaseContractHeadDTO.setId(IdWorker.getIdStr());
        purchaseContractHeadDTO.setToElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setSupplierName(item.getSupplierName());
        purchaseContractHeadDTO.setSupplierCode(item.getSupplierCode());
        purchaseContractHeadDTO.setInvoicedElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setInvoicedErpCode(item.getSupplierCode());
        purchaseContractHeadDTO.setInvoicedName(item.getSupplierName());
        purchaseContractHeadDTO.setPerformingPartyElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setPerformingPartyName(item.getSupplierName());
        purchaseContractHeadDTO.setPerformingPartyCode(item.getSupplierCode());
        purchaseContractHeadDTO.setPayeeElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setPayeeName(item.getSupplierName());
        purchaseContractHeadDTO.setPayeeErpCode(item.getSupplierCode());
        purchaseContractHeadDTO.setDocumentId(head.getDocumentId());
        purchaseContractHeadDTO.setDocumentParentId(head.getId());
        purchaseContractHeadDTO.setContractDesc(head.getEbiddingDesc());
        purchaseContractHeadDTO.setContractName(head.getProjectName());
        purchaseContractHeadDTO.setContractName(head.getProjectName());
        purchaseContractHeadDTO.setAuditStatus(null);
        purchaseContractHeadDTO.setFlowId(null);
        purchaseContractHeadDTO.setCreateBy(null);
        purchaseContractHeadDTO.setCreateTime(null);
        purchaseContractHeadDTO.setCreateById(null);
        purchaseContractHeadDTO.setUpdateBy(null);
        purchaseContractHeadDTO.setUpdateTime(null);
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal netTotalAmount = BigDecimal.ZERO;
        if (EbiddingWayEnum.PACKAGE.getValue().equals(head.getEbiddingWay())) {
            totalAmount = item.getTotalAmount();
            netTotalAmount = item.getNetTotalAmount();
        } else {
            for (PurchaseEbiddingItem item1 : itemList) {
                totalAmount = totalAmount.add(item1.getTaxAmount() == null ? BigDecimal.ZERO : item1.getTaxAmount());
                netTotalAmount = netTotalAmount.add(item1.getNetAmount() == null ? BigDecimal.ZERO : item1.getNetAmount());
            }
        }
        purchaseContractHeadDTO.setTotalTaxAmount(totalAmount);
        purchaseContractHeadDTO.setTotalNetAmount(netTotalAmount);
        return purchaseContractHeadDTO;
    }

    private PurchaseContractHeadDTO generateContractHeadDTOByHis(PurchaseEbiddingHead head, PurchaseEbiddingItemHis item) {
        PurchaseContractHeadDTO purchaseContractHeadDTO = new PurchaseContractHeadDTO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)purchaseContractHeadDTO);
        purchaseContractHeadDTO.setId(IdWorker.getIdStr());
        purchaseContractHeadDTO.setToElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setSupplierName(item.getSupplierName());
        purchaseContractHeadDTO.setSupplierCode(item.getSupplierCode());
        purchaseContractHeadDTO.setInvoicedElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setInvoicedErpCode(item.getSupplierCode());
        purchaseContractHeadDTO.setInvoicedName(item.getSupplierName());
        purchaseContractHeadDTO.setPerformingPartyElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setPerformingPartyName(item.getSupplierName());
        purchaseContractHeadDTO.setPerformingPartyCode(item.getSupplierCode());
        purchaseContractHeadDTO.setPayeeElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setPayeeName(item.getSupplierName());
        purchaseContractHeadDTO.setPayeeErpCode(item.getSupplierCode());
        purchaseContractHeadDTO.setDocumentId(head.getDocumentId());
        purchaseContractHeadDTO.setDocumentParentId(head.getId());
        purchaseContractHeadDTO.setContractDesc(head.getEbiddingDesc());
        purchaseContractHeadDTO.setContractName(head.getProjectName());
        purchaseContractHeadDTO.setContractName(head.getProjectName());
        purchaseContractHeadDTO.setAuditStatus(null);
        purchaseContractHeadDTO.setFlowId(null);
        purchaseContractHeadDTO.setCreateBy(null);
        purchaseContractHeadDTO.setCreateTime(null);
        purchaseContractHeadDTO.setCreateById(null);
        purchaseContractHeadDTO.setUpdateBy(null);
        purchaseContractHeadDTO.setUpdateTime(null);
        if (EbiddingWayEnum.PACKAGE.getValue().equals(head.getEbiddingWay())) {
            purchaseContractHeadDTO.setTotalTaxAmount(item.getTotalAmount());
            purchaseContractHeadDTO.setTotalNetAmount(item.getNetTotalAmount());
        }
        return purchaseContractHeadDTO;
    }

    private List<PurchaseContractItemDTO> generateContractItemDTO(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, String id) {
        ArrayList<PurchaseContractItemDTO> itemDTOList = new ArrayList<PurchaseContractItemDTO>();
        for (PurchaseEbiddingItem purchaseEbiddingItem : itemList) {
            PurchaseContractItemDTO purchaseContractItemDTO = new PurchaseContractItemDTO();
            BeanUtils.copyProperties((Object)((Object)purchaseEbiddingItem), (Object)purchaseContractItemDTO);
            purchaseContractItemDTO.setHeadId(id);
            purchaseContractItemDTO.setDocumentParentId(purchaseEbiddingItem.getId());
            if (EbiddingWayEnum.SINGLE.getValue().equals(head.getEbiddingWay()) || EbiddingWayEnum.DISPOSABLE.getValue().equals(head.getEbiddingWay())) {
                purchaseContractItemDTO.setQuantity(purchaseEbiddingItem.getQuotaQuantity());
                purchaseContractItemDTO.setTaxAmount(purchaseEbiddingItem.getQuotaTaxAmount());
                purchaseContractItemDTO.setNetAmount(purchaseEbiddingItem.getQuotaNetAmount());
            } else if (EbiddingWayEnum.BATCH.getValue().equals(head.getEbiddingWay())) {
                purchaseContractItemDTO.setQuantity(purchaseEbiddingItem.getRequireQuantity());
                purchaseContractItemDTO.setTaxAmount(purchaseEbiddingItem.getPrice());
                purchaseContractItemDTO.setNetAmount(purchaseEbiddingItem.getNetPrice());
            }
            purchaseContractItemDTO.setId(null);
            purchaseContractItemDTO.setCreateBy(null);
            purchaseContractItemDTO.setCreateTime(null);
            purchaseContractItemDTO.setCreateById(null);
            purchaseContractItemDTO.setUpdateBy(null);
            purchaseContractItemDTO.setUpdateTime(null);
            purchaseContractItemDTO.setSourceItemId(purchaseEbiddingItem.getId());
            purchaseContractItemDTO.setSourceType("ebidding");
            purchaseContractItemDTO.setSourceId(purchaseEbiddingItem.getHeadId());
            purchaseContractItemDTO.setSourceItemNumber(purchaseEbiddingItem.getItemNumber());
            purchaseContractItemDTO.setSourceNumber(purchaseEbiddingItem.getEbiddingNumber());
            itemDTOList.add(purchaseContractItemDTO);
        }
        return itemDTOList;
    }

    private List<PurchaseContractItemDTO> generateContractItemDTOByHis(PurchaseEbiddingHead head, List<PurchaseEbiddingItemHis> itemList, String id) {
        ArrayList<PurchaseContractItemDTO> itemDTOList = new ArrayList<PurchaseContractItemDTO>();
        for (PurchaseEbiddingItemHis purchaseEbiddingItem : itemList) {
            PurchaseContractItemDTO purchaseContractItemDTO = new PurchaseContractItemDTO();
            BeanUtils.copyProperties((Object)((Object)purchaseEbiddingItem), (Object)purchaseContractItemDTO);
            purchaseContractItemDTO.setHeadId(id);
            purchaseContractItemDTO.setDocumentParentId(purchaseEbiddingItem.getId());
            purchaseContractItemDTO.setQuantity(purchaseEbiddingItem.getQuotaQuantity());
            purchaseContractItemDTO.setTaxAmount(purchaseEbiddingItem.getQuotaTaxAmount());
            purchaseContractItemDTO.setNetAmount(purchaseEbiddingItem.getQuotaNetAmount());
            purchaseContractItemDTO.setId(null);
            purchaseContractItemDTO.setCreateBy(null);
            purchaseContractItemDTO.setCreateTime(null);
            purchaseContractItemDTO.setCreateById(null);
            purchaseContractItemDTO.setUpdateBy(null);
            purchaseContractItemDTO.setUpdateTime(null);
            purchaseContractItemDTO.setSourceItemId(purchaseEbiddingItem.getId());
            purchaseContractItemDTO.setSourceType("ebidding");
            purchaseContractItemDTO.setSourceId(purchaseEbiddingItem.getHeadId());
            purchaseContractItemDTO.setSourceItemNumber(purchaseEbiddingItem.getItemNumber());
            purchaseContractItemDTO.setSourceNumber(purchaseEbiddingItem.getEbiddingNumber());
            itemDTOList.add(purchaseContractItemDTO);
        }
        return itemDTOList;
    }

    private void handleEnquirySupplierList(PurchaseEbiddingHead head, List<PurchaseEbiddingSupplier> supplierList) {
        if (CollectionUtils.isEmpty(supplierList)) {
            return;
        }
        List<String> toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
        List<SupplierMasterDataDTO> supplierMasterDataList = this.inquiryInvokeSupplierRpcService.selectSupplerList(head.getElsAccount(), toElsAccountList);
        Map supplierMasterDataMap = supplierMasterDataList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (newVal, oldVal) -> oldVal));
        supplierList.forEach(supplier -> supplier.setNeedCoordination(((SupplierMasterDataDTO)supplierMasterDataMap.get(supplier.getToElsAccount())).getNeedCoordination()));
    }

    private void updatePurchaseEbiddingHead(PurchaseEbiddingHead head) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)head.getId());
        updateWrapper.set(PurchaseEbiddingHead::getIntervalMinute, (Object)head.getIntervalMinute());
        updateWrapper.set(PurchaseEbiddingHead::getBeforeEndMinute, (Object)head.getBeforeEndMinute());
        updateWrapper.set(PurchaseEbiddingHead::getDelayCount, (Object)head.getDelayCount());
        updateWrapper.set(PurchaseEbiddingHead::getDelayMinute, (Object)head.getDelayMinute());
        updateWrapper.set(PurchaseEbiddingHead::getKeepMinute, (Object)head.getKeepMinute());
        updateWrapper.set(PurchaseEbiddingHead::getDelayRule, (Object)head.getDelayRule());
        updateWrapper.set(PurchaseEbiddingHead::getEchoEndTime, (Object)head.getEchoEndTime());
        updateWrapper.set(PurchaseEbiddingHead::getApplyEndTime, (Object)head.getApplyEndTime());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    @Override
    public void insertInitTable(String headId, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingConfirmVO> confirmList) {
        JSONObject itemObject = new JSONObject();
        itemObject.put("relationId", (Object)headId);
        itemObject.put("businessType", (Object)"item");
        itemObject.put("businessInfoJson", (Object)JSON.toJSONString(itemList));
        InitTableMqUtil.sendInitMsg(itemObject.toJSONString());
        JSONObject confirmObject = new JSONObject();
        confirmObject.put("relationId", (Object)headId);
        confirmObject.put("businessType", (Object)"confirm");
        confirmObject.put("businessInfoJson", (Object)JSON.toJSONString(confirmList));
        InitTableMqUtil.sendInitMsg(confirmObject.toJSONString());
    }

    private AttachmentSendDTO publishEbidding(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> demandList, List<PurchaseEbiddingConfirmVO> confirmList) {
        List<String> toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
        List<String> materialNumberList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).map(PurchaseEbiddingItem::getMaterialNumber).distinct().collect(Collectors.toList());
        Map<String, PurchaseMaterialRelationDTO> relationMap = this.inquiryInvokeMainDataRpcService.findByMaterialAndAccount(materialNumberList, toElsAccountList);
        this.purchaseEbiddingSupplierService.publish(head, supplierList);
        List<PurchaseEbiddingItem> insertItemList = this.purchaseEbiddingItemService.publish(head, itemList, supplierList, relationMap);
        List<PurchaseEbiddingConfirm> insertConfirmList = this.purchaseEbiddingConfirmService.publish(head, confirmList, supplierList);
        Map<String, String> idMap = this.saleEbiddingHeadService.publish(head, insertItemList, supplierList, insertConfirmList);
        AttachmentSendDTO sendDTO = this.sendAttachment(head, idMap, demandList);
        Map<String, String> supplierMap = supplierList.stream().collect(Collectors.toMap(PurchaseEbiddingSupplier::getToElsAccount, PurchaseEbiddingSupplier::getSupplierName, (newVal, oldVal) -> oldVal));
        for (String toElsAccount : toElsAccountList) {
            PurchaseEbiddingMessageVO messageVO = new PurchaseEbiddingMessageVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)messageVO));
            messageVO.setToElsAccount(toElsAccount);
            messageVO.setPurchaseCompanyName(SysUtil.getLoginUser().getEnterpriseName());
            messageVO.setSupplierName(supplierMap.get(toElsAccount));
            if (START_PRICE_FLAG.equals(head.getNeedEcho())) {
                super.sendMessage(TenantContext.getTenant(), "ebidding", "biddingReply_publish", head.getId(), "ebiddingBusDataServiceImpl", Collections.singletonList(toElsAccount));
                continue;
            }
            super.sendMessage(TenantContext.getTenant(), "ebidding", "biddingReply_publish", head.getId(), "ebiddingBusDataServiceImpl", Collections.singletonList(toElsAccount));
        }
        return sendDTO;
    }

    private AttachmentSendDTO sendAttachment(PurchaseEbiddingHead purchaseHead, Map<String, String> idMap, List<PurchaseAttachmentDemandDTO> demandList) {
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setHeadId(purchaseHead.getId());
        sendVO.setElsAccount(purchaseHead.getElsAccount());
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>();
        for (String elsAccount : idMap.keySet()) {
            toSend.put(idMap.get(elsAccount), elsAccount);
        }
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendPurchaseFile(sendVO, true);
        this.invokeBaseRpcService.sendPurchaseAttachmentDemandDemand(demandList, purchaseHead.getId(), "ebidding", idMap);
        return sendVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishNewSupplier(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingSupplier> webSupplierList) {
        String headId = dbHead.getId();
        List hadList = this.purchaseEbiddingSupplierService.selectByMainId(headId).stream().map(PurchaseEbiddingSupplier::getToElsAccount).collect(Collectors.toList());
        List<PurchaseEbiddingSupplier> supplierList = webSupplierList.stream().filter(supplier -> !hadList.contains(supplier.getToElsAccount())).collect(Collectors.toList());
        Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_APiFjRdOIOhxRrWSTKmhx_fda6d18a", (String)"\u5f53\u524d\u9009\u62e9\u7684\u4f9b\u5e94\u90fd\u5df2\u7ecf\u53d1\u5e03\u8fc7\u4e86\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u5e03"));
        ElsInitialTableDTO itemInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId, "item");
        List itemList = JSON.parseArray((String)itemInitInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId);
        ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId, "confirm");
        List confirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmVO.class);
        dbHead.setEbiddingStatus(START_PRICE_FLAG.equals(dbHead.getNeedEcho()) ? EbiddingStatusEnum.WAIT_REPLY.getValue() : EbiddingStatusEnum.WAIT_BIDDING.getValue());
        this.updateById((Object)dbHead);
        this.publishEbidding(dbHead, itemList, supplierList, demandList, confirmList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        for (PurchaseEbiddingSupplier supplier2 : supplierList) {
            purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.EBIDDING.getValue(), dbHead.getEbiddingNumber(), supplier2.getToElsAccount(), supplier2.getSupplierName());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void startBidding(String id) {
        List<PurchaseEbiddingItem> quoteList;
        List<String> itemIdList;
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING.getValue());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod()) && START_PRICE_FLAG.equals(dbHead.getRespectiveQuotations())) {
                dbItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING.getValue()));
                itemIdList = dbItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                this.purchaseEbiddingItemService.updateBatchById(dbItemList);
                quoteList = dbItemList;
            } else {
                String itemNumber = StrUtil.isNotBlank((CharSequence)dbHead.getCurrentItemNumber()) ? dbHead.getCurrentItemNumber() : START_PRICE_FLAG;
                List<PurchaseEbiddingItem> updateList = dbItemList.stream().filter(item -> itemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                dbHead.setCurrentItemNumber(itemNumber);
                dbHead.setCurrentMaterialDesc(((PurchaseEbiddingItem)((Object)updateList.get(0))).getMaterialDesc());
                dbHead.setCurrentDelayCount(0);
                updateList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING.getValue()));
                itemIdList = updateList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                PurchaseEbiddingHeadServiceImpl.processRemainingQuantity(dbHead, updateList);
                this.purchaseEbiddingItemService.updateBatchById(updateList);
                quoteList = updateList;
                this.saleEbiddingHeadService.processRemainingQuantity(dbHead, updateList);
            }
        } else {
            dbHead.setCurrentMaterialDesc(EbiddingWayEnum.getDesc(dbHead.getEbiddingWay()));
            dbItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING.getValue()));
            itemIdList = dbItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            PurchaseEbiddingHeadServiceImpl.processRemainingQuantity(dbHead, dbItemList);
            this.purchaseEbiddingItemService.updateBatchById(dbItemList);
            quoteList = dbItemList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEbiddingItem>(Comparator.comparing(PurchaseEbiddingItem::getToElsAccount))), ArrayList::new));
            this.saleEbiddingHeadService.processRemainingQuantity(dbHead, dbItemList);
        }
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEbiddingHeadService.startEbidding(dbHead, itemIdList);
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            EbiddingJobUtil.deleteDutchQuoteJob(dbHead);
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
            EbiddingJobUtil.createEndJob(dbHead, dbHead.getEndTime());
        } else if (START_PRICE_FLAG.equals(dbHead.getPurchaseAutoQuote())) {
            this.autoQuotePrice(dbHead, quoteList);
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
                dbHead.setBeginTime(new Date());
                dbHead.setEndTime((Date)DateUtil.offsetSecond((Date)dbHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1)));
                dbHead.setQuoteFlag(START_PRICE_FLAG);
                ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
                SaleEbiddingHead saleHead2 = new SaleEbiddingHead();
                saleHead2.setQuoteFlag(START_PRICE_FLAG);
                saleHead2.setBeginTime(dbHead.getBeginTime());
                saleHead2.setStartTime(dbHead.getStartTime());
                saleHead2.setEndTime(dbHead.getEndTime());
                saleHead2.setCurrentDelayCount(dbHead.getCurrentDelayCount());
                SaleEbiddingHeadService saleEbiddingHeadService = (SaleEbiddingHeadService)SpringContextUtils.getBean(SaleEbiddingHeadServiceImpl.class);
                saleEbiddingHeadService.update((Object)saleHead2, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue()));
                this.autoSetBindnumber(dbHead, dbItemList, quoteList);
                EbiddingJobUtil.createDutchQuoteJob(dbHead, dbHead.getEndTime());
            }
        }
        this.redis.publish("quote-price-topic", (Object)dbHead.getId());
        List<SaleEbiddingHead> saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
        List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            SaleEbiddingHead sale = saleHeadList.stream().filter(saleHead -> saleHead.getElsAccount().equals(supplier.getToElsAccount())).findFirst().orElse(new SaleEbiddingHead());
            supplier.setKeyWord(sale.getPurchaseName());
            super.sendMessage(TenantContext.getTenant(), "ebidding", "start", id, "ebiddingBusDataServiceImpl", Arrays.asList(supplier.getToElsAccount()));
        }
    }

    @Override
    public void autoSetBindnumber(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> dbItemList, List<PurchaseEbiddingItem> quoteList) {
        List<PurchaseEbiddingItem> updateList = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? quoteList : dbItemList;
        for (PurchaseEbiddingItem item : updateList) {
            BigDecimal bidNumber = quoteList.get(0).getBidNumber();
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BaseEntity::getId, (Object)item.getId())).set(PurchaseEbiddingItem::getBidNumber, (Object)bidNumber));
            SaleEbiddingItemService saleEbiddingItemService = (SaleEbiddingItemService)SpringContextUtils.getBean(SaleEbiddingItemServiceImpl.class);
            saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingItem::getRelationId, (Object)item.getId())).set(SaleEbiddingItem::getBidNumber, (Object)bidNumber));
        }
    }

    private static void processRemainingQuantity(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> updateList) {
        block4: {
            if (!EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) break block4;
            if (!EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
                for (PurchaseEbiddingItem item : updateList) {
                    item.setRemainingQuantity(item.getRequireQuantity());
                }
            } else {
                for (PurchaseEbiddingItem item : updateList) {
                    item.setRemainingQuantity(BigDecimal.ONE);
                }
            }
        }
    }

    private Map<String, JSONObject> getReceiveParamMap(String headId) {
        List<SaleEbiddingHead> dbSaleHeadList = this.saleEbiddingHeadService.getByRelationId(headId);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        for (SaleEbiddingHead saleHead : dbSaleHeadList) {
            JSONObject urlParam = new JSONObject();
            urlParam.put("id", (Object)saleHead.getId());
            urlParam.put("templateNumber", (Object)saleHead.getTemplateNumber());
            urlParam.put("templateVersion", (Object)saleHead.getTemplateVersion());
            urlParam.put("templateAccount", (Object)saleHead.getTemplateAccount());
            urlParam.put("busAccount", (Object)saleHead.getBusAccount());
            receiveParamMap.put(saleHead.getElsAccount(), urlParam);
        }
        return receiveParamMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void endBidding(String id, List<String> itemNumberList) {
        ArrayList<String> itemIdList = new ArrayList<String>();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod()) && START_PRICE_FLAG.equals(dbHead.getRespectiveQuotations())) {
                List<PurchaseEbiddingItem> currentItemList = dbItemList.stream().filter(item -> itemNumberList.contains(item.getItemNumber())).collect(Collectors.toList());
                currentItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue()));
                List idList = currentItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                itemIdList.addAll(idList);
                this.purchaseEbiddingItemService.updateBatchById(currentItemList);
                List biddingEndList = dbItemList.stream().filter(item -> EbiddingItemStatusEnum.BIDDING_END.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                dbHead.setEbiddingStatus(dbItemList.size() == biddingEndList.size() ? EbiddingStatusEnum.BIDDING_END.getValue() : EbiddingStatusEnum.BIDDING.getValue());
            } else {
                List<PurchaseEbiddingItem> currentItemList;
                String currentItemNumber = dbHead.getCurrentItemNumber();
                String nextItemNumber = String.valueOf(Integer.parseInt(currentItemNumber) + 1);
                PurchaseEbiddingItem nextItem = this.purchaseEbiddingItemService.selectOneByMainIdAndItemNumber(id, nextItemNumber);
                if (nextItem != null) {
                    dbHead.setCurrentItemNumber(nextItemNumber);
                    dbHead.setCurrentMaterialDesc(nextItem.getMaterialDesc());
                    dbHead.setCurrentDelayCount(0);
                    if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
                        dbHead.setEbiddingStatus(EbiddingStatusEnum.WAIT_BIDDING.getValue());
                        dbHead.setBeginTime((Date)DateUtil.offsetSecond((Date)dbHead.getEndTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getIntervalMinute(), (int)1)));
                        dbHead.setEndTime((Date)DateUtil.offsetSecond((Date)dbHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1)));
                        EbiddingJobUtil.createStartJob(dbHead, dbHead.getBeginTime());
                    }
                    if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
                        dbHead.setQuoteFlag("0");
                        dbHead.setEbiddingStatus(EbiddingStatusEnum.WAIT_BIDDING.getValue());
                        dbHead.setBeginTime(new Date());
                        dbHead.setEndTime((Date)DateUtil.offsetSecond((Date)dbHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getIntervalMinute(), (int)1)));
                        EbiddingJobUtil.createStartJob(dbHead, dbHead.getEndTime());
                        EbiddingJobUtil.deleteDutchQuoteJob(dbHead);
                        SaleEbiddingItemHisService saleEbiddingItemHisService = (SaleEbiddingItemHisService)SpringContextUtils.getBean(SaleEbiddingItemHisServiceImpl.class);
                        List<SaleEbiddingHead> saleEbiddingHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
                        List<String> saleHeadIdList = saleEbiddingHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                        List<SaleEbiddingItemHis> saleEbiddingItemHisList = saleEbiddingItemHisService.selectWithoutElsAccountByHeadIdNotAccept(saleHeadIdList);
                        saleEbiddingItemHisList = saleEbiddingItemHisList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getAccept())).collect(Collectors.toList());
                        for (SaleEbiddingItemHis itemHis : saleEbiddingItemHisList) {
                            itemHis.setAccept("3");
                            saleEbiddingItemHisService.updateById((Object)itemHis);
                            PurchaseEbiddingItemHis purchaseHis = new PurchaseEbiddingItemHis();
                            purchaseHis.setId(itemHis.getRelationId());
                            purchaseHis.setAccept("3");
                            this.purchaseEbiddingItemHisMapper.updateById((Object)purchaseHis);
                        }
                    }
                    if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod())) {
                        dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING.getValue());
                        dbHead.setEndTime(new Date());
                        List<PurchaseEbiddingItem> nextItemList = dbItemList.stream().filter(item -> nextItemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                        nextItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING.getValue()));
                        this.purchaseEbiddingItemService.updateBatchById(nextItemList);
                        SaleEbiddingItemService saleEbiddingItemService = (SaleEbiddingItemService)SpringContextUtils.getBean(SaleEbiddingItemServiceImpl.class);
                        saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getRelationId, (Collection)nextItemList.stream().map(BaseEntity::getId).collect(Collectors.toList()))).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING.getValue()));
                        this.autoQuotePrice(dbHead, nextItemList);
                    }
                } else {
                    dbHead.setCurrentItemNumber("");
                    dbHead.setCurrentMaterialDesc("");
                    dbHead.setBeginTime(dbHead.getBeginTime());
                    dbHead.setEndTime(dbHead.getEndTime());
                    dbHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
                    if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod())) {
                        dbHead.setEndTime(new Date());
                    }
                }
                if (CollectionUtil.isNotEmpty(currentItemList = dbItemList.stream().filter(item -> currentItemNumber.equals(item.getItemNumber())).collect(Collectors.toList()))) {
                    currentItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue()));
                    this.purchaseEbiddingItemService.updateBatchById(currentItemList);
                    List idList = currentItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    itemIdList.addAll(idList);
                }
            }
        } else {
            dbHead.setCurrentMaterialDesc(EbiddingWayEnum.getDesc(dbHead.getEbiddingWay()));
            dbHead.setEndTime(new Date());
            dbItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.updateBatchById(dbItemList);
            List idList = dbItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            itemIdList.addAll(idList);
        }
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEbiddingHeadService.endEbidding(dbHead, itemIdList);
        this.redis.publish("quote-price-topic", (Object)dbHead.getId());
    }

    private void autoQuotePrice(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> quoteList) {
        if (START_PRICE_FLAG.equals(dbHead.getPurchaseAutoQuote())) {
            List<SaleEbiddingHead> saleList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
            List biddingList = saleList.stream().filter(sale -> EbiddingStatusEnum.BIDDING.getValue().equals(sale.getEbiddingStatus())).map(BaseEntity::getElsAccount).collect(Collectors.toList());
            log.info("autoQuotePrice->quoteList:{}", (Object)JSONObject.toJSONString(quoteList));
            for (PurchaseEbiddingItem dbItem : quoteList) {
                BigDecimal quotePrice;
                if (!biddingList.contains(dbItem.getToElsAccount())) continue;
                PurchaseEbiddingItem quoteItem = new PurchaseEbiddingItem();
                BeanUtils.copyProperties((Object)((Object)dbItem), (Object)((Object)quoteItem));
                this.purchaseEbiddingItemHisService.queryAddQuoteSite(dbHead, quoteItem);
                dbItem.setBidNumber(quoteItem.getBidNumber());
                log.info("autoQuotePrice->quoteItem:{}", (Object)JSONObject.toJSONString((Object)((Object)quoteItem)));
                if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                    quotePrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetPrice() : quoteItem.getPrice();
                } else {
                    BigDecimal bigDecimal = quotePrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetTotalAmount() : quoteItem.getTotalAmount();
                }
                if (quotePrice != null && quotePrice.compareTo(BigDecimal.ZERO) >= 0) {
                    this.quote(dbHead, dbItem, quoteItem);
                    continue;
                }
                log.error("\u7ade\u4ef7\u5355\u53f7[{}]->\u884c\u53f7[{}]\uff0c\u81ea\u52a8\u62a5\u4ef7\u5931\u8d25\uff0c\u62a5\u4ef7\u5c0f\u4e8e0", (Object)JSONObject.toJSONString((Object)((Object)quoteItem)));
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JOsuKmsuXU0_71c3596a", (String)"\u81ea\u52a8\u62a5\u4ef7\u5931\u8d25\uff0c\u62a5\u4ef7\u5c0f\u4e8e0\uff01"));
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public boolean autoQuotePricePublic(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> quoteList) {
        try {
            this.autoQuotePrice(dbHead, quoteList);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void manualStartBid(PurchaseEbiddingHeadVO headVO) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Date currentTime = new Date();
        Assert.isTrue((boolean)currentTime.after(dbHead.getBeginTime()), (String)I18nUtil.translate((String)"i18n_alert_OuvKKILuWPxOvAOuW_ecf2e58b", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u672a\u5230\uff0c\u6682\u4e0d\u80fd\u5f00\u542f\u7ade\u4ef7\uff01"));
        List<String> status = Arrays.asList(EbiddingStatusEnum.WAIT_REPLY.getValue(), EbiddingStatusEnum.WAIT_BIDDING.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjoOunodBntFqvA_7f51a7cc", (String)"\u53ea\u6709\u5f85\u7ade\u4ef7\u548c\u5f85\u5e94\u6807\u7684\u5355\u636e\u53ef\u5f00\u542f"));
        PurchaseEbiddingHead update = new PurchaseEbiddingHead();
        update.setId(headVO.getId());
        update.setStartTime(currentTime);
        if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
            DateTime endTime = DateUtil.offsetSecond((Date)currentTime, (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1));
            update.setEndTime((Date)endTime);
        }
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)update);
        this.startBidding(headVO.getId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void manualEndBid(PurchaseEbiddingHeadVO headVO) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Date currentTime = new Date();
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_ROyWOusntFW_48f68479", (String)"\u53ea\u80fd\u7ed3\u675f\u7ade\u4ef7\u4e2d\u7684\u5355\u636e\uff01"));
        if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
            Assert.isTrue((boolean)currentTime.after(dbHead.getEndTime()), (String)I18nUtil.translate((String)"i18n_alert_OuyWKILuWxOyWOuW_5c8cb549", (String)"\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u80fd\u7ed3\u675f\u7ade\u4ef7\uff01"));
        }
        ArrayList<String> itemNumberList = new ArrayList<String>();
        if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod()) && START_PRICE_FLAG.equals(dbHead.getRespectiveQuotations()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            Assert.notEmpty(headVO.getPurchaseEbiddingItemList(), (String)I18nUtil.translate((String)"i18n_alert_ViFTPyWOujSL_a62fc5f7", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u7ed3\u675f\u7ade\u4ef7\u7684\u7269\u6599"));
            headVO.getPurchaseEbiddingItemList().forEach(item -> itemNumberList.add(item.getItemNumber()));
        }
        this.endBidding(dbHead.getId(), itemNumberList);
    }

    private Map<String, BigDecimal> getStartPriceMap(PurchaseEbiddingHeadVO headVO, List<PurchaseEbiddingItem> dbItemList) {
        HashMap<String, BigDecimal> startPriceMap = new HashMap<String, BigDecimal>(16);
        String startPriceFlag = headVO.getStartPriceFlag();
        if (START_PRICE_FLAG.equals(startPriceFlag)) {
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                Map<String, List<PurchaseEbiddingItem>> itemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
                for (String itemNumber : itemMap.keySet()) {
                    List itemList = itemMap.get(itemNumber).stream().filter(item -> item.getPrice() != null && item.getPrice().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
                    if (itemList.isEmpty()) continue;
                    if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(headVO.getEbiddingType())) {
                        BigDecimal maxPrice = itemList.stream().max(Comparator.comparing(PurchaseEbiddingItem::getPrice)).map(PurchaseEbiddingItem::getPrice).orElse(null);
                        startPriceMap.put(itemNumber, maxPrice);
                        continue;
                    }
                    BigDecimal minPrice = itemList.stream().min(Comparator.comparing(PurchaseEbiddingItem::getPrice)).map(PurchaseEbiddingItem::getPrice).orElse(null);
                    startPriceMap.put(itemNumber, minPrice);
                }
            } else {
                List itemList = dbItemList.stream().filter(item -> item.getTaxAmount() != null && item.getTaxAmount().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
                if (!itemList.isEmpty()) {
                    if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(headVO.getEbiddingType())) {
                        BigDecimal maxTotalAmount = itemList.stream().max(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount)).map(PurchaseEbiddingItem::getTotalAmount).orElse(null);
                        startPriceMap.put(headVO.getId(), maxTotalAmount);
                    } else {
                        BigDecimal minTotalAmount = itemList.stream().min(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount)).map(PurchaseEbiddingItem::getTotalAmount).orElse(null);
                        startPriceMap.put(headVO.getId(), minTotalAmount);
                    }
                }
            }
        }
        return startPriceMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void createNewRound(PurchaseEbiddingHeadVO headVO) {
        String headId = headVO.getId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING_END.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_OuyWjtFnqcIVVm_91ffe3ea", (String)"\u7ade\u4ef7\u7ed3\u675f\u7684\u5355\u636e\u624d\u53ef\u521b\u5efa\u65b0\u8f6e\u6b21"));
        String startPriceFlag = headVO.getStartPriceFlag();
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(headId);
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId, "item");
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        Map<String, BigDecimal> startPriceMap = this.getStartPriceMap(headVO, dbItemList);
        for (PurchaseEbiddingItem item : initItemList) {
            if (!START_PRICE_FLAG.equals(startPriceFlag)) continue;
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                item.setStartPrice(startPriceMap.get(item.getItemNumber()));
                continue;
            }
            headVO.setStartTotalAmount(startPriceMap.get(headId));
            break;
        }
        headVO.setPurchaseEbiddingItemList(initItemList);
        ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId(), "confirm");
        List confirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmVO.class);
        if (!CollectionUtils.isEmpty(headVO.getPurchaseEbiddingConfirmList())) {
            headVO.getPurchaseEbiddingConfirmList().forEach(e -> {
                if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)e.getId())) {
                    confirmList.add(e);
                }
            });
        }
        headVO.setPurchaseEbiddingConfirmList(confirmList);
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        supplierList.forEach(supplier -> supplier.setReplyTime(null));
        headVO.setPurchaseEbiddingSupplierList(supplierList);
        headVO.setAuditStatus(START_PRICE_FLAG.equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setResultAuditStatus(START_PRICE_FLAG.equals(headVO.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setCurrentRound(headVO.getCurrentRound() + 1);
        headVO.setCurrentDelayCount(0);
        headVO.setReplyQuantity(0);
        headVO.setId(null);
        headVO.setQuoteFlag(null);
        this.newRoundPublish(headVO);
        PurchaseEbiddingHead purchaseHead = new PurchaseEbiddingHead();
        purchaseHead.setId(headId);
        purchaseHead.setEbiddingStatus(EbiddingStatusEnum.NEW_ROUND.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)purchaseHead);
    }

    private void saveNewPurchaseAttachmentList(PurchaseEbiddingHeadVO headVO) {
        List<PurchaseAttachmentDTO> purchaseAttachmentList = headVO.getPurchaseAttachmentList();
        if (CollectionUtils.isEmpty(purchaseAttachmentList)) {
            return;
        }
        purchaseAttachmentList.forEach(e -> {
            e.setId(null);
            e.setSendStatus("0");
            e.setHeadId(headVO.getId());
        });
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submitPrice(PurchaseEbiddingHead dbHead, PurchaseAwardOpinionVO opinionVO, List<PurchaseEbiddingItem> dbItemList) {
        ArrayList<PurchaseEbiddingItem> itemList = new ArrayList<PurchaseEbiddingItem>();
        List<PurchaseEbiddingSupplierVO> supplierVOList = opinionVO.getPurchaseEbiddingSupplierQuoteList();
        for (PurchaseEbiddingSupplierVO supplierVO : supplierVOList) {
            if (supplierVO.getPurchaseEbiddingItemList() == null || supplierVO.getPurchaseEbiddingItemList().size() <= 0) continue;
            itemList.addAll(supplierVO.getPurchaseEbiddingItemList());
        }
        this.checkSubmitPrice(dbHead, itemList, opinionVO.getAcceptMinPrice());
        this.purchaseAwardOpinionService.save((Object)opinionVO);
        String quotaWay = dbHead.getQuotaWay();
        log.warn("submitPrice,ebiddingWay:{},flag:{},size:{}", new Object[]{dbHead.getEbiddingWay(), EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), itemList.size()});
        ArrayList<PurchaseEbiddingSupplier> supplierList = new ArrayList<PurchaseEbiddingSupplier>();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) || EbiddingWayEnum.DISPOSABLE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItem item : itemList) {
                BigDecimal taxAmount;
                item.setQuota((BigDecimal)(EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus()) ? item.getQuota() : (item.getQuota() == null ? null : BigDecimal.ZERO)));
                item.setItemStatus(EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus()) ? EbiddingItemStatusEnum.BID_WIN.getValue() : EbiddingItemStatusEnum.UN_BID_WIN.getValue());
                log.warn("submitPrice,quota:{},requireQuantity:{},quotaWay:{}", new Object[]{item.getQuota(), item.getRequireQuantity(), quotaWay});
                if (item.getRequireQuantity() == null || !EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())) continue;
                if (QuotaWayEnum.SCALE.getValue().equals(quotaWay)) {
                    BigDecimal multiply = item.getRequireQuantity().multiply(item.getQuota().divide(BigDecimal.valueOf(100L), 6, 5));
                    item.setQuotaQuantity(multiply);
                } else {
                    item.setQuotaQuantity(item.getQuota());
                }
                BigDecimal divide = taxAmount = item.getQuotaQuantity().multiply(item.getPrice());
                if (StringUtils.isNotBlank((CharSequence)item.getTaxRate())) {
                    divide = taxAmount.divide(BigDecimal.ONE.add(new BigDecimal(item.getTaxRate()).divide(BigDecimal.valueOf(100L), 2, 5)), 6, 5);
                }
                item.setQuotaTaxAmount(taxAmount);
                item.setQuotaNetAmount(divide);
                log.info("\u66f4\u65b0\u4e2d\u6807\u4fe1\u606f\u62c6\u5206\u91d1\u989d,\u7ade\u4ef7\u5355\u53f7:" + dbHead.getEbiddingNumber() + "\u884c\u53f7:" + item.getItemNumber() + ",\u62c6\u5206\u6570\u91cf:" + item.getQuotaQuantity() + ",\u542b\u7a0e\u91d1\u989d" + item.getQuotaTaxAmount() + ",\u4e0d\u542b\u7a0e\u91d1\u989d" + item.getQuotaNetAmount());
            }
            this.purchaseEbiddingItemService.updateBatchById(itemList);
            Map<String, String> supplierMap = itemList.stream().collect(Collectors.toMap(PurchaseEbiddingItem::getToElsAccount, PurchaseEbiddingItem::getItemStatus, (oldVal, newVal) -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
            supplierMap.forEach((key, value) -> {
                PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount((String)key);
                supplier.setBiddingStatus((String)value);
                supplierList.add(supplier);
            });
        } else {
            for (PurchaseEbiddingItem item : itemList) {
                String itemStatus = EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus()) ? EbiddingItemStatusEnum.BID_WIN.getValue() : EbiddingItemStatusEnum.UN_BID_WIN.getValue();
                BigDecimal quota = EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus()) ? item.getQuota() : null;
                item.setQuota(quota);
                item.setItemStatus(itemStatus);
                if (item.getTaxAmount() != null && quota != null) {
                    BigDecimal divide = quota.divide(BigDecimal.valueOf(100L), 6, 5);
                    item.setQuotaTaxAmount(item.getTaxAmount().multiply(divide));
                    item.setQuotaNetAmount(item.getNetAmount().multiply(divide));
                }
                PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount(item.getToElsAccount());
                supplier.setQuota(quota == null ? null : quota.toString());
                supplier.setBiddingStatus(itemStatus);
                supplierList.add(supplier);
            }
            this.purchaseEbiddingItemService.updateBidByHeadId(itemList);
        }
        this.purchaseEbiddingSupplierService.updateBidResultBatch(supplierList);
        if ("0".equals(dbHead.getResultAudit())) {
            this.priced(dbHead, itemList, supplierList);
            this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                List acceptList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.purchaseEbiddingItemService.lambdaQuery().eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getId())).eq(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BID_WIN.getValue())).list();
                this.generatePriceRecord(dbHead, acceptList);
            }
        } else {
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(dbHead.getId());
            dto.setBusinessType("resultEbidding");
            String projectName = StringUtils.isNotBlank((CharSequence)dbHead.getProjectName()) ? dbHead.getProjectName() : "";
            dto.setAuditSubject("\u7ade\u4ef7\u7ed3\u679c\u5ba1\u6279\uff0c\u5355\u53f7\uff1a" + dbHead.getEbiddingNumber() + " " + projectName);
            PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            headVO.setPurchaseEbiddingItemList(dbItemList);
            dto.setParams(JSONObject.toJSONString((Object)((Object)headVO)));
            this.inquiryInvokeWorkFlowRpcService.submit(dto);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submitPriceByHis(PurchaseEbiddingHead dbHead, PurchaseAwardOpinionVO opinionVO, List<PurchaseEbiddingItemHis> dbItemList) {
        ArrayList<PurchaseEbiddingItemHis> itemList = new ArrayList<PurchaseEbiddingItemHis>();
        List<PurchaseEbiddingSupplierVO> supplierVOList = opinionVO.getPurchaseEbiddingSupplierQuoteList();
        for (PurchaseEbiddingSupplierVO supplierVO : supplierVOList) {
            if (supplierVO.getPurchaseEbiddingItemHis() == null || supplierVO.getPurchaseEbiddingItemHis().size() <= 0) continue;
            itemList.addAll(supplierVO.getPurchaseEbiddingItemHis());
        }
        itemList.forEach(item -> item.setQuota(item.getBidNumber()));
        this.checkSubmitPriceByHis(dbHead, itemList, opinionVO.getAcceptMinPrice());
        this.purchaseAwardOpinionService.save((Object)opinionVO);
        String quotaWay = dbHead.getQuotaWay();
        log.warn("submitPrice,ebiddingWay:{},flag:{},size:{}", new Object[]{dbHead.getEbiddingWay(), EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), itemList.size()});
        ArrayList<PurchaseEbiddingSupplier> supplierList = new ArrayList<PurchaseEbiddingSupplier>();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItemHis item2 : itemList) {
                BigDecimal taxAmount;
                item2.setQuota((BigDecimal)(EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? item2.getQuota() : (item2.getQuota() == null ? null : BigDecimal.ZERO)));
                item2.setItemStatus(EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? EbiddingItemStatusEnum.BID_WIN.getValue() : EbiddingItemStatusEnum.UN_BID_WIN.getValue());
                log.warn("submitPrice,quota:{},requireQuantity:{},quotaWay:{}", new Object[]{item2.getQuota(), item2.getRequireQuantity(), quotaWay});
                if (item2.getRequireQuantity() == null || !EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus())) continue;
                if (QuotaWayEnum.SCALE.getValue().equals(quotaWay)) {
                    BigDecimal multiply = item2.getRequireQuantity().multiply(item2.getQuota().divide(BigDecimal.valueOf(100L), 6, 5));
                    item2.setQuotaQuantity(multiply);
                } else {
                    item2.setQuotaQuantity(item2.getQuota());
                }
                BigDecimal divide = taxAmount = item2.getQuotaQuantity().multiply(item2.getPrice());
                if (StringUtils.isNotBlank((CharSequence)item2.getTaxRate())) {
                    divide = taxAmount.divide(BigDecimal.ONE.add(new BigDecimal(item2.getTaxRate()).divide(BigDecimal.valueOf(100L), 2, 5)), 6, 5);
                }
                item2.setQuotaTaxAmount(taxAmount);
                item2.setQuotaNetAmount(divide);
                log.error("\u66f4\u65b0\u4e2d\u6807\u4fe1\u606f\u62c6\u5206\u91d1\u989d,\u7ade\u4ef7\u5355\u53f7:" + dbHead.getEbiddingNumber() + "\u884c\u53f7:" + item2.getItemNumber() + ",\u62c6\u5206\u6570\u91cf:" + item2.getQuotaQuantity() + ",\u542b\u7a0e\u91d1\u989d" + item2.getQuotaTaxAmount() + ",\u4e0d\u542b\u7a0e\u91d1\u989d" + item2.getQuotaNetAmount());
            }
            this.purchaseEbiddingItemHisService.updateBatchById(itemList);
            Map<String, String> supplierMap = itemList.stream().collect(Collectors.toMap(PurchaseEbiddingItemHis::getToElsAccount, PurchaseEbiddingItemHis::getItemStatus, (oldVal, newVal) -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
            supplierMap.forEach((key, value) -> {
                PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount((String)key);
                supplier.setBiddingStatus((String)value);
                supplierList.add(supplier);
            });
        } else {
            for (PurchaseEbiddingItemHis item2 : itemList) {
                String itemStatus = EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? EbiddingItemStatusEnum.BID_WIN.getValue() : EbiddingItemStatusEnum.UN_BID_WIN.getValue();
                BigDecimal quota = EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? item2.getQuota() : null;
                item2.setQuota(quota);
                item2.setItemStatus(itemStatus);
                if (item2.getTaxAmount() != null && quota != null) {
                    BigDecimal divide = quota.divide(BigDecimal.valueOf(100L), 6, 5);
                    item2.setQuotaTaxAmount(item2.getTaxAmount().multiply(divide));
                    item2.setQuotaNetAmount(item2.getNetAmount().multiply(divide));
                }
                PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount(item2.getToElsAccount());
                supplier.setQuota(quota == null ? null : quota.toString());
                supplier.setBiddingStatus(itemStatus);
                supplierList.add(supplier);
            }
            this.purchaseEbiddingItemHisService.updateBidByHeadId(itemList);
        }
        this.purchaseEbiddingSupplierService.updateBidResultBatch(supplierList);
        if ("0".equals(dbHead.getResultAudit())) {
            this.pricedByHis(dbHead, itemList, supplierList);
            List ids = itemList.stream().map(PurchaseEbiddingItemHis::getItemId).distinct().collect(Collectors.toList());
            List byIds = this.purchaseEbiddingItemService.listByIds(ids);
            this.goBackDemand(byIds, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                List<PurchaseEbiddingItemHis> acceptList = this.purchaseEbiddingItemHisService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                this.generatePriceRecordByHis(dbHead, acceptList);
            }
        } else {
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(dbHead.getId());
            dto.setBusinessType("resultEbidding");
            String projectName = StringUtils.isNotBlank((CharSequence)dbHead.getProjectName()) ? dbHead.getProjectName() : "";
            dto.setAuditSubject("\u7ade\u4ef7\u7ed3\u679c\u5ba1\u6279\uff0c\u5355\u53f7\uff1a" + dbHead.getEbiddingNumber() + " " + projectName);
            PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            headVO.setPurchaseEbiddingItemHisList(dbItemList);
            dto.setParams(JSONObject.toJSONString((Object)((Object)headVO)));
            this.inquiryInvokeWorkFlowRpcService.submit(dto);
        }
    }

    private void checkSubmitPrice(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> itemList, String acceptMinPrice) {
        Map<String, List<PurchaseEbiddingItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
        Map<String, String> itemStatusMap = itemList.stream().collect(Collectors.toMap(PurchaseEbiddingItem::getItemNumber, PurchaseEbiddingItem::getItemStatus, (oldVal, newVal) -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
        ArrayList<String> checkList = new ArrayList<String>();
        for (String itemNumber : itemMap.keySet()) {
            List<PurchaseEbiddingItem> list;
            String itemStatus = itemStatusMap.get(itemNumber);
            if (START_PRICE_FLAG.equals(acceptMinPrice) && !EbiddingItemStatusEnum.BID_WIN.getValue().equals(itemStatus)) {
                list = itemMap.get(itemNumber);
                List<PurchaseEbiddingItem> sortList = EbiddingTypeEnum.getEnumByValue(dbHead.getEbiddingType()).sort(dbHead.getEbiddingWay(), list);
                if (CollectionUtil.isNotEmpty(sortList)) {
                    PurchaseEbiddingItem appropriate = sortList.get(0);
                    for (PurchaseEbiddingItem item2 : list) {
                        if (!item2.getId().equals(appropriate.getId())) continue;
                        item2.setItemStatus(EbiddingItemStatusEnum.BID_WIN.getValue());
                        BigDecimal quota = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay()) ? BigDecimal.valueOf(100L) : appropriate.getRequireQuantity();
                        item2.setQuota(quota);
                    }
                    continue;
                }
                list.forEach(item -> {
                    item.setItemStatus(EbiddingItemStatusEnum.UN_BID_WIN.getValue());
                    item.setQuota(null);
                });
                continue;
            }
            if (EbiddingItemStatusEnum.BID_WIN.getValue().equals(itemStatus) || (list = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) || EbiddingWayEnum.DISPOSABLE.getValue().equals(dbHead.getEbiddingWay()) ? itemMap.get(itemNumber).stream().filter(item -> item.getPrice() != null && item.getPrice().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList()) : itemMap.get(itemNumber).stream().filter(item -> item.getTotalAmount() != null && item.getTotalAmount().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList())).isEmpty()) continue;
            checkList.add(itemNumber);
        }
        if (!checkList.isEmpty()) {
            List materialList = itemList.stream().filter(item -> checkList.contains(item.getItemNumber())).map(PurchaseEbiddingItem::getMaterialDesc).distinct().collect(Collectors.toList());
            String message = EbiddingTypeEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType()) ? (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? I18nUtil.translate((String)"i18n_alert_WWWWWLlBWKQCLexusBW_39c42088", (String)"${0} \u672a\u6388\u6807\uff0c\u662f\u5426\u9ed8\u8ba4\u6700\u9ad8\u4ef7\u4e2d\u6807\uff1f", (String[])new String[]{String.join((CharSequence)"\uff0c", materialList)}) : I18nUtil.translate((String)"i18n_alert_KQCLexusBW_86c45c09", (String)"\u662f\u5426\u9ed8\u8ba4\u6700\u9ad8\u4ef7\u4e2d\u6807\uff1f")) : (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? I18nUtil.translate((String)"i18n_alert_WWWWWLlBWKQCLenusBW_1148a9fe", (String)"${0} \u672a\u6388\u6807\uff0c\u662f\u5426\u9ed8\u8ba4\u6700\u4f4e\u4ef7\u4e2d\u6807\uff1f", (String[])new String[]{String.join((CharSequence)"\uff0c", materialList)}) : I18nUtil.translate((String)"i18n_alert_KQCLenusBW_5e48e57f", (String)"\u662f\u5426\u9ed8\u8ba4\u6700\u4f4e\u4ef7\u4e2d\u6807\uff1f"));
            throw new ELSAgainException(message);
        }
        List<PurchaseEbiddingItem> acceptList = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(acceptList)) {
            acceptList.forEach(item -> {
                Assert.isTrue((item.getPrice() != null || item.getTotalAmount() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_LsujRdXxqsB_92e6b4a1", (String)"\u672a\u62a5\u4ef7\u7684\u4f9b\u5e94\u5546\u4e0d\u53ef\u4e2d\u6807"));
                if (QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay())) {
                    Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_sBjWFWvzlvlTfUW_88b8f618", (String)"\u4e2d\u6807\u7684\u6570\u636e\uff0c\u62c6\u5206\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0"));
                } else {
                    Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_sBjWFWvzWRlTfUW_8d48d2f0", (String)"\u4e2d\u6807\u7684\u6570\u636e\uff0c\u62c6\u5206\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
                }
            });
            Map<String, List<PurchaseEbiddingItem>> acceptMap = acceptList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
            for (String itemNumber : acceptMap.keySet()) {
                List<PurchaseEbiddingItem> list = acceptMap.get(itemNumber);
                BigDecimal quotaTotal = list.stream().map(PurchaseEbiddingItem::getQuota).reduce(BigDecimal.ZERO, BigDecimal::add);
                boolean isScale = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay());
                BigDecimal quota = isScale ? BigDecimal.valueOf(100L) : list.get(0).getRequireQuantity();
                String message = isScale ? I18nUtil.translate((String)"i18n_alert_vzlvRnlTEUWWWW_ffbb0603", (String)"\u62c6\u5206\u6bd4\u4f8b\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100\uff01") : I18nUtil.translate((String)"i18n_alert_vzWRRnlTEUTVWRW_11dd4a65", (String)"\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u9700\u6c42\u6570\u91cf\uff01");
                Assert.isTrue((quotaTotal.compareTo(quota) == 0 ? 1 : 0) != 0, (String)message);
            }
        }
    }

    private void checkSubmitPriceByHis(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItemHis> itemList, String acceptMinPrice) {
        Map<String, List<PurchaseEbiddingItemHis>> itemMap = itemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemHis::getItemNumber));
        Map<String, String> itemStatusMap = itemList.stream().collect(Collectors.toMap(PurchaseEbiddingItemHis::getItemNumber, PurchaseEbiddingItemHis::getItemStatus, (oldVal, newVal) -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
        ArrayList<String> checkList = new ArrayList<String>();
        for (String itemNumber : itemMap.keySet()) {
            List<PurchaseEbiddingItemHis> list;
            String itemStatus = itemStatusMap.get(itemNumber);
            if (START_PRICE_FLAG.equals(acceptMinPrice) && !EbiddingItemStatusEnum.BID_WIN.getValue().equals(itemStatus)) {
                list = itemMap.get(itemNumber);
                List<PurchaseEbiddingItemHis> sortList = EbiddingTypeHisEnum.getEnumByValue(dbHead.getEbiddingType()).sort(dbHead.getEbiddingWay(), list);
                if (CollectionUtil.isNotEmpty(sortList)) {
                    PurchaseEbiddingItemHis appropriate = sortList.get(0);
                    for (PurchaseEbiddingItemHis item2 : list) {
                        if (!item2.getId().equals(appropriate.getId())) continue;
                        item2.setItemStatus(EbiddingItemStatusEnum.BID_WIN.getValue());
                        BigDecimal quota = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay()) ? BigDecimal.valueOf(100L) : appropriate.getRequireQuantity();
                        item2.setQuota(quota);
                    }
                    continue;
                }
                list.forEach(item -> {
                    item.setItemStatus(EbiddingItemStatusEnum.UN_BID_WIN.getValue());
                    item.setQuota(null);
                });
                continue;
            }
            if (EbiddingItemStatusEnum.BID_WIN.getValue().equals(itemStatus) || (list = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? itemMap.get(itemNumber).stream().filter(item -> item.getPrice() != null && item.getPrice().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList()) : itemMap.get(itemNumber).stream().filter(item -> item.getTotalAmount() != null && item.getTotalAmount().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList())).isEmpty()) continue;
            checkList.add(itemNumber);
        }
        if (!checkList.isEmpty()) {
            List materialList = itemList.stream().filter(item -> checkList.contains(item.getItemNumber())).map(PurchaseEbiddingItemHis::getMaterialDesc).distinct().collect(Collectors.toList());
            String message = EbiddingTypeEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType()) ? (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? I18nUtil.translate((String)"i18n_alert_WWWWWLlBWKQCLexusBW_39c42088", (String)"${0} \u672a\u6388\u6807\uff0c\u662f\u5426\u9ed8\u8ba4\u6700\u9ad8\u4ef7\u4e2d\u6807\uff1f", (String[])new String[]{String.join((CharSequence)"\uff0c", materialList)}) : I18nUtil.translate((String)"i18n_alert_KQCLexusBW_86c45c09", (String)"\u662f\u5426\u9ed8\u8ba4\u6700\u9ad8\u4ef7\u4e2d\u6807\uff1f")) : (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? I18nUtil.translate((String)"i18n_alert_WWWWWLlBWKQCLenusBW_1148a9fe", (String)"${0} \u672a\u6388\u6807\uff0c\u662f\u5426\u9ed8\u8ba4\u6700\u4f4e\u4ef7\u4e2d\u6807\uff1f", (String[])new String[]{String.join((CharSequence)"\uff0c", materialList)}) : I18nUtil.translate((String)"i18n_alert_KQCLenusBW_5e48e57f", (String)"\u662f\u5426\u9ed8\u8ba4\u6700\u4f4e\u4ef7\u4e2d\u6807\uff1f"));
            throw new ELSAgainException(message);
        }
        List<PurchaseEbiddingItemHis> acceptList = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(acceptList)) {
            acceptList.forEach(item -> {
                Assert.isTrue((item.getPrice() != null || item.getTotalAmount() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_LsujRdXxqsB_92e6b4a1", (String)"\u672a\u62a5\u4ef7\u7684\u4f9b\u5e94\u5546\u4e0d\u53ef\u4e2d\u6807"));
                if (QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay())) {
                    Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_sBjWFWvzlvlTfUW_88b8f618", (String)"\u4e2d\u6807\u7684\u6570\u636e\uff0c\u62c6\u5206\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0"));
                } else {
                    Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_sBjWFWvzWRlTfUW_8d48d2f0", (String)"\u4e2d\u6807\u7684\u6570\u636e\uff0c\u62c6\u5206\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
                }
            });
            Map<String, List<PurchaseEbiddingItemHis>> acceptMap = acceptList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemHis::getItemNumber));
            for (String itemNumber : acceptMap.keySet()) {
                List<PurchaseEbiddingItemHis> list = acceptMap.get(itemNumber);
                BigDecimal quotaTotal = list.stream().map(PurchaseEbiddingItemHis::getQuota).reduce(BigDecimal.ZERO, BigDecimal::add);
                boolean isScale = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay());
                BigDecimal quota = isScale ? BigDecimal.valueOf(100L) : list.get(0).getRequireQuantity();
                String message = isScale ? I18nUtil.translate((String)"i18n_alert_vzlvRnlTEUWWWW_ffbb0603", (String)"\u62c6\u5206\u6bd4\u4f8b\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100\uff01") : I18nUtil.translate((String)"i18n_alert_vzWRRnlTEUTVWRW_11dd4a65", (String)"\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u9700\u6c42\u6570\u91cf\uff01");
                Assert.isTrue((quotaTotal.compareTo(quota) == 0 ? 1 : 0) != 0, (String)message);
            }
        }
    }

    @Override
    public void priced(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList) {
        block12: {
            List limit;
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseEbiddingItemService.lambdaUpdate().set(PurchaseEbiddingItem::getPricedTime, (Object)new Date())).eq(PurchaseEbiddingItem::getHeadId, (Object)dbHead.getId())).update((Object)new PurchaseEbiddingItem());
            dbHead.setEbiddingStatus(EbiddingStatusEnum.BID_SUCCESS.getValue());
            BigDecimal ebiddingAmount = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) || EbiddingWayEnum.DISPOSABLE.getValue().equals(dbHead.getEbiddingWay()) ? itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItem::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : ((limit = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).limit(1L).collect(Collectors.toList())).isEmpty() ? BigDecimal.ZERO : ((PurchaseEbiddingItem)((Object)limit.get(0))).getTotalAmount());
            dbHead.setEbiddingAmount(ebiddingAmount);
            if (dbHead.getProjectBudget() != null && dbHead.getProjectBudget().compareTo(BigDecimal.ZERO) != 0) {
                dbHead.setSavingAmount(dbHead.getProjectBudget().subtract(ebiddingAmount));
                if (BigDecimal.ZERO.compareTo(dbHead.getProjectBudget()) != 0) {
                    dbHead.setSavingRate(dbHead.getSavingAmount().divide(dbHead.getProjectBudget(), 6, 4).multiply(BigDecimal.valueOf(100L)));
                }
            }
            ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
            this.saleEbiddingHeadService.priced(dbHead, itemList, supplierList);
            if (PricingNoticeEnum.NOT.getValue().equals(dbHead.getPricingNotice())) break block12;
            ArrayList sendAccountList = new ArrayList();
            List<PurchaseEbiddingSupplier> dbSupplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
            if (PricingNoticeEnum.WIN.getValue().equals(dbHead.getPricingNotice())) {
                sendAccountList.addAll(dbSupplierList.stream().filter(supplier -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(supplier.getBiddingStatus())).map(PurchaseEbiddingSupplier::getToElsAccount).collect(Collectors.toList()));
            } else if (PricingNoticeEnum.ALL.getValue().equals(dbHead.getPricingNotice()) && START_PRICE_FLAG.equals(dbHead.getNeedEcho())) {
                sendAccountList.addAll(dbSupplierList.stream().filter(supplier -> EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus())).map(PurchaseEbiddingSupplier::getToElsAccount).collect(Collectors.toList()));
            }
            List<PurchaseEbiddingItem> sendItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> sendAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
            sendItemList.forEach(item -> item.setKeyWord(SysUtil.getLoginUser().getEnterpriseName()));
            if (CollectionUtil.isNotEmpty(sendItemList)) {
                if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                    for (PurchaseEbiddingItem item2 : sendItemList) {
                        if (EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus())) {
                            super.sendMessage(TenantContext.getTenant(), "ebidding", "confirm", item2.getHeadId(), "ebiddingBusDataServiceImpl", Arrays.asList(item2.getToElsAccount()));
                            continue;
                        }
                        super.sendMessage(TenantContext.getTenant(), "ebidding", "refundPurchase", item2.getHeadId(), "ebiddingBusDataServiceImpl", Arrays.asList(item2.getToElsAccount()));
                    }
                } else {
                    sendItemList.forEach(item -> item.setPrice(item.getTotalAmount()));
                    Map<String, PurchaseEbiddingItem> packageMap = sendItemList.stream().collect(Collectors.toMap(PurchaseEbiddingItem::getToElsAccount, item -> {
                        PurchaseEbiddingItem purchaseEbiddingItem = new PurchaseEbiddingItem();
                        BeanUtils.copyProperties((Object)item, (Object)((Object)purchaseEbiddingItem));
                        return purchaseEbiddingItem;
                    }, (newVal, oldVal) -> {
                        String materialNumber = oldVal.getMaterialNumber();
                        oldVal.setMaterialNumber(materialNumber + "," + newVal.getMaterialNumber());
                        BigDecimal oldRequireQuantity = oldVal.getRequireQuantity() == null ? BigDecimal.ZERO : oldVal.getRequireQuantity();
                        BigDecimal newRequireQuantity = newVal.getRequireQuantity() == null ? BigDecimal.ZERO : newVal.getRequireQuantity();
                        oldVal.setRequireQuantity(oldRequireQuantity.add(newRequireQuantity));
                        return oldVal;
                    }));
                    for (PurchaseEbiddingItem item3 : packageMap.values()) {
                        if (EbiddingItemStatusEnum.BID_WIN.getValue().equals(item3.getItemStatus())) {
                            super.sendMessage(TenantContext.getTenant(), "ebidding", "confirm", item3.getHeadId(), "ebiddingBusDataServiceImpl", Arrays.asList(item3.getToElsAccount()));
                            continue;
                        }
                        super.sendMessage(TenantContext.getTenant(), "ebidding", "refundPurchase", item3.getHeadId(), "ebiddingBusDataServiceImpl", Arrays.asList(item3.getToElsAccount()));
                    }
                }
            }
        }
    }

    @Override
    public void pricedByHis(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItemHis> itemList, List<PurchaseEbiddingSupplier> supplierList) {
        block12: {
            List limit;
            List<PurchaseEbiddingItemHis> dbItemList = this.purchaseEbiddingItemHisService.queryAcceptDetail(dbHead);
            Date pricedTime = new Date();
            dbItemList.forEach(item -> item.setPricedTime(pricedTime));
            this.purchaseEbiddingItemHisService.updateBatchById(dbItemList);
            dbHead.setEbiddingStatus(EbiddingStatusEnum.BID_SUCCESS.getValue());
            BigDecimal ebiddingAmount = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItemHis::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : ((limit = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).limit(1L).collect(Collectors.toList())).isEmpty() ? BigDecimal.ZERO : ((PurchaseEbiddingItemHis)((Object)limit.get(0))).getTotalAmount());
            dbHead.setEbiddingAmount(ebiddingAmount);
            if (dbHead.getProjectBudget() != null && dbHead.getProjectBudget().compareTo(BigDecimal.ZERO) != 0) {
                dbHead.setSavingAmount(dbHead.getProjectBudget().subtract(ebiddingAmount));
                if (BigDecimal.ZERO.compareTo(dbHead.getProjectBudget()) != 0) {
                    dbHead.setSavingRate(dbHead.getSavingAmount().divide(dbHead.getProjectBudget(), 6, 4).multiply(BigDecimal.valueOf(100L)));
                }
            }
            ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
            this.saleEbiddingHeadService.pricedByHis(dbHead, itemList, supplierList);
            if (PricingNoticeEnum.NOT.getValue().equals(dbHead.getPricingNotice())) break block12;
            ArrayList sendAccountList = new ArrayList();
            List<PurchaseEbiddingSupplier> dbSupplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
            if (PricingNoticeEnum.WIN.getValue().equals(dbHead.getPricingNotice())) {
                sendAccountList.addAll(dbSupplierList.stream().filter(supplier -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(supplier.getBiddingStatus())).map(PurchaseEbiddingSupplier::getToElsAccount).collect(Collectors.toList()));
            } else if (PricingNoticeEnum.ALL.getValue().equals(dbHead.getPricingNotice()) && START_PRICE_FLAG.equals(dbHead.getNeedEcho())) {
                sendAccountList.addAll(dbSupplierList.stream().filter(supplier -> EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus())).map(PurchaseEbiddingSupplier::getToElsAccount).collect(Collectors.toList()));
            }
            List<PurchaseEbiddingItemHis> sendItemList = this.purchaseEbiddingItemHisService.queryAcceptDetail(dbHead).stream().filter(item -> sendAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
            sendItemList.forEach(item -> item.setKeyWord(SysUtil.getLoginUser().getEnterpriseName()));
            if (CollectionUtil.isNotEmpty(sendItemList)) {
                Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(dbHead.getId());
                if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                    for (PurchaseEbiddingItemHis item2 : sendItemList) {
                        if (EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus())) {
                            super.sendMessage(TenantContext.getTenant(), "ebidding", "confirm", item2.getHeadId(), "ebiddingBusDataServiceImpl", Arrays.asList(item2.getToElsAccount()));
                            continue;
                        }
                        super.sendMessage(TenantContext.getTenant(), "ebidding", "refundPurchase", item2.getHeadId(), "ebiddingBusDataServiceImpl", Arrays.asList(item2.getToElsAccount()));
                    }
                } else {
                    sendItemList.forEach(item -> item.setPrice(item.getTotalAmount()));
                    Map packageMap = sendItemList.stream().collect(Collectors.toMap(PurchaseEbiddingItemHis::getToElsAccount, Function.identity(), (newVal, oldVal) -> {
                        String materialNumber = oldVal.getMaterialNumber();
                        oldVal.setMaterialNumber(materialNumber + "," + newVal.getMaterialNumber());
                        BigDecimal oldRequireQuantity = oldVal.getRequireQuantity() == null ? BigDecimal.ZERO : oldVal.getRequireQuantity();
                        BigDecimal newRequireQuantity = newVal.getRequireQuantity() == null ? BigDecimal.ZERO : newVal.getRequireQuantity();
                        oldVal.setRequireQuantity(oldRequireQuantity.add(newRequireQuantity));
                        return oldVal;
                    }));
                    for (PurchaseEbiddingItemHis item3 : packageMap.values()) {
                        if (EbiddingItemStatusEnum.BID_WIN.getValue().equals(item3.getItemStatus())) {
                            super.sendMessage(TenantContext.getTenant(), "ebidding", "confirm", item3.getHeadId(), "ebiddingBusDataServiceImpl", Arrays.asList(item3.getToElsAccount()));
                            continue;
                        }
                        super.sendMessage(TenantContext.getTenant(), "ebidding", "refundPurchase", item3.getHeadId(), "ebiddingBusDataServiceImpl", Arrays.asList(item3.getToElsAccount()));
                    }
                }
            }
        }
    }

    @Override
    public void cancel(PurchaseEbiddingHead dbHead) {
        dbHead.setEbiddingStatus(EbiddingStatusEnum.INVALID.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
        this.saleEbiddingHeadService.remove((Wrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getId()));
        EbiddingJobUtil.deleteAllJob(dbHead);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        this.inquiryInvokeMessageRpcService.delNotice(dbHead.getId());
        log.info("\u7ade\u4ef7\u4f5c\u5e9f\u5f00\u59cb\u53d1\u9001\u6d88\u606f");
        List<SaleEbiddingHead> saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
        Map idMap = saleHeadList.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity()));
        List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
        List toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
        Map<String, String> supplierMap = supplierList.stream().collect(Collectors.toMap(PurchaseEbiddingSupplier::getToElsAccount, PurchaseEbiddingSupplier::getSupplierName, (newVal, oldVal) -> oldVal));
        for (String toElsAccount : toElsAccountList) {
            PurchaseEbiddingMessageVO messageVO = new PurchaseEbiddingMessageVO();
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)messageVO));
            messageVO.setToElsAccount(toElsAccount);
            messageVO.setPurchaseCompanyName(SysUtil.getLoginUser().getEnterpriseName());
            messageVO.setSupplierName(supplierMap.get(toElsAccount));
        }
        super.sendMessage(TenantContext.getTenant(), "ebidding", "cancel", dbHead.getId(), "ebiddingBusDataServiceImpl", toElsAccountList);
        log.info("\u7ade\u4ef7\u4f5c\u5e9f\u53d1\u9001\u6d88\u606f\u5b8c\u6bd5");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void quote(PurchaseEbiddingHead dbHead, PurchaseEbiddingItem dbItem, PurchaseEbiddingItem quoteItem) {
        this.checkQuotePrice(dbHead, dbItem, quoteItem);
        this.computeQuotePrice(dbHead, dbItem, quoteItem);
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            if (quoteItem.getBidNumber() == null || quoteItem.getBidNumber().compareTo(BigDecimal.ZERO) == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBWRxOLVSNL0_3f48889b", (String)"\u6295\u6807\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3a0\uff01"));
            }
            if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) && "0".equals(dbHead.getAllowModifyQuantity()) && quoteItem.getBidNumber().compareTo(dbItem.getRequireQuantity()) != 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_OutxiTcrBnWReBWRdrATVWRIR_3c58466c", (String)"\u7ade\u4ef7\u5355\u4e0d\u5141\u8bb8\u4fee\u6539\u6807\u7684\u6570\u91cf\uff0c\u6295\u6807\u6570\u91cf\u5e94\u8be5\u8ddf\u9700\u6c42\u6570\u91cf\u4e00\u81f4\uff01"));
            }
            if (START_PRICE_FLAG.equals(dbHead.getAllowModifyQuantity()) && quoteItem.getBidNumber().compareTo(dbItem.getRemainingQuantity()) > 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_OutiTcrBnWReBWRBReBbUWR_4e466e9b", (String)"\u7ade\u4ef7\u5355\u5141\u8bb8\u4fee\u6539\u6807\u7684\u6570\u91cf\uff0c\u6295\u6807\u6570\u91cf\u8d85\u8fc7\u6295\u6807\u5269\u4f59\u6570\u91cf\uff01"));
            }
        }
        List saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId()).stream().filter(head -> dbItem.getToElsAccount().equals(head.getElsAccount())).collect(Collectors.toList());
        SaleEbiddingHead dbSaleHead = (SaleEbiddingHead)((Object)saleHeadList.get(0));
        this.purchaseEbiddingItemHisService.save(quoteItem, dbSaleHead);
        RedisUtil redis = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        redis.publish("quote-price-topic", (Object)dbHead.getId());
    }

    private void checkQuotePrice(PurchaseEbiddingHead dbHead, PurchaseEbiddingItem dbItem, PurchaseEbiddingItem quoteItem) {
        BigDecimal dbPrice;
        BigDecimal webPrice;
        BigDecimal startPrice;
        PurchaseEbiddingItemHis dbHisItem;
        List dbHisList = this.purchaseEbiddingItemHisService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseEbiddingItemHis::getItemId, (Object)dbItem.getId())).orderByDesc(PurchaseEbiddingItemHis::getQuoteTime));
        PurchaseEbiddingItemHis purchaseEbiddingItemHis = dbHisItem = dbHisList.isEmpty() ? new PurchaseEbiddingItemHis() : (PurchaseEbiddingItemHis)((Object)dbHisList.get(0));
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            startPrice = dbItem.getStartPrice();
            webPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetPrice() : quoteItem.getPrice();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            dbPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? dbHisItem.getNetPrice() : dbHisItem.getPrice();
        } else {
            startPrice = dbHead.getStartTotalAmount();
            webPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetTotalAmount() : quoteItem.getTotalAmount();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            BigDecimal bigDecimal = dbPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? dbHisItem.getNetTotalAmount() : dbHisItem.getTotalAmount();
        }
        if (startPrice != null && startPrice.compareTo(BigDecimal.ZERO) != 0 && START_PRICE_FLAG.equals(dbHead.getSetStartPrice())) {
            if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType())) {
                Assert.isTrue((startPrice.compareTo(webPrice) <= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_idOuWsulTfUEUAAu_dc6d22a8", (String)"\u6b63\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            }
            if (EbiddingTypeEnum.REVERSE_BID.getValue().equals(dbHead.getEbiddingType())) {
                Assert.isTrue((startPrice.compareTo(webPrice) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_vdOuWsulTXUEUAAu_53224de6", (String)"\u53cd\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            }
        }
        if (dbPrice != null) {
            BigDecimal changeRange;
            BigDecimal bigDecimal = changeRange = EbiddingRangeUnitEnum.PERCENT.getValue().equals(dbHead.getRangeUnit()) ? dbPrice.multiply(dbHead.getChangeRange().divide(BigDecimal.valueOf(100L), 6, 4)) : dbHead.getChangeRange();
            boolean flag = EbiddingTypeEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType()) ? webPrice.subtract(changeRange).compareTo(dbPrice) >= 0 : webPrice.add(changeRange).compareTo(dbPrice) <= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_APsuxBnOuBzWVVVsuW_6e488384", (String)"\u5f53\u524d\u62a5\u4ef7\u4e0d\u7b26\u5408\u7ade\u4ef7\u5e45\u5ea6\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\uff01"));
        }
    }

    private void computeQuotePrice(PurchaseEbiddingHead dbHead, PurchaseEbiddingItem dbItem, PurchaseEbiddingItem quoteItem) {
        BigDecimal taxRate;
        BigDecimal bigDecimal = taxRate = StrUtil.isNotBlank((CharSequence)dbItem.getTaxRate()) ? new BigDecimal(dbItem.getTaxRate()) : BigDecimal.ZERO;
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            BigDecimal requireQuantity;
            BigDecimal bigDecimal2 = requireQuantity = dbItem.getRequireQuantity() == null ? BigDecimal.ONE : dbItem.getRequireQuantity();
            if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType())) {
                BigDecimal price = quoteItem.getPrice();
                BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
                quoteItem.setNetPrice(netPrice);
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
            } else {
                BigDecimal netPrice = quoteItem.getNetPrice();
                BigDecimal price = netPrice.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L), 6, 4)));
                quoteItem.setPrice(price);
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
            }
        } else if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType())) {
            BigDecimal totalAmount = quoteItem.getTotalAmount();
            BigDecimal netTotalAmount = totalAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
            quoteItem.setNetTotalAmount(netTotalAmount);
        } else {
            BigDecimal netTotalAmount = quoteItem.getNetTotalAmount();
            BigDecimal totalAmount = netTotalAmount.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L), 6, 4)));
            quoteItem.setTotalAmount(totalAmount);
        }
        quoteItem.setQuoteTime(new Date());
        quoteItem.setQuoteCount(dbItem.getQuoteCount() == null ? 1 : dbItem.getQuoteCount() + 1);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void generatePriceRecord(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> acceptList) {
        if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
            return;
        }
        if (CollectionUtil.isNotEmpty(acceptList) && !START_PRICE_FLAG.equals(dbHead.getTest())) {
            ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
            for (PurchaseEbiddingItem item : acceptList) {
                PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
                BeanUtils.copyProperties((Object)((Object)item), (Object)records);
                records.setPurchaseGroup(dbHead.getPurchaseGroup());
                records.setPurchaseOrg(dbHead.getPurchaseOrg());
                records.setPurchaseUnit(item.getPurchaseUnit());
                records.setCompany(dbHead.getCompany());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setSourceId(dbHead.getId());
                records.setSourceItemId(item.getId());
                records.setSourceType(PriceSourceTypeEnum.EBIDDING.getValue());
                records.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
                records.setSourceNumber(dbHead.getEbiddingNumber());
                records.setCurrencyCode(item.getCurrency());
                records.setSourceItemNumber(item.getItemNumber());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
                records.setCurrencyCode(item.getCurrency());
                recordsList.add(records);
            }
            this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
            this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
            ArrayList<PurchaseEbiddingItem> updateList = new ArrayList<PurchaseEbiddingItem>();
            for (PurchaseEbiddingItem item : acceptList) {
                PurchaseEbiddingItem update = new PurchaseEbiddingItem();
                update.setId(item.getId());
                update.setSendStatus(START_PRICE_FLAG);
                updateList.add(update);
            }
            this.purchaseEbiddingItemService.updateBatchById(updateList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void generatePriceRecordByHis(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItemHis> acceptList) {
        if (CollectionUtil.isNotEmpty(acceptList) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) && !START_PRICE_FLAG.equals(dbHead.getTest())) {
            ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
            for (PurchaseEbiddingItemHis item : acceptList) {
                PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
                BeanUtils.copyProperties((Object)((Object)item), (Object)records);
                records.setPurchaseGroup(dbHead.getPurchaseGroup());
                records.setPurchaseOrg(dbHead.getPurchaseOrg());
                records.setPurchaseUnit(item.getPurchaseUnit());
                records.setCompany(dbHead.getCompany());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setSourceId(dbHead.getId());
                records.setSourceItemId(item.getId());
                records.setSourceType(PriceSourceTypeEnum.EBIDDING.getValue());
                records.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
                records.setSourceNumber(dbHead.getEbiddingNumber());
                records.setCurrencyCode(item.getCurrency());
                records.setSourceItemNumber(item.getItemNumber());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
                records.setCurrencyCode(item.getCurrency());
                records.setAllowDuplicatePrice(START_PRICE_FLAG);
                records.setSupplierBidNumber(item.getBidNumber());
                recordsList.add(records);
            }
            this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
            this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
            ArrayList<PurchaseEbiddingItemHis> updateList = new ArrayList<PurchaseEbiddingItemHis>();
            for (PurchaseEbiddingItemHis item : acceptList) {
                PurchaseEbiddingItemHis update = new PurchaseEbiddingItemHis();
                update.setId(item.getId());
                update.setSendStatus(START_PRICE_FLAG);
                updateList.add(update);
            }
            this.purchaseEbiddingItemHisService.updateBatchById(updateList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void regret(PurchaseEbiddingHeadVO headVO) {
        String headId = headVO.getId();
        String regretFlag = headVO.getRegretFlag();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)EbiddingStatusEnum.BID_SUCCESS.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_IlBntFnqMB_6899e661", (String)"\u5df2\u6388\u6807\u7684\u5355\u636e\u624d\u53ef\u6094\u6807"));
        dbHead.setEbiddingStatus(EbiddingStatusEnum.REGRET.getValue());
        dbHead.setResultAuditStatus(START_PRICE_FLAG.equals(dbHead.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(headId);
        itemList.forEach(item -> {
            item.setItemStatus(EbiddingItemStatusEnum.REGRET.getValue());
            item.setRegretFlag(regretFlag);
            item.setQuota(item.getQuota() == null ? null : BigDecimal.ZERO);
            item.setSendStatus("0");
            item.setAuditStatus(dbHead.getResultAuditStatus());
        });
        this.purchaseEbiddingItemService.updateBatchById(itemList);
        if (RegretFlagEnum.RE_SOURCE.getValue().equals(regretFlag)) {
            this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        } else if (RegretFlagEnum.RE_PRICED.getValue().equals(regretFlag)) {
            this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
        }
        this.saleEbiddingHeadService.regret(dbHead, itemList);
        String sourceNumber = dbHead.getEbiddingNumber();
        List<String> itemNumberList = itemList.stream().map(PurchaseEbiddingItem::getItemNumber).distinct().collect(Collectors.toList());
        this.inquiryInvokeMainDataRpcService.cancelPurchaseInformationBySourceNumber(PriceSourceTypeEnum.EBIDDING.getValue(), sourceNumber, itemNumberList);
        log.info("\u7ade\u4ef7\u6094\u6807\u5f00\u59cb\u53d1\u9001\u6d88\u606f");
        List<SaleEbiddingHead> saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
        Map idMap = saleHeadList.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity()));
        List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
        List toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
        Map<String, String> supplierMap = supplierList.stream().collect(Collectors.toMap(PurchaseEbiddingSupplier::getToElsAccount, PurchaseEbiddingSupplier::getSupplierName, (newVal, oldVal) -> oldVal));
        for (String toElsAccount : toElsAccountList) {
            PurchaseEbiddingMessageVO messageVO = new PurchaseEbiddingMessageVO();
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)messageVO));
            messageVO.setToElsAccount(toElsAccount);
            messageVO.setPurchaseCompanyName(SysUtil.getLoginUser().getEnterpriseName());
            messageVO.setSupplierName(supplierMap.get(toElsAccount));
        }
        super.sendMessage(TenantContext.getTenant(), "ebidding", "regret_" + regretFlag, headVO.getId(), "ebiddingBusDataServiceImpl", toElsAccountList);
        log.info("\u7ade\u4ef7\u6094\u6807\u53d1\u9001\u6d88\u606f\u5b8c\u6bd5");
    }

    private void sendMessage(PurchaseEbiddingHead dbHead, String operateType) {
        List<SaleEbiddingHead> saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
        Map<String, SaleEbiddingHead> supplierMap = saleHeadList.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity()));
        Map<String, JSONObject> receiveParamMap = this.getSaleReceiveParamMap(supplierMap);
        List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
        List toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
        super.sendMessage(TenantContext.getTenant(), "ebidding", operateType, dbHead.getId(), "ebiddingBusDataServiceImpl", toElsAccountList);
    }

    private Map<String, JSONObject> getSaleReceiveParamMap(Map<String, SaleEbiddingHead> supplierMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(supplierMap)) {
            supplierMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", (Object)value.getId());
                object.put("templateNumber", (Object)value.getTemplateNumber());
                object.put("templateVersion", (Object)value.getTemplateVersion());
                object.put("templateAccount", (Object)value.getTemplateAccount());
                object.put("busAccount", (Object)value.getBusAccount());
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    @Override
    public void failed(PurchaseEbiddingHead dbHead) {
        dbHead.setEbiddingStatus(EbiddingStatusEnum.BID_FAILED.getValue());
        this.updateById((Object)dbHead);
        this.saleEbiddingHeadService.failed(dbHead);
        EbiddingJobUtil.deleteAllJob(dbHead);
        dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)dbHead.getId())));
        log.info("\u7ade\u4ef7\u6d41\u6807\u5f00\u59cb\u53d1\u9001\u6d88\u606f");
        List<SaleEbiddingHead> saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
        Map idMap = saleHeadList.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity()));
        List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
        List toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
        Map<String, String> supplierMap = supplierList.stream().collect(Collectors.toMap(PurchaseEbiddingSupplier::getToElsAccount, PurchaseEbiddingSupplier::getSupplierName, (newVal, oldVal) -> oldVal));
        for (String toElsAccount : toElsAccountList) {
            PurchaseEbiddingMessageVO messageVO = new PurchaseEbiddingMessageVO();
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)messageVO));
            messageVO.setToElsAccount(toElsAccount);
            messageVO.setPurchaseCompanyName(SysUtil.getLoginUser().getEnterpriseName());
            messageVO.setSupplierName(supplierMap.get(toElsAccount));
        }
        super.sendMessage(TenantContext.getTenant(), "ebidding", "failureOfBid", dbHead.getId(), "ebiddingBusDataServiceImpl", toElsAccountList);
        log.info("\u7ade\u4ef7\u6d41\u6807\u53d1\u9001\u6d88\u606f\u5b8c\u6bd5");
    }

    private Map<String, Map<String, JSONObject>> getReceiveParamMap(List<SaleEbiddingHead> dbSaleHeadList) {
        HashMap<String, Map<String, JSONObject>> result = new HashMap<String, Map<String, JSONObject>>();
        for (SaleEbiddingHead saleHead : dbSaleHeadList) {
            HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
            JSONObject urlParam = new JSONObject();
            urlParam.put("id", (Object)saleHead.getId());
            urlParam.put("templateNumber", (Object)saleHead.getTemplateNumber());
            urlParam.put("templateVersion", (Object)saleHead.getTemplateVersion());
            urlParam.put("templateAccount", (Object)saleHead.getTemplateAccount());
            urlParam.put("busAccount", (Object)saleHead.getBusAccount());
            receiveParamMap.put(saleHead.getElsAccount(), urlParam);
            result.put(saleHead.getElsAccount(), receiveParamMap);
        }
        return result;
    }

    @Override
    public void pricingNotice(String headId, String pricingNotice) {
        PurchaseEbiddingHead updateHead = new PurchaseEbiddingHead();
        updateHead.setId(headId);
        updateHead.setPricingNotice(pricingNotice);
        this.updateById((Object)updateHead);
    }

    @Override
    public JSONObject getEbinddingDataById(String id) {
        PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        headVO.setPurchaseEbiddingItemList(dbItemList);
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    @Override
    public JSONArray getEbinddingDataById(List<String> idList) {
        JSONArray array = new JSONArray();
        for (String id : idList) {
            array.add((Object)this.getEbinddingDataById(id));
        }
        return array;
    }

    @Override
    public void executeReview(PurchaseQualificationReview review) {
        String headId = review.getRelationId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        Date applyEndTime = START_PRICE_FLAG.equals(dbHead.getNeedEcho()) ? dbHead.getEchoEndTime() : dbHead.getBeginTime();
        Assert.isTrue((boolean)applyEndTime.after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_UJKIIRWxqUJ_b9732d1b", (String)"\u5ba1\u67e5\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5ba1\u67e5"));
        if (QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            return;
        }
        this.executeReview(dbHead, review);
    }

    @Override
    public void executeReview(PurchaseEbiddingHead dbHead, PurchaseQualificationReview review) {
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId(), "item");
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        ArrayList supplierList = Lists.newArrayList();
        PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
        supplier.setToElsAccount(review.getToElsAccount());
        supplier.setSupplierCode(review.getSupplierCode());
        supplier.setSupplierName(review.getSupplierName());
        supplier.setNeedCoordination(review.getNeedCoordination());
        supplierList.add(supplier);
        List itemStatusList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemStatusEnum.NEW.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItem::getItemStatus).distinct().collect(Collectors.toList());
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(dbHead.getId());
        if (itemStatusList.contains(EbiddingStatusEnum.NEW.getValue())) {
            this.deleteSubTable(dbHead.getId());
        }
        ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId(), "confirm");
        List confirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmVO.class);
        dbHead.setEbiddingStatus(START_PRICE_FLAG.equals(dbHead.getNeedEcho()) ? EbiddingStatusEnum.WAIT_REPLY.getValue() : EbiddingStatusEnum.WAIT_BIDDING.getValue());
        this.updateById((Object)dbHead);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(review.getId());
        purchaseAttachmentList.forEach(attachment -> {
            attachment.setId(null);
            attachment.setHeadId(dbHead.getId());
            attachment.setBusinessType("ebidding");
        });
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        AttachmentSendDTO sendVO = this.publishEbidding(dbHead, initItemList, supplierList, demandList, confirmList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.EBIDDING.getValue(), dbHead.getEbiddingNumber(), supplier.getToElsAccount(), supplier.getSupplierName());
        this.saveSaleAttachment(purchaseAttachmentList, sendVO);
    }

    private void saveSaleAttachment(List<PurchaseAttachmentDTO> purchaseAttachmentList, AttachmentSendDTO sendVO) {
        ArrayList saleAttachmentDTOList = new ArrayList();
        String saleHeadId = sendVO.getToSend().keySet().stream().findFirst().map(Object::toString).orElse("");
        purchaseAttachmentList.forEach(e -> {
            SaleAttachmentDTO saleAttachmentDTO = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)e, (Object)saleAttachmentDTO);
            saleAttachmentDTO.setHeadId(saleHeadId);
            saleAttachmentDTO.setId(null);
            saleAttachmentDTO.setSendStatus(START_PRICE_FLAG);
            saleAttachmentDTOList.add(saleAttachmentDTO);
        });
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOList);
    }

    @Override
    public PurchaseEbiddingPrintVO printById(String id) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseEbiddingPrintVO printVO = new PurchaseEbiddingPrintVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)printVO));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        String ebiddingWay = dbHead.getEbiddingWay();
        String ebiddingType = dbHead.getEbiddingType();
        dbItemList = this.rankEbiddingItemData(dbItemList, ebiddingWay, ebiddingType);
        this.processFirstQuotePrice(id, dbHead, dbItemList);
        printVO.setPurchaseEbiddingItemList(dbItemList);
        List<PurchaseEbiddingSupplier> dbSupplierList = this.ebiddingSupplierService.selectByMainId(id);
        printVO.setPurchaseEbiddingSupplierList(dbSupplierList);
        List<PurchaseAwardOpinion> awardOpinionList = this.purchaseAwardOpinionService.selectByMainId(id);
        printVO.setPurchaseAwardOpinionList(awardOpinionList);
        if (CollectionUtil.isNotEmpty(awardOpinionList)) {
            PurchaseAwardOpinion awardOpinion = awardOpinionList.get(awardOpinionList.size() - 1);
            printVO.setPricingInstructions(awardOpinion.getAwardOpinion());
            printVO.setPricingPeople(awardOpinion.getCreateById());
        }
        if (!ObjectUtils.isEmpty((Object)printVO.getResultFlowId())) {
            List<A1FlowTaskTrajectoryDTO> a1FlowTaskTrajectoryEntityList = this.workflowAuditDataService.queryA1FlowTaskTrajectoryList(printVO.getResultFlowId());
            StringBuilder resultOpinion = new StringBuilder();
            StringBuilder resultOpinionPeople = new StringBuilder();
            int count = 1;
            for (A1FlowTaskTrajectoryDTO a1FlowTaskTrajectoryEntity : a1FlowTaskTrajectoryEntityList) {
                resultOpinion.append(count + "\u3001" + a1FlowTaskTrajectoryEntity.getOpinion() + "\uff1b");
                resultOpinionPeople.append(count + "\u3001" + a1FlowTaskTrajectoryEntity.getUserName() + "\uff1b");
                ++count;
            }
            printVO.setResultOpinion(resultOpinion.toString());
            printVO.setResultOpinionPeople(resultOpinionPeople.toString());
        }
        printVO.setPurchaseEbiddingConfirmList(this.purchaseEbiddingConfirmService.selectByMainId(id));
        printVO.setPurchaseAttachmentDemandList(this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id));
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        printVO.setPurchaseAttachmentList(attachmentList);
        printVO.setSupplierCounts(dbSupplierList.size());
        return printVO;
    }

    @Override
    public void checkEnquirySameMaterial(List<PurchaseEbiddingItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        for (int i = 0; i < itemList.size(); ++i) {
            if (!StringUtils.isBlank((CharSequence)itemList.get(i).getItemNumber())) continue;
            itemList.get(i).setItemNumber(String.valueOf(i + 1));
        }
        Map<String, List<PurchaseEbiddingItem>> groupMap = itemList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getMaterialNumber())).collect(Collectors.groupingBy(item -> {
            String materialNumber = StringUtils.isNotBlank((CharSequence)item.getMaterialNumber()) ? item.getMaterialNumber() : "";
            String factory = StringUtils.isNotBlank((CharSequence)item.getFactory()) ? item.getFactory() : "";
            String storageLocation = StringUtils.isNotBlank((CharSequence)item.getStorageLocation()) ? item.getStorageLocation() : "";
            return materialNumber + "_" + factory + "_" + storageLocation;
        }));
        groupMap.forEach((key, values) -> {
            if (values.size() > 1) {
                List itemNumber = values.stream().map(PurchaseEbiddingItem::getItemNumber).collect(Collectors.toList());
                String msg = "\u884c\u53f7\uff1a${0}\uff0c\u540c\u4e00\u4e2a\u7269\u6599\u540c\u5de5\u5382\u540c\u5e93\u5b58\u5730\u70b9\uff0c\u65e0\u6cd5\u540c\u65f6\u7ade\u4ef7\uff01";
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_Ey0eImSLeRHeGMnCSheKOu_d05d927b", (String)msg, (String[])new String[]{"{" + StringUtils.join(itemNumber, (String)"}\u3001{") + "}"}));
            }
        });
    }

    private void processFirstQuotePrice(String headId, PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> dbItemList) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)headId);
        wrapper.eq((Object)"quote_count", (Object)1);
        List itemHisList = this.purchaseEbiddingItemHisService.list((Wrapper)wrapper);
        if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
            Map<String, List<PurchaseEbiddingItemHis>> toElsAccountMap = itemHisList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount()));
            for (PurchaseEbiddingItem deItem : dbItemList) {
                List<PurchaseEbiddingItemHis> hisList = toElsAccountMap.get(deItem.getToElsAccount());
                if (hisList == null || hisList.size() <= 0) continue;
                PurchaseEbiddingItemHis his = hisList.get(0);
                deItem.setFirstQuotePrice(his.getNetTotalAmount());
            }
        } else {
            Map<String, List<PurchaseEbiddingItemHis>> toElsAccountMap = itemHisList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + ":" + o.getMaterialDesc()));
            for (PurchaseEbiddingItem deItem : dbItemList) {
                List<PurchaseEbiddingItemHis> hisList = toElsAccountMap.get(deItem.getToElsAccount() + ":" + deItem.getMaterialDesc());
                if (hisList == null || hisList.size() <= 0) continue;
                PurchaseEbiddingItemHis his = hisList.get(0);
                deItem.setFirstQuotePrice(his.getNetPrice());
            }
        }
    }

    private List<PurchaseEbiddingItem> rankEbiddingItemData(List<PurchaseEbiddingItem> dbItemList, String ebiddingWay, String ebiddingType) {
        if (EbiddingWayEnum.PACKAGE.getValue().equals(ebiddingWay)) {
            String itemNumber = START_PRICE_FLAG;
            List items = dbItemList.stream().filter(item -> item.getItemNumber().equals(itemNumber)).collect(Collectors.toList());
            List<PurchaseEbiddingItem> filterList = dbItemList.stream().filter(item -> item.getMaterialDesc().equals(((PurchaseEbiddingItem)((Object)((Object)items.get(0)))).getMaterialDesc())).collect(Collectors.toList());
            this.rank(filterList, ebiddingWay, ebiddingType);
            Map<String, List<PurchaseEbiddingItem>> filterSortMap = filterList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + "-" + o.getFactory()));
            Map<String, List<PurchaseEbiddingItem>> deItemMap = dbItemList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + "-" + o.getFactory()));
            for (Map.Entry<String, List<PurchaseEbiddingItem>> entry : deItemMap.entrySet()) {
                List<PurchaseEbiddingItem> filterMapItemList = filterSortMap.get(entry.getKey());
                if (filterMapItemList == null || filterMapItemList.size() <= 0) continue;
                for (PurchaseEbiddingItem dbMapItem : entry.getValue()) {
                    dbMapItem.setQuoteRank(filterMapItemList.get(0).getQuoteRank());
                }
            }
            for (PurchaseEbiddingItem deItem : dbItemList) {
                List<PurchaseEbiddingItem> sortList = filterSortMap.get(deItem.getToElsAccount() + "-" + deItem.getItemNumber());
                if (sortList == null || sortList.size() <= 0) continue;
                PurchaseEbiddingItem sortItem = sortList.get(0);
                deItem.setQuoteRank(sortItem.getQuoteRank());
            }
            dbItemList.sort(Comparator.comparing(PurchaseEbiddingItem::getQuoteRank, Comparator.nullsLast(Integer::compareTo)).thenComparing(PurchaseEbiddingItem::getItemNumber));
        } else {
            ArrayList<PurchaseEbiddingItem> sortItemList = new ArrayList<PurchaseEbiddingItem>();
            Map<String, List<PurchaseEbiddingItem>> itemNumberMap = dbItemList.stream().collect(Collectors.groupingBy(o -> o.getMaterialDesc()));
            for (Map.Entry<String, List<PurchaseEbiddingItem>> entry : itemNumberMap.entrySet()) {
                List<PurchaseEbiddingItem> itemList = entry.getValue();
                if (itemList == null || itemList.size() <= 0) continue;
                this.rank(itemList, ebiddingWay, ebiddingType);
                sortItemList.addAll(itemList);
            }
            Boolean flag = true;
            for (PurchaseEbiddingItem purchaseEbiddingItem : sortItemList) {
                if (!ObjectUtils.isEmpty((Object)purchaseEbiddingItem.getQuoteRank())) continue;
                flag = false;
                break;
            }
            if (flag.booleanValue()) {
                sortItemList.sort(Comparator.comparing(PurchaseEbiddingItem::getMaterialDesc, Comparator.nullsLast(String::compareTo)).thenComparing(PurchaseEbiddingItem::getQuoteRank));
            } else {
                sortItemList.sort(Comparator.comparing(PurchaseEbiddingItem::getMaterialDesc, Comparator.nullsLast(String::compareTo)));
            }
            dbItemList = sortItemList;
        }
        return dbItemList;
    }

    private void rank(List<PurchaseEbiddingItem> itemList, String ebiddingWay, String ebiddingType) {
        List<PurchaseEbiddingItem> sortList = EbiddingTypeEnum.getEnumByValue(ebiddingType).sort(ebiddingWay, itemList);
        block0: for (int i = 0; i < sortList.size(); ++i) {
            for (PurchaseEbiddingItem purchaseEbiddingItem : itemList) {
                if (!purchaseEbiddingItem.getId().equals(sortList.get(i).getId())) continue;
                int rank = i + 1;
                purchaseEbiddingItem.setQuoteRank(rank);
                continue block0;
            }
        }
        Map<String, List<PurchaseEbiddingItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + "-" + o.getMaterialDesc()));
        for (Map.Entry entry : itemMap.entrySet()) {
            List itemSortList = (List)entry.getValue();
            if (itemSortList == null || itemSortList.size() <= 1) continue;
            itemSortList.sort(Comparator.comparing(PurchaseEbiddingItem::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
            for (int i = 1; i < itemSortList.size(); ++i) {
                PurchaseEbiddingItem firstItem = (PurchaseEbiddingItem)((Object)itemSortList.get(i - 1));
                PurchaseEbiddingItem secondItem = (PurchaseEbiddingItem)((Object)itemSortList.get(i));
                if (EbiddingWayEnum.SINGLE.getValue().equals(ebiddingWay)) {
                    if (firstItem.getPrice() == null || secondItem.getPrice() == null || firstItem.getPrice().compareTo(secondItem.getPrice()) != 0 || !firstItem.getQuoteTime().equals(secondItem.getQuoteTime())) continue;
                    secondItem.setQuoteRank(firstItem.getQuoteRank());
                    continue;
                }
                if (firstItem.getTotalAmount() == null || secondItem.getTotalAmount() == null || firstItem.getTotalAmount().compareTo(secondItem.getTotalAmount()) != 0 || !firstItem.getQuoteTime().equals(secondItem.getQuoteTime())) continue;
                secondItem.setQuoteRank(firstItem.getQuoteRank());
            }
        }
        itemList.sort(Comparator.comparing(PurchaseEbiddingItem::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
    }

    private void checkMaterialNumber(List<PurchaseEbiddingItem> itemList) {
        List<String> materialNumbers = itemList.stream().map(PurchaseEbiddingItem::getMaterialNumber).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(materialNumbers)) {
            Map<String, String> materialItemNumberMap = itemList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getMaterialNumber())).collect(Collectors.toMap(PurchaseEbiddingItem::getMaterialNumber, PurchaseEbiddingItem::getItemNumber, (v1, v2) -> v1));
            List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOS = this.purchaseMaterialHeadService.listByMaterialNumbers(materialNumbers);
            List blocDelMaterial = purchaseMaterialHeadDTOS.stream().filter(material -> START_PRICE_FLAG.equals(material.getBlocDel())).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtils.isEmpty(blocDelMaterial), (String)I18nUtil.translate((String)"", (String)("\u7269\u6599\u7f16\u7801:" + blocDelMaterial.stream().map(p -> p.getMaterialNumber() + "\u3010" + (String)materialItemNumberMap.get(p.getMaterialNumber()) + "\u3011\u884c").collect(Collectors.joining(",")) + "\u7269\u6599\u5df2\u88ab\u5220\u9664")));
        }
    }
}

