/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.mapper.SaleEbiddingItemMapper;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.vo.SaleEbiddingHeadVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleEbiddingItemServiceImpl
extends ServiceImpl<SaleEbiddingItemMapper, SaleEbiddingItem>
implements SaleEbiddingItemService {
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;

    @Override
    public List<SaleEbiddingItem> selectByMainId(String mainId) {
        return ((SaleEbiddingItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void publish(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, Map<String, String> idMap) {
        ArrayList<SaleEbiddingItem> insertList = new ArrayList<SaleEbiddingItem>();
        LoginUser user = SysUtil.getLoginUser();
        for (PurchaseEbiddingItem item : itemList) {
            SaleEbiddingItem insertItem = new SaleEbiddingItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)insertItem));
            insertItem.setId(item.getRelationId());
            insertItem.setElsAccount(item.getToElsAccount());
            insertItem.setRelationId(item.getId());
            insertItem.setHeadId(idMap.get(item.getToElsAccount()));
            insertItem.setToElsAccount(item.getElsAccount());
            insertItem.setPurchaseName(user.getEnterpriseName());
            insertItem.setTargetPrice("1".equals(head.getSendTargetPrice()) ? item.getTargetPrice() : null);
            insertItem.setStartPrice("1".equals(head.getSetStartPrice()) ? item.getStartPrice() : null);
            insertList.add(insertItem);
        }
        this.saveBatch(insertList, 2000);
    }

    @Override
    public void acceptResponse(SaleEbiddingHeadVO saleHeadVO) {
        List<SaleEbiddingItem> itemList = saleHeadVO.getSaleEbiddingItemList();
        ArrayList<PurchaseEbiddingItem> updatePurchaseList = new ArrayList<PurchaseEbiddingItem>();
        for (SaleEbiddingItem item : itemList) {
            PurchaseEbiddingItem purchaseItem = new PurchaseEbiddingItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)purchaseItem));
            purchaseItem.setId(item.getRelationId());
            purchaseItem.setElsAccount(item.getToElsAccount());
            purchaseItem.setRelationId(item.getId());
            purchaseItem.setHeadId(saleHeadVO.getRelationId());
            purchaseItem.setToElsAccount(item.getElsAccount());
            updatePurchaseList.add(purchaseItem);
        }
        this.updateBatchById(itemList);
        this.purchaseEbiddingItemService.updateBatchById(updatePurchaseList);
    }

    @Override
    public void replenishMaterialNumber(List<PurchaseEbiddingItem> itemList) {
        ArrayList<SaleEbiddingItem> updateList = new ArrayList<SaleEbiddingItem>();
        for (PurchaseEbiddingItem item : itemList) {
            SaleEbiddingItem update = new SaleEbiddingItem();
            update.setId(item.getRelationId());
            update.setMaterialNumber(item.getMaterialNumber());
            update.setMaterialDesc(item.getMaterialDesc());
            update.setMaterialGroup(item.getMaterialGroup());
            update.setMaterialSpec(item.getMaterialSpec());
            update.setMaterialGroupName(item.getMaterialGroupName());
            updateList.add(update);
        }
        this.updateBatchById(updateList);
    }

    @Override
    public SaleEbiddingItem selectOneByMainIdAndItemNumber(String headId, String nextItemNumber) {
        return ((SaleEbiddingItemMapper)this.baseMapper).selectOneByMainIdAndItemNumber(headId, nextItemNumber);
    }

    @Override
    public List<SaleEbiddingItem> selectWithoutElsAccountByHeadId(List<String> saleHeadIdList) {
        return ((SaleEbiddingItemMapper)this.baseMapper).selectWithoutElsAccountByHeadId(saleHeadIdList);
    }
}

