/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enquiry.entity.EnquirySubstituteHead;
import com.els.modules.enquiry.entity.EnquirySubstituteItem;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.EnquirySubstituteHeadService;
import com.els.modules.enquiry.service.EnquirySubstituteItemService;
import com.els.modules.enquiry.vo.SaleEnquiryHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/enquiry/enquirySubstituteHead"})
@Api(tags={"\u8be2\u4ef7\u4ee3\u62a5\u4ef7\u5934"})
public class EnquirySubstituteHeadController
extends BaseController<EnquirySubstituteHead, EnquirySubstituteHeadService> {
    private static final Logger log = LoggerFactory.getLogger(EnquirySubstituteHeadController.class);
    @Autowired
    private EnquirySubstituteItemService enquirySubstituteItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="enquirySubstituteHead")
    @RequiresPermissions(value={"enquiry#enquirySubstituteHead:list"})
    public Result<?> queryPageList(EnquirySubstituteHead enquirySubstituteHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)enquirySubstituteHead), (Map)req.getParameterMap());
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(SaleEnquiryHead::getToElsAccount, (Object)this.getTenantId())).ne(SaleEnquiryHead::getEnquiryStatus, (Object)EnquiryStatusEnum.CANCEL.getValue());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((EnquirySubstituteHeadService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"enquiry#enquirySubstituteHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        EnquirySubstituteHead dbHead = (EnquirySubstituteHead)((Object)((EnquirySubstituteHeadService)this.service).getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"to_els_account", (Object)TenantContext.getTenant())));
        SaleEnquiryHeadVO headVO = new SaleEnquiryHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<EnquirySubstituteItem> substituteItemList = this.enquirySubstituteItemService.selectByMainId(id);
        ArrayList<SaleEnquiryItem> itemList = new ArrayList<SaleEnquiryItem>(substituteItemList);
        headVO.setSaleEnquiryItemList(itemList);
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        headVO.setSaleAttachmentList(saleAttachmentList);
        List demandList = this.invokeBaseRpcService.selectSaleAttachmentDemandByMainId(id);
        headVO.setSaleAttachmentDemandList(demandList);
        return Result.ok((Object)((Object)headVO));
    }
}

