/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.excel.poi.excel.entity.vo.ExcelTemplateHeadVO;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.inquiry.enumerate.QuoteTypeEnum;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="saleEnquiryItemExcelServiceImpl")
public class SaleEnquiryItemExcelServiceImpl
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(SaleEnquiryItemExcelServiceImpl.class);
    @Autowired
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    private String headId;

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
            templateAccount = StringUtils.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
            templateVersion = String.valueOf(dbHead.getTemplateVersion());
            templateNumber = String.valueOf(dbHead.getTemplateNumber());
        }
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<SaleEnquiryItem> itemList = this.saleEnquiryItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return new ArrayList<SaleEnquiryItem>(itemList);
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList oldList = new ArrayList();
        for (Map data : dataList) {
            oldList.add(new HashMap(data));
            if (data.get("quotePrice") == null || !"0".equals(data.get("quotePrice").toString())) continue;
            for (Map.Entry entry : data.entrySet()) {
                String key = (String)entry.getKey();
                if ("itemNumber".equals(key) || "quotePrice".equals(key)) continue;
                data.put(entry.getKey(), null);
            }
        }
        List quotePriceList = null;
        Map costPriceMap = null;
        if (((Map)dataList.get(dataList.size() - 1)).get("otherSheetList") != null) {
            quotePriceList = (List)((Map)dataList.get(dataList.size() - 1)).get("otherSheetList");
            dataList.remove(dataList.size() - 1);
            oldList.remove(oldList.size() - 1);
            if (((Map)quotePriceList.get(quotePriceList.size() - 1)).get("costPrice") != null) {
                costPriceMap = (Map)((Map)quotePriceList.get(quotePriceList.size() - 1)).get("costPrice");
                quotePriceList.remove(quotePriceList.size() - 1);
            }
        }
        SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)this.headId)));
        List<SaleEnquiryItem> dbItemList = this.saleEnquiryItemService.selectByMainId(this.headId);
        List<String> excludeColumn = Arrays.asList("price", "netPrice", "taxCode", "taxRate");
        TemplateHeadDTO template = this.getTemplate(excelImportDTO.getExcelByConfigDTO());
        Map editColumnMap = template.getTemplateConfigItemList().stream().filter(item -> !excludeColumn.contains(item.getFieldName())).collect(Collectors.toMap(TemplateConfigItemDTO::getFieldName, Function.identity(), (v1, v2) -> v2));
        List editColumn = template.getTemplateConfigItemList().stream().filter(item -> "1".equals(item.getSaleEdit())).map(TemplateConfigItemDTO::getFieldName).filter(s -> !excludeColumn.contains(s)).collect(Collectors.toList());
        if ("1".equals(dbHead.getSupplierTaxRate())) {
            editColumn.add("taxCode");
        }
        if (QuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType())) {
            editColumn.add("netPrice");
        } else {
            editColumn.add("price");
        }
        Map taxMap = this.invokeBaseRpcService.getAllTax(dbHead.getToElsAccount());
        Iterator iterator = dataList.iterator();
        Iterator oldIterator = oldList.iterator();
        while (iterator.hasNext()) {
            String taxCode;
            List list;
            Map data = (Map)iterator.next();
            Map errorData = (Map)oldIterator.next();
            boolean flag = this.checkDisableConfigItemData(excelImportDTO, iterator, editColumnMap, editColumn, errorData);
            if (!flag || CollectionUtil.isEmpty(list = dbItemList.stream().filter(s -> s.getItemNumber().equals(data.get("itemNumber"))).collect(Collectors.toList()))) continue;
            SaleEnquiryItem dbItem = (SaleEnquiryItem)((Object)list.get(0));
            BigDecimal taxRate = BigDecimal.ONE;
            if (dbItem != null && !StringUtils.isEmpty((CharSequence)dbItem.getTaxRate())) {
                taxRate = new BigDecimal(dbItem.getTaxRate());
            }
            Integer requireQuantity = dbItem.getRequireQuantity() != null ? dbItem.getRequireQuantity().intValue() : 1;
            for (Map.Entry entry : data.entrySet()) {
                if (!editColumn.contains(entry.getKey()) && !"itemNumber".equals(entry.getKey())) {
                    data.put(entry.getKey(), null);
                    continue;
                }
                data.put(entry.getKey(), entry.getValue());
            }
            if (!EnquiryQuoteWayEnum.NORMAL.getValue().equals(dbItem.getQuotePriceWay())) {
                data.put("price", null);
                data.put("netPrice", null);
            }
            if (StringUtils.isNotBlank((CharSequence)(taxCode = (String)data.get("taxCode")))) {
                if (!taxMap.containsKey(taxCode)) {
                    String msg = I18nUtil.translate((String)"i18n_alert_foWWWWWWWxMK_e919daf8", (String)"\u7a0e\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{taxCode});
                    this.errorAdd(excelImportDTO, msg, errorData);
                    iterator.remove();
                    continue;
                }
                data.put("taxRate", taxMap.get(taxCode));
            }
            if (EnquiryQuoteWayEnum.LADDER.getValue().equals(dbItem.getQuotePriceWay()) && quotePriceList != null) {
                List<Map> newQuotePriceList = quotePriceList.stream().filter(info -> dbItem.getItemNumber().equals(info.get("itemNumber"))).collect(Collectors.toList());
                BigDecimal finalTaxRate = taxRate;
                List<Object> quantityList = new ArrayList<Integer>();
                newQuotePriceList.forEach(info -> {
                    if (QuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) && info.get("netPrice") != null) {
                        BigDecimal temp = finalTaxRate.divide(new BigDecimal("100")).add(BigDecimal.ONE);
                        BigDecimal result = new BigDecimal(info.get("netPrice") + "").multiply(temp);
                        result = result.setScale(6, 4);
                        info.put("price", result);
                    } else if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType()) && info.get("price") != null) {
                        BigDecimal temp = finalTaxRate.divide(new BigDecimal("100")).add(BigDecimal.ONE);
                        BigDecimal result = new BigDecimal(info.get("price") + "").divide(temp, 6, 4);
                        result = result.setScale(6, 4);
                        info.put("netPrice", result);
                    }
                });
                for (Map map : newQuotePriceList) {
                    quantityList.add(Integer.valueOf((String)map.get("ladderQuantity")));
                }
                data.put("ladderPriceJson", JSONArray.toJSONString(newQuotePriceList));
                quantityList.add(requireQuantity);
                quantityList = quantityList.stream().sorted().collect(Collectors.toList());
                ArrayList<Integer> indexs = new ArrayList<Integer>();
                for (int i = 0; i < quantityList.size(); ++i) {
                    if (quantityList.get(i) != requireQuantity) continue;
                    indexs.add(i);
                }
                int index = 0;
                if (indexs.size() == 1) {
                    index = (Integer)indexs.get(0) - 1;
                } else if (indexs.size() > 1) {
                    index = (Integer)indexs.get(0);
                }
                Map newQuotePrice = (Map)newQuotePriceList.get(index);
                data.put("price", newQuotePrice.get("price"));
                data.put("netPrice", newQuotePrice.get("netPrice"));
                Float netAmount = Float.valueOf(0.0f);
                Float taxAmount = Float.valueOf(0.0f);
                if (newQuotePrice.containsKey("netPrice") && ObjectUtil.isNotEmpty(newQuotePrice.get("netPrice"))) {
                    netAmount = Float.valueOf(Float.valueOf(((Map)newQuotePriceList.get(0)).get("netPrice") + "").floatValue() * (float)requireQuantity.intValue());
                }
                if (newQuotePrice.containsKey("price") && ObjectUtil.isNotEmpty(newQuotePrice.get("price"))) {
                    taxAmount = Float.valueOf(Float.valueOf(((Map)newQuotePriceList.get(0)).get("price") + "").floatValue() * (float)requireQuantity.intValue());
                }
                data.put("netAmount", String.format("%.6f", netAmount));
                data.put("taxAmount", String.format("%.6f", taxAmount));
                continue;
            }
            if (!EnquiryQuoteWayEnum.COST.getValue().equals(dbItem.getQuotePriceWay()) || quotePriceList == null) continue;
            List costList = (List)costPriceMap.get(dbItem.getMaterialNumber());
            Map<Object, List<Map>> groupList = costList.stream().collect(Collectors.groupingBy(a -> a.get("groupName")));
            JSONObject costJson = JSONObject.parseObject((String)dbItem.getCostFormJson());
            HashMap<Object, Object> newCostJson = new HashMap<Object, Object>();
            for (Map.Entry<Object, List<Map>> map : groupList.entrySet()) {
                if (map.getValue().size() == 1) {
                    newCostJson.put(map.getKey(), map.getValue().get(0));
                    continue;
                }
                newCostJson.put(map.getKey(), map.getValue());
            }
            ArrayList newCostGroupJsonList = new ArrayList();
            String templateNumber = costJson.getString("templateNumber");
            String templateAccount = costJson.getString("templateAccount");
            TenantContext.setTenant((String)templateAccount);
            List templateHeadDTOS = this.invokeBaseRpcService.getTemplateByType("costForm");
            TemplateHeadDTO templateHeadDTO = templateHeadDTOS.stream().filter(templateHead -> templateNumber.equals(templateHead.getTemplateNumber())).findFirst().get();
            ExcelTemplateHeadVO excelTemplateHeadVO = this.invokeBaseRpcService.selectVoById(templateHeadDTO.getId());
            TenantContext.setTenant((String)SysUtil.getLoginUser().getElsAccount());
            BigDecimal totalPrice = BigDecimal.ZERO;
            BigDecimal totalNetPrice = BigDecimal.ZERO;
            data.put("price", totalPrice.toString());
            data.put("netPrice", totalNetPrice.toString());
            data.put("taxAmount", dbItem.getRequireQuantity().multiply(totalPrice).setScale(6, 4).toString());
            data.put("netAmount", dbItem.getRequireQuantity().multiply(totalNetPrice).setScale(6, 4).toString());
            String newDataJsonStr = JSONObject.toJSONString(newCostJson);
            costJson.put("data", JSONObject.parse((String)newDataJsonStr));
            costJson.put("groups", newCostGroupJsonList);
            data.put("costFormJson", JSONObject.toJSONString((Object)costJson));
        }
        this.errorHandle(true, excelImportDTO, SysUtil.getLoginUser().getElsAccount(), totalCount);
        return dataList;
    }
}

