/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.PurchaseEnquiryItemHis;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItemHis;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.mapper.PurchaseEnquiryItemHisMapper;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemHisService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.impl.PurchaseEnquiryItemServiceImpl;
import com.els.modules.enquiry.vo.CurrentQuoteTrendVO;
import com.els.modules.enquiry.vo.EnquiryItemPriceVO;
import com.els.modules.enquiry.vo.SupplierEnquiryItemAmountVO;
import com.els.modules.enquiry.vo.SupplierEnquiryItemPriceVO;
import com.els.modules.enquiry.vo.SupplierEnquiryItemQuantityVO;
import com.els.modules.exchange.rpc.dto.BpExchangeRateDTO;
import com.els.modules.inquiry.enumerate.QuoteTypeEnum;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialUnitNewDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseEnquiryItemHisServiceImpl
extends ServiceImpl<PurchaseEnquiryItemHisMapper, PurchaseEnquiryItemHis>
implements PurchaseEnquiryItemHisService {
    @Autowired
    private DictAspect dictAspect;
    private String priceType = "price";
    private BigDecimal ladderQuantity = BigDecimal.ONE;
    private String costGroup;
    @Autowired
    private InquiryInvokeMainDataRpcService mainDataRpcService;
    private Map<String, Function<List<PurchaseEnquiryItemHis>, CurrentQuoteTrendVO>> functionMap = new HashMap<String, Function<List<PurchaseEnquiryItemHis>, CurrentQuoteTrendVO>>();

    @PostConstruct
    public void init() {
        this.functionMap.put(EnquiryQuoteWayEnum.NORMAL.getValue(), this::getNormalQuoteHis);
        this.functionMap.put(EnquiryQuoteWayEnum.LADDER.getValue(), this::getLadderQuoteHis);
        this.functionMap.put(EnquiryQuoteWayEnum.COST.getValue(), this::getCostQuoteHis);
    }

    @Override
    public void saveQuoteItemHis(SaleEnquiryHead saleHead, Map<String, String> purchaseItemIdMap, List<SaleEnquiryItemHis> insertSaleList) {
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(PurchaseEnquiryItemHis::getLastQuote, (Object)"0")).in(PurchaseEnquiryItemHis::getItemId, purchaseItemIdMap.values()));
        ArrayList<PurchaseEnquiryItemHis> purchaseItemHisList = new ArrayList<PurchaseEnquiryItemHis>();
        for (SaleEnquiryItemHis saleHis : insertSaleList) {
            PurchaseEnquiryItemHis purchaseHis = new PurchaseEnquiryItemHis();
            BeanUtils.copyProperties((Object)((Object)saleHis), (Object)((Object)purchaseHis));
            purchaseHis.setId(saleHis.getRelationId());
            purchaseHis.setElsAccount(saleHis.getToElsAccount());
            purchaseHis.setRelationId(saleHis.getId());
            purchaseHis.setHeadId(saleHead.getRelationId());
            purchaseHis.setItemId(purchaseItemIdMap.get(saleHis.getItemId()));
            purchaseHis.setToElsAccount(saleHis.getElsAccount());
            purchaseItemHisList.add(purchaseHis);
        }
        this.saveBatch(purchaseItemHisList, 20000);
    }

    @Override
    public void replenishMaterialNumber(List<PurchaseEnquiryItem> items) {
        for (PurchaseEnquiryItem item : items) {
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEnquiryItemHis::getItemId, (Object)item.getId())).set(PurchaseEnquiryItemHis::getMaterialNumber, (Object)item.getMaterialNumber())).set(PurchaseEnquiryItemHis::getMaterialName, (Object)item.getMaterialName())).set(PurchaseEnquiryItemHis::getMaterialDesc, (Object)item.getMaterialDesc())).set(PurchaseEnquiryItemHis::getMaterialGroup, (Object)item.getMaterialGroup())).set(PurchaseEnquiryItemHis::getMaterialGroupName, (Object)item.getMaterialGroupName())).set(PurchaseEnquiryItemHis::getMaterialSpec, (Object)item.getMaterialSpec()));
        }
    }

    @Override
    public CurrentQuoteTrendVO findQuoteHis(HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String itemNumber = request.getParameter("itemNumber");
        this.priceType = request.getParameter("priceType");
        this.ladderQuantity = StrUtil.isBlank((CharSequence)request.getParameter("ladderQuantity")) ? null : new BigDecimal(request.getParameter("ladderQuantity"));
        this.costGroup = request.getParameter("costGroup");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItemHis::getHeadId, (Object)headId);
        if (StrUtil.isNotBlank((CharSequence)itemNumber)) {
            queryWrapper.eq(PurchaseEnquiryItemHis::getItemNumber, (Object)itemNumber);
        }
        queryWrapper.orderByAsc(PurchaseEnquiryItemHis::getQuoteCount);
        List list = ((PurchaseEnquiryItemHisMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        this.hidePrice(list);
        return list.isEmpty() ? new CurrentQuoteTrendVO() : this.functionMap.get(((PurchaseEnquiryItemHis)((Object)list.get(0))).getQuotePriceWay()).apply(list);
    }

    private void hidePrice(List<PurchaseEnquiryItemHis> list) {
        if (CollectionUtil.isNotEmpty(list)) {
            boolean showPrice;
            PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)SpringContextUtils.getBean(PurchaseEnquiryHeadService.class)).getById((Serializable)((Object)list.get(0).getHeadId())));
            boolean bl = showPrice = !"0".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || dbHead.getQuoteEndTime().before(new Date());
            if (!showPrice) {
                for (PurchaseEnquiryItemHis item : list) {
                    Object object2;
                    item.setPrice(null);
                    item.setNetPrice(null);
                    item.setTaxAmount(null);
                    item.setNetAmount(null);
                    if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())) {
                        JSONArray ladderPriceJson = StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson()) ? JSONArray.parseArray((String)item.getLadderPriceJson()) : new JSONArray();
                        for (Object object2 : ladderPriceJson) {
                            JSONObject ladderItem = (JSONObject)object2;
                            ladderItem.put("netPrice", null);
                            ladderItem.put("price", null);
                            ladderItem.put("taxAmount", null);
                            ladderItem.put("netAmount", null);
                        }
                        item.setLadderPriceJson(ladderPriceJson.toJSONString());
                    }
                    if (!EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())) continue;
                    JSONObject costFormJson = StrUtil.isNotBlank((CharSequence)item.getCostFormJson()) ? JSONObject.parseObject((String)item.getCostFormJson()) : new JSONObject();
                    JSONObject data = costFormJson.getJSONObject("data") == null ? new JSONObject() : costFormJson.getJSONObject("data");
                    object2 = data.keySet().iterator();
                    while (object2.hasNext()) {
                        String key = (String)object2.next();
                        data.put(key, (Object)new JSONArray());
                    }
                    JSONArray groups = costFormJson.getJSONArray("groups") == null ? new JSONArray() : costFormJson.getJSONArray("groups");
                    for (Object object3 : groups) {
                        JSONObject group = (JSONObject)object3;
                        group.put("totalValue", null);
                    }
                    item.setCostFormJson(costFormJson.toJSONString());
                }
            }
        }
    }

    private CurrentQuoteTrendVO getTrend(List<PurchaseEnquiryItemHis> dataList) {
        CurrentQuoteTrendVO trendVO = new CurrentQuoteTrendVO();
        List<String> legendData = dataList.stream().map(PurchaseEnquiryItemHis::getSupplierName).distinct().collect(Collectors.toList());
        trendVO.setLegendData(legendData);
        List<Integer> xAxisData = dataList.stream().map(PurchaseEnquiryItemHis::getQuoteCount).distinct().collect(Collectors.toList());
        trendVO.setXAxisData(xAxisData);
        return trendVO;
    }

    private CurrentQuoteTrendVO getNormalQuoteHis(List<PurchaseEnquiryItemHis> dataList) {
        CurrentQuoteTrendVO trendVO = this.getTrend(dataList);
        Map<String, List<PurchaseEnquiryItemHis>> itemMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getSupplierName));
        JSONArray array = new JSONArray();
        for (String supplierName : itemMap.keySet()) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)supplierName);
            object.put("type", (Object)"bar");
            List<PurchaseEnquiryItemHis> itemList = itemMap.get(supplierName);
            List priceList = "netPrice".equals(this.priceType) ? itemList.stream().map(PurchaseEnquiryItemHis::getNetPrice).collect(Collectors.toList()) : itemList.stream().map(PurchaseEnquiryItemHis::getPrice).collect(Collectors.toList());
            object.put("data", priceList);
            array.add((Object)object);
        }
        trendVO.setSeries(array);
        return trendVO;
    }

    private CurrentQuoteTrendVO getLadderQuoteHis(List<PurchaseEnquiryItemHis> dataList) {
        Assert.notNull((Object)this.ladderQuantity, (String)I18nUtil.translate((String)"i18n_alert_yDWRxOLV_cff2a168", (String)"\u9636\u68af\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
        CurrentQuoteTrendVO trendVO = this.getTrend(dataList);
        Map<String, List<PurchaseEnquiryItemHis>> itemMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getSupplierName));
        JSONArray array = new JSONArray();
        for (String supplierName : itemMap.keySet()) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)supplierName);
            object.put("type", (Object)"bar");
            List<PurchaseEnquiryItemHis> itemList = itemMap.get(supplierName);
            ArrayList<BigDecimal> priceList = new ArrayList<BigDecimal>();
            for (PurchaseEnquiryItemHis item : itemList) {
                BigDecimal price = null;
                if (StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson())) {
                    JSONArray ladderArray = JSONArray.parseArray((String)item.getLadderPriceJson());
                    for (Object ladderObject : ladderArray) {
                        JSONObject ladder = (JSONObject)ladderObject;
                        BigDecimal ladderQuantity = ladder.getBigDecimal("ladderQuantity");
                        if (this.ladderQuantity.compareTo(ladderQuantity) < 0) continue;
                        price = "netPrice".equals(this.priceType) ? ladder.getBigDecimal("netPrice") : ladder.getBigDecimal("price");
                    }
                }
                priceList.add(price);
            }
            object.put("data", priceList);
            array.add((Object)object);
        }
        trendVO.setSeries(array);
        return trendVO;
    }

    private CurrentQuoteTrendVO getCostQuoteHis(List<PurchaseEnquiryItemHis> dataList) {
        Assert.hasText((String)this.costGroup, (String)I18nUtil.translate((String)"i18n_alert_LvdxOLV_956826d", (String)"\u6210\u672c\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
        CurrentQuoteTrendVO trendVO = this.getTrend(dataList);
        Map<String, List<PurchaseEnquiryItemHis>> itemMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getSupplierName));
        JSONArray array = new JSONArray();
        for (String supplierName : itemMap.keySet()) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)supplierName);
            object.put("type", (Object)"bar");
            List<PurchaseEnquiryItemHis> itemList = itemMap.get(supplierName);
            ArrayList<BigDecimal> priceList = new ArrayList<BigDecimal>();
            for (PurchaseEnquiryItemHis item : itemList) {
                BigDecimal price = null;
                if (StrUtil.isNotBlank((CharSequence)item.getCostFormJson())) {
                    JSONObject costObject = JSONObject.parseObject((String)item.getCostFormJson());
                    JSONArray groups = costObject.getJSONArray("groups") == null ? new JSONArray() : costObject.getJSONArray("groups");
                    for (Object groupObject : groups) {
                        JSONObject group = (JSONObject)groupObject;
                        if (!this.costGroup.equals(group.getString("groupCode"))) continue;
                        price = group.getBigDecimal("totalValue");
                    }
                }
                priceList.add(price);
            }
            object.put("data", priceList);
            array.add((Object)object);
        }
        trendVO.setSeries(array);
        return trendVO;
    }

    @Override
    public JSONObject queryCompare(PurchaseEnquiryHead dbHead, List<String> compareList, List<String> toElsAccountList) {
        JSONObject result = new JSONObject();
        List dbList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseEnquiryItemHis::getHeadId, (Object)dbHead.getId())).in(CollectionUtil.isNotEmpty(toElsAccountList), PurchaseEnquiryItemHis::getToElsAccount, toElsAccountList));
        Map<String, List<PurchaseEnquiryItemHis>> groupItem = dbList.stream().collect(Collectors.groupingBy(item -> item.getMaterialNumber() + "_" + item.getQuoteCount()));
        dbList.clear();
        for (Map.Entry<String, List<PurchaseEnquiryItemHis>> entry : groupItem.entrySet()) {
            this.initCompareMsg(dbHead, entry.getValue());
            dbList.addAll((Collection)entry.getValue());
        }
        Result dbResult = Result.ok((Object)dbList);
        this.dictAspect.parseDictText((Object)dbResult);
        List dataList = (List)dbResult.getResult();
        this.compareNormal(dataList, result);
        this.compareLadder(dataList, result);
        this.compareCost(dataList, result);
        this.compareSupplier(dataList, result);
        return result;
    }

    @Override
    public IPage<JSONObject> queryCompareNormalList(PurchaseEnquiryHead dbHead, Page<PurchaseEnquiryItemHis> page, List<String> toElsAccountList) {
        JSONObject result = new JSONObject();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItemHis::getHeadId, (Object)dbHead.getId());
        queryWrapper.eq(PurchaseEnquiryItemHis::getQuotePriceWay, (Object)EnquiryQuoteWayEnum.NORMAL.getValue());
        queryWrapper.in(CollectionUtil.isNotEmpty(toElsAccountList), PurchaseEnquiryItemHis::getToElsAccount, toElsAccountList);
        IPage pageList = this.page((IPage)page, (Wrapper)queryWrapper);
        List records = pageList.getRecords();
        Map<String, List<PurchaseEnquiryItemHis>> groupItem = records.stream().collect(Collectors.groupingBy(item -> item.getMaterialNumber() + "_" + item.getQuoteCount()));
        records.clear();
        for (Map.Entry<String, List<PurchaseEnquiryItemHis>> entry : groupItem.entrySet()) {
            this.initCompareMsg(dbHead, entry.getValue());
            records.addAll((Collection)entry.getValue());
        }
        Result dbResult = Result.ok((Object)records);
        this.dictAspect.parseDictText((Object)dbResult);
        List dataList = (List)dbResult.getResult();
        this.compareNormal(dataList, result);
        Page pageList1 = new Page();
        pageList1.setRecords(dataList);
        pageList1.setSize(pageList.getSize());
        pageList1.setTotal(pageList.getTotal());
        pageList1.setPages(pageList.getPages());
        return pageList1;
    }

    @Override
    public IPage<JSONObject> queryCompareLadderList(PurchaseEnquiryHead dbHead, Page<PurchaseEnquiryItemHis> page, List<String> toElsAccountList) {
        JSONObject result = new JSONObject();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItemHis::getHeadId, (Object)dbHead.getId());
        queryWrapper.eq(PurchaseEnquiryItemHis::getQuotePriceWay, (Object)EnquiryQuoteWayEnum.LADDER.getValue());
        queryWrapper.in(CollectionUtil.isNotEmpty(toElsAccountList), PurchaseEnquiryItemHis::getToElsAccount, toElsAccountList);
        IPage pageList = this.page((IPage)page, (Wrapper)queryWrapper);
        List records = pageList.getRecords();
        Map<String, List<PurchaseEnquiryItemHis>> groupItem = records.stream().collect(Collectors.groupingBy(item -> item.getMaterialNumber() + "_" + item.getQuoteCount()));
        records.clear();
        for (Map.Entry<String, List<PurchaseEnquiryItemHis>> entry : groupItem.entrySet()) {
            this.initCompareMsg(dbHead, entry.getValue());
            records.addAll((Collection)entry.getValue());
        }
        Result dbResult = Result.ok((Object)records);
        this.dictAspect.parseDictText((Object)dbResult);
        List dataList = (List)dbResult.getResult();
        List<JSONObject> jsonObjects = this.compareLadder(dataList, result);
        Page pageList1 = new Page();
        pageList1.setRecords(jsonObjects);
        pageList1.setSize(pageList.getSize());
        pageList1.setTotal(pageList.getTotal());
        pageList1.setPages(pageList.getPages());
        return pageList1;
    }

    @Override
    public IPage<JSONObject> queryCompareCostList(PurchaseEnquiryHead dbHead, Page<PurchaseEnquiryItemHis> page, List<String> toElsAccountList) {
        JSONObject result = new JSONObject();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItemHis::getHeadId, (Object)dbHead.getId());
        queryWrapper.eq(PurchaseEnquiryItemHis::getQuotePriceWay, (Object)EnquiryQuoteWayEnum.COST.getValue());
        queryWrapper.in(CollectionUtil.isNotEmpty(toElsAccountList), PurchaseEnquiryItemHis::getToElsAccount, toElsAccountList);
        IPage pageList = this.page((IPage)page, (Wrapper)queryWrapper);
        List records = pageList.getRecords();
        Map<String, List<PurchaseEnquiryItemHis>> groupItem = records.stream().collect(Collectors.groupingBy(item -> item.getMaterialNumber() + "_" + item.getQuoteCount()));
        records.clear();
        for (Map.Entry<String, List<PurchaseEnquiryItemHis>> entry : groupItem.entrySet()) {
            this.initCompareMsg(dbHead, entry.getValue());
            records.addAll((Collection)entry.getValue());
        }
        Result dbResult = Result.ok((Object)records);
        this.dictAspect.parseDictText((Object)dbResult);
        List dataList = (List)dbResult.getResult();
        List<JSONObject> jsonObjects = this.compareCost(dataList, result);
        Page pageList1 = new Page();
        pageList1.setRecords(jsonObjects);
        pageList1.setSize(pageList.getSize());
        pageList1.setTotal(pageList.getTotal());
        pageList1.setPages(pageList.getPages());
        return pageList1;
    }

    @Override
    public List<?> queryCompareSupplierList(PurchaseEnquiryHead dbHead, List<String> toElsAccountList) {
        JSONObject result = new JSONObject();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItemHis::getHeadId, (Object)dbHead.getId());
        queryWrapper.in(CollectionUtil.isNotEmpty(toElsAccountList), PurchaseEnquiryItemHis::getToElsAccount, toElsAccountList);
        List records = this.list((Wrapper)queryWrapper);
        Map<String, List<PurchaseEnquiryItemHis>> groupItem = records.stream().collect(Collectors.groupingBy(item -> item.getMaterialNumber() + "_" + item.getQuoteCount()));
        records.clear();
        for (Map.Entry<String, List<PurchaseEnquiryItemHis>> entry : groupItem.entrySet()) {
            this.initCompareMsg(dbHead, entry.getValue());
            records.addAll((Collection)entry.getValue());
        }
        Result dbResult = Result.ok((Object)records);
        this.dictAspect.parseDictText((Object)dbResult);
        List dataList = (List)dbResult.getResult();
        return this.compareSupplier(dataList, result);
    }

    @Override
    public JSONObject queryCompareForLast(PurchaseEnquiryHead dbHead, List<String> compareList, List<String> toElsAccountList) {
        JSONObject result = new JSONObject();
        result.put("quoteType", (Object)dbHead.getQuoteType());
        PurchaseEnquiryItemService enquiryItemService = (PurchaseEnquiryItemService)SpringContextUtils.getBean(PurchaseEnquiryItemServiceImpl.class);
        List dbList = enquiryItemService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseEnquiryItem::getHeadId, (Object)dbHead.getId())).in(CollectionUtil.isNotEmpty(toElsAccountList), PurchaseEnquiryItem::getToElsAccount, toElsAccountList));
        Map<String, List<PurchaseEnquiryItem>> groupItem = dbList.stream().collect(Collectors.groupingBy(item -> item.getMaterialNumber() + "_" + item.getQuoteCount()));
        dbList.clear();
        ArrayList returnList = new ArrayList();
        for (Map.Entry<String, List<PurchaseEnquiryItem>> entry : groupItem.entrySet()) {
            List hisList = BeanUtil.copyToList((Collection)entry.getValue(), PurchaseEnquiryItemHis.class);
            hisList.stream().forEach(item -> {
                item.setQuotaQuantity(item.getQuotaQuantity() != null ? item.getQuotaQuantity() : BigDecimal.ZERO);
                item.setQuotaScale(item.getQuotaScale() != null ? item.getQuotaScale() : BigDecimal.ZERO);
            });
            this.initCompareMsg(dbHead, hisList);
            returnList.addAll(hisList);
        }
        Result dbResult = Result.ok(returnList);
        this.dictAspect.parseDictText((Object)dbResult);
        List dataList = (List)dbResult.getResult();
        this.compareNormalForLast(dataList, result);
        this.compareLadderForLast(dataList, result);
        this.compareCostNewForLast(dataList, result);
        this.compareSupplierForLast(dataList, result);
        result.remove((Object)"quoteType");
        return result;
    }

    private void compareNormalForLast(List<JSONObject> dataList, JSONObject result) {
        JSONObject object;
        int i;
        List sortList;
        List<JSONObject> newList = this.getNewList(dataList);
        List normalList = newList.stream().filter(item -> EnquiryQuoteWayEnum.NORMAL.getValue().equals(item.getString("quotePriceWay"))).collect(Collectors.toMap(item -> item.getString("toElsAccount") + "_" + item.getString("itemNumber"), Function.identity(), (newVal, oldVal) -> {
            if (oldVal.getDate("quoteTime").before(newVal.getDate("quoteTime"))) {
                return newVal;
            }
            return oldVal;
        })).values().stream().collect(Collectors.toList());
        Map<String, List<JSONObject>> dataMap = normalList.stream().collect(Collectors.groupingBy(item -> item.getString("itemNumber")));
        for (Map.Entry<String, List<JSONObject>> entry : dataMap.entrySet()) {
            sortList = entry.getValue().stream().filter(item -> item.getBigDecimal("price") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(newVal -> newVal.getBigDecimal("price")).thenComparing(newVal -> newVal.getDate("quoteTime"))).collect(Collectors.toList());
            for (i = 0; i < sortList.size(); ++i) {
                object = (JSONObject)sortList.get(i);
                object.put("minPrice", (Object)(i == 0 ? 1 : 0));
                object.put("maxPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
            }
        }
        for (Map.Entry<String, List<JSONObject>> entry : dataMap.entrySet()) {
            sortList = entry.getValue().stream().filter(item -> item.getBigDecimal("netPrice") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(newVal -> newVal.getBigDecimal("netPrice")).thenComparing(newVal -> newVal.getDate("quoteTime"))).collect(Collectors.toList());
            for (i = 0; i < sortList.size(); ++i) {
                object = (JSONObject)sortList.get(i);
                object.put("minNetPrice", (Object)(i == 0 ? 1 : 0));
                object.put("maxNetPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
            }
        }
        result.put("normalList", normalList);
    }

    private void compareLadderForLast(List<JSONObject> dataList, JSONObject result) {
        List<JSONObject> newList = this.getNewList(dataList);
        List ladderList = newList.stream().filter(item -> EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getString("quotePriceWay"))).collect(Collectors.toMap(item -> item.getString("toElsAccount") + "_" + item.getString("itemNumber"), Function.identity(), (newVal, oldVal) -> {
            if (oldVal.getDate("quoteTime").before(newVal.getDate("quoteTime"))) {
                return newVal;
            }
            return oldVal;
        })).values().stream().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(ladderList)) {
            JSONObject object;
            List sortList;
            String ladder;
            HashMap<String, List<JSONObject>> dataMap = new HashMap<String, List<JSONObject>>();
            for (JSONObject jSONObject : ladderList) {
                JSONArray ladderArray = JSONArray.parseArray((String)jSONObject.getString("ladderPriceJson"));
                for (Object object2 : ladderArray) {
                    JSONObject ladderItem = (JSONObject)object2;
                    String ladder2 = ladderItem.getString("ladder");
                    jSONObject.put(ladder2, (Object)ladderItem);
                    String mapKey = ladder2 + "_" + jSONObject.getString("itemNumber");
                    this.getDataMap(dataMap, mapKey, jSONObject);
                }
            }
            for (Map.Entry entry : dataMap.entrySet()) {
                ladder = ((String)entry.getKey()).split("_")[0];
                this.setMinPriceAndMaxPrice((List)entry.getValue(), ladder);
            }
            for (Map.Entry entry : dataMap.entrySet()) {
                ladder = ((String)entry.getKey()).split("_")[0];
                this.setMinNetPriceAndMaxNetPrice((List)entry.getValue(), ladder);
            }
            for (JSONObject jSONObject : ladderList) {
                JSONObject newItem = JSONObject.parseObject((String)jSONObject.toJSONString());
                JSONArray ladderArray = JSONArray.parseArray((String)jSONObject.getString("ladderPriceJson"));
                JSONArray ladderPriceJson = new JSONArray();
                for (Object object3 : ladderArray) {
                    JSONObject ladderItem = (JSONObject)object3;
                    ladderPriceJson.add((Object)newItem.getJSONObject(ladderItem.getString("ladder")));
                }
                jSONObject.put("ladderPriceJson", (Object)ladderPriceJson);
            }
            Map<String, List<JSONObject>> ladderMap = ladderList.stream().collect(Collectors.groupingBy(item -> item.getString("itemNumber") + "_" + item.getInteger("quoteCount")));
            for (Map.Entry<String, List<JSONObject>> entry : ladderMap.entrySet()) {
                sortList = entry.getValue().stream().filter(item -> item.getBigDecimal("price") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(newVal -> newVal.getBigDecimal("price")).thenComparing(newVal -> newVal.getDate("quoteTime"))).collect(Collectors.toList());
                for (int i = 0; i < sortList.size(); ++i) {
                    object = (JSONObject)sortList.get(i);
                    object.put("minPrice", (Object)(i == 0 ? 1 : 0));
                    object.put("maxPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
                }
            }
            for (Map.Entry<String, List<JSONObject>> entry : ladderMap.entrySet()) {
                sortList = entry.getValue().stream().filter(item -> item.getBigDecimal("netPrice") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(newVal -> newVal.getBigDecimal("netPrice")).thenComparing(newVal -> newVal.getDate("quoteTime"))).collect(Collectors.toList());
                for (int i = 0; i < sortList.size(); ++i) {
                    object = (JSONObject)sortList.get(i);
                    object.put("minNetPrice", (Object)(i == 0 ? 1 : 0));
                    object.put("maxNetPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
                }
            }
            result.put("ladderList", ladderList);
        }
    }

    private void compareCostNewForLast(List<JSONObject> dataList, JSONObject result) {
        List<JSONObject> newList = this.getNewList(dataList);
        List costList = newList.stream().filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getString("quotePriceWay"))).collect(Collectors.toMap(item -> item.getString("toElsAccount") + "_" + item.getString("itemNumber"), Function.identity(), (newVal, oldVal) -> {
            if (oldVal.getDate("quoteTime").before(newVal.getDate("quoteTime"))) {
                return newVal;
            }
            return oldVal;
        })).values().stream().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(costList)) {
            JSONObject object;
            List sortList;
            for (JSONObject item2 : costList) {
                String itemNumber = item2.getString("itemNumber");
                String toElsAccount = item2.getString("toElsAccount");
                String taxRate = item2.getString("taxRate");
                BigDecimal taxRateDec = (StringUtils.isNotBlank((CharSequence)taxRate) ? new BigDecimal(taxRate) : BigDecimal.ZERO).divide(new BigDecimal("100"));
                JSONObject costFormJson = new JSONObject();
                JSONArray groupsArr = new JSONArray();
                costFormJson.put("groups", (Object)groupsArr);
                JSONObject dataObj = new JSONObject();
                costFormJson.put("data", (Object)dataObj);
                item2.put("costFormJsonObj", (Object)costFormJson);
            }
            Map<String, List<JSONObject>> costMap = costList.stream().collect(Collectors.groupingBy(item -> item.getString("itemNumber") + "_" + item.getInteger("quoteCount")));
            for (Map.Entry<String, List<JSONObject>> entry : costMap.entrySet()) {
                sortList = entry.getValue().stream().filter(item -> item.getBigDecimal("price") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(newVal -> newVal.getBigDecimal("price")).thenComparing(newVal -> newVal.getDate("quoteTime"))).collect(Collectors.toList());
                for (int i = 0; i < sortList.size(); ++i) {
                    object = (JSONObject)sortList.get(i);
                    object.put("minPrice", (Object)(i == 0 ? 1 : 0));
                    object.put("maxPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
                }
            }
            for (Map.Entry<String, List<JSONObject>> entry : costMap.entrySet()) {
                sortList = entry.getValue().stream().filter(item -> item.getBigDecimal("netPrice") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(newVal -> newVal.getBigDecimal("netPrice")).thenComparing(newVal -> newVal.getDate("quoteTime"))).collect(Collectors.toList());
                for (int i = 0; i < sortList.size(); ++i) {
                    object = (JSONObject)sortList.get(i);
                    object.put("minNetPrice", (Object)(i == 0 ? 1 : 0));
                    object.put("maxNetPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
                }
            }
            result.put("costList", costList);
        }
    }

    private void compareSupplierForLast(List<JSONObject> dataList, JSONObject result) {
        List<JSONObject> supplierList = this.getNewList(dataList);
        Map data1Map = supplierList.stream().collect(Collectors.toMap(item -> item.getString("toElsAccount") + "_" + item.getInteger("quoteCount"), Function.identity(), (newVal, oldVal) -> {
            BigDecimal newTaxAmount = newVal.getBigDecimal("taxAmount") == null ? BigDecimal.ZERO : newVal.getBigDecimal("taxAmount");
            BigDecimal oldTaxAmount = oldVal.getBigDecimal("taxAmount") == null ? BigDecimal.ZERO : oldVal.getBigDecimal("taxAmount");
            BigDecimal taxAmount = oldTaxAmount.add(newTaxAmount);
            oldVal.put("taxAmount", (Object)taxAmount);
            oldVal.put("price", (Object)taxAmount);
            BigDecimal newNetAmount = newVal.getBigDecimal("netAmount") == null ? BigDecimal.ZERO : newVal.getBigDecimal("netAmount");
            BigDecimal oldNetAmount = oldVal.getBigDecimal("netAmount") == null ? BigDecimal.ZERO : oldVal.getBigDecimal("netAmount");
            BigDecimal netAmount = oldNetAmount.add(newNetAmount);
            oldVal.put("netAmount", (Object)netAmount);
            oldVal.put("netPrice", (Object)netAmount);
            return oldVal;
        }));
        Map dataMap = data1Map.values().stream().filter(item -> item.containsKey((Object)"quoteTime")).collect(Collectors.toMap(item -> item.getString("toElsAccount"), Function.identity(), (newVal, oldVal) -> {
            if (oldVal.getDate("quoteTime").before(newVal.getDate("quoteTime"))) {
                return newVal;
            }
            return oldVal;
        }));
        List taxAmountSortList = dataMap.values().stream().sorted(Comparator.comparing(item -> item.getBigDecimal("taxAmount")).thenComparing(item -> item.getDate("quoteTime"))).collect(Collectors.toList());
        for (int i = 0; i < taxAmountSortList.size(); ++i) {
            JSONObject item2 = (JSONObject)taxAmountSortList.get(i);
            item2.put("minTaxAmount", (Object)(i == 0 ? 1 : 0));
            item2.put("maxTaxAmount", (Object)(i == taxAmountSortList.size() - 1 ? 1 : 0));
        }
        List netAmountSortList = dataMap.values().stream().sorted(Comparator.comparing(item -> item.getBigDecimal("netAmount")).thenComparing(item -> item.getDate("quoteTime"))).collect(Collectors.toList());
        for (int i = 0; i < netAmountSortList.size(); ++i) {
            JSONObject item3 = (JSONObject)netAmountSortList.get(i);
            item3.put("minNetAmount", (Object)(i == 0 ? 1 : 0));
            item3.put("maxNetAmount", (Object)(i == netAmountSortList.size() - 1 ? 1 : 0));
        }
        result.put("supplierList", new ArrayList(dataMap.values()));
    }

    @Override
    public void compareNormal(List<JSONObject> dataList, JSONObject result) {
        JSONObject object;
        int i;
        List sortList;
        Map<String, List<JSONObject>> dataMap = dataList.stream().collect(Collectors.groupingBy(item -> item.getString("itemNumber") + "_" + item.getInteger("quoteCount")));
        for (Map.Entry<String, List<JSONObject>> entry : dataMap.entrySet()) {
            sortList = entry.getValue().stream().filter(item -> item.getBigDecimal("price") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(newVal -> newVal.getBigDecimal("price")).thenComparing(newVal -> newVal.getDate("quoteTime"))).collect(Collectors.toList());
            for (i = 0; i < sortList.size(); ++i) {
                object = (JSONObject)sortList.get(i);
                object.put("minPrice", (Object)(i == 0 ? 1 : 0));
                object.put("maxPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
            }
        }
        for (Map.Entry<String, List<JSONObject>> entry : dataMap.entrySet()) {
            sortList = entry.getValue().stream().filter(item -> item.getBigDecimal("netPrice") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(newVal -> newVal.getBigDecimal("netPrice")).thenComparing(newVal -> newVal.getDate("quoteTime"))).collect(Collectors.toList());
            for (i = 0; i < sortList.size(); ++i) {
                object = (JSONObject)sortList.get(i);
                object.put("minNetPrice", (Object)(i == 0 ? 1 : 0));
                object.put("maxNetPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
            }
        }
        result.put("normalList", dataList);
    }

    @Override
    public List<JSONObject> compareLadder(List<JSONObject> dataList, JSONObject result) {
        String ladder;
        List<JSONObject> newList = this.getNewList(dataList);
        List<JSONObject> ladderList = newList.stream().filter(item -> EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getString("quotePriceWay"))).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(ladderList)) {
            return null;
        }
        HashMap<String, List<JSONObject>> dataMap = new HashMap<String, List<JSONObject>>();
        for (JSONObject jSONObject : ladderList) {
            JSONArray ladderArray = JSONArray.parseArray((String)jSONObject.getString("ladderPriceJson"));
            for (Object object : ladderArray) {
                JSONObject ladderItem = (JSONObject)object;
                String ladder2 = ladderItem.getString("ladder");
                jSONObject.put(ladder2, (Object)ladderItem);
                String mapKey = ladder2 + "_" + jSONObject.getString("itemNumber") + "_" + jSONObject.getInteger("quoteCount");
                this.getDataMap(dataMap, mapKey, jSONObject);
            }
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            ladder = ((String)entry.getKey()).split("_")[0];
            this.setMinPriceAndMaxPrice((List)entry.getValue(), ladder);
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            ladder = ((String)entry.getKey()).split("_")[0];
            this.setMinNetPriceAndMaxNetPrice((List)entry.getValue(), ladder);
        }
        for (JSONObject jSONObject : ladderList) {
            JSONObject newItem = JSONObject.parseObject((String)jSONObject.toJSONString());
            JSONArray ladderArray = JSONArray.parseArray((String)jSONObject.getString("ladderPriceJson"));
            JSONArray ladderPriceJson = new JSONArray();
            for (Object object : ladderArray) {
                JSONObject ladderItem = (JSONObject)object;
                ladderPriceJson.add((Object)newItem.getJSONObject(ladderItem.getString("ladder")));
            }
            jSONObject.put("ladderPriceJson", (Object)ladderPriceJson);
        }
        result.put("ladderList", ladderList);
        return ladderList;
    }

    private void getDataMap(Map<String, List<JSONObject>> dataMap, String key, JSONObject item) {
        if (dataMap.containsKey(key)) {
            dataMap.get(key).add(item);
        } else {
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            list.add(item);
            dataMap.put(key, list);
        }
    }

    private void setMinPriceAndMaxPrice(List<JSONObject> needSortList, String mapKey) {
        List sortList = needSortList.stream().filter(item -> item.getJSONObject(mapKey).getBigDecimal("price") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(item -> item.getJSONObject(mapKey).getBigDecimal("price")).thenComparing(item -> item.getDate("quoteTime"))).collect(Collectors.toList());
        for (int i = 0; i < sortList.size(); ++i) {
            JSONObject item2 = (JSONObject)sortList.get(i);
            item2.getJSONObject(mapKey).put("minPrice", (Object)(i == 0 ? 1 : 0));
            item2.getJSONObject(mapKey).put("maxPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
        }
    }

    private void setMinNetPriceAndMaxNetPrice(List<JSONObject> needSortList, String mapKey) {
        List sortList = needSortList.stream().filter(item -> item.getJSONObject(mapKey).getBigDecimal("netPrice") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(item -> item.getJSONObject(mapKey).getBigDecimal("netPrice")).thenComparing(item -> item.getDate("quoteTime"))).collect(Collectors.toList());
        for (int i = 0; i < sortList.size(); ++i) {
            JSONObject item2 = (JSONObject)sortList.get(i);
            item2.getJSONObject(mapKey).put("minNetPrice", (Object)(i == 0 ? 1 : 0));
            item2.getJSONObject(mapKey).put("maxNetPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
        }
    }

    @Override
    public List<JSONObject> compareCost(List<JSONObject> dataList, JSONObject result) {
        String groupCode;
        List<JSONObject> newList = this.getNewList(dataList);
        List<JSONObject> costList = newList.stream().filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getString("quotePriceWay"))).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(costList)) {
            return null;
        }
        HashMap<String, List<JSONObject>> dataMap = new HashMap<String, List<JSONObject>>();
        for (JSONObject jSONObject : costList) {
            JSONObject costObject = JSONObject.parseObject((String)jSONObject.getString("costFormJson"));
            JSONArray costGroups = costObject.getJSONArray("groups");
            if (ObjectUtils.isEmpty((Object)costGroups)) continue;
            for (Object object : costGroups) {
                JSONObject costItem = (JSONObject)object;
                String groupCode2 = costItem.getString("groupCode");
                jSONObject.put(groupCode2, (Object)costItem);
                String mapKey = groupCode2 + "_" + jSONObject.getString("itemNumber") + "_" + jSONObject.getInteger("quoteCount");
                this.getDataMap(dataMap, mapKey, jSONObject);
            }
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            groupCode = ((String)entry.getKey()).split("_")[0];
            this.setMinPriceAndMaxPrice((List)entry.getValue(), groupCode);
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            groupCode = ((String)entry.getKey()).split("_")[0];
            this.setMinNetPriceAndMaxNetPrice((List)entry.getValue(), groupCode);
        }
        for (JSONObject jSONObject : costList) {
            JSONObject newItem = JSONObject.parseObject((String)jSONObject.toJSONString());
            JSONObject costObject = JSONObject.parseObject((String)jSONObject.getString("costFormJson"));
            JSONArray costGroups = costObject.getJSONArray("groups");
            if (ObjectUtils.isEmpty((Object)costGroups)) continue;
            JSONArray costFormJson = new JSONArray();
            for (Object object : costGroups) {
                JSONObject costItem = (JSONObject)object;
                costFormJson.add((Object)newItem.getJSONObject(costItem.getString("groupCode")));
            }
            jSONObject.put("costFormJson", (Object)costFormJson);
        }
        result.put("costList", costList);
        return costList;
    }

    private List<?> compareSupplier(List<JSONObject> dataList, JSONObject result) {
        List<JSONObject> supplierList = this.getNewList(dataList);
        Map dataMap = supplierList.stream().collect(Collectors.toMap(item -> item.getString("toElsAccount") + "_" + item.getInteger("quoteCount"), Function.identity(), (newVal, oldVal) -> {
            BigDecimal newTaxAmount = newVal.getBigDecimal("taxAmount") == null ? BigDecimal.ZERO : newVal.getBigDecimal("taxAmount");
            BigDecimal oldTaxAmount = oldVal.getBigDecimal("taxAmount") == null ? BigDecimal.ZERO : oldVal.getBigDecimal("taxAmount");
            BigDecimal taxAmount = oldTaxAmount.add(newTaxAmount);
            oldVal.put("taxAmount", (Object)taxAmount);
            oldVal.put("price", (Object)taxAmount);
            BigDecimal newNetAmount = newVal.getBigDecimal("netAmount") == null ? BigDecimal.ZERO : newVal.getBigDecimal("netAmount");
            BigDecimal oldNetAmount = oldVal.getBigDecimal("netAmount") == null ? BigDecimal.ZERO : oldVal.getBigDecimal("netAmount");
            BigDecimal netAmount = oldNetAmount.add(newNetAmount);
            oldVal.put("netAmount", (Object)netAmount);
            oldVal.put("netPrice", (Object)netAmount);
            return oldVal;
        }));
        List taxAmountSortList = dataMap.values().stream().sorted(Comparator.comparing(item -> item.getBigDecimal("taxAmount")).thenComparing(item -> item.getDate("quoteTime"))).collect(Collectors.toList());
        for (int i = 0; i < taxAmountSortList.size(); ++i) {
            JSONObject item2 = (JSONObject)taxAmountSortList.get(i);
            item2.put("minTaxAmount", (Object)(i == 0 ? 1 : 0));
            item2.put("maxTaxAmount", (Object)(i == taxAmountSortList.size() - 1 ? 1 : 0));
        }
        List netAmountSortList = dataMap.values().stream().sorted(Comparator.comparing(item -> item.getBigDecimal("netAmount")).thenComparing(item -> item.getDate("quoteTime"))).collect(Collectors.toList());
        for (int i = 0; i < netAmountSortList.size(); ++i) {
            JSONObject item3 = (JSONObject)netAmountSortList.get(i);
            item3.put("minNetAmount", (Object)(i == 0 ? 1 : 0));
            item3.put("maxNetAmount", (Object)(i == netAmountSortList.size() - 1 ? 1 : 0));
        }
        result.put("supplierList", new ArrayList(dataMap.values()));
        return new ArrayList(dataMap.values());
    }

    private List<JSONObject> getNewList(List<JSONObject> dataList) {
        ArrayList<JSONObject> newList = new ArrayList<JSONObject>();
        dataList.forEach(item -> {
            JSONObject supplier = JSONObject.parseObject((String)item.toJSONString());
            newList.add(supplier);
        });
        return newList;
    }

    private void initHeadMsg(PurchaseEnquiryHead head, List<PurchaseEnquiryItemHis> items) {
        items.forEach(item -> item.setPayTermsCode(head.getPayTermsCode()).setTradeCondition(head.getTradeCondition()));
    }

    private void initHisMinPrice(PurchaseEnquiryHead head, List<PurchaseEnquiryItemHis> items) {
        for (PurchaseEnquiryItemHis item : items) {
            List<EnquiryItemPriceVO> priceVOs = ((PurchaseEnquiryItemHisMapper)this.baseMapper).hisMinPrice(head.getQuoteType(), item.getMaterialNumber(), item.getQuoteTime());
            if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(head.getQuoteType())) {
                List<String> currencies = priceVOs.stream().filter(priceVO -> StringUtils.isNotBlank((CharSequence)priceVO.getItemCurrency()) && !Objects.equals(priceVO.getItemCurrency(), head.getCurrency())).map(EnquiryItemPriceVO::getItemCurrency).collect(Collectors.toList());
                List<BpExchangeRateDTO> rates = this.mainDataRpcService.getRateByCurrencys(currencies, head.getCurrency());
                for (BpExchangeRateDTO rateDTO : rates) {
                    if (rateDTO.getExchange() == null) continue;
                    for (EnquiryItemPriceVO priceVO2 : priceVOs) {
                        if (!Objects.equals(rateDTO.getOriginalCurrency(), priceVO2.getItemCurrency())) continue;
                        BigDecimal tempPrice = priceVO2.getPrice() == null ? BigDecimal.ZERO : priceVO2.getPrice();
                        BigDecimal result = tempPrice.multiply(rateDTO.getExchange()).setScale(6, 4).stripTrailingZeros();
                        priceVO2.setPrice(result);
                    }
                }
                priceVOs = priceVOs.stream().sorted(Comparator.comparing(EnquiryItemPriceVO::getPrice)).collect(Collectors.toList());
            }
            BigDecimal price = CollectionUtils.isEmpty(priceVOs) || priceVOs.get(0).getPrice() == null ? null : priceVOs.get(0).getPrice().stripTrailingZeros();
            item.setHisMinPrice(price);
        }
    }

    private void initSupplierHisMinPrice(PurchaseEnquiryHead head, List<PurchaseEnquiryItemHis> items) {
        List toElsAccounts = items.stream().map(PurchaseEnquiryItemHis::getToElsAccount).collect(Collectors.toList());
        List<SupplierEnquiryItemPriceVO> priceVOS = ((PurchaseEnquiryItemHisMapper)this.baseMapper).supplierHisMinPrice(head.getQuoteType(), items.get(0).getMaterialNumber(), items);
        if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(head.getQuoteType())) {
            List<String> currencies = priceVOS.stream().filter(priceVO -> StringUtils.isNotBlank((CharSequence)priceVO.getItemCurrency()) && !Objects.equals(priceVO.getItemCurrency(), head.getCurrency())).map(SupplierEnquiryItemPriceVO::getItemCurrency).distinct().collect(Collectors.toList());
            List<BpExchangeRateDTO> rates = this.mainDataRpcService.getRateByCurrencys(currencies, head.getCurrency());
            for (BpExchangeRateDTO rateDTO : rates) {
                if (rateDTO.getExchange() == null) continue;
                for (SupplierEnquiryItemPriceVO priceVO2 : priceVOS) {
                    if (!Objects.equals(rateDTO.getOriginalCurrency(), priceVO2.getItemCurrency())) continue;
                    BigDecimal tempPrice = priceVO2.getPrice() == null ? BigDecimal.ZERO : priceVO2.getPrice();
                    BigDecimal result = tempPrice.multiply(rateDTO.getExchange()).setScale(6, 4).stripTrailingZeros();
                    priceVO2.setPrice(result);
                }
            }
        }
        Map<String, List<SupplierEnquiryItemPriceVO>> groupVOS = priceVOS.stream().collect(Collectors.groupingBy(item -> item.getToElsAccount()));
        for (PurchaseEnquiryItemHis item2 : items) {
            List<SupplierEnquiryItemPriceVO> tempVOS = groupVOS.get(item2.getToElsAccount());
            if (CollectionUtils.isEmpty(tempVOS)) continue;
            BigDecimal min = tempVOS.stream().map(SupplierEnquiryItemPriceVO::getPrice).min(BigDecimal::compareTo).get();
            item2.setSupplierHisMinPrice(min);
        }
    }

    private void sumAmount(PurchaseEnquiryHead head, List<PurchaseEnquiryItemHis> items) {
        List toElsAccounts = items.stream().map(PurchaseEnquiryItemHis::getToElsAccount).collect(Collectors.toList());
        List<SupplierEnquiryItemAmountVO> amountVOS = ((PurchaseEnquiryItemHisMapper)this.baseMapper).supplierSumAmount(head.getQuoteType(), items.get(0).getMaterialNumber(), items);
        if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(head.getQuoteType())) {
            List<String> currencies = amountVOS.stream().filter(priceVO -> StringUtils.isNotBlank((CharSequence)priceVO.getItemCurrency()) && !Objects.equals(priceVO.getItemCurrency(), head.getCurrency())).map(SupplierEnquiryItemAmountVO::getItemCurrency).distinct().collect(Collectors.toList());
            List<BpExchangeRateDTO> rates = this.mainDataRpcService.getRateByCurrencys(currencies, head.getCurrency());
            for (BpExchangeRateDTO rateDTO : rates) {
                if (rateDTO.getExchange() == null) continue;
                for (SupplierEnquiryItemAmountVO amountVO : amountVOS) {
                    if (!Objects.equals(rateDTO.getOriginalCurrency(), amountVO.getItemCurrency())) continue;
                    BigDecimal tempPrice = amountVO.getSumAmount() == null ? BigDecimal.ZERO : amountVO.getSumAmount();
                    BigDecimal result = tempPrice.multiply(rateDTO.getExchange()).setScale(6, 4).stripTrailingZeros();
                    amountVO.setSumAmount(result);
                }
            }
        }
        Map<String, BigDecimal> sumGroup = amountVOS.stream().collect(Collectors.groupingBy(SupplierEnquiryItemAmountVO::getToElsAccount, Collectors.mapping(SupplierEnquiryItemAmountVO::getSumAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        for (PurchaseEnquiryItemHis item : items) {
            BigDecimal sumAmount;
            BigDecimal bigDecimal = sumAmount = sumGroup.get(item.getToElsAccount()) == null ? null : sumGroup.get(item.getToElsAccount()).stripTrailingZeros();
            if (item.getBeforeThreeMonths() == null) {
                item.setSupplierSumAmount(sumAmount);
                continue;
            }
            item.setThreeMonthsSumAmount(sumAmount);
        }
    }

    private void threeMonthsSumAmount(PurchaseEnquiryHead head, List<PurchaseEnquiryItemHis> items) {
        items.forEach(item -> {
            if (item.getQuoteTime() != null) {
                LocalDateTime localDateTime = LocalDateTimeUtil.of((Date)item.getQuoteTime());
                String beforeThreeMonths = LocalDateTimeUtil.format((LocalDateTime)localDateTime.minusMonths(3L), (String)"yyyy-MM-dd HH:mm:ss");
                item.setBeforeThreeMonths(beforeThreeMonths);
            }
        });
        this.sumAmount(head, items);
    }

    private void sumQuantity(PurchaseEnquiryHead head, List<PurchaseEnquiryItemHis> items) {
        List<SupplierEnquiryItemQuantityVO> quantityVOS = ((PurchaseEnquiryItemHisMapper)this.baseMapper).supplierSumQuantity(items.get(0).getMaterialNumber(), items);
        List<PurchaseMaterialUnitNewDTO> materialUnits = this.mainDataRpcService.getByMaterialNumber(items.get(0).getMaterialNumber());
        for (SupplierEnquiryItemQuantityVO quantityVO : quantityVOS) {
            if (Objects.equals(quantityVO.getPurchaseUnit(), items.get(0).getPurchaseUnit())) continue;
            for (PurchaseMaterialUnitNewDTO dto : materialUnits) {
                BigDecimal basicAmount;
                BigDecimal quantity = quantityVO.getQuantities() == null ? BigDecimal.ZERO : quantityVO.getQuantities();
                BigDecimal objectAmount = dto.getObjectAmount() == null ? BigDecimal.ONE : dto.getObjectAmount();
                BigDecimal bigDecimal = basicAmount = dto.getBasicAmount() == null ? BigDecimal.ONE : dto.getBasicAmount();
                if (Objects.equals(quantityVO.getPurchaseUnit(), dto.getObjectUnit()) && Objects.equals(items.get(0).getPurchaseUnit(), dto.getBasicUnit())) {
                    quantity = quantity.multiply(basicAmount).divide(objectAmount, 6, RoundingMode.HALF_UP);
                }
                if (Objects.equals(quantityVO.getPurchaseUnit(), dto.getBasicUnit()) && Objects.equals(items.get(0).getPurchaseUnit(), dto.getObjectUnit())) {
                    quantity = quantity.multiply(objectAmount).divide(basicAmount, 6, RoundingMode.HALF_UP);
                }
                quantityVO.setQuantities(quantity);
            }
        }
        Map<String, BigDecimal> sumGroup = quantityVOS.stream().filter(item -> item.getQuantities() != null).collect(Collectors.groupingBy(SupplierEnquiryItemQuantityVO::getToElsAccount, Collectors.mapping(SupplierEnquiryItemQuantityVO::getQuantities, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        for (PurchaseEnquiryItemHis item2 : items) {
            BigDecimal sumQuantity = sumGroup.get(item2.getToElsAccount()) == null ? null : sumGroup.get(item2.getToElsAccount()).stripTrailingZeros();
            item2.setSumQuantity(sumQuantity);
        }
    }

    @Override
    public void initCompareMsg(PurchaseEnquiryHead head, List<PurchaseEnquiryItemHis> items) {
        if (CollectionUtils.isEmpty(items) || StringUtils.isBlank((CharSequence)items.get(0).getMaterialNumber())) {
            return;
        }
        this.initHeadMsg(head, items);
        this.initHisMinPrice(head, items);
        this.initSupplierHisMinPrice(head, items);
        this.sumAmount(head, items);
        this.threeMonthsSumAmount(head, items);
        this.sumQuantity(head, items);
    }
}

