/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.service.PurchaseAttachmentRpcService;
import com.els.modules.base.api.service.SaleAttachmentRpcService;
import com.els.modules.tender.common.service.TenderDownloadService;
import com.els.modules.tender.project.utils.TenderProjectMemberUtils;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/common/download"})
@Api(tags={"\u62db\u6807\u5728\u7ebf\u6587\u6863\u7f16\u8f91\u4e0b\u8f7d"})
public class TenderDownloadController {
    private static final String SERVICE_ADDRESS = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.config.service.address");
    @Autowired
    private TenderDownloadService tenderDownloadService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    @Lazy
    private PurchaseAttachmentRpcService purchaseAttachmentRpcService;
    @Autowired
    @Lazy
    private SaleAttachmentRpcService saleAttachmentRpcService;
    @Autowired
    @Lazy
    private TenderProjectSupplierService supplierService;

    @GetMapping(value={"/downloadPDF"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> downloadPDF(@RequestParam(name="id", required=true) String id, @RequestParam(name="businessType", required=true) String businessType, HttpServletRequest request, HttpServletResponse response) {
        this.tenderDownloadService.downloadPDF(id, businessType, request, response);
        return Result.ok();
    }

    @RequiresPermissions(value={"attachment#purchaseAttachment:download"})
    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u7684\u4e0b\u8f7d\u8def\u5f84", notes="\u83b7\u53d6\u6587\u4ef6\u7684\u4e0b\u8f7d\u8def\u5f84")
    @GetMapping(value={"/getDownLoadUrl"})
    @ResponseBody
    public Result<?> getDownLoadUrl(@RequestParam(value="id") String id, @RequestParam(value="subpackageId") String subpackageId) {
        this.checkAttachmentOwn(subpackageId);
        String signature = null;
        PurchaseAttachmentDTO dbPurchaseAttachment = this.purchaseAttachmentRpcService.selectById(id);
        String key = IdWorker.getIdStr();
        if (dbPurchaseAttachment == null) {
            SaleAttachmentDTO dbSaleAttachment = this.saleAttachmentRpcService.selectById(id);
            if (dbSaleAttachment == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
            }
            signature = "/attachment/saleAttachment/noToken/download?id=" + dbSaleAttachment.getId() + "&key=" + key;
        } else {
            signature = "/attachment/purchaseAttachment/noToken/download?id=" + dbPurchaseAttachment.getId() + "&key=" + key;
        }
        this.redisUtil.set("sys:attachment:expire:" + key, (Object)key, 10L);
        return Result.ok((String)signature.replace("\\", "/"));
    }

    @RequiresPermissions(value={"attachment#purchaseAttachment:getSignature"})
    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u7684\u9884\u89c8\u94fe\u63a5", notes="\u83b7\u53d6\u6587\u4ef6\u7684\u9884\u89c8\u94fe\u63a5")
    @GetMapping(value={"/getSignature"})
    @ResponseBody
    public Result<?> getSignature(@RequestParam(value="id") String id, @RequestParam(value="subpackageId") String subpackageId, HttpServletRequest request) {
        this.checkAttachmentOwn(subpackageId);
        String signature = null;
        PurchaseAttachmentDTO dbPurchaseAttachment = this.purchaseAttachmentRpcService.selectById(id);
        String key = IdWorker.getIdStr();
        if (dbPurchaseAttachment == null) {
            SaleAttachmentDTO dbSaleAttachment = this.saleAttachmentRpcService.selectById(id);
            if (dbSaleAttachment == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
            }
            signature = SERVICE_ADDRESS + "/els/attachment/saleAttachment/noToken/download?id=" + dbSaleAttachment.getId() + "&key=" + key + "&fullfilename=" + dbSaleAttachment.getFileName().replace("&", "@");
        } else {
            signature = SERVICE_ADDRESS + "/els/attachment/purchaseAttachment/noToken/download?id=" + dbPurchaseAttachment.getId() + "&key=" + key + "&fullfilename=" + dbPurchaseAttachment.getFileName().replace("&", "@");
        }
        this.redisUtil.set("sys:attachment:expire:" + key, (Object)key, 10L);
        return Result.ok((String)signature.replace("\\", "/"));
    }

    private void checkAttachmentOwn(String subpackageId) {
        TenderProjectSupplier supplier = new TenderProjectSupplier();
        supplier.setSubpackageId(subpackageId);
        supplier.setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> supplierList = this.supplierService.selectBySubpackageId(supplier);
        if (CollectionUtil.isEmpty(supplierList)) {
            List<ElsSubAccountDTO> dtoList = TenderProjectMemberUtils.getTenderProjectMemberBySubpackageId(subpackageId);
            Set accountSet = dtoList.parallelStream().map(account -> account.getElsAccount() + "_" + account.getSubAccount()).collect(Collectors.toSet());
            LoginUser loginUser = SysUtil.getLoginUser();
            String loginUserAccount = loginUser.getElsAccount() + "_" + loginUser.getSubAccount();
            Assert.isTrue((boolean)accountSet.contains(loginUserAccount), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u8d26\u53f7\u65e0\u4e0b\u8f7d\u9644\u4ef6\u6743\u9650\uff01"));
        }
    }
}

