/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.project.vo.PurchaseTenderProjectOpenInfoHeadVO;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.vo.SaleTenderPriceOpeningsVO;
import com.els.modules.tender.sale.vo.TenderProjectSupplierDecrptVO;
import com.els.modules.tender.supplier.entity.EnhanceTenderProjectSupplier;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.tender.supplier.vo.TenderProjectSupplierMessageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f9b\u5e94\u5546\u6295\u6807\u4e3b\u6570\u636e\u8868"})
@RestController
@RequestMapping(value={"/tender/sale/supplierTenderProjectMasterInfo"})
public class SaleTenderProjectSupplierController
extends BaseController<TenderProjectSupplier, TenderProjectSupplierService> {
    @Autowired
    private TenderProjectSupplierService saleTenderProjectSupplierService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryPageList(EnhanceTenderProjectSupplier saleTenderProjectSupplier, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        LinkedHashMap parameterMap = new LinkedHashMap();
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            if ("status".equals(entry.getKey())) continue;
            parameterMap.put(entry.getKey(), entry.getValue());
        }
        saleTenderProjectSupplier.setEffective("1");
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleTenderProjectSupplier), parameterMap);
        queryWrapper.eq((Object)"supplier_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<EnhanceTenderProjectSupplier> pageList = this.saleTenderProjectSupplierService.pageWrapper((Page<EnhanceTenderProjectSupplier>)page, (QueryWrapper<EnhanceTenderProjectSupplier>)queryWrapper, saleTenderProjectSupplier);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryTabsCount() {
        List<CountVO> result = this.saleTenderProjectSupplierService.queryTabsCount(TenantContext.getTenant());
        return Result.ok(result);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6295\u6807\u4e3b\u6570\u636e\u8868-\u53c2\u52a0(\u65e0\u9700\u62a5\u540d/\u8d2d\u6807\u8c03\u7528)")
    @ApiOperation(value="\u53c2\u52a0", notes="\u53c2\u52a0")
    @PostMapping(value={"/join"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @SrmValidated
    public Result<?> join(@RequestBody TenderProjectSupplier saleTenderProjectSupplier) {
        this.saleTenderProjectSupplierService.join(saleTenderProjectSupplier);
        return Result.ok((Object)((Object)saleTenderProjectSupplier));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TenderProjectSupplier saleTenderProjectSupplier = (TenderProjectSupplier)((Object)this.saleTenderProjectSupplierService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)saleTenderProjectSupplier));
    }

    @AutoLog(value="\u5f00\u6807\u5927\u5385\u83b7\u53d6\u6295\u6807\u51fd\u52a0\u5bc6\u4e32")
    @ApiOperation(value="\u5f00\u6807\u5927\u5385\u83b7\u53d6\u6295\u6807\u51fd\u52a0\u5bc6\u4e32", notes="\u5f00\u6807\u5927\u5385\u83b7\u53d6\u6295\u6807\u51fd\u52a0\u5bc6\u4e32")
    @GetMapping(value={"/getLetterEncryptionInfoBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> decrypt(@RequestParam(name="subpackageId") String subpackageId) {
        SaleTenderPriceOpenings saleTenderPriceOpenings = this.saleTenderProjectSupplierService.getLetterEncryptionInfoBySubpackageId(subpackageId);
        return Result.ok((Object)((Object)saleTenderPriceOpenings));
    }

    @AutoLog(value="\u5f00\u6807\u5927\u5385\u89e3\u5bc6")
    @ApiOperation(value="\u5f00\u6807\u5927\u5385\u89e3\u5bc6", notes="\u5f00\u6807\u5927\u5385\u89e3\u5bc6")
    @PostMapping(value={"/decrypt"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @SrmValidated
    public Result<?> decrypt(@RequestBody @Valid TenderProjectSupplierDecrptVO tenderProjectSupplierDecrptVO) {
        this.saleTenderProjectSupplierService.decrypt(tenderProjectSupplierDecrptVO);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5f00\u6807\u5927\u5385\u7b7e\u540d")
    @ApiOperation(value="\u5f00\u6807\u5927\u5385\u7b7e\u540d", notes="\u5f00\u6807\u5927\u5385\u7b7e\u540d")
    @PostMapping(value={"/sign/{subpackageId}"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> sign(@PathVariable(name="subpackageId") String subpackageId) {
        this.saleTenderProjectSupplierService.signature(subpackageId);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6295\u6807\u4e3b\u6570\u636e\u8868-\u5f00\u6807\u7b7e\u5230")
    @ApiOperation(value="\u7b7e\u5230", notes="\u7b7e\u5230")
    @PostMapping(value={"/signIn"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @SrmValidated
    public Result<?> signIn(@RequestBody TenderProjectSupplier tenderProjectSupplier) {
        this.saleTenderProjectSupplierService.signIn(tenderProjectSupplier);
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u4ef7\u683c\u4e00\u89c8\u8868", notes="\u83b7\u53d6\u4ef7\u683c\u4e00\u89c8\u8868")
    @PostMapping(value={"/priceOpeningsBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> getPriceOpeningsBySubpackageId(@RequestParam(name="subpackageId") String subpackageId) {
        List<SaleTenderPriceOpeningsVO> tenderPriceOpeningsList = this.saleTenderProjectSupplierService.getSalePriceOpeningsBySubpackageId(subpackageId);
        return Result.ok(tenderPriceOpeningsList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5206\u5305Id\u67e5\u8be2\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u6743\u9650", notes="\u901a\u8fc7\u5206\u5305Id\u67e5\u8be2\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u6743\u9650")
    @GetMapping(value={"/openBid/permission"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> openBidPermission(@RequestParam(value="subpackageId") String subpackageId) {
        PurchaseTenderProjectOpenInfoHeadVO openInfoHeadVO = this.saleTenderProjectSupplierService.openBidPermission(subpackageId);
        return Result.ok((Object)((Object)openInfoHeadVO));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6295\u6807\u4e3b\u6570\u636e\u8868-\u8ddf\u636e\u5206\u5305ID\u67e5\u8be2\u4f9b\u5e94\u5546\u7aef\u72b6\u6001")
    @ApiOperation(value="\u8ddf\u636e\u5206\u5305ID\u67e5\u8be2\u4f9b\u5e94\u5546\u7aef\u72b6\u6001", notes="\u8ddf\u636e\u5206\u5305ID\u67e5\u8be2\u4f9b\u5e94\u5546\u7aef\u72b6\u6001")
    @GetMapping(value={"/selectProjectSupplierBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> selectProjectSupplierBySubpackageId(@RequestParam(value="subpackageId") String subpackageId) {
        TenderProjectSupplierMessageVO tenderProjectSupplierMessageVO = this.saleTenderProjectSupplierService.selectProjectSupplierBySubpackageId(subpackageId);
        return Result.ok((Object)((Object)tenderProjectSupplierMessageVO));
    }
}

