/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.template.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.tender.common.vo.GenerateTemplateVO;
import com.els.modules.tender.common.vo.ParseTemplateParamVO;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaExpertTaskService;
import com.els.modules.tender.template.entity.PurchaseTenderTemplateLibrary;
import com.els.modules.tender.template.enumerate.TemplateLibraryStatusEnum;
import com.els.modules.tender.template.service.PurchaseTenderTemplateLibraryService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u62db\u6807\u6a21\u677f\u5e93"})
@RestController
@RequestMapping(value={"/tender/template/purchaseTenderTemplateLibrary"})
public class PurchaseTenderTemplateLibraryController
extends BaseController<PurchaseTenderTemplateLibrary, PurchaseTenderTemplateLibraryService> {
    @Autowired
    private PurchaseTenderTemplateLibraryService purchaseTenderTemplateLibraryService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    PurchaseTenderProjectEvaExpertTaskService tenderProjectEvaExpertTaskService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#templateLibrary:list"})
    @PermissionDataView(businessType="tenderTemplateLibrary")
    public Result<?> queryPageList(PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTenderTemplateLibrary), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.purchaseTenderTemplateLibraryService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @PermissionDataView(businessType="tenderTemplateLibrary")
    public Result<?> queryTabsCount(PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTenderTemplateLibrary), (Map)req.getParameterMap());
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        List<CountVO> countVOList = this.purchaseTenderTemplateLibraryService.queryTabsCount(TenantContext.getTenant(), (QueryWrapper<PurchaseTenderTemplateLibrary>)queryWrapper);
        Map<String, Integer> countMap = countVOList.stream().collect(Collectors.toMap(o -> o.getValue(), o -> o.getTotal()));
        int totalCount = countVOList.stream().mapToInt(CountVO::getTotal).sum();
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, Integer.valueOf(totalCount)));
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("templateLibraryStatus", TenantContext.getTenant());
        if (CollectionUtil.isNotEmpty((Collection)dictDTOList)) {
            for (DictDTO status : dictDTOList) {
                Integer count = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
                result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), count));
            }
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u62db\u6807\u6a21\u677f\u5e93-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"tender#templateLibrary:add"})
    @PermissionDataOpt(businessType="tenderTemplateLibrary", beanClass=PurchaseTenderTemplateLibraryService.class)
    public Result<?> add(@RequestBody PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary) {
        this.purchaseTenderTemplateLibraryService.add(purchaseTenderTemplateLibrary);
        return Result.ok((Object)((Object)purchaseTenderTemplateLibrary));
    }

    @AutoLog(value="\u62db\u6807\u6a21\u677f\u5e93-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"tender#templateLibrary:edit"})
    @PermissionDataOpt(businessType="tenderTemplateLibrary", beanClass=PurchaseTenderTemplateLibraryService.class)
    public Result<?> edit(@RequestBody PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary) {
        this.purchaseTenderTemplateLibraryService.edit(purchaseTenderTemplateLibrary);
        return Result.ok((Object)((Object)purchaseTenderTemplateLibrary));
    }

    @ApiOperation(value="\u590d\u5236\u6a21\u677f", notes="\u590d\u5236\u6a21\u677f")
    @GetMapping(value={"/copyTemplate"})
    @RequiresPermissions(value={"tender#templateLibrary:edit"})
    public Result<?> copyTemplate(@RequestParam(name="id") String id) {
        PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary = this.purchaseTenderTemplateLibraryService.copyTemplate(id);
        return Result.ok((Object)((Object)purchaseTenderTemplateLibrary));
    }

    @AutoLog(value="\u62db\u6807\u6a21\u677f\u5e93-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tender#templateLibrary:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseTenderTemplateLibraryService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u62db\u6807\u6a21\u677f\u5e93-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"tender#templateLibrary:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseTenderTemplateLibraryService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#templateLibrary:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary = (PurchaseTenderTemplateLibrary)((Object)this.purchaseTenderTemplateLibraryService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)purchaseTenderTemplateLibrary));
    }

    @ApiOperation(value="\u6a21\u677f\u751f\u6210", notes="\u6a21\u677f\u751f\u6210")
    @PostMapping(value={"/generateTemplate"})
    @RequiresPermissions(value={"tender#templateLibrary:queryById"})
    public Result<?> generateTemplate(@RequestBody ParseTemplateParamVO parseTemplateParamVO) {
        GenerateTemplateVO generate = this.purchaseTenderTemplateLibraryService.generate(parseTemplateParamVO);
        return Result.ok((Object)generate);
    }

    @ApiOperation(value="\u6a21\u677f\u9884\u89c8", notes="\u6a21\u677f\u9884\u89c8")
    @PostMapping(value={"/templatePreview"})
    @RequiresPermissions(value={"tender#templateLibrary:queryById"})
    public Result<?> templatePreview(@RequestBody PurchaseTenderTemplateLibrary templateLibrary) {
        GenerateTemplateVO generate = this.purchaseTenderTemplateLibraryService.templatePreview(templateLibrary);
        return Result.ok((Object)generate);
    }

    @ApiOperation(value="\u516c\u544a\u67e5\u8be2\u6a21\u677f", notes="\u516c\u544a\u67e5\u8be2\u6a21\u677f")
    @GetMapping(value={"/queryTemplateLibrary"})
    @RequiresPermissions(value={"tender#templateLibrary:list"})
    public Result<?> queryTemplateLibrary(PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTenderTemplateLibrary), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        ((QueryWrapper)queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"status", (Object)TemplateLibraryStatusEnum.PUBLISH.getValue());
        IPage pageList = this.purchaseTenderTemplateLibraryService.page((IPage)page, (Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)pageList.getRecords())) {
            queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTenderTemplateLibrary), (Map)req.getParameterMap());
            ((QueryWrapper)queryWrapper.eq((Object)"els_account", (Object)"100000")).eq((Object)"status", (Object)TemplateLibraryStatusEnum.PUBLISH.getValue());
            pageList = this.purchaseTenderTemplateLibraryService.page((IPage)page, (Wrapper)queryWrapper);
        }
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u8bc4\u6807\u67e5\u8be2\u6a21\u677f", notes="\u8bc4\u6807\u67e5\u8be2\u6a21\u677f")
    @GetMapping(value={"/queryTemplateLibraryForEva"})
    @RequiresPermissions(value={"tender#templateLibrary:list"})
    public Result<?> queryTemplateLibraryForEva(PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTenderTemplateLibrary), (Map)req.getParameterMap());
        ((QueryWrapper)queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"status", (Object)TemplateLibraryStatusEnum.PUBLISH.getValue());
        List list = this.purchaseTenderTemplateLibraryService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTenderTemplateLibrary), (Map)req.getParameterMap());
            ((QueryWrapper)queryWrapper.eq((Object)"els_account", (Object)"100000")).eq((Object)"status", (Object)TemplateLibraryStatusEnum.PUBLISH.getValue());
            list = this.purchaseTenderTemplateLibraryService.list((Wrapper)queryWrapper);
        }
        return Result.ok((Object)list);
    }

    @AutoLog(value="\u62db\u6807\u6a21\u677f\u5e93-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"tender#templateLibrary:publish"})
    @PermissionDataOpt(businessType="tenderTemplateLibrary", beanClass=PurchaseTenderTemplateLibraryService.class)
    public Result<?> publish(@RequestBody PurchaseTenderTemplateLibrary purchaseTenderTemplateLibrary) {
        this.purchaseTenderTemplateLibraryService.publish(purchaseTenderTemplateLibrary);
        return Result.ok((Object)((Object)purchaseTenderTemplateLibrary));
    }
}

