/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.inquiry.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.modules.inquiry.qualification.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.service.PublicInquiryService;
import com.els.modules.inquiry.vo.PublicInquiryVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inquiry/public"})
@Api(tags={"\u516c\u5f00\u5bfb\u6e90"})
public class PublicInquiryController {
    @AutoLog(value="\u516c\u5f00\u5bfb\u6e90-\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3")
    @ApiOperation(value="\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3", notes="\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3")
    @GetMapping(value={"/noToken/queryById/{id}/{businessType}"})
    public Result<?> queryById(@PathVariable(value="id") String id, @PathVariable(value="businessType") String businessType) {
        PublicInquiryService inquiryService = SourceTypeEnum.getPublicService(businessType);
        return inquiryService.getPublicResult(id);
    }

    @AutoLog(value="\u516c\u5f00\u5bfb\u6e90-\u62a5\u540d\u63a5\u53e3")
    @ApiOperation(value="\u62a5\u540d\u63a5\u53e3", notes="\u62a5\u540d\u63a5\u53e3")
    @PostMapping(value={"/apply"})
    public Result<?> apply(@Valid @RequestBody PublicInquiryVO inquiryVO) {
        String businessType = inquiryVO.getBusinessType();
        PublicInquiryService inquiryService = SourceTypeEnum.getPublicService(businessType);
        inquiryService.apply(inquiryVO);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

