/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.bidding.entity.PurchaseBiddingEvaResult;
import com.els.modules.bidding.service.PurchaseBiddingEvaResultService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.vo.BiddingEvaResultVO;
import com.els.modules.bidding.vo.BiddingRegulationVO;
import com.els.modules.bidding.vo.PurchaseBiddingEvaResultVO;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8bc4\u6807\u7ed3\u679c"})
@RestController
@RequestMapping(value={"/bidding/purchaseBiddingEvaResult"})
public class PurchaseBiddingEvaResultController
extends BaseController<PurchaseBiddingEvaResult, PurchaseBiddingEvaResultService> {
    @Autowired
    private PurchaseBiddingEvaResultService purchaseBiddingEvaResultService;

    @ApiOperation(value="\u901a\u8fc7\u62db\u6807\u5355id\u67e5\u8be2\u8bc4\u6807\u660e\u7ec6", notes="\u901a\u8fc7\u62db\u6807\u5355id\u67e5\u8be2\u8bc4\u6807\u660e\u7ec6")
    @GetMapping(value={"/queryByBiddingId"})
    public Result<?> queryByBiddingId(@RequestParam(name="id") String id) {
        List<BiddingRegulationVO> resultList = this.purchaseBiddingEvaResultService.findEvaResult(id);
        PurchaseBiddingEvaResultVO evaResultVO = new PurchaseBiddingEvaResultVO();
        evaResultVO.setId(id);
        evaResultVO.setBiddingRegulationList(resultList);
        return Result.ok((Object)((Object)evaResultVO));
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c")
    @ApiOperation(value="\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c", notes="\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c")
    @PostMapping(value={"/saveEvaResult"})
    public Result<?> saveEvaResult(@RequestBody PurchaseBiddingEvaResultVO result) {
        this.purchaseBiddingEvaResultService.saveEvaResult(result.getId(), result.getBiddingRegulationList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c")
    @ApiOperation(value="\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c", notes="\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c")
    @PostMapping(value={"/submitEvaResult"})
    public Result<?> submitEvaResult(@RequestBody PurchaseBiddingHeadVO result) {
        this.purchaseBiddingEvaResultService.submitEvaResult(result.getId(), result.getBiddingSupplierVOList());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7\u62db\u6807\u5355id\u67e5\u8be2\u8bc4\u6807\u7ed3\u679c\u4e00\u89c8\u8868", notes="\u901a\u8fc7\u62db\u6807\u5355id\u67e5\u8be2\u8bc4\u6807\u7ed3\u679c\u4e00\u89c8\u8868")
    @GetMapping(value={"/queryEvaResultByBiddingId"})
    public Result<?> queryEvaResultByBiddingId(@RequestParam(name="id") String id) {
        List<BiddingEvaResultVO> resultList = this.purchaseBiddingEvaResultService.findEvaBidList(id);
        return Result.ok(resultList);
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c")
    @ApiOperation(value="\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c", notes="\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c")
    @PostMapping(value={"/saveBidEvaOfOffLine"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:saveBidEvaOfOffLine"})
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> saveBidEvaOfOffLine(@RequestBody PurchaseBiddingHeadVO result) {
        this.purchaseBiddingEvaResultService.saveBidEvaOfOffLine(result);
        return this.commonSuccessResult(3);
    }
}

