/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.forecast.entity.PurchaseForecastDetail;
import com.els.modules.forecast.service.PurchaseForecastDetailService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ForecastExcelImportServiceImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchaseForecastDetailService purchaseForecastDetailService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    @Resource
    private CoreInvokeSupplierRpcService coreInvokeSupplierRpcService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = dataList.size();
        ArrayList<String> materialNumberList = new ArrayList<String>();
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        String errorTitle = this.getErrorTitle();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            String materialNumber = (String)map.get("materialNumber");
            if (CharSequenceUtil.isBlank((CharSequence)materialNumber)) {
                String msg = I18nUtil.translate((String)"i18n_alert_SLAoxOLV_f1cdd68b", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, map);
                iterator.remove();
                continue;
            }
            materialNumberList.add(materialNumber);
            String toElsAccount = (String)map.get("toElsAccount");
            toElsAccountList.add(toElsAccount);
        }
        List<Object> materialList = new ArrayList();
        if (CollectionUtil.isNotEmpty(materialNumberList)) {
            materialList = this.purchaseMaterialHeadLocalRpcService.listByMaterialNumbers(materialNumberList);
        }
        Map materialMap = materialList.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity(), (newVal, oldVal) -> oldVal));
        Map<Object, Object> supplierMap = new HashMap();
        if (CollectionUtil.isNotEmpty(toElsAccountList)) {
            List supplierList = this.coreInvokeSupplierRpcService.selectSupplerList(TenantContext.getTenant(), toElsAccountList);
            supplierMap = supplierList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (newVal, oldVal) -> oldVal));
        }
        for (Map map : dataList) {
            PurchaseForecastDetail detail = (PurchaseForecastDetail)((Object)JSON.parseObject((String)JSON.toJSONString((Object)map), PurchaseForecastDetail.class));
            String materialNumber = detail.getMaterialNumber();
            PurchaseMaterialHeadDTO materialHead = (PurchaseMaterialHeadDTO)materialMap.get(materialNumber);
            if (null == materialHead) {
                String msg = I18nUtil.translate((String)"i18n_alert_SLAoWWWWWxMK_af53d65a", (String)"\u7269\u6599\u7f16\u7801\uff1a${0}\u4e0d\u5b58\u5728", (String[])new String[]{materialNumber});
                this.errorAdd(excelImportDTO, msg, map);
                continue;
            }
            detail.setMaterialName(materialHead.getMaterialName());
            detail.setMaterialDesc(materialHead.getMaterialDesc());
            detail.setMaterialGroup(materialHead.getMaterialGroup());
            detail.setMaterialGroupName(materialHead.getMaterialGroupName());
            detail.setMaterialCateCode(materialHead.getCateCode());
            detail.setMaterialCateName(materialHead.getCateName());
            String toElsAccount = detail.getToElsAccount();
            if (StrUtil.isNotBlank((CharSequence)toElsAccount)) {
                SupplierMasterDataDTO supplier = (SupplierMasterDataDTO)supplierMap.get(toElsAccount);
                if (null == supplier) {
                    String msg = I18nUtil.translate((String)"i18n_alert_RdXWWWWWxMK_4e14fa6c", (String)"\u4f9b\u5e94\u5546\uff1a${0}\u4e0d\u5b58\u5728", (String[])new String[]{toElsAccount});
                    this.errorAdd(excelImportDTO, msg, map);
                    continue;
                }
                detail.setSupplierName(supplier.getSupplierName());
                detail.setSupplierCode(supplier.getSupplierCode());
            }
            this.purchaseForecastDetailService.add(detail);
            if (!StrUtil.isNotBlank((CharSequence)toElsAccount)) continue;
            this.purchaseForecastDetailService.submit(detail);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

